#include "FlameMaster.h"
#include "PRF_HT.h"

void ComputeSteadyStates( Double *k, Double *c, Double *M )
{
// c[sC6H13X1XC6H13] (uncoupled) --------------------

		c[sC6H13X1XC6H13] = ( 0
			+ k[rH418b] * c[sC6H12X1XC6H12] * c[sH]
			+ k[rH436f] * c[sNXC7H16]
			) / ( CatchZero(
			+ k[rH418f]
			+ k[rH419]
			+ k[rH436b] * c[sCH3]
			) );


// c[sCXC8H17] (uncoupled) --------------------

		c[sCXC8H17] = ( 0
			+ k[rHLP451] * c[sIXC8H18] * c[sOH]
			+ k[rHLP454] * c[sIXC8H18] * c[sHO2]
			+ k[rHLP455] * c[sIXC8H18] * c[sCH3]
			+ k[rHLP457] * c[sIXC8H18] * c[sCH3O]
			+ k[rHLP458] * c[sIXC8H18] * c[sH]
			+ k[rHLP459] * c[sIXC8H18] * c[sO]
			+ k[rHLP460] * c[sIXC8H18] * c[sCH3O2]
			+ k[rHLP461f] * c[sIXC8H18] * c[sO2]
			) / ( CatchZero(
			+ k[rHLP447]
			+ k[rHLP448]
			+ k[rHLP449]
			+ k[rHLP450]
			+ k[rHLP461b] * c[sHO2]
			) );


// c[sC3H5O] (uncoupled) --------------------

		c[sC3H5O] = ( 0
			+ k[rH203] * c[sC3H5XAXC3H5] * c[sHO2]
			+ k[rH206] * c[sC3H5XAXC3H5] * c[sCH3O2]
			+ k[rH253b] * c[sC2H3CHO] * c[sH]
			) / ( CatchZero(
			+ k[rH253f]
			+ k[rH254]
			+ k[rH255] * c[sO2]
			) );


// c[sC2H3CO] (uncoupled) --------------------

		c[sC2H3CO] = ( 0
			+ k[rH246b] * c[sC2H3] * c[sCO]
			+ k[rH247] * c[sC2H3CHO] * c[sCH3O2]
			+ k[rH248] * c[sC2H3CHO] * c[sOH]
			+ k[rH249] * c[sC2H3CHO] * c[sHO2]
			+ k[rH250] * c[sC2H3CHO] * c[sCH3]
			+ k[rH251] * c[sC2H3CHO] * c[sO]
			+ k[rH252] * c[sC2H3CHO] * c[sH]
			) / ( CatchZero(
			+ k[rH246f]
			) );


// c[sHOCH2O] (uncoupled) --------------------

		c[sHOCH2O] = ( 0
			+ k[rH107b] * c[sHOCHO] * c[sH]
			+ k[rH108b] * c[sCH2O] * c[sOH]
			) / ( CatchZero(
			+ k[rH107f]
			+ k[rH108f]
			) );


// c[sC7H15X2XC7H15] (uncoupled) --------------------

		c[sC7H15X2XC7H15] = ( 0
			+ k[rHLP429b] * c[sC6H12X1XC6H12] * c[sCH3]
			+ k[rHLP434] * c[sNXC7H16] * c[sHO2]
			+ k[rHLP435] * c[sNXC7H16] * c[sCH3]
			+ k[rHLP437] * c[sNXC7H16] * c[sCH3O]
			+ k[rHLP438] * c[sNXC7H16] * c[sC2H5]
			+ k[rHLP439] * c[sNXC7H16] * c[sO]
			+ k[rHLP440f] * c[sNXC7H16] * c[sO2]
			+ k[rHLP441] * c[sNXC7H16] * c[sOH]
			+ k[rHLP442] * c[sNXC7H16] * c[sH]
			+ k[rHLP444] * c[sNXC7H16] * c[sCH3O2]
			) / ( CatchZero(
			+ k[rHLP425]
			+ k[rHLP426] * c[sH]
			+ k[rHLP427]
			+ k[rHLP428]
			+ k[rHLP429f]
			+ k[rHLP430]
			+ k[rHLP440b] * c[sHO2]
			) );


// c[sPXC4H9] (uncoupled) --------------------

		c[sPXC4H9] = ( 0
			+ k[rH318b] * c[sC2H5] * c[sC2H4]
			+ k[rH319b] * c[sC4H8X1XC4H8] * c[sH]
			+ k[rH344f] * c[sC4H10]
			+ k[rH345f] * c[sC4H10] * c[sO2]
			+ k[rH346f] * c[sC4H10] * c[sC3H5XAXC3H5]
			+ k[rH347f] * c[sC4H10] * c[sC2H5]
			+ k[rH348f] * c[sC4H10] * c[sC2H3]
			+ k[rH349f] * c[sC4H10] * c[sCH3]
			+ k[rH350f] * c[sC4H10] * c[sH]
			+ k[rH351f] * c[sC4H10] * c[sOH]
			+ k[rH352f] * c[sC4H10] * c[sO]
			+ k[rH353f] * c[sC4H10] * c[sHO2]
			+ k[rH354f] * c[sC4H10] * c[sCH3O]
			+ k[rH393f] * c[sPXC4H9O2]
			+ k[rH406] * c[sC5H10X1XC5H10] * c[sOH]
			+ k[rH419] * c[sC6H13X1XC6H13]
			+ k[rHLP427] * c[sC7H15X2XC7H15]
			+ k[rH443f] * c[sNXC7H16]
			) / ( CatchZero(
			+ k[rH318f]
			+ k[rH319f]
			+ k[rH344b] * c[sH]
			+ k[rH345b] * c[sHO2]
			+ k[rH346b] * c[sC3H6]
			+ k[rH347b] * c[sC2H6]
			+ k[rH348b] * c[sC2H4]
			+ k[rH349b] * c[sCH4]
			+ k[rH350b] * c[sH2]
			+ k[rH351b] * c[sH2O]
			+ k[rH352b] * c[sOH]
			+ k[rH353b] * c[sH2O2]
			+ k[rH354b] * c[sCH3OH]
			+ k[rH393b] * c[sO2]
			+ k[rH443b] * c[sNXC3H7]
			) );


// c[sIXC4H6OH] c[sIXC4H7O] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC4H6OH_denom1 = CatchZero( 0
			+ k[rH364] * c[sH]
			+ k[rH365] * c[sCH2O]
			+ k[rH366]
			+ k[rH367] * c[sHO2]
			+ k[rH368] * c[sHO2]
			+ k[rH374]
			);

	 Double IXC4H7O_denom1 = CatchZero( 0
			+ k[rH371]
			+ k[rH372]
			+ k[rH373]
			+ k[rH375] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double IXC4H6OH_ct1 = ( 0
			+ k[rH377] * c[sIXC4H7OH] * c[sHO2]
			+ k[rH378] * c[sIXC4H7OH] * c[sOH]
			);

	 Double IXC4H7O_ct1 = ( 0
			+ k[rH284] * c[sCH3O2] * c[sIXC4H7]
			+ k[rH290] * c[sIXC4H7] * c[sHO2]
			+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
			);


// IXC4H6OH ---------------------------------------

	 Double IXC4H6OH_denom2 = CatchZero( IXC4H6OH_denom1
			);

	 Double IXC4H6OH_ct2 = ( IXC4H6OH_ct1
			) / IXC4H6OH_denom2;



	 Double IXC4H6OH_IXC4H7O = ( 0 + k[rH373] 
			) / IXC4H6OH_denom2 ;



	 Double IXC4H6OH_IXC4H7O_coeff = ( 0 + k[rH374] 
			);


// IXC4H7O ---------------------------------------

	 Double IXC4H7O_denom2 = CatchZero( IXC4H7O_denom1
			- IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_IXC4H7O
			);

	 Double IXC4H7O_ct2 = ( IXC4H7O_ct1
			+ IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_ct2
			) / IXC4H7O_denom2;






// Reconstruction ------------------------------------

	c[sIXC4H7O] = ( IXC4H7O_ct2
			) ;

	c[sIXC4H6OH] = ( IXC4H6OH_ct2
			+ IXC4H6OH_IXC4H7O * c[sIXC4H7O]
			) ;

// c[sIC4H8O2HXTXC4H9O2] (uncoupled) --------------------

		c[sIC4H8O2HXTXC4H9O2] = ( 0
			+ k[rHLP382f] * c[sIXC4H9O2]
			+ k[rHLP395b] * c[sIXC4H8] * c[sHO2]
			) / ( CatchZero(
			+ k[rHLP382b]
			+ k[rHLP394]
			+ k[rHLP395f]
			) );


// c[sNEOXC5H11] (uncoupled) --------------------

		c[sNEOXC5H11] = ( 0
			+ k[rH408b] * c[sIXC4H8] * c[sCH3]
			+ k[rHLP450] * c[sCXC8H17]
			+ k[rH456] * c[sIXC8H18]
			) / ( CatchZero(
			+ k[rH408f]
			) );


// c[sC2H5O] (uncoupled) --------------------

		c[sC2H5O] = ( 0
			+ k[rH138] * c[sCH3O2] * c[sC2H5]
			+ k[rH140] * c[sC2H5] * c[sHO2]
			+ k[rH175b] * c[sCH3CHO] * c[sH] * M[mM5]
			) / ( CatchZero(
			+ k[rH175f] * M[mM5]
			+ k[rH176] * c[sO2]
			+ k[rH177] * M[mM5]
			) );


// c[sC5H11X1XC5H11] (uncoupled) --------------------

		c[sC5H11X1XC5H11] = ( 0
			+ k[rHLP410b] * c[sH] * c[sC5H10X1XC5H10]
			+ k[rHLP411b] * c[sC3H6] * c[sC2H5]
			+ k[rHLP417] * c[sC6H12X1XC6H12] * c[sOH]
			+ k[rHLP425] * c[sC7H15X2XC7H15]
			+ k[rHLP445f] * c[sNXC7H16]
			) / ( CatchZero(
			+ k[rHLP409]
			+ k[rHLP410f]
			+ k[rHLP411f]
			+ k[rHLP445b] * c[sC2H5]
			) );


// c[sXXC7H13] (uncoupled) --------------------

		c[sXXC7H13] = ( 0
			+ k[rHLP423f] * c[sYXC7H14] * c[sOH]
			+ k[rHLP424f] * c[sYXC7H14] * c[sH]
			) / ( CatchZero(
			+ k[rHLP420] * c[sHO2]
			+ k[rHLP423b] * c[sH2O]
			+ k[rHLP424b] * c[sH2]
			) );


// c[sTC4H8O2HXIXC4H9O2] (uncoupled) --------------------

		c[sTC4H8O2HXIXC4H9O2] = ( 0
			+ k[rH389f] * c[sTXC4H9O2]
			+ k[rH391b] * c[sIXC4H8] * c[sHO2]
			) / ( CatchZero(
			+ k[rH389b]
			+ k[rH391f]
			) );


// c[sC3H5XTXC3H5] (uncoupled) --------------------

		c[sC3H5XTXC3H5] = ( 0
			+ k[rH212b] * c[sC3H4XAXH4C3] * c[sH]
			+ k[rH215b] * c[sC3H4XPXH4C3] * c[sH]
			+ k[rH221] * c[sC3H6] * c[sO]
			+ k[rH223] * c[sC3H6] * c[sOH]
			+ k[rH224f] * c[sC3H6] * c[sH]
			+ k[rH304] * c[sIXC4H8]
			+ k[rH355] * c[sIXC3H5CO]
			+ k[rH371] * c[sIXC4H7O]
			) / ( CatchZero(
			+ k[rH212f]
			+ k[rH213] * c[sO2]
			+ k[rH214] * c[sO2]
			+ k[rH215f]
			+ k[rH224b] * c[sH2]
			) );


// c[sC2H3O1X2XC2H3O] c[sCH3CO] c[sCH2CHO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double C2H3O1X2XC2H3O_denom1 = CatchZero( 0
			+ k[rH162f]
			+ k[rH163f]
			);

	 Double CH3CO_denom1 = CatchZero( 0
			+ k[rH163b]
			+ k[rH164] * c[sCH3]
			+ k[rH165f]
			);

	 Double CH2CHO_denom1 = CatchZero( 0
			+ k[rH160f]
			+ k[rH161] * c[sO2]
			+ k[rH162b]
			);


// Primary constant parts -----------------------

	 Double C2H3O1X2XC2H3O_ct1 = ( 0
			);

	 Double CH3CO_ct1 = ( 0
			+ k[rH165b] * c[sCO] * c[sCH3]
			+ k[rH167] * c[sCH3CHO] * c[sH]
			+ k[rH168] * c[sCH3CHO] * c[sO2]
			+ k[rH169] * c[sCH3CHO] * c[sO]
			+ k[rH170] * c[sCH3CHO] * c[sCH3]
			+ k[rH171] * c[sCH3O2] * c[sCH3CHO]
			+ k[rH173] * c[sCH3CHO] * c[sHO2]
			+ k[rH174] * c[sCH3CHO] * c[sOH]
			+ k[rH214] * c[sC3H5XTXC3H5] * c[sO2]
			+ k[rH264] * c[sCH3COCH3]
			+ k[rH296] * c[sC4H8X1XC4H8] * c[sOH]
			+ k[rH298] * c[sC4H8X1XC4H8] * c[sO]
			);

	 Double CH2CHO_ct1 = ( 0
			+ k[rH124] * c[sC2H3] * c[sO2]
			+ k[rH127] * c[sC2H4] * c[sO]
			+ k[rH160b] * c[sCH2CO] * c[sH]
			+ k[rH211] * c[sC3H5XAXC3H5] * c[sO2]
			);


// C2H3O1X2XC2H3O ---------------------------------------

	 Double C2H3O1X2XC2H3O_denom2 = CatchZero( C2H3O1X2XC2H3O_denom1
			);

	 Double C2H3O1X2XC2H3O_ct2 = ( C2H3O1X2XC2H3O_ct1
			) / C2H3O1X2XC2H3O_denom2;



	 Double C2H3O1X2XC2H3O_CH3CO = ( 0 + k[rH163b] 
			) / C2H3O1X2XC2H3O_denom2 ;

	 Double C2H3O1X2XC2H3O_CH2CHO = ( 0 + k[rH162b] 
			) / C2H3O1X2XC2H3O_denom2 ;



	 Double C2H3O1X2XC2H3O_CH3CO_coeff = ( 0 + k[rH163f] 
			);

	 Double C2H3O1X2XC2H3O_CH2CHO_coeff = ( 0 + k[rH162f] 
			);


// CH3CO ---------------------------------------

	 Double CH3CO_denom2 = CatchZero( CH3CO_denom1
			- C2H3O1X2XC2H3O_CH3CO_coeff * C2H3O1X2XC2H3O_CH3CO
			);

	 Double CH3CO_ct2 = ( CH3CO_ct1
			+ C2H3O1X2XC2H3O_CH3CO_coeff * C2H3O1X2XC2H3O_ct2
			) / CH3CO_denom2;



	 Double CH3CO_CH2CHO = ( 0 
			+ C2H3O1X2XC2H3O_CH3CO_coeff * C2H3O1X2XC2H3O_CH2CHO
			) / CH3CO_denom2 ;



	 Double CH3CO_CH2CHO_coeff = ( 0 
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_CH3CO
			);


// CH2CHO ---------------------------------------

	 Double CH2CHO_denom2 = CatchZero( CH2CHO_denom1
			- C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_CH2CHO
			- CH3CO_CH2CHO_coeff * CH3CO_CH2CHO
			);

	 Double CH2CHO_ct2 = ( CH2CHO_ct1
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_ct2
			+ CH3CO_CH2CHO_coeff * CH3CO_ct2
			) / CH2CHO_denom2;






// Reconstruction ------------------------------------

	c[sCH2CHO] = ( CH2CHO_ct2
			) ;

	c[sCH3CO] = ( CH3CO_ct2
			+ CH3CO_CH2CHO * c[sCH2CHO]
			) ;

	c[sC2H3O1X2XC2H3O] = ( C2H3O1X2XC2H3O_ct2
			+ C2H3O1X2XC2H3O_CH3CO * c[sCH3CO]
			+ C2H3O1X2XC2H3O_CH2CHO * c[sCH2CHO]
			) ;

// c[sXC7H13OXZXC7H13O] (uncoupled) --------------------

		c[sXC7H13OXZXC7H13O] = ( 0
			+ k[rHLP420] * c[sXXC7H13] * c[sHO2]
			) / ( CatchZero(
			+ k[rHLP446]
			) );


// c[sC4H7] (uncoupled) --------------------

		c[sC4H7] = ( 0
			+ k[rH283b] * c[sC4H6] * c[sH]
			+ k[rH294] * c[sC4H8X1XC4H8] * c[sH]
			+ k[rH299f] * c[sC4H8X1XC4H8] * c[sO2]
			+ k[rH300] * c[sC4H8X1XC4H8] * c[sOH]
			+ k[rH301] * c[sC4H8X1XC4H8] * c[sHO2]
			+ k[rH303] * c[sC4H8X1XC4H8] * c[sCH3]
			) / ( CatchZero(
			+ k[rH274] * c[sCH3]
			+ k[rH275] * c[sC3H5XAXC3H5]
			+ k[rH276] * c[sHO2]
			+ k[rH277] * c[sC2H5]
			+ k[rH278] * c[sCH3O2]
			+ k[rH279] * c[sH]
			+ k[rH280]
			+ k[rH281] * c[sO2]
			+ k[rH282] * c[sH]
			+ k[rH283f]
			+ k[rH299b] * c[sHO2]
			) );


// c[sC4H7O] (uncoupled) --------------------

		c[sC4H7O] = ( 0
			+ k[rH276] * c[sC4H7] * c[sHO2]
			+ k[rH278] * c[sC4H7] * c[sCH3O2]
			) / ( CatchZero(
			+ k[rH369]
			+ k[rH370]
			) );


// c[sCH2CCH2OH] (uncoupled) --------------------

		c[sCH2CCH2OH] = ( 0
			+ k[rH257b] * c[sC3H4XAXH4C3] * c[sOH]
			+ k[rH367] * c[sIXC4H6OH] * c[sHO2]
			+ k[rH379] * c[sIXC4H7OH]
			) / ( CatchZero(
			+ k[rH257f]
			+ k[rH258] * c[sO2]
			+ k[rH259]
			) );


// c[sCH2OH] (uncoupled) --------------------

		c[sCH2OH] = ( 0
			+ k[rH80b] * c[sH] * c[sCH2O]
			+ k[rH81b] * c[sCH2O] * c[sHO2]
			+ k[rH83] * c[sCH3OH] * c[sH]
			+ k[rH84] * c[sCH3OH]
			+ k[rH86] * c[sCH3OH] * c[sO]
			+ k[rH87] * c[sCH3OH] * c[sHO2]
			+ k[rH89f] * c[sCH3OH] * c[sOH]
			+ k[rH101] * c[sCH3OH] * c[sCH3O2]
			+ k[rH157] * c[sCH2CO] * c[sOH]
			+ k[rH258] * c[sCH2CCH2OH] * c[sO2]
			+ k[rH259] * c[sCH2CCH2OH]
			+ k[rH366] * c[sIXC4H6OH]
			) / ( CatchZero(
			+ k[rH80f]
			+ k[rH81f] * c[sO2]
			+ k[rH82] * c[sCH2O]
			+ k[rH89b] * c[sH2O]
			) );


// c[sC3H2] (uncoupled) --------------------

		c[sC3H2] = ( 0
			+ k[rH182] * c[sC3H3] * c[sH]
			+ k[rH185f] * c[sC3H3] * c[sOH]
			) / ( CatchZero(
			+ k[rH180] * c[sOH]
			+ k[rH181] * c[sO2]
			+ k[rH185b] * c[sH2O]
			) );


// c[sIXC4H9] (uncoupled) --------------------

		c[sIXC4H9] = ( 0
			+ k[rH316b] * c[sIXC4H8] * c[sH]
			+ k[rH317b] * c[sC3H6] * c[sCH3]
			+ k[rH325f] * c[sIXC4H10]
			+ k[rH327f] * c[sIXC4H10] * c[sH]
			+ k[rH329f] * c[sIXC4H10] * c[sCH3]
			+ k[rH331f] * c[sIXC4H10] * c[sOH]
			+ k[rH332f] * c[sIXC4H10] * c[sC2H5]
			+ k[rH334f] * c[sIXC4H10] * c[sHO2]
			+ k[rH337f] * c[sIXC4H10] * c[sO]
			+ k[rH338f] * c[sIXC4H10] * c[sCH3O]
			+ k[rH340f] * c[sIXC4H10] * c[sO2]
			+ k[rH383f] * c[sIXC4H9O2]
			+ k[rHLP449] * c[sCXC8H17]
			+ k[rH453] * c[sIXC8H18]
			) / ( CatchZero(
			+ k[rH316f]
			+ k[rH317f]
			+ k[rH325b] * c[sH]
			+ k[rH327b] * c[sH2]
			+ k[rH329b] * c[sCH4]
			+ k[rH331b] * c[sH2O]
			+ k[rH332b] * c[sC2H6]
			+ k[rH334b] * c[sH2O2]
			+ k[rH337b] * c[sOH]
			+ k[rH338b] * c[sCH3OH]
			+ k[rH340b] * c[sHO2]
			+ k[rH383b] * c[sO2]
			) );


// c[sC4H8OOH1X3XC4H9O2] (uncoupled) --------------------

		c[sC4H8OOH1X3XC4H9O2] = ( 0
			+ k[rH392f] * c[sPXC4H9O2]
			) / ( CatchZero(
			+ k[rH381]
			+ k[rH392b]
			) );


// c[sYXC7H15] (uncoupled) --------------------

		c[sYXC7H15] = ( 0
			+ k[rHLP432b] * c[sYXC7H14] * c[sH]
			+ k[rHLP452] * c[sIXC8H18]
			) / ( CatchZero(
			+ k[rHLP431]
			+ k[rHLP432f]
			+ k[rHLP433]
			) );


// c[sIXC3H7] (uncoupled) --------------------

		c[sIXC3H7] = ( 0
			+ k[rH228b] * c[sH] * c[sC3H6]
			+ k[rH234f] * c[sC3H8] * c[sO2]
			+ k[rH236f] * c[sH] * c[sC3H8]
			+ k[rH238f] * c[sC3H8] * c[sO]
			+ k[rH241f] * c[sC3H8] * c[sOH]
			+ k[rH242f] * c[sC3H8] * c[sHO2]
			+ k[rH244f] * c[sCH3] * c[sC3H8]
			+ k[rH265f] * c[sIXC3H7O2]
			+ k[rH311] * c[sIXC4H8] * c[sO]
			+ k[rH323f] * c[sIXC4H10]
			+ k[rH362] * c[sIXC3H6CO] * c[sOH]
			+ k[rH363] * c[sIXC3H6CO] * c[sH]
			+ k[rHLP421f] * c[sYXC7H14]
			+ k[rHLP433] * c[sYXC7H15]
			+ k[rHLP446] * c[sXC7H13OXZXC7H13O]
			+ k[rH456] * c[sIXC8H18]
			) / ( CatchZero(
			+ k[rH228f]
			+ k[rH229] * c[sO2]
			+ k[rH234b] * c[sHO2]
			+ k[rH236b] * c[sH2]
			+ k[rH238b] * c[sOH]
			+ k[rH241b] * c[sH2O]
			+ k[rH242b] * c[sH2O2]
			+ k[rH244b] * c[sCH4]
			+ k[rH265b] * c[sO2]
			+ k[rH323b] * c[sCH3]
			+ k[rHLP421b] * c[sIXC4H7]
			) );


// c[sTXC4H9] (uncoupled) --------------------

		c[sTXC4H9] = ( 0
			+ k[rH320b] * c[sH] * c[sIXC4H8]
			+ k[rH324f] * c[sIXC4H10]
			+ k[rH326f] * c[sIXC4H10] * c[sH]
			+ k[rH328f] * c[sIXC4H10] * c[sCH3]
			+ k[rH330f] * c[sIXC4H10] * c[sOH]
			+ k[rH333f] * c[sIXC4H10] * c[sC2H5]
			+ k[rH335f] * c[sIXC4H10] * c[sHO2]
			+ k[rH336f] * c[sIXC4H10] * c[sO]
			+ k[rH339f] * c[sIXC4H10] * c[sCH3O]
			+ k[rH341f] * c[sIXC4H10] * c[sO2]
			+ k[rH387f] * c[sTXC4H9O2]
			+ k[rHLP422f] * c[sYXC7H14]
			+ k[rHLP431] * c[sYXC7H15]
			+ k[rHLP447] * c[sCXC8H17]
			+ k[rH453] * c[sIXC8H18]
			) / ( CatchZero(
			+ k[rH320f]
			+ k[rH321] * c[sHO2]
			+ k[rH322] * c[sCH3O2]
			+ k[rH324b] * c[sH]
			+ k[rH326b] * c[sH2]
			+ k[rH328b] * c[sCH4]
			+ k[rH330b] * c[sH2O]
			+ k[rH333b] * c[sC2H6]
			+ k[rH335b] * c[sH2O2]
			+ k[rH336b] * c[sOH]
			+ k[rH339b] * c[sCH3OH]
			+ k[rH341b] * c[sHO2]
			+ k[rH387b] * c[sO2]
			+ k[rH390] * c[sTXC4H9O2]
			+ k[rHLP422b] * c[sC3H5XAXC3H5]
			) );


// c[sTXC4H9O] (uncoupled) --------------------

		c[sTXC4H9O] = ( 0
			+ k[rH321] * c[sTXC4H9] * c[sHO2]
			+ k[rH322] * c[sCH3O2] * c[sTXC4H9]
			+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
			+ k[rH385] * c[sTXC4H9O2] * c[sCH3]
			+ k[rH386] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
			+ k[rH388] * c[sTXC4H9O2] * c[sCH3O2]
			+ k[rH390] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9]
			) / ( CatchZero(
			+ k[rH380]
			) );


// c[sC2H] (uncoupled) --------------------

		c[sC2H] = ( 0
			+ k[rH120f] * c[sO] * c[sC2H2]
			+ k[rH121f] * c[sC2H2] * c[sOH]
			+ k[rH187] * c[sC3H3] * c[sO]
			+ k[rH199f] * c[sC3H4XPXH4C3]
			) / ( CatchZero(
			+ k[rH110] * c[sO]
			+ k[rH111] * c[sH] * M[mM5]
			+ k[rH112] * c[sO2]
			+ k[rH120b] * c[sOH]
			+ k[rH121b] * c[sH2O]
			+ k[rH199b] * c[sCH3]
			) );


// c[sCH2GSGXCH2] c[sCH] c[sHCCO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH2GSGXCH2_denom1 = CatchZero( 0
			+ k[rH29] * c[sO]
			+ k[rH30] * c[sOH]
			+ k[rH31f] * c[sH2]
			+ k[rH32f] * M[mM5]
			+ k[rH33] * c[sO2]
			+ k[rH34f] * c[sH]
			+ k[rH36b] * c[sH2O]
			+ k[rH39] * c[sCH3]
			+ k[rH56f] * c[sCH4]
			+ k[rH90] * c[sCO2]
			+ k[rH146] * c[sC2H6]
			+ k[rH149b] * c[sCO]
			+ k[rH153] * c[sCH2CO]
			);

	 Double CH_denom1 = CatchZero( 0
			+ k[rH21] * c[sO2]
			+ k[rH23b] * c[sH2O]
			+ k[rH25b] * c[sH2]
			+ k[rH34b] * c[sH2]
			+ k[rH54] * c[sCH4]
			);

	 Double HCCO_denom1 = CatchZero( 0
			+ k[rH148] * c[sO2]
			+ k[rH149f] * c[sH]
			+ k[rH150] * c[sOH]
			+ k[rH151] * c[sO]
			+ k[rH152b] * c[sH2O]
			+ k[rH158b] * c[sH2]
			);


// Primary constant parts -----------------------

	 Double CH2GSGXCH2_ct1 = ( 0
			+ k[rH31b] * c[sCH3] * c[sH]
			+ k[rH32b] * c[sCH2] * M[mM5]
			+ k[rH36f] * c[sCH3] * c[sOH]
			+ k[rH56b] * c[sCH3] * c[sCH3]
			);

	 Double CH_ct1 = ( 0
			+ k[rH23f] * c[sCH2] * c[sOH]
			+ k[rH25f] * c[sCH2] * c[sH]
			+ k[rH110] * c[sC2H] * c[sO]
			);

	 Double HCCO_ct1 = ( 0
			+ k[rH113] * c[sC2H2] * c[sO]
			+ k[rH114] * c[sC2H2] * c[sO2]
			+ k[rH152f] * c[sCH2CO] * c[sOH]
			+ k[rH155] * c[sCH2CO] * c[sO]
			+ k[rH158f] * c[sCH2CO] * c[sH]
			+ k[rH181] * c[sC3H2] * c[sO2]
			);


// CH2GSGXCH2 ---------------------------------------

	 Double CH2GSGXCH2_denom2 = CatchZero( CH2GSGXCH2_denom1
			);

	 Double CH2GSGXCH2_ct2 = ( CH2GSGXCH2_ct1
			) / CH2GSGXCH2_denom2;



	 Double CH2GSGXCH2_CH = ( 0 + k[rH34b]  * c[sH2]
			) / CH2GSGXCH2_denom2 ;

	 Double CH2GSGXCH2_HCCO = ( 0 + k[rH149f]  * c[sH]
			) / CH2GSGXCH2_denom2 ;



	 Double CH2GSGXCH2_CH_coeff = ( 0 + k[rH34f]  * c[sH]
			);

	 Double CH2GSGXCH2_HCCO_coeff = ( 0 + k[rH149b]  * c[sCO]
			);


// CH ---------------------------------------

	 Double CH_denom2 = CatchZero( CH_denom1
			- CH2GSGXCH2_CH_coeff * CH2GSGXCH2_CH
			);

	 Double CH_ct2 = ( CH_ct1
			+ CH2GSGXCH2_CH_coeff * CH2GSGXCH2_ct2
			) / CH_denom2;



	 Double CH_HCCO = ( 0 
			+ CH2GSGXCH2_CH_coeff * CH2GSGXCH2_HCCO
			) / CH_denom2 ;



	 Double CH_HCCO_coeff = ( 0 
			+ CH2GSGXCH2_HCCO_coeff * CH2GSGXCH2_CH
			);


// HCCO ---------------------------------------

	 Double HCCO_denom2 = CatchZero( HCCO_denom1
			- CH2GSGXCH2_HCCO_coeff * CH2GSGXCH2_HCCO
			- CH_HCCO_coeff * CH_HCCO
			);

	 Double HCCO_ct2 = ( HCCO_ct1
			+ CH2GSGXCH2_HCCO_coeff * CH2GSGXCH2_ct2
			+ CH_HCCO_coeff * CH_ct2
			) / HCCO_denom2;






// Reconstruction ------------------------------------

	c[sHCCO] = ( HCCO_ct2
			) ;

	c[sCH] = ( CH_ct2
			+ CH_HCCO * c[sHCCO]
			) ;

	c[sCH2GSGXCH2] = ( CH2GSGXCH2_ct2
			+ CH2GSGXCH2_CH * c[sCH]
			+ CH2GSGXCH2_HCCO * c[sHCCO]
			) ;

}

int SteadyStatesFunc( const VectorPtr /*x*/, VectorPtr fVec, void *object )
{
	int		speciesIn;
	Double	*c;
	Double	*k;
	Double	*M;
	Double	*f = fVec->vec;
	SteadyStateInfoPtr ssInfo = ( SteadyStateInfoPtr )object;
	ssInfo->GetSteadyStateInfo( &c, &k, &M, &speciesIn );

	f[sIXC3H7-speciesIn] = c[sIXC3H7] - (
		 k[rH228b] * c[sH] * c[sC3H6]
		+ k[rH234f] * c[sC3H8] * c[sO2]
		+ k[rH236f] * c[sH] * c[sC3H8]
		+ k[rH238f] * c[sC3H8] * c[sO]
		+ k[rH241f] * c[sC3H8] * c[sOH]
		+ k[rH242f] * c[sC3H8] * c[sHO2]
		+ k[rH244f] * c[sCH3] * c[sC3H8]
		+ k[rH265f] * c[sIXC3H7O2]
		+ k[rH311] * c[sIXC4H8] * c[sO]
		+ k[rH323f] * c[sIXC4H10]
		+ k[rH362] * c[sIXC3H6CO] * c[sOH]
		+ k[rH363] * c[sIXC3H6CO] * c[sH]
		+ k[rHLP421f] * c[sYXC7H14]
		+ k[rHLP433] * c[sYXC7H15]
		+ k[rHLP446] * c[sXC7H13OXZXC7H13O]
		+ k[rH456] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rH228f]
		+ k[rH229] * c[sO2]
		+ k[rH234b] * c[sHO2]
		+ k[rH236b] * c[sH2]
		+ k[rH238b] * c[sOH]
		+ k[rH241b] * c[sH2O]
		+ k[rH242b] * c[sH2O2]
		+ k[rH244b] * c[sCH4]
		+ k[rH265b] * c[sO2]
		+ k[rH323b] * c[sCH3]
		+ k[rHLP421b] * c[sIXC4H7] ) );

	f[sC6H13X1XC6H13-speciesIn] = c[sC6H13X1XC6H13] - (
		 k[rH418b] * c[sC6H12X1XC6H12] * c[sH]
		+ k[rH436f] * c[sNXC7H16] ) / ( CatchZero( 
		 k[rH418f]
		+ k[rH419]
		+ k[rH436b] * c[sCH3] ) );

	f[sC4H7O-speciesIn] = c[sC4H7O] - (
		 k[rH276] * c[sC4H7] * c[sHO2]
		+ k[rH278] * c[sC4H7] * c[sCH3O2] ) / ( CatchZero( 
		 k[rH369]
		+ k[rH370] ) );

	f[sXC7H13OXZXC7H13O-speciesIn] = c[sXC7H13OXZXC7H13O] - (
		 k[rHLP420] * c[sXXC7H13] * c[sHO2] ) / ( CatchZero( 
		 k[rHLP446] ) );

	f[sTXC4H9O-speciesIn] = c[sTXC4H9O] - (
		 k[rH321] * c[sTXC4H9] * c[sHO2]
		+ k[rH322] * c[sCH3O2] * c[sTXC4H9]
		+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
		+ k[rH385] * c[sTXC4H9O2] * c[sCH3]
		+ k[rH386] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
		+ k[rH388] * c[sTXC4H9O2] * c[sCH3O2]
		+ k[rH390] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9] ) / ( CatchZero( 
		 k[rH380] ) );

	f[sTC4H8O2HXIXC4H9O2-speciesIn] = c[sTC4H8O2HXIXC4H9O2] - (
		 k[rH389f] * c[sTXC4H9O2]
		+ k[rH391b] * c[sIXC4H8] * c[sHO2] ) / ( CatchZero( 
		 k[rH389b]
		+ k[rH391f] ) );

	f[sIC4H8O2HXTXC4H9O2-speciesIn] = c[sIC4H8O2HXTXC4H9O2] - (
		 k[rHLP382f] * c[sIXC4H9O2]
		+ k[rHLP395b] * c[sIXC4H8] * c[sHO2] ) / ( CatchZero( 
		 k[rHLP382b]
		+ k[rHLP394]
		+ k[rHLP395f] ) );

	f[sIXC4H7O-speciesIn] = c[sIXC4H7O] - (
		 k[rH284] * c[sCH3O2] * c[sIXC4H7]
		+ k[rH290] * c[sIXC4H7] * c[sHO2]
		+ k[rH374] * c[sIXC4H6OH]
		+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7] ) / ( CatchZero( 
		 k[rH371]
		+ k[rH372]
		+ k[rH373]
		+ k[rH375] * c[sO2] ) );

	f[sYXC7H15-speciesIn] = c[sYXC7H15] - (
		 k[rHLP432b] * c[sYXC7H14] * c[sH]
		+ k[rHLP452] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rHLP431]
		+ k[rHLP432f]
		+ k[rHLP433] ) );

	f[sNEOXC5H11-speciesIn] = c[sNEOXC5H11] - (
		 k[rH408b] * c[sIXC4H8] * c[sCH3]
		+ k[rHLP450] * c[sCXC8H17]
		+ k[rH456] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rH408f] ) );

	f[sIXC4H9-speciesIn] = c[sIXC4H9] - (
		 k[rH316b] * c[sIXC4H8] * c[sH]
		+ k[rH317b] * c[sC3H6] * c[sCH3]
		+ k[rH325f] * c[sIXC4H10]
		+ k[rH327f] * c[sIXC4H10] * c[sH]
		+ k[rH329f] * c[sIXC4H10] * c[sCH3]
		+ k[rH331f] * c[sIXC4H10] * c[sOH]
		+ k[rH332f] * c[sIXC4H10] * c[sC2H5]
		+ k[rH334f] * c[sIXC4H10] * c[sHO2]
		+ k[rH337f] * c[sIXC4H10] * c[sO]
		+ k[rH338f] * c[sIXC4H10] * c[sCH3O]
		+ k[rH340f] * c[sIXC4H10] * c[sO2]
		+ k[rH383f] * c[sIXC4H9O2]
		+ k[rHLP449] * c[sCXC8H17]
		+ k[rH453] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rH316f]
		+ k[rH317f]
		+ k[rH325b] * c[sH]
		+ k[rH327b] * c[sH2]
		+ k[rH329b] * c[sCH4]
		+ k[rH331b] * c[sH2O]
		+ k[rH332b] * c[sC2H6]
		+ k[rH334b] * c[sH2O2]
		+ k[rH337b] * c[sOH]
		+ k[rH338b] * c[sCH3OH]
		+ k[rH340b] * c[sHO2]
		+ k[rH383b] * c[sO2] ) );

	f[sCXC8H17-speciesIn] = c[sCXC8H17] - (
		 k[rHLP451] * c[sIXC8H18] * c[sOH]
		+ k[rHLP454] * c[sIXC8H18] * c[sHO2]
		+ k[rHLP455] * c[sIXC8H18] * c[sCH3]
		+ k[rHLP457] * c[sIXC8H18] * c[sCH3O]
		+ k[rHLP458] * c[sIXC8H18] * c[sH]
		+ k[rHLP459] * c[sIXC8H18] * c[sO]
		+ k[rHLP460] * c[sIXC8H18] * c[sCH3O2]
		+ k[rHLP461f] * c[sIXC8H18] * c[sO2] ) / ( CatchZero( 
		 k[rHLP447]
		+ k[rHLP448]
		+ k[rHLP449]
		+ k[rHLP450]
		+ k[rHLP461b] * c[sHO2] ) );

	f[sC4H7-speciesIn] = c[sC4H7] - (
		 k[rH283b] * c[sC4H6] * c[sH]
		+ k[rH294] * c[sC4H8X1XC4H8] * c[sH]
		+ k[rH299f] * c[sC4H8X1XC4H8] * c[sO2]
		+ k[rH300] * c[sC4H8X1XC4H8] * c[sOH]
		+ k[rH301] * c[sC4H8X1XC4H8] * c[sHO2]
		+ k[rH303] * c[sC4H8X1XC4H8] * c[sCH3] ) / ( CatchZero( 
		 k[rH274] * c[sCH3]
		+ k[rH275] * c[sC3H5XAXC3H5]
		+ k[rH276] * c[sHO2]
		+ k[rH277] * c[sC2H5]
		+ k[rH278] * c[sCH3O2]
		+ k[rH279] * c[sH]
		+ k[rH280]
		+ k[rH281] * c[sO2]
		+ k[rH282] * c[sH]
		+ k[rH283f]
		+ k[rH299b] * c[sHO2] ) );

	f[sTXC4H9-speciesIn] = c[sTXC4H9] - (
		 k[rH320b] * c[sH] * c[sIXC4H8]
		+ k[rH324f] * c[sIXC4H10]
		+ k[rH326f] * c[sIXC4H10] * c[sH]
		+ k[rH328f] * c[sIXC4H10] * c[sCH3]
		+ k[rH330f] * c[sIXC4H10] * c[sOH]
		+ k[rH333f] * c[sIXC4H10] * c[sC2H5]
		+ k[rH335f] * c[sIXC4H10] * c[sHO2]
		+ k[rH336f] * c[sIXC4H10] * c[sO]
		+ k[rH339f] * c[sIXC4H10] * c[sCH3O]
		+ k[rH341f] * c[sIXC4H10] * c[sO2]
		+ k[rH387f] * c[sTXC4H9O2]
		+ k[rHLP422f] * c[sYXC7H14]
		+ k[rHLP431] * c[sYXC7H15]
		+ k[rHLP447] * c[sCXC8H17]
		+ k[rH453] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rH320f]
		+ k[rH321] * c[sHO2]
		+ k[rH322] * c[sCH3O2]
		+ k[rH324b] * c[sH]
		+ k[rH326b] * c[sH2]
		+ k[rH328b] * c[sCH4]
		+ k[rH330b] * c[sH2O]
		+ k[rH333b] * c[sC2H6]
		+ k[rH335b] * c[sH2O2]
		+ k[rH336b] * c[sOH]
		+ k[rH339b] * c[sCH3OH]
		+ k[rH341b] * c[sHO2]
		+ k[rH387b] * c[sO2]
		+ k[rH390] * c[sTXC4H9O2]
		+ k[rHLP422b] * c[sC3H5XAXC3H5] ) );

	f[sIXC4H6OH-speciesIn] = c[sIXC4H6OH] - (
		 k[rH373] * c[sIXC4H7O]
		+ k[rH377] * c[sIXC4H7OH] * c[sHO2]
		+ k[rH378] * c[sIXC4H7OH] * c[sOH] ) / ( CatchZero( 
		 k[rH364] * c[sH]
		+ k[rH365] * c[sCH2O]
		+ k[rH366]
		+ k[rH367] * c[sHO2]
		+ k[rH368] * c[sHO2]
		+ k[rH374] ) );

	f[sXXC7H13-speciesIn] = c[sXXC7H13] - (
		 k[rHLP423f] * c[sYXC7H14] * c[sOH]
		+ k[rHLP424f] * c[sYXC7H14] * c[sH] ) / ( CatchZero( 
		 k[rHLP420] * c[sHO2]
		+ k[rHLP423b] * c[sH2O]
		+ k[rHLP424b] * c[sH2] ) );

	f[sC4H8OOH1X3XC4H9O2-speciesIn] = c[sC4H8OOH1X3XC4H9O2] - (
		 k[rH392f] * c[sPXC4H9O2] ) / ( CatchZero( 
		 k[rH381]
		+ k[rH392b] ) );

	f[sC5H11X1XC5H11-speciesIn] = c[sC5H11X1XC5H11] - (
		 k[rHLP410b] * c[sH] * c[sC5H10X1XC5H10]
		+ k[rHLP411b] * c[sC3H6] * c[sC2H5]
		+ k[rHLP417] * c[sC6H12X1XC6H12] * c[sOH]
		+ k[rHLP425] * c[sC7H15X2XC7H15]
		+ k[rHLP445f] * c[sNXC7H16] ) / ( CatchZero( 
		 k[rHLP409]
		+ k[rHLP410f]
		+ k[rHLP411f]
		+ k[rHLP445b] * c[sC2H5] ) );

	f[sC2H3O1X2XC2H3O-speciesIn] = c[sC2H3O1X2XC2H3O] - (
		 k[rH162b] * c[sCH2CHO]
		+ k[rH163b] * c[sCH3CO] ) / ( CatchZero( 
		 k[rH162f]
		+ k[rH163f] ) );

	f[sC3H5O-speciesIn] = c[sC3H5O] - (
		 k[rH203] * c[sC3H5XAXC3H5] * c[sHO2]
		+ k[rH206] * c[sC3H5XAXC3H5] * c[sCH3O2]
		+ k[rH253b] * c[sC2H3CHO] * c[sH] ) / ( CatchZero( 
		 k[rH253f]
		+ k[rH254]
		+ k[rH255] * c[sO2] ) );

	f[sCH2CCH2OH-speciesIn] = c[sCH2CCH2OH] - (
		 k[rH257b] * c[sC3H4XAXH4C3] * c[sOH]
		+ k[rH367] * c[sIXC4H6OH] * c[sHO2]
		+ k[rH379] * c[sIXC4H7OH] ) / ( CatchZero( 
		 k[rH257f]
		+ k[rH258] * c[sO2]
		+ k[rH259] ) );

	f[sCH3CO-speciesIn] = c[sCH3CO] - (
		 k[rH163f] * c[sC2H3O1X2XC2H3O]
		+ k[rH165b] * c[sCO] * c[sCH3]
		+ k[rH167] * c[sCH3CHO] * c[sH]
		+ k[rH168] * c[sCH3CHO] * c[sO2]
		+ k[rH169] * c[sCH3CHO] * c[sO]
		+ k[rH170] * c[sCH3CHO] * c[sCH3]
		+ k[rH171] * c[sCH3O2] * c[sCH3CHO]
		+ k[rH173] * c[sCH3CHO] * c[sHO2]
		+ k[rH174] * c[sCH3CHO] * c[sOH]
		+ k[rH214] * c[sC3H5XTXC3H5] * c[sO2]
		+ k[rH264] * c[sCH3COCH3]
		+ k[rH296] * c[sC4H8X1XC4H8] * c[sOH]
		+ k[rH298] * c[sC4H8X1XC4H8] * c[sO] ) / ( CatchZero( 
		 k[rH163b]
		+ k[rH164] * c[sCH3]
		+ k[rH165f] ) );

	f[sC3H2-speciesIn] = c[sC3H2] - (
		 k[rH182] * c[sC3H3] * c[sH]
		+ k[rH185f] * c[sC3H3] * c[sOH] ) / ( CatchZero( 
		 k[rH180] * c[sOH]
		+ k[rH181] * c[sO2]
		+ k[rH185b] * c[sH2O] ) );

	f[sC2H3CO-speciesIn] = c[sC2H3CO] - (
		 k[rH246b] * c[sC2H3] * c[sCO]
		+ k[rH247] * c[sC2H3CHO] * c[sCH3O2]
		+ k[rH248] * c[sC2H3CHO] * c[sOH]
		+ k[rH249] * c[sC2H3CHO] * c[sHO2]
		+ k[rH250] * c[sC2H3CHO] * c[sCH3]
		+ k[rH251] * c[sC2H3CHO] * c[sO]
		+ k[rH252] * c[sC2H3CHO] * c[sH] ) / ( CatchZero( 
		 k[rH246f] ) );

	f[sCH2CHO-speciesIn] = c[sCH2CHO] - (
		 k[rH124] * c[sC2H3] * c[sO2]
		+ k[rH127] * c[sC2H4] * c[sO]
		+ k[rH160b] * c[sCH2CO] * c[sH]
		+ k[rH162f] * c[sC2H3O1X2XC2H3O]
		+ k[rH211] * c[sC3H5XAXC3H5] * c[sO2] ) / ( CatchZero( 
		 k[rH160f]
		+ k[rH161] * c[sO2]
		+ k[rH162b] ) );

	f[sC2H5O-speciesIn] = c[sC2H5O] - (
		 k[rH138] * c[sCH3O2] * c[sC2H5]
		+ k[rH140] * c[sC2H5] * c[sHO2]
		+ k[rH175b] * c[sCH3CHO] * c[sH] * M[mM5] ) / ( CatchZero( 
		 k[rH175f] * M[mM5]
		+ k[rH176] * c[sO2]
		+ k[rH177] * M[mM5] ) );

	f[sCH2GSGXCH2-speciesIn] = c[sCH2GSGXCH2] - (
		 k[rH31b] * c[sCH3] * c[sH]
		+ k[rH32b] * c[sCH2] * M[mM5]
		+ k[rH34b] * c[sCH] * c[sH2]
		+ k[rH36f] * c[sCH3] * c[sOH]
		+ k[rH56b] * c[sCH3] * c[sCH3]
		+ k[rH149f] * c[sHCCO] * c[sH] ) / ( CatchZero( 
		 k[rH29] * c[sO]
		+ k[rH30] * c[sOH]
		+ k[rH31f] * c[sH2]
		+ k[rH32f] * M[mM5]
		+ k[rH33] * c[sO2]
		+ k[rH34f] * c[sH]
		+ k[rH36b] * c[sH2O]
		+ k[rH39] * c[sCH3]
		+ k[rH56f] * c[sCH4]
		+ k[rH90] * c[sCO2]
		+ k[rH146] * c[sC2H6]
		+ k[rH149b] * c[sCO]
		+ k[rH153] * c[sCH2CO] ) );

	f[sC2H-speciesIn] = c[sC2H] - (
		 k[rH120f] * c[sO] * c[sC2H2]
		+ k[rH121f] * c[sC2H2] * c[sOH]
		+ k[rH187] * c[sC3H3] * c[sO]
		+ k[rH199f] * c[sC3H4XPXH4C3] ) / ( CatchZero( 
		 k[rH110] * c[sO]
		+ k[rH111] * c[sH] * M[mM5]
		+ k[rH112] * c[sO2]
		+ k[rH120b] * c[sOH]
		+ k[rH121b] * c[sH2O]
		+ k[rH199b] * c[sCH3] ) );

	f[sCH-speciesIn] = c[sCH] - (
		 k[rH23f] * c[sCH2] * c[sOH]
		+ k[rH25f] * c[sCH2] * c[sH]
		+ k[rH34f] * c[sCH2GSGXCH2] * c[sH]
		+ k[rH110] * c[sC2H] * c[sO] ) / ( CatchZero( 
		 k[rH21] * c[sO2]
		+ k[rH23b] * c[sH2O]
		+ k[rH25b] * c[sH2]
		+ k[rH34b] * c[sH2]
		+ k[rH54] * c[sCH4] ) );

	f[sPXC4H9-speciesIn] = c[sPXC4H9] - (
		 k[rH318b] * c[sC2H5] * c[sC2H4]
		+ k[rH319b] * c[sC4H8X1XC4H8] * c[sH]
		+ k[rH344f] * c[sC4H10]
		+ k[rH345f] * c[sC4H10] * c[sO2]
		+ k[rH346f] * c[sC4H10] * c[sC3H5XAXC3H5]
		+ k[rH347f] * c[sC4H10] * c[sC2H5]
		+ k[rH348f] * c[sC4H10] * c[sC2H3]
		+ k[rH349f] * c[sC4H10] * c[sCH3]
		+ k[rH350f] * c[sC4H10] * c[sH]
		+ k[rH351f] * c[sC4H10] * c[sOH]
		+ k[rH352f] * c[sC4H10] * c[sO]
		+ k[rH353f] * c[sC4H10] * c[sHO2]
		+ k[rH354f] * c[sC4H10] * c[sCH3O]
		+ k[rH393f] * c[sPXC4H9O2]
		+ k[rH406] * c[sC5H10X1XC5H10] * c[sOH]
		+ k[rH419] * c[sC6H13X1XC6H13]
		+ k[rHLP427] * c[sC7H15X2XC7H15]
		+ k[rH443f] * c[sNXC7H16] ) / ( CatchZero( 
		 k[rH318f]
		+ k[rH319f]
		+ k[rH344b] * c[sH]
		+ k[rH345b] * c[sHO2]
		+ k[rH346b] * c[sC3H6]
		+ k[rH347b] * c[sC2H6]
		+ k[rH348b] * c[sC2H4]
		+ k[rH349b] * c[sCH4]
		+ k[rH350b] * c[sH2]
		+ k[rH351b] * c[sH2O]
		+ k[rH352b] * c[sOH]
		+ k[rH353b] * c[sH2O2]
		+ k[rH354b] * c[sCH3OH]
		+ k[rH393b] * c[sO2]
		+ k[rH443b] * c[sNXC3H7] ) );

	f[sC7H15X2XC7H15-speciesIn] = c[sC7H15X2XC7H15] - (
		 k[rHLP429b] * c[sC6H12X1XC6H12] * c[sCH3]
		+ k[rHLP434] * c[sNXC7H16] * c[sHO2]
		+ k[rHLP435] * c[sNXC7H16] * c[sCH3]
		+ k[rHLP437] * c[sNXC7H16] * c[sCH3O]
		+ k[rHLP438] * c[sNXC7H16] * c[sC2H5]
		+ k[rHLP439] * c[sNXC7H16] * c[sO]
		+ k[rHLP440f] * c[sNXC7H16] * c[sO2]
		+ k[rHLP441] * c[sNXC7H16] * c[sOH]
		+ k[rHLP442] * c[sNXC7H16] * c[sH]
		+ k[rHLP444] * c[sNXC7H16] * c[sCH3O2] ) / ( CatchZero( 
		 k[rHLP425]
		+ k[rHLP426] * c[sH]
		+ k[rHLP427]
		+ k[rHLP428]
		+ k[rHLP429f]
		+ k[rHLP430]
		+ k[rHLP440b] * c[sHO2] ) );

	f[sHCCO-speciesIn] = c[sHCCO] - (
		 k[rH113] * c[sC2H2] * c[sO]
		+ k[rH114] * c[sC2H2] * c[sO2]
		+ k[rH149b] * c[sCH2GSGXCH2] * c[sCO]
		+ k[rH152f] * c[sCH2CO] * c[sOH]
		+ k[rH155] * c[sCH2CO] * c[sO]
		+ k[rH158f] * c[sCH2CO] * c[sH]
		+ k[rH181] * c[sC3H2] * c[sO2] ) / ( CatchZero( 
		 k[rH148] * c[sO2]
		+ k[rH149f] * c[sH]
		+ k[rH150] * c[sOH]
		+ k[rH151] * c[sO]
		+ k[rH152b] * c[sH2O]
		+ k[rH158b] * c[sH2] ) );

	f[sHOCH2O-speciesIn] = c[sHOCH2O] - (
		 k[rH107b] * c[sHOCHO] * c[sH]
		+ k[rH108b] * c[sCH2O] * c[sOH] ) / ( CatchZero( 
		 k[rH107f]
		+ k[rH108f] ) );

	f[sC3H5XTXC3H5-speciesIn] = c[sC3H5XTXC3H5] - (
		 k[rH212b] * c[sC3H4XAXH4C3] * c[sH]
		+ k[rH215b] * c[sC3H4XPXH4C3] * c[sH]
		+ k[rH221] * c[sC3H6] * c[sO]
		+ k[rH223] * c[sC3H6] * c[sOH]
		+ k[rH224f] * c[sC3H6] * c[sH]
		+ k[rH304] * c[sIXC4H8]
		+ k[rH355] * c[sIXC3H5CO]
		+ k[rH371] * c[sIXC4H7O] ) / ( CatchZero( 
		 k[rH212f]
		+ k[rH213] * c[sO2]
		+ k[rH214] * c[sO2]
		+ k[rH215f]
		+ k[rH224b] * c[sH2] ) );

	f[sCH2OH-speciesIn] = c[sCH2OH] - (
		 k[rH80b] * c[sH] * c[sCH2O]
		+ k[rH81b] * c[sCH2O] * c[sHO2]
		+ k[rH83] * c[sCH3OH] * c[sH]
		+ k[rH84] * c[sCH3OH]
		+ k[rH86] * c[sCH3OH] * c[sO]
		+ k[rH87] * c[sCH3OH] * c[sHO2]
		+ k[rH89f] * c[sCH3OH] * c[sOH]
		+ k[rH101] * c[sCH3OH] * c[sCH3O2]
		+ k[rH157] * c[sCH2CO] * c[sOH]
		+ k[rH258] * c[sCH2CCH2OH] * c[sO2]
		+ k[rH259] * c[sCH2CCH2OH]
		+ k[rH366] * c[sIXC4H6OH] ) / ( CatchZero( 
		 k[rH80f]
		+ k[rH81f] * c[sO2]
		+ k[rH82] * c[sCH2O]
		+ k[rH89b] * c[sH2O] ) );

	return 0;
}

#ifndef MECHANISM
#define MECHANISM ""
#endif

void TReaction::CheckSteadyStatesMech( const char *mechName )
{
	char	*name = new char[strlen( MECHANISM ) + 5];
	sprintf( name, "/%s.pre", MECHANISM );
	if ( strstr( mechName, name ) == 0 ) {
		cerr << "#error: program linked with mechanism " << MECHANISM << ".mech"
					<< ", input mechanism is " << mechName << NEWL;
		exit(2);
	}
	else {
		cerr << "use reduced kinetics " << MECHANISM << NEWL;
	}
}
