#include "FlameMaster.h"
#include "PRF_LT.h"

void ComputeSteadyStates( Double *k, Double *c, Double *M )
{
// c[sAC8H16OOHXBXC8H17O2] (uncoupled) --------------------

		c[sAC8H16OOHXBXC8H17O2] = ( 0
			+ k[rLLP309] * c[sBXC8H17O2]
			+ k[rLLP332f] * c[sBC8H16OOHXCO2XC8H17O4]
			) / ( CatchZero(
			+ k[rLLP315]
			+ k[rLLP316]
			+ k[rLLP317]
			+ k[rLLP318]
			+ k[rLLP332b] * c[sO2]
			) );


// c[sSXC4H9] (uncoupled) --------------------

		c[sSXC4H9] = ( 0
			+ k[rL76b] * c[sC3H6] * c[sCH3]
			+ k[rL77b] * c[sC4H8X1XC4H8] * c[sH]
			) / ( CatchZero(
			+ k[rL76f]
			+ k[rL77f]
			) );


// c[sCXC8H17] (uncoupled) --------------------

		c[sCXC8H17] = ( 0
			+ k[rHLP451] * c[sIXC8H18] * c[sOH]
			+ k[rHLP454] * c[sIXC8H18] * c[sHO2]
			+ k[rHLP455] * c[sIXC8H18] * c[sCH3]
			+ k[rHLP457] * c[sIXC8H18] * c[sCH3O]
			+ k[rHLP458] * c[sIXC8H18] * c[sH]
			+ k[rHLP459] * c[sIXC8H18] * c[sO]
			+ k[rHLP460] * c[sIXC8H18] * c[sCH3O2]
			+ k[rHLP461f] * c[sIXC8H18] * c[sO2]
			+ k[rLLP296b] * c[sJXC8H16] * c[sH]
			+ k[rLLP308] * c[sIXC8H18] * c[sBXC8H17O2]
			+ k[rLLP310f] * c[sBXC8H17O2]
			) / ( CatchZero(
			+ k[rHLP447]
			+ k[rHLP448]
			+ k[rHLP449]
			+ k[rHLP450]
			+ k[rHLP461b] * c[sHO2]
			+ k[rLLP294] * c[sCH3O2]
			+ k[rLLP295] * c[sHO2]
			+ k[rLLP296f]
			+ k[rLLP310b] * c[sO2]
			+ k[rLLP313] * c[sBXC8H17O2]
			) );


// c[sC2H5O2] c[sC2H4O2H] (coupled)  --------------------

// Primary denominators-----------------------

	 Double C2H5O2_denom1 = CatchZero( 0
			+ k[rH178f]
			+ k[rH179f]
			+ k[rL9] * c[sCH2O]
			+ k[rL10f]
			+ k[rL11] * c[sHO2]
			+ k[rL12] * c[sC2H4]
			+ k[rL40] * c[sC2H5CHO]
			+ k[rL52] * c[sNXC3H7O2]
			+ k[rL131] * c[sPXC4H9O2]
			);

	 Double C2H4O2H_denom1 = CatchZero( 0
			+ k[rL8f]
			+ k[rL10b]
			);


// Primary constant parts -----------------------

	 Double C2H5O2_ct1 = ( 0
			+ k[rH178b] * c[sC2H5] * c[sO2]
			+ k[rH179b] * c[sC2H4] * c[sHO2]
			);

	 Double C2H4O2H_ct1 = ( 0
			+ k[rL4] * c[sC2H5] * c[sO2]
			+ k[rL8b] * c[sC2H4] * c[sHO2]
			);


// C2H5O2 ---------------------------------------

	 Double C2H5O2_denom2 = CatchZero( C2H5O2_denom1
			);

	 Double C2H5O2_ct2 = ( C2H5O2_ct1
			) / C2H5O2_denom2;



	 Double C2H5O2_C2H4O2H = ( 0 + k[rL10b] 
			) / C2H5O2_denom2 ;



	 Double C2H5O2_C2H4O2H_coeff = ( 0 + k[rL10f] 
			);


// C2H4O2H ---------------------------------------

	 Double C2H4O2H_denom2 = CatchZero( C2H4O2H_denom1
			- C2H5O2_C2H4O2H_coeff * C2H5O2_C2H4O2H
			);

	 Double C2H4O2H_ct2 = ( C2H4O2H_ct1
			+ C2H5O2_C2H4O2H_coeff * C2H5O2_ct2
			) / C2H4O2H_denom2;






// Reconstruction ------------------------------------

	c[sC2H4O2H] = ( C2H4O2H_ct2
			) ;

	c[sC2H5O2] = ( C2H5O2_ct2
			+ C2H5O2_C2H4O2H * c[sC2H4O2H]
			) ;

// c[sHOCH2O] (uncoupled) --------------------

		c[sHOCH2O] = ( 0
			+ k[rH107b] * c[sHOCHO] * c[sH]
			+ k[rH108b] * c[sCH2O] * c[sOH]
			) / ( CatchZero(
			+ k[rH107f]
			+ k[rH108f]
			) );


// c[sC3H5O] (uncoupled) --------------------

		c[sC3H5O] = ( 0
			+ k[rH203] * c[sC3H5XAXC3H5] * c[sHO2]
			+ k[rH206] * c[sC3H5XAXC3H5] * c[sCH3O2]
			+ k[rH253b] * c[sC2H3CHO] * c[sH]
			+ k[rL57] * c[sNXC3H7O2] * c[sC3H5XAXC3H5]
			) / ( CatchZero(
			+ k[rH253f]
			+ k[rH254]
			+ k[rH255] * c[sO2]
			) );


// c[sC2H3CO] (uncoupled) --------------------

		c[sC2H3CO] = ( 0
			+ k[rH246b] * c[sC2H3] * c[sCO]
			+ k[rH247] * c[sC2H3CHO] * c[sCH3O2]
			+ k[rH248] * c[sC2H3CHO] * c[sOH]
			+ k[rH249] * c[sC2H3CHO] * c[sHO2]
			+ k[rH250] * c[sC2H3CHO] * c[sCH3]
			+ k[rH251] * c[sC2H3CHO] * c[sO]
			+ k[rH252] * c[sC2H3CHO] * c[sH]
			) / ( CatchZero(
			+ k[rH246f]
			) );


// c[sC7H15X2XC7H15] (uncoupled) --------------------

		c[sC7H15X2XC7H15] = ( 0
			+ k[rHLP429b] * c[sC6H12X1XC6H12] * c[sCH3]
			+ k[rHLP434] * c[sNXC7H16] * c[sHO2]
			+ k[rHLP435] * c[sNXC7H16] * c[sCH3]
			+ k[rHLP437] * c[sNXC7H16] * c[sCH3O]
			+ k[rHLP438] * c[sNXC7H16] * c[sC2H5]
			+ k[rHLP439] * c[sNXC7H16] * c[sO]
			+ k[rHLP440f] * c[sNXC7H16] * c[sO2]
			+ k[rHLP441] * c[sNXC7H16] * c[sOH]
			+ k[rHLP442] * c[sNXC7H16] * c[sH]
			+ k[rHLP444] * c[sNXC7H16] * c[sCH3O2]
			+ k[rLLP220b] * c[sH] * c[sC7H14X2XC7H14]
			+ k[rLLP262] * c[sNXC7H16] * c[sC7H15O2X2XC7H15O2]
			+ k[rLLP263f] * c[sC7H15O2X2XC7H15O2]
			) / ( CatchZero(
			+ k[rHLP425]
			+ k[rHLP426] * c[sH]
			+ k[rHLP427]
			+ k[rHLP428]
			+ k[rHLP429f]
			+ k[rHLP430]
			+ k[rHLP440b] * c[sHO2]
			+ k[rLLP218] * c[sCH3O2]
			+ k[rLLP219] * c[sHO2]
			+ k[rLLP220f]
			+ k[rLLP263b] * c[sO2]
			+ k[rLLP265] * c[sC7H15O2X2XC7H15O2]
			) );


// c[sC3H6OOH1X2XC3H7O2] (uncoupled) --------------------

		c[sC3H6OOH1X2XC3H7O2] = ( 0
			+ k[rL48b] * c[sC3H6] * c[sHO2]
			+ k[rL53f] * c[sNXC3H7O2]
			) / ( CatchZero(
			+ k[rL48f]
			+ k[rL53b]
			) );


// c[sC3H6OOH2X1XC3H7O2] (uncoupled) --------------------

		c[sC3H6OOH2X1XC3H7O2] = ( 0
			+ k[rL49b] * c[sC3H6] * c[sHO2]
			+ k[rL50] * c[sIXC3H7O2]
			) / ( CatchZero(
			+ k[rL49f]
			) );


// c[sNXC3H7CO] (uncoupled) --------------------

		c[sNXC3H7CO] = ( 0
			+ k[rL82b] * c[sNXC3H7] * c[sCO]
			+ k[rL88] * c[sNXC3H7CHO] * c[sO]
			+ k[rL89] * c[sNXC3H7CHO] * c[sCH3O]
			+ k[rL90] * c[sNXC3H7CHO] * c[sCH3O2]
			+ k[rL91] * c[sNXC3H7CHO] * c[sCH3]
			+ k[rL92] * c[sNXC3H7CHO] * c[sO2]
			+ k[rL93] * c[sNXC3H7CHO] * c[sHO2]
			+ k[rL94] * c[sNXC3H7CHO] * c[sOH]
			+ k[rL95] * c[sNXC3H7CHO] * c[sH]
			+ k[rLLP234] * c[sC7H14O2X5XC7H14O] * c[sHO2]
			+ k[rLLP236] * c[sC7H14O2X5XC7H14O] * c[sOH]
			) / ( CatchZero(
			+ k[rL82f]
			) );


// c[sTC4H8O2HXIXC4H9O2] (uncoupled) --------------------

		c[sTC4H8O2HXIXC4H9O2] = ( 0
			+ k[rH389f] * c[sTXC4H9O2]
			+ k[rH391b] * c[sIXC4H8] * c[sHO2]
			) / ( CatchZero(
			+ k[rH389b]
			+ k[rH391f]
			+ k[rL124]
			) );


// c[sC7H14OOH1X3XC7H15O2] (uncoupled) --------------------

		c[sC7H14OOH1X3XC7H15O2] = ( 0
			+ k[rLLP261f] * c[sC7H15O2X2XC7H15O2]
			+ k[rLLP288f] * c[sC7H14OOH1X3O2XC7H15O4]
			) / ( CatchZero(
			+ k[rLLP249]
			+ k[rLLP250]
			+ k[rLLP251]
			+ k[rLLP252]
			+ k[rLLP253]
			+ k[rLLP261b]
			+ k[rLLP288b] * c[sO2]
			) );


// c[sC3H2] (uncoupled) --------------------

		c[sC3H2] = ( 0
			+ k[rH182] * c[sC3H3] * c[sH]
			+ k[rH185f] * c[sC3H3] * c[sOH]
			) / ( CatchZero(
			+ k[rH180] * c[sOH]
			+ k[rH181] * c[sO2]
			+ k[rH185b] * c[sH2O]
			) );


// c[sDXC8H17O] (uncoupled) --------------------

		c[sDXC8H17O] = ( 0
			+ k[rLLP294] * c[sCXC8H17] * c[sCH3O2]
			+ k[rLLP295] * c[sCXC8H17] * c[sHO2]
			+ k[rLLP306] * c[sBXC8H17O2] * c[sCH3O2]
			+ k[rLLP313] * 2.0 * c[sCXC8H17] * c[sBXC8H17O2]
			+ k[rLLP314] * 2.0 * c[sBXC8H17O2] * c[sBXC8H17O2]
			+ k[rLLP326] * c[sBXC8H17O2H]
			) / ( CatchZero(
			+ k[rLLP302]
			+ k[rLLP303]
			+ k[rLLP304]
			) );


// c[sDC8H16OOHXBXC8H17O2] (uncoupled) --------------------

		c[sDC8H16OOHXBXC8H17O2] = ( 0
			+ k[rLLP305] * c[sBXC8H17O2]
			+ k[rLLP333f] * c[sBC8H16OOHXCO2XC8H17O4]
			) / ( CatchZero(
			+ k[rLLP323]
			+ k[rLLP324]
			+ k[rLLP325]
			+ k[rLLP333b] * c[sO2]
			) );


// c[sIXC4H8OH] c[sIXO2C4H8OH] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC4H8OH_denom1 = CatchZero( 0
			+ k[rL102f]
			+ k[rL144b] * c[sO2]
			);

	 Double IXO2C4H8OH_denom1 = CatchZero( 0
			+ k[rL143]
			+ k[rL144f]
			);


// Primary constant parts -----------------------

	 Double IXC4H8OH_ct1 = ( 0
			+ k[rL87] * c[sIXC4H7OH] * c[sH]
			+ k[rL102b] * c[sIXC4H8] * c[sOH]
			);

	 Double IXO2C4H8OH_ct1 = ( 0
			);


// IXC4H8OH ---------------------------------------

	 Double IXC4H8OH_denom2 = CatchZero( IXC4H8OH_denom1
			);

	 Double IXC4H8OH_ct2 = ( IXC4H8OH_ct1
			) / IXC4H8OH_denom2;



	 Double IXC4H8OH_IXO2C4H8OH = ( 0 + k[rL144f] 
			) / IXC4H8OH_denom2 ;



	 Double IXC4H8OH_IXO2C4H8OH_coeff = ( 0 + k[rL144b]  * c[sO2]
			);


// IXO2C4H8OH ---------------------------------------

	 Double IXO2C4H8OH_denom2 = CatchZero( IXO2C4H8OH_denom1
			- IXC4H8OH_IXO2C4H8OH_coeff * IXC4H8OH_IXO2C4H8OH
			);

	 Double IXO2C4H8OH_ct2 = ( IXO2C4H8OH_ct1
			+ IXC4H8OH_IXO2C4H8OH_coeff * IXC4H8OH_ct2
			) / IXO2C4H8OH_denom2;






// Reconstruction ------------------------------------

	c[sIXO2C4H8OH] = ( IXO2C4H8OH_ct2
			) ;

	c[sIXC4H8OH] = ( IXC4H8OH_ct2
			+ IXC4H8OH_IXO2C4H8OH * c[sIXO2C4H8OH]
			) ;

// c[sC6H12OOH1X3O2XC6H13O4] c[sC6H12OOH1X3XC6H13O2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double C6H12OOH1X3O2XC6H13O4_denom1 = CatchZero( 0
			+ k[rL207f]
			+ k[rL208]
			);

	 Double C6H12OOH1X3XC6H13O2_denom1 = CatchZero( 0
			+ k[rL203]
			+ k[rL207b] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double C6H12OOH1X3O2XC6H13O4_ct1 = ( 0
			);

	 Double C6H12OOH1X3XC6H13O2_ct1 = ( 0
			+ k[rL204] * c[sC6H13O2X1XC6H13O2]
			);


// C6H12OOH1X3O2XC6H13O4 ---------------------------------------

	 Double C6H12OOH1X3O2XC6H13O4_denom2 = CatchZero( C6H12OOH1X3O2XC6H13O4_denom1
			);

	 Double C6H12OOH1X3O2XC6H13O4_ct2 = ( C6H12OOH1X3O2XC6H13O4_ct1
			) / C6H12OOH1X3O2XC6H13O4_denom2;



	 Double C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2 = ( 0 + k[rL207b]  * c[sO2]
			) / C6H12OOH1X3O2XC6H13O4_denom2 ;



	 Double C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2_coeff = ( 0 + k[rL207f] 
			);


// C6H12OOH1X3XC6H13O2 ---------------------------------------

	 Double C6H12OOH1X3XC6H13O2_denom2 = CatchZero( C6H12OOH1X3XC6H13O2_denom1
			- C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2_coeff * C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2
			);

	 Double C6H12OOH1X3XC6H13O2_ct2 = ( C6H12OOH1X3XC6H13O2_ct1
			+ C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2_coeff * C6H12OOH1X3O2XC6H13O4_ct2
			) / C6H12OOH1X3XC6H13O2_denom2;






// Reconstruction ------------------------------------

	c[sC6H12OOH1X3XC6H13O2] = ( C6H12OOH1X3XC6H13O2_ct2
			) ;

	c[sC6H12OOH1X3O2XC6H13O4] = ( C6H12OOH1X3O2XC6H13O4_ct2
			+ C6H12OOH1X3O2XC6H13O4_C6H12OOH1X3XC6H13O2 * c[sC6H12OOH1X3XC6H13O2]
			) ;

// c[sC7H14OOH3X2XC7H15O2] (uncoupled) --------------------

		c[sC7H14OOH3X2XC7H15O2] = ( 0
			+ k[rLLP259f] * c[sC7H15O2X2XC7H15O2]
			) / ( CatchZero(
			+ k[rLLP256]
			+ k[rLLP259b]
			) );


// c[sC2H5COC2H4PXC5H9O] (uncoupled) --------------------

		c[sC2H5COC2H4PXC5H9O] = ( 0
			+ k[rLLP280] * c[sNC7KET25XC7H14O3]
			) / ( CatchZero(
			+ k[rL154]
			) );


// c[sYC7H13OOHXX2XC7H14O2] (uncoupled) --------------------

		c[sYC7H13OOHXX2XC7H14O2] = ( 0
			+ k[rLLP316] * c[sAC8H16OOHXBXC8H17O2]
			+ k[rLLP324] * c[sDC8H16OOHXBXC8H17O2]
			) / ( CatchZero(
			+ k[rLLP248]
			) );


// c[sC7H15OX1XC7H15O] (uncoupled) --------------------

		c[sC7H15OX1XC7H15O] = ( 0
			+ k[rLLP218] * c[sC7H15X2XC7H15] * c[sCH3O2]
			+ k[rLLP219] * c[sC7H15X2XC7H15] * c[sHO2]
			+ k[rLLP257] * c[sC7H15O2X2XC7H15O2] * c[sCH3O2]
			+ k[rLLP258] * 2.0 * c[sC7H15O2X2XC7H15O2] * c[sC7H15O2X2XC7H15O2]
			+ k[rLLP265] * 2.0 * c[sC7H15X2XC7H15] * c[sC7H15O2X2XC7H15O2]
			+ k[rLLP277] * c[sC7H15O2HX2XC7H16O2]
			) / ( CatchZero(
			+ k[rLLP242]
			+ k[rLLP243]
			+ k[rLLP244]
			+ k[rLLP245]
			) );


// c[sC5H11X1XC5H11] (uncoupled) --------------------

		c[sC5H11X1XC5H11] = ( 0
			+ k[rHLP410b] * c[sH] * c[sC5H10X1XC5H10]
			+ k[rHLP411b] * c[sC3H6] * c[sC2H5]
			+ k[rHLP417] * c[sC6H12X1XC6H12] * c[sOH]
			+ k[rHLP425] * c[sC7H15X2XC7H15]
			+ k[rHLP445f] * c[sNXC7H16]
			+ k[rLLP176f] * c[sC5H11O2X1XC5H11O2]
			+ k[rLLP216] * c[sC7H14X2XC7H14] * c[sOH]
			+ k[rLLP245] * c[sC7H15OX1XC7H15O]
			) / ( CatchZero(
			+ k[rHLP409]
			+ k[rHLP410f]
			+ k[rHLP411f]
			+ k[rHLP445b] * c[sC2H5]
			+ k[rLLP152] * c[sHO2]
			+ k[rLLP153] * c[sCH3O2]
			+ k[rLLP176b] * c[sO2]
			+ k[rLLP179] * c[sC5H11O2X1XC5H11O2]
			) );


// c[sC6H13X1XC6H13] (uncoupled) --------------------

		c[sC6H13X1XC6H13] = ( 0
			+ k[rH418b] * c[sC6H12X1XC6H12] * c[sH]
			+ k[rH436f] * c[sNXC7H16]
			+ k[rL205f] * c[sC6H13O2X1XC6H13O2]
			+ k[rLLP244] * c[sC7H15OX1XC7H15O]
			) / ( CatchZero(
			+ k[rH418f]
			+ k[rH419]
			+ k[rH436b] * c[sCH3]
			+ k[rL205b] * c[sO2]
			) );


// c[sTXC4H8CHO] (uncoupled) --------------------

		c[sTXC4H8CHO] = ( 0
			+ k[rL78] * c[sIXC3H5CHO] * c[sCH3]
			+ k[rL169] * c[sTXC4H9CHO] * c[sOH]
			+ k[rLLP327] * c[sIC8KETBCXC8H16O3]
			) / ( CatchZero(
			+ k[rL161]
			) );


// c[sC2H5O] (uncoupled) --------------------

		c[sC2H5O] = ( 0
			+ k[rH138] * c[sCH3O2] * c[sC2H5]
			+ k[rH140] * c[sC2H5] * c[sHO2]
			+ k[rH175b] * c[sCH3CHO] * c[sH] * M[mM5]
			+ k[rL13] * c[sC2H5O2H]
			+ k[rL52] * c[sNXC3H7O2] * c[sC2H5O2]
			+ k[rL59] * c[sNXC3H7O2] * c[sC2H5]
			+ k[rL128] * c[sPXC4H9O2] * c[sC2H5]
			+ k[rL131] * c[sPXC4H9O2] * c[sC2H5O2]
			) / ( CatchZero(
			+ k[rH175f] * M[mM5]
			+ k[rH176] * c[sO2]
			+ k[rH177] * M[mM5]
			) );


// c[sC5H10OOH1X3XC5H11O2] (uncoupled) --------------------

		c[sC5H10OOH1X3XC5H11O2] = ( 0
			+ k[rL180f] * c[sC5H11O2X1XC5H11O2]
			+ k[rL194f] * c[sC5H10OOH1X3O2XC5H11O4]
			) / ( CatchZero(
			+ k[rL175]
			+ k[rL180b]
			+ k[rL194b] * c[sO2]
			) );


// c[sIXC3H5CO] (uncoupled) --------------------

		c[sIXC3H5CO] = ( 0
			+ k[rH356] * c[sIXC3H5CHO] * c[sOH]
			+ k[rH357] * c[sIXC3H5CHO] * c[sO]
			+ k[rH358] * c[sIXC3H5CHO] * c[sHO2]
			+ k[rH359] * c[sIXC3H5CHO] * c[sH]
			+ k[rH360] * c[sIXC3H5CHO] * c[sCH3]
			) / ( CatchZero(
			+ k[rH355]
			) );


// c[sPC7H14OOHXOO2XC7H15O4] c[sYC7H14OOHXY2XC7H15O2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double PC7H14OOHXOO2XC7H15O4_denom1 = CatchZero( 0
			+ k[rLLP286f]
			+ k[rL287]
			);

	 Double YC7H14OOHXY2XC7H15O2_denom1 = CatchZero( 0
			+ k[rLLP272b]
			+ k[rLLP274]
			+ k[rLLP275]
			+ k[rLLP276]
			+ k[rLLP286b] * c[sO2]
			+ k[rLLP292b] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double PC7H14OOHXOO2XC7H15O4_ct1 = ( 0
			);

	 Double YC7H14OOHXY2XC7H15O2_ct1 = ( 0
			+ k[rLLP272f] * c[sYXC7H15O2]
			+ k[rLLP292f] * c[sYC7H14OOHXY2O2XC7H15O4]
			);


// PC7H14OOHXOO2XC7H15O4 ---------------------------------------

	 Double PC7H14OOHXOO2XC7H15O4_denom2 = CatchZero( PC7H14OOHXOO2XC7H15O4_denom1
			);

	 Double PC7H14OOHXOO2XC7H15O4_ct2 = ( PC7H14OOHXOO2XC7H15O4_ct1
			) / PC7H14OOHXOO2XC7H15O4_denom2;



	 Double PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2 = ( 0 + k[rLLP286b]  * c[sO2]
			) / PC7H14OOHXOO2XC7H15O4_denom2 ;



	 Double PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2_coeff = ( 0 + k[rLLP286f] 
			);


// YC7H14OOHXY2XC7H15O2 ---------------------------------------

	 Double YC7H14OOHXY2XC7H15O2_denom2 = CatchZero( YC7H14OOHXY2XC7H15O2_denom1
			- PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2_coeff * PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2
			);

	 Double YC7H14OOHXY2XC7H15O2_ct2 = ( YC7H14OOHXY2XC7H15O2_ct1
			+ PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2_coeff * PC7H14OOHXOO2XC7H15O4_ct2
			) / YC7H14OOHXY2XC7H15O2_denom2;






// Reconstruction ------------------------------------

	c[sYC7H14OOHXY2XC7H15O2] = ( YC7H14OOHXY2XC7H15O2_ct2
			) ;

	c[sPC7H14OOHXOO2XC7H15O4] = ( PC7H14OOHXOO2XC7H15O4_ct2
			+ PC7H14OOHXOO2XC7H15O4_YC7H14OOHXY2XC7H15O2 * c[sYC7H14OOHXY2XC7H15O2]
			) ;

// c[sNEOC7KETPOXC7H14O3] (uncoupled) --------------------

		c[sNEOC7KETPOXC7H14O3] = ( 0
			+ k[rL287] * c[sPC7H14OOHXOO2XC7H15O4]
			) / ( CatchZero(
			+ k[rL279]
			) );


// c[sC5H11OX1XC5H11O] (uncoupled) --------------------

		c[sC5H11OX1XC5H11O] = ( 0
			+ k[rLLP152] * c[sC5H11X1XC5H11] * c[sHO2]
			+ k[rLLP153] * c[sC5H11X1XC5H11] * c[sCH3O2]
			+ k[rL177] * c[sC5H11O2X1XC5H11O2] * c[sCH3O2]
			+ k[rL178] * 2.0 * c[sC5H11O2X1XC5H11O2] * c[sC5H11O2X1XC5H11O2]
			+ k[rLLP179] * 2.0 * c[sC5H11X1XC5H11] * c[sC5H11O2X1XC5H11O2]
			) / ( CatchZero(
			+ k[rL173]
			) );


// c[sPXC4H9] c[sNXC4H9CO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double PXC4H9_denom1 = CatchZero( 0
			+ k[rH318f]
			+ k[rH319f]
			+ k[rH344b] * c[sH]
			+ k[rH345b] * c[sHO2]
			+ k[rH346b] * c[sC3H6]
			+ k[rH347b] * c[sC2H6]
			+ k[rH348b] * c[sC2H4]
			+ k[rH349b] * c[sCH4]
			+ k[rH350b] * c[sH2]
			+ k[rH351b] * c[sH2O]
			+ k[rH352b] * c[sOH]
			+ k[rH353b] * c[sH2O2]
			+ k[rH354b] * c[sCH3OH]
			+ k[rH393b] * c[sO2]
			+ k[rH443b] * c[sNXC3H7]
			+ k[rL73] * c[sNXC3H7O2]
			+ k[rL74] * c[sCH3O2]
			+ k[rL75] * c[sHO2]
			+ k[rL125] * c[sPXC4H9O2]
			+ k[rL159b] * c[sCO]
			);

	 Double NXC4H9CO_denom1 = CatchZero( 0
			+ k[rL159f]
			);


// Primary constant parts -----------------------

	 Double PXC4H9_ct1 = ( 0
			+ k[rH318b] * c[sC2H5] * c[sC2H4]
			+ k[rH319b] * c[sC4H8X1XC4H8] * c[sH]
			+ k[rH344f] * c[sC4H10]
			+ k[rH345f] * c[sC4H10] * c[sO2]
			+ k[rH346f] * c[sC4H10] * c[sC3H5XAXC3H5]
			+ k[rH347f] * c[sC4H10] * c[sC2H5]
			+ k[rH348f] * c[sC4H10] * c[sC2H3]
			+ k[rH349f] * c[sC4H10] * c[sCH3]
			+ k[rH350f] * c[sC4H10] * c[sH]
			+ k[rH351f] * c[sC4H10] * c[sOH]
			+ k[rH352f] * c[sC4H10] * c[sO]
			+ k[rH353f] * c[sC4H10] * c[sHO2]
			+ k[rH354f] * c[sC4H10] * c[sCH3O]
			+ k[rH393f] * c[sPXC4H9O2]
			+ k[rH406] * c[sC5H10X1XC5H10] * c[sOH]
			+ k[rH419] * c[sC6H13X1XC6H13]
			+ k[rHLP427] * c[sC7H15X2XC7H15]
			+ k[rH443f] * c[sNXC7H16]
			+ k[rL173] * c[sC5H11OX1XC5H11O]
			+ k[rLLP211] * c[sC7H14X2XC7H14] * c[sOH]
			+ k[rLLP242] * c[sC7H15OX1XC7H15O]
			);

	 Double NXC4H9CO_ct1 = ( 0
			+ k[rL163] * c[sNXC4H9CHO] * c[sCH3O2]
			+ k[rL164] * c[sNXC4H9CHO] * c[sH]
			+ k[rL165] * c[sNXC4H9CHO] * c[sOH]
			+ k[rL166] * c[sNXC4H9CHO] * c[sCH3]
			+ k[rL167] * c[sNXC4H9CHO] * c[sCH3O]
			+ k[rL168] * c[sNXC4H9CHO] * c[sHO2]
			+ k[rLLP240] * c[sC7H14O2X5XC7H14O] * c[sOH]
			);


// PXC4H9 ---------------------------------------

	 Double PXC4H9_denom2 = CatchZero( PXC4H9_denom1
			);

	 Double PXC4H9_ct2 = ( PXC4H9_ct1
			) / PXC4H9_denom2;



	 Double PXC4H9_NXC4H9CO = ( 0 + k[rL159f] 
			) / PXC4H9_denom2 ;



	 Double PXC4H9_NXC4H9CO_coeff = ( 0 + k[rL159b]  * c[sCO]
			);


// NXC4H9CO ---------------------------------------

	 Double NXC4H9CO_denom2 = CatchZero( NXC4H9CO_denom1
			- PXC4H9_NXC4H9CO_coeff * PXC4H9_NXC4H9CO
			);

	 Double NXC4H9CO_ct2 = ( NXC4H9CO_ct1
			+ PXC4H9_NXC4H9CO_coeff * PXC4H9_ct2
			) / NXC4H9CO_denom2;






// Reconstruction ------------------------------------

	c[sNXC4H9CO] = ( NXC4H9CO_ct2
			) ;

	c[sPXC4H9] = ( PXC4H9_ct2
			+ PXC4H9_NXC4H9CO * c[sNXC4H9CO]
			) ;

// c[sXXC7H13] (uncoupled) --------------------

		c[sXXC7H13] = ( 0
			+ k[rHLP423f] * c[sYXC7H14] * c[sOH]
			+ k[rHLP424f] * c[sYXC7H14] * c[sH]
			+ k[rLLP297] * c[sIC8ETERACXC8H16O] * c[sOH]
			) / ( CatchZero(
			+ k[rHLP420] * c[sHO2]
			+ k[rHLP423b] * c[sH2O]
			+ k[rHLP424b] * c[sH2]
			) );


// c[sXC7H13OXZXC7H13O] (uncoupled) --------------------

		c[sXC7H13OXZXC7H13O] = ( 0
			+ k[rHLP420] * c[sXXC7H13] * c[sHO2]
			+ k[rLLP248] * c[sYC7H13OOHXX2XC7H14O2]
			) / ( CatchZero(
			+ k[rHLP446]
			+ k[rLLP224]
			) );


// c[sBC8H16OOHXCXC8H17O2] (uncoupled) --------------------

		c[sBC8H16OOHXCXC8H17O2] = ( 0
			+ k[rLLP311] * c[sBXC8H17O2]
			+ k[rLLP334f] * c[sBC8H16OOHXCO2XC8H17O4]
			) / ( CatchZero(
			+ k[rLLP319]
			+ k[rLLP320]
			+ k[rLLP321]
			+ k[rLLP322]
			+ k[rLLP334b] * c[sO2]
			) );


// c[sC7H14OOH2X3XC7H15O2] (uncoupled) --------------------

		c[sC7H14OOH2X3XC7H15O2] = ( 0
			+ k[rLLP264f] * c[sC7H15O2X2XC7H15O2]
			+ k[rLLP290f] * c[sC7H14OOH1X4O2XC7H15O4]
			) / ( CatchZero(
			+ k[rLLP254]
			+ k[rLLP255]
			+ k[rLLP264b]
			+ k[rLLP290b] * c[sO2]
			) );


// c[sC4H8OHX1XC4H9O] (uncoupled) --------------------

		c[sC4H8OHX1XC4H9O] = ( 0
			+ k[rL103b] * c[sC4H8X1XC4H8] * c[sOH]
			) / ( CatchZero(
			+ k[rL103f]
			+ k[rL104] * c[sO2]
			) );


// c[sC4H8OHX1O2XC4H9O3] (uncoupled) --------------------

		c[sC4H8OHX1O2XC4H9O3] = ( 0
			+ k[rL104] * c[sC4H8OHX1XC4H9O] * c[sO2]
			) / ( CatchZero(
			+ k[rL142]
			) );


// c[sC4H7] (uncoupled) --------------------

		c[sC4H7] = ( 0
			+ k[rH283b] * c[sC4H6] * c[sH]
			+ k[rH294] * c[sC4H8X1XC4H8] * c[sH]
			+ k[rH299f] * c[sC4H8X1XC4H8] * c[sO2]
			+ k[rH300] * c[sC4H8X1XC4H8] * c[sOH]
			+ k[rH301] * c[sC4H8X1XC4H8] * c[sHO2]
			+ k[rH303] * c[sC4H8X1XC4H8] * c[sCH3]
			+ k[rL209f] * c[sC7H13]
			+ k[rLLP213] * c[sC7H14X2XC7H14]
			+ k[rLLP231] * c[sC7H14O2X5XC7H14O] * c[sOH]
			) / ( CatchZero(
			+ k[rH274] * c[sCH3]
			+ k[rH275] * c[sC3H5XAXC3H5]
			+ k[rH276] * c[sHO2]
			+ k[rH277] * c[sC2H5]
			+ k[rH278] * c[sCH3O2]
			+ k[rH279] * c[sH]
			+ k[rH280]
			+ k[rH281] * c[sO2]
			+ k[rH282] * c[sH]
			+ k[rH283f]
			+ k[rH299b] * c[sHO2]
			+ k[rL65] * c[sC2H5CHO]
			+ k[rL209b] * c[sC3H6]
			) );


// c[sC4H7O] (uncoupled) --------------------

		c[sC4H7O] = ( 0
			+ k[rH276] * c[sC4H7] * c[sHO2]
			+ k[rH278] * c[sC4H7] * c[sCH3O2]
			) / ( CatchZero(
			+ k[rH369]
			+ k[rH370]
			) );


// c[sNEOXC5H10OOH] c[sNEOC5H10OOHXO2XC5H11O4] (coupled)  --------------------

// Primary denominators-----------------------

	 Double NEOXC5H10OOH_denom1 = CatchZero( 0
			+ k[rL181]
			+ k[rL182]
			+ k[rL183b]
			+ k[rL196b] * c[sO2]
			);

	 Double NEOC5H10OOHXO2XC5H11O4_denom1 = CatchZero( 0
			+ k[rL195]
			+ k[rL196f]
			);


// Primary constant parts -----------------------

	 Double NEOXC5H10OOH_ct1 = ( 0
			+ k[rL183f] * c[sNEOXC5H11O2]
			);

	 Double NEOC5H10OOHXO2XC5H11O4_ct1 = ( 0
			);


// NEOXC5H10OOH ---------------------------------------

	 Double NEOXC5H10OOH_denom2 = CatchZero( NEOXC5H10OOH_denom1
			);

	 Double NEOXC5H10OOH_ct2 = ( NEOXC5H10OOH_ct1
			) / NEOXC5H10OOH_denom2;



	 Double NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4 = ( 0 + k[rL196f] 
			) / NEOXC5H10OOH_denom2 ;



	 Double NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff = ( 0 + k[rL196b]  * c[sO2]
			);


// NEOC5H10OOHXO2XC5H11O4 ---------------------------------------

	 Double NEOC5H10OOHXO2XC5H11O4_denom2 = CatchZero( NEOC5H10OOHXO2XC5H11O4_denom1
			- NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff * NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4
			);

	 Double NEOC5H10OOHXO2XC5H11O4_ct2 = ( NEOC5H10OOHXO2XC5H11O4_ct1
			+ NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff * NEOXC5H10OOH_ct2
			) / NEOC5H10OOHXO2XC5H11O4_denom2;






// Reconstruction ------------------------------------

	c[sNEOC5H10OOHXO2XC5H11O4] = ( NEOC5H10OOHXO2XC5H11O4_ct2
			) ;

	c[sNEOXC5H10OOH] = ( NEOXC5H10OOH_ct2
			+ NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4 * c[sNEOC5H10OOHXO2XC5H11O4]
			) ;

// c[sNEOC5H9Q2XNXC5H11O4] (uncoupled) --------------------

		c[sNEOC5H9Q2XNXC5H11O4] = ( 0
			+ k[rL195] * c[sNEOC5H10OOHXO2XC5H11O4]
			) / ( CatchZero(
			+ k[rL197]
			) );


// c[sNEOC5KETXC5H10O3] (uncoupled) --------------------

		c[sNEOC5KETXC5H10O3] = ( 0
			+ k[rL197] * c[sNEOC5H9Q2XNXC5H11O4]
			) / ( CatchZero(
			+ k[rL192]
			) );


// c[sTXC3H6O2CHO] c[sTXC3H6CHO] c[sNEOC5KETOXXC5H9O2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double TXC3H6O2CHO_denom1 = CatchZero( 0
			+ k[rL136f]
			+ k[rL137]
			);

	 Double TXC3H6CHO_denom1 = CatchZero( 0
			+ k[rL83] * c[sHO2]
			+ k[rL84f]
			+ k[rL85f]
			+ k[rL86] * c[sHO2]
			+ k[rL136b] * c[sO2]
			+ k[rL174b] * c[sCH2O]
			);

	 Double NEOC5KETOXXC5H9O2_denom1 = CatchZero( 0
			+ k[rL174f]
			);


// Primary constant parts -----------------------

	 Double TXC3H6O2CHO_ct1 = ( 0
			);

	 Double TXC3H6CHO_ct1 = ( 0
			+ k[rL84b] * c[sIXC3H5CHO] * c[sH]
			+ k[rL85b] * c[sIXC3H6CO] * c[sH]
			+ k[rL96] * c[sIXC3H7CHO] * c[sOH]
			+ k[rLLP301] * c[sIC8ETERACXC8H16O] * c[sOH]
			+ k[rLLP330] * c[sIC8KETBCXC8H16O3]
			);

	 Double NEOC5KETOXXC5H9O2_ct1 = ( 0
			+ k[rL192] * c[sNEOC5KETXC5H10O3]
			);


// TXC3H6O2CHO ---------------------------------------

	 Double TXC3H6O2CHO_denom2 = CatchZero( TXC3H6O2CHO_denom1
			);

	 Double TXC3H6O2CHO_ct2 = ( TXC3H6O2CHO_ct1
			) / TXC3H6O2CHO_denom2;



	 Double TXC3H6O2CHO_TXC3H6CHO = ( 0 + k[rL136b]  * c[sO2]
			) / TXC3H6O2CHO_denom2 ;

	 Double TXC3H6O2CHO_NEOC5KETOXXC5H9O2 = ( 0 
			) / TXC3H6O2CHO_denom2 ;



	 Double TXC3H6O2CHO_TXC3H6CHO_coeff = ( 0 + k[rL136f] 
			);

	 Double TXC3H6O2CHO_NEOC5KETOXXC5H9O2_coeff = ( 0 
			);


// TXC3H6CHO ---------------------------------------

	 Double TXC3H6CHO_denom2 = CatchZero( TXC3H6CHO_denom1
			- TXC3H6O2CHO_TXC3H6CHO_coeff * TXC3H6O2CHO_TXC3H6CHO
			);

	 Double TXC3H6CHO_ct2 = ( TXC3H6CHO_ct1
			+ TXC3H6O2CHO_TXC3H6CHO_coeff * TXC3H6O2CHO_ct2
			) / TXC3H6CHO_denom2;



	 Double TXC3H6CHO_NEOC5KETOXXC5H9O2 = ( 0 + k[rL174f] 
			+ TXC3H6O2CHO_TXC3H6CHO_coeff * TXC3H6O2CHO_NEOC5KETOXXC5H9O2
			) / TXC3H6CHO_denom2 ;



	 Double TXC3H6CHO_NEOC5KETOXXC5H9O2_coeff = ( 0 + k[rL174b]  * c[sCH2O]
			+ TXC3H6O2CHO_NEOC5KETOXXC5H9O2_coeff * TXC3H6O2CHO_TXC3H6CHO
			);


// NEOC5KETOXXC5H9O2 ---------------------------------------

	 Double NEOC5KETOXXC5H9O2_denom2 = CatchZero( NEOC5KETOXXC5H9O2_denom1
			- TXC3H6O2CHO_NEOC5KETOXXC5H9O2_coeff * TXC3H6O2CHO_NEOC5KETOXXC5H9O2
			- TXC3H6CHO_NEOC5KETOXXC5H9O2_coeff * TXC3H6CHO_NEOC5KETOXXC5H9O2
			);

	 Double NEOC5KETOXXC5H9O2_ct2 = ( NEOC5KETOXXC5H9O2_ct1
			+ TXC3H6O2CHO_NEOC5KETOXXC5H9O2_coeff * TXC3H6O2CHO_ct2
			+ TXC3H6CHO_NEOC5KETOXXC5H9O2_coeff * TXC3H6CHO_ct2
			) / NEOC5KETOXXC5H9O2_denom2;






// Reconstruction ------------------------------------

	c[sNEOC5KETOXXC5H9O2] = ( NEOC5KETOXXC5H9O2_ct2
			) ;

	c[sTXC3H6CHO] = ( TXC3H6CHO_ct2
			+ TXC3H6CHO_NEOC5KETOXXC5H9O2 * c[sNEOC5KETOXXC5H9O2]
			) ;

	c[sTXC3H6O2CHO] = ( TXC3H6O2CHO_ct2
			+ TXC3H6O2CHO_TXC3H6CHO * c[sTXC3H6CHO]
			+ TXC3H6O2CHO_NEOC5KETOXXC5H9O2 * c[sNEOC5KETOXXC5H9O2]
			) ;

// c[sTXC3H6O2HCO] (uncoupled) --------------------

		c[sTXC3H6O2HCO] = ( 0
			+ k[rL137] * c[sTXC3H6O2CHO]
			) / ( CatchZero(
			+ k[rL138]
			) );


// c[sTXC3H6OCHO] (uncoupled) --------------------

		c[sTXC3H6OCHO] = ( 0
			+ k[rL83] * c[sTXC3H6CHO] * c[sHO2]
			) / ( CatchZero(
			+ k[rL108]
			) );


// c[sC2H5COCH2] (uncoupled) --------------------

		c[sC2H5COCH2] = ( 0
			+ k[rLLP232] * c[sC7H14O2X5XC7H14O] * c[sHO2]
			+ k[rLLP233] * c[sC7H14O2X5XC7H14O] * c[sOH]
			+ k[rLLP283] * c[sNC7KET42XC7H14O3]
			) / ( CatchZero(
			+ k[rL79]
			) );


// c[sCH3CHCHO] (uncoupled) --------------------

		c[sCH3CHCHO] = ( 0
			+ k[rL29b] * c[sC2H3CHO] * c[sH]
			+ k[rL31b] * c[sCH3CHCO] * c[sH]
			+ k[rLLP331] * c[sIC8KETBCXC8H16O3]
			) / ( CatchZero(
			+ k[rL29f]
			+ k[rL30] * c[sO2]
			+ k[rL31f]
			+ k[rL32] * c[sO2]
			) );


// c[sIXC4H7OOH] (uncoupled) --------------------

		c[sIXC4H7OOH] = ( 0
			+ k[rL181] * c[sNEOXC5H10OOH]
			+ k[rLLP315] * c[sAC8H16OOHXBXC8H17O2]
			) / ( CatchZero(
			+ k[rL109]
			) );


// c[sIXC4H6OH] c[sIXC4H7O] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC4H6OH_denom1 = CatchZero( 0
			+ k[rH364] * c[sH]
			+ k[rH365] * c[sCH2O]
			+ k[rH366]
			+ k[rH367] * c[sHO2]
			+ k[rH368] * c[sHO2]
			+ k[rH374]
			);

	 Double IXC4H7O_denom1 = CatchZero( 0
			+ k[rH371]
			+ k[rH372]
			+ k[rH373]
			+ k[rH375] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double IXC4H6OH_ct1 = ( 0
			+ k[rH377] * c[sIXC4H7OH] * c[sHO2]
			+ k[rH378] * c[sIXC4H7OH] * c[sOH]
			);

	 Double IXC4H7O_ct1 = ( 0
			+ k[rH284] * c[sCH3O2] * c[sIXC4H7]
			+ k[rH290] * c[sIXC4H7] * c[sHO2]
			+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
			+ k[rL109] * c[sIXC4H7OOH]
			+ k[rL118] * c[sIXC4H9O2] * c[sIXC4H7]
			);


// IXC4H6OH ---------------------------------------

	 Double IXC4H6OH_denom2 = CatchZero( IXC4H6OH_denom1
			);

	 Double IXC4H6OH_ct2 = ( IXC4H6OH_ct1
			) / IXC4H6OH_denom2;



	 Double IXC4H6OH_IXC4H7O = ( 0 + k[rH373] 
			) / IXC4H6OH_denom2 ;



	 Double IXC4H6OH_IXC4H7O_coeff = ( 0 + k[rH374] 
			);


// IXC4H7O ---------------------------------------

	 Double IXC4H7O_denom2 = CatchZero( IXC4H7O_denom1
			- IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_IXC4H7O
			);

	 Double IXC4H7O_ct2 = ( IXC4H7O_ct1
			+ IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_ct2
			) / IXC4H7O_denom2;






// Reconstruction ------------------------------------

	c[sIXC4H7O] = ( IXC4H7O_ct2
			) ;

	c[sIXC4H6OH] = ( IXC4H6OH_ct2
			+ IXC4H6OH_IXC4H7O * c[sIXC4H7O]
			) ;

// c[sC3H5XTXC3H5] c[sC3H4XPXH4C3] c[sC2H] (coupled)  --------------------

// Primary denominators-----------------------

	 Double C3H5XTXC3H5_denom1 = CatchZero( 0
			+ k[rH212f]
			+ k[rH213] * c[sO2]
			+ k[rH214] * c[sO2]
			+ k[rH215f]
			+ k[rH224b] * c[sH2]
			);

	 Double C3H4XPXH4C3_denom1 = CatchZero( 0
			+ k[rH118b] * c[sH]
			+ k[rH194b]
			+ k[rH195] * M[mM5]
			+ k[rH196f] * c[sOH]
			+ k[rH197f] * c[sCH3]
			+ k[rH198f] * c[sH]
			+ k[rH199f]
			+ k[rH215b] * c[sH]
			);

	 Double C2H_denom1 = CatchZero( 0
			+ k[rH110] * c[sO]
			+ k[rH111] * c[sH] * M[mM5]
			+ k[rH112] * c[sO2]
			+ k[rH120b] * c[sOH]
			+ k[rH121b] * c[sH2O]
			+ k[rH199b] * c[sCH3]
			);


// Primary constant parts -----------------------

	 Double C3H5XTXC3H5_ct1 = ( 0
			+ k[rH212b] * c[sC3H4XAXH4C3] * c[sH]
			+ k[rH221] * c[sC3H6] * c[sO]
			+ k[rH223] * c[sC3H6] * c[sOH]
			+ k[rH224f] * c[sC3H6] * c[sH]
			+ k[rH304] * c[sIXC4H8]
			+ k[rH355] * c[sIXC3H5CO]
			+ k[rH371] * c[sIXC4H7O]
			);

	 Double C3H4XPXH4C3_ct1 = ( 0
			+ k[rH118f] * c[sC2H2] * c[sCH3]
			+ k[rH188] * c[sC3H3] * c[sHO2]
			+ k[rH194f] * c[sC3H4XAXH4C3]
			+ k[rH196b] * c[sC3H3] * c[sH2O]
			+ k[rH197b] * c[sC3H3] * c[sCH4]
			+ k[rH198b] * c[sC3H3] * c[sH2]
			);

	 Double C2H_ct1 = ( 0
			+ k[rH120f] * c[sO] * c[sC2H2]
			+ k[rH121f] * c[sC2H2] * c[sOH]
			+ k[rH187] * c[sC3H3] * c[sO]
			);


// C3H5XTXC3H5 ---------------------------------------

	 Double C3H5XTXC3H5_denom2 = CatchZero( C3H5XTXC3H5_denom1
			);

	 Double C3H5XTXC3H5_ct2 = ( C3H5XTXC3H5_ct1
			) / C3H5XTXC3H5_denom2;



	 Double C3H5XTXC3H5_C3H4XPXH4C3 = ( 0 + k[rH215b]  * c[sH]
			) / C3H5XTXC3H5_denom2 ;

	 Double C3H5XTXC3H5_C2H = ( 0 
			) / C3H5XTXC3H5_denom2 ;



	 Double C3H5XTXC3H5_C3H4XPXH4C3_coeff = ( 0 + k[rH215f] 
			);

	 Double C3H5XTXC3H5_C2H_coeff = ( 0 
			);


// C3H4XPXH4C3 ---------------------------------------

	 Double C3H4XPXH4C3_denom2 = CatchZero( C3H4XPXH4C3_denom1
			- C3H5XTXC3H5_C3H4XPXH4C3_coeff * C3H5XTXC3H5_C3H4XPXH4C3
			);

	 Double C3H4XPXH4C3_ct2 = ( C3H4XPXH4C3_ct1
			+ C3H5XTXC3H5_C3H4XPXH4C3_coeff * C3H5XTXC3H5_ct2
			) / C3H4XPXH4C3_denom2;



	 Double C3H4XPXH4C3_C2H = ( 0 + k[rH199b]  * c[sCH3]
			+ C3H5XTXC3H5_C3H4XPXH4C3_coeff * C3H5XTXC3H5_C2H
			) / C3H4XPXH4C3_denom2 ;



	 Double C3H4XPXH4C3_C2H_coeff = ( 0 + k[rH199f] 
			+ C3H5XTXC3H5_C2H_coeff * C3H5XTXC3H5_C3H4XPXH4C3
			);


// C2H ---------------------------------------

	 Double C2H_denom2 = CatchZero( C2H_denom1
			- C3H5XTXC3H5_C2H_coeff * C3H5XTXC3H5_C2H
			- C3H4XPXH4C3_C2H_coeff * C3H4XPXH4C3_C2H
			);

	 Double C2H_ct2 = ( C2H_ct1
			+ C3H5XTXC3H5_C2H_coeff * C3H5XTXC3H5_ct2
			+ C3H4XPXH4C3_C2H_coeff * C3H4XPXH4C3_ct2
			) / C2H_denom2;






// Reconstruction ------------------------------------

	c[sC2H] = ( C2H_ct2
			) ;

	c[sC3H4XPXH4C3] = ( C3H4XPXH4C3_ct2
			+ C3H4XPXH4C3_C2H * c[sC2H]
			) ;

	c[sC3H5XTXC3H5] = ( C3H5XTXC3H5_ct2
			+ C3H5XTXC3H5_C3H4XPXH4C3 * c[sC3H4XPXH4C3]
			+ C3H5XTXC3H5_C2H * c[sC2H]
			) ;

// c[sCH2CCH2OH] (uncoupled) --------------------

		c[sCH2CCH2OH] = ( 0
			+ k[rH257b] * c[sC3H4XAXH4C3] * c[sOH]
			+ k[rH367] * c[sIXC4H6OH] * c[sHO2]
			+ k[rH379] * c[sIXC4H7OH]
			) / ( CatchZero(
			+ k[rH257f]
			+ k[rH258] * c[sO2]
			+ k[rH259]
			) );


// c[sCH2OH] (uncoupled) --------------------

		c[sCH2OH] = ( 0
			+ k[rH80b] * c[sH] * c[sCH2O]
			+ k[rH81b] * c[sCH2O] * c[sHO2]
			+ k[rH83] * c[sCH3OH] * c[sH]
			+ k[rH84] * c[sCH3OH]
			+ k[rH86] * c[sCH3OH] * c[sO]
			+ k[rH87] * c[sCH3OH] * c[sHO2]
			+ k[rH89f] * c[sCH3OH] * c[sOH]
			+ k[rH101] * c[sCH3OH] * c[sCH3O2]
			+ k[rH157] * c[sCH2CO] * c[sOH]
			+ k[rH258] * c[sCH2CCH2OH] * c[sO2]
			+ k[rH259] * c[sCH2CCH2OH]
			+ k[rH366] * c[sIXC4H6OH]
			+ k[rL1] * c[sCH3O] * c[sCH3OH]
			+ k[rL2] * c[sCH3OH] * c[sCH3]
			) / ( CatchZero(
			+ k[rH80f]
			+ k[rH81f] * c[sO2]
			+ k[rH82] * c[sCH2O]
			+ k[rH89b] * c[sH2O]
			) );


// c[sCH3COCH2O] c[sCH3CO] c[sC2H3O1X2XC2H3O] c[sCH2CHO] c[sCH2CH2COCH3] c[sC3H6COCH3X2XC5H9O] c[sCH3CO3] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH3COCH2O_denom1 = CatchZero( 0
			+ k[rL47f]
			);

	 Double CH3CO_denom1 = CatchZero( 0
			+ k[rH163b]
			+ k[rH164] * c[sCH3]
			+ k[rH165f]
			+ k[rL15b] * c[sO2]
			+ k[rL47b] * c[sCH2O]
			+ k[rL80b] * c[sC2H4]
			+ k[rL155b] * c[sC3H6]
			);

	 Double C2H3O1X2XC2H3O_denom1 = CatchZero( 0
			+ k[rH162f]
			+ k[rH163f]
			);

	 Double CH2CHO_denom1 = CatchZero( 0
			+ k[rH160f]
			+ k[rH161] * c[sO2]
			+ k[rH162b]
			);

	 Double CH2CH2COCH3_denom1 = CatchZero( 0
			+ k[rL80f]
			);

	 Double C3H6COCH3X2XC5H9O_denom1 = CatchZero( 0
			+ k[rL155f]
			);

	 Double CH3CO3_denom1 = CatchZero( 0
			+ k[rL14] * c[sHO2]
			+ k[rL15f]
			+ k[rL16] * c[sCH2O]
			+ k[rL17f] * c[sH2O2]
			+ k[rL18] * c[sCH3CHO]
			+ k[rL33] * c[sC2H5CHO]
			+ k[rL55] * c[sNXC3H7O2]
			+ k[rL120] * c[sTXC4H9O2]
			+ k[rL126] * c[sPXC4H9O2]
			);


// Primary constant parts -----------------------

	 Double CH3COCH2O_ct1 = ( 0
			+ k[rL64] * c[sCH3COCH2O2H]
			);

	 Double CH3CO_ct1 = ( 0
			+ k[rH165b] * c[sCO] * c[sCH3]
			+ k[rH167] * c[sCH3CHO] * c[sH]
			+ k[rH168] * c[sCH3CHO] * c[sO2]
			+ k[rH169] * c[sCH3CHO] * c[sO]
			+ k[rH170] * c[sCH3CHO] * c[sCH3]
			+ k[rH171] * c[sCH3O2] * c[sCH3CHO]
			+ k[rH173] * c[sCH3CHO] * c[sHO2]
			+ k[rH174] * c[sCH3CHO] * c[sOH]
			+ k[rH214] * c[sC3H5XTXC3H5] * c[sO2]
			+ k[rH264] * c[sCH3COCH3]
			+ k[rH296] * c[sC4H8X1XC4H8] * c[sOH]
			+ k[rH298] * c[sC4H8X1XC4H8] * c[sO]
			+ k[rLLP230] * c[sC7H14O2X5XC7H14O] * c[sHO2]
			+ k[rLLP238] * c[sC7H14O2X5XC7H14O] * c[sOH]
			+ k[rL279] * c[sNEOC7KETPOXC7H14O3]
			);

	 Double C2H3O1X2XC2H3O_ct1 = ( 0
			);

	 Double CH2CHO_ct1 = ( 0
			+ k[rH124] * c[sC2H3] * c[sO2]
			+ k[rH127] * c[sC2H4] * c[sO]
			+ k[rH160b] * c[sCH2CO] * c[sH]
			+ k[rH211] * c[sC3H5XAXC3H5] * c[sO2]
			+ k[rL139] * c[sNC4KET13XC4H8O3]
			+ k[rL191] * c[sNC5KET13XC5H10O3]
			+ k[rL206] * c[sNC6KET13XC6H12O3]
			+ k[rLLP241] * c[sC7H14O2X5XC7H14O] * c[sOH]
			+ k[rLLP284] * c[sNC7KET42XC7H14O3]
			);

	 Double CH2CH2COCH3_ct1 = ( 0
			+ k[rLLP281] * c[sNC7KET25XC7H14O3]
			);

	 Double C3H6COCH3X2XC5H9O_ct1 = ( 0
			+ k[rL162] * c[sNXC3H7COCH3] * c[sOH]
			);

	 Double CH3CO3_ct1 = ( 0
			+ k[rL17b] * c[sHO2] * c[sCH3CO3H]
			);


// CH3COCH2O ---------------------------------------

	 Double CH3COCH2O_denom2 = CatchZero( CH3COCH2O_denom1
			);

	 Double CH3COCH2O_ct2 = ( CH3COCH2O_ct1
			) / CH3COCH2O_denom2;



	 Double CH3COCH2O_CH3CO = ( 0 + k[rL47b]  * c[sCH2O]
			) / CH3COCH2O_denom2 ;

	 Double CH3COCH2O_C2H3O1X2XC2H3O = ( 0 
			) / CH3COCH2O_denom2 ;

	 Double CH3COCH2O_CH2CHO = ( 0 
			) / CH3COCH2O_denom2 ;

	 Double CH3COCH2O_CH2CH2COCH3 = ( 0 
			) / CH3COCH2O_denom2 ;

	 Double CH3COCH2O_C3H6COCH3X2XC5H9O = ( 0 
			) / CH3COCH2O_denom2 ;

	 Double CH3COCH2O_CH3CO3 = ( 0 
			) / CH3COCH2O_denom2 ;



	 Double CH3COCH2O_CH3CO_coeff = ( 0 + k[rL47f] 
			);

	 Double CH3COCH2O_C2H3O1X2XC2H3O_coeff = ( 0 
			);

	 Double CH3COCH2O_CH2CHO_coeff = ( 0 
			);

	 Double CH3COCH2O_CH2CH2COCH3_coeff = ( 0 
			);

	 Double CH3COCH2O_C3H6COCH3X2XC5H9O_coeff = ( 0 
			);

	 Double CH3COCH2O_CH3CO3_coeff = ( 0 
			);


// CH3CO ---------------------------------------

	 Double CH3CO_denom2 = CatchZero( CH3CO_denom1
			- CH3COCH2O_CH3CO_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_ct2 = ( CH3CO_ct1
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_ct2
			) / CH3CO_denom2;



	 Double CH3CO_C2H3O1X2XC2H3O = ( 0 + k[rH163f] 
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			) / CH3CO_denom2 ;

	 Double CH3CO_CH2CHO = ( 0 
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_CH2CHO
			) / CH3CO_denom2 ;

	 Double CH3CO_CH2CH2COCH3 = ( 0 + k[rL80f] 
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_CH2CH2COCH3
			) / CH3CO_denom2 ;

	 Double CH3CO_C3H6COCH3X2XC5H9O = ( 0 + k[rL155f] 
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			) / CH3CO_denom2 ;

	 Double CH3CO_CH3CO3 = ( 0 + k[rL15f] + k[rL18] * c[sCH3CHO] 
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_CH3CO3
			) / CH3CO_denom2 ;



	 Double CH3CO_C2H3O1X2XC2H3O_coeff = ( 0 + k[rH163b] 
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_CH2CHO_coeff = ( 0 
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_CH2CH2COCH3_coeff = ( 0 + k[rL80b] * c[sC2H4] 
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_C3H6COCH3X2XC5H9O_coeff = ( 0 + k[rL155b] * c[sC3H6] 
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_CH3CO3_coeff = ( 0 + k[rL15b]  * c[sO2]
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_CH3CO
			);


// C2H3O1X2XC2H3O ---------------------------------------

	 Double C2H3O1X2XC2H3O_denom2 = CatchZero( C2H3O1X2XC2H3O_denom1
			- CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			- CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_C2H3O1X2XC2H3O
			);

	 Double C2H3O1X2XC2H3O_ct2 = ( C2H3O1X2XC2H3O_ct1
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_ct2
			+ CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_ct2
			) / C2H3O1X2XC2H3O_denom2;



	 Double C2H3O1X2XC2H3O_CH2CHO = ( 0 + k[rH162b] 
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_CH2CHO
			+ CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_CH2CHO
			) / C2H3O1X2XC2H3O_denom2 ;

	 Double C2H3O1X2XC2H3O_CH2CH2COCH3 = ( 0 
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_CH2CH2COCH3
			+ CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_CH2CH2COCH3
			) / C2H3O1X2XC2H3O_denom2 ;

	 Double C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O = ( 0 
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			+ CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_C3H6COCH3X2XC5H9O
			) / C2H3O1X2XC2H3O_denom2 ;

	 Double C2H3O1X2XC2H3O_CH3CO3 = ( 0 
			+ CH3COCH2O_C2H3O1X2XC2H3O_coeff * CH3COCH2O_CH3CO3
			+ CH3CO_C2H3O1X2XC2H3O_coeff * CH3CO_CH3CO3
			) / C2H3O1X2XC2H3O_denom2 ;



	 Double C2H3O1X2XC2H3O_CH2CHO_coeff = ( 0 + k[rH162f] 
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			+ CH3CO_CH2CHO_coeff * CH3CO_C2H3O1X2XC2H3O
			);

	 Double C2H3O1X2XC2H3O_CH2CH2COCH3_coeff = ( 0 
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			+ CH3CO_CH2CH2COCH3_coeff * CH3CO_C2H3O1X2XC2H3O
			);

	 Double C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff = ( 0 
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			+ CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_C2H3O1X2XC2H3O
			);

	 Double C2H3O1X2XC2H3O_CH3CO3_coeff = ( 0 
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_C2H3O1X2XC2H3O
			+ CH3CO_CH3CO3_coeff * CH3CO_C2H3O1X2XC2H3O
			);


// CH2CHO ---------------------------------------

	 Double CH2CHO_denom2 = CatchZero( CH2CHO_denom1
			- CH3COCH2O_CH2CHO_coeff * CH3COCH2O_CH2CHO
			- CH3CO_CH2CHO_coeff * CH3CO_CH2CHO
			- C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_CH2CHO
			);

	 Double CH2CHO_ct2 = ( CH2CHO_ct1
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_ct2
			+ CH3CO_CH2CHO_coeff * CH3CO_ct2
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_ct2
			) / CH2CHO_denom2;



	 Double CH2CHO_CH2CH2COCH3 = ( 0 
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_CH2CH2COCH3
			+ CH3CO_CH2CHO_coeff * CH3CO_CH2CH2COCH3
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_CH2CH2COCH3
			) / CH2CHO_denom2 ;

	 Double CH2CHO_C3H6COCH3X2XC5H9O = ( 0 
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			+ CH3CO_CH2CHO_coeff * CH3CO_C3H6COCH3X2XC5H9O
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O
			) / CH2CHO_denom2 ;

	 Double CH2CHO_CH3CO3 = ( 0 
			+ CH3COCH2O_CH2CHO_coeff * CH3COCH2O_CH3CO3
			+ CH3CO_CH2CHO_coeff * CH3CO_CH3CO3
			+ C2H3O1X2XC2H3O_CH2CHO_coeff * C2H3O1X2XC2H3O_CH3CO3
			) / CH2CHO_denom2 ;



	 Double CH2CHO_CH2CH2COCH3_coeff = ( 0 
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_CH2CHO
			+ CH3CO_CH2CH2COCH3_coeff * CH3CO_CH2CHO
			+ C2H3O1X2XC2H3O_CH2CH2COCH3_coeff * C2H3O1X2XC2H3O_CH2CHO
			);

	 Double CH2CHO_C3H6COCH3X2XC5H9O_coeff = ( 0 
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_CH2CHO
			+ CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_CH2CHO
			+ C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff * C2H3O1X2XC2H3O_CH2CHO
			);

	 Double CH2CHO_CH3CO3_coeff = ( 0 
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_CH2CHO
			+ CH3CO_CH3CO3_coeff * CH3CO_CH2CHO
			+ C2H3O1X2XC2H3O_CH3CO3_coeff * C2H3O1X2XC2H3O_CH2CHO
			);


// CH2CH2COCH3 ---------------------------------------

	 Double CH2CH2COCH3_denom2 = CatchZero( CH2CH2COCH3_denom1
			- CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_CH2CH2COCH3
			- CH3CO_CH2CH2COCH3_coeff * CH3CO_CH2CH2COCH3
			- C2H3O1X2XC2H3O_CH2CH2COCH3_coeff * C2H3O1X2XC2H3O_CH2CH2COCH3
			- CH2CHO_CH2CH2COCH3_coeff * CH2CHO_CH2CH2COCH3
			);

	 Double CH2CH2COCH3_ct2 = ( CH2CH2COCH3_ct1
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_ct2
			+ CH3CO_CH2CH2COCH3_coeff * CH3CO_ct2
			+ C2H3O1X2XC2H3O_CH2CH2COCH3_coeff * C2H3O1X2XC2H3O_ct2
			+ CH2CHO_CH2CH2COCH3_coeff * CH2CHO_ct2
			) / CH2CH2COCH3_denom2;



	 Double CH2CH2COCH3_C3H6COCH3X2XC5H9O = ( 0 
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			+ CH3CO_CH2CH2COCH3_coeff * CH3CO_C3H6COCH3X2XC5H9O
			+ C2H3O1X2XC2H3O_CH2CH2COCH3_coeff * C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O
			+ CH2CHO_CH2CH2COCH3_coeff * CH2CHO_C3H6COCH3X2XC5H9O
			) / CH2CH2COCH3_denom2 ;

	 Double CH2CH2COCH3_CH3CO3 = ( 0 
			+ CH3COCH2O_CH2CH2COCH3_coeff * CH3COCH2O_CH3CO3
			+ CH3CO_CH2CH2COCH3_coeff * CH3CO_CH3CO3
			+ C2H3O1X2XC2H3O_CH2CH2COCH3_coeff * C2H3O1X2XC2H3O_CH3CO3
			+ CH2CHO_CH2CH2COCH3_coeff * CH2CHO_CH3CO3
			) / CH2CH2COCH3_denom2 ;



	 Double CH2CH2COCH3_C3H6COCH3X2XC5H9O_coeff = ( 0 
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_CH2CH2COCH3
			+ CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_CH2CH2COCH3
			+ C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff * C2H3O1X2XC2H3O_CH2CH2COCH3
			+ CH2CHO_C3H6COCH3X2XC5H9O_coeff * CH2CHO_CH2CH2COCH3
			);

	 Double CH2CH2COCH3_CH3CO3_coeff = ( 0 
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_CH2CH2COCH3
			+ CH3CO_CH3CO3_coeff * CH3CO_CH2CH2COCH3
			+ C2H3O1X2XC2H3O_CH3CO3_coeff * C2H3O1X2XC2H3O_CH2CH2COCH3
			+ CH2CHO_CH3CO3_coeff * CH2CHO_CH2CH2COCH3
			);


// C3H6COCH3X2XC5H9O ---------------------------------------

	 Double C3H6COCH3X2XC5H9O_denom2 = CatchZero( C3H6COCH3X2XC5H9O_denom1
			- CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			- CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_C3H6COCH3X2XC5H9O
			- C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff * C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O
			- CH2CHO_C3H6COCH3X2XC5H9O_coeff * CH2CHO_C3H6COCH3X2XC5H9O
			- CH2CH2COCH3_C3H6COCH3X2XC5H9O_coeff * CH2CH2COCH3_C3H6COCH3X2XC5H9O
			);

	 Double C3H6COCH3X2XC5H9O_ct2 = ( C3H6COCH3X2XC5H9O_ct1
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_ct2
			+ CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_ct2
			+ C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff * C2H3O1X2XC2H3O_ct2
			+ CH2CHO_C3H6COCH3X2XC5H9O_coeff * CH2CHO_ct2
			+ CH2CH2COCH3_C3H6COCH3X2XC5H9O_coeff * CH2CH2COCH3_ct2
			) / C3H6COCH3X2XC5H9O_denom2;



	 Double C3H6COCH3X2XC5H9O_CH3CO3 = ( 0 
			+ CH3COCH2O_C3H6COCH3X2XC5H9O_coeff * CH3COCH2O_CH3CO3
			+ CH3CO_C3H6COCH3X2XC5H9O_coeff * CH3CO_CH3CO3
			+ C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O_coeff * C2H3O1X2XC2H3O_CH3CO3
			+ CH2CHO_C3H6COCH3X2XC5H9O_coeff * CH2CHO_CH3CO3
			+ CH2CH2COCH3_C3H6COCH3X2XC5H9O_coeff * CH2CH2COCH3_CH3CO3
			) / C3H6COCH3X2XC5H9O_denom2 ;



	 Double C3H6COCH3X2XC5H9O_CH3CO3_coeff = ( 0 
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_C3H6COCH3X2XC5H9O
			+ CH3CO_CH3CO3_coeff * CH3CO_C3H6COCH3X2XC5H9O
			+ C2H3O1X2XC2H3O_CH3CO3_coeff * C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O
			+ CH2CHO_CH3CO3_coeff * CH2CHO_C3H6COCH3X2XC5H9O
			+ CH2CH2COCH3_CH3CO3_coeff * CH2CH2COCH3_C3H6COCH3X2XC5H9O
			);


// CH3CO3 ---------------------------------------

	 Double CH3CO3_denom2 = CatchZero( CH3CO3_denom1
			- CH3COCH2O_CH3CO3_coeff * CH3COCH2O_CH3CO3
			- CH3CO_CH3CO3_coeff * CH3CO_CH3CO3
			- C2H3O1X2XC2H3O_CH3CO3_coeff * C2H3O1X2XC2H3O_CH3CO3
			- CH2CHO_CH3CO3_coeff * CH2CHO_CH3CO3
			- CH2CH2COCH3_CH3CO3_coeff * CH2CH2COCH3_CH3CO3
			- C3H6COCH3X2XC5H9O_CH3CO3_coeff * C3H6COCH3X2XC5H9O_CH3CO3
			);

	 Double CH3CO3_ct2 = ( CH3CO3_ct1
			+ CH3COCH2O_CH3CO3_coeff * CH3COCH2O_ct2
			+ CH3CO_CH3CO3_coeff * CH3CO_ct2
			+ C2H3O1X2XC2H3O_CH3CO3_coeff * C2H3O1X2XC2H3O_ct2
			+ CH2CHO_CH3CO3_coeff * CH2CHO_ct2
			+ CH2CH2COCH3_CH3CO3_coeff * CH2CH2COCH3_ct2
			+ C3H6COCH3X2XC5H9O_CH3CO3_coeff * C3H6COCH3X2XC5H9O_ct2
			) / CH3CO3_denom2;






// Reconstruction ------------------------------------

	c[sCH3CO3] = ( CH3CO3_ct2
			) ;

	c[sC3H6COCH3X2XC5H9O] = ( C3H6COCH3X2XC5H9O_ct2
			+ C3H6COCH3X2XC5H9O_CH3CO3 * c[sCH3CO3]
			) ;

	c[sCH2CH2COCH3] = ( CH2CH2COCH3_ct2
			+ CH2CH2COCH3_C3H6COCH3X2XC5H9O * c[sC3H6COCH3X2XC5H9O]
			+ CH2CH2COCH3_CH3CO3 * c[sCH3CO3]
			) ;

	c[sCH2CHO] = ( CH2CHO_ct2
			+ CH2CHO_CH2CH2COCH3 * c[sCH2CH2COCH3]
			+ CH2CHO_C3H6COCH3X2XC5H9O * c[sC3H6COCH3X2XC5H9O]
			+ CH2CHO_CH3CO3 * c[sCH3CO3]
			) ;

	c[sC2H3O1X2XC2H3O] = ( C2H3O1X2XC2H3O_ct2
			+ C2H3O1X2XC2H3O_CH2CHO * c[sCH2CHO]
			+ C2H3O1X2XC2H3O_CH2CH2COCH3 * c[sCH2CH2COCH3]
			+ C2H3O1X2XC2H3O_C3H6COCH3X2XC5H9O * c[sC3H6COCH3X2XC5H9O]
			+ C2H3O1X2XC2H3O_CH3CO3 * c[sCH3CO3]
			) ;

	c[sCH3CO] = ( CH3CO_ct2
			+ CH3CO_C2H3O1X2XC2H3O * c[sC2H3O1X2XC2H3O]
			+ CH3CO_CH2CHO * c[sCH2CHO]
			+ CH3CO_CH2CH2COCH3 * c[sCH2CH2COCH3]
			+ CH3CO_C3H6COCH3X2XC5H9O * c[sC3H6COCH3X2XC5H9O]
			+ CH3CO_CH3CO3 * c[sCH3CO3]
			) ;

	c[sCH3COCH2O] = ( CH3COCH2O_ct2
			+ CH3COCH2O_CH3CO * c[sCH3CO]
			+ CH3COCH2O_C2H3O1X2XC2H3O * c[sC2H3O1X2XC2H3O]
			+ CH3COCH2O_CH2CHO * c[sCH2CHO]
			+ CH3COCH2O_CH2CH2COCH3 * c[sCH2CH2COCH3]
			+ CH3COCH2O_C3H6COCH3X2XC5H9O * c[sC3H6COCH3X2XC5H9O]
			+ CH3COCH2O_CH3CO3 * c[sCH3CO3]
			) ;

// c[sCH3CO2] (uncoupled) --------------------

		c[sCH3CO2] = ( 0
			+ k[rL7b] * c[sCH3] * c[sCO2] * M[mM5]
			+ k[rL19] * c[sCH3CO3H]
			+ k[rL55] * c[sNXC3H7O2] * c[sCH3CO3]
			+ k[rL120] * c[sTXC4H9O2] * c[sCH3CO3]
			+ k[rL126] * c[sPXC4H9O2] * c[sCH3CO3]
			) / ( CatchZero(
			+ k[rL7f] * M[mM5]
			) );


// c[sPXC4H9O] (uncoupled) --------------------

		c[sPXC4H9O] = ( 0
			+ k[rL73] * c[sNXC3H7O2] * c[sPXC4H9]
			+ k[rL74] * c[sCH3O2] * c[sPXC4H9]
			+ k[rL75] * c[sPXC4H9] * c[sHO2]
			+ k[rL125] * 2.0 * c[sPXC4H9O2] * c[sPXC4H9]
			+ k[rL126] * c[sPXC4H9O2] * c[sCH3CO3]
			+ k[rL127] * 2.0 * c[sPXC4H9O2] * c[sPXC4H9O2]
			+ k[rL128] * c[sPXC4H9O2] * c[sC2H5]
			+ k[rL129] * c[sPXC4H9O2] * c[sNXC3H7O2]
			+ k[rL130] * c[sPXC4H9O2] * c[sCH3]
			+ k[rL131] * c[sPXC4H9O2] * c[sC2H5O2]
			+ k[rL132] * c[sPXC4H9O2] * c[sCH3O2]
			+ k[rL133] * c[sPXC4H9O2] * c[sNXC3H7]
			) / ( CatchZero(
			+ k[rL107]
			) );


// c[sCH] c[sCH2GSGXCH2] c[sHCCO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH_denom1 = CatchZero( 0
			+ k[rH21] * c[sO2]
			+ k[rH23b] * c[sH2O]
			+ k[rH25b] * c[sH2]
			+ k[rH34b] * c[sH2]
			+ k[rH54] * c[sCH4]
			);

	 Double CH2GSGXCH2_denom1 = CatchZero( 0
			+ k[rH29] * c[sO]
			+ k[rH30] * c[sOH]
			+ k[rH31f] * c[sH2]
			+ k[rH32f] * M[mM5]
			+ k[rH33] * c[sO2]
			+ k[rH34f] * c[sH]
			+ k[rH36b] * c[sH2O]
			+ k[rH39] * c[sCH3]
			+ k[rH56f] * c[sCH4]
			+ k[rH90] * c[sCO2]
			+ k[rH146] * c[sC2H6]
			+ k[rH149b] * c[sCO]
			+ k[rH153] * c[sCH2CO]
			);

	 Double HCCO_denom1 = CatchZero( 0
			+ k[rH148] * c[sO2]
			+ k[rH149f] * c[sH]
			+ k[rH150] * c[sOH]
			+ k[rH151] * c[sO]
			+ k[rH152b] * c[sH2O]
			+ k[rH158b] * c[sH2]
			);


// Primary constant parts -----------------------

	 Double CH_ct1 = ( 0
			+ k[rH23f] * c[sCH2] * c[sOH]
			+ k[rH25f] * c[sCH2] * c[sH]
			+ k[rH110] * c[sC2H] * c[sO]
			);

	 Double CH2GSGXCH2_ct1 = ( 0
			+ k[rH31b] * c[sCH3] * c[sH]
			+ k[rH32b] * c[sCH2] * M[mM5]
			+ k[rH36f] * c[sCH3] * c[sOH]
			+ k[rH56b] * c[sCH3] * c[sCH3]
			);

	 Double HCCO_ct1 = ( 0
			+ k[rH113] * c[sC2H2] * c[sO]
			+ k[rH114] * c[sC2H2] * c[sO2]
			+ k[rH152f] * c[sCH2CO] * c[sOH]
			+ k[rH155] * c[sCH2CO] * c[sO]
			+ k[rH158f] * c[sCH2CO] * c[sH]
			+ k[rH181] * c[sC3H2] * c[sO2]
			);


// CH ---------------------------------------

	 Double CH_denom2 = CatchZero( CH_denom1
			);

	 Double CH_ct2 = ( CH_ct1
			) / CH_denom2;



	 Double CH_CH2GSGXCH2 = ( 0 + k[rH34f]  * c[sH]
			) / CH_denom2 ;

	 Double CH_HCCO = ( 0 
			) / CH_denom2 ;



	 Double CH_CH2GSGXCH2_coeff = ( 0 + k[rH34b]  * c[sH2]
			);

	 Double CH_HCCO_coeff = ( 0 
			);


// CH2GSGXCH2 ---------------------------------------

	 Double CH2GSGXCH2_denom2 = CatchZero( CH2GSGXCH2_denom1
			- CH_CH2GSGXCH2_coeff * CH_CH2GSGXCH2
			);

	 Double CH2GSGXCH2_ct2 = ( CH2GSGXCH2_ct1
			+ CH_CH2GSGXCH2_coeff * CH_ct2
			) / CH2GSGXCH2_denom2;



	 Double CH2GSGXCH2_HCCO = ( 0 + k[rH149f]  * c[sH]
			+ CH_CH2GSGXCH2_coeff * CH_HCCO
			) / CH2GSGXCH2_denom2 ;



	 Double CH2GSGXCH2_HCCO_coeff = ( 0 + k[rH149b]  * c[sCO]
			+ CH_HCCO_coeff * CH_CH2GSGXCH2
			);


// HCCO ---------------------------------------

	 Double HCCO_denom2 = CatchZero( HCCO_denom1
			- CH_HCCO_coeff * CH_HCCO
			- CH2GSGXCH2_HCCO_coeff * CH2GSGXCH2_HCCO
			);

	 Double HCCO_ct2 = ( HCCO_ct1
			+ CH_HCCO_coeff * CH_ct2
			+ CH2GSGXCH2_HCCO_coeff * CH2GSGXCH2_ct2
			) / HCCO_denom2;






// Reconstruction ------------------------------------

	c[sHCCO] = ( HCCO_ct2
			) ;

	c[sCH2GSGXCH2] = ( CH2GSGXCH2_ct2
			+ CH2GSGXCH2_HCCO * c[sHCCO]
			) ;

	c[sCH] = ( CH_ct2
			+ CH_CH2GSGXCH2 * c[sCH2GSGXCH2]
			+ CH_HCCO * c[sHCCO]
			) ;

// c[sO2C2H4OH] c[sPXC2H4OH] (coupled)  --------------------

// Primary denominators-----------------------

	 Double O2C2H4OH_denom1 = CatchZero( 0
			+ k[rL20f]
			+ k[rL21]
			);

	 Double PXC2H4OH_denom1 = CatchZero( 0
			+ k[rL6f]
			+ k[rL20b] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double O2C2H4OH_ct1 = ( 0
			);

	 Double PXC2H4OH_ct1 = ( 0
			+ k[rL6b] * c[sC2H4] * c[sOH]
			);


// O2C2H4OH ---------------------------------------

	 Double O2C2H4OH_denom2 = CatchZero( O2C2H4OH_denom1
			);

	 Double O2C2H4OH_ct2 = ( O2C2H4OH_ct1
			) / O2C2H4OH_denom2;



	 Double O2C2H4OH_PXC2H4OH = ( 0 + k[rL20b]  * c[sO2]
			) / O2C2H4OH_denom2 ;



	 Double O2C2H4OH_PXC2H4OH_coeff = ( 0 + k[rL20f] 
			);


// PXC2H4OH ---------------------------------------

	 Double PXC2H4OH_denom2 = CatchZero( PXC2H4OH_denom1
			- O2C2H4OH_PXC2H4OH_coeff * O2C2H4OH_PXC2H4OH
			);

	 Double PXC2H4OH_ct2 = ( PXC2H4OH_ct1
			+ O2C2H4OH_PXC2H4OH_coeff * O2C2H4OH_ct2
			) / PXC2H4OH_denom2;






// Reconstruction ------------------------------------

	c[sPXC2H4OH] = ( PXC2H4OH_ct2
			) ;

	c[sO2C2H4OH] = ( O2C2H4OH_ct2
			+ O2C2H4OH_PXC2H4OH * c[sPXC2H4OH]
			) ;

// c[sIC4H8O2HXTXC4H9O2] c[sIC4H8OOHXTO2XC4H9O4] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IC4H8O2HXTXC4H9O2_denom1 = CatchZero( 0
			+ k[rHLP382b]
			+ k[rHLP394]
			+ k[rHLP395f]
			+ k[rLLP147b] * c[sO2]
			+ k[rLLP149]
			);

	 Double IC4H8OOHXTO2XC4H9O4_denom1 = CatchZero( 0
			+ k[rLLP147f]
			+ k[rLLP148]
			);


// Primary constant parts -----------------------

	 Double IC4H8O2HXTXC4H9O2_ct1 = ( 0
			+ k[rHLP382f] * c[sIXC4H9O2]
			+ k[rHLP395b] * c[sIXC4H8] * c[sHO2]
			);

	 Double IC4H8OOHXTO2XC4H9O4_ct1 = ( 0
			);


// IC4H8O2HXTXC4H9O2 ---------------------------------------

	 Double IC4H8O2HXTXC4H9O2_denom2 = CatchZero( IC4H8O2HXTXC4H9O2_denom1
			);

	 Double IC4H8O2HXTXC4H9O2_ct2 = ( IC4H8O2HXTXC4H9O2_ct1
			) / IC4H8O2HXTXC4H9O2_denom2;



	 Double IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4 = ( 0 + k[rLLP147f] 
			) / IC4H8O2HXTXC4H9O2_denom2 ;



	 Double IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff = ( 0 + k[rLLP147b]  * c[sO2]
			);


// IC4H8OOHXTO2XC4H9O4 ---------------------------------------

	 Double IC4H8OOHXTO2XC4H9O4_denom2 = CatchZero( IC4H8OOHXTO2XC4H9O4_denom1
			- IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff * IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4
			);

	 Double IC4H8OOHXTO2XC4H9O4_ct2 = ( IC4H8OOHXTO2XC4H9O4_ct1
			+ IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff * IC4H8O2HXTXC4H9O2_ct2
			) / IC4H8OOHXTO2XC4H9O4_denom2;






// Reconstruction ------------------------------------

	c[sIC4H8OOHXTO2XC4H9O4] = ( IC4H8OOHXTO2XC4H9O4_ct2
			) ;

	c[sIC4H8O2HXTXC4H9O2] = ( IC4H8O2HXTXC4H9O2_ct2
			+ IC4H8O2HXTXC4H9O2_IC4H8OOHXTO2XC4H9O4 * c[sIC4H8OOHXTO2XC4H9O4]
			) ;

// c[sIC4KETITXC4H8O3] (uncoupled) --------------------

		c[sIC4KETITXC4H8O3] = ( 0
			+ k[rLLP148] * c[sIC4H8OOHXTO2XC4H9O4]
			) / ( CatchZero(
			+ k[rLLP140]
			+ k[rLLP141]
			) );


// c[sC2H5CO] (uncoupled) --------------------

		c[sC2H5CO] = ( 0
			+ k[rL28b] * c[sC2H5] * c[sCO]
			+ k[rL33] * c[sC2H5CHO] * c[sCH3CO3]
			+ k[rL34] * c[sC2H5CHO] * c[sCH3]
			+ k[rL35] * c[sC2H5CHO] * c[sOH]
			+ k[rL36] * c[sC2H5CHO] * c[sH]
			+ k[rL37] * c[sC2H5CHO] * c[sO]
			+ k[rL38] * c[sC2H5CHO] * c[sCH3O]
			+ k[rL39] * c[sC2H5CHO] * c[sCH3O2]
			+ k[rL40] * c[sC2H5CHO] * c[sC2H5O2]
			+ k[rL41] * c[sC2H5CHO] * c[sC2H5]
			+ k[rL43] * c[sC2H5CHO] * c[sC3H5XAXC3H5]
			+ k[rL44] * c[sC2H5CHO] * c[sHO2]
			+ k[rL65] * c[sC2H5CHO] * c[sC4H7]
			+ k[rL67] * c[sC4H8X1XC4H8] * c[sO]
			+ k[rL69] * c[sC4H8X1XC4H8] * c[sOH]
			+ k[rLLP140] * c[sIC4KETITXC4H8O3]
			+ k[rL154] * c[sC2H5COC2H4PXC5H9O]
			+ k[rLLP228] * c[sC7H14O2X5XC7H14O] * c[sOH]
			) / ( CatchZero(
			+ k[rL28f]
			) );


// c[sC4H8OOH1X3XC4H9O2] (uncoupled) --------------------

		c[sC4H8OOH1X3XC4H9O2] = ( 0
			+ k[rH392f] * c[sPXC4H9O2]
			+ k[rL145f] * c[sC4H8OOH1X3O2XC4H9O4]
			) / ( CatchZero(
			+ k[rH381]
			+ k[rH392b]
			+ k[rL145b] * c[sO2]
			) );


// c[sNXC3H7O] (uncoupled) --------------------

		c[sNXC3H7O] = ( 0
			+ k[rL23] * c[sCH3O2] * c[sNXC3H7]
			+ k[rL24] * c[sNXC3H7] * c[sHO2]
			+ k[rL46b] * c[sC2H5CHO] * c[sH]
			+ k[rL51] * c[sNXC3H7O2] * c[sCH3]
			+ k[rL52] * c[sNXC3H7O2] * c[sC2H5O2]
			+ k[rL54] * 2.0 * c[sNXC3H7O2] * c[sNXC3H7O2]
			+ k[rL55] * c[sNXC3H7O2] * c[sCH3CO3]
			+ k[rL56] * 2.0 * c[sNXC3H7O2] * c[sNXC3H7]
			+ k[rL57] * c[sNXC3H7O2] * c[sC3H5XAXC3H5]
			+ k[rL58] * c[sNXC3H7O2] * c[sCH3O2]
			+ k[rL59] * c[sNXC3H7O2] * c[sC2H5]
			+ k[rL73] * c[sNXC3H7O2] * c[sPXC4H9]
			+ k[rL129] * c[sPXC4H9O2] * c[sNXC3H7O2]
			+ k[rL133] * c[sPXC4H9O2] * c[sNXC3H7]
			) / ( CatchZero(
			+ k[rL45]
			+ k[rL46f]
			) );


// c[sYXC7H15] (uncoupled) --------------------

		c[sYXC7H15] = ( 0
			+ k[rHLP432b] * c[sYXC7H14] * c[sH]
			+ k[rHLP452] * c[sIXC8H18]
			+ k[rLLP271f] * c[sYXC7H15O2]
			+ k[rLLP302] * c[sDXC8H17O]
			) / ( CatchZero(
			+ k[rHLP431]
			+ k[rHLP432f]
			+ k[rHLP433]
			+ k[rLLP221] * c[sCH3O2]
			+ k[rLLP222]
			+ k[rLLP223] * c[sHO2]
			+ k[rLLP269] * c[sYXC7H15O2]
			+ k[rLLP271b] * c[sO2]
			) );


// c[sPXC7H15O] (uncoupled) --------------------

		c[sPXC7H15O] = ( 0
			+ k[rLLP221] * c[sYXC7H15] * c[sCH3O2]
			+ k[rLLP223] * c[sYXC7H15] * c[sHO2]
			+ k[rLLP267] * c[sYXC7H15O2] * c[sCH3O2]
			+ k[rLLP268] * 2.0 * c[sYXC7H15O2] * c[sYXC7H15O2]
			+ k[rLLP269] * 2.0 * c[sYXC7H15] * c[sYXC7H15O2]
			+ k[rLLP278] * c[sYXC7H15O2H]
			) / ( CatchZero(
			+ k[rLLP246]
			+ k[rLLP247]
			) );


// c[sNEOXC5H11] (uncoupled) --------------------

		c[sNEOXC5H11] = ( 0
			+ k[rH408b] * c[sIXC4H8] * c[sCH3]
			+ k[rHLP450] * c[sCXC8H17]
			+ k[rH456] * c[sIXC8H18]
			+ k[rL188f] * c[sNEOXC5H11O2]
			+ k[rLLP246] * c[sPXC7H15O]
			+ k[rLLP293] * c[sJXC8H16] * c[sOH]
			+ k[rLLP304] * c[sDXC8H17O]
			) / ( CatchZero(
			+ k[rH408f]
			+ k[rL150] * c[sCH3O2]
			+ k[rL151] * c[sHO2]
			+ k[rL185] * c[sNEOXC5H11O2]
			+ k[rL188b] * c[sO2]
			) );


// c[sNEOXC5H11O] (uncoupled) --------------------

		c[sNEOXC5H11O] = ( 0
			+ k[rL150] * c[sNEOXC5H11] * c[sCH3O2]
			+ k[rL151] * c[sNEOXC5H11] * c[sHO2]
			+ k[rL184] * c[sNEOXC5H11O2] * c[sCH3O2]
			+ k[rL185] * 2.0 * c[sNEOXC5H11] * c[sNEOXC5H11O2]
			+ k[rL189] * 2.0 * c[sNEOXC5H11O2] * c[sNEOXC5H11O2]
			+ k[rL190] * c[sNEOXC5H11O2H]
			) / ( CatchZero(
			+ k[rL172]
			) );


// c[sTXC4H9CO] c[sTXC4H9] (coupled)  --------------------

// Primary denominators-----------------------

	 Double TXC4H9CO_denom1 = CatchZero( 0
			+ k[rL160f]
			);

	 Double TXC4H9_denom1 = CatchZero( 0
			+ k[rH320f]
			+ k[rH321] * c[sHO2]
			+ k[rH322] * c[sCH3O2]
			+ k[rH324b] * c[sH]
			+ k[rH326b] * c[sH2]
			+ k[rH328b] * c[sCH4]
			+ k[rH330b] * c[sH2O]
			+ k[rH333b] * c[sC2H6]
			+ k[rH335b] * c[sH2O2]
			+ k[rH336b] * c[sOH]
			+ k[rH339b] * c[sCH3OH]
			+ k[rH341b] * c[sHO2]
			+ k[rH387b] * c[sO2]
			+ k[rH390] * c[sTXC4H9O2]
			+ k[rHLP422b] * c[sC3H5XAXC3H5]
			+ k[rL114] * c[sIXC4H9O2]
			+ k[rL160b] * c[sCO]
			+ k[rLLP225b] * c[sCH3CHCO]
			);


// Primary constant parts -----------------------

	 Double TXC4H9CO_ct1 = ( 0
			+ k[rL170] * c[sTXC4H9CHO] * c[sOH]
			+ k[rL171] * c[sTXC4H9CHO] * c[sHO2]
			+ k[rLLP300] * c[sIC8ETERACXC8H16O] * c[sOH]
			+ k[rLLP328] * c[sIC8KETBCXC8H16O3]
			);

	 Double TXC4H9_ct1 = ( 0
			+ k[rH320b] * c[sH] * c[sIXC4H8]
			+ k[rH324f] * c[sIXC4H10]
			+ k[rH326f] * c[sIXC4H10] * c[sH]
			+ k[rH328f] * c[sIXC4H10] * c[sCH3]
			+ k[rH330f] * c[sIXC4H10] * c[sOH]
			+ k[rH333f] * c[sIXC4H10] * c[sC2H5]
			+ k[rH335f] * c[sIXC4H10] * c[sHO2]
			+ k[rH336f] * c[sIXC4H10] * c[sO]
			+ k[rH339f] * c[sIXC4H10] * c[sCH3O]
			+ k[rH341f] * c[sIXC4H10] * c[sO2]
			+ k[rH387f] * c[sTXC4H9O2]
			+ k[rHLP422f] * c[sYXC7H14]
			+ k[rHLP431] * c[sYXC7H15]
			+ k[rHLP447] * c[sCXC8H17]
			+ k[rH453] * c[sIXC8H18]
			+ k[rL172] * c[sNEOXC5H11O]
			+ k[rLLP225f] * c[sIC3H7COC3H6XTXC7H13O]
			+ k[rLLP303] * c[sDXC8H17O]
			+ k[rLLP315] * c[sAC8H16OOHXBXC8H17O2]
			);


// TXC4H9CO ---------------------------------------

	 Double TXC4H9CO_denom2 = CatchZero( TXC4H9CO_denom1
			);

	 Double TXC4H9CO_ct2 = ( TXC4H9CO_ct1
			) / TXC4H9CO_denom2;



	 Double TXC4H9CO_TXC4H9 = ( 0 + k[rL160b]  * c[sCO]
			) / TXC4H9CO_denom2 ;



	 Double TXC4H9CO_TXC4H9_coeff = ( 0 + k[rL160f] 
			);


// TXC4H9 ---------------------------------------

	 Double TXC4H9_denom2 = CatchZero( TXC4H9_denom1
			- TXC4H9CO_TXC4H9_coeff * TXC4H9CO_TXC4H9
			);

	 Double TXC4H9_ct2 = ( TXC4H9_ct1
			+ TXC4H9CO_TXC4H9_coeff * TXC4H9CO_ct2
			) / TXC4H9_denom2;






// Reconstruction ------------------------------------

	c[sTXC4H9] = ( TXC4H9_ct2
			) ;

	c[sTXC4H9CO] = ( TXC4H9CO_ct2
			+ TXC4H9CO_TXC4H9 * c[sTXC4H9]
			) ;

// c[sIXC5H9] c[sBXC6H12] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC5H9_denom1 = CatchZero( 0
			+ k[rH398]
			+ k[rL200b] * c[sCH3]
			);

	 Double BXC6H12_denom1 = CatchZero( 0
			+ k[rL199] * c[sCH3]
			+ k[rL200f]
			+ k[rL201] * c[sOH]
			+ k[rL202] * c[sH]
			);


// Primary constant parts -----------------------

	 Double IXC5H9_ct1 = ( 0
			+ k[rH399] * c[sAXC5H10] * c[sO]
			+ k[rH400] * c[sAXC5H10] * c[sCH3]
			);

	 Double BXC6H12_ct1 = ( 0
			+ k[rLLP222] * c[sYXC7H15]
			);


// IXC5H9 ---------------------------------------

	 Double IXC5H9_denom2 = CatchZero( IXC5H9_denom1
			);

	 Double IXC5H9_ct2 = ( IXC5H9_ct1
			) / IXC5H9_denom2;



	 Double IXC5H9_BXC6H12 = ( 0 + k[rL200f] 
			) / IXC5H9_denom2 ;



	 Double IXC5H9_BXC6H12_coeff = ( 0 + k[rL200b] * c[sCH3] 
			);


// BXC6H12 ---------------------------------------

	 Double BXC6H12_denom2 = CatchZero( BXC6H12_denom1
			- IXC5H9_BXC6H12_coeff * IXC5H9_BXC6H12
			);

	 Double BXC6H12_ct2 = ( BXC6H12_ct1
			+ IXC5H9_BXC6H12_coeff * IXC5H9_ct2
			) / BXC6H12_denom2;






// Reconstruction ------------------------------------

	c[sBXC6H12] = ( BXC6H12_ct2
			) ;

	c[sIXC5H9] = ( IXC5H9_ct2
			+ IXC5H9_BXC6H12 * c[sBXC6H12]
			) ;

// c[sIXC6H11] (uncoupled) --------------------

		c[sIXC6H11] = ( 0
			+ k[rL199] * c[sBXC6H12] * c[sCH3]
			+ k[rL201] * c[sBXC6H12] * c[sOH]
			+ k[rL202] * c[sBXC6H12] * c[sH]
			+ k[rLLP217f] * c[sYXC7H14]
			+ k[rLLP224] * c[sXC7H13OXZXC7H13O]
			) / ( CatchZero(
			+ k[rL198]
			+ k[rLLP217b] * c[sCH3]
			) );


// c[sIXC4H9] (uncoupled) --------------------

		c[sIXC4H9] = ( 0
			+ k[rH316b] * c[sIXC4H8] * c[sH]
			+ k[rH317b] * c[sC3H6] * c[sCH3]
			+ k[rH325f] * c[sIXC4H10]
			+ k[rH327f] * c[sIXC4H10] * c[sH]
			+ k[rH329f] * c[sIXC4H10] * c[sCH3]
			+ k[rH331f] * c[sIXC4H10] * c[sOH]
			+ k[rH332f] * c[sIXC4H10] * c[sC2H5]
			+ k[rH334f] * c[sIXC4H10] * c[sHO2]
			+ k[rH337f] * c[sIXC4H10] * c[sO]
			+ k[rH338f] * c[sIXC4H10] * c[sCH3O]
			+ k[rH340f] * c[sIXC4H10] * c[sO2]
			+ k[rH383f] * c[sIXC4H9O2]
			+ k[rHLP449] * c[sCXC8H17]
			+ k[rH453] * c[sIXC8H18]
			+ k[rLLP247] * c[sPXC7H15O]
			) / ( CatchZero(
			+ k[rH316f]
			+ k[rH317f]
			+ k[rH325b] * c[sH]
			+ k[rH327b] * c[sH2]
			+ k[rH329b] * c[sCH4]
			+ k[rH331b] * c[sH2O]
			+ k[rH332b] * c[sC2H6]
			+ k[rH334b] * c[sH2O2]
			+ k[rH337b] * c[sOH]
			+ k[rH338b] * c[sCH3OH]
			+ k[rH340b] * c[sHO2]
			+ k[rH383b] * c[sO2]
			+ k[rL71] * c[sHO2]
			+ k[rL72] * c[sCH3O2]
			+ k[rL116] * c[sIXC4H9O2]
			) );


// c[sIXC4H9O] (uncoupled) --------------------

		c[sIXC4H9O] = ( 0
			+ k[rL71] * c[sIXC4H9] * c[sHO2]
			+ k[rL72] * c[sCH3O2] * c[sIXC4H9]
			+ k[rL106b] * c[sIXC3H7CHO] * c[sH]
			+ k[rL110] * 2.0 * c[sIXC4H9O2] * c[sIXC4H9O2]
			+ k[rL112] * c[sIXC4H9O2] * c[sCH3]
			+ k[rL113] * c[sIXC4H9O2] * c[sCH3O2]
			+ k[rL114] * c[sIXC4H9O2] * c[sTXC4H9]
			+ k[rL116] * 2.0 * c[sIXC4H9O2] * c[sIXC4H9]
			+ k[rL118] * c[sIXC4H9O2] * c[sIXC4H7]
			+ k[rL119] * c[sIXC4H9O2] * c[sTXC4H9O2]
			+ k[rL134] * c[sIXC4H9O2H]
			) / ( CatchZero(
			+ k[rL105]
			+ k[rL106f]
			) );


// c[sTXC4H9O] (uncoupled) --------------------

		c[sTXC4H9O] = ( 0
			+ k[rH321] * c[sTXC4H9] * c[sHO2]
			+ k[rH322] * c[sCH3O2] * c[sTXC4H9]
			+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
			+ k[rH385] * c[sTXC4H9O2] * c[sCH3]
			+ k[rH386] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
			+ k[rH388] * c[sTXC4H9O2] * c[sCH3O2]
			+ k[rH390] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9]
			+ k[rL114] * c[sIXC4H9O2] * c[sTXC4H9]
			+ k[rL119] * c[sIXC4H9O2] * c[sTXC4H9O2]
			+ k[rL120] * c[sTXC4H9O2] * c[sCH3CO3]
			+ k[rL135] * c[sTXC4H9O2H]
			) / ( CatchZero(
			+ k[rH380]
			) );


// c[sIXC3H7] c[sIXC3H7CO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC3H7_denom1 = CatchZero( 0
			+ k[rH228f]
			+ k[rH229] * c[sO2]
			+ k[rH234b] * c[sHO2]
			+ k[rH236b] * c[sH2]
			+ k[rH238b] * c[sOH]
			+ k[rH241b] * c[sH2O]
			+ k[rH242b] * c[sH2O2]
			+ k[rH244b] * c[sCH4]
			+ k[rH265b] * c[sO2]
			+ k[rH323b] * c[sCH3]
			+ k[rHLP421b] * c[sIXC4H7]
			+ k[rL81b] * c[sCO]
			+ k[rLLP226b] * c[sIXC3H6CO]
			);

	 Double IXC3H7CO_denom1 = CatchZero( 0
			+ k[rL81f]
			);


// Primary constant parts -----------------------

	 Double IXC3H7_ct1 = ( 0
			+ k[rH228b] * c[sH] * c[sC3H6]
			+ k[rH234f] * c[sC3H8] * c[sO2]
			+ k[rH236f] * c[sH] * c[sC3H8]
			+ k[rH238f] * c[sC3H8] * c[sO]
			+ k[rH241f] * c[sC3H8] * c[sOH]
			+ k[rH242f] * c[sC3H8] * c[sHO2]
			+ k[rH244f] * c[sCH3] * c[sC3H8]
			+ k[rH265f] * c[sIXC3H7O2]
			+ k[rH311] * c[sIXC4H8] * c[sO]
			+ k[rH323f] * c[sIXC4H10]
			+ k[rH362] * c[sIXC3H6CO] * c[sOH]
			+ k[rH363] * c[sIXC3H6CO] * c[sH]
			+ k[rHLP421f] * c[sYXC7H14]
			+ k[rHLP433] * c[sYXC7H15]
			+ k[rHLP446] * c[sXC7H13OXZXC7H13O]
			+ k[rH456] * c[sIXC8H18]
			+ k[rL100] * c[sIXC3H7CHO]
			+ k[rL105] * c[sIXC4H9O]
			+ k[rLLP226f] * c[sIC3H7COC3H6XTXC7H13O]
			);

	 Double IXC3H7CO_ct1 = ( 0
			+ k[rL97] * c[sIXC3H7CHO] * c[sHO2]
			+ k[rL98] * c[sIXC3H7CHO] * c[sCH3]
			+ k[rL99] * c[sIXC3H7CHO] * c[sOH]
			+ k[rLLP298] * c[sIC8ETERACXC8H16O] * c[sOH]
			);


// IXC3H7 ---------------------------------------

	 Double IXC3H7_denom2 = CatchZero( IXC3H7_denom1
			);

	 Double IXC3H7_ct2 = ( IXC3H7_ct1
			) / IXC3H7_denom2;



	 Double IXC3H7_IXC3H7CO = ( 0 + k[rL81f] 
			) / IXC3H7_denom2 ;



	 Double IXC3H7_IXC3H7CO_coeff = ( 0 + k[rL81b]  * c[sCO]
			);


// IXC3H7CO ---------------------------------------

	 Double IXC3H7CO_denom2 = CatchZero( IXC3H7CO_denom1
			- IXC3H7_IXC3H7CO_coeff * IXC3H7_IXC3H7CO
			);

	 Double IXC3H7CO_ct2 = ( IXC3H7CO_ct1
			+ IXC3H7_IXC3H7CO_coeff * IXC3H7_ct2
			) / IXC3H7CO_denom2;






// Reconstruction ------------------------------------

	c[sIXC3H7CO] = ( IXC3H7CO_ct2
			) ;

	c[sIXC3H7] = ( IXC3H7_ct2
			+ IXC3H7_IXC3H7CO * c[sIXC3H7CO]
			) ;

// c[sCH3COCH2O2] c[sCH3COCH2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH3COCH2O2_denom1 = CatchZero( 0
			+ k[rL60] * c[sCH3COCH3]
			+ k[rL61] * c[sCH2O]
			+ k[rL62f]
			+ k[rL63] * c[sHO2]
			);

	 Double CH3COCH2_denom1 = CatchZero( 0
			+ k[rH256f]
			+ k[rL62b] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double CH3COCH2O2_ct1 = ( 0
			);

	 Double CH3COCH2_ct1 = ( 0
			+ k[rH213] * c[sC3H5XTXC3H5] * c[sO2]
			+ k[rH256b] * c[sCH2CO] * c[sCH3]
			+ k[rH260] * c[sCH3COCH3] * c[sH]
			+ k[rH261] * c[sCH3COCH3] * c[sOH]
			+ k[rH262] * c[sCH3COCH3] * c[sHO2]
			+ k[rH263] * c[sCH3COCH3] * c[sO]
			+ k[rH286] * c[sIXC4H7] * c[sO2]
			+ k[rLLP235] * c[sC7H14O2X5XC7H14O] * c[sOH]
			+ k[rLLP237] * c[sC7H14O2X5XC7H14O] * c[sHO2]
			+ k[rLLP285] * c[sNC7KET42XC7H14O3]
			);


// CH3COCH2O2 ---------------------------------------

	 Double CH3COCH2O2_denom2 = CatchZero( CH3COCH2O2_denom1
			);

	 Double CH3COCH2O2_ct2 = ( CH3COCH2O2_ct1
			) / CH3COCH2O2_denom2;



	 Double CH3COCH2O2_CH3COCH2 = ( 0 + k[rL62b]  * c[sO2]
			) / CH3COCH2O2_denom2 ;



	 Double CH3COCH2O2_CH3COCH2_coeff = ( 0 + k[rL60] * c[sCH3COCH3] + k[rL62f] 
			);


// CH3COCH2 ---------------------------------------

	 Double CH3COCH2_denom2 = CatchZero( CH3COCH2_denom1
			- CH3COCH2O2_CH3COCH2_coeff * CH3COCH2O2_CH3COCH2
			);

	 Double CH3COCH2_ct2 = ( CH3COCH2_ct1
			+ CH3COCH2O2_CH3COCH2_coeff * CH3COCH2O2_ct2
			) / CH3COCH2_denom2;






// Reconstruction ------------------------------------

	c[sCH3COCH2] = ( CH3COCH2_ct2
			) ;

	c[sCH3COCH2O2] = ( CH3COCH2O2_ct2
			+ CH3COCH2O2_CH3COCH2 * c[sCH3COCH2]
			) ;

}

int SteadyStatesFunc( const VectorPtr /*x*/, VectorPtr fVec, void *object )
{
	int		speciesIn;
	Double	*c;
	Double	*k;
	Double	*M;
	Double	*f = fVec->vec;
	SteadyStateInfoPtr ssInfo = ( SteadyStateInfoPtr )object;
	ssInfo->GetSteadyStateInfo( &c, &k, &M, &speciesIn );

	f[sNEOC5H9Q2XNXC5H11O4-speciesIn] = c[sNEOC5H9Q2XNXC5H11O4] - (
		 k[rL195] * c[sNEOC5H10OOHXO2XC5H11O4] ) / ( CatchZero( 
		 k[rL197] ) );

	f[sTXC3H6O2HCO-speciesIn] = c[sTXC3H6O2HCO] - (
		 k[rL137] * c[sTXC3H6O2CHO] ) / ( CatchZero( 
		 k[rL138] ) );

	f[sC2H3O1X2XC2H3O-speciesIn] = c[sC2H3O1X2XC2H3O] - (
		 k[rH162b] * c[sCH2CHO]
		+ k[rH163b] * c[sCH3CO] ) / ( CatchZero( 
		 k[rH162f]
		+ k[rH163f] ) );

	f[sTXC4H9CO-speciesIn] = c[sTXC4H9CO] - (
		 k[rL160b] * c[sTXC4H9] * c[sCO]
		+ k[rL170] * c[sTXC4H9CHO] * c[sOH]
		+ k[rL171] * c[sTXC4H9CHO] * c[sHO2]
		+ k[rLLP300] * c[sIC8ETERACXC8H16O] * c[sOH]
		+ k[rLLP328] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rL160f] ) );

	f[sTXC3H6OCHO-speciesIn] = c[sTXC3H6OCHO] - (
		 k[rL83] * c[sTXC3H6CHO] * c[sHO2] ) / ( CatchZero( 
		 k[rL108] ) );

	f[sC4H7O-speciesIn] = c[sC4H7O] - (
		 k[rH276] * c[sC4H7] * c[sHO2]
		+ k[rH278] * c[sC4H7] * c[sCH3O2] ) / ( CatchZero( 
		 k[rH369]
		+ k[rH370] ) );

	f[sXC7H13OXZXC7H13O-speciesIn] = c[sXC7H13OXZXC7H13O] - (
		 k[rHLP420] * c[sXXC7H13] * c[sHO2]
		+ k[rLLP248] * c[sYC7H13OOHXX2XC7H14O2] ) / ( CatchZero( 
		 k[rHLP446]
		+ k[rLLP224] ) );

	f[sNEOC5KETOXXC5H9O2-speciesIn] = c[sNEOC5KETOXXC5H9O2] - (
		 k[rL174b] * c[sTXC3H6CHO] * c[sCH2O]
		+ k[rL192] * c[sNEOC5KETXC5H10O3] ) / ( CatchZero( 
		 k[rL174f] ) );

	f[sC4H8OHX1O2XC4H9O3-speciesIn] = c[sC4H8OHX1O2XC4H9O3] - (
		 k[rL104] * c[sC4H8OHX1XC4H9O] * c[sO2] ) / ( CatchZero( 
		 k[rL142] ) );

	f[sIXC3H7CO-speciesIn] = c[sIXC3H7CO] - (
		 k[rL81b] * c[sIXC3H7] * c[sCO]
		+ k[rL97] * c[sIXC3H7CHO] * c[sHO2]
		+ k[rL98] * c[sIXC3H7CHO] * c[sCH3]
		+ k[rL99] * c[sIXC3H7CHO] * c[sOH]
		+ k[rLLP298] * c[sIC8ETERACXC8H16O] * c[sOH] ) / ( CatchZero( 
		 k[rL81f] ) );

	f[sNEOXC5H11O-speciesIn] = c[sNEOXC5H11O] - (
		 k[rL150] * c[sNEOXC5H11] * c[sCH3O2]
		+ k[rL151] * c[sNEOXC5H11] * c[sHO2]
		+ k[rL184] * c[sNEOXC5H11O2] * c[sCH3O2]
		+ k[rL185] * 2.0 * c[sNEOXC5H11] * c[sNEOXC5H11O2]
		+ k[rL189] * 2.0 * c[sNEOXC5H11O2] * c[sNEOXC5H11O2]
		+ k[rL190] * c[sNEOXC5H11O2H] ) / ( CatchZero( 
		 k[rL172] ) );

	f[sDXC8H17O-speciesIn] = c[sDXC8H17O] - (
		 k[rLLP294] * c[sCXC8H17] * c[sCH3O2]
		+ k[rLLP295] * c[sCXC8H17] * c[sHO2]
		+ k[rLLP306] * c[sBXC8H17O2] * c[sCH3O2]
		+ k[rLLP313] * 2.0 * c[sCXC8H17] * c[sBXC8H17O2]
		+ k[rLLP314] * 2.0 * c[sBXC8H17O2] * c[sBXC8H17O2]
		+ k[rLLP326] * c[sBXC8H17O2H] ) / ( CatchZero( 
		 k[rLLP302]
		+ k[rLLP303]
		+ k[rLLP304] ) );

	f[sIXC4H9O-speciesIn] = c[sIXC4H9O] - (
		 k[rL71] * c[sIXC4H9] * c[sHO2]
		+ k[rL72] * c[sCH3O2] * c[sIXC4H9]
		+ k[rL106b] * c[sIXC3H7CHO] * c[sH]
		+ k[rL110] * 2.0 * c[sIXC4H9O2] * c[sIXC4H9O2]
		+ k[rL112] * c[sIXC4H9O2] * c[sCH3]
		+ k[rL113] * c[sIXC4H9O2] * c[sCH3O2]
		+ k[rL114] * c[sIXC4H9O2] * c[sTXC4H9]
		+ k[rL116] * 2.0 * c[sIXC4H9O2] * c[sIXC4H9]
		+ k[rL118] * c[sIXC4H9O2] * c[sIXC4H7]
		+ k[rL119] * c[sIXC4H9O2] * c[sTXC4H9O2]
		+ k[rL134] * c[sIXC4H9O2H] ) / ( CatchZero( 
		 k[rL105]
		+ k[rL106f] ) );

	f[sHOCH2O-speciesIn] = c[sHOCH2O] - (
		 k[rH107b] * c[sHOCHO] * c[sH]
		+ k[rH108b] * c[sCH2O] * c[sOH] ) / ( CatchZero( 
		 k[rH107f]
		+ k[rH108f] ) );

	f[sTXC4H9O-speciesIn] = c[sTXC4H9O] - (
		 k[rH321] * c[sTXC4H9] * c[sHO2]
		+ k[rH322] * c[sCH3O2] * c[sTXC4H9]
		+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
		+ k[rH385] * c[sTXC4H9O2] * c[sCH3]
		+ k[rH386] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
		+ k[rH388] * c[sTXC4H9O2] * c[sCH3O2]
		+ k[rH390] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9]
		+ k[rL114] * c[sIXC4H9O2] * c[sTXC4H9]
		+ k[rL119] * c[sIXC4H9O2] * c[sTXC4H9O2]
		+ k[rL120] * c[sTXC4H9O2] * c[sCH3CO3]
		+ k[rL135] * c[sTXC4H9O2H] ) / ( CatchZero( 
		 k[rH380] ) );

	f[sCH3COCH2O-speciesIn] = c[sCH3COCH2O] - (
		 k[rL47b] * c[sCH3CO] * c[sCH2O]
		+ k[rL64] * c[sCH3COCH2O2H] ) / ( CatchZero( 
		 k[rL47f] ) );

	f[sC2H5CO-speciesIn] = c[sC2H5CO] - (
		 k[rL28b] * c[sC2H5] * c[sCO]
		+ k[rL33] * c[sC2H5CHO] * c[sCH3CO3]
		+ k[rL34] * c[sC2H5CHO] * c[sCH3]
		+ k[rL35] * c[sC2H5CHO] * c[sOH]
		+ k[rL36] * c[sC2H5CHO] * c[sH]
		+ k[rL37] * c[sC2H5CHO] * c[sO]
		+ k[rL38] * c[sC2H5CHO] * c[sCH3O]
		+ k[rL39] * c[sC2H5CHO] * c[sCH3O2]
		+ k[rL40] * c[sC2H5CHO] * c[sC2H5O2]
		+ k[rL41] * c[sC2H5CHO] * c[sC2H5]
		+ k[rL43] * c[sC2H5CHO] * c[sC3H5XAXC3H5]
		+ k[rL44] * c[sC2H5CHO] * c[sHO2]
		+ k[rL65] * c[sC2H5CHO] * c[sC4H7]
		+ k[rL67] * c[sC4H8X1XC4H8] * c[sO]
		+ k[rL69] * c[sC4H8X1XC4H8] * c[sOH]
		+ k[rLLP140] * c[sIC4KETITXC4H8O3]
		+ k[rL154] * c[sC2H5COC2H4PXC5H9O]
		+ k[rLLP228] * c[sC7H14O2X5XC7H14O] * c[sOH] ) / ( CatchZero( 
		 k[rL28f] ) );

	f[sPXC7H15O-speciesIn] = c[sPXC7H15O] - (
		 k[rLLP221] * c[sYXC7H15] * c[sCH3O2]
		+ k[rLLP223] * c[sYXC7H15] * c[sHO2]
		+ k[rLLP267] * c[sYXC7H15O2] * c[sCH3O2]
		+ k[rLLP268] * 2.0 * c[sYXC7H15O2] * c[sYXC7H15O2]
		+ k[rLLP269] * 2.0 * c[sYXC7H15] * c[sYXC7H15O2]
		+ k[rLLP278] * c[sYXC7H15O2H] ) / ( CatchZero( 
		 k[rLLP246]
		+ k[rLLP247] ) );

	f[sTC4H8O2HXIXC4H9O2-speciesIn] = c[sTC4H8O2HXIXC4H9O2] - (
		 k[rH389f] * c[sTXC4H9O2]
		+ k[rH391b] * c[sIXC4H8] * c[sHO2] ) / ( CatchZero( 
		 k[rH389b]
		+ k[rH391f]
		+ k[rL124] ) );

	f[sC3H6OOH2X1XC3H7O2-speciesIn] = c[sC3H6OOH2X1XC3H7O2] - (
		 k[rL49b] * c[sC3H6] * c[sHO2]
		+ k[rL50] * c[sIXC3H7O2] ) / ( CatchZero( 
		 k[rL49f] ) );

	f[sC3H6OOH1X2XC3H7O2-speciesIn] = c[sC3H6OOH1X2XC3H7O2] - (
		 k[rL48b] * c[sC3H6] * c[sHO2]
		+ k[rL53f] * c[sNXC3H7O2] ) / ( CatchZero( 
		 k[rL48f]
		+ k[rL53b] ) );

	f[sC4H8OHX1XC4H9O-speciesIn] = c[sC4H8OHX1XC4H9O] - (
		 k[rL103b] * c[sC4H8X1XC4H8] * c[sOH] ) / ( CatchZero( 
		 k[rL103f]
		+ k[rL104] * c[sO2] ) );

	f[sTXC4H8CHO-speciesIn] = c[sTXC4H8CHO] - (
		 k[rL78] * c[sIXC3H5CHO] * c[sCH3]
		+ k[rL169] * c[sTXC4H9CHO] * c[sOH]
		+ k[rLLP327] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rL161] ) );

	f[sC2H4O2H-speciesIn] = c[sC2H4O2H] - (
		 k[rL4] * c[sC2H5] * c[sO2]
		+ k[rL8b] * c[sC2H4] * c[sHO2]
		+ k[rL10f] * c[sC2H5O2] ) / ( CatchZero( 
		 k[rL8f]
		+ k[rL10b] ) );

	f[sDC8H16OOHXBXC8H17O2-speciesIn] = c[sDC8H16OOHXBXC8H17O2] - (
		 k[rLLP305] * c[sBXC8H17O2]
		+ k[rLLP333f] * c[sBC8H16OOHXCO2XC8H17O4] ) / ( CatchZero( 
		 k[rLLP323]
		+ k[rLLP324]
		+ k[rLLP325]
		+ k[rLLP333b] * c[sO2] ) );

	f[sNXC3H7CO-speciesIn] = c[sNXC3H7CO] - (
		 k[rL82b] * c[sNXC3H7] * c[sCO]
		+ k[rL88] * c[sNXC3H7CHO] * c[sO]
		+ k[rL89] * c[sNXC3H7CHO] * c[sCH3O]
		+ k[rL90] * c[sNXC3H7CHO] * c[sCH3O2]
		+ k[rL91] * c[sNXC3H7CHO] * c[sCH3]
		+ k[rL92] * c[sNXC3H7CHO] * c[sO2]
		+ k[rL93] * c[sNXC3H7CHO] * c[sHO2]
		+ k[rL94] * c[sNXC3H7CHO] * c[sOH]
		+ k[rL95] * c[sNXC3H7CHO] * c[sH]
		+ k[rLLP234] * c[sC7H14O2X5XC7H14O] * c[sHO2]
		+ k[rLLP236] * c[sC7H14O2X5XC7H14O] * c[sOH] ) / ( CatchZero( 
		 k[rL82f] ) );

	f[sC3H6COCH3X2XC5H9O-speciesIn] = c[sC3H6COCH3X2XC5H9O] - (
		 k[rL155b] * c[sC3H6] * c[sCH3CO]
		+ k[rL162] * c[sNXC3H7COCH3] * c[sOH] ) / ( CatchZero( 
		 k[rL155f] ) );

	f[sC3H5O-speciesIn] = c[sC3H5O] - (
		 k[rH203] * c[sC3H5XAXC3H5] * c[sHO2]
		+ k[rH206] * c[sC3H5XAXC3H5] * c[sCH3O2]
		+ k[rH253b] * c[sC2H3CHO] * c[sH]
		+ k[rL57] * c[sNXC3H7O2] * c[sC3H5XAXC3H5] ) / ( CatchZero( 
		 k[rH253f]
		+ k[rH254]
		+ k[rH255] * c[sO2] ) );

	f[sCH3CHCHO-speciesIn] = c[sCH3CHCHO] - (
		 k[rL29b] * c[sC2H3CHO] * c[sH]
		+ k[rL31b] * c[sCH3CHCO] * c[sH]
		+ k[rLLP331] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rL29f]
		+ k[rL30] * c[sO2]
		+ k[rL31f]
		+ k[rL32] * c[sO2] ) );

	f[sCH2CCH2OH-speciesIn] = c[sCH2CCH2OH] - (
		 k[rH257b] * c[sC3H4XAXH4C3] * c[sOH]
		+ k[rH367] * c[sIXC4H6OH] * c[sHO2]
		+ k[rH379] * c[sIXC4H7OH] ) / ( CatchZero( 
		 k[rH257f]
		+ k[rH258] * c[sO2]
		+ k[rH259] ) );

	f[sPXC4H9O-speciesIn] = c[sPXC4H9O] - (
		 k[rL73] * c[sNXC3H7O2] * c[sPXC4H9]
		+ k[rL74] * c[sCH3O2] * c[sPXC4H9]
		+ k[rL75] * c[sPXC4H9] * c[sHO2]
		+ k[rL125] * 2.0 * c[sPXC4H9O2] * c[sPXC4H9]
		+ k[rL126] * c[sPXC4H9O2] * c[sCH3CO3]
		+ k[rL127] * 2.0 * c[sPXC4H9O2] * c[sPXC4H9O2]
		+ k[rL128] * c[sPXC4H9O2] * c[sC2H5]
		+ k[rL129] * c[sPXC4H9O2] * c[sNXC3H7O2]
		+ k[rL130] * c[sPXC4H9O2] * c[sCH3]
		+ k[rL131] * c[sPXC4H9O2] * c[sC2H5O2]
		+ k[rL132] * c[sPXC4H9O2] * c[sCH3O2]
		+ k[rL133] * c[sPXC4H9O2] * c[sNXC3H7] ) / ( CatchZero( 
		 k[rL107] ) );

	f[sC5H11OX1XC5H11O-speciesIn] = c[sC5H11OX1XC5H11O] - (
		 k[rLLP152] * c[sC5H11X1XC5H11] * c[sHO2]
		+ k[rLLP153] * c[sC5H11X1XC5H11] * c[sCH3O2]
		+ k[rL177] * c[sC5H11O2X1XC5H11O2] * c[sCH3O2]
		+ k[rL178] * 2.0 * c[sC5H11O2X1XC5H11O2] * c[sC5H11O2X1XC5H11O2]
		+ k[rLLP179] * 2.0 * c[sC5H11X1XC5H11] * c[sC5H11O2X1XC5H11O2] ) / ( CatchZero( 
		 k[rL173] ) );

	f[sNXC3H7O-speciesIn] = c[sNXC3H7O] - (
		 k[rL23] * c[sCH3O2] * c[sNXC3H7]
		+ k[rL24] * c[sNXC3H7] * c[sHO2]
		+ k[rL46b] * c[sC2H5CHO] * c[sH]
		+ k[rL51] * c[sNXC3H7O2] * c[sCH3]
		+ k[rL52] * c[sNXC3H7O2] * c[sC2H5O2]
		+ k[rL54] * 2.0 * c[sNXC3H7O2] * c[sNXC3H7O2]
		+ k[rL55] * c[sNXC3H7O2] * c[sCH3CO3]
		+ k[rL56] * 2.0 * c[sNXC3H7O2] * c[sNXC3H7]
		+ k[rL57] * c[sNXC3H7O2] * c[sC3H5XAXC3H5]
		+ k[rL58] * c[sNXC3H7O2] * c[sCH3O2]
		+ k[rL59] * c[sNXC3H7O2] * c[sC2H5]
		+ k[rL73] * c[sNXC3H7O2] * c[sPXC4H9]
		+ k[rL129] * c[sPXC4H9O2] * c[sNXC3H7O2]
		+ k[rL133] * c[sPXC4H9O2] * c[sNXC3H7] ) / ( CatchZero( 
		 k[rL45]
		+ k[rL46f] ) );

	f[sAC8H16OOHXBXC8H17O2-speciesIn] = c[sAC8H16OOHXBXC8H17O2] - (
		 k[rLLP309] * c[sBXC8H17O2]
		+ k[rLLP332f] * c[sBC8H16OOHXCO2XC8H17O4] ) / ( CatchZero( 
		 k[rLLP315]
		+ k[rLLP316]
		+ k[rLLP317]
		+ k[rLLP318]
		+ k[rLLP332b] * c[sO2] ) );

	f[sC7H15OX1XC7H15O-speciesIn] = c[sC7H15OX1XC7H15O] - (
		 k[rLLP218] * c[sC7H15X2XC7H15] * c[sCH3O2]
		+ k[rLLP219] * c[sC7H15X2XC7H15] * c[sHO2]
		+ k[rLLP257] * c[sC7H15O2X2XC7H15O2] * c[sCH3O2]
		+ k[rLLP258] * 2.0 * c[sC7H15O2X2XC7H15O2] * c[sC7H15O2X2XC7H15O2]
		+ k[rLLP265] * 2.0 * c[sC7H15X2XC7H15] * c[sC7H15O2X2XC7H15O2]
		+ k[rLLP277] * c[sC7H15O2HX2XC7H16O2] ) / ( CatchZero( 
		 k[rLLP242]
		+ k[rLLP243]
		+ k[rLLP244]
		+ k[rLLP245] ) );

	f[sIC4H8O2HXTXC4H9O2-speciesIn] = c[sIC4H8O2HXTXC4H9O2] - (
		 k[rHLP382f] * c[sIXC4H9O2]
		+ k[rHLP395b] * c[sIXC4H8] * c[sHO2]
		+ k[rLLP147f] * c[sIC4H8OOHXTO2XC4H9O4] ) / ( CatchZero( 
		 k[rHLP382b]
		+ k[rHLP394]
		+ k[rHLP395f]
		+ k[rLLP147b] * c[sO2]
		+ k[rLLP149] ) );

	f[sCH3CO-speciesIn] = c[sCH3CO] - (
		 k[rH163f] * c[sC2H3O1X2XC2H3O]
		+ k[rH165b] * c[sCO] * c[sCH3]
		+ k[rH167] * c[sCH3CHO] * c[sH]
		+ k[rH168] * c[sCH3CHO] * c[sO2]
		+ k[rH169] * c[sCH3CHO] * c[sO]
		+ k[rH170] * c[sCH3CHO] * c[sCH3]
		+ k[rH171] * c[sCH3O2] * c[sCH3CHO]
		+ k[rH173] * c[sCH3CHO] * c[sHO2]
		+ k[rH174] * c[sCH3CHO] * c[sOH]
		+ k[rH214] * c[sC3H5XTXC3H5] * c[sO2]
		+ k[rH264] * c[sCH3COCH3]
		+ k[rH296] * c[sC4H8X1XC4H8] * c[sOH]
		+ k[rH298] * c[sC4H8X1XC4H8] * c[sO]
		+ k[rL15f] * c[sCH3CO3]
		+ k[rL18] * c[sCH3CHO] * c[sCH3CO3]
		+ k[rL47f] * c[sCH3COCH2O]
		+ k[rL80f] * c[sCH2CH2COCH3]
		+ k[rL155f] * c[sC3H6COCH3X2XC5H9O]
		+ k[rLLP230] * c[sC7H14O2X5XC7H14O] * c[sHO2]
		+ k[rLLP238] * c[sC7H14O2X5XC7H14O] * c[sOH]
		+ k[rL279] * c[sNEOC7KETPOXC7H14O3] ) / ( CatchZero( 
		 k[rH163b]
		+ k[rH164] * c[sCH3]
		+ k[rH165f]
		+ k[rL15b] * c[sO2]
		+ k[rL47b] * c[sCH2O]
		+ k[rL80b] * c[sC2H4]
		+ k[rL155b] * c[sC3H6] ) );

	f[sSXC4H9-speciesIn] = c[sSXC4H9] - (
		 k[rL76b] * c[sC3H6] * c[sCH3]
		+ k[rL77b] * c[sC4H8X1XC4H8] * c[sH] ) / ( CatchZero( 
		 k[rL76f]
		+ k[rL77f] ) );

	f[sNXC4H9CO-speciesIn] = c[sNXC4H9CO] - (
		 k[rL159b] * c[sPXC4H9] * c[sCO]
		+ k[rL163] * c[sNXC4H9CHO] * c[sCH3O2]
		+ k[rL164] * c[sNXC4H9CHO] * c[sH]
		+ k[rL165] * c[sNXC4H9CHO] * c[sOH]
		+ k[rL166] * c[sNXC4H9CHO] * c[sCH3]
		+ k[rL167] * c[sNXC4H9CHO] * c[sCH3O]
		+ k[rL168] * c[sNXC4H9CHO] * c[sHO2]
		+ k[rLLP240] * c[sC7H14O2X5XC7H14O] * c[sOH] ) / ( CatchZero( 
		 k[rL159f] ) );

	f[sNEOXC5H10OOH-speciesIn] = c[sNEOXC5H10OOH] - (
		 k[rL183f] * c[sNEOXC5H11O2]
		+ k[rL196f] * c[sNEOC5H10OOHXO2XC5H11O4] ) / ( CatchZero( 
		 k[rL181]
		+ k[rL182]
		+ k[rL183b]
		+ k[rL196b] * c[sO2] ) );

	f[sIXC4H7O-speciesIn] = c[sIXC4H7O] - (
		 k[rH284] * c[sCH3O2] * c[sIXC4H7]
		+ k[rH290] * c[sIXC4H7] * c[sHO2]
		+ k[rH374] * c[sIXC4H6OH]
		+ k[rH384] * c[sTXC4H9O2] * c[sIXC4H7]
		+ k[rL109] * c[sIXC4H7OOH]
		+ k[rL118] * c[sIXC4H9O2] * c[sIXC4H7] ) / ( CatchZero( 
		 k[rH371]
		+ k[rH372]
		+ k[rH373]
		+ k[rH375] * c[sO2] ) );

	f[sCH2OH-speciesIn] = c[sCH2OH] - (
		 k[rH80b] * c[sH] * c[sCH2O]
		+ k[rH81b] * c[sCH2O] * c[sHO2]
		+ k[rH83] * c[sCH3OH] * c[sH]
		+ k[rH84] * c[sCH3OH]
		+ k[rH86] * c[sCH3OH] * c[sO]
		+ k[rH87] * c[sCH3OH] * c[sHO2]
		+ k[rH89f] * c[sCH3OH] * c[sOH]
		+ k[rH101] * c[sCH3OH] * c[sCH3O2]
		+ k[rH157] * c[sCH2CO] * c[sOH]
		+ k[rH258] * c[sCH2CCH2OH] * c[sO2]
		+ k[rH259] * c[sCH2CCH2OH]
		+ k[rH366] * c[sIXC4H6OH]
		+ k[rL1] * c[sCH3O] * c[sCH3OH]
		+ k[rL2] * c[sCH3OH] * c[sCH3] ) / ( CatchZero( 
		 k[rH80f]
		+ k[rH81f] * c[sO2]
		+ k[rH82] * c[sCH2O]
		+ k[rH89b] * c[sH2O] ) );

	f[sC7H14OOH3X2XC7H15O2-speciesIn] = c[sC7H14OOH3X2XC7H15O2] - (
		 k[rLLP259f] * c[sC7H15O2X2XC7H15O2] ) / ( CatchZero( 
		 k[rLLP256]
		+ k[rLLP259b] ) );

	f[sC3H2-speciesIn] = c[sC3H2] - (
		 k[rH182] * c[sC3H3] * c[sH]
		+ k[rH185f] * c[sC3H3] * c[sOH] ) / ( CatchZero( 
		 k[rH180] * c[sOH]
		+ k[rH181] * c[sO2]
		+ k[rH185b] * c[sH2O] ) );

	f[sC7H14OOH2X3XC7H15O2-speciesIn] = c[sC7H14OOH2X3XC7H15O2] - (
		 k[rLLP264f] * c[sC7H15O2X2XC7H15O2]
		+ k[rLLP290f] * c[sC7H14OOH1X4O2XC7H15O4] ) / ( CatchZero( 
		 k[rLLP254]
		+ k[rLLP255]
		+ k[rLLP264b]
		+ k[rLLP290b] * c[sO2] ) );

	f[sC2H3CO-speciesIn] = c[sC2H3CO] - (
		 k[rH246b] * c[sC2H3] * c[sCO]
		+ k[rH247] * c[sC2H3CHO] * c[sCH3O2]
		+ k[rH248] * c[sC2H3CHO] * c[sOH]
		+ k[rH249] * c[sC2H3CHO] * c[sHO2]
		+ k[rH250] * c[sC2H3CHO] * c[sCH3]
		+ k[rH251] * c[sC2H3CHO] * c[sO]
		+ k[rH252] * c[sC2H3CHO] * c[sH] ) / ( CatchZero( 
		 k[rH246f] ) );

	f[sCH2CH2COCH3-speciesIn] = c[sCH2CH2COCH3] - (
		 k[rL80b] * c[sC2H4] * c[sCH3CO]
		+ k[rLLP281] * c[sNC7KET25XC7H14O3] ) / ( CatchZero( 
		 k[rL80f] ) );

	f[sCH2CHO-speciesIn] = c[sCH2CHO] - (
		 k[rH124] * c[sC2H3] * c[sO2]
		+ k[rH127] * c[sC2H4] * c[sO]
		+ k[rH160b] * c[sCH2CO] * c[sH]
		+ k[rH162f] * c[sC2H3O1X2XC2H3O]
		+ k[rH211] * c[sC3H5XAXC3H5] * c[sO2]
		+ k[rL139] * c[sNC4KET13XC4H8O3]
		+ k[rL191] * c[sNC5KET13XC5H10O3]
		+ k[rL206] * c[sNC6KET13XC6H12O3]
		+ k[rLLP241] * c[sC7H14O2X5XC7H14O] * c[sOH]
		+ k[rLLP284] * c[sNC7KET42XC7H14O3] ) / ( CatchZero( 
		 k[rH160f]
		+ k[rH161] * c[sO2]
		+ k[rH162b] ) );

	f[sBC8H16OOHXCXC8H17O2-speciesIn] = c[sBC8H16OOHXCXC8H17O2] - (
		 k[rLLP311] * c[sBXC8H17O2]
		+ k[rLLP334f] * c[sBC8H16OOHXCO2XC8H17O4] ) / ( CatchZero( 
		 k[rLLP319]
		+ k[rLLP320]
		+ k[rLLP321]
		+ k[rLLP322]
		+ k[rLLP334b] * c[sO2] ) );

	f[sIXC4H8OH-speciesIn] = c[sIXC4H8OH] - (
		 k[rL87] * c[sIXC4H7OH] * c[sH]
		+ k[rL102b] * c[sIXC4H8] * c[sOH]
		+ k[rL144f] * c[sIXO2C4H8OH] ) / ( CatchZero( 
		 k[rL102f]
		+ k[rL144b] * c[sO2] ) );

	f[sC3H5XTXC3H5-speciesIn] = c[sC3H5XTXC3H5] - (
		 k[rH212b] * c[sC3H4XAXH4C3] * c[sH]
		+ k[rH215b] * c[sC3H4XPXH4C3] * c[sH]
		+ k[rH221] * c[sC3H6] * c[sO]
		+ k[rH223] * c[sC3H6] * c[sOH]
		+ k[rH224f] * c[sC3H6] * c[sH]
		+ k[rH304] * c[sIXC4H8]
		+ k[rH355] * c[sIXC3H5CO]
		+ k[rH371] * c[sIXC4H7O] ) / ( CatchZero( 
		 k[rH212f]
		+ k[rH213] * c[sO2]
		+ k[rH214] * c[sO2]
		+ k[rH215f]
		+ k[rH224b] * c[sH2] ) );

	f[sC2H5O-speciesIn] = c[sC2H5O] - (
		 k[rH138] * c[sCH3O2] * c[sC2H5]
		+ k[rH140] * c[sC2H5] * c[sHO2]
		+ k[rH175b] * c[sCH3CHO] * c[sH] * M[mM5]
		+ k[rL13] * c[sC2H5O2H]
		+ k[rL52] * c[sNXC3H7O2] * c[sC2H5O2]
		+ k[rL59] * c[sNXC3H7O2] * c[sC2H5]
		+ k[rL128] * c[sPXC4H9O2] * c[sC2H5]
		+ k[rL131] * c[sPXC4H9O2] * c[sC2H5O2] ) / ( CatchZero( 
		 k[rH175f] * M[mM5]
		+ k[rH176] * c[sO2]
		+ k[rH177] * M[mM5] ) );

	f[sYC7H14OOHXY2XC7H15O2-speciesIn] = c[sYC7H14OOHXY2XC7H15O2] - (
		 k[rLLP272f] * c[sYXC7H15O2]
		+ k[rLLP286f] * c[sPC7H14OOHXOO2XC7H15O4]
		+ k[rLLP292f] * c[sYC7H14OOHXY2O2XC7H15O4] ) / ( CatchZero( 
		 k[rLLP272b]
		+ k[rLLP274]
		+ k[rLLP275]
		+ k[rLLP276]
		+ k[rLLP286b] * c[sO2]
		+ k[rLLP292b] * c[sO2] ) );

	f[sYXC7H15-speciesIn] = c[sYXC7H15] - (
		 k[rHLP432b] * c[sYXC7H14] * c[sH]
		+ k[rHLP452] * c[sIXC8H18]
		+ k[rLLP271f] * c[sYXC7H15O2]
		+ k[rLLP302] * c[sDXC8H17O] ) / ( CatchZero( 
		 k[rHLP431]
		+ k[rHLP432f]
		+ k[rHLP433]
		+ k[rLLP221] * c[sCH3O2]
		+ k[rLLP222]
		+ k[rLLP223] * c[sHO2]
		+ k[rLLP269] * c[sYXC7H15O2]
		+ k[rLLP271b] * c[sO2] ) );

	f[sNEOXC5H11-speciesIn] = c[sNEOXC5H11] - (
		 k[rH408b] * c[sIXC4H8] * c[sCH3]
		+ k[rHLP450] * c[sCXC8H17]
		+ k[rH456] * c[sIXC8H18]
		+ k[rL188f] * c[sNEOXC5H11O2]
		+ k[rLLP246] * c[sPXC7H15O]
		+ k[rLLP293] * c[sJXC8H16] * c[sOH]
		+ k[rLLP304] * c[sDXC8H17O] ) / ( CatchZero( 
		 k[rH408f]
		+ k[rL150] * c[sCH3O2]
		+ k[rL151] * c[sHO2]
		+ k[rL185] * c[sNEOXC5H11O2]
		+ k[rL188b] * c[sO2] ) );

	f[sIXC3H5CO-speciesIn] = c[sIXC3H5CO] - (
		 k[rH356] * c[sIXC3H5CHO] * c[sOH]
		+ k[rH357] * c[sIXC3H5CHO] * c[sO]
		+ k[rH358] * c[sIXC3H5CHO] * c[sHO2]
		+ k[rH359] * c[sIXC3H5CHO] * c[sH]
		+ k[rH360] * c[sIXC3H5CHO] * c[sCH3] ) / ( CatchZero( 
		 k[rH355] ) );

	f[sCH2GSGXCH2-speciesIn] = c[sCH2GSGXCH2] - (
		 k[rH31b] * c[sCH3] * c[sH]
		+ k[rH32b] * c[sCH2] * M[mM5]
		+ k[rH34b] * c[sCH] * c[sH2]
		+ k[rH36f] * c[sCH3] * c[sOH]
		+ k[rH56b] * c[sCH3] * c[sCH3]
		+ k[rH149f] * c[sHCCO] * c[sH] ) / ( CatchZero( 
		 k[rH29] * c[sO]
		+ k[rH30] * c[sOH]
		+ k[rH31f] * c[sH2]
		+ k[rH32f] * M[mM5]
		+ k[rH33] * c[sO2]
		+ k[rH34f] * c[sH]
		+ k[rH36b] * c[sH2O]
		+ k[rH39] * c[sCH3]
		+ k[rH56f] * c[sCH4]
		+ k[rH90] * c[sCO2]
		+ k[rH146] * c[sC2H6]
		+ k[rH149b] * c[sCO]
		+ k[rH153] * c[sCH2CO] ) );

	f[sC5H10OOH1X3XC5H11O2-speciesIn] = c[sC5H10OOH1X3XC5H11O2] - (
		 k[rL180f] * c[sC5H11O2X1XC5H11O2]
		+ k[rL194f] * c[sC5H10OOH1X3O2XC5H11O4] ) / ( CatchZero( 
		 k[rL175]
		+ k[rL180b]
		+ k[rL194b] * c[sO2] ) );

	f[sC7H14OOH1X3XC7H15O2-speciesIn] = c[sC7H14OOH1X3XC7H15O2] - (
		 k[rLLP261f] * c[sC7H15O2X2XC7H15O2]
		+ k[rLLP288f] * c[sC7H14OOH1X3O2XC7H15O4] ) / ( CatchZero( 
		 k[rLLP249]
		+ k[rLLP250]
		+ k[rLLP251]
		+ k[rLLP252]
		+ k[rLLP253]
		+ k[rLLP261b]
		+ k[rLLP288b] * c[sO2] ) );

	f[sIXC4H9-speciesIn] = c[sIXC4H9] - (
		 k[rH316b] * c[sIXC4H8] * c[sH]
		+ k[rH317b] * c[sC3H6] * c[sCH3]
		+ k[rH325f] * c[sIXC4H10]
		+ k[rH327f] * c[sIXC4H10] * c[sH]
		+ k[rH329f] * c[sIXC4H10] * c[sCH3]
		+ k[rH331f] * c[sIXC4H10] * c[sOH]
		+ k[rH332f] * c[sIXC4H10] * c[sC2H5]
		+ k[rH334f] * c[sIXC4H10] * c[sHO2]
		+ k[rH337f] * c[sIXC4H10] * c[sO]
		+ k[rH338f] * c[sIXC4H10] * c[sCH3O]
		+ k[rH340f] * c[sIXC4H10] * c[sO2]
		+ k[rH383f] * c[sIXC4H9O2]
		+ k[rHLP449] * c[sCXC8H17]
		+ k[rH453] * c[sIXC8H18]
		+ k[rLLP247] * c[sPXC7H15O] ) / ( CatchZero( 
		 k[rH316f]
		+ k[rH317f]
		+ k[rH325b] * c[sH]
		+ k[rH327b] * c[sH2]
		+ k[rH329b] * c[sCH4]
		+ k[rH331b] * c[sH2O]
		+ k[rH332b] * c[sC2H6]
		+ k[rH334b] * c[sH2O2]
		+ k[rH337b] * c[sOH]
		+ k[rH338b] * c[sCH3OH]
		+ k[rH340b] * c[sHO2]
		+ k[rH383b] * c[sO2]
		+ k[rL71] * c[sHO2]
		+ k[rL72] * c[sCH3O2]
		+ k[rL116] * c[sIXC4H9O2] ) );

	f[sC4H8OOH1X3XC4H9O2-speciesIn] = c[sC4H8OOH1X3XC4H9O2] - (
		 k[rH392f] * c[sPXC4H9O2]
		+ k[rL145f] * c[sC4H8OOH1X3O2XC4H9O4] ) / ( CatchZero( 
		 k[rH381]
		+ k[rH392b]
		+ k[rL145b] * c[sO2] ) );

	f[sC2H-speciesIn] = c[sC2H] - (
		 k[rH120f] * c[sO] * c[sC2H2]
		+ k[rH121f] * c[sC2H2] * c[sOH]
		+ k[rH187] * c[sC3H3] * c[sO]
		+ k[rH199f] * c[sC3H4XPXH4C3] ) / ( CatchZero( 
		 k[rH110] * c[sO]
		+ k[rH111] * c[sH] * M[mM5]
		+ k[rH112] * c[sO2]
		+ k[rH120b] * c[sOH]
		+ k[rH121b] * c[sH2O]
		+ k[rH199b] * c[sCH3] ) );

	f[sCH-speciesIn] = c[sCH] - (
		 k[rH23f] * c[sCH2] * c[sOH]
		+ k[rH25f] * c[sCH2] * c[sH]
		+ k[rH34f] * c[sCH2GSGXCH2] * c[sH]
		+ k[rH110] * c[sC2H] * c[sO] ) / ( CatchZero( 
		 k[rH21] * c[sO2]
		+ k[rH23b] * c[sH2O]
		+ k[rH25b] * c[sH2]
		+ k[rH34b] * c[sH2]
		+ k[rH54] * c[sCH4] ) );

	f[sIXO2C4H8OH-speciesIn] = c[sIXO2C4H8OH] - (
		 k[rL144b] * c[sIXC4H8OH] * c[sO2] ) / ( CatchZero( 
		 k[rL143]
		+ k[rL144f] ) );

	f[sC6H13X1XC6H13-speciesIn] = c[sC6H13X1XC6H13] - (
		 k[rH418b] * c[sC6H12X1XC6H12] * c[sH]
		+ k[rH436f] * c[sNXC7H16]
		+ k[rL205f] * c[sC6H13O2X1XC6H13O2]
		+ k[rLLP244] * c[sC7H15OX1XC7H15O] ) / ( CatchZero( 
		 k[rH418f]
		+ k[rH419]
		+ k[rH436b] * c[sCH3]
		+ k[rL205b] * c[sO2] ) );

	f[sCXC8H17-speciesIn] = c[sCXC8H17] - (
		 k[rHLP451] * c[sIXC8H18] * c[sOH]
		+ k[rHLP454] * c[sIXC8H18] * c[sHO2]
		+ k[rHLP455] * c[sIXC8H18] * c[sCH3]
		+ k[rHLP457] * c[sIXC8H18] * c[sCH3O]
		+ k[rHLP458] * c[sIXC8H18] * c[sH]
		+ k[rHLP459] * c[sIXC8H18] * c[sO]
		+ k[rHLP460] * c[sIXC8H18] * c[sCH3O2]
		+ k[rHLP461f] * c[sIXC8H18] * c[sO2]
		+ k[rLLP296b] * c[sJXC8H16] * c[sH]
		+ k[rLLP308] * c[sIXC8H18] * c[sBXC8H17O2]
		+ k[rLLP310f] * c[sBXC8H17O2] ) / ( CatchZero( 
		 k[rHLP447]
		+ k[rHLP448]
		+ k[rHLP449]
		+ k[rHLP450]
		+ k[rHLP461b] * c[sHO2]
		+ k[rLLP294] * c[sCH3O2]
		+ k[rLLP295] * c[sHO2]
		+ k[rLLP296f]
		+ k[rLLP310b] * c[sO2]
		+ k[rLLP313] * c[sBXC8H17O2] ) );

	f[sC5H11X1XC5H11-speciesIn] = c[sC5H11X1XC5H11] - (
		 k[rHLP410b] * c[sH] * c[sC5H10X1XC5H10]
		+ k[rHLP411b] * c[sC3H6] * c[sC2H5]
		+ k[rHLP417] * c[sC6H12X1XC6H12] * c[sOH]
		+ k[rHLP425] * c[sC7H15X2XC7H15]
		+ k[rHLP445f] * c[sNXC7H16]
		+ k[rLLP176f] * c[sC5H11O2X1XC5H11O2]
		+ k[rLLP216] * c[sC7H14X2XC7H14] * c[sOH]
		+ k[rLLP245] * c[sC7H15OX1XC7H15O] ) / ( CatchZero( 
		 k[rHLP409]
		+ k[rHLP410f]
		+ k[rHLP411f]
		+ k[rHLP445b] * c[sC2H5]
		+ k[rLLP152] * c[sHO2]
		+ k[rLLP153] * c[sCH3O2]
		+ k[rLLP176b] * c[sO2]
		+ k[rLLP179] * c[sC5H11O2X1XC5H11O2] ) );

	f[sTXC3H6CHO-speciesIn] = c[sTXC3H6CHO] - (
		 k[rL84b] * c[sIXC3H5CHO] * c[sH]
		+ k[rL85b] * c[sIXC3H6CO] * c[sH]
		+ k[rL96] * c[sIXC3H7CHO] * c[sOH]
		+ k[rL136f] * c[sTXC3H6O2CHO]
		+ k[rL174f] * c[sNEOC5KETOXXC5H9O2]
		+ k[rLLP301] * c[sIC8ETERACXC8H16O] * c[sOH]
		+ k[rLLP330] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rL83] * c[sHO2]
		+ k[rL84f]
		+ k[rL85f]
		+ k[rL86] * c[sHO2]
		+ k[rL136b] * c[sO2]
		+ k[rL174b] * c[sCH2O] ) );

	f[sPXC4H9-speciesIn] = c[sPXC4H9] - (
		 k[rH318b] * c[sC2H5] * c[sC2H4]
		+ k[rH319b] * c[sC4H8X1XC4H8] * c[sH]
		+ k[rH344f] * c[sC4H10]
		+ k[rH345f] * c[sC4H10] * c[sO2]
		+ k[rH346f] * c[sC4H10] * c[sC3H5XAXC3H5]
		+ k[rH347f] * c[sC4H10] * c[sC2H5]
		+ k[rH348f] * c[sC4H10] * c[sC2H3]
		+ k[rH349f] * c[sC4H10] * c[sCH3]
		+ k[rH350f] * c[sC4H10] * c[sH]
		+ k[rH351f] * c[sC4H10] * c[sOH]
		+ k[rH352f] * c[sC4H10] * c[sO]
		+ k[rH353f] * c[sC4H10] * c[sHO2]
		+ k[rH354f] * c[sC4H10] * c[sCH3O]
		+ k[rH393f] * c[sPXC4H9O2]
		+ k[rH406] * c[sC5H10X1XC5H10] * c[sOH]
		+ k[rH419] * c[sC6H13X1XC6H13]
		+ k[rHLP427] * c[sC7H15X2XC7H15]
		+ k[rH443f] * c[sNXC7H16]
		+ k[rL159f] * c[sNXC4H9CO]
		+ k[rL173] * c[sC5H11OX1XC5H11O]
		+ k[rLLP211] * c[sC7H14X2XC7H14] * c[sOH]
		+ k[rLLP242] * c[sC7H15OX1XC7H15O] ) / ( CatchZero( 
		 k[rH318f]
		+ k[rH319f]
		+ k[rH344b] * c[sH]
		+ k[rH345b] * c[sHO2]
		+ k[rH346b] * c[sC3H6]
		+ k[rH347b] * c[sC2H6]
		+ k[rH348b] * c[sC2H4]
		+ k[rH349b] * c[sCH4]
		+ k[rH350b] * c[sH2]
		+ k[rH351b] * c[sH2O]
		+ k[rH352b] * c[sOH]
		+ k[rH353b] * c[sH2O2]
		+ k[rH354b] * c[sCH3OH]
		+ k[rH393b] * c[sO2]
		+ k[rH443b] * c[sNXC3H7]
		+ k[rL73] * c[sNXC3H7O2]
		+ k[rL74] * c[sCH3O2]
		+ k[rL75] * c[sHO2]
		+ k[rL125] * c[sPXC4H9O2]
		+ k[rL159b] * c[sCO] ) );

	f[sIXC3H7-speciesIn] = c[sIXC3H7] - (
		 k[rH228b] * c[sH] * c[sC3H6]
		+ k[rH234f] * c[sC3H8] * c[sO2]
		+ k[rH236f] * c[sH] * c[sC3H8]
		+ k[rH238f] * c[sC3H8] * c[sO]
		+ k[rH241f] * c[sC3H8] * c[sOH]
		+ k[rH242f] * c[sC3H8] * c[sHO2]
		+ k[rH244f] * c[sCH3] * c[sC3H8]
		+ k[rH265f] * c[sIXC3H7O2]
		+ k[rH311] * c[sIXC4H8] * c[sO]
		+ k[rH323f] * c[sIXC4H10]
		+ k[rH362] * c[sIXC3H6CO] * c[sOH]
		+ k[rH363] * c[sIXC3H6CO] * c[sH]
		+ k[rHLP421f] * c[sYXC7H14]
		+ k[rHLP433] * c[sYXC7H15]
		+ k[rHLP446] * c[sXC7H13OXZXC7H13O]
		+ k[rH456] * c[sIXC8H18]
		+ k[rL81f] * c[sIXC3H7CO]
		+ k[rL100] * c[sIXC3H7CHO]
		+ k[rL105] * c[sIXC4H9O]
		+ k[rLLP226f] * c[sIC3H7COC3H6XTXC7H13O] ) / ( CatchZero( 
		 k[rH228f]
		+ k[rH229] * c[sO2]
		+ k[rH234b] * c[sHO2]
		+ k[rH236b] * c[sH2]
		+ k[rH238b] * c[sOH]
		+ k[rH241b] * c[sH2O]
		+ k[rH242b] * c[sH2O2]
		+ k[rH244b] * c[sCH4]
		+ k[rH265b] * c[sO2]
		+ k[rH323b] * c[sCH3]
		+ k[rHLP421b] * c[sIXC4H7]
		+ k[rL81b] * c[sCO]
		+ k[rLLP226b] * c[sIXC3H6CO] ) );

	f[sC6H12OOH1X3XC6H13O2-speciesIn] = c[sC6H12OOH1X3XC6H13O2] - (
		 k[rL204] * c[sC6H13O2X1XC6H13O2]
		+ k[rL207f] * c[sC6H12OOH1X3O2XC6H13O4] ) / ( CatchZero( 
		 k[rL203]
		+ k[rL207b] * c[sO2] ) );

	f[sCH3COCH2-speciesIn] = c[sCH3COCH2] - (
		 k[rH213] * c[sC3H5XTXC3H5] * c[sO2]
		+ k[rH256b] * c[sCH2CO] * c[sCH3]
		+ k[rH260] * c[sCH3COCH3] * c[sH]
		+ k[rH261] * c[sCH3COCH3] * c[sOH]
		+ k[rH262] * c[sCH3COCH3] * c[sHO2]
		+ k[rH263] * c[sCH3COCH3] * c[sO]
		+ k[rH286] * c[sIXC4H7] * c[sO2]
		+ k[rL60] * c[sCH3COCH3] * c[sCH3COCH2O2]
		+ k[rL62f] * c[sCH3COCH2O2]
		+ k[rLLP235] * c[sC7H14O2X5XC7H14O] * c[sOH]
		+ k[rLLP237] * c[sC7H14O2X5XC7H14O] * c[sHO2]
		+ k[rLLP285] * c[sNC7KET42XC7H14O3] ) / ( CatchZero( 
		 k[rH256f]
		+ k[rL62b] * c[sO2] ) );

	f[sIXC5H9-speciesIn] = c[sIXC5H9] - (
		 k[rH399] * c[sAXC5H10] * c[sO]
		+ k[rH400] * c[sAXC5H10] * c[sCH3]
		+ k[rL200f] * c[sBXC6H12] ) / ( CatchZero( 
		 k[rH398]
		+ k[rL200b] * c[sCH3] ) );

	f[sCH3CO2-speciesIn] = c[sCH3CO2] - (
		 k[rL7b] * c[sCH3] * c[sCO2] * M[mM5]
		+ k[rL19] * c[sCH3CO3H]
		+ k[rL55] * c[sNXC3H7O2] * c[sCH3CO3]
		+ k[rL120] * c[sTXC4H9O2] * c[sCH3CO3]
		+ k[rL126] * c[sPXC4H9O2] * c[sCH3CO3] ) / ( CatchZero( 
		 k[rL7f] * M[mM5] ) );

	f[sC4H7-speciesIn] = c[sC4H7] - (
		 k[rH283b] * c[sC4H6] * c[sH]
		+ k[rH294] * c[sC4H8X1XC4H8] * c[sH]
		+ k[rH299f] * c[sC4H8X1XC4H8] * c[sO2]
		+ k[rH300] * c[sC4H8X1XC4H8] * c[sOH]
		+ k[rH301] * c[sC4H8X1XC4H8] * c[sHO2]
		+ k[rH303] * c[sC4H8X1XC4H8] * c[sCH3]
		+ k[rL209f] * c[sC7H13]
		+ k[rLLP213] * c[sC7H14X2XC7H14]
		+ k[rLLP231] * c[sC7H14O2X5XC7H14O] * c[sOH] ) / ( CatchZero( 
		 k[rH274] * c[sCH3]
		+ k[rH275] * c[sC3H5XAXC3H5]
		+ k[rH276] * c[sHO2]
		+ k[rH277] * c[sC2H5]
		+ k[rH278] * c[sCH3O2]
		+ k[rH279] * c[sH]
		+ k[rH280]
		+ k[rH281] * c[sO2]
		+ k[rH282] * c[sH]
		+ k[rH283f]
		+ k[rH299b] * c[sHO2]
		+ k[rL65] * c[sC2H5CHO]
		+ k[rL209b] * c[sC3H6] ) );

	f[sPXC2H4OH-speciesIn] = c[sPXC2H4OH] - (
		 k[rL6b] * c[sC2H4] * c[sOH]
		+ k[rL20f] * c[sO2C2H4OH] ) / ( CatchZero( 
		 k[rL6f]
		+ k[rL20b] * c[sO2] ) );

	f[sC7H15X2XC7H15-speciesIn] = c[sC7H15X2XC7H15] - (
		 k[rHLP429b] * c[sC6H12X1XC6H12] * c[sCH3]
		+ k[rHLP434] * c[sNXC7H16] * c[sHO2]
		+ k[rHLP435] * c[sNXC7H16] * c[sCH3]
		+ k[rHLP437] * c[sNXC7H16] * c[sCH3O]
		+ k[rHLP438] * c[sNXC7H16] * c[sC2H5]
		+ k[rHLP439] * c[sNXC7H16] * c[sO]
		+ k[rHLP440f] * c[sNXC7H16] * c[sO2]
		+ k[rHLP441] * c[sNXC7H16] * c[sOH]
		+ k[rHLP442] * c[sNXC7H16] * c[sH]
		+ k[rHLP444] * c[sNXC7H16] * c[sCH3O2]
		+ k[rLLP220b] * c[sH] * c[sC7H14X2XC7H14]
		+ k[rLLP262] * c[sNXC7H16] * c[sC7H15O2X2XC7H15O2]
		+ k[rLLP263f] * c[sC7H15O2X2XC7H15O2] ) / ( CatchZero( 
		 k[rHLP425]
		+ k[rHLP426] * c[sH]
		+ k[rHLP427]
		+ k[rHLP428]
		+ k[rHLP429f]
		+ k[rHLP430]
		+ k[rHLP440b] * c[sHO2]
		+ k[rLLP218] * c[sCH3O2]
		+ k[rLLP219] * c[sHO2]
		+ k[rLLP220f]
		+ k[rLLP263b] * c[sO2]
		+ k[rLLP265] * c[sC7H15O2X2XC7H15O2] ) );

	f[sO2C2H4OH-speciesIn] = c[sO2C2H4OH] - (
		 k[rL20b] * c[sPXC2H4OH] * c[sO2] ) / ( CatchZero( 
		 k[rL20f]
		+ k[rL21] ) );

	f[sTXC4H9-speciesIn] = c[sTXC4H9] - (
		 k[rH320b] * c[sH] * c[sIXC4H8]
		+ k[rH324f] * c[sIXC4H10]
		+ k[rH326f] * c[sIXC4H10] * c[sH]
		+ k[rH328f] * c[sIXC4H10] * c[sCH3]
		+ k[rH330f] * c[sIXC4H10] * c[sOH]
		+ k[rH333f] * c[sIXC4H10] * c[sC2H5]
		+ k[rH335f] * c[sIXC4H10] * c[sHO2]
		+ k[rH336f] * c[sIXC4H10] * c[sO]
		+ k[rH339f] * c[sIXC4H10] * c[sCH3O]
		+ k[rH341f] * c[sIXC4H10] * c[sO2]
		+ k[rH387f] * c[sTXC4H9O2]
		+ k[rHLP422f] * c[sYXC7H14]
		+ k[rHLP431] * c[sYXC7H15]
		+ k[rHLP447] * c[sCXC8H17]
		+ k[rH453] * c[sIXC8H18]
		+ k[rL160f] * c[sTXC4H9CO]
		+ k[rL172] * c[sNEOXC5H11O]
		+ k[rLLP225f] * c[sIC3H7COC3H6XTXC7H13O]
		+ k[rLLP303] * c[sDXC8H17O]
		+ k[rLLP315] * c[sAC8H16OOHXBXC8H17O2] ) / ( CatchZero( 
		 k[rH320f]
		+ k[rH321] * c[sHO2]
		+ k[rH322] * c[sCH3O2]
		+ k[rH324b] * c[sH]
		+ k[rH326b] * c[sH2]
		+ k[rH328b] * c[sCH4]
		+ k[rH330b] * c[sH2O]
		+ k[rH333b] * c[sC2H6]
		+ k[rH335b] * c[sH2O2]
		+ k[rH336b] * c[sOH]
		+ k[rH339b] * c[sCH3OH]
		+ k[rH341b] * c[sHO2]
		+ k[rH387b] * c[sO2]
		+ k[rH390] * c[sTXC4H9O2]
		+ k[rHLP422b] * c[sC3H5XAXC3H5]
		+ k[rL114] * c[sIXC4H9O2]
		+ k[rL160b] * c[sCO]
		+ k[rLLP225b] * c[sCH3CHCO] ) );

	f[sIXC4H6OH-speciesIn] = c[sIXC4H6OH] - (
		 k[rH373] * c[sIXC4H7O]
		+ k[rH377] * c[sIXC4H7OH] * c[sHO2]
		+ k[rH378] * c[sIXC4H7OH] * c[sOH] ) / ( CatchZero( 
		 k[rH364] * c[sH]
		+ k[rH365] * c[sCH2O]
		+ k[rH366]
		+ k[rH367] * c[sHO2]
		+ k[rH368] * c[sHO2]
		+ k[rH374] ) );

	f[sHCCO-speciesIn] = c[sHCCO] - (
		 k[rH113] * c[sC2H2] * c[sO]
		+ k[rH114] * c[sC2H2] * c[sO2]
		+ k[rH149b] * c[sCH2GSGXCH2] * c[sCO]
		+ k[rH152f] * c[sCH2CO] * c[sOH]
		+ k[rH155] * c[sCH2CO] * c[sO]
		+ k[rH158f] * c[sCH2CO] * c[sH]
		+ k[rH181] * c[sC3H2] * c[sO2] ) / ( CatchZero( 
		 k[rH148] * c[sO2]
		+ k[rH149f] * c[sH]
		+ k[rH150] * c[sOH]
		+ k[rH151] * c[sO]
		+ k[rH152b] * c[sH2O]
		+ k[rH158b] * c[sH2] ) );

	f[sC2H5COC2H4PXC5H9O-speciesIn] = c[sC2H5COC2H4PXC5H9O] - (
		 k[rLLP280] * c[sNC7KET25XC7H14O3] ) / ( CatchZero( 
		 k[rL154] ) );

	f[sC3H4XPXH4C3-speciesIn] = c[sC3H4XPXH4C3] - (
		 k[rH118f] * c[sC2H2] * c[sCH3]
		+ k[rH188] * c[sC3H3] * c[sHO2]
		+ k[rH194f] * c[sC3H4XAXH4C3]
		+ k[rH196b] * c[sC3H3] * c[sH2O]
		+ k[rH197b] * c[sC3H3] * c[sCH4]
		+ k[rH198b] * c[sC3H3] * c[sH2]
		+ k[rH199b] * c[sC2H] * c[sCH3]
		+ k[rH215f] * c[sC3H5XTXC3H5] ) / ( CatchZero( 
		 k[rH118b] * c[sH]
		+ k[rH194b]
		+ k[rH195] * M[mM5]
		+ k[rH196f] * c[sOH]
		+ k[rH197f] * c[sCH3]
		+ k[rH198f] * c[sH]
		+ k[rH199f]
		+ k[rH215b] * c[sH] ) );

	f[sCH3CO3-speciesIn] = c[sCH3CO3] - (
		 k[rL15b] * c[sCH3CO] * c[sO2]
		+ k[rL17b] * c[sHO2] * c[sCH3CO3H] ) / ( CatchZero( 
		 k[rL14] * c[sHO2]
		+ k[rL15f]
		+ k[rL16] * c[sCH2O]
		+ k[rL17f] * c[sH2O2]
		+ k[rL18] * c[sCH3CHO]
		+ k[rL33] * c[sC2H5CHO]
		+ k[rL55] * c[sNXC3H7O2]
		+ k[rL120] * c[sTXC4H9O2]
		+ k[rL126] * c[sPXC4H9O2] ) );

	f[sXXC7H13-speciesIn] = c[sXXC7H13] - (
		 k[rHLP423f] * c[sYXC7H14] * c[sOH]
		+ k[rHLP424f] * c[sYXC7H14] * c[sH]
		+ k[rLLP297] * c[sIC8ETERACXC8H16O] * c[sOH] ) / ( CatchZero( 
		 k[rHLP420] * c[sHO2]
		+ k[rHLP423b] * c[sH2O]
		+ k[rHLP424b] * c[sH2] ) );

	f[sIC4H8OOHXTO2XC4H9O4-speciesIn] = c[sIC4H8OOHXTO2XC4H9O4] - (
		 k[rLLP147b] * c[sIC4H8O2HXTXC4H9O2] * c[sO2] ) / ( CatchZero( 
		 k[rLLP147f]
		+ k[rLLP148] ) );

	f[sC2H5O2-speciesIn] = c[sC2H5O2] - (
		 k[rH178b] * c[sC2H5] * c[sO2]
		+ k[rH179b] * c[sC2H4] * c[sHO2]
		+ k[rL10b] * c[sC2H4O2H] ) / ( CatchZero( 
		 k[rH178f]
		+ k[rH179f]
		+ k[rL9] * c[sCH2O]
		+ k[rL10f]
		+ k[rL11] * c[sHO2]
		+ k[rL12] * c[sC2H4]
		+ k[rL40] * c[sC2H5CHO]
		+ k[rL52] * c[sNXC3H7O2]
		+ k[rL131] * c[sPXC4H9O2] ) );

	f[sCH3COCH2O2-speciesIn] = c[sCH3COCH2O2] - (
		 k[rL62b] * c[sCH3COCH2] * c[sO2] ) / ( CatchZero( 
		 k[rL60] * c[sCH3COCH3]
		+ k[rL61] * c[sCH2O]
		+ k[rL62f]
		+ k[rL63] * c[sHO2] ) );

	f[sNEOC5H10OOHXO2XC5H11O4-speciesIn] = c[sNEOC5H10OOHXO2XC5H11O4] - (
		 k[rL196b] * c[sNEOXC5H10OOH] * c[sO2] ) / ( CatchZero( 
		 k[rL195]
		+ k[rL196f] ) );

	f[sYC7H13OOHXX2XC7H14O2-speciesIn] = c[sYC7H13OOHXX2XC7H14O2] - (
		 k[rLLP316] * c[sAC8H16OOHXBXC8H17O2]
		+ k[rLLP324] * c[sDC8H16OOHXBXC8H17O2] ) / ( CatchZero( 
		 k[rLLP248] ) );

	f[sPC7H14OOHXOO2XC7H15O4-speciesIn] = c[sPC7H14OOHXOO2XC7H15O4] - (
		 k[rLLP286b] * c[sYC7H14OOHXY2XC7H15O2] * c[sO2] ) / ( CatchZero( 
		 k[rLLP286f]
		+ k[rL287] ) );

	f[sC2H5COCH2-speciesIn] = c[sC2H5COCH2] - (
		 k[rLLP232] * c[sC7H14O2X5XC7H14O] * c[sHO2]
		+ k[rLLP233] * c[sC7H14O2X5XC7H14O] * c[sOH]
		+ k[rLLP283] * c[sNC7KET42XC7H14O3] ) / ( CatchZero( 
		 k[rL79] ) );

	f[sBXC6H12-speciesIn] = c[sBXC6H12] - (
		 k[rL200b] * c[sCH3] * c[sIXC5H9]
		+ k[rLLP222] * c[sYXC7H15] ) / ( CatchZero( 
		 k[rL199] * c[sCH3]
		+ k[rL200f]
		+ k[rL201] * c[sOH]
		+ k[rL202] * c[sH] ) );

	f[sC6H12OOH1X3O2XC6H13O4-speciesIn] = c[sC6H12OOH1X3O2XC6H13O4] - (
		 k[rL207b] * c[sC6H12OOH1X3XC6H13O2] * c[sO2] ) / ( CatchZero( 
		 k[rL207f]
		+ k[rL208] ) );

	f[sIC4KETITXC4H8O3-speciesIn] = c[sIC4KETITXC4H8O3] - (
		 k[rLLP148] * c[sIC4H8OOHXTO2XC4H9O4] ) / ( CatchZero( 
		 k[rLLP140]
		+ k[rLLP141] ) );

	f[sIXC6H11-speciesIn] = c[sIXC6H11] - (
		 k[rL199] * c[sBXC6H12] * c[sCH3]
		+ k[rL201] * c[sBXC6H12] * c[sOH]
		+ k[rL202] * c[sBXC6H12] * c[sH]
		+ k[rLLP217f] * c[sYXC7H14]
		+ k[rLLP224] * c[sXC7H13OXZXC7H13O] ) / ( CatchZero( 
		 k[rL198]
		+ k[rLLP217b] * c[sCH3] ) );

	f[sNEOC7KETPOXC7H14O3-speciesIn] = c[sNEOC7KETPOXC7H14O3] - (
		 k[rL287] * c[sPC7H14OOHXOO2XC7H15O4] ) / ( CatchZero( 
		 k[rL279] ) );

	f[sTXC3H6O2CHO-speciesIn] = c[sTXC3H6O2CHO] - (
		 k[rL136b] * c[sTXC3H6CHO] * c[sO2] ) / ( CatchZero( 
		 k[rL136f]
		+ k[rL137] ) );

	f[sIXC4H7OOH-speciesIn] = c[sIXC4H7OOH] - (
		 k[rL181] * c[sNEOXC5H10OOH]
		+ k[rLLP315] * c[sAC8H16OOHXBXC8H17O2] ) / ( CatchZero( 
		 k[rL109] ) );

	f[sNEOC5KETXC5H10O3-speciesIn] = c[sNEOC5KETXC5H10O3] - (
		 k[rL197] * c[sNEOC5H9Q2XNXC5H11O4] ) / ( CatchZero( 
		 k[rL192] ) );

	return 0;
}

#ifndef MECHANISM
#define MECHANISM ""
#endif

void TReaction::CheckSteadyStatesMech( const char *mechName )
{
	char	*name = new char[strlen( MECHANISM ) + 5];
	sprintf( name, "/%s.pre", MECHANISM );
	if ( strstr( mechName, name ) == 0 ) {
		cerr << "#error: program linked with mechanism " << MECHANISM << ".mech"
					<< ", input mechanism is " << mechName << NEWL;
		exit(2);
	}
	else {
		cerr << "use reduced kinetics " << MECHANISM << NEWL;
	}
}
