#include "FlameMaster.h"
#include "IC8_LLNL_red.h"

void ComputeSteadyStates( Double *k, Double *c, Double *M )
{
// c[sCXC8H17] (uncoupled) --------------------

		c[sCXC8H17] = ( 0
			+ k[rLPC350b] * c[sJXC8H16] * c[sH]
			+ k[rLPB353] * c[sIXC8H18] * c[sCH3O]
			+ k[rLPB354] * c[sIXC8H18] * c[sOH]
			+ k[rLPB355] * c[sIXC8H18] * c[sCH3O2]
			+ k[rLPB356] * c[sIXC8H18] * c[sHO2]
			+ k[rLPB357] * c[sIXC8H18] * c[sCH3]
			+ k[rLPB359] * c[sIXC8H18] * c[sH]
			+ k[rLPB361f] * c[sIXC8H18] * c[sO2]
			+ k[rLPB363] * c[sIXC8H18] * c[sO]
			+ k[rLPB375] * c[sIXC8H18] * c[sBXC8H17O2]
			+ k[rLPJ377f] * c[sBXC8H17O2]
			) / ( CatchZero(
			+ k[rLPC347]
			+ k[rLPK348] * c[sHO2]
			+ k[rLPK349] * c[sCH3O2]
			+ k[rLPC350f]
			+ k[rLPC351]
			+ k[rLPC352]
			+ k[rLPB361b] * c[sHO2]
			+ k[rLPK376] * c[sBXC8H17O2]
			+ k[rLPJ377b] * c[sO2]
			) );


// c[sHOCH2O] (uncoupled) --------------------

		c[sHOCH2O] = ( 0
			+ k[r91b] * c[sCH2O] * c[sOH]
			+ k[r92b] * c[sHOCHO] * c[sH]
			) / ( CatchZero(
			+ k[r91f]
			+ k[r92f]
			) );


// c[sC3H5O] (uncoupled) --------------------

		c[sC3H5O] = ( 0
			+ k[r164] * c[sC3H5XAXC3H5] * c[sCH3O2]
			+ k[r172] * c[sC3H5XAXC3H5] * c[sHO2]
			) / ( CatchZero(
			+ k[r197]
			+ k[r198] * c[sO2]
			+ k[r199]
			) );


// c[sNEOC5KETOXXC5H9O2] c[sTXC3H6CHO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double NEOC5KETOXXC5H9O2_denom1 = CatchZero( 0
			+ k[r316f]
			);

	 Double TXC3H6CHO_denom1 = CatchZero( 0
			+ k[r266] * c[sHO2]
			+ k[r267f]
			+ k[r268f]
			+ k[r269] * c[sHO2]
			+ k[r300b] * c[sO2]
			+ k[r316b] * c[sCH2O]
			);


// Primary constant parts -----------------------

	 Double NEOC5KETOXXC5H9O2_ct1 = ( 0
			+ k[r324] * c[sNEOC5KETXC5H10O3]
			);

	 Double TXC3H6CHO_ct1 = ( 0
			+ k[r267b] * c[sIXC3H5CHO] * c[sH]
			+ k[r268b] * c[sIXC3H6CO] * c[sH]
			+ k[r279] * c[sIXC3H7CHO] * c[sOH]
			+ k[r300f] * c[sTXC3H6O2CHO]
			+ k[rLPY365] * c[sIC8ETERACXC8H16O] * c[sOH]
			+ k[rLPX390] * c[sIC8KETBCXC8H16O3]
			);


// NEOC5KETOXXC5H9O2 ---------------------------------------

	 Double NEOC5KETOXXC5H9O2_denom2 = CatchZero( NEOC5KETOXXC5H9O2_denom1
			);

	 Double NEOC5KETOXXC5H9O2_ct2 = ( NEOC5KETOXXC5H9O2_ct1
			) / NEOC5KETOXXC5H9O2_denom2;



	 Double NEOC5KETOXXC5H9O2_TXC3H6CHO = ( 0 + k[r316b]  * c[sCH2O]
			) / NEOC5KETOXXC5H9O2_denom2 ;



	 Double NEOC5KETOXXC5H9O2_TXC3H6CHO_coeff = ( 0 + k[r316f] 
			);


// TXC3H6CHO ---------------------------------------

	 Double TXC3H6CHO_denom2 = CatchZero( TXC3H6CHO_denom1
			- NEOC5KETOXXC5H9O2_TXC3H6CHO_coeff * NEOC5KETOXXC5H9O2_TXC3H6CHO
			);

	 Double TXC3H6CHO_ct2 = ( TXC3H6CHO_ct1
			+ NEOC5KETOXXC5H9O2_TXC3H6CHO_coeff * NEOC5KETOXXC5H9O2_ct2
			) / TXC3H6CHO_denom2;






// Reconstruction ------------------------------------

	c[sTXC3H6CHO] = ( TXC3H6CHO_ct2
			) ;

	c[sNEOC5KETOXXC5H9O2] = ( NEOC5KETOXXC5H9O2_ct2
			+ NEOC5KETOXXC5H9O2_TXC3H6CHO * c[sTXC3H6CHO]
			) ;

// c[sTXC3H6O2HCO] (uncoupled) --------------------

		c[sTXC3H6O2HCO] = ( 0
			+ k[r301] * c[sTXC3H6O2CHO]
			) / ( CatchZero(
			+ k[r302]
			) );


// c[sIXC3H5CO] (uncoupled) --------------------

		c[sIXC3H5CO] = ( 0
			+ k[r249] * c[sIXC3H5CHO] * c[sH]
			+ k[r250] * c[sIXC3H5CHO] * c[sCH3]
			+ k[r251] * c[sIXC3H5CHO] * c[sO]
			+ k[r252] * c[sIXC3H5CHO] * c[sHO2]
			+ k[r253] * c[sIXC3H5CHO] * c[sOH]
			) / ( CatchZero(
			+ k[r248]
			) );


// c[sXXC7H13] (uncoupled) --------------------

		c[sXXC7H13] = ( 0
			+ k[rLP329f] * c[sYXC7H14] * c[sOH]
			+ k[rLP331f] * c[sYXC7H14] * c[sH]
			+ k[rLPY367] * c[sIC8ETERACXC8H16O] * c[sOH]
			) / ( CatchZero(
			+ k[rLP328] * c[sHO2]
			+ k[rLP329b] * c[sH2O]
			+ k[rLP331b] * c[sH2]
			) );


// c[sBC8H16OOHXCXC8H17O2] (uncoupled) --------------------

		c[sBC8H16OOHXCXC8H17O2] = ( 0
			+ k[rLPL373] * c[sBXC8H17O2]
			+ k[rLPT381b] * c[sJXC8H16] * c[sHO2]
			+ k[rLPV392f] * c[sBC8H16OOHXCO2XC8H17O4]
			) / ( CatchZero(
			+ k[rLPD379]
			+ k[rLPD380]
			+ k[rLPT381f]
			+ k[rLPS382]
			+ k[rLPD383]
			+ k[rLPD384]
			+ k[rLPD385]
			+ k[rLPV392b] * c[sO2]
			) );


// c[sYC7H13OOHXX1XC7H14O2] (uncoupled) --------------------

		c[sYC7H13OOHXX1XC7H14O2] = ( 0
			+ k[rLPD384] * c[sBC8H16OOHXCXC8H17O2]
			) / ( CatchZero(
			+ k[rLP340]
			) );


// c[sTC4H8O2HXIXC4H9O2] c[sIC4H8OOHXTO2XC4H9O4] (coupled)  --------------------

// Primary denominators-----------------------

	 Double TC4H8O2HXIXC4H9O2_denom1 = CatchZero( 0
			+ k[rLP286b]
			+ k[rLP296]
			+ k[rLP297]
			+ k[rLP298f]
			+ k[rLP307b] * c[sO2]
			);

	 Double IC4H8OOHXTO2XC4H9O4_denom1 = CatchZero( 0
			+ k[rLP307f]
			+ k[rLP308]
			);


// Primary constant parts -----------------------

	 Double TC4H8O2HXIXC4H9O2_ct1 = ( 0
			+ k[rLP286f] * c[sTXC4H9O2]
			+ k[rLP298b] * c[sIXC4H8] * c[sHO2]
			);

	 Double IC4H8OOHXTO2XC4H9O4_ct1 = ( 0
			);


// TC4H8O2HXIXC4H9O2 ---------------------------------------

	 Double TC4H8O2HXIXC4H9O2_denom2 = CatchZero( TC4H8O2HXIXC4H9O2_denom1
			);

	 Double TC4H8O2HXIXC4H9O2_ct2 = ( TC4H8O2HXIXC4H9O2_ct1
			) / TC4H8O2HXIXC4H9O2_denom2;



	 Double TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4 = ( 0 + k[rLP307f] 
			) / TC4H8O2HXIXC4H9O2_denom2 ;



	 Double TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff = ( 0 + k[rLP307b]  * c[sO2]
			);


// IC4H8OOHXTO2XC4H9O4 ---------------------------------------

	 Double IC4H8OOHXTO2XC4H9O4_denom2 = CatchZero( IC4H8OOHXTO2XC4H9O4_denom1
			- TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff * TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4
			);

	 Double IC4H8OOHXTO2XC4H9O4_ct2 = ( IC4H8OOHXTO2XC4H9O4_ct1
			+ TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4_coeff * TC4H8O2HXIXC4H9O2_ct2
			) / IC4H8OOHXTO2XC4H9O4_denom2;






// Reconstruction ------------------------------------

	c[sIC4H8OOHXTO2XC4H9O4] = ( IC4H8OOHXTO2XC4H9O4_ct2
			) ;

	c[sTC4H8O2HXIXC4H9O2] = ( TC4H8O2HXIXC4H9O2_ct2
			+ TC4H8O2HXIXC4H9O2_IC4H8OOHXTO2XC4H9O4 * c[sIC4H8OOHXTO2XC4H9O4]
			) ;

// c[sIC4KETITXC4H8O3] (uncoupled) --------------------

		c[sIC4KETITXC4H8O3] = ( 0
			+ k[rLP308] * c[sIC4H8OOHXTO2XC4H9O4]
			) / ( CatchZero(
			+ k[rLP303]
			+ k[rLP304]
			) );


// c[sXC7H13OXZXC7H13O] (uncoupled) --------------------

		c[sXC7H13OXZXC7H13O] = ( 0
			+ k[rLP328] * c[sXXC7H13] * c[sHO2]
			+ k[rLP340] * c[sYC7H13OOHXX1XC7H14O2]
			) / ( CatchZero(
			+ k[rLP336]
			) );


// c[sC3H2] (uncoupled) --------------------

		c[sC3H2] = ( 0
			+ k[r151] * c[sC3H3] * c[sH]
			+ k[r153f] * c[sC3H3] * c[sOH]
			) / ( CatchZero(
			+ k[r149] * c[sOH]
			+ k[r150] * c[sO2]
			+ k[r153b] * c[sH2O]
			) );


// c[sHCCO] (uncoupled) --------------------

		c[sHCCO] = ( 0
			+ k[r103] * c[sC2H2] * c[sO]
			+ k[r108] * c[sC2H2] * c[sO2]
			+ k[r131f] * c[sCH2CO] * c[sOH]
			+ k[r133f] * c[sCH2CO] * c[sH]
			+ k[r137] * c[sCH2CO] * c[sO]
			+ k[r150] * c[sC3H2] * c[sO2]
			) / ( CatchZero(
			+ k[r126] * c[sH]
			+ k[r127] * c[sO2]
			+ k[r128] * c[sO]
			+ k[r129] * c[sOH]
			+ k[r131b] * c[sH2O]
			+ k[r133b] * c[sH2]
			) );


// c[sC2H3] (uncoupled) --------------------

		c[sC2H3] = ( 0
			+ k[r109b] * c[sC2H2] * c[sHO2]
			+ k[r114f] * c[sC2H4] * c[sOH]
			+ k[r116f] * c[sC2H4] * c[sCH3]
			+ k[r118f] * c[sC2H4] * c[sH]
			+ k[r187f] * c[sC3H6]
			+ k[r197] * c[sC3H5O]
			) / ( CatchZero(
			+ k[r109f] * c[sO2]
			+ k[r110] * c[sO2]
			+ k[r111] * c[sO2]
			+ k[r112]
			+ k[r114b] * c[sH2O]
			+ k[r116b] * c[sCH4]
			+ k[r118b] * c[sH2]
			+ k[r187b] * c[sCH3]
			) );


// c[sCH2CHO] (uncoupled) --------------------

		c[sCH2CHO] = ( 0
			+ k[r111] * c[sC2H3] * c[sO2]
			+ k[r113] * c[sC2H4] * c[sO]
			+ k[r138b] * c[sCH2CO] * c[sH]
			+ k[r163] * c[sC3H5XAXC3H5] * c[sO2]
			) / ( CatchZero(
			+ k[r138f]
			+ k[r139] * c[sO2]
			) );


// c[sCH2] c[sCH2GSGXCH2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH2_denom1 = CatchZero( 0
			+ k[r20b] * M[mM0]
			+ k[r24] * c[sO]
			+ k[r25] * c[sO2]
			+ k[r26] * c[sO2]
			+ k[r27] * c[sO2]
			+ k[r28] * c[sO2]
			+ k[r29b] * c[sH2O]
			+ k[r31b] * c[sH2]
			+ k[r134b] * c[sCO]
			);

	 Double CH2GSGXCH2_denom1 = CatchZero( 0
			+ k[r20f] * M[mM0]
			+ k[r21f] * c[sH2]
			+ k[r22] * c[sO2]
			+ k[r23] * c[sOH]
			+ k[r32b] * c[sH2O]
			+ k[r35] * c[sCH3]
			+ k[r45f] * c[sCH4]
			+ k[r81] * c[sCO2]
			+ k[r130] * c[sCH2CO]
			);


// Primary constant parts -----------------------

	 Double CH2_ct1 = ( 0
			+ k[r29f] * c[sCH3] * c[sOH]
			+ k[r31f] * c[sCH3] * c[sH]
			+ k[r106] * c[sC2H2] * c[sO]
			+ k[r134f] * c[sCH2CO]
			+ k[r136] * c[sCH2CO] * c[sO]
			);

	 Double CH2GSGXCH2_ct1 = ( 0
			+ k[r21b] * c[sCH3] * c[sH]
			+ k[r32f] * c[sCH3] * c[sOH]
			+ k[r45b] * c[sCH3] * c[sCH3]
			+ k[r126] * c[sHCCO] * c[sH]
			);


// CH2 ---------------------------------------

	 Double CH2_denom2 = CatchZero( CH2_denom1
			);

	 Double CH2_ct2 = ( CH2_ct1
			) / CH2_denom2;



	 Double CH2_CH2GSGXCH2 = ( 0 + k[r20f]  * M[mM0]
			) / CH2_denom2 ;



	 Double CH2_CH2GSGXCH2_coeff = ( 0 + k[r20b]  * M[mM0]
			);


// CH2GSGXCH2 ---------------------------------------

	 Double CH2GSGXCH2_denom2 = CatchZero( CH2GSGXCH2_denom1
			- CH2_CH2GSGXCH2_coeff * CH2_CH2GSGXCH2
			);

	 Double CH2GSGXCH2_ct2 = ( CH2GSGXCH2_ct1
			+ CH2_CH2GSGXCH2_coeff * CH2_ct2
			) / CH2GSGXCH2_denom2;






// Reconstruction ------------------------------------

	c[sCH2GSGXCH2] = ( CH2GSGXCH2_ct2
			) ;

	c[sCH2] = ( CH2_ct2
			+ CH2_CH2GSGXCH2 * c[sCH2GSGXCH2]
			) ;

// c[sDXC8H17O] (uncoupled) --------------------

		c[sDXC8H17O] = ( 0
			+ k[rLPK348] * c[sCXC8H17] * c[sHO2]
			+ k[rLPK349] * c[sCXC8H17] * c[sCH3O2]
			+ k[rLPP371] * 2.0 * c[sBXC8H17O2] * c[sBXC8H17O2]
			+ k[rLPO372] * c[sBXC8H17O2] * c[sCH3O2]
			+ k[rLPK376] * 2.0 * c[sCXC8H17] * c[sBXC8H17O2]
			+ k[rLPQ386] * c[sBXC8H17O2H]
			) / ( CatchZero(
			+ k[rLPR368]
			+ k[rLPR369]
			+ k[rLPR370]
			) );


// c[sNEOXC5H11] (uncoupled) --------------------

		c[sNEOXC5H11] = ( 0
			+ k[r310b] * c[sIXC4H8] * c[sCH3]
			+ k[r317f] * c[sNEOXC5H11O2]
			+ k[rLPF346] * c[sJXC8H16] * c[sOH]
			+ k[rLPC347] * c[sCXC8H17]
			+ k[rLPA360] * c[sIXC8H18]
			+ k[rLPR370] * c[sDXC8H17O]
			) / ( CatchZero(
			+ k[r309] * c[sHO2]
			+ k[r310f]
			+ k[r311] * c[sCH3O2]
			+ k[r317b] * c[sO2]
			+ k[r320] * c[sNEOXC5H11O2]
			) );


// c[sYC7H14OOHXY2XC7H15O2] (uncoupled) --------------------

		c[sYC7H14OOHXY2XC7H15O2] = ( 0
			+ k[rLP342f] * c[sYXC7H15O2]
			) / ( CatchZero(
			+ k[rLP342b]
			+ k[rLP343]
			+ k[rLP344]
			+ k[rLP345]
			) );


// c[sNEOXC5H11O] (uncoupled) --------------------

		c[sNEOXC5H11O] = ( 0
			+ k[r309] * c[sNEOXC5H11] * c[sHO2]
			+ k[r311] * c[sNEOXC5H11] * c[sCH3O2]
			+ k[r319] * c[sNEOXC5H11O2] * c[sCH3O2]
			+ k[r320] * 2.0 * c[sNEOXC5H11] * c[sNEOXC5H11O2]
			+ k[r321] * 2.0 * c[sNEOXC5H11O2] * c[sNEOXC5H11O2]
			) / ( CatchZero(
			+ k[rLP315]
			) );


// c[sC2H5CO] c[sC2H5] (coupled)  --------------------

// Primary denominators-----------------------

	 Double C2H5CO_denom1 = CatchZero( 0
			+ k[r208f]
			);

	 Double C2H5_denom1 = CatchZero( 0
			+ k[r119b]
			+ k[r120] * c[sO2]
			+ k[r121b] * c[sH2O]
			+ k[r208b] * c[sCO]
			);


// Primary constant parts -----------------------

	 Double C2H5CO_ct1 = ( 0
			+ k[rLP304] * c[sIC4KETITXC4H8O3]
			);

	 Double C2H5_ct1 = ( 0
			+ k[r36] * c[sCH3] * c[sCH3]
			+ k[r119f] * c[sH] * c[sC2H4]
			+ k[r121f] * c[sC2H6] * c[sOH]
			+ k[r122] * c[sC2H6] * c[sO]
			+ k[r123] * c[sC2H6] * c[sH]
			+ k[r124] * c[sC2H6]
			+ k[r125] * c[sC2H6] * c[sCH3]
			+ k[r190] * c[sC3H6] * c[sO]
			+ k[r194] * c[sCH3CHCO] * c[sOH]
			+ k[r195] * c[sCH3CHCO] * c[sH]
			);


// C2H5CO ---------------------------------------

	 Double C2H5CO_denom2 = CatchZero( C2H5CO_denom1
			);

	 Double C2H5CO_ct2 = ( C2H5CO_ct1
			) / C2H5CO_denom2;



	 Double C2H5CO_C2H5 = ( 0 + k[r208b]  * c[sCO]
			) / C2H5CO_denom2 ;



	 Double C2H5CO_C2H5_coeff = ( 0 + k[r208f] 
			);


// C2H5 ---------------------------------------

	 Double C2H5_denom2 = CatchZero( C2H5_denom1
			- C2H5CO_C2H5_coeff * C2H5CO_C2H5
			);

	 Double C2H5_ct2 = ( C2H5_ct1
			+ C2H5CO_C2H5_coeff * C2H5CO_ct2
			) / C2H5_denom2;






// Reconstruction ------------------------------------

	c[sC2H5] = ( C2H5_ct2
			) ;

	c[sC2H5CO] = ( C2H5CO_ct2
			+ C2H5CO_C2H5 * c[sC2H5]
			) ;

// c[sIXC4H6OH] c[sIXC4H7O] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC4H6OH_denom1 = CatchZero( 0
			+ k[r260b]
			+ k[r261] * c[sCH2O]
			+ k[r262] * c[sHO2]
			+ k[rLP263]
			+ k[r264] * c[sH]
			+ k[r265] * c[sHO2]
			);

	 Double IXC4H7O_denom1 = CatchZero( 0
			+ k[r257] * c[sO2]
			+ k[r258]
			+ k[r259]
			+ k[r260f]
			);


// Primary constant parts -----------------------

	 Double IXC4H6OH_ct1 = ( 0
			+ k[r273] * c[sIXC4H7OH] * c[sOH]
			+ k[r275] * c[sIXC4H7OH] * c[sHO2]
			);

	 Double IXC4H7O_ct1 = ( 0
			+ k[r224] * c[sCH3O2] * c[sIXC4H7]
			+ k[r228] * c[sIXC4H7] * c[sHO2]
			+ k[r285] * c[sIXC4H7OOH]
			+ k[rLP294] * c[sTXC4H9O2] * c[sIXC4H7]
			);


// IXC4H6OH ---------------------------------------

	 Double IXC4H6OH_denom2 = CatchZero( IXC4H6OH_denom1
			);

	 Double IXC4H6OH_ct2 = ( IXC4H6OH_ct1
			) / IXC4H6OH_denom2;



	 Double IXC4H6OH_IXC4H7O = ( 0 + k[r260f] 
			) / IXC4H6OH_denom2 ;



	 Double IXC4H6OH_IXC4H7O_coeff = ( 0 + k[r260b] 
			);


// IXC4H7O ---------------------------------------

	 Double IXC4H7O_denom2 = CatchZero( IXC4H7O_denom1
			- IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_IXC4H7O
			);

	 Double IXC4H7O_ct2 = ( IXC4H7O_ct1
			+ IXC4H6OH_IXC4H7O_coeff * IXC4H6OH_ct2
			) / IXC4H7O_denom2;






// Reconstruction ------------------------------------

	c[sIXC4H7O] = ( IXC4H7O_ct2
			) ;

	c[sIXC4H6OH] = ( IXC4H6OH_ct2
			+ IXC4H6OH_IXC4H7O * c[sIXC4H7O]
			) ;

// c[sC3H5XTXC3H5] (uncoupled) --------------------

		c[sC3H5XTXC3H5] = ( 0
			+ k[rLP176b] * c[sC3H4XAXH4C3] * c[sH]
			+ k[r179f] * c[sC3H6] * c[sH]
			+ k[r180] * c[sC3H6] * c[sOH]
			+ k[r189] * c[sC3H6] * c[sO]
			+ k[r242] * c[sIXC4H8]
			+ k[r248] * c[sIXC3H5CO]
			+ k[r258] * c[sIXC4H7O]
			) / ( CatchZero(
			+ k[rLP176f]
			+ k[r177] * c[sO2]
			+ k[r178] * c[sO2]
			+ k[r179b] * c[sH2]
			) );


// c[sCH3COCH2O2] c[sCH3COCH2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH3COCH2O2_denom1 = CatchZero( 0
			+ k[r218] * c[sCH2O]
			+ k[r219f]
			+ k[r220] * c[sCH3COCH3]
			+ k[r221] * c[sHO2]
			);

	 Double CH3COCH2_denom1 = CatchZero( 0
			+ k[r200f]
			+ k[r219b] * c[sO2]
			);


// Primary constant parts -----------------------

	 Double CH3COCH2O2_ct1 = ( 0
			);

	 Double CH3COCH2_ct1 = ( 0
			+ k[r177] * c[sC3H5XTXC3H5] * c[sO2]
			+ k[r200b] * c[sCH2CO] * c[sCH3]
			+ k[r209] * c[sCH3COCH3] * c[sH]
			+ k[r210] * c[sCH3COCH3] * c[sOH]
			+ k[r211] * c[sCH3COCH3] * c[sO]
			+ k[r212] * c[sCH3COCH3] * c[sHO2]
			+ k[r223] * c[sIXC4H7] * c[sO2]
			);


// CH3COCH2O2 ---------------------------------------

	 Double CH3COCH2O2_denom2 = CatchZero( CH3COCH2O2_denom1
			);

	 Double CH3COCH2O2_ct2 = ( CH3COCH2O2_ct1
			) / CH3COCH2O2_denom2;



	 Double CH3COCH2O2_CH3COCH2 = ( 0 + k[r219b]  * c[sO2]
			) / CH3COCH2O2_denom2 ;



	 Double CH3COCH2O2_CH3COCH2_coeff = ( 0 + k[r219f] + k[r220] * c[sCH3COCH3] 
			);


// CH3COCH2 ---------------------------------------

	 Double CH3COCH2_denom2 = CatchZero( CH3COCH2_denom1
			- CH3COCH2O2_CH3COCH2_coeff * CH3COCH2O2_CH3COCH2
			);

	 Double CH3COCH2_ct2 = ( CH3COCH2_ct1
			+ CH3COCH2O2_CH3COCH2_coeff * CH3COCH2O2_ct2
			) / CH3COCH2_denom2;






// Reconstruction ------------------------------------

	c[sCH3COCH2] = ( CH3COCH2_ct2
			) ;

	c[sCH3COCH2O2] = ( CH3COCH2O2_ct2
			+ CH3COCH2O2_CH3COCH2 * c[sCH3COCH2]
			) ;

// c[sCH3COCH2O] c[sCH3CO] (coupled)  --------------------

// Primary denominators-----------------------

	 Double CH3COCH2O_denom1 = CatchZero( 0
			+ k[r214f]
			);

	 Double CH3CO_denom1 = CatchZero( 0
			+ k[r140f]
			+ k[r214b] * c[sCH2O]
			);


// Primary constant parts -----------------------

	 Double CH3COCH2O_ct1 = ( 0
			+ k[r222] * c[sCH3COCH2O2H]
			);

	 Double CH3CO_ct1 = ( 0
			+ k[r140b] * c[sCO] * c[sCH3]
			+ k[r141] * c[sCH3CHO] * c[sCH3]
			+ k[r142] * c[sCH3CHO] * c[sO]
			+ k[r143] * c[sCH3O2] * c[sCH3CHO]
			+ k[r145] * c[sCH3CHO] * c[sH]
			+ k[r146] * c[sCH3CHO] * c[sOH]
			+ k[r148] * c[sCH3CHO] * c[sHO2]
			+ k[r178] * c[sC3H5XTXC3H5] * c[sO2]
			+ k[r213] * c[sCH3COCH3]
			);


// CH3COCH2O ---------------------------------------

	 Double CH3COCH2O_denom2 = CatchZero( CH3COCH2O_denom1
			);

	 Double CH3COCH2O_ct2 = ( CH3COCH2O_ct1
			) / CH3COCH2O_denom2;



	 Double CH3COCH2O_CH3CO = ( 0 + k[r214b]  * c[sCH2O]
			) / CH3COCH2O_denom2 ;



	 Double CH3COCH2O_CH3CO_coeff = ( 0 + k[r214f] 
			);


// CH3CO ---------------------------------------

	 Double CH3CO_denom2 = CatchZero( CH3CO_denom1
			- CH3COCH2O_CH3CO_coeff * CH3COCH2O_CH3CO
			);

	 Double CH3CO_ct2 = ( CH3CO_ct1
			+ CH3COCH2O_CH3CO_coeff * CH3COCH2O_ct2
			) / CH3CO_denom2;






// Reconstruction ------------------------------------

	c[sCH3CO] = ( CH3CO_ct2
			) ;

	c[sCH3COCH2O] = ( CH3COCH2O_ct2
			+ CH3COCH2O_CH3CO * c[sCH3CO]
			) ;

// c[sCH2CCH2OH] (uncoupled) --------------------

		c[sCH2CCH2OH] = ( 0
			+ k[rLP205b] * c[sC3H4XAXH4C3] * c[sOH]
			+ k[r262] * c[sIXC4H6OH] * c[sHO2]
			+ k[r274] * c[sIXC4H7OH]
			) / ( CatchZero(
			+ k[rLP205f]
			+ k[r206]
			+ k[r207] * c[sO2]
			) );


// c[sCH2OH] (uncoupled) --------------------

		c[sCH2OH] = ( 0
			+ k[r71b] * c[sH] * c[sCH2O]
			+ k[r74] * c[sCH3OH] * c[sO]
			+ k[r76] * c[sCH3OH] * c[sH]
			+ k[r77] * c[sCH3OH] * c[sHO2]
			+ k[r78] * c[sCH3OH] * c[sOH]
			+ k[r80] * c[sCH3OH]
			+ k[r95] * c[sCH3OH] * c[sCH3O2]
			+ k[r132] * c[sCH2CO] * c[sOH]
			+ k[r206] * c[sCH2CCH2OH]
			+ k[r207] * c[sCH2CCH2OH] * c[sO2]
			+ k[rLP263] * c[sIXC4H6OH]
			) / ( CatchZero(
			+ k[r71f]
			+ k[r72] * c[sCH2O]
			+ k[r73] * c[sO2]
			) );


// c[sCH3CHCHO] (uncoupled) --------------------

		c[sCH3CHCHO] = ( 0
			+ k[r201b] * c[sCH3CHCO] * c[sH]
			+ k[r202b] * c[sC2H3CHO] * c[sH]
			+ k[rLPX391] * c[sIC8KETBCXC8H16O3]
			) / ( CatchZero(
			+ k[r201f]
			+ k[r202f]
			+ k[r203] * c[sO2]
			+ k[r204] * c[sO2]
			) );


// c[sIXC4H8OH] c[sIXO2C4H8OH] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC4H8OH_denom1 = CatchZero( 0
			+ k[r283f]
			+ k[r306b] * c[sO2]
			);

	 Double IXO2C4H8OH_denom1 = CatchZero( 0
			+ k[r305]
			+ k[r306f]
			);


// Primary constant parts -----------------------

	 Double IXC4H8OH_ct1 = ( 0
			+ k[r276] * c[sIXC4H7OH] * c[sH]
			+ k[r283b] * c[sIXC4H8] * c[sOH]
			);

	 Double IXO2C4H8OH_ct1 = ( 0
			);


// IXC4H8OH ---------------------------------------

	 Double IXC4H8OH_denom2 = CatchZero( IXC4H8OH_denom1
			);

	 Double IXC4H8OH_ct2 = ( IXC4H8OH_ct1
			) / IXC4H8OH_denom2;



	 Double IXC4H8OH_IXO2C4H8OH = ( 0 + k[r306f] 
			) / IXC4H8OH_denom2 ;



	 Double IXC4H8OH_IXO2C4H8OH_coeff = ( 0 + k[r306b]  * c[sO2]
			);


// IXO2C4H8OH ---------------------------------------

	 Double IXO2C4H8OH_denom2 = CatchZero( IXO2C4H8OH_denom1
			- IXC4H8OH_IXO2C4H8OH_coeff * IXC4H8OH_IXO2C4H8OH
			);

	 Double IXO2C4H8OH_ct2 = ( IXO2C4H8OH_ct1
			+ IXC4H8OH_IXO2C4H8OH_coeff * IXC4H8OH_ct2
			) / IXO2C4H8OH_denom2;






// Reconstruction ------------------------------------

	c[sIXO2C4H8OH] = ( IXO2C4H8OH_ct2
			) ;

	c[sIXC4H8OH] = ( IXC4H8OH_ct2
			+ IXC4H8OH_IXO2C4H8OH * c[sIXO2C4H8OH]
			) ;

// c[sTXC3H6OCHO] (uncoupled) --------------------

		c[sTXC3H6OCHO] = ( 0
			+ k[r269] * c[sTXC3H6CHO] * c[sHO2]
			) / ( CatchZero(
			+ k[r284]
			) );


// c[sYXC7H15] (uncoupled) --------------------

		c[sYXC7H15] = ( 0
			+ k[rLP333b] * c[sYXC7H14] * c[sH]
			+ k[rLP341f] * c[sYXC7H15O2]
			+ k[rLPA358] * c[sIXC8H18]
			+ k[rLPR368] * c[sDXC8H17O]
			) / ( CatchZero(
			+ k[rLP333f]
			+ k[rLP334]
			+ k[rLP335]
			+ k[rLP341b] * c[sO2]
			) );


// c[sTXC4H9CO] c[sTXC4H9] c[sTC4H9COC2H4SXC7H13O] (coupled)  --------------------

// Primary denominators-----------------------

	 Double TXC4H9CO_denom1 = CatchZero( 0
			+ k[rLP312f]
			);

	 Double TXC4H9_denom1 = CatchZero( 0
			+ k[rLP244f]
			+ k[rLP245] * c[sHO2]
			+ k[rLP246f]
			+ k[rLP247] * c[sCH3O2]
			+ k[rLP288] * c[sTXC4H9O2]
			+ k[rLP289b] * c[sO2]
			+ k[rLP312b] * c[sCO]
			+ k[rLP332b] * c[sC3H5XAXC3H5]
			+ k[rLP338b] * c[sCH3CHCO]
			);

	 Double TC4H9COC2H4SXC7H13O_denom1 = CatchZero( 0
			+ k[rLP338f]
			);


// Primary constant parts -----------------------

	 Double TXC4H9CO_ct1 = ( 0
			+ k[r313] * c[sTXC4H9CHO] * c[sOH]
			+ k[r314] * c[sTXC4H9CHO] * c[sHO2]
			+ k[rLPY364] * c[sIC8ETERACXC8H16O] * c[sOH]
			+ k[rLPX387] * c[sIC8KETBCXC8H16O3]
			);

	 Double TXC4H9_ct1 = ( 0
			+ k[rLP244b] * c[sIXC4H8] * c[sH]
			+ k[rLP246b] * c[sC3H6] * c[sCH3]
			+ k[rLP289f] * c[sTXC4H9O2]
			+ k[rLP315] * c[sNEOXC5H11O]
			+ k[rLP332f] * c[sYXC7H14]
			+ k[rLP334] * c[sYXC7H15]
			+ k[rLPC351] * c[sCXC8H17]
			+ k[rLPA362] * 2.0 * c[sIXC8H18]
			+ k[rLPR369] * c[sDXC8H17O]
			+ k[rLPD380] * c[sBC8H16OOHXCXC8H17O2]
			);

	 Double TC4H9COC2H4SXC7H13O_ct1 = ( 0
			+ k[rLPX388] * c[sIC8KETBCXC8H16O3]
			);


// TXC4H9CO ---------------------------------------

	 Double TXC4H9CO_denom2 = CatchZero( TXC4H9CO_denom1
			);

	 Double TXC4H9CO_ct2 = ( TXC4H9CO_ct1
			) / TXC4H9CO_denom2;



	 Double TXC4H9CO_TXC4H9 = ( 0 + k[rLP312b]  * c[sCO]
			) / TXC4H9CO_denom2 ;

	 Double TXC4H9CO_TC4H9COC2H4SXC7H13O = ( 0 
			) / TXC4H9CO_denom2 ;



	 Double TXC4H9CO_TXC4H9_coeff = ( 0 + k[rLP312f] 
			);

	 Double TXC4H9CO_TC4H9COC2H4SXC7H13O_coeff = ( 0 
			);


// TXC4H9 ---------------------------------------

	 Double TXC4H9_denom2 = CatchZero( TXC4H9_denom1
			- TXC4H9CO_TXC4H9_coeff * TXC4H9CO_TXC4H9
			);

	 Double TXC4H9_ct2 = ( TXC4H9_ct1
			+ TXC4H9CO_TXC4H9_coeff * TXC4H9CO_ct2
			) / TXC4H9_denom2;



	 Double TXC4H9_TC4H9COC2H4SXC7H13O = ( 0 + k[rLP338f] 
			+ TXC4H9CO_TXC4H9_coeff * TXC4H9CO_TC4H9COC2H4SXC7H13O
			) / TXC4H9_denom2 ;



	 Double TXC4H9_TC4H9COC2H4SXC7H13O_coeff = ( 0 + k[rLP338b] * c[sCH3CHCO] 
			+ TXC4H9CO_TC4H9COC2H4SXC7H13O_coeff * TXC4H9CO_TXC4H9
			);


// TC4H9COC2H4SXC7H13O ---------------------------------------

	 Double TC4H9COC2H4SXC7H13O_denom2 = CatchZero( TC4H9COC2H4SXC7H13O_denom1
			- TXC4H9CO_TC4H9COC2H4SXC7H13O_coeff * TXC4H9CO_TC4H9COC2H4SXC7H13O
			- TXC4H9_TC4H9COC2H4SXC7H13O_coeff * TXC4H9_TC4H9COC2H4SXC7H13O
			);

	 Double TC4H9COC2H4SXC7H13O_ct2 = ( TC4H9COC2H4SXC7H13O_ct1
			+ TXC4H9CO_TC4H9COC2H4SXC7H13O_coeff * TXC4H9CO_ct2
			+ TXC4H9_TC4H9COC2H4SXC7H13O_coeff * TXC4H9_ct2
			) / TC4H9COC2H4SXC7H13O_denom2;






// Reconstruction ------------------------------------

	c[sTC4H9COC2H4SXC7H13O] = ( TC4H9COC2H4SXC7H13O_ct2
			) ;

	c[sTXC4H9] = ( TXC4H9_ct2
			+ TXC4H9_TC4H9COC2H4SXC7H13O * c[sTC4H9COC2H4SXC7H13O]
			) ;

	c[sTXC4H9CO] = ( TXC4H9CO_ct2
			+ TXC4H9CO_TXC4H9 * c[sTXC4H9]
			+ TXC4H9CO_TC4H9COC2H4SXC7H13O * c[sTC4H9COC2H4SXC7H13O]
			) ;

// c[sTXC4H9O] (uncoupled) --------------------

		c[sTXC4H9O] = ( 0
			+ k[rLP245] * c[sTXC4H9] * c[sHO2]
			+ k[rLP247] * c[sCH3O2] * c[sTXC4H9]
			+ k[rLP280b] * c[sIXC3H7CHO] * c[sH]
			+ k[rLP288] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9]
			+ k[rLP291] * c[sTXC4H9O2] * c[sCH3]
			+ k[rLP292] * c[sTXC4H9O2] * c[sCH3O2]
			+ k[rLP294] * c[sTXC4H9O2] * c[sIXC4H7]
			+ k[rLP295] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
			+ k[rLP299] * c[sTXC4H9O2H]
			) / ( CatchZero(
			+ k[rLP280f]
			+ k[rLP281]
			+ k[rLP282]
			) );


// c[sIXC3H7] c[sIXC3H7O2] (coupled)  --------------------

// Primary denominators-----------------------

	 Double IXC3H7_denom1 = CatchZero( 0
			+ k[rLP191f]
			+ k[rLP192] * c[sO2]
			+ k[rLP193f]
			+ k[rLP215b] * c[sO2]
			+ k[rLP330b] * c[sIXC4H7]
			+ k[rLP337b] * c[sIXC3H6CO]
			);

	 Double IXC3H7O2_denom1 = CatchZero( 0
			+ k[rLP215f]
			+ k[r216]
			);


// Primary constant parts -----------------------

	 Double IXC3H7_ct1 = ( 0
			+ k[rLP191b] * c[sCH3] * c[sC2H4]
			+ k[rLP193b] * c[sH] * c[sC3H6]
			+ k[rLP237] * c[sIXC4H8] * c[sO]
			+ k[rLP254] * c[sIXC3H6CO] * c[sH]
			+ k[rLP256] * c[sIXC3H6CO] * c[sOH]
			+ k[rLP278] * c[sIXC3H7CHO]
			+ k[rLP282] * c[sTXC4H9O]
			+ k[rLP330f] * c[sYXC7H14]
			+ k[rLP335] * c[sYXC7H15]
			+ k[rLP336] * c[sXC7H13OXZXC7H13O]
			+ k[rLP337f] * c[sIC3H7COC3H6XTXC7H13O]
			+ k[rLPA360] * c[sIXC8H18]
			);

	 Double IXC3H7O2_ct1 = ( 0
			);


// IXC3H7 ---------------------------------------

	 Double IXC3H7_denom2 = CatchZero( IXC3H7_denom1
			);

	 Double IXC3H7_ct2 = ( IXC3H7_ct1
			) / IXC3H7_denom2;



	 Double IXC3H7_IXC3H7O2 = ( 0 + k[rLP215f] 
			) / IXC3H7_denom2 ;



	 Double IXC3H7_IXC3H7O2_coeff = ( 0 + k[rLP215b]  * c[sO2]
			);


// IXC3H7O2 ---------------------------------------

	 Double IXC3H7O2_denom2 = CatchZero( IXC3H7O2_denom1
			- IXC3H7_IXC3H7O2_coeff * IXC3H7_IXC3H7O2
			);

	 Double IXC3H7O2_ct2 = ( IXC3H7O2_ct1
			+ IXC3H7_IXC3H7O2_coeff * IXC3H7_ct2
			) / IXC3H7O2_denom2;






// Reconstruction ------------------------------------

	c[sIXC3H7O2] = ( IXC3H7O2_ct2
			) ;

	c[sIXC3H7] = ( IXC3H7_ct2
			+ IXC3H7_IXC3H7O2 * c[sIXC3H7O2]
			) ;

// c[sC3H6OOH2X1XC3H7O2] (uncoupled) --------------------

		c[sC3H6OOH2X1XC3H7O2] = ( 0
			+ k[r216] * c[sIXC3H7O2]
			+ k[r217b] * c[sC3H6] * c[sHO2]
			) / ( CatchZero(
			+ k[r217f]
			) );


// c[sNEOXC5H10OOH] c[sNEOC5H10OOHXO2XC5H11O4] (coupled)  --------------------

// Primary denominators-----------------------

	 Double NEOXC5H10OOH_denom1 = CatchZero( 0
			+ k[r318b]
			+ k[r322]
			+ k[r323]
			+ k[r325b] * c[sO2]
			);

	 Double NEOC5H10OOHXO2XC5H11O4_denom1 = CatchZero( 0
			+ k[r325f]
			+ k[r326]
			);


// Primary constant parts -----------------------

	 Double NEOXC5H10OOH_ct1 = ( 0
			+ k[r318f] * c[sNEOXC5H11O2]
			);

	 Double NEOC5H10OOHXO2XC5H11O4_ct1 = ( 0
			);


// NEOXC5H10OOH ---------------------------------------

	 Double NEOXC5H10OOH_denom2 = CatchZero( NEOXC5H10OOH_denom1
			);

	 Double NEOXC5H10OOH_ct2 = ( NEOXC5H10OOH_ct1
			) / NEOXC5H10OOH_denom2;



	 Double NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4 = ( 0 + k[r325f] 
			) / NEOXC5H10OOH_denom2 ;



	 Double NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff = ( 0 + k[r325b]  * c[sO2]
			);


// NEOC5H10OOHXO2XC5H11O4 ---------------------------------------

	 Double NEOC5H10OOHXO2XC5H11O4_denom2 = CatchZero( NEOC5H10OOHXO2XC5H11O4_denom1
			- NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff * NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4
			);

	 Double NEOC5H10OOHXO2XC5H11O4_ct2 = ( NEOC5H10OOHXO2XC5H11O4_ct1
			+ NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4_coeff * NEOXC5H10OOH_ct2
			) / NEOC5H10OOHXO2XC5H11O4_denom2;






// Reconstruction ------------------------------------

	c[sNEOC5H10OOHXO2XC5H11O4] = ( NEOC5H10OOHXO2XC5H11O4_ct2
			) ;

	c[sNEOXC5H10OOH] = ( NEOXC5H10OOH_ct2
			+ NEOXC5H10OOH_NEOC5H10OOHXO2XC5H11O4 * c[sNEOC5H10OOHXO2XC5H11O4]
			) ;

// c[sNEOC5H9Q2XNXC5H11O4] (uncoupled) --------------------

		c[sNEOC5H9Q2XNXC5H11O4] = ( 0
			+ k[r326] * c[sNEOC5H10OOHXO2XC5H11O4]
			) / ( CatchZero(
			+ k[r327]
			) );


// c[sC2H] (uncoupled) --------------------

		c[sC2H] = ( 0
			+ k[r107f] * c[sC2H2] * c[sOH]
			+ k[r152] * c[sC3H3] * c[sO]
			+ k[rLP157f] * c[sC3H4XAXH4C3]
			) / ( CatchZero(
			+ k[r101] * c[sO2]
			+ k[r102] * c[sOH]
			+ k[r107b] * c[sH2O]
			+ k[rLP157b] * c[sCH3]
			) );


// c[sHCO] (uncoupled) --------------------

		c[sHCO] = ( 0
			+ k[r52b] * c[sCO] * c[sH2]
			+ k[r54b] * c[sH] * c[sCO] * M[mM0]
			+ k[r56b] * c[sCO] * c[sHO2]
			+ k[r58f] * c[sCH2O] * c[sH]
			+ k[r60] * c[sCH2O] * c[sCH3]
			+ k[r61] * c[sCH2O] * c[sO]
			+ k[r62] * c[sCH2O] * M[mM0]
			+ k[r63] * c[sCH2O] * c[sO2]
			+ k[r64] * c[sCH2O] * c[sHO2]
			+ k[r65] * c[sCH2O] * c[sOH]
			+ k[r67] * c[sCH2O] * c[sCH3O]
			+ k[r72] * c[sCH2OH] * c[sCH2O]
			+ k[r89f] * c[sHOCHO]
			+ k[r97] * c[sCH3O2] * c[sCH2O]
			+ k[r101] * c[sC2H] * c[sO2]
			+ k[r110] * c[sC2H3] * c[sO2]
			+ k[r115] * c[sC2H4] * c[sO]
			+ k[r127] * c[sHCCO] * c[sO2]
			+ k[r129] * 2.0 * c[sHCCO] * c[sOH]
			+ k[r144f] * c[sCH3CHO]
			+ k[r149] * c[sC3H2] * c[sOH]
			+ k[r154] * c[sC3H3] * c[sO2]
			+ k[r167f] * c[sC3H5XAXC3H5] * c[sCH2O]
			+ k[r190] * c[sC3H6] * c[sO]
			+ k[r218] * c[sCH2O] * c[sCH3COCH2O2]
			+ k[rLP237] * c[sIXC4H8] * c[sO]
			+ k[r261] * c[sIXC4H6OH] * c[sCH2O]
			+ k[rLP278] * c[sIXC3H7CHO]
			+ k[r284] * c[sTXC3H6OCHO]
			+ k[rLP290] * c[sTXC4H9O2] * c[sCH2O]
			+ k[rLP303] * c[sIC4KETITXC4H8O3]
			+ k[rLPY366] * c[sIC8ETERACXC8H16O] * c[sOH]
			) / ( CatchZero(
			+ k[r51] * c[sOH]
			+ k[r52f] * c[sH]
			+ k[r53] * c[sO]
			+ k[r54f] * M[mM0]
			+ k[r55] * c[sO]
			+ k[r56f] * c[sO2]
			+ k[r57] * c[sCH3]
			+ k[r58b] * c[sH2]
			+ k[r89b] * c[sOH]
			+ k[r144b] * c[sCH3]
			+ k[r167b] * c[sC3H6]
			) );


}

int SteadyStatesFunc( const VectorPtr /*x*/, VectorPtr fVec, void *object )
{
	int		speciesIn;
	Double	*c;
	Double	*k;
	Double	*M;
	Double	*f = fVec->vec;
	SteadyStateInfoPtr ssInfo = ( SteadyStateInfoPtr )object;
	ssInfo->GetSteadyStateInfo( &c, &k, &M, &speciesIn );

	f[sNEOC5H9Q2XNXC5H11O4-speciesIn] = c[sNEOC5H9Q2XNXC5H11O4] - (
		 k[r326] * c[sNEOC5H10OOHXO2XC5H11O4] ) / ( CatchZero( 
		 k[r327] ) );

	f[sTXC3H6O2HCO-speciesIn] = c[sTXC3H6O2HCO] - (
		 k[r301] * c[sTXC3H6O2CHO] ) / ( CatchZero( 
		 k[r302] ) );

	f[sTXC4H9CO-speciesIn] = c[sTXC4H9CO] - (
		 k[rLP312b] * c[sTXC4H9] * c[sCO]
		+ k[r313] * c[sTXC4H9CHO] * c[sOH]
		+ k[r314] * c[sTXC4H9CHO] * c[sHO2]
		+ k[rLPY364] * c[sIC8ETERACXC8H16O] * c[sOH]
		+ k[rLPX387] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rLP312f] ) );

	f[sTXC3H6OCHO-speciesIn] = c[sTXC3H6OCHO] - (
		 k[r269] * c[sTXC3H6CHO] * c[sHO2] ) / ( CatchZero( 
		 k[r284] ) );

	f[sNEOC5KETOXXC5H9O2-speciesIn] = c[sNEOC5KETOXXC5H9O2] - (
		 k[r316b] * c[sTXC3H6CHO] * c[sCH2O]
		+ k[r324] * c[sNEOC5KETXC5H10O3] ) / ( CatchZero( 
		 k[r316f] ) );

	f[sXC7H13OXZXC7H13O-speciesIn] = c[sXC7H13OXZXC7H13O] - (
		 k[rLP328] * c[sXXC7H13] * c[sHO2]
		+ k[rLP340] * c[sYC7H13OOHXX1XC7H14O2] ) / ( CatchZero( 
		 k[rLP336] ) );

	f[sHOCH2O-speciesIn] = c[sHOCH2O] - (
		 k[r91b] * c[sCH2O] * c[sOH]
		+ k[r92b] * c[sHOCHO] * c[sH] ) / ( CatchZero( 
		 k[r91f]
		+ k[r92f] ) );

	f[sDXC8H17O-speciesIn] = c[sDXC8H17O] - (
		 k[rLPK348] * c[sCXC8H17] * c[sHO2]
		+ k[rLPK349] * c[sCXC8H17] * c[sCH3O2]
		+ k[rLPP371] * 2.0 * c[sBXC8H17O2] * c[sBXC8H17O2]
		+ k[rLPO372] * c[sBXC8H17O2] * c[sCH3O2]
		+ k[rLPK376] * 2.0 * c[sCXC8H17] * c[sBXC8H17O2]
		+ k[rLPQ386] * c[sBXC8H17O2H] ) / ( CatchZero( 
		 k[rLPR368]
		+ k[rLPR369]
		+ k[rLPR370] ) );

	f[sNEOXC5H11O-speciesIn] = c[sNEOXC5H11O] - (
		 k[r309] * c[sNEOXC5H11] * c[sHO2]
		+ k[r311] * c[sNEOXC5H11] * c[sCH3O2]
		+ k[r319] * c[sNEOXC5H11O2] * c[sCH3O2]
		+ k[r320] * 2.0 * c[sNEOXC5H11] * c[sNEOXC5H11O2]
		+ k[r321] * 2.0 * c[sNEOXC5H11O2] * c[sNEOXC5H11O2] ) / ( CatchZero( 
		 k[rLP315] ) );

	f[sCH3COCH2O-speciesIn] = c[sCH3COCH2O] - (
		 k[r214b] * c[sCH3CO] * c[sCH2O]
		+ k[r222] * c[sCH3COCH2O2H] ) / ( CatchZero( 
		 k[r214f] ) );

	f[sTXC4H9O-speciesIn] = c[sTXC4H9O] - (
		 k[rLP245] * c[sTXC4H9] * c[sHO2]
		+ k[rLP247] * c[sCH3O2] * c[sTXC4H9]
		+ k[rLP280b] * c[sIXC3H7CHO] * c[sH]
		+ k[rLP288] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9]
		+ k[rLP291] * c[sTXC4H9O2] * c[sCH3]
		+ k[rLP292] * c[sTXC4H9O2] * c[sCH3O2]
		+ k[rLP294] * c[sTXC4H9O2] * c[sIXC4H7]
		+ k[rLP295] * 2.0 * c[sTXC4H9O2] * c[sTXC4H9O2]
		+ k[rLP299] * c[sTXC4H9O2H] ) / ( CatchZero( 
		 k[rLP280f]
		+ k[rLP281]
		+ k[rLP282] ) );

	f[sC3H6OOH2X1XC3H7O2-speciesIn] = c[sC3H6OOH2X1XC3H7O2] - (
		 k[r216] * c[sIXC3H7O2]
		+ k[r217b] * c[sC3H6] * c[sHO2] ) / ( CatchZero( 
		 k[r217f] ) );

	f[sC3H5O-speciesIn] = c[sC3H5O] - (
		 k[r164] * c[sC3H5XAXC3H5] * c[sCH3O2]
		+ k[r172] * c[sC3H5XAXC3H5] * c[sHO2] ) / ( CatchZero( 
		 k[r197]
		+ k[r198] * c[sO2]
		+ k[r199] ) );

	f[sCH3CHCHO-speciesIn] = c[sCH3CHCHO] - (
		 k[r201b] * c[sCH3CHCO] * c[sH]
		+ k[r202b] * c[sC2H3CHO] * c[sH]
		+ k[rLPX391] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[r201f]
		+ k[r202f]
		+ k[r203] * c[sO2]
		+ k[r204] * c[sO2] ) );

	f[sCH2CCH2OH-speciesIn] = c[sCH2CCH2OH] - (
		 k[rLP205b] * c[sC3H4XAXH4C3] * c[sOH]
		+ k[r262] * c[sIXC4H6OH] * c[sHO2]
		+ k[r274] * c[sIXC4H7OH] ) / ( CatchZero( 
		 k[rLP205f]
		+ k[r206]
		+ k[r207] * c[sO2] ) );

	f[sTC4H8O2HXIXC4H9O2-speciesIn] = c[sTC4H8O2HXIXC4H9O2] - (
		 k[rLP286f] * c[sTXC4H9O2]
		+ k[rLP298b] * c[sIXC4H8] * c[sHO2]
		+ k[rLP307f] * c[sIC4H8OOHXTO2XC4H9O4] ) / ( CatchZero( 
		 k[rLP286b]
		+ k[rLP296]
		+ k[rLP297]
		+ k[rLP298f]
		+ k[rLP307b] * c[sO2] ) );

	f[sCH3CO-speciesIn] = c[sCH3CO] - (
		 k[r140b] * c[sCO] * c[sCH3]
		+ k[r141] * c[sCH3CHO] * c[sCH3]
		+ k[r142] * c[sCH3CHO] * c[sO]
		+ k[r143] * c[sCH3O2] * c[sCH3CHO]
		+ k[r145] * c[sCH3CHO] * c[sH]
		+ k[r146] * c[sCH3CHO] * c[sOH]
		+ k[r148] * c[sCH3CHO] * c[sHO2]
		+ k[r178] * c[sC3H5XTXC3H5] * c[sO2]
		+ k[r213] * c[sCH3COCH3]
		+ k[r214f] * c[sCH3COCH2O] ) / ( CatchZero( 
		 k[r140f]
		+ k[r214b] * c[sCH2O] ) );

	f[sCH2CHO-speciesIn] = c[sCH2CHO] - (
		 k[r111] * c[sC2H3] * c[sO2]
		+ k[r113] * c[sC2H4] * c[sO]
		+ k[r138b] * c[sCH2CO] * c[sH]
		+ k[r163] * c[sC3H5XAXC3H5] * c[sO2] ) / ( CatchZero( 
		 k[r138f]
		+ k[r139] * c[sO2] ) );

	f[sIXC4H7O-speciesIn] = c[sIXC4H7O] - (
		 k[r224] * c[sCH3O2] * c[sIXC4H7]
		+ k[r228] * c[sIXC4H7] * c[sHO2]
		+ k[r260b] * c[sIXC4H6OH]
		+ k[r285] * c[sIXC4H7OOH]
		+ k[rLP294] * c[sTXC4H9O2] * c[sIXC4H7] ) / ( CatchZero( 
		 k[r257] * c[sO2]
		+ k[r258]
		+ k[r259]
		+ k[r260f] ) );

	f[sNEOXC5H10OOH-speciesIn] = c[sNEOXC5H10OOH] - (
		 k[r318f] * c[sNEOXC5H11O2]
		+ k[r325f] * c[sNEOC5H10OOHXO2XC5H11O4] ) / ( CatchZero( 
		 k[r318b]
		+ k[r322]
		+ k[r323]
		+ k[r325b] * c[sO2] ) );

	f[sCH2OH-speciesIn] = c[sCH2OH] - (
		 k[r71b] * c[sH] * c[sCH2O]
		+ k[r74] * c[sCH3OH] * c[sO]
		+ k[r76] * c[sCH3OH] * c[sH]
		+ k[r77] * c[sCH3OH] * c[sHO2]
		+ k[r78] * c[sCH3OH] * c[sOH]
		+ k[r80] * c[sCH3OH]
		+ k[r95] * c[sCH3OH] * c[sCH3O2]
		+ k[r132] * c[sCH2CO] * c[sOH]
		+ k[r206] * c[sCH2CCH2OH]
		+ k[r207] * c[sCH2CCH2OH] * c[sO2]
		+ k[rLP263] * c[sIXC4H6OH] ) / ( CatchZero( 
		 k[r71f]
		+ k[r72] * c[sCH2O]
		+ k[r73] * c[sO2] ) );

	f[sC3H5XTXC3H5-speciesIn] = c[sC3H5XTXC3H5] - (
		 k[rLP176b] * c[sC3H4XAXH4C3] * c[sH]
		+ k[r179f] * c[sC3H6] * c[sH]
		+ k[r180] * c[sC3H6] * c[sOH]
		+ k[r189] * c[sC3H6] * c[sO]
		+ k[r242] * c[sIXC4H8]
		+ k[r248] * c[sIXC3H5CO]
		+ k[r258] * c[sIXC4H7O] ) / ( CatchZero( 
		 k[rLP176f]
		+ k[r177] * c[sO2]
		+ k[r178] * c[sO2]
		+ k[r179b] * c[sH2] ) );

	f[sC3H2-speciesIn] = c[sC3H2] - (
		 k[r151] * c[sC3H3] * c[sH]
		+ k[r153f] * c[sC3H3] * c[sOH] ) / ( CatchZero( 
		 k[r149] * c[sOH]
		+ k[r150] * c[sO2]
		+ k[r153b] * c[sH2O] ) );

	f[sIXC4H8OH-speciesIn] = c[sIXC4H8OH] - (
		 k[r276] * c[sIXC4H7OH] * c[sH]
		+ k[r283b] * c[sIXC4H8] * c[sOH]
		+ k[r306f] * c[sIXO2C4H8OH] ) / ( CatchZero( 
		 k[r283f]
		+ k[r306b] * c[sO2] ) );

	f[sNEOXC5H11-speciesIn] = c[sNEOXC5H11] - (
		 k[r310b] * c[sIXC4H8] * c[sCH3]
		+ k[r317f] * c[sNEOXC5H11O2]
		+ k[rLPF346] * c[sJXC8H16] * c[sOH]
		+ k[rLPC347] * c[sCXC8H17]
		+ k[rLPA360] * c[sIXC8H18]
		+ k[rLPR370] * c[sDXC8H17O] ) / ( CatchZero( 
		 k[r309] * c[sHO2]
		+ k[r310f]
		+ k[r311] * c[sCH3O2]
		+ k[r317b] * c[sO2]
		+ k[r320] * c[sNEOXC5H11O2] ) );

	f[sBC8H16OOHXCXC8H17O2-speciesIn] = c[sBC8H16OOHXCXC8H17O2] - (
		 k[rLPL373] * c[sBXC8H17O2]
		+ k[rLPT381b] * c[sJXC8H16] * c[sHO2]
		+ k[rLPV392f] * c[sBC8H16OOHXCO2XC8H17O4] ) / ( CatchZero( 
		 k[rLPD379]
		+ k[rLPD380]
		+ k[rLPT381f]
		+ k[rLPS382]
		+ k[rLPD383]
		+ k[rLPD384]
		+ k[rLPD385]
		+ k[rLPV392b] * c[sO2] ) );

	f[sCH3COCH2-speciesIn] = c[sCH3COCH2] - (
		 k[r177] * c[sC3H5XTXC3H5] * c[sO2]
		+ k[r200b] * c[sCH2CO] * c[sCH3]
		+ k[r209] * c[sCH3COCH3] * c[sH]
		+ k[r210] * c[sCH3COCH3] * c[sOH]
		+ k[r211] * c[sCH3COCH3] * c[sO]
		+ k[r212] * c[sCH3COCH3] * c[sHO2]
		+ k[r219f] * c[sCH3COCH2O2]
		+ k[r220] * c[sCH3COCH3] * c[sCH3COCH2O2]
		+ k[r223] * c[sIXC4H7] * c[sO2] ) / ( CatchZero( 
		 k[r200f]
		+ k[r219b] * c[sO2] ) );

	f[sYXC7H15-speciesIn] = c[sYXC7H15] - (
		 k[rLP333b] * c[sYXC7H14] * c[sH]
		+ k[rLP341f] * c[sYXC7H15O2]
		+ k[rLPA358] * c[sIXC8H18]
		+ k[rLPR368] * c[sDXC8H17O] ) / ( CatchZero( 
		 k[rLP333f]
		+ k[rLP334]
		+ k[rLP335]
		+ k[rLP341b] * c[sO2] ) );

	f[sC2H-speciesIn] = c[sC2H] - (
		 k[r107f] * c[sC2H2] * c[sOH]
		+ k[r152] * c[sC3H3] * c[sO]
		+ k[rLP157f] * c[sC3H4XAXH4C3] ) / ( CatchZero( 
		 k[r101] * c[sO2]
		+ k[r102] * c[sOH]
		+ k[r107b] * c[sH2O]
		+ k[rLP157b] * c[sCH3] ) );

	f[sYC7H14OOHXY2XC7H15O2-speciesIn] = c[sYC7H14OOHXY2XC7H15O2] - (
		 k[rLP342f] * c[sYXC7H15O2] ) / ( CatchZero( 
		 k[rLP342b]
		+ k[rLP343]
		+ k[rLP344]
		+ k[rLP345] ) );

	f[sCH2GSGXCH2-speciesIn] = c[sCH2GSGXCH2] - (
		 k[r20b] * c[sCH2] * M[mM0]
		+ k[r21b] * c[sCH3] * c[sH]
		+ k[r32f] * c[sCH3] * c[sOH]
		+ k[r45b] * c[sCH3] * c[sCH3]
		+ k[r126] * c[sHCCO] * c[sH] ) / ( CatchZero( 
		 k[r20f] * M[mM0]
		+ k[r21f] * c[sH2]
		+ k[r22] * c[sO2]
		+ k[r23] * c[sOH]
		+ k[r32b] * c[sH2O]
		+ k[r35] * c[sCH3]
		+ k[r45f] * c[sCH4]
		+ k[r81] * c[sCO2]
		+ k[r130] * c[sCH2CO] ) );

	f[sC2H5-speciesIn] = c[sC2H5] - (
		 k[r36] * c[sCH3] * c[sCH3]
		+ k[r119f] * c[sH] * c[sC2H4]
		+ k[r121f] * c[sC2H6] * c[sOH]
		+ k[r122] * c[sC2H6] * c[sO]
		+ k[r123] * c[sC2H6] * c[sH]
		+ k[r124] * c[sC2H6]
		+ k[r125] * c[sC2H6] * c[sCH3]
		+ k[r190] * c[sC3H6] * c[sO]
		+ k[r194] * c[sCH3CHCO] * c[sOH]
		+ k[r195] * c[sCH3CHCO] * c[sH]
		+ k[r208f] * c[sC2H5CO] ) / ( CatchZero( 
		 k[r119b]
		+ k[r120] * c[sO2]
		+ k[r121b] * c[sH2O]
		+ k[r208b] * c[sCO] ) );

	f[sIXC3H5CO-speciesIn] = c[sIXC3H5CO] - (
		 k[r249] * c[sIXC3H5CHO] * c[sH]
		+ k[r250] * c[sIXC3H5CHO] * c[sCH3]
		+ k[r251] * c[sIXC3H5CHO] * c[sO]
		+ k[r252] * c[sIXC3H5CHO] * c[sHO2]
		+ k[r253] * c[sIXC3H5CHO] * c[sOH] ) / ( CatchZero( 
		 k[r248] ) );

	f[sCXC8H17-speciesIn] = c[sCXC8H17] - (
		 k[rLPC350b] * c[sJXC8H16] * c[sH]
		+ k[rLPB353] * c[sIXC8H18] * c[sCH3O]
		+ k[rLPB354] * c[sIXC8H18] * c[sOH]
		+ k[rLPB355] * c[sIXC8H18] * c[sCH3O2]
		+ k[rLPB356] * c[sIXC8H18] * c[sHO2]
		+ k[rLPB357] * c[sIXC8H18] * c[sCH3]
		+ k[rLPB359] * c[sIXC8H18] * c[sH]
		+ k[rLPB361f] * c[sIXC8H18] * c[sO2]
		+ k[rLPB363] * c[sIXC8H18] * c[sO]
		+ k[rLPB375] * c[sIXC8H18] * c[sBXC8H17O2]
		+ k[rLPJ377f] * c[sBXC8H17O2] ) / ( CatchZero( 
		 k[rLPC347]
		+ k[rLPK348] * c[sHO2]
		+ k[rLPK349] * c[sCH3O2]
		+ k[rLPC350f]
		+ k[rLPC351]
		+ k[rLPC352]
		+ k[rLPB361b] * c[sHO2]
		+ k[rLPK376] * c[sBXC8H17O2]
		+ k[rLPJ377b] * c[sO2] ) );

	f[sC2H3-speciesIn] = c[sC2H3] - (
		 k[r109b] * c[sC2H2] * c[sHO2]
		+ k[r114f] * c[sC2H4] * c[sOH]
		+ k[r116f] * c[sC2H4] * c[sCH3]
		+ k[r118f] * c[sC2H4] * c[sH]
		+ k[r187f] * c[sC3H6]
		+ k[r197] * c[sC3H5O] ) / ( CatchZero( 
		 k[r109f] * c[sO2]
		+ k[r110] * c[sO2]
		+ k[r111] * c[sO2]
		+ k[r112]
		+ k[r114b] * c[sH2O]
		+ k[r116b] * c[sCH4]
		+ k[r118b] * c[sH2]
		+ k[r187b] * c[sCH3] ) );

	f[sIXO2C4H8OH-speciesIn] = c[sIXO2C4H8OH] - (
		 k[r306b] * c[sIXC4H8OH] * c[sO2] ) / ( CatchZero( 
		 k[r305]
		+ k[r306f] ) );

	f[sIXC3H7-speciesIn] = c[sIXC3H7] - (
		 k[rLP191b] * c[sCH3] * c[sC2H4]
		+ k[rLP193b] * c[sH] * c[sC3H6]
		+ k[rLP215f] * c[sIXC3H7O2]
		+ k[rLP237] * c[sIXC4H8] * c[sO]
		+ k[rLP254] * c[sIXC3H6CO] * c[sH]
		+ k[rLP256] * c[sIXC3H6CO] * c[sOH]
		+ k[rLP278] * c[sIXC3H7CHO]
		+ k[rLP282] * c[sTXC4H9O]
		+ k[rLP330f] * c[sYXC7H14]
		+ k[rLP335] * c[sYXC7H15]
		+ k[rLP336] * c[sXC7H13OXZXC7H13O]
		+ k[rLP337f] * c[sIC3H7COC3H6XTXC7H13O]
		+ k[rLPA360] * c[sIXC8H18] ) / ( CatchZero( 
		 k[rLP191f]
		+ k[rLP192] * c[sO2]
		+ k[rLP193f]
		+ k[rLP215b] * c[sO2]
		+ k[rLP330b] * c[sIXC4H7]
		+ k[rLP337b] * c[sIXC3H6CO] ) );

	f[sHCO-speciesIn] = c[sHCO] - (
		 k[r52b] * c[sCO] * c[sH2]
		+ k[r54b] * c[sH] * c[sCO] * M[mM0]
		+ k[r56b] * c[sCO] * c[sHO2]
		+ k[r58f] * c[sCH2O] * c[sH]
		+ k[r60] * c[sCH2O] * c[sCH3]
		+ k[r61] * c[sCH2O] * c[sO]
		+ k[r62] * c[sCH2O] * M[mM0]
		+ k[r63] * c[sCH2O] * c[sO2]
		+ k[r64] * c[sCH2O] * c[sHO2]
		+ k[r65] * c[sCH2O] * c[sOH]
		+ k[r67] * c[sCH2O] * c[sCH3O]
		+ k[r72] * c[sCH2OH] * c[sCH2O]
		+ k[r89f] * c[sHOCHO]
		+ k[r97] * c[sCH3O2] * c[sCH2O]
		+ k[r101] * c[sC2H] * c[sO2]
		+ k[r110] * c[sC2H3] * c[sO2]
		+ k[r115] * c[sC2H4] * c[sO]
		+ k[r127] * c[sHCCO] * c[sO2]
		+ k[r129] * 2.0 * c[sHCCO] * c[sOH]
		+ k[r144f] * c[sCH3CHO]
		+ k[r149] * c[sC3H2] * c[sOH]
		+ k[r154] * c[sC3H3] * c[sO2]
		+ k[r167f] * c[sC3H5XAXC3H5] * c[sCH2O]
		+ k[r190] * c[sC3H6] * c[sO]
		+ k[r218] * c[sCH2O] * c[sCH3COCH2O2]
		+ k[rLP237] * c[sIXC4H8] * c[sO]
		+ k[r261] * c[sIXC4H6OH] * c[sCH2O]
		+ k[rLP278] * c[sIXC3H7CHO]
		+ k[r284] * c[sTXC3H6OCHO]
		+ k[rLP290] * c[sTXC4H9O2] * c[sCH2O]
		+ k[rLP303] * c[sIC4KETITXC4H8O3]
		+ k[rLPY366] * c[sIC8ETERACXC8H16O] * c[sOH] ) / ( CatchZero( 
		 k[r51] * c[sOH]
		+ k[r52f] * c[sH]
		+ k[r53] * c[sO]
		+ k[r54f] * M[mM0]
		+ k[r55] * c[sO]
		+ k[r56f] * c[sO2]
		+ k[r57] * c[sCH3]
		+ k[r58b] * c[sH2]
		+ k[r89b] * c[sOH]
		+ k[r144b] * c[sCH3]
		+ k[r167b] * c[sC3H6] ) );

	f[sTXC3H6CHO-speciesIn] = c[sTXC3H6CHO] - (
		 k[r267b] * c[sIXC3H5CHO] * c[sH]
		+ k[r268b] * c[sIXC3H6CO] * c[sH]
		+ k[r279] * c[sIXC3H7CHO] * c[sOH]
		+ k[r300f] * c[sTXC3H6O2CHO]
		+ k[r316f] * c[sNEOC5KETOXXC5H9O2]
		+ k[rLPY365] * c[sIC8ETERACXC8H16O] * c[sOH]
		+ k[rLPX390] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[r266] * c[sHO2]
		+ k[r267f]
		+ k[r268f]
		+ k[r269] * c[sHO2]
		+ k[r300b] * c[sO2]
		+ k[r316b] * c[sCH2O] ) );

	f[sIXC4H6OH-speciesIn] = c[sIXC4H6OH] - (
		 k[r260f] * c[sIXC4H7O]
		+ k[r273] * c[sIXC4H7OH] * c[sOH]
		+ k[r275] * c[sIXC4H7OH] * c[sHO2] ) / ( CatchZero( 
		 k[r260b]
		+ k[r261] * c[sCH2O]
		+ k[r262] * c[sHO2]
		+ k[rLP263]
		+ k[r264] * c[sH]
		+ k[r265] * c[sHO2] ) );

	f[sTXC4H9-speciesIn] = c[sTXC4H9] - (
		 k[rLP244b] * c[sIXC4H8] * c[sH]
		+ k[rLP246b] * c[sC3H6] * c[sCH3]
		+ k[rLP289f] * c[sTXC4H9O2]
		+ k[rLP312f] * c[sTXC4H9CO]
		+ k[rLP315] * c[sNEOXC5H11O]
		+ k[rLP332f] * c[sYXC7H14]
		+ k[rLP334] * c[sYXC7H15]
		+ k[rLP338f] * c[sTC4H9COC2H4SXC7H13O]
		+ k[rLPC351] * c[sCXC8H17]
		+ k[rLPA362] * 2.0 * c[sIXC8H18]
		+ k[rLPR369] * c[sDXC8H17O]
		+ k[rLPD380] * c[sBC8H16OOHXCXC8H17O2] ) / ( CatchZero( 
		 k[rLP244f]
		+ k[rLP245] * c[sHO2]
		+ k[rLP246f]
		+ k[rLP247] * c[sCH3O2]
		+ k[rLP288] * c[sTXC4H9O2]
		+ k[rLP289b] * c[sO2]
		+ k[rLP312b] * c[sCO]
		+ k[rLP332b] * c[sC3H5XAXC3H5]
		+ k[rLP338b] * c[sCH3CHCO] ) );

	f[sHCCO-speciesIn] = c[sHCCO] - (
		 k[r103] * c[sC2H2] * c[sO]
		+ k[r108] * c[sC2H2] * c[sO2]
		+ k[r131f] * c[sCH2CO] * c[sOH]
		+ k[r133f] * c[sCH2CO] * c[sH]
		+ k[r137] * c[sCH2CO] * c[sO]
		+ k[r150] * c[sC3H2] * c[sO2] ) / ( CatchZero( 
		 k[r126] * c[sH]
		+ k[r127] * c[sO2]
		+ k[r128] * c[sO]
		+ k[r129] * c[sOH]
		+ k[r131b] * c[sH2O]
		+ k[r133b] * c[sH2] ) );

	f[sCH2-speciesIn] = c[sCH2] - (
		 k[r20f] * c[sCH2GSGXCH2] * M[mM0]
		+ k[r29f] * c[sCH3] * c[sOH]
		+ k[r31f] * c[sCH3] * c[sH]
		+ k[r106] * c[sC2H2] * c[sO]
		+ k[r134f] * c[sCH2CO]
		+ k[r136] * c[sCH2CO] * c[sO] ) / ( CatchZero( 
		 k[r20b] * M[mM0]
		+ k[r24] * c[sO]
		+ k[r25] * c[sO2]
		+ k[r26] * c[sO2]
		+ k[r27] * c[sO2]
		+ k[r28] * c[sO2]
		+ k[r29b] * c[sH2O]
		+ k[r31b] * c[sH2]
		+ k[r134b] * c[sCO] ) );

	f[sC2H5CO-speciesIn] = c[sC2H5CO] - (
		 k[r208b] * c[sC2H5] * c[sCO]
		+ k[rLP304] * c[sIC4KETITXC4H8O3] ) / ( CatchZero( 
		 k[r208f] ) );

	f[sCH3COCH2O2-speciesIn] = c[sCH3COCH2O2] - (
		 k[r219b] * c[sCH3COCH2] * c[sO2] ) / ( CatchZero( 
		 k[r218] * c[sCH2O]
		+ k[r219f]
		+ k[r220] * c[sCH3COCH3]
		+ k[r221] * c[sHO2] ) );

	f[sIC4H8OOHXTO2XC4H9O4-speciesIn] = c[sIC4H8OOHXTO2XC4H9O4] - (
		 k[rLP307b] * c[sTC4H8O2HXIXC4H9O2] * c[sO2] ) / ( CatchZero( 
		 k[rLP307f]
		+ k[rLP308] ) );

	f[sXXC7H13-speciesIn] = c[sXXC7H13] - (
		 k[rLP329f] * c[sYXC7H14] * c[sOH]
		+ k[rLP331f] * c[sYXC7H14] * c[sH]
		+ k[rLPY367] * c[sIC8ETERACXC8H16O] * c[sOH] ) / ( CatchZero( 
		 k[rLP328] * c[sHO2]
		+ k[rLP329b] * c[sH2O]
		+ k[rLP331b] * c[sH2] ) );

	f[sTC4H9COC2H4SXC7H13O-speciesIn] = c[sTC4H9COC2H4SXC7H13O] - (
		 k[rLP338b] * c[sCH3CHCO] * c[sTXC4H9]
		+ k[rLPX388] * c[sIC8KETBCXC8H16O3] ) / ( CatchZero( 
		 k[rLP338f] ) );

	f[sNEOC5H10OOHXO2XC5H11O4-speciesIn] = c[sNEOC5H10OOHXO2XC5H11O4] - (
		 k[r325b] * c[sNEOXC5H10OOH] * c[sO2] ) / ( CatchZero( 
		 k[r325f]
		+ k[r326] ) );

	f[sYC7H13OOHXX1XC7H14O2-speciesIn] = c[sYC7H13OOHXX1XC7H14O2] - (
		 k[rLPD384] * c[sBC8H16OOHXCXC8H17O2] ) / ( CatchZero( 
		 k[rLP340] ) );

	f[sIC4KETITXC4H8O3-speciesIn] = c[sIC4KETITXC4H8O3] - (
		 k[rLP308] * c[sIC4H8OOHXTO2XC4H9O4] ) / ( CatchZero( 
		 k[rLP303]
		+ k[rLP304] ) );

	f[sIXC3H7O2-speciesIn] = c[sIXC3H7O2] - (
		 k[rLP215b] * c[sIXC3H7] * c[sO2] ) / ( CatchZero( 
		 k[rLP215f]
		+ k[r216] ) );

	return 0;
}

#ifndef MECHANISM
#define MECHANISM ""
#endif

void TReaction::CheckSteadyStatesMech( const char *mechName )
{
	char	*name = new char[strlen( MECHANISM ) + 5];
	sprintf( name, "%s.pre", MECHANISM );
	if ( strstr( mechName, name ) == 0 ) {
		cerr << "#error: program linked with mechanism " << MECHANISM << ".mech"
					<< ", input mechanism is " << mechName << NEWL;
		exit(2);
	}
	else {
		cerr << "use reduced kinetics " << MECHANISM << NEWL;
	}
}
