function rval = rtest_3_cojocaru()
% The regression test for the bug reported by Radu Cojocaru on 9 November
% 2006.  The error is getting erroneous edges in the minimum spanning tree.
%  The cause of the error is that mst outputs exactly n-1 edges for the
%  minimum spanning tree.  However, if the graph is disconnected, then the
%  MST will only have n-(number of components) edges.  The implementation
%  of mst.m at the at time would include the extra edges in the tree.

A = [
0.0 0.043440 0.028011 0.026889 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.043440 0.0 0.078864 0.070572 0.057703 0.044092 0.030731 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.028011 0.078864 0.0 0.671141 0.215054 0.100000 0.050352 0.036062 0.030788 0.029533 0.027762 0.026860 0.026645 0.025714 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.026889 0.070572 0.671141 0.0 0.316456 0.117509 0.054437 0.038110 0.032268 0.030893 0.028960 0.027980 0.027747 0.026738 0.025740 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.057703 0.215054 0.316456 0.0 0.186916 0.065746 0.043328 0.035932 0.034235 0.031878 0.030694 0.030414 0.029206 0.028019 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.044092 0.100000 0.117509 0.186916 0.0 0.101420 0.056402 0.044484 0.041911 0.038432 0.036724 0.036324 0.034614 0.032960 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.030731 0.050352 0.054437 0.065746 0.101420 0.0 0.127065 0.079239 0.071429 0.061881 0.057571 0.056593 0.052549 0.048828 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.036062 0.038110 0.043328 0.056402 0.127065 0.0 0.210526 0.163132 0.120627 0.105263 0.102041 0.089606 0.079302 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.030788 0.032268 0.035932 0.044484 0.079239 0.210526 0.0 0.724638 0.282486 0.210526 0.198020 0.156006 0.127226 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.029533 0.030893 0.034235 0.041911 0.071429 0.163132 0.724638 0.0 0.462963 0.296736 0.272480 0.198807 0.154321 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.027762 0.028960 0.031878 0.038432 0.061881 0.120627 0.282486 0.462963 0.0 0.826446 0.662252 0.348432 0.231481 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.026860 0.027980 0.030694 0.036724 0.057571 0.105263 0.210526 0.296736 0.826446 0.0 3.333333 0.602410 0.321543 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.026645 0.027747 0.030414 0.036324 0.056593 0.102041 0.198020 0.272480 0.662252 3.333333 0.0 0.735294 0.355872 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.025714 0.026738 0.029206 0.034614 0.052549 0.089606 0.156006 0.198807 0.348432 0.602410 0.735294 0.0 0.689655 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.000000 0.025740 0.028019 0.032960 0.048828 0.079302 0.127226 0.154321 0.231481 0.321543 0.355872 0.689655 0.0 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.0 0.450450 0.335570 0.255754 0.096154 0.073855
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.450450 0.0 1.315789 0.591716 0.122249 0.088339
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.335570 1.315789 0.0 1.075269 0.134771 0.094697
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.255754 0.591716 1.075269 0.0 0.154083 0.103842
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.096154 0.122249 0.134771 0.154083 0.0 0.318471
0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.073855 0.088339 0.094697 0.103842 0.318471 0.0
];

A = sparse(A);

T = mst(A);

rval = 1;

G = A - T;
[i j v] = find(G);

if any(v < 0)
    rval = 0;
end
