% function R = GetSignificantRelationality(A,m,sigma,alpha)
% 
% remove non significant ties in a relationality matrix
% 
% A: relationality matrix
% m: mean for significance determination
% sigma: std for significance determination
% alpha: significance level
% 
% R: relationality matrix

function R = GetSignificantRelationality(A,m,sigma,alpha)

if nargin < 4
    alpha = 0.05;
end

zval = abs(norminv((alpha/2),0,1)); 

R = A;
R(R<(m + zval*sigma) & R>(m - zval*sigma)) = 0;
R = R.*(1-eye(size(R,1)));



        