% function results = RCA_bootstrap(R,N)
% 
% boostraps the relationality matrix and reports the mean and
% standard deviation of each bootstrapped sample
% 
% R: relationality matrix
% N: number of bootstrap samples
% 
% results: Nx2 sample results, mean and std

function results = RCA_bootstrap(R,N)

if nargin < 2
    N = 1000;
end

n = size(R,1);

results = zeros(N,2);

for i=1:N
    r = ceil(rand(1,n)*n);
    r(r==0) = 1;
    m = R(r,r);
    sample = m(logical(tril(ones(size(m,1)),-1)));    
    
    results(i,1) = mean(sample);
    results(i,2) = std(sample);
    if mod(i,100)==0
        i
    end
end
