%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Reduce_Matrix
%  Given an index vector extracts a matrix for these nodes
%  only. 
%
%  Input variables:
%  A: the adjacency matrix
%  v: index vector (logical or numerical)
%    
%  Output variables:
%  G: the extracted matrix
%  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function G = Reduce_Matrix(A,v,dim)

if nargin<3
    dim = 1;
end

if length(v)~=size(A,dim)
    disp('Reduce Matrix: index vector must be of same length as matrix')
    G = A;
    return;
end

if length(v)==size(A,dim)
    index = find(v);
else
    index = v;
end

if nargin<3
    dim = 0;
end

if dim ==0 
    G = A(index,index);
elseif dim == 1
    G = A(index,:);
else
    G = A(:,index);
end

