% function R = Relationality(data, maxs, vector)
% 
% compute the relationality for each pair of observations in the dataset
% 
% data: NxM dataset
% maxs: 1xM vector of maximal values for each variable
% vector: binary if the result should be reported as a vector

function R = Relationality(data, maxs,vector)

if nargin<3
    vector = 0;
end

if nargin<2
    maxs = max(data);
end

[n,m] = size(data);

if length(maxs)==1
    maxs = maxs*ones(1,m);
end

mins = min(data);

for i=1:m
    data(:,i) = (data(:,i)-mins(i))/(maxs(i)-mins(i));
end

M = zeros(m,m,n);

for i=1:n
    M(:,:,i) = Differences(data(i,:));
end        

if ~vector
    R = zeros(n);
else
    R = zeros((n*(n-1))/2,1);
    vi = 0;
end

for i=1:(n-1)
    for j=(i+1):n
        T = abs(abs(M(:,:,i))-abs(M(:,:,j)));
        T = (1-T).*((((M(:,:,i).*M(:,:,j))>=0)-0.5)*2);
        m_hat = sum(~isnan(data(i,:))&~isnan(data(j,:)));
        r = (sum(sum(T(~isnan(T))))-m_hat)/(m_hat*(m_hat-1));

        if ~vector
            R(i,j) = r;
            R(j,i) = R(i,j);
        else
            vi = vi+1;
            R(vi) = r;
        end
    end
end

    