import numpy as np
import matplotlib.pyplot as plt
import time
import NMF as nmf

n = 100      # number of data points
d = 2        # number of dimensions
r = 3        # ranks of the model
n_f = 15     # number of data points generated on the faces.
deg_prob = np.array((0.3, 0.7)) # distribution of the support size of weights corresponding to data points on the faces.

alpha = 1         # Dirichlet parameter
sigma = 0.001     # Noise power.
W0 = generate_weights(n,6,alpha,n_f,deg_prob)

H0 = np.array([[-5-float(4)/9,-5],[0,5+float(9)/4],[5+float(4)/9,-5]])
print H0
plot_H(H0, 'y', 'o')
HH0 = np.array([[-1,5],[-5,-4],[-4,-5],[4,-5],[5,-4],[1,5]])
X0 = np.dot(W0,HH0)
X = X0 + sigma*np.random.normal(0,1,(n,d))

W, H, L, Err = acc_palm_nmf(X, r=3, proj_method='wolfe', m=5, maxiter=5000, c1 =1, c2 = 1, verbose = True, plotit = True, proj_low_dim = False, oracle = True, H0=H0, weights_exact = False, method = 'fista', fixed_max_size=5)