C     
C  JOHN B. TAYLOR MULTICOUNTRY MODEL SIMULATION
C
C  FILE LAST CHANGED ON 5-13-93 BY JCW
C                                                                      
C THIS PROGRAM AND ITS ASSOCIATED SUBROUTINES COMPUTES
C SOLUTIONS TO THE TAYLOR MULTICOUNTRY MODEL USING THE
C FAIR-TAYLOR EXTENDED PATH ALGORITHM.                      
C
C THE USER IS FREE TO CHOOSE THE FOLLOWING:
C     TYPE OF SIMULATION: DETERMINISTIC OR STOCHASTIC
C     ACCURACY OF SOLUTION
C     PERIOD OF SIMULATION: STARING AND ENDING QUARTERS
C     EXHANGE RATE REGIME: FLOAT, FIXED,OR MIXED (EMS)
C     MONETARY POLICY REGIME: FIXED MONEY SUPPLY RULE OR
C                             INTEREST RATE REACTION FUNCTION
C     TYPE OF SHOCKS:
C       FOR DETERMINISTIC SIMULATIONS:
C          TEMPORARY OR PERMANENT CHANGES IN MONEY SUPPLY
C          AND/OR GOVERNMENT SPENDING IN ONE OR MORE COUNTRIES
C       FOR STOCHASTIC SIMULATIONS:
C          INNOVATIONS EQUAL TO THE HISTORICAL VALUES OR
C          GENERATED BY A RANDOM NUMBER GENERATOR 
C     
C FOR FURTHER INFORMATION, SEE THE FILE readme.mcm
C     
      PROGRAM EXTPATH
      IMPLICIT DOUBLE PRECISION(A-G,O-Z)
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3,NS=100)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      DOUBLE PRECISION COEF(NCOEFL,NCOEFS)
      DOUBLE PRECISION PSI(0:6,0:MAXLAG),PHI(0:6,0:MAXLAG),
     X PSI5(NT,0:MAXLAG),PHI5(NT,0:MAXLAG),DELTA(0:6,NT),GAMMA(0:6)
      DOUBLE PRECISION VCOV(NE,NE),RES(NE,NT),SH(NE,NT)
      DOUBLE PRECISION YQ(NT),PARG(0:6,2)
      INTEGER ISEED(NS)
C
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /VARS/ COEF
      COMMON /WAGE/ PSI,PHI,PSI5,PHI5,DELTA,GAMMA
      COMMON /Z/ ZE,ZO
      COMMON /SCALE/ SCALE1,SCALE2
      COMMON /PAR/ PARG
      COMMON /SHOCKS/ VCOV,SH
      COMMON /PRINT/ ISEED,NRUN
C                                                                     
C  PRINT PROLOGUE TO SCREEN              
C
      WRITE(*,*) ' '                                                           
      WRITE(*,*) 'MULTI-COUNTRY MODEL SIMULATION'
      WRITE(*,*) ' '
C     
C  IF YOU ALWAYS WANT TO READ JOB SPECIFICATIONS FROM FILE UNIT 1,
C  SET IFILE = 1
C
      IFILE=1
      CALL FILES
      NRUN=1
      CALL JOBSPECS(IFILE)
      CALL REWR(RES)
C
      DO 100 NRUN = 2,NSIMLS
	 CALL INIT(1,NT)
	 WRITE(*,*) ' '
	 WRITE(*,*) 'SIMULATION ',NRUN,' OF ',NSIMLS,'.'
	 WRITE(*,*) 'ISEED = ', ISEED(NRUN)
         INITSEED=ISEED(NRUN)
	 CALL STOCH(INITSEED)
	 IF (IRES .EQ. 1) CALL RESID(1,1,1,1,1,NT,RES)
	 CALL SOLVE(RES)
	 CALL PRINTF
  100 CONTINUE
C
      WRITE(*,*) ' '
      WRITE(*,*) 'END OF MULTI-COUNTRY MODEL SIMULATION.'
      WRITE(*,*) ' '
C
      STOP
      END
C
C  *********************************************************************
C  SUBROUTINE INIT                                                      
C  *********************************************************************
C                                                                       
C  THIS SUBROUTINE INITIALIZES THE VECTORS N=2 THROUGH N=4 FOR USE      
C  IN THE SUBROUTINE SOLVE.  THE VECTORS ARE SET EQUAL TO VECTOR N=1,   
C  WHICH CONTAINS THE BASELINE VALUES READ IN BY SUBROUTINE REWR.       
C  THE VECTORS N=2 AND N=3 CONTAIN THE VALUES OF VARIABLES FOR THE      
C  PREVIOUS AND CURRENT TYPE I ITERATION, RESPECTIVELY.                 
C  VECTOR N=4 CONTAINS THE VALUES OF EXPECTATIONS VARIABLES IN THE      
C  CURRENT TYPE II ITERATION. THUS N=2 IS THE INITIAL VECTOR FOR        
C  THE GAUSS-SEIDEL ROUTINE AND N=4 IS THE INITIAL VECTOR FOR THE       
C  TYPE II ITERATION CHECK.                                             
C                                                                       
      SUBROUTINE INIT(NST,NFI)
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)
      PARAMETER(NT=240,N=5,NE=112,NO=79)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      COMMON /Z/ ZE,ZO
C
      WRITE(*,*) 'INITIALIZING VECTORS.'
C
C  INITIALIZE ZE VALUES
C
      DO 10 J=NST,NFI                                                   
	DO 10 K=1,NE*N,N                                                
	  DO 10 KK=1,N-1                                                
	    ZE(J,K+KK)=ZE(J,K)                                          
  10  CONTINUE                                                          
C
C  INITIALIZE ZO VALUES
C
      DO 20 J=NST,NFI                                                   
	DO 20 K=1,NO*N,N                                                
	  DO 20 KK=1,N-1                                                
	    ZO(J,K+KK)=ZO(J,K)                                          
  20  CONTINUE 
C                                                         
      RETURN                                                            
      END
C
C  ******************************************************************
C  SUBROUTINE JOBSPECS                      
C  ******************************************************************
C
C  THIS SUBROUTINE READS IN SIMULATION SPECIFICATIONS EITHER FROM A
C  DATA FILE (UNIT 11) IF IFILE = 1, OR FROM PROMPTED SCREEN INPUT
C  IF IFILE = 0.
C
      SUBROUTINE JOBSPECS (IFILE)
      IMPLICIT DOUBLE PRECISION(A-G,O-Z)
      PARAMETER(NT=240,NS=100)
      DOUBLE PRECISION YQ(NT),PARG(0:6,2)
      INTEGER ISEED(NS)
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /SCALE/ SCALE1,SCALE2
      COMMON /PAR/ PARG
      COMMON /PRINT/ ISEED,NRUN
C
      IF (IFILE .NE. 1) THEN
       WRITE(*,*)'HAVE YOU WRITTEN THE JOB SPECIFICATIONS TO A FILE?'
       READ(*,*) IFILE
      END IF
C
      IF (IFILE .EQ. 1) THEN
	 WRITE(*,*) 'READING JOB SPECIFICATIONS.'
	 READ(11,*) ISTOCH,NSIMLS,ISUB
	 READ(11,*) (ISEED(I), I=1,NSIMLS)
	 READ(11,*) IDTYPE
	 READ(11,*) IPRULE
	 READ(11,*) (PARG(I,1), I=0,6)
	 READ(11,*) (PARG(I,2), I=0,6)
	 READ(11,*) IFLEXE
	 READ(11,*) IRES
	 READ(11,*) NBEG,NEND
	 READ(11,*) NBEP,NEEP
	 READ(11,*) CR1,CR2,CR3
	 READ(11,*) SCALE1,SCALE2
	 READ(11,*) MAXIT1,MAXIT2
	 READ(11,*) NFUT1
      ELSE
	 WRITE(*,*) 'IS THE SIMULATION STOCHASTIC?'
	 READ(*,*) ISTOCH
	 IF (ISTOCH .EQ. 1) THEN
	    WRITE(*,*)
     X        'DO YOU WISH TO USE STRUCTURAL RESIDUALS FOR SHOCKS?'
	    READ(*,*) ISUB
	    IF (ISUB .NE. 1) THEN
	     WRITE(*,*) 'HOW MANY TIMES SHOULD THE SIMULATION BE RUN?'
	     READ(*,*) NSIMLS
	     WRITE(*,*) 'ENTER THE SEED VALUES FOR RANDOM NUMBERS.'
	     WRITE(*,*) '(#SIMULATIONS INTEGERS)'
	     READ(*,*) (ISEED(I),I=1,NSIMLS)
	     WRITE(*,*) 'WHICH MONETARY POLICY RULE IS TO BE USED?'
	     READ(*,*) IPRULE
	     WRITE(*,*) 'WHAT ARE THE VALUES FOR G1? (SEVEN REALS)'
	     READ(*,*) (PARG(I,1), I = 0,6)
	     WRITE(*,*) 'WHAT ARE THE VALUES FR G2? (SEVEN REALS)'
	     READ(*,*) (PARG(I,2), I = 0,6)
	    END IF
C           
	 ELSE
	    NSIMLS=1
	    WRITE(*,*) 'WHICH POLICY CHANGE IS TO BE USED?'
	    READ(*,*) IDTYPE
	 END IF
	 WRITE(*,*) 'ARE EXCHANGE RATES FLEXIBLE?'
	 READ(*,*) IFLEXE
	 WRITE(*,*) 'ARE RESIDUALS TO BE ADDED TO THE EQUATIONS?'
	 READ(*,*) IRES
	   WRITE(*,*)
     X    'WHAT ARE THE FIRST AND LAST PERIODS FOR THE SIMULATION?'
	   READ(*,*) NBEG, NEND
	 WRITE(*,*) 'WHAT ARE THE FIRST AND LAST PERIODS FOR OUTPUT?'
	 READ(*,*) NBEP, NEEP
	 WRITE(*,*)
     X    'ARE THE DEFAULT ITERATION SPECIFICATIONS TO BE USED?'
	 READ(*,*) IDEFAULT
	 IF (IDEFAULT .EQ. 1) THEN
	    CR1 = 1.0D-5
	    CR2 = 2.0D-5
	    CR3 = 2.0D-4
	    MAXIT1 = 500
	    MAXIT2 = 500
	    IF (ISTOCH .EQ. 1) THEN
	       NFUT1 = 20
	    ELSE
	       NFUT1 = 80
	    END IF
	 ELSE
	    WRITE(*,*) 
     X 'WHAT ARE THE CONVERGENCE CRITERIA FOR TYPE I, II, AND III ITERAT
     XIONS'
	    WRITE(*,*) '(THREE REAL NUMBER ARE REQUIRED)?'
	    READ(*,*) CR12, CR2, CR3
	    WRITE(*,*) 
     X  'WHAT ARE THE MAXIMUM NUMBER OF TYPE I AND II ITERATIONS?'
	    READ (*,*) MAXIT1, MAXIT2
	    WRITE(*,*)'HOW FAR INTO THE FUTURE SHOULD THER PATH EXTEND?'
	    READ(*,*) NFUT1
	 END IF
      END IF
C    
C  SET NFUT2 = NFUT1 + 1 FOR TYPE III ITERATION CHECK
C
      NFUT2 = NFUT1 + 1
C
C  SET NTP = NUMBER OF TIME PERIODS OF SIMULATION
C
      NTP=NEND-NBEG+1         
C
C  CONVERT INTEGER PERIODS INTO QUARTERS STARTING FROM 1971
C
      DO 10 I = 1,NT                                                    
	YQ(I)=71.D0+FLOAT(INT((I-1)/4))+(1.D0+FLOAT(MOD(I-1,4)))/10.D0  
   10 CONTINUE                                                          
C
C  FOR DETERMINISTIC SIMULATIONS SET SEED VALUES TO 0
C
      IF (ISTOCH .NE. 1) THEN
	 DO 20 I=1,NSIMLS
	    ISEED(I) = 0
 20      CONTINUE
      END IF
C
      WRITE(*,*) 'THE FOLLOWING SPECIFICATIONS HAVE BEEN REQUESTED:'
      WRITE(*,*) '  '
      IF (ISTOCH .EQ. 1) THEN
	 WRITE(*,*) ' THE SIMULATION IS STOCHASTIC.'
	 IF (NSIMLS.EQ.1) THEN
	   WRITE(*,*) '1 SIMULATION WILL BE CONDUCTED.'
	 ELSE
	    WRITE(*,900) NSIMLS
 900        FORMAT(I3, ' SIMULATIONS WILL BE CONDUCTED.')
	 END IF
      ELSE
	 WRITE(*,*) 'THE SIMULATION IS DETERMINISTIC.'
	 WRITE(*,910) IDTYPE
 910     FORMAT(' THE POLICY IS TYPE ', I2)
      END IF
      IF (ISTOCH .EQ. 1) THEN
	 WRITE(*,920) IPRULE
 920     FORMAT(' THE MONETARY POLICY RULE IS TYPE' , I2)
	 WRITE(*,*) 'MONETARY POLICY COEFFICIENTS:'
	 WRITE(*,*) '(TWO SETS OF SIX REALS)'
	 WRITE(*,925) (PARG(I,1), I = 0,6)
	 WRITE(*,925) (PARG(I,2), I = 0,6)
  925    FORMAT(7(1X,F8.5))
      END IF
      IF (IFLEXE .EQ. 1) THEN
	 WRITE(*,*) 'EXCHANGE RATES ARE FLEXIBLE.'
      ELSE
	 WRITE(*,*) 'EXCHANGE RATES ARE FIXED.'
      END IF
      IF (IRES .EQ. 1) WRITE(*,*)
     X  'RESIDUALS ARE BEING ADDED TO THE EQUATIONS.'
      WRITE(*,930) YQ(NBEG),YQ(NEND)                             
 930  FORMAT(' PERIOD OF SIMULATION: ',F5.1,' TO ',F5.1)
      WRITE(*,940) YQ(NBEP),YQ(NEEP)
 940  FORMAT(' PERIOD FOR WHICH THE RESULTS ARE PRINTED: ',
     X        F5.1,' TO ',F5.1)                
      WRITE(*,950) CR1,CR2,CR3   
 950  FORMAT(' TYPE I,II, AND III CONVERGENCE CRITERIA:',3(1X,F9.7))
      WRITE(*,960) MAXIT1,MAXIT2 
 960  FORMAT(' MAXIMUM NUMBER OF TYPE I AND II ITERATIONS: ',I4,1X,I4)
      WRITE(*,970) NFUT1,NFUT2    
 970  FORMAT(' TYPE III ITERATION TRUNCATION VALUES = ',I3,' TO ',I3)
C     
      RETURN
      END
C
C *********************************************************************
C PRINTF
C *********************************************************************
C
      SUBROUTINE PRINTF
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3,H=8,NVARS=147,NS=100)
      PARAMETER (NPOPTS=3,ISW=6,MAXP=400)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      DOUBLE PRECISION YQ(NT) 
      DOUBLE PRECISION ZPRINT(NT,MAXP)
      CHARACTER*7 VNAME(NVARS)
      CHARACTER*13 PNAME(MAXP)
      CHARACTER*1 FN1,FN2,FN3,FN4,FN5
C      CHARACTER*12 SIMOUT
      CHARACTER*11 VUOUT
      INTEGER ISEED(NS)
      INTEGER IPRINT(NVARS,3)
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /Z/ ZE,ZO
      COMMON /PRINT/ ISEED,NRUN
C
C NAME OUTPUT FILES
C 
      FN1=CHAR(48+IDTYPE/10)
      FN2=CHAR(48+IDTYPE-10*(IDTYPE/10))
      FN3=CHAR(48+IFLEXE)
      FN4=CHAR(48+IPRULE/10)
      FN5=CHAR(48+IPRULE-10*(IPRULE/10))
C      SIMOUT='rem'//FN1//FN2//FN3//FN4//FN5//'.sim'
      VUOUT='rem'//FN1//FN2//FN3//FN4//FN5//'.vu'
      OPEN(UNIT=7,FILE=VUOUT)
C      OPEN(UNIT=12,FILE=SIMOUT)    
C 
C   COMMENT TO APPEAR IN OUTPUT FILES:                                    
C                                                                       
      WRITE(7,5) YQ(NBEG),YQ(NEND),CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,   
     XNFUT2,IRES,IFLEXE,IPRULE                                          
C
   5  FORMAT('"COMMENT: SOL.PER.=',2(1X,F5.1),'; CR1,2,3=',3(1X,F9.7), 
     X'; MAXIT1,2=',2(1X,I4),'; NFUT1,2=',2(1X,I4),'; IRES=',I1,       
     X'; IFLEXE=',I1,'; IPRULE=',I2)
C
	 WRITE(7,*) ' '
	 WRITE(7,*) 'SIMULATION ',NRUN,' OF ',NSIMLS,'.'
	 IF (ISTOCH.EQ.1) WRITE(7,*) 'ISEED = ', ISEED(NRUN)
C	 WRITE(12,*) ' '
C        WRITE(12,*) 'SIMULATION ',NRUN,' OF ',NSIMLS,'.'
C        IF (ISTOCH.EQ.1) WRITE(12,*) 'ISEED = ', ISEED(NRUN)
C                          
C  TAKE LEVELS OF E,EX,IM,X,W,P,PI,PE,M
C
      DO 1 I=1,35
	 DO 1 J=1,NT
	    IF (I.LE.30) ZE(J,I+35)=DEXP(ZE(J,I+35))
	    ZE(J,I+280)=DEXP(ZE(J,I+280))
	    ZE(J,I+315)=DEXP(ZE(J,I+315))
	    ZE(J,I+385)=DEXP(ZE(J,I+385))
	    ZE(J,I+420)=DEXP(ZE(J,I+420))
	    ZE(J,I+455)=DEXP(ZE(J,I+455))
	    ZE(J,I+490)=DEXP(ZE(J,I+490))
	    ZE(J,I+525)=DEXP(ZE(J,I+525))
	    ZO(J,I)=DEXP(ZO(J,I))               
 1    CONTINUE
C
C MULTIPLY INTEREST RATES BY 100
C
      DO 2 I=1,35
	 DO 2 J=1,NT
	    ZE(J,I)=100.0D0*ZE(J,I)
 2    CONTINUE
      DO 3 I=66,100
	 DO 3 J=1,NT
	    ZE(J,I)=100.0D0*ZE(J,I)
 3    CONTINUE
C
C NDURP: NUMBER OF ROWS OF PRINTED OUTPUT (PERIODS)
C NPOPTS: NUMBER OF PRINTING OPTIONS (SET EQUAL TO 3)
C NCNT(*): NUMBER OF VARIABLES PRINTED USING OPTION *
C ICNT(*): COUNTER FOR COLUMN OF OUTPUT
C
      NDURP=NEEP-NBEP+1
C
      WRITE(*,*) 'READING OUTPUT SPECIFICATIONS.'
C
C READ PRINT INFORMATION: VARAIBLE NAMES AND PRINT SPECIFICATIONS
C
C IPRINT(I,1)=1: LEVEL
C            =2: NATURAL LOGARITHM
C IPRINT(I,2)=1: DIFFERENCE FROM BASELINE
C            =2: PERCENTAGE DEVIATION FROM BASELINE
C IPRINT(I,3)=1: DIFFERENCE FROM PREVIOUS QUARTER
C            =2: PERCENTAGE INCREASE FROM PREVIOUS QUARTER 
C            =3: FOUR-QUARTER DIFFERENCE
C            =4: PERCENTAGE INCREASE OVER FOUR QUARTERS
C            =5: DIFFERENCE OF FOUR-QUARTER DIFFERENCE FROM TREND
C            =6: DIFFERENCE OF PERCENTAGE INCREASE OVER 4 QUARTERS
C                FROM TREND
C
      NCOLS=1
      ICOL=1
C
      PNAME(1)='"TIME"'
      DO 50 I=NBEP,NEEP
	 ZPRINT(I-NBEP+1,1)=YQ(I)
 50   CONTINUE
C
C READ IN NAMES FROM VARIABLES AND COUNT HOW MANY VARIABLES
C ARE TO BE PRINTED
C
      DO 100 I=1,NVARS
	 READ(16,*) VNAME(I),(IPRINT(I,J),J=1,3)
	 DO 150 J=1,NPOPTS
	    IF (IPRINT(I,J).NE.0) NCOLS=NCOLS+1
  150    CONTINUE
  100 CONTINUE
C
C LOOP THROUGH VARIABLE LIST, CALCULATING NEEDED VALUES
C
      DO 300 J=1,NE
	 IF (IPRINT(J,1).NE.0) ICOL=ICOL+1
	 IF (IPRINT(J,1).EQ.1) THEN
	    PNAME(ICOL)='"'//VNAME(J)//'"'
	    DO 210 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=ZE(I,J*5-2)
  210       CONTINUE
	 ELSE IF (IPRINT(J,1).EQ.2) THEN
	    PNAME(ICOL)='"LOG'//VNAME(J)//'"'
	    DO 220 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=DLOG(ZE(I,5*J-2))
  220       CONTINUE
	 END IF
C
      IF (IPRINT(J,2).NE.0) ICOL=ICOL+1
	 IF (IPRINT(J,2).EQ.1) THEN
	    PNAME(ICOL)='"DFT'//VNAME(J)//'"'
	    DO 240 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=ZE(I,5*J-2)-ZE(I,5*J-4)
  240       CONTINUE
	 ELSE IF (IPRINT(J,2).EQ.2) THEN
	    PNAME(ICOL)='"PDT'//VNAME(J)//'"'
	    DO 250 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=100.0D0*
     X         (ZE(I,5*J-2)-ZE(I,5*J-4))/ZE(I,5*J-4)
  250       CONTINUE
	 END IF
C
      IF (IPRINT(J,3).NE.0) ICOL=ICOL+1
	 IF (IPRINT(J,3).EQ.1) THEN
	    PNAME(ICOL)='"DF1'//VNAME(J)//'"'
	    DO 260 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=(
     X                  ZE(I,5*J-2)-ZE(I-1,5*J-2))
  260       CONTINUE
	 END IF
	 IF (IPRINT(J,3).EQ.2) THEN
	    PNAME(ICOL)='"PD1'//VNAME(J)//'"'
	    DO 270 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=100.0D0*
     X               (ZE(I,5*J-2)-ZE(I-1,5*J-2))/ZE(I-1,5*J-2)
  270       CONTINUE
	 END IF
	 IF (IPRINT(J,3).EQ.3) THEN
	    PNAME(ICOL)='"DF4'//VNAME(J)//'"'
	    DO 280 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=ZE(I,5*J-2)-ZE(I-4,5*J-2)
  280       CONTINUE
	 END IF
	 IF (IPRINT(J,3).EQ.4) THEN
	    PNAME(ICOL)='"PD4'//VNAME(J)//'"'
	    DO 290 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=100.0D0*
     X               (ZE(I,5*J-2)-ZE(I-4,5*J-2))/ZE(I-4,5*J-2)
  290       CONTINUE
	 END IF
	 IF (IPRINT(J,3).EQ.5) THEN
	    PNAME(ICOL)='"D4T'//VNAME(J)//'"'
	    DO 292 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=ZE(I,5*J-2)-ZE(I-4,5*J-2)-
     X         (ZE(I,5*J-4)-ZE(I-4,5*J-4))
  292       CONTINUE
	 END IF
	 IF (IPRINT(J,3).EQ.6) THEN
	    PNAME(ICOL)='"P4T'//VNAME(J)//'"'
	    DO 294 I=NBEP,NEEP
	       ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X               (ZE(I,5*J-2)-ZE(I-4,5*J-2))/ZE(I-4,5*J-2)-
     X               (ZE(I,5*J-4)-ZE(I-4,5*J-4))/ZE(I-4,5*J-4))
  294       CONTINUE
	 END IF
C
  300 CONTINUE
C
C CALCULATE REAL INTEREST RATES, CURRENT ACCOUNT VARIABLES,
C MONEY, AND GOVERNMENT SPENDING 
C
       DO 320 J=14,20
	 IF (IPRINT(NE+J-13,2).EQ.1) THEN
	    ICOL=ICOL+1
	    PNAME(ICOL)='"DTR'//VNAME(J)//'"'       
	    DO 310 I=NBEP,NEEP
	     ZPRINT(I-NBEP+1,ICOL)=ZE(I,5*J-2)-ZE(I,5*J-4)-
     X       100.0D0*(
     X       DLOG(ZE(I+4,5*(J+78)-1))-DLOG(ZE(I,5*(J+78)-2))
     X       -DLOG(ZE(I+4,5*(J+78)-4))+DLOG(ZE(I,5*(J+78)-4)))
 310        CONTINUE
	 END IF
	 IF (IPRINT(NE+J-13,3).EQ.1) THEN
	    ICOL=ICOL+1
	    PNAME(ICOL)='"D1R'//VNAME(J)//'"'
	     DO 311 I=NBEP,NEEP
	     ZPRINT(I-NBEP+1,ICOL)=ZE(I,5*J-2)-ZE(I-1,5*J-2)-
     X       100.0D0*(
     X       DLOG(ZE(I+4,5*(J+78)-1))-DLOG(ZE(I,5*(J+78)-2))
     X       -DLOG(ZE(I+3,5*(J+78)-1))+DLOG(ZE(I-1,5*(J+78)-2)))
 311        CONTINUE
	 END IF
 320  CONTINUE
C
      DO 330 J=71,77    
	 IF(IPRINT(NE+J-63,2).EQ.1) THEN
	    ICOL=ICOL+1
	    PNAME(ICOL)='"DTR'//VNAME(J-14)//'"'
	    DO 321 I=NBEP,NEEP
	     ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X       (ZE(I,5*(J-14)-2)-ZE(I,5*(J-7)-2))/ZE(I,J*5-2)-
     X       (ZE(I,5*(J-14)-4)-ZE(I,5*(J-7)-4))/ZE(I,J*5-4))
 321        CONTINUE
	 ENDIF
	 IF(IPRINT(NE+J-63,3).EQ.1) THEN
	    ICOL=ICOL+1
	    PNAME(ICOL)='"D1R'//VNAME(J-14)//'"'
	    DO 322 I=NBEP,NEEP
	     ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X       (ZE(I,5*(J-14)-2)-ZE(I,5*(J-7)-2))/ZE(I,J*5-2)-
     X       (ZE(I-1,5*(J-14)-2)-ZE(I-1,5*(J-7)-2))/ZE(I-1,J*5-2))
 322        CONTINUE
	 ENDIF
 330   CONTINUE
C
      DO 340 J=71,77
	 IF(IPRINT(NE+J-56,2).EQ.1) THEN
	 ICOL=ICOL+1
	 PNAME(ICOL)='"DTN'//VNAME(J-14)//'"'
	 DO 331 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZE(I,5*(J-14)-2)*ZE(I,5*(J+35)-2)-
     X      ZE(I,5*(J-7)-2)*ZE(I,5*(J+28)-2))/
     X      (ZE(I,J*5-2)*ZE(I,5*(J+21)-2))-(
     X      (ZE(I,5*(J-14)-4)*ZE(I,5*(J+35)-4)-
     X      ZE(I,5*(J-7)-4)*ZE(I,5*(J+28)-4))/
     X      (ZE(I,J*5-4)*ZE(I,5*(J+21)-4)) ))
  331    CONTINUE
	 ENDIF
	 IF(IPRINT(NE+J-56,3).EQ.1) THEN
	   ICOL=ICOL+1
	   PNAME(ICOL)='"D1N'//VNAME(J-14)//'"'
	   DO 332 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZE(I,5*(J-14)-2)*ZE(I,5*(J+35)-2)-
     X      ZE(I,5*(J-7)-2)*ZE(I,5*(J+28)-2))/
     X      (ZE(I,J*5-2)*ZE(I,5*(J+21)-2))-(
     X      (ZE(I-1,5*(J-14)-2)*ZE(I-1,5*(J+35)-2)-
     X      ZE(I-1,5*(J-7)-2)*ZE(I-1,5*(J+28)-2))/
     X      (ZE(I-1,J*5-2)*ZE(I-1,5*(J+21)-2)) ))
  332     CONTINUE
	 ENDIF
  340 CONTINUE
C
      DO 350 J=1,7
	 IF(IPRINT(NE+J+21,2).EQ.2) THEN
	   ICOL=ICOL+1
	   PNAME(ICOL)='"PDT'//VNAME(NE+J+21)//'"'
	   DO 341 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZO(I,5*J-2)-ZO(I,5*J-4))/ZO(I,5*J-4))
 341       CONTINUE
	 ENDIF
	 IF(IPRINT(NE+J+21,3).EQ.2) THEN
	   ICOL=ICOL+1
	   PNAME(ICOL)='"PD1'//VNAME(NE+J+21)//'"'
	   DO 342 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZO(I,5*J-2)-ZO(I-1,5*J-2))/ZO(I-1,5*J-2))
 342       CONTINUE
	 ENDIF
 350   CONTINUE
C
       DO 360 J=8,14
	 IF(IPRINT(NE+J+21,2).EQ.2) THEN
	   ICOL=ICOL+1
	   PNAME(ICOL)='"PDT'//VNAME(NE+J+21)//'"'
	   DO 351 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZO(I,5*J-2)-ZO(I,5*J-4))/ZO(I,5*J-4))
 351       CONTINUE
	  ENDIF
	 IF(IPRINT(NE+J+21,3).EQ.2) THEN
	   ICOL=ICOL+1
	   PNAME(ICOL)='"PD1'//VNAME(NE+J+21)//'"'
	   DO 352 I=NBEP,NEEP
	    ZPRINT(I-NBEP+1,ICOL)=100.0D0*(
     X      (ZO(I,5*J-2)-ZO(I-1,5*J-2))/ZO(I-1,5*J-2))
 352       CONTINUE
	 ENDIF
 360   CONTINUE
C
      WRITE(*,*) 'PRINTING OUTPUT TO FILE.'
      WRITE(7,*) ' '
C      WRITE(12,*) ' '
C
C WRITE OUTPUT TO FILE
C
C NCOLS IS THE TOTAL NUMBER OF VARIABLES TO BE PRINTED
C ISW IS THE NUMBER OF VARIABLES TO BE PRINTED AT A TIME
C
      IPEND=(NCOLS-1)/ISW +1
      DO 600 K=1,IPEND
	 IPB=(K-1)*ISW+1
	 IPE=IPB+ISW-1
	 IF (IPE.GT.NCOLS) IPE=NCOLS 
	 WRITE(7,*) (PNAME(J),J=IPB,IPE)
	 DO 500 I=1,NDURP
	    WRITE(7,1000) (ZPRINT(I,J),J=IPB,IPE)
  500    CONTINUE
	 IF (IPE.EQ.NCOLS) GOTO 650
	 WRITE(7,*) ' ' 
 600  CONTINUE
C
 650  CONTINUE
C
C      WRITE(12,*) (PNAME(J),J=1,NCOLS)
C      DO 700 I=1,NDURP
C	 WRITE(12,1100) (ZPRINT(I,J),J=1,NCOLS)
C 700  CONTINUE
C
 1000 FORMAT (6E13.5)
C 1100 FORMAT (400F7.3)
      RETURN
      END
C
C  *********************************************************************
C  SUBROUTINE RESID                                                            
C  *********************************************************************       
C                                                                              
C  THIS SUBROUTINE CALCULATES RESIDUALS FOR ANY SPECIFICATION OF N1,           
C  N2, N3, AND N4 WHERE:                                                       
C  N1 = VECTOR HOLDING TO BE USED FOR LHS VARIABLE                             
C  N2 = VECTOR HOLDING TO BE USED FOR CURRENT OR PAST RHS VARIABLES            
C       THAT ARE NOT `EXPECTATION VARIABLES'                                   
C  N3 = VECTOR HOLDING TO BE USED FOR CURRENT OR PAST RHS VARIABLES            
C       THAT ARE `EXPECTATION VARIABLES'                                       
C  N4 = VECTOR HOLDING TO BE USED FOR FUTURE RHS VARIABLES.                    
C  (NOTE THAT Ni IS AN ELEMENT OF {1,2,3,4,5}, i=1,2,3,4.)                     
C                                                                              
C  NBU=BEGINNING PERIOD FOR CALCULATION OF RESIDUALS (INPUT).                  
C  NEU=ENDING PERIOD FOR CALCULATION OF RESIDUALS (INPUT).                     
C  U = THE MATRIX OF RESIDUALS COMPUTED FOR THE PERIOD NBU TO NEU              
C      (OUTPUT).                                                               
C                                                                              
      SUBROUTINE RESID(N1,N2,N3,N4,NBU,NEU,U)
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3,H=8)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      DOUBLE PRECISION RS(NT,N),RS1(NT,N),RS2(NT,N),RS3(NT,N),
     X RS4(NT,N),RS5(NT,N),RS6(NT,N),E1(NT,N),E2(NT,N),E3(NT,N),
     X E4(NT,N),E5(NT,N),E6(NT,N),RL(NT,N),RL1(NT,N),RL2(NT,N),
     X RL3(NT,N),RL4(NT,N),RL5(NT,N),RL6(NT,N),CD(NT,N),CN(NT,N),
     X CS(NT,N),CD1(NT,N),CN1(NT,N),CS1(NT,N),CD2(NT,N),CN2(NT,N),
     X CS2(NT,N),C3(NT,N),C4(NT,N),CD5(NT,N),CN5(NT,N),CS5(NT,N),
     X CD6(NT,N),CN6(NT,N),CS6(NT,N),INE(NT,N),INS(NT,N),IR(NT,N),
     X II(NT,N),IF1(NT,N),II1(NT,N),IN2(NT,N),                                 
     X IR2(NT,N),II2(NT,N),IF3(NT,N),II3(NT,N),                             
     X IF4(NT,N),II4(NT,N),IN5(NT,N),IR5(NT,N),II5(NT,N),                   
     X IN6(NT,N),IR6(NT,N),II6(NT,N),EX(NT,N),                              
     X EX1(NT,N),EX2(NT,N),EX3(NT,N),EX4(NT,N),EX5(NT,N),EX6(NT,N),         
     X IM(NT,N),IM1(NT,N),IM2(NT,N),IM3(NT,N),IM4(NT,N),IM5(NT,N),          
     X IM6(NT,N),Y(NT,N),Y1(NT,N),Y2(NT,N),Y3(NT,N),Y4(NT,N),               
     X Y5(NT,N),Y6(NT,N),X(NT,N),X1(NT,N),X2(NT,N),                         
     X X3(NT,N),X4(NT,N),X5(NT,N),X6(NT,N),W(NT,N),W1(NT,N),                
     X W2(NT,N),W3(NT,N),W4(NT,N),W5(NT,N),W6(NT,N),P(NT,N),                
     X P1(NT,N),P2(NT,N),P3(NT,N),P4(NT,N),P5(NT,N),P6(NT,N)                
      DOUBLE PRECISION PI(NT,N),PI1(NT,N),PI2(NT,N),PI3(NT,N),PI4(NT,N),
     X PI5(NT,N),PI6(NT,N),PE(NT,N),PE1(NT,N),PE2(NT,N),PE3(NT,N),
     X PE4(NT,N),PE5(NT,N),PE6(NT,N),M(NT,N),M1(NT,N),M2(NT,N),M3(NT,N),
     X M4(NT,N),M5(NT,N),M6(NT,N),G(NT,N),G1(NT,N),G2(NT,N),G3(NT,N),
     X G4(NT,N),G5(NT,N),G6(NT,N),T(NT),TT(NT),LE1(NT,N),LE2(NT,N),
     X LE3(NT,N),LE4(NT,N),LE5(NT,N),LE6(NT,N),LEX(NT,N),LEX1(NT,N),
     X LEX2(NT,N),LEX3(NT,N),LEX4(NT,N),LEX5(NT,N),LEX6(NT,N),LIM(NT,N),
     X LIM1(NT,N),LIM2(NT,N),LIM3(NT,N),LIM4(NT,N),LIM5(NT,N),
     X LIM6(NT,N),LX(NT,N),LX1(NT,N),LX2(NT,N),LX3(NT,N),LX4(NT,N),
     X LX5(NT,N),LX6(NT,N),LW(NT,N),LW1(NT,N),LW2(NT,N),                  
     X LW3(NT,N),LW4(NT,N),LW5(NT,N),LW6(NT,N),LP(NT,N),                    
     X LP1(NT,N),LP2(NT,N),LP3(NT,N),LP4(NT,N),LP5(NT,N),                   
     X LP6(NT,N),LPI(NT,N),LPI1(NT,N),LPI2(NT,N),LPI3(NT,N),                
     X LPI4(NT,N),LPI5(NT,N),LPI6(NT,N),LPE(NT,N),LPE1(NT,N),               
     X LPE2(NT,N),LPE3(NT,N),LPE4(NT,N),LPE5(NT,N),LPE6(NT,N),              
     X LM(NT,N),LM1(NT,N),LM2(NT,N),LM3(NT,N),LM4(NT,N),LM5(NT,N),          
     X LM6(NT,N),LMW(NT,N)                                                  
      DOUBLE PRECISION PSI(0:6,0:MAXLAG),PHI(0:6,0:MAXLAG),
     X PSI5(NT,0:MAXLAG),PHI5(NT,0:MAXLAG),DELTA(0:6,NT),GAMMA(0:6)
      DOUBLE PRECISION YQ(NT),PARG(0:6,2)
      DOUBLE PRECISION U(NE,NT),YGAP(NT,4),YGAP1(NT,4),YGAP2(NT,4),
     X    YGAP3(NT,4),YGAP4(NT,4),YGAP5(NT,4),YGAP6(NT,4)                      
      DOUBLE PRECISION COEF(NCOEFL,NCOEFS)
C
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /VARS/ COEF
      COMMON /WAGE/ PSI,PHI,PSI5,PHI5,DELTA,GAMMA
      COMMON /Z/ ZE,ZO
      COMMON /PAR/ PARG
C
      EQUIVALENCE (ZE(1,1),RS),(ZE(1,6),RS1),(ZE(1,11),RS2),                   
     X       (ZE(1,16),RS3),(ZE(1,21),RS4),(ZE(1,26),RS5),(ZE(1,31),           
     X       RS6),(ZE(1,36),LE1),(ZE(1,41),LE2),(ZE(1,46),LE3),                
     X       (ZE(1,51),LE4),(ZE(1,56),LE5),(ZE(1,61),LE6),                     
     X       (ZE(1,66),RL),(ZE(1,71),RL1),(ZE(1,76),RL2),(ZE(1,81),            
     X       RL3),(ZE(1,86),RL4),(ZE(1,91),RL5),(ZE(1,96),RL6),                
     X       (ZE(1,101),CD),(ZE(1,106),CN),(ZE(1,111),CS),(ZE(1,116),          
     X       CD1),(ZE(1,121),CN1),(ZE(1,126),CS1),(ZE(1,131),CD2),             
     X       (ZE(1,136),CN2),(ZE(1,141),CS2),(ZE(1,146),C3),(ZE(1,151),        
     X       C4),(ZE(1,156),CD5),(ZE(1,161),CN5),(ZE(1,166),CS5),              
     X       (ZE(1,171),CD6),(ZE(1,176),CN6),(ZE(1,181),CS6),                  
     X       (ZE(1,186),INE),(ZE(1,191),INS),(ZE(1,196),IR),(ZE(1,201),        
     X       II),(ZE(1,206),IF1),(ZE(1,211),II1),(ZE(1,216),IN2),              
     X       (ZE(1,221),IR2),(ZE(1,226),II2),(ZE(1,231),IF3),                  
     X       (ZE(1,236),II3),(ZE(1,241),IF4),(ZE(1,246),II4),                  
     X       (ZE(1,251),IN5),(ZE(1,256),IR5),(ZE(1,261),II5),                  
     X       (ZE(1,266),IN6),(ZE(1,271),IR6),(ZE(1,276),II6),                  
     X       (ZE(1,281),LEX),(ZE(1,286),LEX1),(ZE(1,291),LEX2),                
     X       (ZE(1,296),LEX3),(ZE(1,301),LEX4),(ZE(1,306),LEX5),               
     X       (ZE(1,311),LEX6),(ZE(1,316),LIM),(ZE(1,321),LIM1)                 
      EQUIVALENCE (ZE(1,326),LIM2),(ZE(1,331),LIM3),(ZE(1,336),LIM4),          
     X       (ZE(1,341),LIM5),(ZE(1,346),LIM6),                                
     X       (ZE(1,351),Y),(ZE(1,356),Y1),(ZE(1,361),Y2),(ZE(1,366),           
     X       Y3),(ZE(1,371),Y4),(ZE(1,376),Y5),(ZE(1,381),Y6),                 
     X       (ZE(1,386),LX),(ZE(1,391),LX1),(ZE(1,396),LX2),(ZE(1,401),        
     X       LX3),(ZE(1,406),LX4),(ZE(1,411),LX5),(ZE(1,416),LX6),             
     X       (ZE(1,421),LW),(ZE(1,426),LW1),(ZE(1,431),LW2),(ZE(1,436),        
     X       LW3),(ZE(1,441),LW4),(ZE(1,446),LW5),(ZE(1,451),LW6),             
     X       (ZE(1,456),LP),(ZE(1,461),LP1),(ZE(1,466),LP2),(ZE(1,471),        
     X       LP3),(ZE(1,476),LP4),(ZE(1,481),LP5),(ZE(1,486),LP6),             
     X       (ZE(1,491),LPI),(ZE(1,496),LPI1),(ZE(1,501),LPI2),                
     X       (ZE(1,506),LPI3),(ZE(1,511),LPI4),(ZE(1,516),LPI5),               
     X       (ZE(1,521),LPI6),(ZE(1,526),LPE),(ZE(1,531),LPE1),                
     X       (ZE(1,536),LPE2),(ZE(1,541),LPE3),(ZE(1,546),LPE4),               
     X       (ZE(1,551),LPE5),(ZE(1,556),LPE6)                                 
      EQUIVALENCE (ZO(1,1),LM),(ZO(1,6),LM1),(ZO(1,11),LM2),(ZO(1,16),         
     X       LM3),(ZO(1,21),LM4),(ZO(1,26),LM5),(ZO(1,31),LM6),                
     X       (ZO(1,36),G),(ZO(1,41),G1),(ZO(1,46),G2),(ZO(1,51),G3),           
     X       (ZO(1,56),G4),(ZO(1,61),G5),(ZO(1,66),G6),(ZO(1,71),T),           
     X       (ZO(1,76),TT),(ZO(1,81),E1),(ZO(1,86),E2),(ZO(1,91),E3),          
     X       (ZO(1,96),E4),(ZO(1,101),E5),(ZO(1,106),E6),                      
     X       (ZO(1,111),EX),(ZO(1,116),EX1),(ZO(1,121),EX2),                   
     X       (ZO(1,126),EX3),(ZO(1,131),EX4),(ZO(1,136),EX5),                  
     X       (ZO(1,141),EX6),(ZO(1,146),IM),(ZO(1,151),IM1),                   
     X       (ZO(1,156),IM2),(ZO(1,161),IM3),(ZO(1,166),IM4),                  
     X       (ZO(1,171),IM5),(ZO(1,176),IM6),                                  
     X       (ZO(1,181),X),(ZO(1,186),X1),(ZO(1,191),X2),(ZO(1,196),           
     X       X3),(ZO(1,201),X4),(ZO(1,206),X5),(ZO(1,211),X6),                 
     X       (ZO(1,216),W),(ZO(1,221),W1),(ZO(1,226),W2),(ZO(1,231),           
     X       W3),(ZO(1,236),W4),(ZO(1,241),W5),(ZO(1,246),W6),                 
     X       (ZO(1,251),P),(ZO(1,256),P1),(ZO(1,261),P2),(ZO(1,266),           
     X       P3),(ZO(1,271),P4),(ZO(1,276),P5),(ZO(1,281),P6),                 
     X       (ZO(1,286),PI),(ZO(1,291),PI1),(ZO(1,296),PI2),(ZO(1,301),        
     X       PI3),(ZO(1,306),PI4),(ZO(1,311),PI5),(ZO(1,316),PI6)              
      EQUIVALENCE (ZO(1,321),PE),(ZO(1,326),PE1),(ZO(1,331),PE2),              
     X       (ZO(1,336),PE3),(ZO(1,341),PE4),(ZO(1,346),PE5),(ZO(1,351),       
     X       PE6),(ZO(1,356),M),(ZO(1,361),M1),(ZO(1,366),M2),                 
     X       (ZO(1,371),M3),(ZO(1,376),M4),(ZO(1,381),M5),(ZO(1,386),          
     X       M6),(ZO(1,391),LMW)                                               
C
      WRITE(*,*) 'CALCULATING RESIDUALS.'
C
C  ADJUST PERIOD OVER WHICH RESIDUALS ARE COMPUTED IF PERIOD
C  STARTS TOO SOON RELATIVE TO AVAILABLE DATA, GIVEN MAXIMUM
C  LAG, OR TOO LATE GIVEN MAXIMUM LEAD.
C
      IF(NBU.GT.MAXLAG) THEN                                                   
	NBUU=NBU                                                               
      ELSE                                                                     
	NBUU=MAXLAG+1                                                          
	DO 10 J=NBU,MAXLAG                                                     
	  DO 10 I=1,NE                                                         
	    U(I,J)=0.D0                                                        
  10    CONTINUE                                                               
      END IF
C
      IF(NEU.LE.NT-H) THEN                                                     
	NEUU=NEU                                                               
      ELSE                                                                     
	NEUU=NT-H                                                              
	DO 20 J=NT-H+1,NEU                                                     
	  DO 20 I=1,NE                                                         
	    U(I,J)=0.D0                                                        
 20     CONTINUE                                                               
      END IF
C
C  CONSTRUCT RESIDUAL MATRIX U (DO 100 LOOP)
C
      DO 100 J=NBUU,NEUU
C
      WNE=   0.091*(LE1(J,2))+0.175*(LE2(J,2))                                
     X       +0.265*(LE3(J,2))+0.123*(LE4(J,2))                                
     X       +0.189*(LE5(J,2))+0.157*(LE6(J,2))                                
     X      -(0.091*(LE1(J,1))+0.175*(LE2(J,1))                                
     X       +0.265*(LE3(J,1))+0.123*(LE4(J,1))                                
     X       +0.189*(LE5(J,1))+0.157*(LE6(J,1)))                               
       WNE1= -LE1(J,2) +0.141*(LE2(J,2))                                       
     X       +0.213*(LE3(J,2))+0.099*(LE4(J,2))                                
     X       +0.152*(LE5(J,2))+0.127*(LE6(J,2))                                
     X      -(-LE1(J,1) +0.141*(LE2(J,1))                                      
     X       +0.213*(LE3(J,1))+0.099*(LE4(J,1))                                
     X       +0.152*(LE5(J,1))+0.127*(LE6(J,1)))                               
	WNE2= -LE2(J,2) +0.079*(LE1(J,2))                                      
     X       +0.229*(LE3(J,2))+0.106*(LE4(J,2))                                
     X       +0.163*(LE5(J,2))+0.136*(LE6(J,2))                                
     X      -( -LE2(J,1) +0.079*(LE1(J,1))                                     
     X       +0.229*(LE3(J,1))+0.106*(LE4(J,1))                                
     X       +0.163*(LE5(J,1))+0.136*(LE6(J,1)))                               
	WNE3= -LE3(J,2) +0.085*(LE1(J,2))                                      
     X       +0.164*(LE2(J,2))+0.116*(LE4(J,2))                                
     X       +0.177*(LE5(J,2))+0.147*(LE6(J,2))                                
     X      -( -LE3(J,1) +0.085*(LE1(J,1))                                     
     X       +0.164*(LE2(J,1))+0.116*(LE4(J,1))                                
     X       +0.177*(LE5(J,1))+0.147*(LE6(J,1)))                               
	WNE4= -LE4(J,2) +0.075*(LE1(J,2))                                      
     X       +0.145*(LE2(J,2))+0.219*(LE3(J,2))                                
     X       +0.156*(LE5(J,2))+0.130*(LE6(J,2))                                
     X      -( -LE4(J,1) +0.075*(LE1(J,1))                                     
     X       +0.145*(LE2(J,1))+0.219*(LE3(J,1))                                
     X       +0.156*(LE5(J,1))+0.130*(LE6(J,1)))                               
	WNE5= -LE5(J,2) +0.079*(LE1(J,2))                                      
     X       +0.153*(LE2(J,2))+0.232*(LE3(J,2))                                
     X       +0.108*(LE4(J,2))+0.137*(LE6(J,2))                                
     X      -( -LE5(J,1) +0.079*(LE1(J,1))                                     
     X       +0.153*(LE2(J,1))+0.232*(LE3(J,1))                                
     X       +0.108*(LE4(J,1))+0.137*(LE6(J,1)))                               
	WNE6= -LE6(J,2) +0.077*(LE1(J,2))                                      
     X       +0.149*(LE2(J,2))+0.225*(LE3(J,2))                                
     X       +0.105*(LE4(J,2))+0.161*(LE5(J,2))                                
     X      -(-LE6(J,1) +0.077*(LE1(J,1))                                      
     X       +0.149*(LE2(J,1))+0.225*(LE3(J,1))                                
     X       +0.105*(LE4(J,1))+0.161*(LE5(J,1)))                               
       WRE=   0.091*(LP1(J,2)+LE1(J,2))+0.175*(LP2(J,2)+LE2(J,2))              
     X       +0.265*(LP3(J,2)+LE3(J,2))+0.123*(LP4(J,2)+LE4(J,2))              
     X       +0.189*(LP5(J,2)+LE5(J,2))+0.157*(LP6(J,2)+LE6(J,2))              
     X      -(0.091*(LP1(J,1)+LE1(J,1))+0.175*(LP2(J,1)+LE2(J,1))              
     X       +0.265*(LP3(J,1)+LE3(J,1))+0.123*(LP4(J,1)+LE4(J,1))              
     X       +0.189*(LP5(J,1)+LE5(J,1))+0.157*(LP6(J,1)+LE6(J,1)))             
       WRE1= 0.268*LP(J,2)  -LE1(J,2) +0.141*(LP2(J,2)+LE2(J,2))               
     X       +0.213*(LP3(J,2)+LE3(J,2))+0.099*(LP4(J,2)+LE4(J,2))              
     X       +0.152*(LP5(J,2)+LE5(J,2))+0.127*(LP6(J,2)+LE6(J,2))              
     X      -(0.268*LP(J,1)  -LE1(J,1) +0.141*(LP2(J,1)+LE2(J,1))              
     X       +0.213*(LP3(J,1)+LE3(J,1))+0.099*(LP4(J,1)+LE4(J,1))              
     X       +0.152*(LP5(J,1)+LE5(J,1))+0.127*(LP6(J,1)+LE6(J,1)))             
	WRE2= 0.287*LP(J,2)  -LE2(J,2) +0.079*(LP1(J,2)+LE1(J,2))              
     X       +0.229*(LP3(J,2)+LE3(J,2))+0.106*(LP4(J,2)+LE4(J,2))              
     X       +0.163*(LP5(J,2)+LE5(J,2))+0.136*(LP6(J,2)+LE6(J,2))              
     X      -(0.287*LP(J,1)  -LE2(J,1) +0.079*(LP1(J,1)+LE1(J,1))              
     X       +0.229*(LP3(J,1)+LE3(J,1))+0.106*(LP4(J,1)+LE4(J,1))              
     X       +0.163*(LP5(J,1)+LE5(J,1))+0.136*(LP6(J,1)+LE6(J,1)))             
	WRE3= 0.311*LP(J,2)  -LE3(J,2) +0.085*(LP1(J,2)+LE1(J,2))              
     X       +0.164*(LP2(J,2)+LE2(J,2))+0.116*(LP4(J,2)+LE4(J,2))              
     X       +0.177*(LP5(J,2)+LE5(J,2))+0.147*(LP6(J,2)+LE6(J,2))              
     X      -(0.311*LP(J,1)  -LE3(J,1) +0.085*(LP1(J,1)+LE1(J,1))              
     X       +0.164*(LP2(J,1)+LE2(J,1))+0.116*(LP4(J,1)+LE4(J,1))              
     X       +0.177*(LP5(J,1)+LE5(J,1))+0.147*(LP6(J,1)+LE6(J,1)))             
	WRE4= 0.275*LP(J,2)  -LE4(J,2) +0.075*(LP1(J,2)+LE1(J,2))              
     X       +0.145*(LP2(J,2)+LE2(J,2))+0.219*(LP3(J,2)+LE3(J,2))              
     X       +0.156*(LP5(J,2)+LE5(J,2))+0.130*(LP6(J,2)+LE6(J,2))              
     X      -(0.275*LP(J,1)  -LE4(J,1) +0.075*(LP1(J,1)+LE1(J,1))             
     X       +0.145*(LP2(J,1)+LE2(J,1))+0.219*(LP3(J,1)+LE3(J,1))              
     X       +0.156*(LP5(J,1)+LE5(J,1))+0.130*(LP6(J,1)+LE6(J,1)))             
	WRE5= 0.291*LP(J,2)  -LE5(J,2) +0.079*(LP1(J,2)+LE1(J,2))              
     X       +0.153*(LP2(J,2)+LE2(J,2))+0.232*(LP3(J,2)+LE3(J,2))              
     X       +0.108*(LP4(J,2)+LE4(J,2))+0.137*(LP6(J,2)+LE6(J,2))              
     X      -(0.291*LP(J,1)  -LE5(J,1) +0.079*(LP1(J,1)+LE1(J,1))              
     X       +0.153*(LP2(J,1)+LE2(J,1))+0.232*(LP3(J,1)+LE3(J,1))              
     X       +0.108*(LP4(J,1)+LE4(J,1))+0.137*(LP6(J,1)+LE6(J,1)))             
	WRE6= 0.283*LP(J,2)  -LE6(J,2) +0.077*(LP1(J,2)+LE1(J,2))              
     X       +0.149*(LP2(J,2)+LE2(J,2))+0.225*(LP3(J,2)+LE3(J,2))              
     X       +0.105*(LP4(J,2)+LE4(J,2))+0.161*(LP5(J,2)+LE5(J,2))              
     X      -(0.283*LP(J,1)  -LE6(J,1) +0.077*(LP1(J,1)+LE1(J,1))              
     X       +0.149*(LP2(J,1)+LE2(J,1))+0.225*(LP3(J,1)+LE3(J,1))              
     X       +0.105*(LP4(J,1)+LE4(J,1))+0.161*(LP5(J,1)+LE5(J,1)))
C
      EEMS=.20*WRE2+.20*WRE4+.40*WRE3+.20*WRE6
C
      PW=.20*(LP(J,2)-LP(J,1))+.05*(LP1(J,2)-LP1(J,1))+.05*                    
     X (LP2(J,2)-LP2(J,1))+.05*(LP4(J,2)-LP4(J,1))+.10*                        
     X (LP3(J,2)-LP3(J,1))+.05*(LP6(J,2)-LP6(J,1))+.50*                        
     X (LP5(J,2)-LP5(J,1))
C
      EPW=.20*(LP(J+4,4)-LP(J,2)-LP(J+4,1)+LP(J,1))+                           
     X .05*(LP1(J+4,4)-LP1(J,2)-LP1(J+4,1)+LP1(J,1))+
     X .05*(LP2(J+4,4)-LP2(J,2)-LP2(J+4,1)+LP2(J,1))+
     X .10*(LP3(J+4,4)-LP3(J,2)-LP3(J+4,1)+LP3(J,1))+
     X .05*(LP4(J+4,4)-LP4(J,2)-LP4(J+4,1)+LP4(J,1))+
     X .50*(LP5(J+4,4)-LP5(J,2)-LP5(J+4,1)+LP5(J,1))+
     X .05*(LP6(J+4,4)-LP6(J,2)-LP6(J+4,1)+LP6(J,1))
C
      YW=.20*(LP(J,2)-LP(J,1))+.05*(LP1(J,2)-LP1(J,1))+.05*
     X (LP2(J,2)-LP2(J,1))+.05*(LP4(J,2)-LP4(J,1))+.10*                        
     X (LP3(J,2)-LP3(J,1))+.05*(LP6(J,2)-LP6(J,1))+.50*                        
     X (LP5(J,2)-LP5(J,1))+.20*(LOG(Y(J,2)/Y(J,1)))+.05*                       
     X (LOG(Y1(J,2)/Y1(J,1)))+.05*(LOG(Y2(J,2)/Y2(J,1)))                       
     X +.05*(LOG(Y4(J,2)/Y4(J,1)))+.10*                                        
     X (LOG(Y3(J,2)/Y3(J,1)))+.05*(LOG(Y6(J,2)/Y6(J,1)))+.50*                  
     X (LOG(Y5(J,2)/Y5(J,1)))
C
      YEMS=.20*(LOG(Y2(J,2)/Y2(J,1)))+.20*(LOG(Y4(J,2)/Y4(J,1)))               
     X +.40*(LOG(Y3(J,2)/Y3(J,1)))+.20*(LOG(Y6(J,2)/Y6(J,1)))                  
      PEMS=.20*(LP2(J,2)-LP2(J,1))+.20*(LP4(J,2)-LP4(J,1))+.40*                
     X (LP3(J,2)-LP3(J,1))+.20*(LP6(J,2)-LP6(J,1))                             
      EPEMS=.20*(LP2(J+4,4)-LP2(J+4,1)-LP2(J,2)+LP2(J,1))                      
     X +.40*(LP3(J+4,4)-LP3(J+4,1)-LP3(J,2)+LP3(J,1))                          
     X +.20*(LP4(J+4,4)-LP4(J+4,1)-LP4(J,2)+LP4(J,1))                          
     X +.20*(LP6(J+4,4)-LP6(J+4,1)-LP6(J,2)+LP6(J,1))                          
      PNAMS=.80*(LP(J,2)-LP(J,1))+.20*(LP1(J,2)-LP1(J,1))                      
      EPNAMS=.80*(LP(J+4,4)-LP(J+4,1)-LP(J,2)+LP(J,1))                         
     X +.20*(LP1(J+4,4)-LP1(J+4,1)-LP1(J,2)+LP1(J,1))
C
C---------------------------------------------------------------------
C
C BEGINNING OF LIST OF COUNTRY EQUATIONS
C
C---------------------------------------------------------------------
C
C INTEREST RATE/MONEY SUPPLY EQUATIONS
C
C FOR FLEXIBLE EXCHANGE RATES THERE ARE TWO OPTIONS:
C
C     IPRULE=0: INTEREST RATE DETERMINED BY INVERTED MONEY DEMAND 
C               EQUATION AND EXOGENOUS MONEY SUPPLY
C     IPRULE=1: INTEREST RATE DETERMINED BY INTEREST RATE REACTION
C               FUNCTION AND MONEY SUPPLY ENDOGENOUS
C               REACTION FUNCTION PARAMETERS ARE INPUT BY USER
C               AS MATRIX PARG(.,.)
C
      IF(IFLEXE.EQ.1) THEN
C
      IF (IPRULE.EQ.0) THEN
	  U(1,J)=RS(J,N1)
     X     -(COEF(1,1)+COEF(1,2)*(LM(J,N2)-LP(J,N2))+COEF(1,3)*
     X     (LM(J-1,N2)-LP(J-1,N2))+COEF(1,4)*DLOG(Y(J,N2))
     X     +COEF(1,5)*TT(J))
	  U(2,J)=RS1(J,N1)
     X     -(COEF(2,1)+COEF(2,2)*(LM1(J,N2)-LP1(J,N2))+COEF(2,3)*
     X     (LM1(J-1,N2)-LP1(J-1,N2))+COEF(2,4)*DLOG(Y1(J,N2)))
	  U(3,J)=RS2(J,N1)
     X     -(COEF(3,1)+COEF(3,2)*(LM2(J,N2)-LP2(J,N2))+COEF(3,3)*
     X     (LM2(J-1,N2)-LP2(J-1,N2))+COEF(3,4)*DLOG(Y2(J,N2)))
	  U(4,J)=RS3(J,N1)
     X     -(COEF(4,1)+COEF(4,2)*(LM3(J,N2)-LP3(J,N2))+COEF(4,3)*
     X     (LM3(J-1,N2)-LP3(J-1,N2))+COEF(4,4)*DLOG(Y3(J,N2)))
	  U(5,J)=RS4(J,N1)
     X     -(COEF(5,1)+COEF(5,2)*(LM4(J,N2)-LP4(J,N2))+COEF(5,3)*
     X     (LM4(J-1,N2)-LP4(J-1,N2))+COEF(5,4)*DLOG(Y4(J,N2)))
	  U(6,J)=RS5(J,N1)
     X     -(COEF(6,1)+COEF(6,2)*(LM5(J,N2)-LP5(J,N2))+COEF(6,3)*
     X     (LM5(J-1,N2)-LP5(J-1,N2))+COEF(6,4)*DLOG(Y5(J,N2)))
	  U(7,J)=RS6(J,N1)
     X     -(COEF(7,1)+COEF(7,2)*(LM6(J,N2)-LP6(J,N2))+COEF(7,3)*
     X     (LM6(J-1,N2)-LP6(J-1,N2))+COEF(7,4)*DLOG(Y6(J,N2))
     X     +COEF(7,5)*TT(J))
      END IF
C
      IF(IPRULE.EQ.1) THEN
	 U(1,J)=RS(J,N1)-LP(J+4,N4)+LP(J,N2)-RS(J,1)+LP(J+4,1)
     X       -LP(J,1)-PARG(0,1)*(LP(J,N2)-LP(J,N1))
     X       -PARG(0,2)*DLOG(Y(J,N2)/Y(J,N1))
	 U(2,J)=RS1(J,N1)-LP1(J+4,N4)+LP1(J,N2)-RS1(J,1)+LP1(J+4,1)
     X       -LP1(J,1)-PARG(1,1)*(LP1(J,N2)-LP1(J,N1))
     X       -PARG(1,2)*DLOG(Y1(J,N2)/Y1(J,N1))
	 U(3,J)=RS2(J,N1)-LP2(J+4,N4)+LP2(J,N2)-RS2(J,1)+LP2(J+4,1)
     X       -LP2(J,1)-PARG(2,1)*(LP2(J,N2)-LP2(J,N1))
     X       -PARG(2,2)*DLOG(Y2(J,N2)/Y2(J,N1))
	 U(4,J)=RS3(J,N1)-LP3(J+4,N4)+LP3(J,N2)-RS3(J,1)+LP3(J+4,1)
     X       -LP3(J,1)-PARG(3,1)*(LP3(J,N2)-LP3(J,N1))
     X       -PARG(3,2)*DLOG(Y3(J,N2)/Y3(J,N1))
	 U(5,J)=RS4(J,N1)-LP4(J+4,N4)+LP4(J,N2)-RS4(J,1)+LP4(J+4,1)
     X       -LP4(J,1)-PARG(4,1)*(LP4(J,N2)-LP4(J,N1))
     X       -PARG(4,2)*DLOG(Y4(J,N2)/Y4(J,N1))
	 U(6,J)=RS5(J,N1)-LP5(J+4,N4)+LP5(J,N2)-RS5(J,1)+LP5(J+4,1)
     X       -LP5(J,1)-PARG(5,1)*(LP5(J,N2)-LP5(J,N1))
     X       -PARG(5,2)*DLOG(Y5(J,N2)/Y5(J,N1))
	 U(7,J)=RS6(J,N1)-LP6(J+4,N4)+LP6(J,N2)-RS6(J,1)+LP6(J+4,1)
     X       -LP6(J,1)-PARG(6,1)*(LP6(J,N2)-LP6(J,N1))
     X       -PARG(6,2)*DLOG(Y6(J,N2)/Y6(J,N1))
      END IF
C
      U(8,J)=LE1(J,N1)  -(LE1(J+1,N4)+COEF(8,1)*(RS1(J,N2)-RS(J,N2)))          
      U(9,J)=LE2(J,N1)  -(LE2(J+1,N4)+COEF(9,1)*(RS2(J,N2)-RS(J,N2)))          
      U(10,J)=LE3(J,N1) -(LE3(J+1,N4)+COEF(10,1)*(RS3(J,N2)-RS(J,N2)))         
      U(11,J)=LE4(J,N1) -(LE4(J+1,N4)+COEF(11,1)*(RS4(J,N2)-RS(J,N2)))         
      U(12,J)=LE5(J,N1) -(LE5(J+1,N4)+COEF(12,1)*(RS5(J,N2)-RS(J,N2)))         
      U(13,J)=LE6(J,N1) -(LE6(J+1,N4)+COEF(13,1)*(RS6(J,N2)-RS(J,N2)))
C
      END IF
C      
C FOR FIXED EXCHANGE RATES THERE ARE A NUMBER OF OPTIONS.
C     IPRULE=0: U.S. LEADER IN FIXED EXCHANGE RATE REGIME
C               U.S. SETS INTEREST RATE ACCORDING TO INVERTED
C               MONEY DEMAND EQUATION AND EXOGENOUS MONEY SUPPLY
C               REMAINING COUNTRIES FIX INTEREST RATES TO THAT OF
C               U.S.; THUS, THEIR MONEY SUPPLIES ARE ENDOGENOUS
C     IPRULE=I  FOR 1-6: SAME AS IPRULE=0, EXCEPT SUBSTITUTE  COUNTRY
C                INDEXED BY IPRULE NUMBER FOR U.S. AS LEADER;
C                E.G., IPRULE=5: JAPAN IS LEADER
C     IPRULE=10: U.S. LEADER IN FIXED EXCHANGE RATE REGIME
C                U.S. SETS INTEREST RATE ACCORDING TO INTEREST RATE
C                REACTION FUNCTION. U.S. MONEY SUPPLY ENDOGENOUS.
C                REMAINING COUNTRIES FIX INTEREST RATES TO THAT OF
C                U.S.; THUS, THEIR MONEY SUPPLIES ARE ENDOGENOUS
C     IPRULE=I;  FOR I=11-16: SAME AS IPRULE=10, EXCEPT SUBSTITUTE  
C                COUNTRY INDEXED BY IPRULE-10 NUMBER FOR U.S. AS LEADER;
C     IPRULE=20: EMS WITH GERMANY AS LEADER AND INTEREST RATES OF
C                GERMANY AND NON-EMS COUNTRIES DETERMINED BY INVERTED
C                MONEY DEMAND EQUATIONS
C     IPRULE=21: EMS WITH GERMANY AS LEADER AND INTEREST RATES OF
C                GERMANY AND NON-EMS COUNTRIES DETERMINED BY INTEREST
C                RATE REACTION FUNCTIONS
C     IPRULE=22: SYMMETRIC EMS AS DEFINED BY VOLKER WIELAND (11-92)
C     
C
      IF(IFLEXE.EQ.0) THEN
C
C U.S. LEADER EQUATIONS
C
      IF ((IPRULE.EQ.0).OR.(IPRULE.EQ.10)) THEN
	 IF (IPRULE.EQ.0) THEN
	    U(1,J)=RS(J,N1)
     X       -(COEF(1,1)+COEF(1,2)*(LM(J,N2)-LP(J,N2))+COEF(1,3)*
     X       (LM(J-1,N2)-LP(J-1,N2))+COEF(1,4)*DLOG(Y(J,N2))
     X       +COEF(1,5)*TT(J))
	 END IF
C
	 IF (IPRULE.EQ.10) THEN
	    U(1,J)=RS(J,N1)-LP(J+4,N4)+LP(J,N2)-RS(J,1)+LP(J+4,1)
     X       -LP(J,1)-PARG(0,1)*(LP(J,N2)-LP(J,N1))
     X       -PARG(0,2)*DLOG(Y(J,N2)/Y(J,N1))
	 END IF
C
	  U(2,J)=LM1(J,N1)                                                  
     X     -(RS1(J,N2)-COEF(2,1)+COEF(2,2)*LP1(J,N2)-COEF(2,3)*              
     X     (LM1(J-1,N2)-LP1(J-1,N2))-COEF(2,4)*DLOG(Y1(J,N2)))/COEF(2,2)    
	  U(3,J)=LM2(J,N1)                                                   
     X     -(RS2(J,N2)-COEF(3,1)+COEF(3,2)*LP2(J,N2)-COEF(3,3)*              
     X     (LM2(J-1,N2)-LP2(J-1,N2))-COEF(3,4)*DLOG(Y2(J,N2)))/COEF(3,2)    
	  U(4,J)=LM3(J,N1)                                    
     X     -(RS3(J,N2)-COEF(4,1)+COEF(4,2)*LP3(J,N2)-COEF(4,3)*              
     X     (LM3(J-1,N2)-LP3(J-1,N2))-COEF(4,4)*DLOG(Y3(J,N2)))/COEF(4,2)    
	  U(5,J)=LM4(J,N1)                                                   
     X     -(RS4(J,N2)-COEF(5,1)+COEF(5,2)*LP4(J,N2)-COEF(5,3)*             
     X     (LM4(J-1,N2)-LP4(J-1,N2))-COEF(5,4)*DLOG(Y4(J,N2)))/COEF(5,2)   
	  U(6,J)=LM5(J,N1)
     X     -(RS5(J,N2)-COEF(6,1)+COEF(6,2)*LP5(J,N2)-COEF(6,3)*
     X     (LM5(J-1,N2)-LP5(J-1,N2))-COEF(6,4)*DLOG(Y5(J,N2)))/COEF(6,2)
	  U(7,J)=LM6(J,N1)                                                   
     X     -(RS6(J,N2)-COEF(7,1)+COEF(7,2)*LP6(J,N2)-COEF(7,3)*            
     X     (LM6(J-1,N2)-LP6(J-1,N2))-COEF(7,4)*DLOG(Y6(J,N2))-COEF(7,5)    
     X     *TT(J) )/COEF(7,2)
C
	  U(8,J)=RS1(J,N1)-RS(J,N2)
	  U(9,J)=RS2(J,N1)-RS(J,N2)
	  U(10,J)=RS3(J,N1)-RS(J,N2)
	  U(11,J)=RS4(J,N1)-RS(J,N2)
	  U(12,J)=RS5(J,N1)-RS(J,N2)
	  U(13,J)=RS6(J,N1)-RS(J,N2)
      END IF
c
C JAPAN LEADER EQUATIONS
C
      IF ((IPRULE.EQ.5).OR.(IPRULE.EQ.15)) THEN
C
      IF (IPRULE.EQ.5) THEN 
	 U(6,J)=RS5(J,N1)
     X     -(COEF(6,1)+COEF(6,2)*(LM5(J,N2)-LP5(J,N2))+COEF(6,3)*
     X     (LM5(J-1,N2)-LP5(J-1,N2))+COEF(6,4)*DLOG(Y5(J,N2)))
      END IF
C
      IF (IPRULE.EQ.15) THEN
	 U(6,J)=RS5(J,N1)-LP5(J+4,N4)+LP5(J,N2)-RS5(J,1)+LP5(J+4,1)
     X       -LP5(J,1)-PARG(5,1)*(LP5(J,N2)-LP5(J,N1))
     X       -PARG(5,2)*DLOG(Y5(J,N2)/Y5(J,N1))        
      END IF
C 
      U(1,J)=LM(J,N1)                                             
     X    -(RS(J,N2)-COEF(1,1)+COEF(1,2)*LP(J,N2)-COEF(1,3)*                  
     X    (LM(J-1,N2)-LP(J-1,N2))-COEF(1,4)*DLOG(Y(J,N2)))/COEF(1,2)
      U(2,J)=LM1(J,N1)                                                         
     X    -(RS1(J,N2)-COEF(2,1)+COEF(2,2)*LP1(J,N2)-COEF(2,3)*                 
     X     (LM1(J-1,N2)-LP1(J-1,N2))-COEF(2,4)*DLOG(Y1(J,N2)))/COEF(2,2)       
      U(3,J)=LM2(J,N1)                                                         
     X    -(RS2(J,N2)-COEF(3,1)+COEF(3,2)*LP2(J,N2)-COEF(3,3)*                 
     X     (LM2(J-1,N2)-LP2(J-1,N2))-COEF(3,4)*DLOG(Y2(J,N2)))/COEF(3,2)       
      U(4,J)=LM3(J,N1)                                                         
     X    -(RS3(J,N2)-COEF(4,1)+COEF(4,2)*LP3(J,N2)-COEF(4,3)*                 
     X     (LM3(J-1,N2)-LP3(J-1,N2))-COEF(4,4)*DLOG(Y3(J,N2)))/COEF(4,2)       
      U(5,J)=LM4(J,N1)                                                         
     X    -(RS4(J,N2)-COEF(5,1)+COEF(5,2)*LP4(J,N2)-COEF(5,3)*                 
     X     (LM4(J-1,N2)-LP4(J-1,N2))-COEF(5,4)*DLOG(Y4(J,N2)))/COEF(5,2) 
      U(7,J)=LM6(J,N1)                                                         
     X    -(RS6(J,N2)-COEF(7,1)+COEF(7,2)*LP6(J,N2)-COEF(7,3)*                 
     X     (LM6(J-1,N2)-LP6(J-1,N2))-COEF(7,4)*DLOG(Y6(J,N2))-COEF(7,5)     
     X      *TT(J) )/COEF(7,2)
C
      U(8,J)=RS(J,N1)-RS5(J,N2)
      U(9,J)=RS1(J,N1)-RS5(J,N2)
      U(10,J)=RS2(J,N1)-RS5(J,N2)
      U(11,J)=RS3(J,N1)-RS5(J,N2)
      U(12,J)=RS4(J,N1)-RS5(J,N2)
      U(13,J)=RS6(J,N1)-RS5(J,N2)
      END IF
C
C IPRULE=20-29
C    20-21: EMS WITH GERMANY SETTING INTEREST RATE UNILATERALLY
C
      IF((IPRULE.GE.20).AND.(IPRULE.LT.30)) THEN
C
C IPRULE=20: EMS WITH GERMANY SETTING INTEREST RATE ACCORDING TO
C INVERTED MONEY DEMAND EQUATION (AS DO NON-EMS COUNTRIES)
C
	 IF (IPRULE.EQ.20) THEN
	U(1,J)=RS(J,3)-(
     X   COEF(1,1)+COEF(1,2)*(LM(J,2)-LP(J,2))+COEF(1,3)*
     X   (LM(J-1,2)-LP(J-1,2))+COEF(1,4)*DLOG(Y(J,2))+
     X   COEF(1,5)*TT(J))
	U(2,J)=RS1(J,3)-(
     X   COEF(2,1)+COEF(2,2)*(LM1(J,2)-LP1(J,2))+COEF(2,3)*
     X   (LM1(J-1,2)-LP1(J-1,2))+COEF(2,4)*DLOG(Y1(J,2)))
	U(4,J)=RS3(J,3)-(
     X   COEF(4,1)+COEF(4,2)*(LM3(J,2)-LP3(J,2))+COEF(4,3)*
     X   (LM3(J-1,2)-LP3(J-1,2))+COEF(4,4)*DLOG(Y3(J,2)))
	U(6,J)=RS5(J,3)-(
     X   COEF(6,1)+COEF(6,2)*(LM5(J,2)-LP5(J,2))+COEF(6,3)*
     X   (LM5(J-1,2)-LP5(J-1,2))+COEF(6,4)*DLOG(Y5(J,2)))
	   END IF
C
C IPRULE=21: EMS WITH GERMANY SETTING INTEREST RATE ACCORDING TO
C GERMAN INTEREST RATE REACTION FUNCTION (AS DO NON-EMS COUNTRIES)
C
      IF((IPRULE.EQ.21).OR.(IPRULE.EQ.22)) THEN
	U(1,J)=0.0D0
	U(2,J)=0.0D0
	U(4,J)=0.0D0
	U(6,J)=0.0D0
      END IF
C
C  EMS INTEREST RATE EQUIVALENCE
C
	U(3,J)=RS2(J,1)-RS3(J,1)
	U(5,J)=RS4(J,1)-RS3(J,1)
	U(7,J)=RS6(J,1)-RS3(J,1)
C
C CANADA, GERMAN, JAPAN EXCHANGE RATES FLOAT VS. U.S. DOLLAR
C FRANCE, ITALY, AND U.K. EXCHANGE RATES TIED TO BASELINE DEVIATIONS
C FROM GERMAN EXCHANGE RATE (I.E., FIXED TO BASELINE RATIOS)
C
      U(8,J)=LE1(J,3)-(
     X LE1(J+1,4)+COEF(8,1)*(RS1(J,3)-RS(J,3)))
      U(10,J)=LE3(J,3)-(
     X  LE3(J+1,4)+COEF(10,1)*(RS3(J,3)-RS(J,3)))
      U(12,J)=LE5(J,3)-(
     X LE5(J+1,4)+COEF(12,1)*(RS5(J,3)-RS(J,3)))
      U(9,J)=0.0D0
      U(11,J)=0.0D0
      U(13,J)=0.0D0
C
      END IF
C
      END IF
C
C -----------------------------------------------------------------------
C  CONSTRUCT LONGTERM INTEREST RATE RESIDUALS
C -----------------------------------------------------------------------
C
      B=COEF(14,2)                                                          
      U(14,J)=RL(J,N1)                                                      
     X    -( COEF(14,1)+(1-B)*(RS(J,N2)+B*RS(J+1,N4)+B**2*RS(J+2,N4)        
     X +B**3*RS(J+3,N4)+B**4*RS(J+4,N4)+B**5*RS(J+5,N4)                     
     X +B**6*RS(J+6,N4)+B**7*RS(J+7,N4)+B**8*RS(J+8,N4))/(1-B**9) )         
      B=COEF(15,2)                                                          
      U(15,J)=RL1(J,N1)                                                     
     X    -( COEF(15,1)+(1-B)*(RS1(J,N2)+B*RS1(J+1,N4)+B**2*RS1(J+2,N4)     
     X +B**3*RS1(J+3,N4)+B**4*RS1(J+4,N4)+B**5*RS1(J+5,N4)                  
     X +B**6*RS1(J+6,N4)+B**7*RS1(J+7,N4)+B**8*RS1(J+8,N4))/(1-B**9) )      
      B=COEF(16,2)                                                          
      U(16,J)=RL2(J,N1)                                                     
     X    -( COEF(16,1)+(1-B)*(RS2(J,N2)+B*RS2(J+1,N4)+B**2*RS2(J+2,N4)     
     X +B**3*RS2(J+3,N4)+B**4*RS2(J+4,N4)+B**5*RS2(J+5,N4)                  
     X +B**6*RS2(J+6,N4)+B**7*RS2(J+7,N4)+B**8*RS2(J+8,N4))/(1-B**9) )      
      B=COEF(17,2)                                                         
      U(17,J)=RL3(J,N1)                                                    
     X    -( COEF(17,1)+(1-B)*(RS3(J,N2)+B*RS3(J+1,N4)+B**2*RS3(J+2,N4)    
     X +B**3*RS3(J+3,N4)+B**4*RS3(J+4,N4)+B**5*RS3(J+5,N4)                 
     X +B**6*RS3(J+6,N4)+B**7*RS3(J+7,N4)+B**8*RS3(J+8,N4))/(1-B**9) )     
      B=COEF(18,2)                                                           
      U(18,J)=RL4(J,N1)                                                       
     X    -( COEF(18,1)+(1-B)*(RS4(J,N2)+B*RS4(J+1,N4)+B**2*RS4(J+2,N4)        
     X +B**3*RS4(J+3,N4)+B**4*RS4(J+4,N4)+B**5*RS4(J+5,N4)                     
     X +B**6*RS4(J+6,N4)+B**7*RS4(J+7,N4)+B**8*RS4(J+8,N4))/(1-B**9) )         
      B=COEF(19,2)                                                             
      U(19,J)=RL5(J,N1)                                                        
     X    -( COEF(19,1)+(1-B)*(RS5(J,N2)+B*RS5(J+1,N4)+B**2*RS5(J+2,N4)        
     X +B**3*RS5(J+3,N4)+B**4*RS5(J+4,N4)+B**5*RS5(J+5,N4)                     
     X +B**6*RS5(J+6,N4)+B**7*RS5(J+7,N4)+B**8*RS5(J+8,N4))/(1-B**9) )         
      B=COEF(20,2)                                                             
      U(20,J)=RL6(J,N1)                                                        
     X    -( COEF(20,1)+(1-B)*(RS6(J,N2)+B*RS6(J+1,N4)+B**2*RS6(J+2,N4)        
     X +B**3*RS6(J+3,N4)+B**4*RS6(J+4,N4)+B**5*RS6(J+5,N4)                     
     X +B**6*RS6(J+6,N4)+B**7*RS6(J+7,N4)+B**8*RS6(J+8,N4))/(1-B**9) )
C
      RRL= DEXP(COEF(113,2)*T(J))*(RL(J,N3)-LP(J+4,N4)+LP(J,N3))            
      RRL1=DEXP(COEF(114,2)*T(J))*(RL1(J,N3)-LP1(J+4,N4)+LP1(J,N3))         
      RRL2=DEXP(COEF(115,2)*T(J))*(RL2(J,N3)-LP2(J+4,N4)+LP2(J,N3))          
      RRL3=DEXP(COEF(116,2)*T(J))*(RL3(J,N3)-LP3(J+4,N4)+LP3(J,N3))         
      RRL4=DEXP(COEF(117,2)*T(J))*(RL4(J,N3)-LP4(J+4,N4)+LP4(J,N3))         
      RRL5=DEXP(COEF(118,2)*T(J))*(RL5(J,N3)-LP5(J+4,N4)+LP5(J,N3))         
      RRL6=DEXP(COEF(119,2)*T(J))*(RL6(J,N3)-LP6(J+4,N4)+LP6(J,N3))
C
C  CREATE PERMANENT INCOME VARIABLE
C
      TERM = 0.1D0/(1.0D0 - (0.9D0**9))
      YP= TERM*(Y(J,N2)+ .9*Y(J+1,N4)+.9**2*Y(J+2,N4)+.9**3*Y(J+3,N4)
     X            +.9**4*Y(J+4,N4)+.9**5*Y(J+5,N4)+.9**6*Y(J+6,N4)          
     X            +.9**7*Y(J+7,N4)+.9**8*Y(J+8,N4))
      YP1=TERM*(Y1(J,N2)+.9*Y1(J+1,N4)+.9**2*Y1(J+2,N4)+.9**3*Y1(J+3,N4)
     X            +.9**4*Y1(J+4,N4)+.9**5*Y1(J+5,N4)+.9**6*Y1(J+6,N4)     
     X            +.9**7*Y1(J+7,N4)+.9**8*Y1(J+8,N4))
      YP2=TERM*(Y2(J,N2)+.9*Y2(J+1,N4)+.9**2*Y2(J+2,N4)+.9**3*Y2(J+3,N4)
     X            +.9**4*Y2(J+4,N4)+.9**5*Y2(J+5,N4)+.9**6*Y2(J+6,N4)          
     X            +.9**7*Y2(J+7,N4)+.9**8*Y2(J+8,N4))
      YP3=TERM*(Y3(J,N2)+.9*Y3(J+1,N4)+.9**2*Y3(J+2,N4)+.9**3*Y3(J+3,N4)
     X            +.9**4*Y3(J+4,N4)+.9**5*Y3(J+5,N4)+.9**6*Y3(J+6,N4)          
     X            +.9**7*Y3(J+7,N4)+.9**8*Y3(J+8,N4))
      YP4=TERM*(Y4(J,N2)+.9*Y4(J+1,N4)+.9**2*Y4(J+2,N4)+.9**3*Y4(J+3,N4)
     X            +.9**4*Y4(J+4,N4)+.9**5*Y4(J+5,N4)+.9**6*Y4(J+6,N4)          
     X            +.9**7*Y4(J+7,N4)+.9**8*Y4(J+8,N4))
      YP5=TERM*(Y5(J,N2)+.9*Y5(J+1,N4)+.9**2*Y5(J+2,N4)+.9**3*Y5(J+3,N4)
     X            +.9**4*Y5(J+4,N4)+.9**5*Y5(J+5,N4)+.9**6*Y5(J+6,N4)          
     X            +.9**7*Y5(J+7,N4)+.9**8*Y5(J+8,N4))
      YP6=TERM*(Y6(J,N2)+.9*Y6(J+1,N4)+.9**2*Y6(J+2,N4)+.9**3*Y6(J+3,N4)
     X            +.9**4*Y6(J+4,N4)+.9**5*Y6(J+5,N4)+.9**6*Y6(J+6,N4)          
     X            +.9**7*Y6(J+7,N4)+.9**8*Y6(J+8,N4))
C
C CONSUMPTION RESIDUALS
C
      U(21,J)=CD(J,N1)-( COEF(21,1)+COEF(21,2)*YP+COEF(21,3)*CD(J-1,N2)        
     X        +COEF(21,4)*RRL )                                                
      U(22,J)=CN(J,N1)-( COEF(22,1)+COEF(22,2)*YP+COEF(22,3)*CN(J-1,N2)        
     X        +COEF(22,4)*RRL )                                                
      U(23,J)=CS(J,N1)-( COEF(23,1)+COEF(23,2)*YP+COEF(23,3)*CS(J-1,N2))       
      U(24,J)=CD1(J,N1)                                                        
     X       -( COEF(24,1)+COEF(24,2)*YP1+COEF(24,3)*CD1(J-1,N2)               
     X         +COEF(24,4)*RRL1 )                                              
      U(25,J)=CN1(J,N1)                                                        
     X       -( COEF(25,1)+COEF(25,2)*YP1+COEF(25,3)*CN1(J-1,N2)               
     X         +COEF(25,4)*RRL1 )                                              
      U(26,J)=CS1(J,N1)                                                        
     X       -( COEF(26,1)+COEF(26,2)*YP1+COEF(26,3)*CS1(J-1,N2) )             
      U(27,J)=CD2(J,N1)                                                        
     X       -( COEF(27,1)+COEF(27,2)*YP2+COEF(27,3)*CD2(J-1,N2)               
     X         +COEF(27,4)*RRL2 )                                              
      U(28,J)=CN2(J,N1)                                                        
     X       -( COEF(28,1)+COEF(28,2)*YP2+COEF(28,3)*CN2(J-1,N2) )             
      U(29,J)=CS2(J,N1)                                                        
     X       -( COEF(29,1)+COEF(29,2)*YP2+COEF(29,3)*CS2(J-1,N2) )             
      U(30,J)=C3(J,N1)-( COEF(30,1)+COEF(30,2)*YP3+COEF(30,3)*C3(J-1,N2)       
     X         +COEF(30,4)*RRL3 )                                              
      U(31,J)=C4(J,N1)-( COEF(31,1)+COEF(31,2)*YP4+COEF(31,3)*C4(J-1,N2)       
     X        +COEF(31,4)*RRL4 )                                               
      U(32,J)=CD5(J,N1)                                                        
     X       -( COEF(32,1)+COEF(32,2)*YP5+COEF(32,3)*CD5(J-1,N2)               
     X         +COEF(32,4)*RRL5 )                                              
      U(33,J)=CN5(J,N1)                                                        
     X       -( COEF(33,1)+COEF(33,2)*YP5+COEF(33,3)*CN5(J-1,N2) )             
      U(34,J)=CS5(J,N1)                                                        
     X       -( COEF(34,1)+COEF(34,2)*YP5+COEF(34,3)*CS5(J-1,N2) )             
      U(35,J)=CD6(J,N1)                                                        
     X       -( COEF(35,1)+COEF(35,2)*YP6+COEF(35,3)*CD6(J-1,N2) )             
      U(36,J)=CN6(J,N1)                                                        
     X       -( COEF(36,1)+COEF(36,2)*YP6+COEF(36,3)*CN6(J-1,N2)               
     X         +COEF(36,4)*RRL6 )                                              
      U(37,J)=CS6(J,N1)                                                        
     X       -( COEF(37,1)+COEF(37,2)*YP6+COEF(37,3)*CS6(J-1,N2) )
C
C  INVESTMENT/INVENTORY RESIDUALS
C
      U(38,J)=INE(J,N1)                                                         
     X    -( COEF(38,1)+COEF(38,2)*INE(J-1,N2)+COEF(38,3)*YP                    
     X          +COEF(38,4)*RRL )                                               
      U(39,J)=INS(J,N1)                                                         
     X    -( COEF(39,1)+COEF(39,2)*INS(J-1,N2)+COEF(39,3)*YP                    
     X          +COEF(39,4)*RRL )                                               
      U(40,J)=IR(J,N1)                                                          
     X    -(  COEF(40,1)+COEF(40,2)*IR(J-1,N2)+COEF(40,3)*YP                    
     X          +COEF(40,4)*RRL )                                               
      U(41,J)=II(J,N1)                                                          
     X    -(  COEF(41,1)+COEF(41,2)*II(J-1,N2)+COEF(41,3)*Y(J,N2)               
     X          +COEF(41,4)*Y(J-1,N2)+COEF(41,5)*RRL )                          
      U(42,J)=IF1(J,N1)                                                         
     X    -( COEF(42,1)+COEF(42,2)*IF1(J-1,N2)+COEF(42,3)*YP1                   
     X          +COEF(42,4)*RRL1 )                                              
      U(43,J)=II1(J,N1)                                                         
     X    -( COEF(43,1)+COEF(43,2)*II1(J-1,N2)+COEF(43,3)*Y1(J,N2)              
     X          +COEF(43,4)*Y1(J-1,N2)+COEF(43,5)*RRL1 )                        
      U(44,J)=IN2(J,N1)                                                         
     X    -( COEF(44,1)+COEF(44,2)*IN2(J-1,N2)+COEF(44,3)*YP2 )                 
      U(45,J)=IR2(J,N1)                                                         
     X    -( COEF(45,1)+COEF(45,2)*IR2(J-1,N2)+COEF(45,3)*RRL2 )                
      U(46,J)=II2(J,N1)                                                         
     X    -( COEF(46,1)+COEF(46,2)*II2(J-1,N2)+COEF(46,3)*Y2(J,N2)              
     X          +COEF(46,4)*Y2(J-1,N2)+COEF(46,5)*RRL2 )                        
      U(47,J)=IF3(J,N1)                                                         
     X    -( COEF(47,1)+COEF(47,2)*IF3(J-1,N2)+COEF(47,3)*YP3                   
     X          +COEF(47,4)*RRL3 )                                              
      U(48,J)=II3(J,N1)                                                         
     X    -( COEF(48,1)+COEF(48,2)*II3(J-1,N2)+COEF(48,3)*Y3(J,N2)              
     X          +COEF(48,4)*Y3(J-1,N2)+COEF(48,5)*RRL3 )                        
      U(49,J)=IF4(J,N1)                                                         
     X    -( COEF(49,1)+COEF(49,2)*IF4(J-1,N2)+COEF(49,3)*YP4                   
     X          +COEF(49,4)*RRL4 )                                              
      U(50,J)=II4(J,N1)                                                         
     X    -( COEF(50,1)+COEF(50,2)*II4(J-1,N2)+COEF(50,3)*Y4(J,N2)              
     X          +COEF(50,4)*Y4(J-1,N2)+COEF(50,5)*RRL4 )                        
      U(51,J)=IN5(J,N1)                                                         
     X    -( COEF(51,1)+COEF(51,2)*IN5(J-1,N2)+COEF(51,3)*YP5                   
     X          +COEF(51,4)*RRL5 )                                              
      U(52,J)=IR5(J,N1)                                                         
     X    -( COEF(52,1)+COEF(52,2)*IR5(J-1,N2)+COEF(52,3)*RRL5 )                
      U(53,J)=II5(J,N1)                                                         
     X    -( COEF(53,1)+COEF(53,2)*II5(J-1,N2)+COEF(53,3)*Y5(J,N2)              
     X          +COEF(53,4)*Y5(J-1,N2)+COEF(53,5)*RRL5 )                        
      U(54,J)=IN6(J,N1)                                                         
     X    -( COEF(54,1)+COEF(54,2)*IN6(J-1,N2)+COEF(54,3)*YP6                   
     X          +COEF(54,4)*RRL6 )                                              
      U(55,J)=IR6(J,N1)                                                         
     X    -( COEF(55,1)+COEF(55,2)*IR6(J-1,N2)+COEF(55,3)*RRL6 )                
      U(56,J)=II6(J,N1)                                                         
     X    -( COEF(56,1)+COEF(56,2)*II6(J-1,N2)+COEF(56,3)*Y6(J,N2)              
     X          +COEF(56,4)*Y6(J-1,N2)+COEF(56,5)*RRL6 )
C
C  EXPORT RESIDUALS
C
      U(57,J)=LEX(J,N1)-(COEF(57,1)+COEF(57,2)*LEX(J-1,N2)+COEF(57,3)*          
     X   (LPE(J,N2)-LPI(J,N2))+COEF(57,4)*(0.091*DLOG(Y1(J,N2))                 
     X   +0.175*DLOG(Y2(J,N2))+0.265*DLOG(Y3(J,N2))+0.123*DLOG(Y4(J,N2))        
     X   +0.189*DLOG(Y5(J,N2))+0.157*DLOG(Y6(J,N2))) )                          
      U(58,J)=LEX1(J,N1)-(COEF(58,1)+COEF(58,2)*LEX1(J-1,N2)+COEF(58,3)*        
     X   (LPE1(J,N2)-LPI1(J,N2))+COEF(58,4)*(0.268*DLOG(Y(J,N2))                
     X   +0.141*DLOG(Y2(J,N2))+0.213*DLOG(Y3(J,N2))+0.099*DLOG(Y4(J,N2))        
     X   +0.152*DLOG(Y5(J,N2))+0.127*DLOG(Y6(J,N2))) )                          
      U(59,J)=LEX2(J,N1)-(COEF(59,1)+COEF(59,2)*LEX2(J-1,N2)+COEF(59,3)*        
     X   (LPE2(J,N2)-LPI2(J,N2))+COEF(59,4)*(0.287*DLOG(Y(J,N2))                
     X   +0.079*DLOG(Y1(J,N2))+0.229*DLOG(Y3(J,N2))+0.106*DLOG(Y4(J,N2))        
     X   +0.163*DLOG(Y5(J,N2))+0.136*DLOG(Y6(J,N2))) )                          
      U(60,J)=LEX3(J,N1)-(COEF(60,1)+COEF(60,2)*LEX3(J-1,N2)+COEF(60,3)*        
     X   (LPE3(J,N2)-LPI3(J,N2))+COEF(60,4)*(0.311*DLOG(Y(J,N2))                
     X   +0.085*DLOG(Y1(J,N2))+0.164*DLOG(Y2(J,N2))+0.116*DLOG(Y4(J,N2))        
     X   +0.177*DLOG(Y5(J,N2))+0.147*DLOG(Y6(J,N2))) )                          
      U(61,J)=LEX4(J,N1)-(COEF(61,1)+COEF(61,2)*LEX4(J-1,N2)+COEF(61,3)*        
     X   (LPE4(J,N2)-LPI4(J,N2))+COEF(61,4)*(0.275*DLOG(Y(J,N2))                
     X   +0.075*DLOG(Y1(J,N2))+0.145*DLOG(Y2(J,N2))+0.219*DLOG(Y3(J,N2))        
     X   +0.156*DLOG(Y5(J,N2))+0.130*DLOG(Y6(J,N2))) )                          
      U(62,J)=LEX5(J,N1)-(COEF(62,1)+COEF(62,2)*LEX5(J-1,N2)+COEF(62,3)*        
     X   (LPE5(J,N2)-LPI5(J,N2))+COEF(62,4)*(0.291*DLOG(Y(J,N2))                
     X   +0.079*DLOG(Y1(J,N2))+0.153*DLOG(Y2(J,N2))+0.232*DLOG(Y3(J,N2))        
     X   +0.108*DLOG(Y4(J,N2))+0.137*DLOG(Y6(J,N2))) )                          
      U(63,J)=LEX6(J,N1)-(COEF(63,1)+COEF(63,2)*LEX6(J-1,N2)+COEF(63,3)*        
     X   (LPE6(J,N2)-LPI6(J,N2))+COEF(63,4)*(0.283*DLOG(Y(J,N2))                
     X   +0.077*DLOG(Y1(J,N2))+0.149*DLOG(Y2(J,N2))+0.225*DLOG(Y3(J,N2))        
     X   +0.105*DLOG(Y4(J,N2))+0.161*DLOG(Y5(J,N2))) )
C
C  IMPORT RESIDUALS
C
      U(64,J)=LIM(J,N1)- (COEF(64,1)+COEF(64,2)*LIM(J-1,N2)+COEF(64,3)*         
     X          (LPI(J,N2) -LP(J,N2)) +COEF(64,4)*DLOG(Y(J,N2)) )               
      U(65,J)=LIM1(J,N1)-(COEF(65,1)+COEF(65,2)*LIM1(J-1,N2)+COEF(65,3)*        
     X          (LPI1(J,N2)-LP1(J,N2))+COEF(65,4)*DLOG(Y1(J,N2)) )              
      U(66,J)=LIM2(J,N1)-(COEF(66,1)+COEF(66,2)*LIM2(J-1,N2)+COEF(66,3)*        
     X          (LPI2(J,N2)-LP2(J,N2))+COEF(66,4)*DLOG(Y2(J,N2)) )              
      U(67,J)=LIM3(J,N1)-(COEF(67,1)+COEF(67,2)*LIM3(J-1,N2)+COEF(67,3)*        
     X          (LPI3(J,N2)-LP3(J,N2))+COEF(67,4)*DLOG(Y3(J,N2)) )              
      U(68,J)=LIM4(J,N1)-(COEF(68,1)+COEF(68,2)*LIM4(J-1,N2)+COEF(68,3)*        
     X          (LPI4(J,N2)-LP4(J,N2))+COEF(68,4)*DLOG(Y4(J,N2)) )              
      U(69,J)=LIM5(J,N1)-(COEF(69,1)+COEF(69,2)*LIM5(J-1,N2)+COEF(69,3)*        
     X          (LPI5(J,N2)-LP5(J,N2))+COEF(69,4)*DLOG(Y5(J,N2)) )              
      U(70,J)=LIM6(J,N1)-(COEF(70,1)+COEF(70,2)*LIM6(J-1,N2)+COEF(70,3)*        
     X          (LPI6(J,N2)-LP6(J,N2))+COEF(70,4)*DLOG(Y6(J,N2)) )
C
C  INCOME RESIDUALS
C
      U(71,J)=Y(J,N1)-(CD(J,N2)+CN(J,N2)+CS(J,N2)+INE(J,N2)+INS(J,N2)           
     X +IR(J,N2)+II(J,N2)+G(J,N2)+DEXP(LEX(J,N2))-DEXP(LIM(J,N2)))              
      U(72,J)=Y1(J,N1)-(CD1(J,N2)+CN1(J,N2)+CS1(J,N2)+IF1(J,N2)                 
     X  +II1(J,N2)+G1(J,N2)+DEXP(LEX1(J,N2))-DEXP(LIM1(J,N2)))                  
      U(73,J)=Y2(J,N1)-(CD2(J,N2)+CN2(J,N2)+CS2(J,N2)+IN2(J,N2)                 
     X  +IR2(J,N2)+II2(J,N2)+G2(J,N2)+DEXP(LEX2(J,N2))-DEXP(LIM2(J,N2)))        
      U(74,J)=Y3(J,N1)-(C3(J,N2)+IF3(J,N2)+II3(J,N2)+G3(J,N2)                   
     X  +DEXP(LEX3(J,N2))-DEXP(LIM3(J,N2)))                                     
      U(75,J)=Y4(J,N1)-(C4(J,N2)+IF4(J,N2)+II4(J,N2)+G4(J,N2)                   
     X  +DEXP(LEX4(J,N2))-DEXP(LIM4(J,N2)))                                     
      U(76,J)=Y5(J,N1)-(CD5(J,N2)+CN5(J,N2)+CS5(J,N2)+IN5(J,N2)                 
     X  +IR5(J,N2)+II5(J,N2)+G5(J,N2)+DEXP(LEX5(J,N2))-DEXP(LIM5(J,N2)))        
      U(77,J)=Y6(J,N1)-(CD6(J,N2)+CN6(J,N2)+CS6(J,N2)+IN6(J,N2)                 
     X  +IR6(J,N2)+II6(J,N2)+G6(J,N2)+DEXP(LEX6(J,N2))-DEXP(LIM6(J,N2)))
C
C  CONSTRUCT YGAP MEASURE
C
      DO 185 LL=0,3                                                             
	DO 185 NV=N3,N4                                                         
	YGAP(J+LL,NV)=DLOG(Y(J+LL,NV))-COEF(113,1)-COEF(113,2)*T(J+LL)          
	YGAP1(J+LL,NV)=DLOG(Y1(J+LL,NV))-COEF(114,1)-COEF(114,2)*T(J+LL)        
	YGAP2(J+LL,NV)=DLOG(Y2(J+LL,NV))-COEF(115,1)-COEF(115,2)*T(J+LL)        
	YGAP3(J+LL,NV)=DLOG(Y3(J+LL,NV))-COEF(116,1)-COEF(116,2)*T(J+LL)        
	YGAP4(J+LL,NV)=DLOG(Y4(J+LL,NV))-COEF(117,1)-COEF(117,2)*T(J+LL)        
	YGAP5(J+LL,NV)=DLOG(Y5(J+LL,NV))-COEF(118,1)-COEF(118,2)*T(J+LL)        
	YGAP6(J+LL,NV)=DLOG(Y6(J+LL,NV))-COEF(119,1)-COEF(119,2)*T(J+LL)        
 185  CONTINUE
C
C  CONTRACT WAGE RESIDUALS
C
      U(78,J)=LX(J,N1)                                                          
     X      -(PHI(0,0)*(LW(J,N3)+GAMMA(0)*YGAP(J,N3))     +DELTA(0,J)           
     X       +PHI(0,1)*(LW(J+1,N4)+GAMMA(0)*YGAP(J+1,N4))                       
     X       +PHI(0,2)*(LW(J+2,N4)+GAMMA(0)*YGAP(J+2,N4))                       
     X       +PHI(0,3)*(LW(J+3,N4)+GAMMA(0)*YGAP(J+3,N4)) )                     
      U(79,J)=LX1(J,N1)                                                         
     X      -(PHI(1,0)*(LW1(J,N3)+GAMMA(1)*YGAP1(J,N3))   +DELTA(1,J)           
     X       +PHI(1,1)*(LW1(J+1,N4)+GAMMA(1)*YGAP1(J+1,N4))                     
     X       +PHI(1,2)*(LW1(J+2,N4)+GAMMA(1)*YGAP1(J+2,N4))                     
     X       +PHI(1,3)*(LW1(J+3,N4)+GAMMA(1)*YGAP1(J+3,N4)) )                   
      U(80,J)=LX2(J,N1)                                                         
     X      -(PHI(2,0)*(LW2(J,N3)+GAMMA(2)*YGAP2(J,N3))   +DELTA(2,J)           
     X       +PHI(2,1)*(LW2(J+1,N4)+GAMMA(2)*YGAP2(J+1,N4))                     
     X       +PHI(2,2)*(LW2(J+2,N4)+GAMMA(2)*YGAP2(J+2,N4))                     
     X       +PHI(2,3)*(LW2(J+3,N4)+GAMMA(2)*YGAP2(J+3,N4)) )                   
      U(81,J)=LX3(J,N1)                                                         
     X      -(PHI(3,0)*(LW3(J,N3)+GAMMA(3)*YGAP3(J,N3))  +DELTA(3,J)            
     X       +PHI(3,1)*(LW3(J+1,N4)+GAMMA(3)*YGAP3(J+1,N4))                     
     X       +PHI(3,2)*(LW3(J+2,N4)+GAMMA(3)*YGAP3(J+2,N4))                     
     X       +PHI(3,3)*(LW3(J+3,N4)+GAMMA(3)*YGAP3(J+3,N4)) )                   
      U(82,J)=LX4(J,N1)                                                         
     X      -(PHI(4,0)*(LW4(J,N3)+GAMMA(4)*YGAP4(J,N3))  +DELTA(4,J)            
     X       +PHI(4,1)*(LW4(J+1,N4)+GAMMA(4)*YGAP4(J+1,N4))                     
     X       +PHI(4,2)*(LW4(J+2,N4)+GAMMA(4)*YGAP4(J+2,N4))                     
     X       +PHI(4,3)*(LW4(J+3,N4)+GAMMA(4)*YGAP4(J+3,N4)) )                   
      U(83,J)=LX5(J,N1)                                                         
     X      -(PHI5(J,0)*(LW5(J,N3)+GAMMA(5)*YGAP5(J,N3))  +DELTA(5,J)           
     X       +PHI5(J,1)*(LW5(J+1,N4)+GAMMA(5)*YGAP5(J+1,N4))                    
     X       +PHI5(J,2)*(LW5(J+2,N4)+GAMMA(5)*YGAP5(J+2,N4))                    
     X       +PHI5(J,3)*(LW5(J+3,N4)+GAMMA(5)*YGAP5(J+3,N4)) )                  
      U(84,J)=LX6(J,N1)                                                         
     X      -(PHI(6,0)*(LW6(J,N3)+GAMMA(6)*YGAP6(J,N3))  +DELTA(6,J)            
     X       +PHI(6,1)*(LW6(J+1,N4)+GAMMA(6)*YGAP6(J+1,N4))                     
     X       +PHI(6,2)*(LW6(J+2,N4)+GAMMA(6)*YGAP6(J+2,N4))                     
     X       +PHI(6,3)*(LW6(J+3,N4)+GAMMA(6)*YGAP6(J+3,N4)) )
C
C  WAGE RESIDUALS
C
      U(85,J)=LW(J,N1)                                                          
     X    -( PSI(0,0)*LX(J,N2)+PSI(0,1)*LX(J-1,N2)+PSI(0,2)*LX(J-2,N2)          
     X         +PSI(0,3)*LX(J-3,N2) )                                           
      U(86,J)=LW1(J,N1)                                                         
     X    -(PSI(1,0)*LX1(J,N2)+PSI(1,1)*LX1(J-1,N2)+PSI(1,2)*LX1(J-2,N2)        
     X         +PSI(1,3)*LX1(J-3,N2) )                                          
      U(87,J)=LW2(J,N1)                                                         
     X    -(PSI(2,0)*LX2(J,N2)+PSI(2,1)*LX2(J-1,N2)+PSI(2,2)*LX2(J-2,N2)        
     X         +PSI(2,3)*LX2(J-3,N2) )                                          
      U(88,J)=LW3(J,N1)                                                         
     X    -(PSI(3,0)*LX3(J,N2)+PSI(3,1)*LX3(J-1,N2)+PSI(3,2)*LX3(J-2,N2)        
     X         +PSI(3,3)*LX3(J-3,N2) )                                          
      U(89,J)=LW4(J,N1)                                                         
     X    -(PSI(4,0)*LX4(J,N2)+PSI(4,1)*LX4(J-1,N2)+PSI(4,2)*LX4(J-2,N2)        
     X         +PSI(4,3)*LX4(J-3,N2) )                                          
      U(90,J)=LW5(J,N1)                                                         
     X    -(PSI5(J,0)*LX5(J,N2)+PSI5(J,1)*LX5(J-1,N2)+PSI5(J,2)                 
     X         *LX5(J-2,N2)+PSI5(J,3)*LX5(J-3,N2) )                             
      U(91,J)=LW6(J,N1)                                                         
     X    -(PSI(6,0)*LX6(J,N2)+PSI(6,1)*LX6(J-1,N2)+PSI(6,2)*LX6(J-2,N2)        
     X         +PSI(6,3)*LX6(J-3,N2) )
C
C  CONSTRUCT FOREIGN PRICES
C
      FP=  0.091*(LP1(J,N2)+LE1(J,N2))+0.175*(LP2(J,N2)+LE2(J,N2))              
     X     +0.265*(LP3(J,N2)+LE3(J,N2))+0.123*(LP4(J,N2)+LE4(J,N2))             
     X     +0.189*(LP5(J,N2)+LE5(J,N2))+0.157*(LP6(J,N2)+LE6(J,N2))             
      FP1= 0.268*LP(J,N2)  -LE1(J,N2) +0.141*(LP2(J,N2)+LE2(J,N2))              
     X     +0.213*(LP3(J,N2)+LE3(J,N2))+0.099*(LP4(J,N2)+LE4(J,N2))             
     X     +0.152*(LP5(J,N2)+LE5(J,N2))+0.127*(LP6(J,N2)+LE6(J,N2))             
      FP2= 0.287*LP(J,N2)  -LE2(J,N2) +0.079*(LP1(J,N2)+LE1(J,N2))              
     X     +0.229*(LP3(J,N2)+LE3(J,N2))+0.106*(LP4(J,N2)+LE4(J,N2))             
     X     +0.163*(LP5(J,N2)+LE5(J,N2))+0.136*(LP6(J,N2)+LE6(J,N2))             
      FP3= 0.311*LP(J,N2)  -LE3(J,N2) +0.085*(LP1(J,N2)+LE1(J,N2))              
     X     +0.164*(LP2(J,N2)+LE2(J,N2))+0.116*(LP4(J,N2)+LE4(J,N2))             
     X     +0.177*(LP5(J,N2)+LE5(J,N2))+0.147*(LP6(J,N2)+LE6(J,N2))             
      FP4= 0.275*LP(J,N2)  -LE4(J,N2) +0.075*(LP1(J,N2)+LE1(J,N2))              
     X     +0.145*(LP2(J,N2)+LE2(J,N2))+0.219*(LP3(J,N2)+LE3(J,N2))             
     X     +0.156*(LP5(J,N2)+LE5(J,N2))+0.130*(LP6(J,N2)+LE6(J,N2))             
      FP5= 0.291*LP(J,N2)  -LE5(J,N2) +0.079*(LP1(J,N2)+LE1(J,N2))            
     X     +0.153*(LP2(J,N2)+LE2(J,N2))+0.232*(LP3(J,N2)+LE3(J,N2))            
     X     +0.108*(LP4(J,N2)+LE4(J,N2))+0.137*(LP6(J,N2)+LE6(J,N2))            
      FP6= 0.283*LP(J,N2)  -LE6(J,N2) +0.077*(LP1(J,N2)+LE1(J,N2))             
     X     +0.149*(LP2(J,N2)+LE2(J,N2))+0.225*(LP3(J,N2)+LE3(J,N2))            
     X     +0.105*(LP4(J,N2)+LE4(J,N2))+0.161*(LP5(J,N2)+LE5(J,N2))            
      FPL=                                                                     
     X  0.091*(LP1(J-1,N2)+LE1(J-1,N2))+0.175*(LP2(J-1,N2)+LE2(J-1,N2))        
     X +0.265*(LP3(J-1,N2)+LE3(J-1,N2))+0.123*(LP4(J-1,N2)+LE4(J-1,N2))        
     X +0.189*(LP5(J-1,N2)+LE5(J-1,N2))+0.157*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP1L=                                                                    
     X  0.268*LP(J-1,N2)  -LE1(J-1,N2) +0.141*(LP2(J-1,N2)+LE2(J-1,N2))        
     X +0.213*(LP3(J-1,N2)+LE3(J-1,N2))+0.099*(LP4(J-1,N2)+LE4(J-1,N2))        
     X +0.152*(LP5(J-1,N2)+LE5(J-1,N2))+0.127*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP1L2=                                                                   
     X  0.268*LP(J-2,N2)  -LE1(J-2,N2) +0.141*(LP2(J-2,N2)+LE2(J-2,N2))        
     X +0.213*(LP3(J-2,N2)+LE3(J-2,N2))+0.099*(LP4(J-2,N2)+LE4(J-2,N2))        
     X +0.152*(LP5(J-2,N2)+LE5(J-2,N2))+0.127*(LP6(J-2,N2)+LE6(J-2,N2))        
      FP2L=                                                                    
     X  0.287*LP(J-1,N2)  -LE2(J-1,N2) +0.079*(LP1(J-1,N2)+LE1(J-1,N2))        
     X +0.229*(LP3(J-1,N2)+LE3(J-1,N2))+0.106*(LP4(J-1,N2)+LE4(J-1,N2))        
     X +0.163*(LP5(J-1,N2)+LE5(J-1,N2))+0.136*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP3L=                                                                    
     X  0.311*LP(J-1,N2)  -LE3(J-1,N2) +0.085*(LP1(J-1,N2)+LE1(J-1,N2))        
     X +0.164*(LP2(J-1,N2)+LE2(J-1,N2))+0.116*(LP4(J-1,N2)+LE4(J-1,N2))        
     X +0.177*(LP5(J-1,N2)+LE5(J-1,N2))+0.147*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP4L=                                                                    
     X  0.275*LP(J-1,N2)  -LE4(J-1,N2) +0.075*(LP1(J-1,N2)+LE1(J-1,N2))        
     X +0.145*(LP2(J-1,N2)+LE2(J-1,N2))+0.219*(LP3(J-1,N2)+LE3(J-1,N2))        
     X +0.156*(LP5(J-1,N2)+LE5(J-1,N2))+0.130*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP5L=                                                                    
     X  0.291*LP(J-1,N2)  -LE5(J-1,N2) +0.079*(LP1(J-1,N2)+LE1(J-1,N2))        
     X +0.153*(LP2(J-1,N2)+LE2(J-1,N2))+0.232*(LP3(J-1,N2)+LE3(J-1,N2))        
     X +0.108*(LP4(J-1,N2)+LE4(J-1,N2))+0.137*(LP6(J-1,N2)+LE6(J-1,N2))        
      FP6L=                                                                    
     X  0.283*LP(J-1,N2)  -LE6(J-1,N2) +0.077*(LP1(J-1,N2)+LE1(J-1,N2))        
     X +0.149*(LP2(J-1,N2)+LE2(J-1,N2))+0.225*(LP3(J-1,N2)+LE3(J-1,N2))        
     X +0.105*(LP4(J-1,N2)+LE4(J-1,N2))+0.161*(LP5(J-1,N2)+LE5(J-1,N2))
C
C  PRICE RESIDUALS
C
      U(92,J)=LP(J,N1)                                                         
     X    -( COEF(92,1)+COEF(92,2)*LP(J-1,N2)+COEF(92,3)*LP(J-2,N2)            
     X        +COEF(92,4)*LW(J,N2)+COEF(92,5)*LW(J-1,N2)+COEF(92,6)            
     X        *LPI(J-1,N2)+COEF(92,7)*LPI(J-2,2)+COEF(92,8)*T(J) )             
      U(93,J)=LP1(J,N1)                                                        
     X    -( COEF(93,1)+COEF(93,2)*LP1(J-1,N2)+COEF(93,3)*LP1(J-2,N2)          
     X        +COEF(93,4)*LW1(J,N2)+COEF(93,5)*LW1(J-1,N2)+COEF(93,6)
     X        *FP1L+COEF(93,7)*FP1L2+COEF(93,8)*T(J) )                         
      U(94,J)=LP2(J,N1)                                                       
     X    -( COEF(94,1)+COEF(94,2)*LP2(J-1,N2)+COEF(94,3)*LP2(J-2,N2)          
     X        +COEF(94,4)*LW2(J,N2)+COEF(94,5)*LW2(J-1,N2)+COEF(94,6)          
     X        *LPI2(J-1,N2)+COEF(94,7)*LPI2(J-2,N2)+COEF(94,8)*T(J) )          
      U(95,J)=LP3(J,N1)                                                        
     X    -( COEF(95,1)+COEF(95,2)*LP3(J-1,N2)+COEF(95,3)*LW3(J,N2)            
     X        +COEF(95,4)*FP3L+COEF(95,5)*T(J) )                               
      U(96,J)=LP4(J,N1)                                                        
     X    -( COEF(96,1)+COEF(96,2)*LP4(J-1,N2)+COEF(96,3)*LP4(J-2,N2)          
     X        +COEF(96,4)*LW4(J,N2)+COEF(96,5)*LW4(J-1,N2)+COEF(96,6)          
     X        *LPI4(J-1,N2)+COEF(96,7)*LPI4(J-2,N2)+COEF(96,8)*T(J) )          
      U(97,J)=LP5(J,N1)                                                        
     X    -(COEF(97,1)+COEF(97,2)*LP5(J-1,N2)+COEF(97,3)*LP5(J-2,N2)           
     X        +COEF(97,4)*LW5(J,N2)+COEF(97,5)*LW5(J-1,N2)+COEF(97,6)          
     X        *LPI5(J-1,N2)+COEF(97,7)*LPI5(J-2,N2)+COEF(97,8)*T(J) )          
      U(98,J)=LP6(J,N1)                                                        
     X    -(COEF(98,1)+COEF(98,2)*LP6(J-1,N2)+COEF(98,3)*LP6(J-2,N2)           
     X        +COEF(98,4)*LW6(J,N2)+COEF(98,5)*LW6(J-1,N2)+COEF(98,6)          
     X        *LPI6(J-1,N2)+COEF(98,7)*LPI6(J-2,N2)+COEF(98,8)*T(J) )
C
C  IMPORT PRICE RESIDUALS
C
      U(99,J)=LPI(J,N1)                                                        
     X    -( COEF(99,1)+COEF(99,2)*LPI(J-1,N2)+COEF(99,3)*                     
     X       LPI(J-2,N2)+COEF(99,4)*FP+COEF(99,5)*FPL )                        
      U(100,J)=LPI1(J,N1)                                                      
     X    -(COEF(100,1)+COEF(100,2)*LPI1(J-1,N2)+COEF(100,3)*                  
     X       LPI1(J-2,N2)+COEF(100,4)*FP1+COEF(100,5)*FP1L )                   
      U(101,J)=LPI2(J,N1)                                                      
     X    -(COEF(101,1)+COEF(101,2)*LPI2(J-1,N2)+COEF(101,3)*                  
     X       LPI2(J-2,N2)+COEF(101,4)*FP2+COEF(101,5)*FP2L )                   
      U(102,J)=LPI3(J,N1)                                                      
     X    -(COEF(102,1)+COEF(102,2)*LPI3(J-1,N2)+COEF(102,3)*                  
     X       LPI3(J-2,N2)+COEF(102,4)*FP3+COEF(102,5)*FP3L )                   
      U(103,J)=LPI4(J,N1)                                                      
     X    -(COEF(103,1)+COEF(103,2)*LPI4(J-1,N2)+COEF(103,3)*                  
     X       LPI4(J-2,N2)+COEF(103,4)*FP4+COEF(103,5)*FP4L )                   
      U(104,J)=LPI5(J,N1)                                                      
     X    -(COEF(104,1)+COEF(104,2)*LPI5(J-1,N2)+COEF(104,3)*                  
     X       LPI5(J-2,N2)+COEF(104,4)*FP5+COEF(104,5)*FP5L )                   
      U(105,J)=LPI6(J,N1)                                                      
     X    -(COEF(105,1)+COEF(105,2)*LPI6(J-1,N2)+COEF(105,3)*                  
     X       LPI6(J-2,N2)+COEF(105,4)*FP6+COEF(105,5)*FP6L )
C
C  EXPORT PRICE RESIDUALS
C
      U(106,J)=LPE(J,N1)                                                       
     X    -( COEF(106,1)+COEF(106,2)*LPE(J-1,N2)+COEF(106,3)                   
     X       *LPE(J-2,N2)+COEF(106,4)*LP(J,N2)+COEF(106,5)*LP(J-1,N2)          
     X       +COEF(106,6)*T(J) )                                               
      U(107,J)=LPE1(J,N1)                                                      
     X    -( COEF(107,1)+COEF(107,2)*LPE1(J-1,N2)+COEF(107,3)                  
     X       *LPE1(J-2,N2)+COEF(107,4)*LP1(J,N2)+COEF(107,5)*LP1(J-1,N2)       
     X       +COEF(107,6)*T(J) )                                               
      U(108,J)=LPE2(J,N1)                                                      
     X    -( COEF(108,1)+COEF(108,2)*LPE2(J-1,N2)+COEF(108,3)                  
     X       *LPE2(J-2,N2)+COEF(108,4)*LP2(J,N2)+COEF(108,5)*LP2(J-1,N2)       
     X       +COEF(108,6)*T(J) )                                               
      U(109,J)=LPE3(J,N1)                                                      
     X    -( COEF(109,1)+COEF(109,2)*LPE3(J-1,N2)+COEF(109,3)                  
     X       *LPE3(J-2,N2)+COEF(109,4)*LP3(J,N2)+COEF(109,5)*LP3(J-1,N2)       
     X       +COEF(109,6)*FP3+COEF(109,7)*FP3L+COEF(109,8)*T(J) )              
      U(110,J)=LPE4(J,N1)                                                      
     X    -( COEF(110,1)+COEF(110,2)*LPE4(J-1,N2)+COEF(110,3)                  
     X       *LPE4(J-2,N2)+COEF(110,4)*LP4(J,N2)+COEF(110,5)*LP4(J-1,N2)       
     X       +COEF(110,6)*FP4+COEF(110,7)*FP4L+COEF(110,8)*T(J) )              
      U(111,J)=LPE5(J,N1)                                                      
     X    -( COEF(111,1)+COEF(111,2)*LPE5(J-1,N2)+COEF(111,3)                  
     X       *LPE5(J-2,N2)+COEF(111,4)*LP5(J,N2)+COEF(111,5)*LP5(J-1,N2)       
     X       +COEF(111,6)*FP5+COEF(111,7)*FP5L+COEF(111,8)*T(J) )              
      U(112,J)=LPE6(J,N1)                                                      
     X    -( COEF(112,1)+COEF(112,2)*LPE6(J-1,N2)+COEF(112,3)                  
     X       *LPE6(J-2,N2)+COEF(112,4)*LP6(J,N2)+COEF(112,5)*LP6(J-1,N2)       
     X       +COEF(112,6)*FP6+COEF(112,7)*FP6L+COEF(112,8)*T(J) )
C
 100  CONTINUE                                                                 
      RETURN                                                                   
      END 
C
C  *********************************************************************
C  SUBROUTINE REWR                                                      
C  *********************************************************************
C                                                                       
C  THIS SUBROUTINE READS IN FILES NECESSARY FOR SIMULATION:             
C  THE RAW DATA (UNIT=2), THE WAGE COEFFICIENTS (UNITS 3 AND 4),
C  THE PRINTvOUT INFORMATION (UNITS 18 AND 19), THE VARIANCE-COVARIANCE
C  MATRIX (UNIT = 21), AND USER SUPPLIED INFORMATION REGARDING
C  STOCHASTIC SHOCKS (UNITS 8 AND 9).
C                                                                       
      SUBROUTINE REWR (S)
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)                               
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3,H=8,NS=100)
      INTEGER NKINK(0:6),NKINK2(0:6),DLIST(NDL,2),ISEED(NS)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      DOUBLE PRECISION RS(NT,N),RS1(NT,N),RS2(NT,N),RS3(NT,N),RS4(NT,N),
     X RS5(NT,N),RS6(NT,N),E1(NT,N),E2(NT,N),E3(NT,N),E4(NT,N),E5(NT,N),
     X E6(NT,N),RL(NT,N),RL1(NT,N),RL2(NT,N),RL3(NT,N),RL4(NT,N),
     X RL5(NT,N),RL6(NT,N)
      DOUBLE PRECISION CD(NT,N),CN(NT,N),CS(NT,N),CD1(NT,N),CN1(NT,N),
     X CS1(NT,N),CD2(NT,N),CN2(NT,N),CS2(NT,N),C3(NT,N),C4(NT,N),
     X CD5(NT,N),CN5(NT,N),CS5(NT,N),CD6(NT,N),CN6(NT,N),CS6(NT,N)
      DOUBLE PRECISION INE(NT,N),INS(NT,N),IR(NT,N),II(NT,N),IF1(NT,N),
     X II1(NT,N),IN2(NT,N),IR2(NT,N),II2(NT,N),IF3(NT,N),II3(NT,N),
     X IF4(NT,N),II4(NT,N),IN5(NT,N),IR5(NT,N),II5(NT,N),IN6(NT,N),
     X IR6(NT,N),II6(NT,N)
      DOUBLE PRECISION EX(NT,N),EX1(NT,N),EX2(NT,N),EX3(NT,N),EX4(NT,N),
     X EX5(NT,N),EX6(NT,N),IM(NT,N),IM1(NT,N),IM2(NT,N),IM3(NT,N),
     X IM4(NT,N),IM5(NT,N),IM6(NT,N),Y(NT,N),Y1(NT,N),Y2(NT,N),Y3(NT,N),
     X Y4(NT,N),Y5(NT,N),Y6(NT,N)
      DOUBLE PRECISION X(NT,N),X1(NT,N),X2(NT,N),X3(NT,N),X4(NT,N),
     X X5(NT,N),X6(NT,N),W(NT,N),W1(NT,N),W2(NT,N),W3(NT,N),W4(NT,N),
     X W5(NT,N),W6(NT,N)
      DOUBLE PRECISION P(NT,N),P1(NT,N),P2(NT,N),P3(NT,N),P4(NT,N),
     X P5(NT,N),P6(NT,N),PI(NT,N),PI1(NT,N),PI2(NT,N),PI3(NT,N),
     X PI4(NT,N),PI5(NT,N),PI6(NT,N),PE(NT,N),PE1(NT,N),PE2(NT,N),
     X PE3(NT,N),PE4(NT,N),PE5(NT,N),PE6(NT,N)
      DOUBLE PRECISION M(NT,N),M1(NT,N),M2(NT,N),M3(NT,N),M4(NT,N),
     X M5(NT,N),M6(NT,N),G(NT,N),G1(NT,N),G2(NT,N),G3(NT,N),G4(NT,N),
     X G5(NT,N),G6(NT,N),T(NT),TT(NT)
      DOUBLE PRECISION LE1(NT,N),LE2(NT,N),LE3(NT,N),LE4(NT,N),
     X LE5(NT,N),LE6(NT,N),LEX(NT,N),LEX1(NT,N),LEX2(NT,N),LEX3(NT,N),
     X LEX4(NT,N),LEX5(NT,N),LEX6(NT,N),LIM(NT,N),LIM1(NT,N),LIM2(NT,N),
     X LIM3(NT,N),LIM4(NT,N),LIM5(NT,N),LIM6(NT,N)
       DOUBLE PRECISION LX(NT,N),LX1(NT,N),LX2(NT,N),LX3(NT,N),
     X LX4(NT,N),LX5(NT,N),LX6(NT,N),LW(NT,N),LW1(NT,N),LW2(NT,N),
     X LW3(NT,N),LW4(NT,N),LW5(NT,N),LW6(NT,N)
      DOUBLE PRECISION LP(NT,N),LP1(NT,N),LP2(NT,N),LP3(NT,N),
     X LP4(NT,N),LP5(NT,N),LP6(NT,N),LPI(NT,N),LPI1(NT,N),LPI2(NT,N),
     X LPI3(NT,N),LPI4(NT,N),LPI5(NT,N),LPI6(NT,N),LPE(NT,N),LPE1(NT,N),
     X LPE2(NT,N),LPE3(NT,N),LPE4(NT,N),LPE5(NT,N),LPE6(NT,N)
      DOUBLE PRECISION LM(NT,N),LM1(NT,N),LM2(NT,N),LM3(NT,N),LM4(NT,N),
     X LM5(NT,N),LM6(NT,N),LMW(NT,N)
      DOUBLE PRECISION PSI(0:6,0:MAXLAG),PHI(0:6,0:MAXLAG),
     X PSI5(NT,0:MAXLAG),PHI5(NT,0:MAXLAG),DELTA(0:6,NT),GAMMA(0:6),
     X STEP,STEPV(12)
      DOUBLE PRECISION YQ(NT)
      DOUBLE PRECISION COEF(NCOEFL,NCOEFS)
      DOUBLE PRECISION VCOV(NE,NE),DADD(4),RATIO(0:6),S(NE,NT),SH(NE,NT)
C
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /VARS/ COEF
      COMMON /WAGE/ PSI,PHI,PSI5,PHI5,DELTA,GAMMA
      COMMON /Z/ ZE,ZO
      COMMON /SHOCKS/ VCOV,SH
      COMMON /PRINT/ ISEED,NRUN
C
      EQUIVALENCE (ZE(1,1),RS),(ZE(1,6),RS1),(ZE(1,11),RS2),            
     X       (ZE(1,16),RS3),(ZE(1,21),RS4),(ZE(1,26),RS5),(ZE(1,31),    
     X       RS6),(ZE(1,36),LE1),(ZE(1,41),LE2),(ZE(1,46),LE3),         
     X       (ZE(1,51),LE4),(ZE(1,56),LE5),(ZE(1,61),LE6),              
     X       (ZE(1,66),RL),(ZE(1,71),RL1),(ZE(1,76),RL2),(ZE(1,81),     
     X       RL3),(ZE(1,86),RL4),(ZE(1,91),RL5),(ZE(1,96),RL6),         
     X       (ZE(1,101),CD),(ZE(1,106),CN),(ZE(1,111),CS),(ZE(1,116),   
     X       CD1),(ZE(1,121),CN1),(ZE(1,126),CS1),(ZE(1,131),CD2),      
     X       (ZE(1,136),CN2),(ZE(1,141),CS2),(ZE(1,146),C3),(ZE(1,151), 
     X       C4),(ZE(1,156),CD5),(ZE(1,161),CN5),(ZE(1,166),CS5),       
     X       (ZE(1,171),CD6),(ZE(1,176),CN6),(ZE(1,181),CS6),           
     X       (ZE(1,186),INE),(ZE(1,191),INS),(ZE(1,196),IR),(ZE(1,201), 
     X       II),(ZE(1,206),IF1),(ZE(1,211),II1),(ZE(1,216),IN2),       
     X       (ZE(1,221),IR2),(ZE(1,226),II2),(ZE(1,231),IF3),           
     X       (ZE(1,236),II3),(ZE(1,241),IF4),(ZE(1,246),II4),           
     X       (ZE(1,251),IN5),(ZE(1,256),IR5),(ZE(1,261),II5),           
     X       (ZE(1,266),IN6),(ZE(1,271),IR6),(ZE(1,276),II6),           
     X       (ZE(1,281),LEX),(ZE(1,286),LEX1),(ZE(1,291),LEX2),         
     X       (ZE(1,296),LEX3),(ZE(1,301),LEX4),(ZE(1,306),LEX5),        
     X       (ZE(1,311),LEX6),(ZE(1,316),LIM),(ZE(1,321),LIM1)          
      EQUIVALENCE (ZE(1,326),LIM2),(ZE(1,331),LIM3),(ZE(1,336),LIM4),   
     X       (ZE(1,341),LIM5),(ZE(1,346),LIM6),                         
     X       (ZE(1,351),Y),(ZE(1,356),Y1),(ZE(1,361),Y2),(ZE(1,366),    
     X       Y3),(ZE(1,371),Y4),(ZE(1,376),Y5),(ZE(1,381),Y6),          
     X       (ZE(1,386),LX),(ZE(1,391),LX1),(ZE(1,396),LX2),(ZE(1,401), 
     X       LX3),(ZE(1,406),LX4),(ZE(1,411),LX5),(ZE(1,416),LX6),      
     X       (ZE(1,421),LW),(ZE(1,426),LW1),(ZE(1,431),LW2),(ZE(1,436), 
     X       LW3),(ZE(1,441),LW4),(ZE(1,446),LW5),(ZE(1,451),LW6),      
     X       (ZE(1,456),LP),(ZE(1,461),LP1),(ZE(1,466),LP2),(ZE(1,471), 
     X       LP3),(ZE(1,476),LP4),(ZE(1,481),LP5),(ZE(1,486),LP6),      
     X       (ZE(1,491),LPI),(ZE(1,496),LPI1),(ZE(1,501),LPI2),         
     X       (ZE(1,506),LPI3),(ZE(1,511),LPI4),(ZE(1,516),LPI5),        
     X       (ZE(1,521),LPI6),(ZE(1,526),LPE),(ZE(1,531),LPE1),         
     X       (ZE(1,536),LPE2),(ZE(1,541),LPE3),(ZE(1,546),LPE4),        
     X       (ZE(1,551),LPE5),(ZE(1,556),LPE6)                          
      EQUIVALENCE (ZO(1,1),LM),(ZO(1,6),LM1),(ZO(1,11),LM2),(ZO(1,16),  
     X       LM3),(ZO(1,21),LM4),(ZO(1,26),LM5),(ZO(1,31),LM6),         
     X       (ZO(1,36),G),(ZO(1,41),G1),(ZO(1,46),G2),(ZO(1,51),G3),    
     X       (ZO(1,56),G4),(ZO(1,61),G5),(ZO(1,66),G6),(ZO(1,71),T),    
     X       (ZO(1,76),TT),(ZO(1,81),E1),(ZO(1,86),E2),(ZO(1,91),E3),   
     X       (ZO(1,96),E4),(ZO(1,101),E5),(ZO(1,106),E6),               
     X       (ZO(1,111),EX),(ZO(1,116),EX1),(ZO(1,121),EX2),            
     X       (ZO(1,126),EX3),(ZO(1,131),EX4),(ZO(1,136),EX5),           
     X       (ZO(1,141),EX6),(ZO(1,146),IM),(ZO(1,151),IM1),            
     X       (ZO(1,156),IM2),(ZO(1,161),IM3),(ZO(1,166),IM4),           
     X       (ZO(1,171),IM5),(ZO(1,176),IM6),                           
     X       (ZO(1,181),X),(ZO(1,186),X1),(ZO(1,191),X2),(ZO(1,196),    
     X       X3),(ZO(1,201),X4),(ZO(1,206),X5),(ZO(1,211),X6),          
     X       (ZO(1,216),W),(ZO(1,221),W1),(ZO(1,226),W2),(ZO(1,231),    
     X       W3),(ZO(1,236),W4),(ZO(1,241),W5),(ZO(1,246),W6),          
     X       (ZO(1,251),P),(ZO(1,256),P1),(ZO(1,261),P2),(ZO(1,266),    
     X       P3),(ZO(1,271),P4),(ZO(1,276),P5),(ZO(1,281),P6),          
     X       (ZO(1,286),PI),(ZO(1,291),PI1),(ZO(1,296),PI2),(ZO(1,301), 
     X       PI3),(ZO(1,306),PI4),(ZO(1,311),PI5),(ZO(1,316),PI6)       
      EQUIVALENCE (ZO(1,321),PE),(ZO(1,326),PE1),(ZO(1,331),PE2),       
     X       (ZO(1,336),PE3),(ZO(1,341),PE4),(ZO(1,346),PE5),(ZO(1,351),
     X       PE6),(ZO(1,356),M),(ZO(1,361),M1),(ZO(1,366),M2),          
     X       (ZO(1,371),M3),(ZO(1,376),M4),(ZO(1,381),M5),(ZO(1,386),   
     X       M6),(ZO(1,391),LMW)                                        
C                                                                       
C  READ IN THE LOCATION THAT EACH VARIABLE WILL HAVE IN THE ZE          
C  AND ZO MATRICES (UNIT 15) AND THE FORMAT IN WHICH DEVIATIONS         
C  OF EACH VARIABLE FROM ITS BASELINE PATH WILL BE PRINTED OUT          
C  (UNIT 16).                                                           
C         
      WRITE(*,*) 'READING IN DATA LISTS.'
C
      DO 10 I=1,NDL                                                     
	READ(15,*) (DLIST(I,J),J=1,2)                                   
 10   CONTINUE                                                          
C                                                                       
C  READ IN THE ACTUAL DATA (BASELINE) FROM UNIT 2:                      
C                                                                       
C  (ZO CONTAINS DATA ENTERED IN LEVEL FORM WHICH WILL BE USED           
C   IN LEVELS AND IN LOGS. ZE CONTAINS DATA ENTERED AND USED            
C   SOLELY IN LEVELS AND THE LOGS OF VARIABLES ENTERED IN ZO)           
C                                       
      WRITE(*,*) 'READING IN BASELINE DATA.'
      DO 30 I=1,NDL                                                     
	 IF(DLIST(I,2).EQ.1) THEN                                        
	    READ(2,*) (ZE(J,DLIST(I,1)),J=1,NT)                           
	 ELSE                                                            
	    READ(2,*) (ZO(J,DLIST(I,1)),J=1,NT)                           
	 END IF                                                          
   30 CONTINUE                                 
C                                                                       
C  READ IN WAGE INFORMATION FROM UNIT 3.                                
C
      WRITE(*,*) 'READING IN WAGE INFORMATION.'
C
      DO 35 I=0,6
	 READ (10,*) RATIO(I),NKINK2(I)
 35   CONTINUE
C
      DO 40 I=0,6                                                       
	IF(I.NE.5) THEN                                                 
	  READ(3,*) NKINK(I),GAMMA(I),DELTA(I,1),D1                    
	  DELTA(I,1+NKINK(I))=DELTA(I,1)+D1                             
	  DELTA(I,1+NKINK2(I))=RATIO(I)*DELTA(I,1+NKINK(I))                
	  READ(3,*) (PSI(I,J),J=0,MAXLAG)                               
	  READ(3,*) (PHI(I,J),J=0,MAXLAG)                               
	ELSE                                                            
	  READ(3,*) NKINK(5),GAMMA(5)                                   
	  READ(3,*) (DELTA(5,J),J=1,4)                                  
	  READ(3,*) (DADD(J),J=1,4)                                    
	  READ(3,*) (PSI5(1,J),J=0,MAXLAG)                              
	  READ(3,*) (PSI5(2,J),J=0,MAXLAG)                              
	  READ(3,*) (PSI5(3,J),J=0,MAXLAG)                              
	  READ(3,*) (PSI5(4,J),J=0,MAXLAG)                              
	  READ(3,*) (PHI5(1,J),J=0,MAXLAG)                              
	  READ(3,*) (PHI5(2,J),J=0,MAXLAG)                              
	  READ(3,*) (PHI5(3,J),J=0,MAXLAG)                              
	  READ(3,*) (PHI5(4,J),J=0,MAXLAG)                              
	END IF
C
C  READ IN STARTING CONTRACT WAGES
C
	IF(I.EQ.0) READ(3,*) (LX(J,1),J=1,3)                            
	IF(I.EQ.1) READ(3,*) (LX1(J,1),J=1,3)                           
	IF(I.EQ.2) READ(3,*) (LX2(J,1),J=1,3)                           
	IF(I.EQ.3) READ(3,*) (LX3(J,1),J=1,3)                           
	IF(I.EQ.4) READ(3,*) (LX4(J,1),J=1,3)                           
	IF(I.EQ.5) READ(3,*) (LX5(J,1),J=1,3)                           
	IF(I.EQ.6) READ(3,*) (LX6(J,1),J=1,3)                           
 40   CONTINUE                                                          
C
C  CONVERT CONTRACT WAGE TO LEVELS
C
      DO 50 J=1,3                                                       
	X(J,1)=DEXP(LX(J,1))                                            
	X1(J,1)=DEXP(LX1(J,1))                                          
	X2(J,1)=DEXP(LX2(J,1))                                          
	X3(J,1)=DEXP(LX3(J,1))                                          
	X4(J,1)=DEXP(LX4(J,1))                                          
	X5(J,1)=DEXP(LX5(J,1))                                          
	X6(J,1)=DEXP(LX6(J,1))                                          
 50   CONTINUE                                                          
C                                                                       
C  READ IN COEFFICIENT VALUES FROM UNIT 4                               
C                                             
      WRITE(*,*) 'READING IN COEFFICIENT VALUES.'
      DO 60 I=1,NCOEFL                                                  
	READ(4,*) (COEF(I,J),J=1,NCOEFS)                                
 60   CONTINUE                                                          
C                                                                       
C  MAKE NECESSARY DATA TRANSFORMATIONS:                                 
C                                                                       
      WRITE(*,*) 'TRANSFORMING DATA.'
C
      DO 70 J=1,NT                                                      
	T(J)=J                                                          
	TT(J)=0.D0                                                      
	IF((J.GT.44).AND.(J.LE.64)) TT(J)=J-44                          
	IF(J.GT.64) TT(J)=20                                            
	DO 80 K=0,6                                                     
	  IF(K.EQ.5) THEN                                               
	    IF(J.LE.NKINK(5)) DELTA(5,J)=DELTA(5,1+MOD(J-1,4))          
	    IF(J.LE.NKINK2(5))                                          
     X      DELTA(5,J)=DELTA(5,1+MOD(J-1,4))+DADD(1+MOD(J-1,4))         
	    IF(J.GT.NKINK2(5))                                          
     X      DELTA(5,J)=RATIO(5)*(DELTA(5,1+MOD(J-1,4))+
     X        DADD(1+MOD(J-1,4)))
	  ELSE                                                          
	    IF(J.LE.NKINK(K)) DELTA(K,J)=DELTA(K,1)                     
	    IF(J.LE.NKINK2(K)) DELTA(K,J)=DELTA(K,1+NKINK(K))           
	    IF(J.GT.NKINK2(K)) DELTA(K,J)=DELTA(K,1+NKINK2(K))          
	  END IF                                                        
	  DO 80 L=0,MAXLAG                                              
	     PSI5(J,L)=PSI5(1+MOD(J-1,4),L)                              
	    PHI5(J,L)=PHI5(1+MOD(J-1,4),L)                              
  80    CONTINUE
C
	LMW(J,1)=0.57822*LM(J,1)+0.01982*LM1(J,1)+0.04482*LM2(J,1)      
     X             +0.11631*LM3(J,1)+0.01723*LM4(J,1)+0.13308*LM5(J,1)  
     X             +0.09052*LM6(J,1)                                    
C
C  TAKE LOGS OF E,EX,IM,X,W,P,PI,PE,M:                                  
C
	DO 90 I=1,35,5                                                  
	  IF(I.LE.30) ZE(J,I+35)=DLOG(ZO(J,I+80))                       
	  ZE(J,I+280)=DLOG(ZO(J,I+110))                                 
	  ZE(J,I+315)=DLOG(ZO(J,I+145))                                 
	  ZE(J,I+420)=DLOG(ZO(J,I+215))                                 
	  ZE(J,I+455)=DLOG(ZO(J,I+250))                                 
	  ZE(J,I+490)=DLOG(ZO(J,I+285))                                 
	  ZE(J,I+525)=DLOG(ZO(J,I+320))                                 
	  ZO(J,I)=DLOG(ZO(J,I+355))                                     
  90    CONTINUE                                                        
C
	IF(J.GE.4) THEN                                                 
	  LX(J,1)= (LW(J,1) -PSI(0,1)*LX(J-1,1) -PSI(0,2)               
     X       *LX(J-2,1) -PSI(0,3)*LX(J-3,1))/PSI(0,0)                   
	  LX1(J,1)=(LW1(J,1)-PSI(1,1)*LX1(J-1,1)-PSI(1,2)               
     X       *LX1(J-2,1)-PSI(1,3)*LX1(J-3,1))/PSI(1,0)                  
	  LX2(J,1)=(LW2(J,1)-PSI(2,1)*LX2(J-1,1)-PSI(2,2)               
     X       *LX2(J-2,1)-PSI(2,3)*LX2(J-3,1))/PSI(2,0)                  
	  LX3(J,1)=(LW3(J,1)-PSI(3,1)*LX3(J-1,1)-PSI(3,2)               
     X       *LX3(J-2,1)-PSI(3,3)*LX3(J-3,1))/PSI(3,0)                  
	  LX4(J,1)=(LW4(J,1)-PSI(4,1)*LX4(J-1,1)-PSI(4,2)               
     X       *LX4(J-2,1)-PSI(4,3)*LX4(J-3,1))/PSI(4,0)                  
	  LX5(J,1)=(LW5(J,1)-PSI5(J,1)*LX5(J-1,1)-PSI5(J,2)             
     X       *LX5(J-2,1)-PSI5(J,3)*LX5(J-3,1))/PSI5(J,0)                
	  LX6(J,1)=(LW6(J,1)-PSI(6,1)*LX6(J-1,1)-PSI(6,2)               
     X       *LX6(J-2,1)-PSI(6,3)*LX6(J-3,1))/PSI(6,0)
C
	  X(J,1)=DEXP(LX(J,1))                                          
	  X1(J,1)=DEXP(LX1(J,1))                                        
	  X2(J,1)=DEXP(LX2(J,1))                                        
	  X3(J,1)=DEXP(LX3(J,1))                                        
	  X4(J,1)=DEXP(LX4(J,1))                                        
	  X5(J,1)=DEXP(LX5(J,1))                                        
	  X6(J,1)=DEXP(LX6(J,1))                                        
	END IF                                                          
  70  CONTINUE
C
C  INITIALIZE VECTORS
C
      CALL INIT(1,NT)
C 
C  READ FROM UNIT 21 THE FACTORIZATION OF THE VAR-COV MATRIX OF THE
C  STRUCTURAL RESIDUALS.  THE ZEROS CORRESPOND TO IDENTITIES.
C
      WRITE(*,*) 'RETRIEVING FACTORED VARIANCE-COVARIANCE MATRIX.'
      IF (ISTOCH .EQ. 1) THEN
	 DO 200 I=1,NE
	    DO 200 J = 1,NE
	       IF (((I .GE. 71) .AND. (I .LE. 77)) .OR. ((I .GE. 85) 
     X         .AND. (I .LE. 91)) .OR. ((J .GE. 71) .AND. (J .LE. 77)) 
     X         .OR. ((J .GE. 85) .AND. (J .LE. 91))) THEN
		  VCOV(I,J) = 0.0D0
	       ELSE
		  READ(21,*) VCOV(I,J)
	       END IF
  200    CONTINUE
      ELSE 
	 DO 210 I=1,NE
	    DO 210 J=1,NE
	       VCOV(I,J) = 0.0D0
  210     CONTINUE
      END IF
C
C  GENERATE MATRIX OF RANDOM SHOCKS (EQUAL ZEROS IF DETERMINISTIC
C   SIMULATION)
C
      INITSEED=ISEED(1)
      CALL STOCH(INITSEED)
C
C CALL RESIDUALS IF REQUESTED
C
      IF (IRES .EQ. 1) THEN
	 CALL RESID(1,1,1,1,1,NT,S)
      ELSE
	 DO 400 K=1,NE
	    DO 400 J=1,NT
	       S(K,J) = 0.0D0
 400    CONTINUE
      END IF
C
C  SPECIFY THE NATURE OF THE POLICY SHOCK
C  (E.G. A GOVERNMENT SPENDING SHOCK OR A MONEY SHOCK)
C
C  NO SHOCK (IDTYPE=0)
C
      IF (IDTYPE .EQ. 0) THEN
	 WRITE(*,*) 'NO POLICY SHOCK.'
      END IF
C
C ***************************************************************
C PERMANENT MONETARY STIMULUS (IDTYPE=x)
C 3 PERCENT INCREASE IN MONEY STOCK
C PHASED-IN OVER ONE YEAR
C ****************************************************************
C
      IF ( (IDTYPE.GT.0) .AND. (IDTYPE.LT.10) )THEN
C
	 WRITE(*,*) 'PHASED-IN 3% INCREASE IN MONEY SUPPLY.'
	 WRITE(*,*) 'FLEXIBLE EXCHANGE RATES.'
	 WRITE(*,*) 'INITIAL GUESSES/EXPECTATIONS ADJUSTED.'
	 STEPV(1)=DLOG(1.0014D0)
	 STEPV(2)=DLOG(1.0073D0)
	 STEPV(3)=DLOG(1.0188D0)
	 STEPV(4)=DLOG(1.028D0)
	 STEPV(5)=DLOG(1.03D0)
C
C  U.S. MONEY SHOCK, PHASED IN (IDTYPE=1)                               
C
	 IF (IDTYPE.EQ.1) THEN
	    WRITE(*,*) 'COUNTRY: UNITED STATES.'
	    DO 510 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 510 K=2,4
		  LP(J,K)=STEPV(JJ)+LP(J,K)
		  LM(J,K)=STEPV(JJ)+LM(J,K)
		  LPE(J,K)=STEPV(JJ)+LPE(J,K)
		  LPI(J,K)=STEPV(JJ)+LPI(J,K)
		  LX(J,K)=STEPV(JJ)+LX(J,K)
		  LW(J,K)=STEPV(JJ)+LW(J,K)
		  LE1(J,K)=STEPV(JJ)+LE1(J,K)
		  LE2(J,K)=STEPV(JJ)+LE2(J,K)
		  LE3(J,K)=STEPV(JJ)+LE3(J,K)
		  LE4(J,K)=STEPV(JJ)+LE4(J,K)
		  LE5(J,K)=STEPV(JJ)+LE5(J,K)
		  LE6(J,K)=STEPV(JJ)+LE6(J,K)
 510        CONTINUE
	 END IF
C
C  CANADIAN MONEY SHOCK, PHASED IN (IDTYPE=2)
C                                                                       
	 IF(IDTYPE.EQ.2) THEN
	    WRITE(*,*) 'COUNTRY: CANADA.'
	    DO 520 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 520 K=2,4
		  LP1(J,K)=STEPV(JJ)+LP1(J,K)
		  LM1(J,K)=STEPV(JJ)+LM1(J,K)
		  LPE1(J,K)=STEPV(JJ)+LPE1(J,K)
		  LPI1(J,K)=STEPV(JJ)+LPI1(J,K)
		  LX1(J,K)=STEPV(JJ)+LX1(J,K)
		  LW1(J,K)=STEPV(JJ)+LW1(J,K)
		  LE1(J,K)=-STEPV(JJ)+LE1(J,K)
 520        CONTINUE
	 END IF
C
C  FRENCH MONEY SHOCK, PHASED IN (IDTYPE=3)
C
	 IF(IDTYPE.EQ.3) THEN
	    WRITE(*,*) 'COUNTRY: FRANCE.'
	    DO 530 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 530 K=2,4
		  LP2(J,K)=STEPV(JJ)+LP2(J,K)
		  LM2(J,K)=STEPV(JJ)+LM2(J,K)
		  LPE2(J,K)=STEPV(JJ)+LPE2(J,K)
		  LPI2(J,K)=STEPV(JJ)+LPI2(J,K)
		  LX2(J,K)=STEPV(JJ)+LX2(J,K)
		  LW2(J,K)=STEPV(JJ)+LW2(J,K)
		  LE2(J,K)=-STEPV(JJ)+LE2(J,K)
 530        CONTINUE
	 END IF
C
C  GERMAN MONEY SHOCK, PHASED IN (IDTYPE=4)
C                                                                       
	 IF(IDTYPE.EQ.4) THEN
	    WRITE(*,*) 'COUNTRY: GERMANY.'
	    DO 540 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 540 K=2,4
		  LP3(J,K)=STEPV(JJ)+LP3(J,K)
		  LM3(J,K)=STEPV(JJ)+LM3(J,K)
		  LPE3(J,K)=STEPV(JJ)+LPE3(J,K)
		  LPI3(J,K)=STEPV(JJ)+LPI3(J,K)
		  LX3(J,K)=STEPV(JJ)+LX3(J,K)
		  LW3(J,K)=STEPV(JJ)+LW3(J,K)
		  LE3(J,K)=-STEPV(JJ)+LE3(J,K)
 540        CONTINUE
	 END IF
C
C  ITALIAN MONEY SHOCK, PHASED IN (IDTYPE=5)
C                                                                       
	 IF(IDTYPE.EQ.5) THEN
	    WRITE(*,*) 'COUNTRY: ITALY.'
	    DO 550 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 550 K=2,4
		  LP4(J,K)=STEPV(JJ)+LP4(J,K)
		  LM4(J,K)=STEPV(JJ)+LM4(J,K)
		  LPE4(J,K)=STEPV(JJ)+LPE4(J,K)
		  LPI4(J,K)=STEPV(JJ)+LPI4(J,K)
		  LX4(J,K)=STEPV(JJ)+LX4(J,K)
		  LW4(J,K)=STEPV(JJ)+LW4(J,K)
		  LE4(J,K)=-STEPV(JJ)+LE4(J,K)
 550        CONTINUE
	 END IF
C
C JAPANESE MONEY SHOCK, PHASED IN (IDTYPE=6)
C
	 IF(IDTYPE.EQ.6) THEN
	    WRITE(*,*) 'COUNTRY: JAPAN.'
	    DO 560 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 560 K=2,4
		  LP5(J,K)=STEPV(JJ)+LP5(J,K)
		  LM5(J,K)=STEPV(JJ)+LM5(J,K)
		  LPE5(J,K)=STEPV(JJ)+LPE5(J,K)
		  LPI5(J,K)=STEPV(JJ)+LPI5(J,K)
		  LX5(J,K)=STEPV(JJ)+LX5(J,K)
		  LW5(J,K)=STEPV(JJ)+LW5(J,K)
		  LE5(J,K)=-STEPV(JJ)+LE5(J,K)
 560        CONTINUE
	 END IF
C
C  U.K. MONEY SHOCK, PHASED IN (IDTYPE=7)
C
	 IF(IDTYPE.EQ.7) THEN
	    WRITE(*,*) 'COUNTRY: UNITED KINGDOM.'
	    DO 570 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 570 K=2,4
		  LP6(J,K)=STEPV(JJ)+LP6(J,K)
		  LM6(J,K)=STEPV(JJ)+LM6(J,K)
		  LPE6(J,K)=STEPV(JJ)+LPE6(J,K)
		  LPI6(J,K)=STEPV(JJ)+LPI6(J,K)
		  LX6(J,K)=STEPV(JJ)+LX6(J,K)
		  LW6(J,K)=STEPV(JJ)+LW6(J,K)
		  LE6(J,K)=-STEPV(JJ)+LE6(J,K)
 570        CONTINUE
	 END IF
C
      END IF
C
C **************************************************************
C PERMANENT UNANNOUNCED GOVERNMENT SPENDING SHOCK (IDTYPE=1x)
C 1 PERCENT OF GNP
C **************************************************************
C
      IF ( (IDTYPE.GT.10) .AND. (IDTYPE.LT.20)) THEN
C
	 WRITE(*,*) 'UNANNOUNCED INCREASE IN GOVERNMENT SPENDING.'
	 WRITE(*,*) 'INCREASE EQUAL TO ONE PERCENT OF BASELINE GDP.'
C
C  U.S. GOVERNMENT SPENDING SHOCK (IDTYPE=11)
C                                                                       
	 IF(IDTYPE.EQ.11) THEN
	    WRITE(*,*) 'COUNTRY: UNITED STATES.'
	    STEP=DLOG(1.03D0)
	    DO 610 J=NBEG,NT
	       DO 610 K=2,4
		  G(J,K)=G(J,K)+0.01D0*Y(J,1)
 610        CONTINUE
	    DO 611 K=2,4
	       DO 611 J=NBEG,NT
		  LP(J,K)=STEP+LP(J,K)
		  LPE(J,K)=STEP+LPE(J,K)
		  LPI(J,K)=-STEP+LPI(J,K)
		  LX(J,K)=STEP+LX(J,K)
		  LW(J,K)=STEP+LW(J,K)
		  LE1(J,K)=-STEP+LE1(J,K)
		  LE2(J,K)=-STEP+LE2(J,K)
		  LE3(J,K)=-STEP+LE3(J,K)
		  LE4(J,K)=-STEP+LE4(J,K)
		  LE5(J,K)=-STEP+LE5(J,K)
		  LE6(J,K)=-STEP+LE6(J,K)
 611        CONTINUE
	 END IF
C
C  CANADIAN GOVERNMENT SPENDING SHOCK (IDTYPE=12)
C                                                                       
	 IF(IDTYPE.EQ.12) THEN
	    WRITE(*,*) 'COUNTRY: CANADA.'
	    STEP=DLOG(1.02D0)
	    DO 620 J=NBEG,NT
	       DO 620 K=2,4
		  G1(J,K)=G1(J,K)+0.01D0*Y1(J,1)
 620        CONTINUE
	    DO 621 K=2,4
	       DO 621 J=NBEG,NT
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=-STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
  621       CONTINUE
	 END IF
C
C  FRENCH GOVERNMENT SPENDING SHOCK (IDTYPE=13)
C                                                                       
	 IF(IDTYPE.EQ.13) THEN
	    WRITE(*,*) 'COUNTRY: FRANCE.'
	    STEP=DLOG(1.01D0)
	    DO 630 J=NBEG,NT
	       DO 630 K=2,4
		  G2(J,K)=G2(J,K)+0.01D0*Y2(J,1)
 630        CONTINUE
	    DO 631 K=2,4
	       DO 631 J=NBEG,NT
		  LP2(J,K)=STEP+LP2(J,K)
		  LPE2(J,K)=STEP+LPE2(J,K)
		  LPI2(J,K)=-STEP+LPI2(J,K)
		  LX2(J,K)=STEP+LX2(J,K)
		  LW2(J,K)=STEP+LW2(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
  631       CONTINUE
	 END IF
C
C  GERMAN GOVERNMENT SPENDING SHOCK (IDTYPE=14)
C                                                                       
	 IF(IDTYPE.EQ.14) THEN
	    WRITE(*,*) 'COUNTRY: GERMANY.'
	    STEP=DLOG(1.01D0)
	    DO 640 J=NBEG,NT
	       DO 640 K=2,4
		  G3(J,K)=G3(J,K)+0.01D0*Y3(J,1)
 640        CONTINUE
	    DO 641 K=2,4
	       DO 641 J=NBEG,NT
		  LP3(J,K)=STEP+LP3(J,K)
		  LPE3(J,K)=STEP+LPE3(J,K)
		  LPI3(J,K)=-STEP+LPI3(J,K)
		  LX3(J,K)=STEP+LX3(J,K)
		  LW3(J,K)=STEP+LW3(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
  641       CONTINUE
	 END IF
C
C  ITALIAN GOVERNMENT SPENDING SHOCK (IDTYPE=15)
C                                                                       
	 IF(IDTYPE.EQ.15) THEN
	    WRITE(*,*) 'COUNTRY: ITLAY.'
	    STEP=DLOG(1.03D0)
	    DO 650 J=NBEG,NT
	       DO 650 K=2,4
		  G4(J,K)=G4(J,K)+0.01D0*Y4(J,1)
 650        CONTINUE
	    DO 651 K=2,4
	       DO 651 J=NBEG,NT
		  LP4(J,K)=STEP+LP4(J,K)
		  LPE4(J,K)=STEP+LPE4(J,K)
		  LPI4(J,K)=-STEP+LPI4(J,K)
		  LX4(J,K)=STEP+LX4(J,K)
		  LW4(J,K)=STEP+LW4(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
  651       CONTINUE
	 END IF
C                                                                       
C  JAPANESE GOVERNMENT SPENDING SHOCK (IDTYPE=16)
C                                                                       
	 IF(IDTYPE.EQ.16) THEN
	    WRITE(*,*) 'COUNTRY: JAPAN.'
	    STEP=DLOG(1.02D0)
	    DO 660 J=NBEG,NT
	       DO 660 K=2,4
		  G5(J,K)=G5(J,K)+0.01D0*Y5(J,1)
  660       CONTINUE
	    DO 661 K=2,4
	       DO 661 J=NBEG,NT
		  LP5(J,K)=STEP+LP5(J,K)
		  LPE5(J,K)=STEP+LPE5(J,K)
		  LPI5(J,K)=-STEP+LPI5(J,K)
		  LX5(J,K)=STEP+LX5(J,K)
		  LW5(J,K)=STEP+LW5(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
  661       CONTINUE
	 END IF
C
C  U.K. GOVERNMENT SPENDING SHOCK (IDTYPE=17)
C                                                                       
	 IF(IDTYPE.EQ.17) THEN
	    WRITE(*,*) 'COUNTRY: UNITED KINGDOM.'
	    STEP=DLOG(1.05D0)
	    DO 670 J=NBEG,NT
	       DO 670 K=2,4
		  G6(J,K)=G6(J,K)+0.01D0*Y6(J,1)
  670       CONTINUE
	    DO 671 K=2,4
	       DO 671 J=NBEG,NT
		  LP6(J,K)=STEP+LP6(J,K)
		  LPE6(J,K)=STEP+LPE6(J,K)
		  LPI6(J,K)=-STEP+LPI6(J,K)
		  LX6(J,K)=STEP+LX6(J,K)
		  LW6(J,K)=STEP+LW6(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
  671       CONTINUE
	 END IF
C
      END IF
C
C ******************************************************************
C ANTICIPATED PERMANENT  MONEY SHOCK (IDTYPE=2x)
C 3 PERCENT INCREASE
C ANTICIPATED TWO YEARS IN ADVANCE
C ******************************************************************
C
      IF ((IDTYPE.GT.20).AND.(IDTYPE.LT.30)) THEN
C
	 WRITE(*,*) 'ANTICIPATED 3% INCREASE IN MONEY SUPPLY.'
	 WRITE(*,*) 'INITIAL GUESSES/EXPECTATIONS ADJUSTED.'
	 STEPV(1)=DLOG(1.0014D0)
	 STEPV(2)=DLOG(1.0073D0)
	 STEPV(3)=DLOG(1.0188D0)
	 STEPV(4)=DLOG(1.028D0)
	 STEPV(5)=DLOG(1.03D0)
C
C  U.S. MONEY SHOCK, ANTICIPATED (IDTYPE=21)
C                                                                       
	 IF(IDTYPE.EQ.21) THEN
	    WRITE(*,*) 'COUNTRY: UNITED STATES.'
	    DO 710 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 710 K=2,4
		  LM(J,K)=STEPV(JJ)+LM(J,K)
  710       CONTINUE
	    DO 711 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 711 K=2,4
		  LP(J,K)=STEP+LP(J,K)
		  LPE(J,K)=STEP+LPE(J,K)
		  LPI(J,K)=STEP+LPI(J,K)
		  LX(J,K)=STEP+LX(J,K)
		  LW(J,K)=STEP+LW(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
 711        CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 712 J=NBEG+12,NT
	       DO 712 K=2,4
		  LP(J,K)=STEP+LP(J,K)
		  LPE(J,K)=STEP+LPE(J,K)
		  LPI(J,K)=STEP+LPI(J,K)
		  LX(J,K)=STEP+LX(J,K)
		  LW(J,K)=STEP+LW(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
 712        CONTINUE
	 END IF
C
C  CANADIAN MONEY SHOCK, ANTICIPATED (IDTYPE=22)
C
	 IF(IDTYPE.EQ.22) THEN
	    WRITE(*,*) 'COUNTRY: CANADA .'
	    DO 720 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 720 K=2,4
		  LM1(J,K)=STEPV(JJ)+LM1(J,K)
  720       CONTINUE
	    DO 721 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 721 K=2,4
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
  721       CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 722 J=NBEG+12,NT
	       DO 722 K=2,4
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
  722       CONTINUE
	 END IF
C
C  FRENCH MONEY SHOCK, ANTICIPATED (IDTYPE=23)
C
	 IF(IDTYPE.EQ.23) THEN
	    WRITE(*,*) 'COUNTRY: FRANCE .'
	    DO 730 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 730 K=2,4
		  LM2(J,K)=STEPV(JJ)+LM2(J,K)
  730       CONTINUE
	    DO 731 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 731 K=2,4
		  LP2(J,K)=STEP+LP2(J,K)
		  LPE2(J,K)=STEP+LPE2(J,K)
		  LPI2(J,K)=STEP+LPI2(J,K)
		  LX2(J,K)=STEP+LX2(J,K)
		  LW2(J,K)=STEP+LW2(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
  731       CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 732 J=NBEG+12,NT
	       DO 732 K=2,4
		  LP2(J,K)=STEP+LP2(J,K)
		  LPE2(J,K)=STEP+LPE2(J,K)
		  LPI2(J,K)=STEP+LPI2(J,K)
		  LX2(J,K)=STEP+LX2(J,K)
		  LW2(J,K)=STEP+LW2(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
 732        CONTINUE
	 END IF
C
C  GERMAN MONEY SHOCK, ANTICIPATED (IDTYPE=24)
C                                                                       
	 IF(IDTYPE.EQ.24) THEN
	    WRITE(*,*) 'COUNTRY: GERMANY.'
	    DO 740 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 740 K=2,4
		  LM3(J,K)=STEPV(JJ)+LM3(J,K)
  740       CONTINUE
	    DO 741 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 741 K=2,4
		  LP3(J,K)=STEP+LP3(J,K)
		  LPE3(J,K)=STEP+LPE3(J,K)
		  LPI3(J,K)=STEP+LPI3(J,K)
		  LX3(J,K)=STEP+LX3(J,K)
		  LW3(J,K)=STEP+LW3(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
 741        CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 742 J=NBEG+12,NT
	       DO 742 K=2,4
		  LP3(J,K)=STEP+LP3(J,K)
		  LPE3(J,K)=STEP+LPE3(J,K)
		  LPI3(J,K)=STEP+LPI3(J,K)
		  LX3(J,K)=STEP+LX3(J,K)
		  LW3(J,K)=STEP+LW3(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
 742        CONTINUE
	 END IF
C
C  ITALIAN MONEY SHOCK, ANTICIPATED (IDTYPE=25)
C                                                                       
	IF(IDTYPE.EQ.25) THEN
	    WRITE(*,*) 'COUNTRY: ITALY.'
	    DO 750 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 750 K=2,4
		  LM4(J,K)=STEPV(JJ)+LM4(J,K)
  750       CONTINUE
	    DO 751 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 751 K=2,4
		  LP4(J,K)=STEP+LP4(J,K)
		  LPE4(J,K)=STEP+LPE4(J,K)
		  LPI4(J,K)=STEP+LPI4(J,K)
		  LX4(J,K)=STEP+LX4(J,K)
		  LW4(J,K)=STEP+LW4(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
 751        CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 752 J=NBEG+12,NT
	       DO 752 K=2,4
		  LP4(J,K)=STEP+LP4(J,K)
		  LPE4(J,K)=STEP+LPE4(J,K)
		  LPI4(J,K)=STEP+LPI4(J,K)
		  LX4(J,K)=STEP+LX4(J,K)
		  LW4(J,K)=STEP+LW4(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
 752        CONTINUE
	 END IF
C
C  JAPANESE MONEY SHOCK, ANTICIPATED (IDTYPE=26)
C                                                                       
	 IF(IDTYPE.EQ.26) THEN
	    WRITE(*,*) 'COUNTRY: JAPAN.'
	    DO 760 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 760 K=2,4
		  LM5(J,K)=STEPV(JJ)+LM5(J,K)
  760       CONTINUE
	    DO 761 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 761 K=2,4
		  LP5(J,K)=STEP+LP5(J,K)
		  LPE5(J,K)=STEP+LPE5(J,K)
		  LPI5(J,K)=STEP+LPI5(J,K)
		  LX5(J,K)=STEP+LX5(J,K)
		  LW5(J,K)=STEP+LW5(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
  761       CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 762 J=NBEG+12,NT
	       DO 762 K=2,4
		  LP5(J,K)=STEP+LP5(J,K)
		  LPE5(J,K)=STEP+LPE5(J,K)
		  LPI5(J,K)=STEP+LPI5(J,K)
		  LX5(J,K)=STEP+LX5(J,K)
		  LW5(J,K)=STEP+LW5(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
  762       CONTINUE
	 END IF
C
C  U.K. MONEY SHOCK, ANTICIPATED (IDTYPE=27)
C                                                                       
	IF(IDTYPE.EQ.27) THEN
	    WRITE(*,*) 'COUNTRY: UNITED KINGDOM.'
	    DO 770 J=NBEG+8,NT
	       JJ= J+1-(NBEG+8)
	       IF (JJ.GE.5) JJ=5
	       DO 770 K=2,4
		  LM6(J,K)=STEPV(JJ)+LM6(J,K)
  770       CONTINUE
	    DO 771 J=NBEG+1,NBEG+11
	       STEP=DLOG(1.0D0+0.03D0*DBLE(J-NBEG)/12.0D0)
	       DO 771 K=2,4
		  LP6(J,K)=STEP+LP6(J,K)
		  LPE6(J,K)=STEP+LPE6(J,K)
		  LPI6(J,K)=STEP+LPI6(J,K)
		  LX6(J,K)=STEP+LX6(J,K)
		  LW6(J,K)=STEP+LW6(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
  771       CONTINUE
	    STEP=DLOG(1.03D0)
	    DO 772 J=NBEG+12,NT
	       DO 772 K=2,4
		  LP6(J,K)=STEP+LP6(J,K)
		  LPE6(J,K)=STEP+LPE6(J,K)
		  LPI6(J,K)=STEP+LPI6(J,K)
		  LX6(J,K)=STEP+LX6(J,K)
		  LW6(J,K)=STEP+LW6(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
  772       CONTINUE
	 END IF
C
      END IF
C
C  *******************************************************************
C  ANTICIPATED PERMANENT GOVERNMENT SPENDING SHOCK (IDTYPE=3x)
C  1 PERCENT OF BASELINE GDP
C  SHOCK BEGINS TWO YEARS AFTER START OF SIMULATION
C  *******************************************************************
C
      IF ((IDTYPE.GT.30).AND.(IDTYPE.LT.40)) THEN
	 WRITE(*,*) 'ANTICIPATED INCREASE IN GOVERNMENT EXPENDITURE.'
	 WRITE(*,*) 'INCREASE EQUALS 1% OF GDP.'
	 WRITE(*,*) 'INCREASE ANNOUNCED TWO YEARS PRIOR TO START.'
C
C  U.S. GOVERNMENT SPENDING SHOCK, ANTICIPATED (IDTYPE=31)
C                                                                      
      IF(IDTYPE.EQ.31) THEN
	WRITE(*,*) 'COUNTRY: UNITED STATES.'
	STEP=DLOG(1.02D0)
	DO 810 J=NBEG+8,NT
	  DO 810 K=2,4
	     G(J,K)=G(J,K)+0.01D0*Y(J,1)
	     LP(J,K)=STEP+LP(J,K)
	     LPE(J,K)=STEP+LPE(J,K)
	     LPI(J,K)=-STEP+LPI(J,K)
	     LX(J,K)=STEP+LX(J,K)
	     LW(J,K)=STEP+LW(J,K)
	     LE1(J,K)=-STEP+LE1(J,K)
	     LE2(J,K)=-STEP+LE2(J,K)
	     LE3(J,K)=-STEP+LE3(J,K)
	     LE4(J,K)=-STEP+LE4(J,K)
	     LE5(J,K)=-STEP+LE5(J,K)
	     LE6(J,K)=-STEP+LE6(J,K)
  810     CONTINUE
	DO 811 J=NBEG+1,NBEG+7
	   STEP=DLOG(1.0D0+0.02D0*DBLE(J-NBEG)/8.0D0)
	   DO 811 K=2,4
	     LP(J,K)=STEP+LP(J,K)
	     LPE(J,K)=STEP+LPE(J,K)
	     LPI(J,K)=-STEP+LPI(J,K)
	     LX(J,K)=STEP+LX(J,K)
	     LW(J,K)=STEP+LW(J,K)
	     LE1(J,K)=-STEP+LE1(J,K)
	     LE2(J,K)=-STEP+LE2(J,K)
	     LE3(J,K)=-STEP+LE3(J,K)
	     LE4(J,K)=-STEP+LE4(J,K)
	     LE5(J,K)=-STEP+LE5(J,K)
	     LE6(J,K)=-STEP+LE6(J,K)
  811   CONTINUE
      END IF
C
C  CANADIAN GOVERNMENT SPENDING SHOCK, ANTICIPATED (IDTYPE=32)
C
	 IF(IDTYPE.EQ.32) THEN
	    WRITE(*,*) 'COUNTRY: CANADA.'
	    STEP=DLOG(1.02D0)
	    DO 820 J=NBEG+8,NT
	       DO 820 K=2,4
		  G1(J,K)=G1(J,K)+0.01D0*Y1(J,1)
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=-STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
  820       CONTINUE
	    DO 821 J=NBEG+1,NBEG+7
	       STEP=DLOG(1.0D0+0.02D0*DBLE(J-NBEG)/8.0D0)
	       DO 821 K=2,4
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=-STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=-STEP+LE1(J,K)
  821     CONTINUE
      END IF
C
C  FRENCH GOVERNMENT SPENDING SHOCK, ANTICIPATED (IDTYPE=33)
C                                                                       
      IF(IDTYPE.EQ.33) THEN
	DO 920 J=NBEG+8,NT
	  DO 920 K=2,4
	     G2(J,K)=G2(J,K)+0.01D0*Y2(J,1)
 920    CONTINUE
	WRITE(*,*) 'ANTICIPATED 1% GNP INCREASE IN FRENCH GOVT. SPEND.'
      END IF
C
C  GERMAN GOVERNMENT SPENDING SHOCK, ANTICIPATED (IDTYPE=34)
C                                                                       
      IF(IDTYPE.EQ.34) THEN
	DO 930 J=NBEG+8,NT
	  DO 930 K=2,4
	     G3(J,K)=G3(J,K)+0.01D0*Y3(J,1)
  930   CONTINUE
	WRITE(*,*) 'ANTICIPATED 1% GNP INCREASE IN GERMAN GOVT. SPEND.'
      END IF
C
C  ITALIAN GOVERNMENT SPENDING SHOCK, ANTICIPATED (IDTYPE=35)
C                                                                       
      IF(IDTYPE.EQ.35) THEN
	DO 940 J=NBEG+8,NT
	  DO 940 K=2,4
	     G4(J,K)=G4(J,K)+0.01D0*Y4(J,1)
 940    CONTINUE
	WRITE(*,*) 'ANTICIPATED 1% GNP INCREASE IN ITALIAN GOVT. SPEND.'
      END IF
C                                                                       
C  JAPANESE GOVERNMENT SPENDING SHOCK (IDTYPE=36)
C                                                                       
      IF(IDTYPE.EQ.36) THEN
	DO 950 J=NBEG+8,NT
	  DO 950 K=2,4
	     G5(J,K)=G5(J,K)+0.01D0*Y5(J,1)
  950   CONTINUE
	WRITE(*,*) 'ANTICIPATED 1% GNP INCREASE IN JAPAN. GOVT. SPEND.'
      END IF
C
C  U.K. GOVERNMENT SPENDING SHOCK (IDTYPE=37)
C                                                                       
      IF(IDTYPE.EQ.37) THEN
	DO 960 J=NBEG+8,NT
	  DO 960 K=2,4
	     G6(J,K)=G6(J,K)+0.01D0*Y6(J,1)
  960   CONTINUE
	WRITE(*,*) 'ANTICIPATED 1% GNP INCREASE IN U.K. GOVT. SPEND.'
      END IF
C
      END IF
C
C  ******************************************************************
C  UNANTICIPTAED TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=5x)
C  1 PERCENT OF GDP
C  SHOCK BEGINS IN FIRST PERIOD OF SIMULATION AND
C  LASTS ONE YEAR
C  ******************************************************************
C
C  U.S. TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=51)
C
      IF (IDTYPE.EQ.51) THEN
	 DO 1100 J =NBEG,NBEG+3
	    DO 1100 K=2,4
	     G(J,K)=G(J,1)+0.01D0*Y(J,1)
 1100    CONTINUE
	 WRITE(*,*) 'TEMPORARY U.S. GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  CANADIAN TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=52)
C
      IF (IDTYPE.EQ.52) THEN
	 DO 1110 J =NBEG,NBEG+3
	    DO 1110 K=2,4
	     G1(J,K)=G1(J,1)+0.01D0*Y1(J,1)
 1110    CONTINUE
	 WRITE(*,*) 'TEMPORARY CANADIAN GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  FRENCH TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=53)
C
      IF (IDTYPE.EQ.53) THEN
	 DO 1120 J =NBEG,NBEG+3
	    DO 1120 K=2,4
	     G2(J,K)=G2(J,1)+0.01D0*Y2(J,1)
 1120    CONTINUE
	 WRITE(*,*) 'TEMPORARY FRENCH GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GDP FOR ONE YEAR.'
      END IF
C
C  GERMAN TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=54)
C
      IF (IDTYPE.EQ.54) THEN
	 DO 1130 J =NBEG,NBEG+3
	    DO 1130 K=2,4
	     G3(J,K)=G3(J,1)+0.01D0*Y3(J,1)
 1130    CONTINUE
	 WRITE(*,*) 'TEMPORARY GERMAN GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  ITALIAN TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=55)
C
      IF (IDTYPE .EQ. 55) THEN
	 DO 1140 J =NBEG,NBEG+3
	    DO 1140 K=2,4
	     G4(J,K)=G4(J,1)+0.01D0*Y4(J,1)
 1140    CONTINUE
	 WRITE(*,*) 'TEMPORARY ITALIAN GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  JAPANESE TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=56)
C
      IF (IDTYPE.EQ.56) THEN
	 DO 1150 J =NBEG,NBEG+3
	    DO 1150 K=2,4
	     G5(J,K)=G5(J,1)+0.01D0*Y5(J,1)
 1150    CONTINUE
	 WRITE(*,*) 'TEMPORARY JAPAN GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  U.K. TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=57)
C
      IF (IDTYPE .EQ. 57) THEN

	 DO 1160 J =NBEG,NBEG+3
	    DO 1160 K=2,4
	     G6(J,K)=G6(J,1)+0.01D0*Y6(J,1)
 1160    CONTINUE
	 WRITE(*,*) 'TEMPORARY U.K. GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C  G7 TEMPORARY GOVERNMENT SPENDING SHOCK (IDTYPE=58)
C
      IF (IDTYPE .EQ. 58) THEN
	 DO 1170 J =NBEG,NBEG+3
	    DO 1170 K=2,4
	       G(J,K)=G(J,K)+0.01D0*Y(J,1)
	       G1(J,K)=G1(J,K)+0.01D0*Y1(J,1)
	       G2(J,K)=G2(J,K)+0.01D0*Y2(J,1)
	       G3(J,K)=G3(J,K)+0.01D0*Y3(J,1)
	       G4(J,K)=G4(J,K)+0.01D0*Y4(J,1)
	       G5(J,K)=G5(J,K)+0.01D0*Y5(J,1)
	       G6(J,K)=G6(J,K)+0.01D0*Y6(J,1)
 1170    CONTINUE
	 WRITE(*,*) 'TEMPORARY G7 GOVERNMENT SPENDING SHOCK:'
	 WRITE(*,*) '1% OF GNP FOR ONE YEAR.'
      END IF
C
C *******************************************************************
C PERMANENT MONETARY STIMULUS (IDTYPE=6x)
C 3 PERCENT INCREASE IN MONEY STOCK
C PHASED-IN OVER ONE YEAR
C FIXED EXCHANGE RATES
C *******************************************************************
C
      IF ((IDTYPE.GT.60) .AND. (IDTYPE.LT.70)) THEN
C
	 IFLEXE=0
	 WRITE(*,*) 'PHASED-IN 3% INCREASE IN MONEY SUPPLY.'
	 WRITE(*,*) 'FIXED EXCHANGE RATES.'
	 WRITE(*,*) 'INITIAL GUESSES/EXPECTATIONS ADJUSTED.'
	 STEPV(1)=DLOG(1.0014D0)
	 STEPV(2)=DLOG(1.0073D0)
	 STEPV(3)=DLOG(1.0188D0)
	 STEPV(4)=DLOG(1.028D0)
	 STEPV(5)=DLOG(1.03D0)
C
	 DO 1200 J=NBEG,NT
	    JJ=J+1-NBEG
	    IF (JJ.GE.5) JJ=5
	    DO 1200 K=2,4
	     LM(J,K)=STEPV(JJ)+LM(J,K)
	     LM1(J,K)=STEPV(JJ)+LM1(J,K)
	     LM2(J,K)=STEPV(JJ)+LM2(J,K)
	     LM3(J,K)=STEPV(JJ)+LM3(J,K)
	     LM4(J,K)=STEPV(JJ)+LM4(J,K)
	     LM5(J,K)=STEPV(JJ)+LM5(J,K)
	     LM6(J,K)=STEPV(JJ)+LM6(J,K)
	     LP(J,K)=STEPV(JJ)+LP(J,K)
	     LPE(J,K)=STEPV(JJ)+LPE(J,K)
	     LPI(J,K)=STEPV(JJ)+LPI(J,K)
	     LX(J,K)=STEPV(JJ)+LX(J,K)
	     LW(J,K)=STEPV(JJ)+LW(J,K)
	     LP1(J,K)=STEPV(JJ)+LP1(J,K)
	     LPE1(J,K)=STEPV(JJ)+LPE1(J,K)
	     LPI1(J,K)=STEPV(JJ)+LPI1(J,K)
	     LX1(J,K)=STEPV(JJ)+LX1(J,K)
	     LW1(J,K)=STEPV(JJ)+LW1(J,K)
	     LP2(J,K)=STEPV(JJ)+LP2(J,K)
	     LPE2(J,K)=STEPV(JJ)+LPE2(J,K)
	     LPI2(J,K)=STEPV(JJ)+LPI2(J,K)
	     LX2(J,K)=STEPV(JJ)+LX2(J,K)
	     LW2(J,K)=STEPV(JJ)+LW2(J,K)
	     LP3(J,K)=STEPV(JJ)+LP3(J,K)
	     LPE3(J,K)=STEPV(JJ)+LPE3(J,K)
	     LPI3(J,K)=STEPV(JJ)+LPI3(J,K)
	     LX3(J,K)=STEPV(JJ)+LX3(J,K)
	     LW3(J,K)=STEPV(JJ)+LW3(J,K)
	     LP4(J,K)=STEPV(JJ)+LP4(J,K)
	     LPE4(J,K)=STEPV(JJ)+LPE4(J,K)
	     LPI4(J,K)=STEPV(JJ)+LPI4(J,K)
	     LX4(J,K)=STEPV(JJ)+LX4(J,K)
	     LW4(J,K)=STEPV(JJ)+LW4(J,K)
	     LP5(J,K)=STEPV(JJ)+LP5(J,K)
	     LPE5(J,K)=STEPV(JJ)+LPE5(J,K)
	     LPI5(J,K)=STEPV(JJ)+LPI5(J,K)
	     LX5(J,K)=STEPV(JJ)+LX5(J,K)
	     LW5(J,K)=STEPV(JJ)+LW5(J,K)
	     LP6(J,K)=STEPV(JJ)+LP6(J,K)
	     LPE6(J,K)=STEPV(JJ)+LPE6(J,K)
	     LPI6(J,K)=STEPV(JJ)+LPI6(J,K)
	     LX6(J,K)=STEPV(JJ)+LX6(J,K)
	     LW6(J,K)=STEPV(JJ)+LW6(J,K)
 1200    CONTINUE
C
C U.S. MONEY SHOCK (IDTYPE=61)
C
	 IF (IDTYPE.EQ.61) THEN
	   WRITE(*,*) 'COUNTRY: UNITED STATES'
	 END IF
C
C JAPANESE MONETARY SHOCK: (IDTYPE=66)
C
	 IF (IDYPE.EQ.66) THEN
	   WRITE(*,*) 'COUNTRY: JAPAN'
	 END IF
C
       END IF
C
C *******************************************************************
C PERMANENT REDUCTION IN U.S. GOVERNMENT SPENDING (IDTYPE=7x)
C 3 PERCENT OF GNP 
C PHASED-IN OVER FIVE YEARS
C ANTICIPATED AND UNANTICIPATED
C *******************************************************************
C
C IDTYPE=71: TEMPORARY INCREASE OF 1% OF GDP
C            FOLLOWED BY DECREASE IN GOVERNMENT SPENDING REACHING
C            3% OF GDP AFTER TOTAL OF SIX YEARS
C IDTYPE=72: SAME AS 71 EXCEPT NO TEMPORARY STIMULUS
C IDTYPE=73: 3% PERMAMENT DECREASE IN GOVERNMENT SPENDING, PHASED
C            IN OVER 5 YEARS
C
      IF((IDTYPE.GT.70).AND.(IDTYPE.LT.80)) THEN
	 STEP=-DLOG(1.03D0)
	 IF(IDTYPE.EQ.71) THEN
	   DO 1310 J=NBEG,NBEG+3
	      DO 1310 K=2,4
		 G(J,K)=G(J,1)+0.01D0*Y(J,1)
 1310       CONTINUE
	 END IF
	 IF ((IDTYPE.EQ.71).OR.(IDTYPE.EQ.72)) THEN
	    DO 1311 J=NBEG+4,NBEG+24
	      DO 1311 K=2,4
	       G(J,K)=G(J,1)+DBLE(NBEG+4-J)*0.03D0*Y(J,1)/20.D0
 1311       CONTINUE
	 END IF
	 IF (IDTYPE.EQ.73) THEN
	    DO 1312 J=NBEG,NBEG+19
	      DO 1312 K=2,4
	       G(J,K)=G(J,1)+DBLE(NBEG-1-J)*0.03D0*Y(J,1)/20.D0
 1312       CONTINUE
	    DO 1313 J=NBEG+20,NBEG+24
	      DO 1313 K=2,4
	       G(J,K)=G(J,1)-0.03D0*Y(J,1)
 1313       CONTINUE
	 END IF
	 DO 1314 J=NBEG+25,NT
	   DO 1314 K=2,4
	     G(J,K)=G(J,1)-0.03D0*Y(J,1)
 1314    CONTINUE
	 DO 1315 K=2,4
	    DO 1315 J=NBEG+4,NT
	       LP(J,K)=STEP+LP(J,K)
	       LPE(J,K)=STEP+LPE(J,K)
	       LPI(J,K)=-STEP+LPI(J,K)
	       LX(J,K)=STEP+LX(J,K)
	       LW(J,K)=STEP+LW(J,K)
	       LE1(J,K)=-STEP+LE1(J,K)
	       LE2(J,K)=-STEP+LE2(J,K)
	       LE3(J,K)=-STEP+LE3(J,K)
	       LE4(J,K)=-STEP+LE4(J,K)
	       LE5(J,K)=-STEP+LE5(J,K)
	       LE6(J,K)=-STEP+LE6(J,K)
 1315    CONTINUE
      END IF
C
C *******************************************************************
C PERMANENT MONETARY STIMULUS (IDTYPE=8x)
C 1% OF BASELINE; UNANTICIPATED
C PHASED IN OVER ONE YEAR
C *******************************************************************
C      
      IF ( (IDTYPE.GT.80) .AND. (IDTYPE.LT.90) )THEN
C
	 WRITE(*,*) 'PHASED-IN 1% INCREASE IN MONEY SUPPLY.'
	 WRITE(*,*) 'FLEXIBLE EXCHANGE RATES.'
	 WRITE(*,*) 'INITIAL GUESSES/EXPECTATIONS ADJUSTED.'
	 STEPV(1)=DLOG(1.002D0)
	 STEPV(2)=DLOG(1.004D0)
	 STEPV(3)=DLOG(1.006D0)
	 STEPV(4)=DLOG(1.008D0)
	 STEPV(5)=DLOG(1.01D0)
C
C  G7 MONEY SHOCK, PHASED IN (IDTYPE=88)                               
C
C
C  U.S. MONEY SHOCK, PHASED IN (IDTYPE=81)                               
C
	 IF ((IDTYPE.EQ.81).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: UNITED STATES.'
	    DO 1510 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1510 K=2,4
		  LP(J,K)=STEPV(JJ)+LP(J,K)
		  LM(J,K)=STEPV(JJ)+LM(J,K)
		  LPE(J,K)=STEPV(JJ)+LPE(J,K)
		  LPI(J,K)=STEPV(JJ)+LPI(J,K)
		  LX(J,K)=STEPV(JJ)+LX(J,K)
		  LW(J,K)=STEPV(JJ)+LW(J,K)
		  LE1(J,K)=STEPV(JJ)+LE1(J,K)
		  LE2(J,K)=STEPV(JJ)+LE2(J,K)
		  LE3(J,K)=STEPV(JJ)+LE3(J,K)
		  LE4(J,K)=STEPV(JJ)+LE4(J,K)
		  LE5(J,K)=STEPV(JJ)+LE5(J,K)
		  LE6(J,K)=STEPV(JJ)+LE6(J,K)
 1510        CONTINUE
	 END IF
C
C  CANADIAN MONEY SHOCK, PHASED IN (IDTYPE=82)
C                                                                       
	 IF((IDTYPE.EQ.82).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: CANADA.'
	    DO 1520 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1520 K=2,4
		  LP1(J,K)=STEPV(JJ)+LP1(J,K)
		  LM1(J,K)=STEPV(JJ)+LM1(J,K)
		  LPE1(J,K)=STEPV(JJ)+LPE1(J,K)
		  LPI1(J,K)=STEPV(JJ)+LPI1(J,K)
		  LX1(J,K)=STEPV(JJ)+LX1(J,K)
		  LW1(J,K)=STEPV(JJ)+LW1(J,K)
		  LE1(J,K)=-STEPV(JJ)+LE1(J,K)
 1520        CONTINUE
	 END IF
C
C  FRENCH MONEY SHOCK, PHASED IN (IDTYPE=83)
C
	 IF((IDTYPE.EQ.83).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: FRANCE.'
	    DO 1530 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1530 K=2,4
		  LP2(J,K)=STEPV(JJ)+LP2(J,K)
		  LM2(J,K)=STEPV(JJ)+LM2(J,K)
		  LPE2(J,K)=STEPV(JJ)+LPE2(J,K)
		  LPI2(J,K)=STEPV(JJ)+LPI2(J,K)
		  LX2(J,K)=STEPV(JJ)+LX2(J,K)
		  LW2(J,K)=STEPV(JJ)+LW2(J,K)
		  LE2(J,K)=-STEPV(JJ)+LE2(J,K)
 1530        CONTINUE
	 END IF
C
C  GERMAN MONEY SHOCK, PHASED IN (IDTYPE=84)
C                                                                       
	 IF((IDTYPE.EQ.84).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: GERMANY.'
	    DO 1540 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1540 K=2,4
		  LP3(J,K)=STEPV(JJ)+LP3(J,K)
		  LM3(J,K)=STEPV(JJ)+LM3(J,K)
		  LPE3(J,K)=STEPV(JJ)+LPE3(J,K)
		  LPI3(J,K)=STEPV(JJ)+LPI3(J,K)
		  LX3(J,K)=STEPV(JJ)+LX3(J,K)
		  LW3(J,K)=STEPV(JJ)+LW3(J,K)
		  LE3(J,K)=-STEPV(JJ)+LE3(J,K)
 1540        CONTINUE
	 END IF
C
C  ITALIAN MONEY SHOCK, PHASED IN (IDTYPE=85)
C                                                                       
	 IF((IDTYPE.EQ.85).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: ITALY.'
	    DO 1550 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1550 K=2,4
		  LP4(J,K)=STEPV(JJ)+LP4(J,K)
		  LM4(J,K)=STEPV(JJ)+LM4(J,K)
		  LPE4(J,K)=STEPV(JJ)+LPE4(J,K)
		  LPI4(J,K)=STEPV(JJ)+LPI4(J,K)
		  LX4(J,K)=STEPV(JJ)+LX4(J,K)
		  LW4(J,K)=STEPV(JJ)+LW4(J,K)
		  LE4(J,K)=-STEPV(JJ)+LE4(J,K)
 1550        CONTINUE
	 END IF
C
C JAPANESE MONEY SHOCK, PHASED IN (IDTYPE=86)
C
	 IF((IDTYPE.EQ.86).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: JAPAN.'
	    DO 1560 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1560 K=2,4
		  LP5(J,K)=STEPV(JJ)+LP5(J,K)
		  LM5(J,K)=STEPV(JJ)+LM5(J,K)
		  LPE5(J,K)=STEPV(JJ)+LPE5(J,K)
		  LPI5(J,K)=STEPV(JJ)+LPI5(J,K)
		  LX5(J,K)=STEPV(JJ)+LX5(J,K)
		  LW5(J,K)=STEPV(JJ)+LW5(J,K)
		  LE5(J,K)=-STEPV(JJ)+LE5(J,K)
 1560        CONTINUE
	 END IF
C
C  U.K. MONEY SHOCK, PHASED IN (IDTYPE=87)
C
	 IF((IDTYPE.EQ.87).OR.(IDTYPE.EQ.88)) THEN
	    WRITE(*,*) 'COUNTRY: UNITED KINGDOM.'
	    DO 1570 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1570 K=2,4
		  LP6(J,K)=STEPV(JJ)+LP6(J,K)
		  LM6(J,K)=STEPV(JJ)+LM6(J,K)
		  LPE6(J,K)=STEPV(JJ)+LPE6(J,K)
		  LPI6(J,K)=STEPV(JJ)+LPI6(J,K)
		  LX6(J,K)=STEPV(JJ)+LX6(J,K)
		  LW6(J,K)=STEPV(JJ)+LW6(J,K)
		  LE6(J,K)=-STEPV(JJ)+LE6(J,K)
 1570        CONTINUE
	 END IF
C
      END IF
C
C **************************************************************
C PERMANENT UNANNOUNCED GOVERNMENT SPENDING SHOCK (IDTYPE=9x)
C 1 PERCENT OF GNP
C PHASED IN OVER ONE YEAR
C **************************************************************
C
      IF ( (IDTYPE.GT.90) .AND. (IDTYPE.LT.100)) THEN
C
	 WRITE(*,*) 'UNANNOUNCED INCREASE IN GOVERNMENT SPENDING.'
	 WRITE(*,*) 'INCREASE EQUAL TO ONE PERCENT OF BASELINE GDP.'
	 WRITE(*,*) 'PHASED IN OVER ONE YEAR.'
C
	 STEPV(1)=DLOG(1.002D0)
	 STEPV(2)=DLOG(1.004D0)
	 STEPV(3)=DLOG(1.006D0)
	 STEPV(4)=DLOG(1.008D0)
	 STEPV(5)=DLOG(1.01D0)
C
C IDTYPE 98: G7 POLICY
C
C  U.S. GOVERNMENT SPENDING SHOCK (IDTYPE=91)
C                                                                       
	 IF((IDTYPE.EQ.91).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: UNITED STATES.'
	    STEP=DLOG(1.003D0)
	    DO 1610 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1610 K=2,4
		  G(J,K)=G(J,K)+STEPV(JJ)*Y(J,1)
 1610        CONTINUE
	    DO 1611 K=2,4
	       DO 1611 J=NBEG,NT
		  LP(J,K)=STEP+LP(J,K)
		  LPE(J,K)=STEP+LPE(J,K)
		  LPI(J,K)=-STEP+LPI(J,K)
		  LX(J,K)=STEP+LX(J,K)
		  LW(J,K)=STEP+LW(J,K)
		  LE1(J,K)=-STEP+LE1(J,K)
		  LE2(J,K)=-STEP+LE2(J,K)
		  LE3(J,K)=-STEP+LE3(J,K)
		  LE4(J,K)=-STEP+LE4(J,K)
		  LE5(J,K)=-STEP+LE5(J,K)
		  LE6(J,K)=-STEP+LE6(J,K)
 1611        CONTINUE
	 END IF
C
C  CANADIAN GOVERNMENT SPENDING SHOCK (IDTYPE=92)
C                                                                       
	 IF((IDTYPE.EQ.92).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: CANADA.'
	    STEP=DLOG(1.0067D0)
	    DO 1620 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1620 K=2,4
		  G1(J,K)=G1(J,K)+STEPV(JJ)*Y1(J,1)
 1620        CONTINUE
	    DO 1621 K=2,4
	       DO 1621 J=NBEG,NT
		  LP1(J,K)=STEP+LP1(J,K)
		  LPE1(J,K)=STEP+LPE1(J,K)
		  LPI1(J,K)=-STEP+LPI1(J,K)
		  LX1(J,K)=STEP+LX1(J,K)
		  LW1(J,K)=STEP+LW1(J,K)
		  LE1(J,K)=STEP+LE1(J,K)
 1621       CONTINUE
	 END IF
C
C  FRENCH GOVERNMENT SPENDING SHOCK (IDTYPE=93)
C                                                                       
	 IF((IDTYPE.EQ.93).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: FRANCE.'
	    STEP=DLOG(1.003D0)
	    DO 1630 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1630 K=2,4
		  G2(J,K)=G2(J,K)+STEPV(JJ)*Y2(J,1)
 1630       CONTINUE
	    DO 1631 K=2,4
	       DO 1631 J=NBEG,NT
		  LP2(J,K)=STEP+LP2(J,K)
		  LPE2(J,K)=STEP+LPE2(J,K)
		  LPI2(J,K)=-STEP+LPI2(J,K)
		  LX2(J,K)=STEP+LX2(J,K)
		  LW2(J,K)=STEP+LW2(J,K)
		  LE2(J,K)=STEP+LE2(J,K)
 1631       CONTINUE
	 END IF
C
C  GERMAN GOVERNMENT SPENDING SHOCK (IDTYPE=94)
C                                                                       
	 IF((IDTYPE.EQ.94).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: GERMANY.'
	    STEP=DLOG(1.003D0)
	    DO 1640 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1640 K=2,4
		  G3(J,K)=G3(J,K)+STEPV(JJ)*Y3(J,1)
 1640        CONTINUE
	    DO 1641 K=2,4
	       DO 1641 J=NBEG,NT
		  LP3(J,K)=STEP+LP3(J,K)
		  LPE3(J,K)=STEP+LPE3(J,K)
		  LPI3(J,K)=-STEP+LPI3(J,K)
		  LX3(J,K)=STEP+LX3(J,K)
		  LW3(J,K)=STEP+LW3(J,K)
		  LE3(J,K)=STEP+LE3(J,K)
 1641       CONTINUE
	 END IF
C
C  ITALIAN GOVERNMENT SPENDING SHOCK (IDTYPE=95)
C                                                                       
	 IF((IDTYPE.EQ.95).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: ITALY.'
	    STEP=DLOG(1.01D0)
	    DO 1650 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1650 K=2,4
		  G4(J,K)=G4(J,K)+STEPV(JJ)*Y4(J,1)
 1650        CONTINUE
	    DO 1651 K=2,4
	       DO 1651 J=NBEG,NT
		  LP4(J,K)=STEP+LP4(J,K)
		  LPE4(J,K)=STEP+LPE4(J,K)
		  LPI4(J,K)=-STEP+LPI4(J,K)
		  LX4(J,K)=STEP+LX4(J,K)
		  LW4(J,K)=STEP+LW4(J,K)
		  LE4(J,K)=STEP+LE4(J,K)
 1651       CONTINUE
	 END IF
C                                                                       
C  JAPANESE GOVERNMENT SPENDING SHOCK (IDTYPE=96)
C                                                                       
	 IF((IDTYPE.EQ.96).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: JAPAN.'
	    STEP=DLOG(1.0067D0)
	    DO 1660 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1660 K=2,4
		  G5(J,K)=G5(J,K)+STEPV(JJ)*Y5(J,1)
 1660       CONTINUE
	    DO 1661 K=2,4
	       DO 1661 J=NBEG,NT
		  LP5(J,K)=STEP+LP5(J,K)
		  LPE5(J,K)=STEP+LPE5(J,K)
		  LPI5(J,K)=-STEP+LPI5(J,K)
		  LX5(J,K)=STEP+LX5(J,K)
		  LW5(J,K)=STEP+LW5(J,K)
		  LE5(J,K)=STEP+LE5(J,K)
 1661       CONTINUE
	 END IF
C
C  U.K. GOVERNMENT SPENDING SHOCK (IDTYPE=97)
C                                                                       
	 IF((IDTYPE.EQ.97).OR.(IDTYPE.EQ.98)) THEN
	    WRITE(*,*) 'COUNTRY: UNITED KINGDOM.'
	    STEP=DLOG(1.0167D0)
	    DO 1670 J=NBEG,NT
	       JJ=J+1-NBEG
	       IF (JJ.GE.5) JJ=5
	       DO 1670 K=2,4
		  G6(J,K)=G6(J,K)+STEPV(JJ)*Y6(J,1)
 1670       CONTINUE
	    DO 1671 K=2,4
	       DO 1671 J=NBEG,NT
		  LP6(J,K)=STEP+LP6(J,K)
		  LPE6(J,K)=STEP+LPE6(J,K)
		  LPI6(J,K)=-STEP+LPI6(J,K)
		  LX6(J,K)=STEP+LX6(J,K)
		  LW6(J,K)=STEP+LW6(J,K)
		  LE6(J,K)=STEP+LE6(J,K)
 1671       CONTINUE
	 END IF
C
      END IF
C
C  CALL SOLVE TO INITIATE EXTENDED PATH SOLUTION ALGORITHM
C
      WRITE(*,*) ' '
      WRITE(*,*) 'SIMULATION 1 OF ',NSIMLS,'.'
      WRITE(*,*) ' '
      CALL SOLVE(S)
C
C  CALL PRINTOUT TO PRINT OUTPUT TO LOTUS READABLE FILE
C
      CALL PRINTF
C
      RETURN                                                            
      END
C
C  *********************************************************************
C  SUBROUTINE SOLVE                                                     
C  *********************************************************************    
C
C  THIS SUBROUTINE CALCULATES THE SOLUTION OF THE DESIRED SIMULATION
C  (GIVEN A SET OF VALUES FOR THE COEFFICIENTS).                        
C  EST = ESTIMATED COEFFICIENTS IN MODEL                                
C  NEST = # ESTIMATED COEFFICIENTS IN MODEL                             
C  THE SUBSCRIPTS (OR ARRAY RANGES) FOR EACH OF THE VARIABLES USED IN   
C  THE MODEL ARE J=1,..,NT AND N=1,..,5,  WHERE NT IS THE TOTAL NUMBER  
C  OF TIME PERIODS FOR WHICH DATA IS AVAILABLE AND N IS GIVEN AS        
C  FOLLOWS:                                                             
C
C     IF N=1 , THEN THE VECTOR WITH ELEMENTS Z(J,N), J=1,..NT IS THE
C              ACTUAL DATA.                                             
C     IF N=2,  THEN Z(J,N) IS THE DATA FROM THE PREVIOUS GAUSS-SEIDEL   
C              ITERATION, J=1,..,NFUT+H.                                
C     IF N=3,  THEN Z(J,N) IS THE DATA FOR THE CURRENT GAUSS-SEIDEL     
C              ITERATION, J=1,..,NFUT+H.                                
C     IF N=4,  THEN Z(J,N) IS THE DATA HELD FOR A TYPE II ITERATION,    
C              J=1,I+H  AND Z BEING A SUBSET OF ALL VARIABLES. (THESE   
C              VARIABLES ARE CALLED `EXPECTATION VARIABLES'.)           
C     IF N=5,  THEN THE EXPECTATION VARIABLE Z(J,N) IS THE DATA HELD    
C              FOR A TYPE III ITERATION, J=1,I+H.                       
C                                                                       
      SUBROUTINE SOLVE(S)
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)                              
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3,H=8)
      DOUBLE PRECISION ZE(NT,NE*N),ZO(NT,NO*N)
      DOUBLE PRECISION YQ(NT)
      DOUBLE PRECISION PARG(0:6,2)
      DOUBLE PRECISION VCOV(NE,NE),S(NE,NT),SH(NE,NT)
      DOUBLE PRECISION COEF(NCOEFL,NCOEFS),U1(NT,6)
      LOGICAL PASS1,PASS2,PAST2,PASS3           
      DOUBLE PRECISION PSI(0:6,0:MAXLAG),PHI(0:6,0:MAXLAG),
     X  PSI5(NT,0:MAXLAG),PHI5(NT,0:MAXLAG),DELTA(0:6,NT),GAMMA(0:6)
      DOUBLE PRECISION YGAP(NT,4),YGAP1(NT,4),NORM(NE,NT),
     X YGAP2(NT,4),YGAP3(NT,4),YGAP4(NT,4),YGAP5(NT,4),YGAP6(NT,4)
      INTEGER NEADD(0:5)                      
      DOUBLE PRECISION RS(NT,N),RS1(NT,N),RS2(NT,N),RS3(NT,N),
     X RS4(NT,N),RS5(NT,N),RS6(NT,N),E1(NT,N),E2(NT,N),E3(NT,N),
     X E4(NT,N),E5(NT,N),E6(NT,N),RL(NT,N),RL1(NT,N),RL2(NT,N),
     X RL3(NT,N),RL4(NT,N),RL5(NT,N),RL6(NT,N),CD(NT,N),CN(NT,N),
     X CS(NT,N),CD1(NT,N),CN1(NT,N),CS1(NT,N),CD2(NT,N),CN2(NT,N),
     X CS2(NT,N),C3(NT,N),C4(NT,N),CD5(NT,N),CN5(NT,N),CS5(NT,N),
     X CD6(NT,N),CN6(NT,N),CS6(NT,N),INE(NT,N),INS(NT,N),IR(NT,N),
     X II(NT,N),IF1(NT,N),II1(NT,N),IN2(NT,N),IR2(NT,N),II2(NT,N),
     X IF3(NT,N),II3(NT,N),IF4(NT,N),II4(NT,N),IN5(NT,N),IR5(NT,N),
     X II5(NT,N),IN6(NT,N),IR6(NT,N),II6(NT,N),EX(NT,N)
      DOUBLE PRECISION EX1(NT,N),EX2(NT,N),EX3(NT,N),EX4(NT,N),
     X EX5(NT,N),EX6(NT,N),IM(NT,N),IM1(NT,N),IM2(NT,N),IM3(NT,N),
     X IM4(NT,N),IM5(NT,N),IM6(NT,N),Y(NT,N),Y1(NT,N),Y2(NT,N),Y3(NT,N),
     X Y4(NT,N),Y5(NT,N),Y6(NT,N),X(NT,N),X1(NT,N),X2(NT,N),X3(NT,N),
     X X4(NT,N),X5(NT,N),X6(NT,N),W(NT,N),W1(NT,N),W2(NT,N),W3(NT,N),
     X W4(NT,N),W5(NT,N),W6(NT,N),P(NT,N),P1(NT,N),P2(NT,N),P3(NT,N),
     X P4(NT,N),P5(NT,N),P6(NT,N)
      DOUBLE PRECISION PI(NT,N),PI1(NT,N),PI2(NT,N),PI3(NT,N),PI4(NT,N),
     X PI5(NT,N),PI6(NT,N),PE(NT,N),PE1(NT,N),PE2(NT,N),PE3(NT,N),
     X PE4(NT,N),PE5(NT,N),PE6(NT,N),M(NT,N),M1(NT,N),M2(NT,N),M3(NT,N),
     X M4(NT,N),M5(NT,N),M6(NT,N),G(NT,N),G1(NT,N),G2(NT,N),G3(NT,N),
     X G4(NT,N),G5(NT,N),G6(NT,N),T(NT),TT(NT),
     X LE1(NT,N),LE2(NT,N),LE3(NT,N),LE4(NT,N),LE5(NT,N),
     X LE6(NT,N),LEX(NT,N),LEX1(NT,N),LEX2(NT,N),LEX3(NT,N),
     X LEX4(NT,N),LEX5(NT,N),LEX6(NT,N),LIM(NT,N),LIM1(NT,N),
     X LIM2(NT,N),LIM3(NT,N),LIM4(NT,N),LIM5(NT,N),LIM6(NT,N),
     X LX(NT,N),LX1(NT,N),LX2(NT,N),LX3(NT,N),LX4(NT,N),
     X LX5(NT,N),LX6(NT,N),LW(NT,N),LW1(NT,N),LW2(NT,N),
     X LW3(NT,N),LW4(NT,N),LW5(NT,N),LW6(NT,N),LP(NT,N),
     X LP1(NT,N),LP2(NT,N),LP3(NT,N),LP4(NT,N),LP5(NT,N),
     X LP6(NT,N),LPI(NT,N),LPI1(NT,N),LPI2(NT,N),LPI3(NT,N),
     X LPI4(NT,N),LPI5(NT,N),LPI6(NT,N),LPE(NT,N),LPE1(NT,N),
     X LPE2(NT,N),LPE3(NT,N),LPE4(NT,N),LPE5(NT,N),LPE6(NT,N),
     X LM(NT,N),LM1(NT,N),LM2(NT,N),LM3(NT,N),LM4(NT,N),LM5(NT,N),
     X LM6(NT,N),LMW(NT,N)
C
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /VARS/ COEF
      COMMON /WAGE/ PSI,PHI,PSI5,PHI5,DELTA,GAMMA
      COMMON /Z/ ZE,ZO
      COMMON /SCALE/ SCALE1,SCALE2
      COMMON /PAR/ PARG
      COMMON /SHOCKS/ VCOV,SH
C
      EQUIVALENCE (ZE(1,1),RS),(ZE(1,6),RS1),(ZE(1,11),RS2),            
     X       (ZE(1,16),RS3),(ZE(1,21),RS4),(ZE(1,26),RS5),(ZE(1,31),    
     X       RS6),(ZE(1,36),LE1),(ZE(1,41),LE2),(ZE(1,46),LE3),         
     X       (ZE(1,51),LE4),(ZE(1,56),LE5),(ZE(1,61),LE6),              
     X       (ZE(1,66),RL),(ZE(1,71),RL1),(ZE(1,76),RL2),(ZE(1,81),     
     X       RL3),(ZE(1,86),RL4),(ZE(1,91),RL5),(ZE(1,96),RL6),         
     X       (ZE(1,101),CD),(ZE(1,106),CN),(ZE(1,111),CS),(ZE(1,116),   
     X       CD1),(ZE(1,121),CN1),(ZE(1,126),CS1),(ZE(1,131),CD2),      
     X       (ZE(1,136),CN2),(ZE(1,141),CS2),(ZE(1,146),C3),(ZE(1,151), 
     X       C4),(ZE(1,156),CD5),(ZE(1,161),CN5),(ZE(1,166),CS5),       
     X       (ZE(1,171),CD6),(ZE(1,176),CN6),(ZE(1,181),CS6),           
     X       (ZE(1,186),INE),(ZE(1,191),INS),(ZE(1,196),IR),(ZE(1,201), 
     X       II),(ZE(1,206),IF1),(ZE(1,211),II1),(ZE(1,216),IN2),       
     X       (ZE(1,221),IR2),(ZE(1,226),II2),(ZE(1,231),IF3),           
     X       (ZE(1,236),II3),(ZE(1,241),IF4),(ZE(1,246),II4),           
     X       (ZE(1,251),IN5),(ZE(1,256),IR5),(ZE(1,261),II5),           
     X       (ZE(1,266),IN6),(ZE(1,271),IR6),(ZE(1,276),II6),           
     X       (ZE(1,281),LEX),(ZE(1,286),LEX1),(ZE(1,291),LEX2),         
     X       (ZE(1,296),LEX3),(ZE(1,301),LEX4),(ZE(1,306),LEX5),        
     X       (ZE(1,311),LEX6),(ZE(1,316),LIM),(ZE(1,321),LIM1)          
      EQUIVALENCE (ZE(1,326),LIM2),(ZE(1,331),LIM3),(ZE(1,336),LIM4),   
     X       (ZE(1,341),LIM5),(ZE(1,346),LIM6),                         
     X       (ZE(1,351),Y),(ZE(1,356),Y1),(ZE(1,361),Y2),(ZE(1,366),    
     X       Y3),(ZE(1,371),Y4),(ZE(1,376),Y5),(ZE(1,381),Y6),          
     X       (ZE(1,386),LX),(ZE(1,391),LX1),(ZE(1,396),LX2),(ZE(1,401), 
     X       LX3),(ZE(1,406),LX4),(ZE(1,411),LX5),(ZE(1,416),LX6),      
     X       (ZE(1,421),LW),(ZE(1,426),LW1),(ZE(1,431),LW2),(ZE(1,436), 
     X       LW3),(ZE(1,441),LW4),(ZE(1,446),LW5),(ZE(1,451),LW6),      
     X       (ZE(1,456),LP),(ZE(1,461),LP1),(ZE(1,466),LP2),(ZE(1,471), 
     X       LP3),(ZE(1,476),LP4),(ZE(1,481),LP5),(ZE(1,486),LP6),      
     X       (ZE(1,491),LPI),(ZE(1,496),LPI1),(ZE(1,501),LPI2),         
     X       (ZE(1,506),LPI3),(ZE(1,511),LPI4),(ZE(1,516),LPI5),        
     X       (ZE(1,521),LPI6),(ZE(1,526),LPE),(ZE(1,531),LPE1),         
     X       (ZE(1,536),LPE2),(ZE(1,541),LPE3),(ZE(1,546),LPE4),        
     X       (ZE(1,551),LPE5),(ZE(1,556),LPE6)                          
      EQUIVALENCE (ZO(1,1),LM),(ZO(1,6),LM1),(ZO(1,11),LM2),
     X (ZO(1,16),LM3),(ZO(1,21),LM4),(ZO(1,26),LM5),(ZO(1,31),LM6),         
     X       (ZO(1,36),G),(ZO(1,41),G1),(ZO(1,46),G2),(ZO(1,51),G3),    
     X       (ZO(1,56),G4),(ZO(1,61),G5),(ZO(1,66),G6),(ZO(1,71),T),    
     X       (ZO(1,76),TT),(ZO(1,81),E1),(ZO(1,86),E2),(ZO(1,91),E3),   
     X       (ZO(1,96),E4),(ZO(1,101),E5),(ZO(1,106),E6),               
     X       (ZO(1,111),EX),(ZO(1,116),EX1),(ZO(1,121),EX2),            
     X       (ZO(1,126),EX3),(ZO(1,131),EX4),(ZO(1,136),EX5),           
     X       (ZO(1,141),EX6),(ZO(1,146),IM),(ZO(1,151),IM1),            
     X       (ZO(1,156),IM2),(ZO(1,161),IM3),(ZO(1,166),IM4),           
     X       (ZO(1,171),IM5),(ZO(1,176),IM6),                           
     X       (ZO(1,181),X),(ZO(1,186),X1),(ZO(1,191),X2),(ZO(1,196),    
     X       X3),(ZO(1,201),X4),(ZO(1,206),X5),(ZO(1,211),X6),          
     X       (ZO(1,216),W),(ZO(1,221),W1),(ZO(1,226),W2),(ZO(1,231),
     X       W3),(ZO(1,236),W4),(ZO(1,241),W5),(ZO(1,246),W6),          
     X       (ZO(1,251),P),(ZO(1,256),P1),(ZO(1,261),P2),(ZO(1,266),    
     X       P3),(ZO(1,271),P4),(ZO(1,276),P5),(ZO(1,281),P6),          
     X       (ZO(1,286),PI),(ZO(1,291),PI1),(ZO(1,296),PI2),(ZO(1,301), 
     X       PI3),(ZO(1,306),PI4),(ZO(1,311),PI5),(ZO(1,316),PI6)       
      EQUIVALENCE (ZO(1,321),PE),(ZO(1,326),PE1),(ZO(1,331),PE2),       
     X       (ZO(1,336),PE3),(ZO(1,341),PE4),(ZO(1,346),PE5),(ZO(1,351),
     X       PE6),(ZO(1,356),M),(ZO(1,361),M1),(ZO(1,366),M2),          
     X       (ZO(1,371),M3),(ZO(1,376),M4),(ZO(1,381),M5),(ZO(1,386),   
     X       M6),(ZO(1,391),LMW)
C                                                                       
C  NEADD= NO. OF EQUATIONS BEYOND 112 ADDED TO THE MODEL.               
C     
      WRITE(*,*) 'BEGINNING EXTENDED-PATH ALGORITHM.'                     
C
      NEADD(0)=0                                                        
      NEADD(1)=1                                                        
      NEADD(2)=7                                                        
      NEADD(4)=6                                                        
C
C  SET NORMALIZATION TERMS 
C
      DO 40 I=1,20                                                     
	DO 40 J=1,NT                                                   
	  NORM(J,I)=1.0D0
  40  CONTINUE                                                          
C                                                                       
      DO 50 I=21,77                                                     
	DO 50 J=1,NT                                                    
	  NORM(J,I)=ZE(J,5*I-4)                                         
  50  CONTINUE                                                          
C  
      DO 60 I=78,NE                                                     
	DO 60 J=1,NT                                                    
	  NORM(J,I)=1.0D0
  60  CONTINUE                                                          
C
      DO 70 J=1,NT                                                    
	  IF((I.EQ.41).OR.(I.EQ.43).OR.(I.EQ.46).OR.(I.EQ.48).OR.       
     X    (I.EQ.50).OR.(I.EQ.53).OR.(I.EQ.56)) NORM(J,I)=1.0D0
  70  CONTINUE                                                          
C
C  SET U1'S TO ZERO
C
      DO 75 I=1,NT
	 DO 75 J=1,6
	    U1(I,J) = 0.0D0
   75 CONTINUE
C
C   THE PERIOD BEING SOLVED IS NBEG...NEND.                             
C
C  I   :  PERIOD BEING SOLVED FOR
C  NFUT:  TRUNCATION POINT FOR TYPE II ITERATION
C  K   :  NUMBER OF TYPE II ITERATION
C  L   :  NUMBER OF TYPE I ITERATION
C  J   :  CURRENT PERIOD OF TYPE I ITERATION
C
      DO 130 I=NBEG,NEND                                                
	 PAST2=.TRUE.
C IF THE SIMULATION IS STOCHASTIC, THEN
C AT THE BEGINNING OF THE SOLUTION PROCESS FOR EACH PERIOD I,
C UPDATE RESIDUALS TO INCLUDE STOCHASTIC SHOCKS
C ALSO, UPDATE AR1(0.5) U1 PROCESS 
C 
	 IF (ISTOCH.EQ.1) THEN
	    DO 132 JJ=1,NE
	       IF((JJ.LE.7).OR.(JJ.GE.14)) THEN
		  S(JJ,I)=S(JJ,I)+SH(JJ,I-NBEG+1)
	       ELSE
		  U1(I,JJ-7)=0.5D0*U1(I-1,JJ-7)+SH(JJ,I-NBEG+1)
		  DO 131 IJ=I+1,NT
		     U1(IJ,JJ-7)=0.5D0*U1(IJ-1,JJ-7)
 131              CONTINUE
	       END IF
  132       CONTINUE           
	 END IF     
C                                                                       
C TYPE III LOOP BEGINS HERE:         
C NFUT IS THE END POINT OF THE TYPE II ITERATIONS
C THE INITIAL VALUE OF NFUT, NFUT1, IS GIVEN BY THE USER;
C THE SECOND (AND FINAL) VALUE OF NFUT, NFUT2, EQUALS NFUT1+1
C                                                                             
	 DO 140 NFUT = NFUT1,NFUT2
	   PASS3 = .TRUE.
C                                                                       
C WITHIN EACH TYPE III ITERATION LOOP, PERFORM TYPE II ITERATIONS      
C TO UPDATE EXPECTATIONS (INDEXED BY 3) OF ENDOGENOUS VARIABLES.
C WITHIN EACH TYPE II ITERATION, SOLVE THE MODEL DYNAMICALLY USING 
C THE GAUSS-SEIDEL ALGORITHM.
C
C K INDEXES THE NUMBER OF THE TYPE II ITERATION
C L INDEXES THE NUMBER OF THE TYPE I ITERATION
C J INDEXES THE TIME PERIOD, RUNNING FROM I TO I+NFUT
C
	  DO 160 K=1,MAXIT2
	    WRITE(*,*) 'K = ',K
	    PASS2 = .TRUE.                                             
	    DO 170 L=1,MAXIT1
	      PASS1 = .TRUE.                                           
	      DO 180 J=I,I+NFUT
C
C COMPUTE WEIGTHED EXCHANGE RATES DEVIATIONS FROM BASELINE
C FOR EACH COUNTRY
C
       WNE=   0.091*(LE1(J,2))+0.175*(LE2(J,2))                         
     X       +0.265*(LE3(J,2))+0.123*(LE4(J,2))                         
     X       +0.189*(LE5(J,2))+0.157*(LE6(J,2))                         
     X      -(0.091*(LE1(J,1))+0.175*(LE2(J,1))                         
     X       +0.265*(LE3(J,1))+0.123*(LE4(J,1))                         
     X       +0.189*(LE5(J,1))+0.157*(LE6(J,1)))                        
       WNE1=  -LE1(J,2) +0.141*(LE2(J,2))                               
     X       +0.213*(LE3(J,2))+0.099*(LE4(J,2))                         
     X       +0.152*(LE5(J,2))+0.127*(LE6(J,2))                         
     X       -(-LE1(J,1) +0.141*(LE2(J,1))                              
     X       +0.213*(LE3(J,1))+0.099*(LE4(J,1))                         
     X       +0.152*(LE5(J,1))+0.127*(LE6(J,1)))
	WNE2=  -LE2(J,2) +0.079*(LE1(J,2))
     X       +0.229*(LE3(J,2))+0.106*(LE4(J,2))
     X       +0.163*(LE5(J,2))+0.136*(LE6(J,2))
     X      -(-LE2(J,1) +0.079*(LE1(J,1))
     X       +0.229*(LE3(J,1))+0.106*(LE4(J,1))
     X       +0.163*(LE5(J,1))+0.136*(LE6(J,1)))
	WNE3= -LE3(J,2) +0.085*(LE1(J,2))
     X       +0.164*(LE2(J,2))+0.116*(LE4(J,2))
     X       +0.177*(LE5(J,2))+0.147*(LE6(J,2))
     X      -(-LE3(J,1) +0.085*(LE1(J,1))
     X       +0.164*(LE2(J,1))+0.116*(LE4(J,1))
     X       +0.177*(LE5(J,1))+0.147*(LE6(J,1)))
	WNE4=  -LE4(J,2) +0.075*(LE1(J,2))
     X       +0.145*(LE2(J,2))+0.219*(LE3(J,2))
     X       +0.156*(LE5(J,2))+0.130*(LE6(J,2))
     X      -(-LE4(J,1) +0.075*(LE1(J,1))
     X       +0.145*(LE2(J,1))+0.219*(LE3(J,1))
     X       +0.156*(LE5(J,1))+0.130*(LE6(J,1)))
	WNE5=  -LE5(J,2) +0.079*(LE1(J,2))
     X       +0.153*(LE2(J,2))+0.232*(LE3(J,2))
     X       +0.108*(LE4(J,2))+0.137*(LE6(J,2))
     X      -( -LE5(J,1) +0.079*(LE1(J,1))
     X       +0.153*(LE2(J,1))+0.232*(LE3(J,1))
     X       +0.108*(LE4(J,1))+0.137*(LE6(J,1)))
	WNE6=  -LE6(J,2) +0.077*(LE1(J,2))
     X       +0.149*(LE2(J,2))+0.225*(LE3(J,2))
     X       +0.105*(LE4(J,2))+0.161*(LE5(J,2))
     X      -(-LE6(J,1) +0.077*(LE1(J,1))
     X       +0.149*(LE2(J,1))+0.225*(LE3(J,1))
     X       +0.105*(LE4(J,1))+0.161*(LE5(J,1)))
C
C COMPUTE WEIGHTED PRICE DEVIATION IN DOLLARS FROM BASELINE
C
       WRE=   0.091*(LP1(J,2)+LE1(J,2))+0.175*(LP2(J,2)+LE2(J,2))
     X       +0.265*(LP3(J,2)+LE3(J,2))+0.123*(LP4(J,2)+LE4(J,2))
     X       +0.189*(LP5(J,2)+LE5(J,2))+0.157*(LP6(J,2)+LE6(J,2))
     X      -(0.091*(LP1(J,1)+LE1(J,1))+0.175*(LP2(J,1)+LE2(J,1))
     X       +0.265*(LP3(J,1)+LE3(J,1))+0.123*(LP4(J,1)+LE4(J,1))
     X       +0.189*(LP5(J,1)+LE5(J,1))+0.157*(LP6(J,1)+LE6(J,1)))
	WRE1= 0.268*LP(J,2)  -LE1(J,2) +0.141*(LP2(J,2)+LE2(J,2))
     X       +0.213*(LP3(J,2)+LE3(J,2))+0.099*(LP4(J,2)+LE4(J,2))
     X       +0.152*(LP5(J,2)+LE5(J,2))+0.127*(LP6(J,2)+LE6(J,2))
     X      -(0.268*LP(J,1)  -LE1(J,1) +0.141*(LP2(J,1)+LE2(J,1))
     X       +0.213*(LP3(J,1)+LE3(J,1))+0.099*(LP4(J,1)+LE4(J,1))
     X       +0.152*(LP5(J,1)+LE5(J,1))+0.127*(LP6(J,1)+LE6(J,1)))
	WRE2= 0.287*LP(J,2)  -LE2(J,2) +0.079*(LP1(J,2)+LE1(J,2))
     X       +0.229*(LP3(J,2)+LE3(J,2))+0.106*(LP4(J,2)+LE4(J,2))
     X       +0.163*(LP5(J,2)+LE5(J,2))+0.136*(LP6(J,2)+LE6(J,2))
     X      -(0.287*LP(J,1)  -LE2(J,1) +0.079*(LP1(J,1)+LE1(J,1))
     X       +0.229*(LP3(J,1)+LE3(J,1))+0.106*(LP4(J,1)+LE4(J,1))
     X       +0.163*(LP5(J,1)+LE5(J,1))+0.136*(LP6(J,1)+LE6(J,1)))
	WRE3= 0.311*LP(J,2)  -LE3(J,2) +0.085*(LP1(J,2)+LE1(J,2))
     X       +0.164*(LP2(J,2)+LE2(J,2))+0.116*(LP4(J,2)+LE4(J,2))
     X       +0.177*(LP5(J,2)+LE5(J,2))+0.147*(LP6(J,2)+LE6(J,2))
     X      -(0.311*LP(J,1)  -LE3(J,1) +0.085*(LP1(J,1)+LE1(J,1))       
     X       +0.164*(LP2(J,1)+LE2(J,1))+0.116*(LP4(J,1)+LE4(J,1))       
     X       +0.177*(LP5(J,1)+LE5(J,1))+0.147*(LP6(J,1)+LE6(J,1)))      
	WRE4= 0.275*LP(J,2)  -LE4(J,2) +0.075*(LP1(J,2)+LE1(J,2))       
     X       +0.145*(LP2(J,2)+LE2(J,2))+0.219*(LP3(J,2)+LE3(J,2))       
     X       +0.156*(LP5(J,2)+LE5(J,2))+0.130*(LP6(J,2)+LE6(J,2))       
     X      -(0.275*LP(J,1)  -LE4(J,1) +0.075*(LP1(J,1)+LE1(J,1))       
     X       +0.145*(LP2(J,1)+LE2(J,1))+0.219*(LP3(J,1)+LE3(J,1))       
     X       +0.156*(LP5(J,1)+LE5(J,1))+0.130*(LP6(J,1)+LE6(J,1)))      
	WRE5= 0.291*LP(J,2)  -LE5(J,2) +0.079*(LP1(J,2)+LE1(J,2))       
     X       +0.153*(LP2(J,2)+LE2(J,2))+0.232*(LP3(J,2)+LE3(J,2))       
     X       +0.108*(LP4(J,2)+LE4(J,2))+0.137*(LP6(J,2)+LE6(J,2))       
     X      -(0.291*LP(J,1)  -LE5(J,1) +0.079*(LP1(J,1)+LE1(J,1))       
     X       +0.153*(LP2(J,1)+LE2(J,1))+0.232*(LP3(J,1)+LE3(J,1))       
     X       +0.108*(LP4(J,1)+LE4(J,1))+0.137*(LP6(J,1)+LE6(J,1)))      
	WRE6= 0.283*LP(J,2)  -LE6(J,2) +0.077*(LP1(J,2)+LE1(J,2))       
     X       +0.149*(LP2(J,2)+LE2(J,2))+0.225*(LP3(J,2)+LE3(J,2))       
     X       +0.105*(LP4(J,2)+LE4(J,2))+0.161*(LP5(J,2)+LE5(J,2))       
     X      -(0.283*LP(J,1)  -LE6(J,1) +0.077*(LP1(J,1)+LE1(J,1))       
     X       +0.149*(LP2(J,1)+LE2(J,1))+0.225*(LP3(J,1)+LE3(J,1))       
     X       +0.105*(LP4(J,1)+LE4(J,1))+0.161*(LP5(J,1)+LE5(J,1)))
C
C EEMS IS A WEIGHTED AVERAGE OF PRICE DEVIATIONS (IN DOLLARS)FROM 
C BASELINE AMONG THE EMS COUNTRIES (FRANCE,GERMANY,ITALY,U.K.)
C
      EEMS=.20*WRE2+.20*WRE4+.40*WRE3+.20*WRE6                          
C
C YW (PW,EPW) IS A WEIGHTED AVERAGE OF NOMINAL OUTPUT
C (PRICE, INFLATION) DEVIATIONS FROM BASELINE
C
      PW=.20*(LP(J,2)-LP(J,1))+.05*(LP1(J,2)-LP1(J,1))+.05*             
     X (LP2(J,2)-LP2(J,1))+.05*(LP4(J,2)-LP4(J,1))+.10*                 
     X (LP3(J,2)-LP3(J,1))+.05*(LP6(J,2)-LP6(J,1))+.50*                 
     X (LP5(J,2)-LP5(J,1))                             
C    
      EPW=.20*(LP(J+4,4)-LP(J,2)-LP(J+4,1)+LP(J,1))+                    
     X    .05*(LP1(J+4,4)-LP1(J,2)-LP1(J+4,1)+LP1(J,1))+                
     X    .05*(LP2(J+4,4)-LP2(J,2)-LP2(J+4,1)+LP2(J,1))+                
     X    .10*(LP3(J+4,4)-LP3(J,2)-LP3(J+4,1)+LP3(J,1))+                
     X    .05*(LP4(J+4,4)-LP4(J,2)-LP4(J+4,1)+LP4(J,1))+                
     X    .50*(LP5(J+4,4)-LP5(J,2)-LP5(J+4,1)+LP5(J,1))+
     X    .05*(LP6(J+4,4)-LP6(J,2)-LP6(J+4,1)+LP6(J,1))
C
      YW=.20*(LP(J,2)-LP(J,1))+.05*(LP1(J,2)-LP1(J,1))+.05*
     X (LP2(J,2)-LP2(J,1))+.05*(LP4(J,2)-LP4(J,1))+.10*
     X (LP3(J,2)-LP3(J,1))+.05*(LP6(J,2)-LP6(J,1))+.50*
     X (LP5(J,2)-LP5(J,1))+.20*(DLOG(Y(J,2)/Y(J,1)))+.05*
     X (DLOG(Y1(J,2)/Y1(J,1)))+.05*(DLOG(Y2(J,2)/Y2(J,1)))
     X +.05*(DLOG(Y4(J,2)/Y4(J,1)))+.10*
     X (DLOG(Y3(J,2)/Y3(J,1)))+.05*(DLOG(Y6(J,2)/Y6(J,1)))+.50*
     X (DLOG(Y5(J,2)/Y5(J,1)))
C
C YEMS (PEMS, EPEMS) IS A WEIGHTED AVERAGE OF REAL OUTPUT 
C (PRICE,INFLATION) DEVIATIONS FROM BASELINE IN THE EMS COUNTRIES
C 
      YEMS=.20*(DLOG(Y2(J,2)/Y2(J,1)))+.20*(DLOG(Y4(J,2)/Y4(J,1)))
     X +.40*(DLOG(Y3(J,2)/Y3(J,1)))+.20*(DLOG(Y6(J,2)/Y6(J,1)))
C
      PEMS=.20*(LP2(J,2)-LP2(J,1))+.20*(LP4(J,2)-LP4(J,1))+.40*
     X (LP3(J,2)-LP3(J,1))+.20*(LP6(J,2)-LP6(J,1))
C
      EPEMS=.20*(LP2(J+4,4)-LP2(J+4,1)-LP2(J,2)+LP2(J,1))
     X +.40*(LP3(J+4,4)-LP3(J+4,1)-LP3(J,2)+LP3(J,1))
     X +.20*(LP4(J+4,4)-LP4(J+4,1)-LP4(J,2)+LP4(J,1))
     X +.20*(LP6(J+4,4)-LP6(J+4,1)-LP6(J,2)+LP6(J,1))
C
C PNAMS (EPNAMS) IS A WEIGHTED AVERAGE OF PRICE (INFLATION) 
C DEVIATIONS FROM BASELINE IN THE U.S. AND CANADA
C
      PNAMS=.80*(LP(J,2)-LP(J,1))+.20*(LP1(J,2)-LP1(J,1))
C
      EPNAMS=.80*(LP(J+4,4)-LP(J+4,1)-LP(J,2)+LP(J,1))
     X +.20*(LP1(J+4,4)-LP1(J+4,1)-LP1(J,2)+LP1(J,1))
C
C
C  EQUALLY WEIGHTED EMS VARIABLES
C
C       DPEMSN = 0.25*LP2(J,2)+0.25*LP3(J,2)+0.25*LP4(J,2)
C    X          +0.25*LP6(J,2)
C       DYEMSN = 0.25*DLOG(Y2(J,2))+0.25*DLOG(Y3(J,2))+0.25*
C     X            DLOG(Y4(J,2))+0.25*DLOG(Y6(J,2))
C       DPEMS = 0.25*LP2(J,1)+0.25*LP3(J,1)+0.25*LP4(J,1)
C     X          +0.25*LP6(J,1)
C       DYEMS = 0.25*DLOG(Y2(J,1))+0.25*DLOG(Y3(J,1))+0.25*
C     X            DLOG(Y4(J,1))+0.25*DLOG(Y6(J,1))
C
C
C
C
C  GNP WEIGHTED EMS VARIABLES
C
	DPEMSN = 0.25*LP2(J,2)+0.35*LP3(J,2)+0.2*LP4(J,2)
     X          +0.2*LP6(J,2)
	DYEMSN = 0.25*DLOG(Y2(J,2))+0.35*DLOG(Y3(J,2))+0.2*
     X            DLOG(Y4(J,2))+0.2*DLOG(Y6(J,2))
	DPEMS = 0.25*LP2(J,1)+0.35*LP3(J,1)+0.2*LP4(J,1)
     X          +0.2*LP6(J,1)
	DYEMS = 0.25*DLOG(Y2(J,1))+0.35*DLOG(Y3(J,1))+0.2*
     X            DLOG(Y4(J,1))+0.2*DLOG(Y6(J,1))
C
C
C
C---------------------------------------------------------------------
C
C BEGINNING OF LIST OF COUNTRY EQUATIONS
C
C---------------------------------------------------------------------
C
C INTEREST RATE/MONEY SUPPLY EQUATIONS
C
C FOR FLEXIBLE EXCHANGE RATES THERE ARE TWO OPTIONS:
C
C     IPRULE=0: INTEREST RATE DETERMINED BY INVERTED MONEY DEMAND 
C               EQUATION AND EXOGENOUS MONEY SUPPLY
C     IPRULE=1: INTEREST RATE DETERMINED BY INTEREST RATE REACTION
C               FUNCTION AND MONEY SUPPLY ENDOGENOUS
C               REACTION FUNCTION PARAMETERS ARE INPUT BY USER
C               AS MATRIX PARG(.,.)
C
      IF(IFLEXE.EQ.1) THEN
C
      IF (IPRULE.EQ.0) THEN
	RS(J,3)=COEF(1,1)+COEF(1,2)*(LM(J,2)-LP(J,2))+COEF(1,3)*
     X   (LM(J-1,2)-LP(J-1,2))+COEF(1,4)*DLOG(Y(J,2))+
     X   COEF(1,5)*TT(J)+S(1,J)
	RS1(J,3)=COEF(2,1)+COEF(2,2)*(LM1(J,2)-LP1(J,2))+COEF(2,3)*
     X   (LM1(J-1,2)-LP1(J-1,2))+COEF(2,4)*DLOG(Y1(J,2))+
     X   S(2,J)
	RS2(J,3)=COEF(3,1)+COEF(3,2)*(LM2(J,2)-LP2(J,2))+COEF(3,3)*
     X   (LM2(J-1,2)-LP2(J-1,2))+COEF(3,4)*DLOG(Y2(J,2))+
     X   S(3,J)
	RS3(J,3)=COEF(4,1)+COEF(4,2)*(LM3(J,2)-LP3(J,2))+COEF(4,3)*
     X   (LM3(J-1,2)-LP3(J-1,2))+COEF(4,4)*DLOG(Y3(J,2))+
     X   S(4,J)
	RS4(J,3)=COEF(5,1)+COEF(5,2)*(LM4(J,2)-LP4(J,2))+COEF(5,3)*
     X   (LM4(J-1,2)-LP4(J-1,2))+COEF(5,4)*DLOG(Y4(J,2))+
     X   S(5,J)
	RS5(J,3)=COEF(6,1)+COEF(6,2)*(LM5(J,2)-LP5(J,2))+COEF(6,3)*
     X   (LM5(J-1,2)-LP5(J-1,2))+COEF(6,4)*DLOG(Y5(J,2))+
     X   S(6,J)
	RS6(J,3)=COEF(7,1)+COEF(7,2)*(LM6(J,2)-LP6(J,2))+COEF(7,3)*
     X   (LM6(J-1,2)-LP6(J-1,2))+COEF(7,4)*DLOG(Y6(J,2))+
     X   COEF(7,5)*TT(J)+S(7,J)
      END IF
C
	IF (IPRULE.EQ.1) THEN
	RS(J,3)= LP(J+4,4)-LP(J,2)+RS(J,1)-LP(J+4,1)+LP(J,1)
     X                +PARG(0,1)*(LP(J,2)-LP(J,1))
     X                +PARG(0,2)*(DLOG(Y(J,2)/Y(J,1)))+S(1,J)
	RS1(J,3)= LP1(J+4,4)-LP1(J,2)+RS1(J,1)-LP1(J+4,1)+LP1(J,1)
     X                  +PARG(1,1)*(LP1(J,2)-LP1(J,1))
     X                  +PARG(1,2)*(DLOG(Y1(J,2)/Y1(J,1)))+S(2,J)
	RS2(J,3)= LP2(J+4,4)-LP2(J,2)+RS2(J,1)-LP2(J+4,1)+LP2(J,1)
     X                  +PARG(2,1)*(LP2(J,2)-LP2(J,1))
     X                  +PARG(2,2)*(DLOG(Y2(J,2)/Y2(J,1)))+S(3,J)
	RS3(J,3)= LP3(J+4,4)-LP3(J,2)+RS3(J,1)-LP3(J+4,1)+LP3(J,1)
     X                  +PARG(3,1)*(LP3(J,2)-LP3(J,1))
     X                  +PARG(3,2)*(DLOG(Y3(J,2)/Y3(J,1)))+S(4,J)
	RS4(J,3)= LP4(J+4,4)-LP4(J,2)+RS4(J,1)-LP4(J+4,1)+LP4(J,1)
     X                  +PARG(4,1)*(LP4(J,2)-LP4(J,1))
     X                  +PARG(4,2)*(DLOG(Y4(J,2)/Y4(J,1)))+S(5,J)
	RS5(J,3)= LP5(J+4,4)-LP5(J,2)+RS5(J,1)-LP5(J+4,1)+LP5(J,1)
     X                  +PARG(5,1)*(LP5(J,2)-LP5(J,1))
     X                  +PARG(5,2)*(DLOG(Y5(J,2)/Y5(J,1)))+S(6,J)
	RS6(J,3)= LP6(J+4,4)-LP6(J,2)+RS6(J,1)-LP6(J+4,1)+LP6(J,1)
     X                  +PARG(6,1)*(LP6(J,2)-LP6(J,1))
     X                  +PARG(6,2)*(DLOG(Y6(J,2)/Y6(J,1)))+S(7,J)
C
       END IF      
C
C MASK SMALL OR NEGATIVE VALUES OF THE INTEREST RATE BY SETTING
C VALUES BELOW 0.01 TO 0.01
C
      IF(RS(J,3).LE.0.01D0) RS(J,3)=0.01D0
      IF(RS1(J,3).LE.0.01D0) RS1(J,3)=0.01D0
      IF(RS2(J,3).LE.0.01D0) RS2(J,3)=0.01D0
      IF(RS3(J,3).LE.0.01D0) RS3(J,3)=0.01D0
      IF(RS4(J,3).LE.0.01D0) RS4(J,3)=0.01D0
      IF(RS5(J,3).LE. 0.01D0) RS5(J,3)=0.01D0
      IF(RS6(J,3).LE. 0.01D0) RS6(J,3)=0.01D0
C
      LE1(J,3)=LE1(J+1,4)+COEF(8,1)*(RS1(J,3)-RS(J,3))+U1(J,1)+S(8,J)
      LE2(J,3)=LE2(J+1,4)+COEF(9,1)*(RS2(J,3)-RS(J,3))+U1(J,2)+S(9,J)
      LE3(J,3)=LE3(J+1,4)+COEF(10,1)*(RS3(J,3)-RS(J,3))+U1(J,3)+S(10,J)
      LE4(J,3)=LE4(J+1,4)+COEF(11,1)*(RS4(J,3)-RS(J,3))+U1(J,4)+S(11,J)
      LE5(J,3)=LE5(J+1,4)+COEF(12,1)*(RS5(J,3)-RS(J,3))+U1(J,5)+S(12,J)
      LE6(J,3)=LE6(J+1,4)+COEF(13,1)*(RS6(J,3)-RS(J,3))+U1(J,6)+S(13,J)
C
      END IF
C      
C FOR FIXED EXCHANGE RATES THERE ARE A NUMBER OF OPTIONS.
C
C     IPRULE=0: U.S. LEADER IN FIXED EXCHANGE RATE REGIME
C               U.S. SETS INTEREST RATE ACCORDING TO INVERTED
C               MONEY DEMAND EQUATION AND EXOGENOUS MONEY SUPPLY
C               REMAINING COUNTRIES FIX INTEREST RATES TO THAT OF
C               U.S.; THUS, THEIR MONEY SUPPLIES ARE ENDOGENOUS
C     IPRULE=I  FOR 1-6: SAME AS IPRULE=0, EXCEPT SUBSTITUTE  COUNTRY
C                INDEXED BY IPRULE NUMBER FOR U.S. AS LEADER;
C                E.G., IPRULE=5: JAPAN IS LEADER
C     IPRULE=10: U.S. LEADER IN FIXED EXCHANGE RATE REGIME
C                U.S. SETS INTEREST RATE ACCORDING TO INTEREST RATE
C                REACTION FUNCTION. U.S. MONEY SUPPLY ENDOGENOUS.
C                REMAINING COUNTRIES FIX INTEREST RATES TO THAT OF
C                U.S.; THUS, THEIR MONEY SUPPLIES ARE ENDOGENOUS
C     IPRULE=I;  FOR I=11-16: SAME AS IPRULE=10, EXCEPT SUBSTITUTE  
C                COUNTRY INDEXED BY IPRULE-10 NUMBER FOR U.S. AS LEADER;
C     IPRULE=20: EMS WITH GERMANY AS LEADER AND INTEREST RATES OF
C                GERMANY AND NON-EMS COUNTRIES DETERMINED BY INVERTED
C                MONEY DEMAND EQUATIONS
C     IPRULE=21: EMS WITH GERMANY AS LEADER AND INTEREST RATES OF
C                GERMANY AND NON-EMS COUNTRIES DETERMINED BY INTEREST
C                RATE REACTION FUNCTIONS     
C
      IF(IFLEXE.EQ.0) THEN
C
C U.S. LEADER EQUATIONS
C
      IF ((IPRULE.EQ.0).OR.(IPRULE.EQ.10)) THEN
	 IF (IPRULE.EQ.0) THEN
	   RS(J,3)=COEF(1,1)+COEF(1,2)*(LM(J,2)-LP(J,2))+COEF(1,3)*
     X     (LM(J-1,2)-LP(J-1,2))+COEF(1,4)*DLOG(Y(J,2))+
     X     COEF(1,5)*TT(J)+S(1,J)
	   IF (RS(J,3).LE.0.01D0) RS(J,3)=0.01D0
	 END IF
	 IF (IPRULE.EQ.10) THEN
	    RS(J,3)= LP(J+4,4)-LP(J,2)+RS(J,1)-LP(J+4,1)+LP(J,1)
     X              +PARG(0,1)*(LP(J,2)-LP(J,1))
     X              +PARG(0,2)*(DLOG(Y(J,2)/Y(J,1)))+S(1,J)
	 END IF
	 RS1(J,3)=RS(J,3)+S(8,J)
	 RS2(J,3)=RS(J,3)+S(9,J)
	 RS3(J,3)=RS(J,3)+S(10,J)
	 RS4(J,3)=RS(J,3)+S(11,J)
	 RS5(J,3)=RS(J,3)+S(12,J)
	 RS6(J,3)=RS(J,3)+S(13,J)
C
	LM1(J,3)=(RS1(J,3)-COEF(2,1)+COEF(2,2)*LP1(J,2)-COEF(2,3)*
     X   (LM1(J-1,3)-LP1(J-1,3))-COEF(2,4)*DLOG(Y1(J,2)))/COEF(2,2)
     X   +S(2,J)
	LM2(J,3)=(RS2(J,3)-COEF(3,1)+COEF(3,2)*LP2(J,2)-COEF(3,3)*
     X   (LM2(J-1,3)-LP2(J-1,3))-COEF(3,4)*DLOG(Y2(J,2)))/COEF(3,2)
     X   +S(3,J)
	LM3(J,3)=(RS3(J,3)-COEF(4,1)+COEF(4,2)*LP3(J,2)-COEF(4,3)*
     X   (LM3(J-1,3)-LP3(J-1,3))-COEF(4,4)*DLOG(Y3(J,2)))/COEF(4,2)
     X   +S(4,J)
	LM4(J,3)=(RS4(J,3)-COEF(5,1)+COEF(5,2)*LP4(J,2)-COEF(5,3)*
     X   (LM4(J-1,3)-LP4(J-1,3))-COEF(5,4)*DLOG(Y4(J,2)))/COEF(5,2)
     X   +S(5,J)
	LM5(J,3)=(RS5(J,3)-COEF(6,1)+COEF(6,2)*LP5(J,2)-COEF(6,3)*
     X   (LM5(J-1,3)-LP5(J-1,3))-COEF(6,4)*DLOG(Y5(J,2)))/COEF(6,2)
     X   +S(6,J)
	LM6(J,3)=(RS6(J,3)-COEF(7,1)+COEF(7,2)*LP6(J,2)-COEF(7,3)*
     X   (LM6(J-1,3)-LP6(J-1,3))-COEF(7,4)*DLOG(Y6(J,2))-COEF(7,5)
     X   *TT(J))/COEF(7,2)+S(7,J)
C 
      END IF
C
C JAPAN AS LEADER EQUATIONS
C
      IF((IPRULE.EQ.5).OR.(IPRULE.EQ.15)) THEN
	 IF (IPRULE.EQ.5) THEN
	    RS5(J,3)=COEF(6,1)+COEF(6,2)*(LM5(J,2)-LP5(J,2))+COEF(6,3)*
     X      (LM5(J-1,2)-LP5(J-1,2))+COEF(6,4)*DLOG(Y5(J,2))+
     X      S(6,J)
	 END IF
	 IF (IPRULE.EQ.15) THEN
	    RS5(J,3)=LP5(J+4,4)-LP5(J,2)+RS5(J,1)-LP5(J+4,1)+LP5(J,1)
     X               +PARG(5,1)*(LP5(J,2)-LP5(J,1))
     X               +PARG(5,2)*(DLOG(Y5(J,2)/Y5(J,1)))+S(6,J)
	 END IF
C
	 IF (RS5(J,3).LE.0.01D0) RS5(J,3)=0.01D0
	 RS(J,3)= RS5(J,3)+S(8,J)
	 RS1(J,3)=RS5(J,3)+S(9,J)
	 RS2(J,3)=RS5(J,3)+S(10,J)
	 RS3(J,3)=RS5(J,3)+S(11,J)
	 RS4(J,3)=RS5(J,3)+S(12,J)
	 RS6(J,3)=RS5(J,3)+S(13,J)
C
	 LM(J,3)=(RS(J,3)-COEF(1,1)+COEF(1,2)*LP(J,2)-COEF(1,3)*
     X    (LM(J-1,3)-LP(J-1,3))-COEF(1,4)*DLOG(Y(J,2))-COEF(1,5)*
     X    TT(J))/COEF(1,2)+S(1,J)
	 LM1(J,3)=(RS1(J,3)-COEF(2,1)+COEF(2,2)*LP1(J,2)-COEF(2,3)*
     X    (LM1(J-1,3)-LP1(J-1,3))-COEF(2,4)*DLOG(Y1(J,2)))/COEF(2,2)
     X    +S(2,J)
	 LM2(J,3)=(RS2(J,3)-COEF(3,1)+COEF(3,2)*LP2(J,2)-COEF(3,3)*
     X    (LM2(J-1,3)-LP2(J-1,3))-COEF(3,4)*DLOG(Y2(J,2)))/COEF(3,2)
     X    +S(3,J)
	 LM3(J,3)=(RS3(J,3)-COEF(4,1)+COEF(4,2)*LP3(J,2)-COEF(4,3)*
     X    (LM3(J-1,3)-LP3(J-1,3))-COEF(4,4)*DLOG(Y3(J,2)))/COEF(4,2)
     X    +S(4,J)
	 LM4(J,3)=(RS4(J,3)-COEF(5,1)+COEF(5,2)*LP4(J,2)-COEF(5,3)*
     X    (LM4(J-1,3)-LP4(J-1,3))-COEF(5,4)*DLOG(Y4(J,2)))/COEF(5,2)
     X    +S(5,J)
	 LM6(J,3)=(RS6(J,3)-COEF(7,1)+COEF(7,2)*LP6(J,2)-COEF(7,3)*
     X    (LM6(J-1,3)-LP6(J-1,3))-COEF(7,4)*DLOG(Y6(J,2))-COEF(7,5)
     X    *TT(J))/COEF(7,2)+S(7,J)
	 END IF
C
C IPRULE=20-29
C    20-21: EMS WITH GERMANY SETTING INTEREST RATE UNILATERALLY
C
      IF((IPRULE.GE.20).AND.(IPRULE.LT.30)) THEN
C
C IPRULE=20: EMS WITH GERMANY SETTING INTEREST RATE ACCORDING TO
C INVERTED MONEY DEMAND EQUATION (AS DO NON-EMS COUNTRIES)
C
	 IF (IPRULE.EQ.20) THEN
	RS(J,3)=COEF(1,1)+COEF(1,2)*(LM(J,2)-LP(J,2))+COEF(1,3)*
     X   (LM(J-1,2)-LP(J-1,2))+COEF(1,4)*DLOG(Y(J,2))+
     X   COEF(1,5)*TT(J)+S(1,J)
	RS1(J,3)=COEF(2,1)+COEF(2,2)*(LM1(J,2)-LP1(J,2))+COEF(2,3)*
     X   (LM1(J-1,2)-LP1(J-1,2))+COEF(2,4)*DLOG(Y1(J,2))+
     X   S(2,J)
	RS3(J,3)=COEF(4,1)+COEF(4,2)*(LM3(J,2)-LP3(J,2))+COEF(4,3)*
     X   (LM3(J-1,2)-LP3(J-1,2))+COEF(4,4)*DLOG(Y3(J,2))+
     X   S(4,J)
	RS5(J,3)=COEF(6,1)+COEF(6,2)*(LM5(J,2)-LP5(J,2))+COEF(6,3)*
     X   (LM5(J-1,2)-LP5(J-1,2))+COEF(6,4)*DLOG(Y5(J,2))+
     X   S(6,J)
	   END IF
C
C IPRULE=21: EMS WITH GERMANY SETTING INTEREST RATE ACCORDING TO
C GERMAN INTEREST RATE REACTION FUNCTION (AS DO NON-EMS COUNTRIES)
C
	   IF(IPRULE.EQ.21) THEN
	RS(J,3)= LP(J+4,4)-LP(J,2)+RS(J,1)-LP(J+4,1)+LP(J,1)
     X                +PARG(0,1)*(LP(J,2)-LP(J,1))
     X                +PARG(0,2)*(DLOG(Y(J,2)/Y(J,1)))+S(1,J)
	RS1(J,3)= LP1(J+4,4)-LP1(J,2)+RS1(J,1)-LP1(J+4,1)+LP1(J,1)
     X                  +PARG(1,1)*(LP1(J,2)-LP1(J,1))
     X                  +PARG(1,2)*(DLOG(Y1(J,2)/Y1(J,1)))+S(2,J)
	RS3(J,3)= LP3(J+4,4)-LP3(J,2)+RS3(J,1)-LP3(J+4,1)+LP3(J,1)
     X                  +PARG(3,1)*(LP3(J,2)-LP3(J,1))
     X                  +PARG(3,2)*(DLOG(Y3(J,2)/Y3(J,1)))+S(4,J)
	RS5(J,3)= LP5(J+4,4)-LP5(J,2)+RS5(J,1)-LP5(J+4,1)+LP5(J,1)
     X                  +PARG(5,1)*(LP5(J,2)-LP5(J,1))
     X                  +PARG(5,2)*(DLOG(Y5(J,2)/Y5(J,1)))+S(6,J)
	   END IF
C
C GERMAN INTEREST RATE REACTION FUNCTION USES WEIGHTED EMS TARGETS
C
C
	   IF(IPRULE.EQ.22) THEN
	RS(J,3)= LP(J+4,4)-LP(J,2)+RS(J,1)-LP(J+4,1)+LP(J,1)
     X                +PARG(0,1)*(LP(J,2)-LP(J,1))
     X                +PARG(0,2)*(DLOG(Y(J,2)/Y(J,1)))+S(1,J)
	RS1(J,3)= LP1(J+4,4)-LP1(J,2)+RS1(J,1)-LP1(J+4,1)+LP1(J,1)
     X                  +PARG(1,1)*(LP1(J,2)-LP1(J,1))
     X                  +PARG(1,2)*(DLOG(Y1(J,2)/Y1(J,1)))+S(2,J)
	RS3(J,3)= LP3(J+4,4)-LP3(J,2)+RS3(J,1)-LP3(J+4,1)+LP3(J,1)
     X                  +PARG(3,1)*(dpemsn-dpems)
     X                  +PARG(3,2)*(dyemsn-dyems)+S(4,J)
	RS5(J,3)= LP5(J+4,4)-LP5(J,2)+RS5(J,1)-LP5(J+4,1)+LP5(J,1)
     X                  +PARG(5,1)*(LP5(J,2)-LP5(J,1))
     X                  +PARG(5,2)*(DLOG(Y5(J,2)/Y5(J,1)))+S(6,J)
	   END IF
C
C FRANCE, ITALY, U.K. INTEREST RATES SET EQUAL TO 
C GERMAN INTEREST RATE
C
	RS2(J,3)=RS3(J,3)+S(3,J)
	RS4(J,3)=RS3(J,3)+S(5,J)
	RS6(J,3)=RS3(J,3)+S(7,J)
C
C MASK SMALL OR NEGATIVE VALUES OF THE INTEREST RATE BY SETTING
C VALUES BELOW 0.01 TO 0.01
C
      IF(RS(J,3).LE.0.01D0) RS(J,3)=0.01D0
      IF(RS1(J,3).LE.0.01D0) RS1(J,3)=0.01D0
      IF(RS2(J,3).LE.0.01D0) RS2(J,3)=0.01D0
      IF(RS3(J,3).LE.0.01D0) RS3(J,3)=0.01D0
      IF(RS4(J,3).LE.0.01D0) RS4(J,3)=0.01D0
      IF(RS5(J,3).LE. 0.01D0) RS5(J,3)=0.01D0
      IF(RS6(J,3).LE. 0.01D0) RS6(J,3)=0.01D0
C
C CANADA, GERMAN, JAPAN EXCHANGE RATES FLOAT VS. U.S. DOLLAR
C FRANCE, ITALY, AND U.K. EXCHANGE RATES TIED TO BASELINE DEVIATIONS
C FROM GERMAN EXCHANGE RATE (I.E., FIXED TO BASELINE RATIOS)
C
      LE1(J,3)=LE1(J+1,4)+COEF(8,1)*(RS1(J,3)-RS(J,3))+U1(J,1)+S(8,J)
      LE3(J,3)=LE3(J+1,4)+COEF(10,1)*(RS3(J,3)-RS(J,3))+U1(J,3)+S(10,J)
      LE5(J,3)=LE5(J+1,4)+COEF(12,1)*(RS5(J,3)-RS(J,3))+U1(J,5)+S(12,J)
      LE2(J,3)=LE3(J,3)-LE3(J,1)+LE2(J,1)+S(9,J)
      LE4(J,3)=LE3(J,3)-LE3(J,1)+LE4(J,1)+S(11,J)      
      LE6(J,3)=LE3(J,3)-LE3(J,1)+LE6(J,1)+S(13,J)
C
      END IF
C
C END OF FIXED EXCHANGE RATE EQUATIONS
C
      END IF
C
C FOR MONETARY REGIMES WITH ENDOGENOUS MONEY SUPPLIES,
C COMPUTE MONEY SUPPLY USING MONEY DEMAND EQUATIONS
C
      IF ((IPRULE.EQ.1).OR.(IPRULE.GT.20)) THEN
	LM(J,3)=LM(J,1)+(RS(J,3)-RS(J,1)
     X   +COEF(1,2)*(LP(J,2)-LP(J,1))
     X   -COEF(1,3)*(LM(J-1,3)-LM(J-1,1)-LP(J-1,3)+LP(J-1,1))
     X   -COEF(1,4)*DLOG(Y(J,2)/Y(J,1)))/COEF(1,2)      
	LM1(J,3)=LM1(J,1)+(RS1(J,3)-RS1(J,1)
     X   +COEF(2,2)*(LP1(J,2)-LP1(J,1))
     X   -COEF(2,3)*(LM1(J-1,3)-LM1(J-1,1)-LP1(J-1,3)+LP1(J-1,1))
     X   -COEF(2,4)*DLOG(Y1(J,2)/Y1(J,1)))/COEF(2,2)    
	LM2(J,3)=LM2(J,1)+(RS2(J,3)-RS2(J,1)
     X   +COEF(3,2)*(LP2(J,2)-LP2(J,1))
     X   -COEF(3,3)*(LM2(J-1,3)-LM2(J-1,1)-LP2(J-1,3)+LP2(J-1,1))
     X   -COEF(3,4)*DLOG(Y2(J,2)/Y2(J,1)))/COEF(3,2)    
	LM3(J,3)=LM3(J,1)+(RS3(J,3)-RS3(J,1)
     X   +COEF(4,2)*(LP3(J,2)-LP3(J,1))
     X   -COEF(4,3)*(LM3(J-1,3)-LM3(J-1,1)-LP3(J-1,3)+LP3(J-1,1))
     X   -COEF(4,4)*DLOG(Y3(J,2)/Y3(J,1)))/COEF(4,2)    
	LM4(J,3)=LM4(J,1)+(RS4(J,3)-RS4(J,1)
     X   +COEF(5,2)*(LP4(J,2)-LP4(J,1))
     X   -COEF(5,3)*(LM4(J-1,3)-LM4(J-1,1)-LP4(J-1,3)+LP4(J-1,1))
     X   -COEF(5,4)*DLOG(Y4(J,2)/Y4(J,1)))/COEF(5,2)    
	LM5(J,3)=LM5(J,1)+(RS5(J,3)-RS5(J,1)
     X   +COEF(6,2)*(LP5(J,2)-LP5(J,1))
     X   -COEF(6,3)*(LM5(J-1,3)-LM5(J-1,1)-LP5(J-1,3)+LP5(J-1,1))
     X   -COEF(6,4)*DLOG(Y5(J,2)/Y5(J,1)))/COEF(6,2)    
	LM6(J,3)=LM6(J,1)+(RS6(J,3)-RS6(J,1)
     X   +COEF(7,2)*(LP6(J,2)-LP6(J,1))
     X   -COEF(7,3)*(LM6(J-1,3)-LM6(J-1,1)-LP6(J-1,3)+LP6(J-1,1))
     X   -COEF(7,4)*DLOG(Y6(J,2)/Y6(J,1)))/COEF(7,2)    
      END IF
C
C -------------------------------------------------------------------
C  CONSTRUCT LONG-TERM INTEREST RATES
C -------------------------------------------------------------------
C
      B=COEF(14,2)
      RL(J,3)= COEF(14,1)+(1-B)*(RS(J,3)+B*RS(J+1,4)+B**2*RS(J+2,4)
     X +B**3*RS(J+3,4)+B**4*RS(J+4,4)+B**5*RS(J+5,4)+B**6*RS(J+6,4)
     X +B**7*RS(J+7,4)+B**8*RS(J+8,4))/(1-B**9) +S(14,J)
      B=COEF(15,2)
      RL1(J,3)= COEF(15,1)+(1-B)*(RS1(J,3)+B*RS1(J+1,4)+B**2*RS1(J+2,4)
     X +B**3*RS1(J+3,4)+B**4*RS1(J+4,4)+B**5*RS1(J+5,4)+B**6*RS1(J+6,4)
     X +B**7*RS1(J+7,4)+B**8*RS1(J+8,4))/(1-B**9) +S(15,J)
      B=COEF(16,2)
      RL2(J,3)= COEF(16,1)+(1-B)*(RS2(J,3)+B*RS2(J+1,4)+B**2*RS2(J+2,4)
     X +B**3*RS2(J+3,4)+B**4*RS2(J+4,4)+B**5*RS2(J+5,4)+B**6*RS2(J+6,4)
     X +B**7*RS2(J+7,4)+B**8*RS2(J+8,4))/(1-B**9) +S(16,J)
      B=COEF(17,2)
      RL3(J,3)= COEF(17,1)+(1-B)*(RS3(J,3)+B*RS3(J+1,4)+B**2*RS3(J+2,4)
     X +B**3*RS3(J+3,4)+B**4*RS3(J+4,4)+B**5*RS3(J+5,4)+B**6*RS3(J+6,4)
     X +B**7*RS3(J+7,4)+B**8*RS3(J+8,4))/(1-B**9) +S(17,J)
      B=COEF(18,2)
      RL4(J,3)= COEF(18,1)+(1-B)*(RS4(J,3)+B*RS4(J+1,4)+B**2*RS4(J+2,4)
     X +B**3*RS4(J+3,4)+B**4*RS4(J+4,4)+B**5*RS4(J+5,4)+B**6*RS4(J+6,4)
     X +B**7*RS4(J+7,4)+B**8*RS4(J+8,4))/(1-B**9) +S(18,J)
      B=COEF(19,2)
      RL5(J,3)= COEF(19,1)+(1-B)*(RS5(J,3)+B*RS5(J+1,4)+B**2*RS5(J+2,4)
     X +B**3*RS5(J+3,4)+B**4*RS5(J+4,4)+B**5*RS5(J+5,4)+B**6*RS5(J+6,4)
     X +B**7*RS5(J+7,4)+B**8*RS5(J+8,4))/(1-B**9) +S(19,J)
      B=COEF(20,2)
      RL6(J,3)= COEF(20,1)+(1-B)*(RS6(J,3)+B*RS6(J+1,4)+B**2*RS6(J+2,4)
     X +B**3*RS6(J+3,4)+B**4*RS6(J+4,4)+B**5*RS6(J+5,4)+B**6*RS6(J+6,4)
     X +B**7*RS6(J+7,4)+B**8*RS6(J+8,4))/(1-B**9) +S(20,J)
C
C---------------------------------------------------------------------
C COMPUTE TREND-ADJUSTED REAL LONG-TERM INTEREST RATES
C --------------------------------------------------------------------
C
      RRL= DEXP(COEF(113,2)*T(J))*(RL(J,4)-LP(J+4,4)+LP(J,4))
      RRL1=DEXP(COEF(114,2)*T(J))*(RL1(J,4)-LP1(J+4,4)+LP1(J,4))
      RRL2=DEXP(COEF(115,2)*T(J))*(RL2(J,4)-LP2(J+4,4)+LP2(J,4))
      RRL3=DEXP(COEF(116,2)*T(J))*(RL3(J,4)-LP3(J+4,4)+LP3(J,4))
      RRL4=DEXP(COEF(117,2)*T(J))*(RL4(J,4)-LP4(J+4,4)+LP4(J,4))
      RRL5=DEXP(COEF(118,2)*T(J))*(RL5(J,4)-LP5(J+4,4)+LP5(J,4))
      RRL6=DEXP(COEF(119,2)*T(J))*(RL6(J,4)-LP6(J+4,4)+LP6(J,4))
C
C -------------------------------------------------------------------
C COMPUTE PERMANENT INCOME
C -------------------------------------------------------------------
C
      TERM=0.1D0/(1.0D0 - (0.9D0**9))
      YP=TERM*(Y(J,2)+ .9*Y(J+1,4)+.9**2*Y(J+2,4)+.9**3*Y(J+3,4)
     X            +.9**4*Y(J+4,4)+.9**5*Y(J+5,4)+.9**6*Y(J+6,4)
     X            +.9**7*Y(J+7,4)+.9**8*Y(J+8,4))
      YP1=TERM*(Y1(J,2)+.9*Y1(J+1,4)+.9**2*Y1(J+2,4)+.9**3*Y1(J+3,4)
     X            +.9**4*Y1(J+4,4)+.9**5*Y1(J+5,4)+.9**6*Y1(J+6,4)
     X            +.9**7*Y1(J+7,4)+.9**8*Y1(J+8,4))
      YP2=TERM*(Y2(J,2)+.9*Y2(J+1,4)+.9**2*Y2(J+2,4)+.9**3*Y2(J+3,4)
     X            +.9**4*Y2(J+4,4)+.9**5*Y2(J+5,4)+.9**6*Y2(J+6,4)
     X            +.9**7*Y2(J+7,4)+.9**8*Y2(J+8,4))
      YP3=TERM*(Y3(J,2)+.9*Y3(J+1,4)+.9**2*Y3(J+2,4)+.9**3*Y3(J+3,4)
     X            +.9**4*Y3(J+4,4)+.9**5*Y3(J+5,4)+.9**6*Y3(J+6,4)
     X            +.9**7*Y3(J+7,4)+.9**8*Y3(J+8,4))
      YP4=TERM*(Y4(J,2)+.9*Y4(J+1,4)+.9**2*Y4(J+2,4)+.9**3*Y4(J+3,4)
     X            +.9**4*Y4(J+4,4)+.9**5*Y4(J+5,4)+.9**6*Y4(J+6,4)
     X            +.9**7*Y4(J+7,4)+.9**8*Y4(J+8,4))
      YP5=TERM*(Y5(J,2)+.9*Y5(J+1,4)+.9**2*Y5(J+2,4)+.9**3*Y5(J+3,4)
     X            +.9**4*Y5(J+4,4)+.9**5*Y5(J+5,4)+.9**6*Y5(J+6,4)
     X            +.9**7*Y5(J+7,4)+.9**8*Y5(J+8,4))
      YP6=TERM*(Y6(J,2)+.9*Y6(J+1,4)+.9**2*Y6(J+2,4)+.9**3*Y6(J+3,4)
     X            +.9**4*Y6(J+4,4)+.9**5*Y6(J+5,4)+.9**6*Y6(J+6,4)
     X            +.9**7*Y6(J+7,4)+.9**8*Y6(J+8,4))
C
C --------------------------------------------------------------------
C  CONSUMPTION EQUATIONS
C --------------------------------------------------------------------
C
      CD(J,3)=COEF(21,1)+COEF(21,2)*YP+COEF(21,3)*CD(J-1,3)
     X        +COEF(21,4)*RRL +S(21,J)
      CN(J,3)=COEF(22,1)+COEF(22,2)*YP+COEF(22,3)*CN(J-1,3)
     X        +COEF(22,4)*RRL +S(22,J)
      CS(J,3)=COEF(23,1)+COEF(23,2)*YP+COEF(23,3)*CS(J-1,3) +S(23,J)    
      CD1(J,3)=COEF(24,1)+COEF(24,2)*YP1+COEF(24,3)*CD1(J-1,3)
     X        +COEF(24,4)*RRL1 +S(24,J)
      CN1(J,3)=COEF(25,1)+COEF(25,2)*YP1+COEF(25,3)*CN1(J-1,3)
     X        +COEF(25,4)*RRL1 +S(25,J)
      CS1(J,3)=COEF(26,1)+COEF(26,2)*YP1+COEF(26,3)*CS1(J-1,3) +S(26,J)
      CD2(J,3)=COEF(27,1)+COEF(27,2)*YP2+COEF(27,3)*CD2(J-1,3)
     X        +COEF(27,4)*RRL2 +S(27,J)
      CN2(J,3)=COEF(28,1)+COEF(28,2)*YP2+COEF(28,3)*CN2(J-1,3) +S(28,J)
      CS2(J,3)=COEF(29,1)+COEF(29,2)*YP2+COEF(29,3)*CS2(J-1,3) +S(29,J)
      C3(J,3)=COEF(30,1)+COEF(30,2)*YP3+COEF(30,3)*C3(J-1,3)
     X        +COEF(30,4)*RRL3 +S(30,J)
      C4(J,3)=COEF(31,1)+COEF(31,2)*YP4+COEF(31,3)*C4(J-1,3)
     X        +COEF(31,4)*RRL4 +S(31,J)
      CD5(J,3)=COEF(32,1)+COEF(32,2)*YP5+COEF(32,3)*CD5(J-1,3)
     X        +COEF(32,4)*RRL5 +S(32,J)
      CN5(J,3)=COEF(33,1)+COEF(33,2)*YP5+COEF(33,3)*CN5(J-1,3) +S(33,J)
      CS5(J,3)=COEF(34,1)+COEF(34,2)*YP5+COEF(34,3)*CS5(J-1,3) +S(34,J)
      CD6(J,3)=COEF(35,1)+COEF(35,2)*YP6+COEF(35,3)*CD6(J-1,3) +S(35,J)
      CN6(J,3)=COEF(36,1)+COEF(36,2)*YP6+COEF(36,3)*CN6(J-1,3)
     X        +COEF(36,4)*RRL6 +S(36,J)
      CS6(J,3)=COEF(37,1)+COEF(37,2)*YP6+COEF(37,3)*CS6(J-1,3) +S(37,J)
C
C ---------------------------------------------------------------------
C  INVESTMENT EQUATIONS
C ---------------------------------------------------------------------
C
      INE(J,3)= COEF(38,1)+COEF(38,2)*INE(J-1,3)+COEF(38,3)*YP
     X          +COEF(38,4)*RRL +S(38,J)
      INS(J,3)= COEF(39,1)+COEF(39,2)*INS(J-1,3)+COEF(39,3)*YP
     X          +COEF(39,4)*RRL +S(39,J)
      IR(J,3)=  COEF(40,1)+COEF(40,2)*IR(J-1,3)+COEF(40,3)*YP
     X          +COEF(40,4)*RRL +S(40,J)
      II(J,3)=  COEF(41,1)+COEF(41,2)*II(J-1,3)+COEF(41,3)*Y(J,2)
     X          +COEF(41,4)*Y(J-1,3)+COEF(41,5)*RRL +S(41,J)
      IF1(J,3)= COEF(42,1)+COEF(42,2)*IF1(J-1,3)+COEF(42,3)*YP1
     X          +COEF(42,4)*RRL1 +S(42,J)
      II1(J,3)= COEF(43,1)+COEF(43,2)*II1(J-1,3)+COEF(43,3)*Y1(J,2)
     X          +COEF(43,4)*Y1(J-1,3)+COEF(43,5)*RRL1 +S(43,J)
      IN2(J,3)= COEF(44,1)+COEF(44,2)*IN2(J-1,3)+COEF(44,3)*YP2 +S(44,J)
      IR2(J,3)= COEF(45,1)+COEF(45,2)*IR2(J-1,3)+COEF(45,3)*RRL2
     X          +S(45,J)
      II2(J,3)= COEF(46,1)+COEF(46,2)*II2(J-1,3)+COEF(46,3)*Y2(J,2)
     X          +COEF(46,4)*Y2(J-1,3)+COEF(46,5)*RRL2 +S(46,J)
      IF3(J,3)= COEF(47,1)+COEF(47,2)*IF3(J-1,3)+COEF(47,3)*YP3
     X          +COEF(47,4)*RRL3 +S(47,J)
      II3(J,3)= COEF(48,1)+COEF(48,2)*II3(J-1,3)+COEF(48,3)*Y3(J,2)
     X          +COEF(48,4)*Y3(J-1,3)+COEF(48,5)*RRL3 +S(48,J)
      IF4(J,3)= COEF(49,1)+COEF(49,2)*IF4(J-1,3)+COEF(49,3)*YP4
     X          +COEF(49,4)*RRL4 +S(49,J)
      II4(J,3)= COEF(50,1)+COEF(50,2)*II4(J-1,3)+COEF(50,3)*Y4(J,2)
     X          +COEF(50,4)*Y4(J-1,3)+COEF(50,5)*RRL4 +S(50,J)
      IN5(J,3)= COEF(51,1)+COEF(51,2)*IN5(J-1,3)+COEF(51,3)*YP5
     X          +COEF(51,4)*RRL5 +S(51,J)
      IR5(J,3)= COEF(52,1)+COEF(52,2)*IR5(J-1,3)+COEF(52,3)*RRL5
     X          +S(52,J)
      II5(J,3)= COEF(53,1)+COEF(53,2)*II5(J-1,3)+COEF(53,3)*Y5(J,2)
     X          +COEF(53,4)*Y5(J-1,3)+COEF(53,5)*RRL5 +S(53,J)
      IN6(J,3)= COEF(54,1)+COEF(54,2)*IN6(J-1,3)+COEF(54,3)*YP6
     X          +COEF(54,4)*RRL6 +S(54,J)
      IR6(J,3)= COEF(55,1)+COEF(55,2)*IR6(J-1,3)+COEF(55,3)*RRL6
     X          +S(55,J)
      II6(J,3)= COEF(56,1)+COEF(56,2)*II6(J-1,3)+COEF(56,3)*Y6(J,2)
     X          +COEF(56,4)*Y6(J-1,3)+COEF(56,5)*RRL6 +S(56,J)
C
C ---------------------------------------------------------------------
C  EXPORT EQUATIONS
C ---------------------------------------------------------------------
C
      LEX(J,3)= COEF(57,1)+COEF(57,2)*LEX(J-1,3)+COEF(57,3)*
     X      (LPE(J,2)-LPI(J,2))+COEF(57,4)*(0.091*DLOG(Y1(J,2))
     X      +0.175*DLOG(Y2(J,2))+0.265*DLOG(Y3(J,2))+0.123*DLOG(Y4(J,2))
     X      +0.189*DLOG(Y5(J,2))+0.157*DLOG(Y6(J,2)))+S(57,J)
      LEX1(J,3)=COEF(58,1)+COEF(58,2)*LEX1(J-1,3)+COEF(58,3)*
     X      (LPE1(J,2)-LPI1(J,2))+COEF(58,4)*(0.268*DLOG(Y(J,2))
     X      +0.141*DLOG(Y2(J,2))+0.213*DLOG(Y3(J,2))+0.099*DLOG(Y4(J,2))
     X      +0.152*DLOG(Y5(J,2))+0.127*DLOG(Y6(J,2)))+S(58,J)
      LEX2(J,3)=COEF(59,1)+COEF(59,2)*LEX2(J-1,3)+COEF(59,3)*
     X      (LPE2(J,2)-LPI2(J,2))+COEF(59,4)*(0.287*DLOG(Y(J,2))
     X      +0.079*DLOG(Y1(J,2))+0.229*DLOG(Y3(J,2))+0.106*DLOG(Y4(J,2))
     X      +0.163*DLOG(Y5(J,2))+0.136*DLOG(Y6(J,2)))+S(59,J)
      LEX3(J,3)=COEF(60,1)+COEF(60,2)*LEX3(J-1,3)+COEF(60,3)*
     X      (LPE3(J,2)-LPI3(J,2))+COEF(60,4)*(0.311*DLOG(Y(J,2))
     X      +0.085*DLOG(Y1(J,2))+0.164*DLOG(Y2(J,2))+0.116*DLOG(Y4(J,2))
     X      +0.177*DLOG(Y5(J,2))+0.147*DLOG(Y6(J,2)))+S(60,J)
      LEX4(J,3)=COEF(61,1)+COEF(61,2)*LEX4(J-1,3)+COEF(61,3)*
     X      (LPE4(J,2)-LPI4(J,2))+COEF(61,4)*(0.275*DLOG(Y(J,2))
     X      +0.075*DLOG(Y1(J,2))+0.145*DLOG(Y2(J,2))+0.219*DLOG(Y3(J,2))
     X      +0.156*DLOG(Y5(J,2))+0.130*DLOG(Y6(J,2)))+S(61,J)
      LEX5(J,3)=COEF(62,1)+COEF(62,2)*LEX5(J-1,3)+COEF(62,3)*
     X      (LPE5(J,2)-LPI5(J,2))+COEF(62,4)*(0.291*DLOG(Y(J,2))
     X      +0.079*DLOG(Y1(J,2))+0.153*DLOG(Y2(J,2))+0.232*DLOG(Y3(J,2))
     X      +0.108*DLOG(Y4(J,2))+0.137*DLOG(Y6(J,2)))+S(62,J)
      LEX6(J,3)=COEF(63,1)+COEF(63,2)*LEX6(J-1,3)+COEF(63,3)*
     X      (LPE6(J,2)-LPI6(J,2))+COEF(63,4)*(0.283*DLOG(Y(J,2))
     X      +0.077*DLOG(Y1(J,2))+0.149*DLOG(Y2(J,2))+0.225*DLOG(Y3(J,2))
     X      +0.105*DLOG(Y4(J,2))+0.161*DLOG(Y5(J,2)))+S(63,J)
C
C  IMPORT EQUATIONS
C
      LIM(J,3)= COEF(64,1)+COEF(64,2)*LIM(J-1,3)+COEF(64,3)*
     X          (LPI(J,2) -LP(J,2)) +COEF(64,4)*DLOG(Y(J,2)) +S(64,J)
      LIM1(J,3)=COEF(65,1)+COEF(65,2)*LIM1(J-1,3)+COEF(65,3)*
     X          (LPI1(J,2)-LP1(J,2))+COEF(65,4)*DLOG(Y1(J,2))+S(65,J)
      LIM2(J,3)=COEF(66,1)+COEF(66,2)*LIM2(J-1,3)+COEF(66,3)*
     X          (LPI2(J,2)-LP2(J,2))+COEF(66,4)*DLOG(Y2(J,2))+S(66,J)
      LIM3(J,3)=COEF(67,1)+COEF(67,2)*LIM3(J-1,3)+COEF(67,3)*
     X          (LPI3(J,2)-LP3(J,2))+COEF(67,4)*DLOG(Y3(J,2))+S(67,J)
      LIM4(J,3)=COEF(68,1)+COEF(68,2)*LIM4(J-1,3)+COEF(68,3)*
     X          (LPI4(J,2)-LP4(J,2))+COEF(68,4)*DLOG(Y4(J,2))+S(68,J)
      LIM5(J,3)=COEF(69,1)+COEF(69,2)*LIM5(J-1,3)+COEF(69,3)*
     X          (LPI5(J,2)-LP5(J,2))+COEF(69,4)*DLOG(Y5(J,2))+S(69,J)
      LIM6(J,3)=COEF(70,1)+COEF(70,2)*LIM6(J-1,3)+COEF(70,3)*
     X          (LPI6(J,2)-LP6(J,2))+COEF(70,4)*DLOG(Y6(J,2))+S(70,J)
C
C -------------------------------------------------------------------
C GDP/GNP EQUATIONS
C -------------------------------------------------------------------
C
      Y(J,3) =CD(J,3)+CN(J,3)+CS(J,3)+INE(J,3)+INS(J,3)+IR(J,3)+II(J,3)
     X        +G(J,2)+DEXP(LEX(J,3))-DEXP(LIM(J,3))+S(71,J)
      Y1(J,3)=CD1(J,3)+CN1(J,3)+CS1(J,3)+IF1(J,3)+II1(J,3)+G1(J,2)
     X        +DEXP(LEX1(J,3))-DEXP(LIM1(J,3))+S(72,J)
      Y2(J,3)=CD2(J,3)+CN2(J,3)+CS2(J,3)+IN2(J,3)+IR2(J,3)+II2(J,3)
     X        +G2(J,2)+DEXP(LEX2(J,3))-DEXP(LIM2(J,3))+S(73,J)
      Y3(J,3)=C3(J,3)+IF3(J,3)+II3(J,3)+G3(J,2)+DEXP(LEX3(J,3))
     X        -DEXP(LIM3(J,3))+S(74,J)
      Y4(J,3)=C4(J,3)+IF4(J,3)+II4(J,3)+G4(J,2)+DEXP(LEX4(J,3))
     X        -DEXP(LIM4(J,3))+S(75,J)
      Y5(J,3)=CD5(J,3)+CN5(J,3)+CS5(J,3)+IN5(J,3)+IR5(J,3)+II5(J,3)
     X        +G5(J,2)+DEXP(LEX5(J,3))-DEXP(LIM5(J,3))+S(76,J)
      Y6(J,3)=CD6(J,3)+CN6(J,3)+CS6(J,3)+IN6(J,3)+IR6(J,3)+II6(J,3)
     X        +G6(J,2)+DEXP(LEX6(J,3))-DEXP(LIM6(J,3))+S(77,J)
C
C MASK SMALL OR NEGATIVE VALUES OF CURRENT REAL OUTPUT TO AVOID 
C TAKING LOG OF NEGATIVE NUMBER
C
       IF (Y(J,3).LT.1.0D0) Y(J,3)=1.0D0
       IF (Y1(J,3).LT.1.0D0) Y1(J,3)=1.0D0
       IF (Y2(J,3).LT.1.0D0) Y2(J,3)=1.0D0
       IF (Y3(J,3).LT.1.0D0) Y3(J,3)=1.0D0
       IF (Y4(J,3).LT.1.0D0) Y4(J,3)=1.0D0
       IF (Y5(J,3).LT.1.0D0) Y5(J,3)=1.0D0
       IF (Y6(J,3).LT.1.0D0) Y6(J,3)=1.0D0
C
C --------------------------------------------------------------------
C  COMPUTE OUTPUT GAP FOR WAGE EQUATIONS
C --------------------------------------------------------------------
C
      DO 185 LL=0,3                                                     
	DO 185 NV=3,4                                                   
	IF((LL.NE.0).AND.(NV.EQ.3)) GO TO 185                           
	YGAP(J+LL,NV)=DLOG(Y(J+LL,NV))-COEF(113,1)-COEF(113,2)*T(J+LL)  
	YGAP1(J+LL,NV)=DLOG(Y1(J+LL,NV))-COEF(114,1)-COEF(114,2)*T(J+LL)
	YGAP2(J+LL,NV)=DLOG(Y2(J+LL,NV))-COEF(115,1)-COEF(115,2)*T(J+LL)
	YGAP3(J+LL,NV)=DLOG(Y3(J+LL,NV))-COEF(116,1)-COEF(116,2)*T(J+LL)
	YGAP4(J+LL,NV)=DLOG(Y4(J+LL,NV))-COEF(117,1)-COEF(117,2)*T(J+LL)
	YGAP5(J+LL,NV)=DLOG(Y5(J+LL,NV))-COEF(118,1)-COEF(118,2)*T(J+LL)
	YGAP6(J+LL,NV)=DLOG(Y6(J+LL,NV))-COEF(119,1)-COEF(119,2)*T(J+LL)
 185  CONTINUE
C
C ---------------------------------------------------------------------
C CONTRACT WAGES
C ---------------------------------------------------------------------
C
      LX(J,3)=PHI(0,0)*(LW(J,4)+GAMMA(0)*YGAP(J,4))     +DELTA(0,J)     
     X       +PHI(0,1)*(LW(J+1,4)+GAMMA(0)*YGAP(J+1,4))                 
     X       +PHI(0,2)*(LW(J+2,4)+GAMMA(0)*YGAP(J+2,4))                 
     X       +PHI(0,3)*(LW(J+3,4)+GAMMA(0)*YGAP(J+3,4))+S(78,J)         
      LX1(J,3)=PHI(1,0)*(LW1(J,4)+GAMMA(1)*YGAP1(J,4))   +DELTA(1,J)    
     X       +PHI(1,1)*(LW1(J+1,4)+GAMMA(1)*YGAP1(J+1,4))               
     X       +PHI(1,2)*(LW1(J+2,4)+GAMMA(1)*YGAP1(J+2,4))               
     X       +PHI(1,3)*(LW1(J+3,4)+GAMMA(1)*YGAP1(J+3,4))+S(79,J)       
      LX2(J,3)=PHI(2,0)*(LW2(J,4)+GAMMA(2)*YGAP2(J,4))   +DELTA(2,J)    
     X       +PHI(2,1)*(LW2(J+1,4)+GAMMA(2)*YGAP2(J+1,4))               
     X       +PHI(2,2)*(LW2(J+2,4)+GAMMA(2)*YGAP2(J+2,4))               
     X       +PHI(2,3)*(LW2(J+3,4)+GAMMA(2)*YGAP2(J+3,4))+S(80,J)       
      LX3(J,3)=PHI(3,0)*(LW3(J,4)+GAMMA(3)*YGAP3(J,4))  +DELTA(3,J)
     X       +PHI(3,1)*(LW3(J+1,4)+GAMMA(3)*YGAP3(J+1,4))
     X       +PHI(3,2)*(LW3(J+2,4)+GAMMA(3)*YGAP3(J+2,4))
     X       +PHI(3,3)*(LW3(J+3,4)+GAMMA(3)*YGAP3(J+3,4))+S(81,J)
      LX4(J,3)=PHI(4,0)*(LW4(J,4)+GAMMA(4)*YGAP4(J,4))  +DELTA(4,J)
     X       +PHI(4,1)*(LW4(J+1,4)+GAMMA(4)*YGAP4(J+1,4))
     X       +PHI(4,2)*(LW4(J+2,4)+GAMMA(4)*YGAP4(J+2,4))
     X       +PHI(4,3)*(LW4(J+3,4)+GAMMA(4)*YGAP4(J+3,4))+S(82,J)
      LX5(J,3)=PHI5(J,0)*(LW5(J,4)+GAMMA(5)*YGAP5(J,4))  +DELTA(5,J)
     X       +PHI5(J,1)*(LW5(J+1,4)+GAMMA(5)*YGAP5(J+1,4))
     X       +PHI5(J,2)*(LW5(J+2,4)+GAMMA(5)*YGAP5(J+2,4))
     X       +PHI5(J,3)*(LW5(J+3,4)+GAMMA(5)*YGAP5(J+3,4))+S(83,J)
      LX6(J,3)=PHI(6,0)*(LW6(J,4)+GAMMA(6)*YGAP6(J,4))  +DELTA(6,J)
     X       +PHI(6,1)*(LW6(J+1,4)+GAMMA(6)*YGAP6(J+1,4))
     X       +PHI(6,2)*(LW6(J+2,4)+GAMMA(6)*YGAP6(J+2,4))
     X       +PHI(6,3)*(LW6(J+3,4)+GAMMA(6)*YGAP6(J+3,4))+S(84,J)
C
C ---------------------------------------------------------------------
C  WAGE EQUATIONS
C ---------------------------------------------------------------------
C
      LW(J,3)= PSI(0,0)*LX(J,3)+PSI(0,1)*LX(J-1,3)+PSI(0,2)*LX(J-2,3)
     X         +PSI(0,3)*LX(J-3,3)+S(85,J)
      LW1(J,3)=PSI(1,0)*LX1(J,3)+PSI(1,1)*LX1(J-1,3)+PSI(1,2)*LX1(J-2,3)
     X         +PSI(1,3)*LX1(J-3,3)+S(86,J)
      LW2(J,3)=PSI(2,0)*LX2(J,3)+PSI(2,1)*LX2(J-1,3)+PSI(2,2)*LX2(J-2,3)
     X         +PSI(2,3)*LX2(J-3,3)+S(87,J)
      LW3(J,3)=PSI(3,0)*LX3(J,3)+PSI(3,1)*LX3(J-1,3)+PSI(3,2)*LX3(J-2,3)
     X         +PSI(3,3)*LX3(J-3,3)+S(88,J)
      LW4(J,3)=PSI(4,0)*LX4(J,3)+PSI(4,1)*LX4(J-1,3)+PSI(4,2)*LX4(J-2,3)
     X         +PSI(4,3)*LX4(J-3,3)+S(89,J)
      LW5(J,3)=PSI5(J,0)*LX5(J,3)+PSI5(J,1)*LX5(J-1,3)+PSI5(J,2)
     X         *LX5(J-2,3)+PSI5(J,3)*LX5(J-3,3)+S(90,J)
      LW6(J,3)=PSI(6,0)*LX6(J,3)+PSI(6,1)*LX6(J-1,3)+PSI(6,2)*LX6(J-2,3)
     X         +PSI(6,3)*LX6(J-3,3)+S(91,J)
C
C ----------------------------------------------------------------------
C  FOREIGN PRICE EQUATIONS
C ----------------------------------------------------------------------
C                                              
	FP=  0.091*(LP1(J,2)+LE1(J,3))+0.175*(LP2(J,2)+LE2(J,3))        
     X       +0.265*(LP3(J,2)+LE3(J,3))+0.123*(LP4(J,2)+LE4(J,3))       
     X       +0.189*(LP5(J,2)+LE5(J,3))+0.157*(LP6(J,2)+LE6(J,3))       
	FP1= 0.268*LP(J,2)  -LE1(J,3) +0.141*(LP2(J,2)+LE2(J,3))        
     X       +0.213*(LP3(J,2)+LE3(J,3))+0.099*(LP4(J,2)+LE4(J,3))       
     X       +0.152*(LP5(J,2)+LE5(J,3))+0.127*(LP6(J,2)+LE6(J,3))       
	FP2= 0.287*LP(J,2)  -LE2(J,3) +0.079*(LP1(J,2)+LE1(J,3))        
     X       +0.229*(LP3(J,2)+LE3(J,3))+0.106*(LP4(J,2)+LE4(J,3))       
     X       +0.163*(LP5(J,2)+LE5(J,3))+0.136*(LP6(J,2)+LE6(J,3))       
	FP3= 0.311*LP(J,2)  -LE3(J,3) +0.085*(LP1(J,2)+LE1(J,3))        
     X       +0.164*(LP2(J,2)+LE2(J,3))+0.116*(LP4(J,2)+LE4(J,3))       
     X       +0.177*(LP5(J,2)+LE5(J,3))+0.147*(LP6(J,2)+LE6(J,3))       
	FP4= 0.275*LP(J,2)  -LE4(J,3) +0.075*(LP1(J,2)+LE1(J,3))        
     X       +0.145*(LP2(J,2)+LE2(J,3))+0.219*(LP3(J,2)+LE3(J,3))       
     X       +0.156*(LP5(J,2)+LE5(J,3))+0.130*(LP6(J,2)+LE6(J,3))       
	FP5= 0.291*LP(J,2)  -LE5(J,3) +0.079*(LP1(J,2)+LE1(J,3))        
     X       +0.153*(LP2(J,2)+LE2(J,3))+0.232*(LP3(J,2)+LE3(J,3))       
     X       +0.108*(LP4(J,2)+LE4(J,3))+0.137*(LP6(J,2)+LE6(J,3))       
	FP6= 0.283*LP(J,2)  -LE6(J,3) +0.077*(LP1(J,2)+LE1(J,3))        
     X       +0.149*(LP2(J,2)+LE2(J,3))+0.225*(LP3(J,2)+LE3(J,3))       
     X       +0.105*(LP4(J,2)+LE4(J,3))+0.161*(LP5(J,2)+LE5(J,3))       
C
      FPL= 0.091*(LP1(J-1,2)+LE1(J-1,2))+0.175*(LP2(J-1,2)+LE2(J-1,2))
     X     +0.265*(LP3(J-1,2)+LE3(J-1,2))+0.123*(LP4(J-1,2)+LE4(J-1,2))
     X     +0.189*(LP5(J-1,2)+LE5(J-1,2))+0.157*(LP6(J-1,2)+LE6(J-1,2))
      FP1L=0.268*LP(J-1,2)  -LE1(J-1,2) +0.141*(LP2(J-1,2)+LE2(J-1,2))
     X     +0.213*(LP3(J-1,2)+LE3(J-1,2))+0.099*(LP4(J-1,2)+LE4(J-1,2))
     X     +0.152*(LP5(J-1,2)+LE5(J-1,2))+0.127*(LP6(J-1,2)+LE6(J-1,2))
      FP1L2=0.268*LP(J-2,2)  -LE1(J-2,2) +0.141*(LP2(J-2,2)+LE2(J-2,2))
     X     +0.213*(LP3(J-2,2)+LE3(J-2,2))+0.099*(LP4(J-2,2)+LE4(J-2,2))
     X     +0.152*(LP5(J-2,2)+LE5(J-2,2))+0.127*(LP6(J-2,2)+LE6(J-2,2))
      FP2L=0.287*LP(J-1,2)  -LE2(J-1,2) +0.079*(LP1(J-1,2)+LE1(J-1,2))
     X     +0.229*(LP3(J-1,2)+LE3(J-1,2))+0.106*(LP4(J-1,2)+LE4(J-1,2))
     X     +0.163*(LP5(J-1,2)+LE5(J-1,2))+0.136*(LP6(J-1,2)+LE6(J-1,2))
      FP3L=0.311*LP(J-1,2)  -LE3(J-1,2) +0.085*(LP1(J-1,2)+LE1(J-1,2))
     X     +0.164*(LP2(J-1,2)+LE2(J-1,2))+0.116*(LP4(J-1,2)+LE4(J-1,2))
     X     +0.177*(LP5(J-1,2)+LE5(J-1,2))+0.147*(LP6(J-1,2)+LE6(J-1,2))
      FP4L=0.275*LP(J-1,2)  -LE4(J-1,2) +0.075*(LP1(J-1,2)+LE1(J-1,2))
     X     +0.145*(LP2(J-1,2)+LE2(J-1,2))+0.219*(LP3(J-1,2)+LE3(J-1,2))
     X     +0.156*(LP5(J-1,2)+LE5(J-1,2))+0.130*(LP6(J-1,2)+LE6(J-1,2))
      FP5L=0.291*LP(J-1,2)  -LE5(J-1,2) +0.079*(LP1(J-1,2)+LE1(J-1,2))
     X     +0.153*(LP2(J-1,2)+LE2(J-1,2))+0.232*(LP3(J-1,2)+LE3(J-1,2))
     X     +0.108*(LP4(J-1,2)+LE4(J-1,2))+0.137*(LP6(J-1,2)+LE6(J-1,2))
      FP6L=0.283*LP(J-1,2)  -LE6(J-1,2) +0.077*(LP1(J-1,2)+LE1(J-1,2))
     X     +0.149*(LP2(J-1,2)+LE2(J-1,2))+0.225*(LP3(J-1,2)+LE3(J-1,2))
     X     +0.105*(LP4(J-1,2)+LE4(J-1,2))+0.161*(LP5(J-1,2)+LE5(J-1,2))
C
C --------------------------------------------------------------------
C  PRICE EQUATIONS
C --------------------------------------------------------------------
C
      LP(J,3)= COEF(92,1)+COEF(92,2)*LP(J-1,3)+COEF(92,3)*LP(J-2,3)
     X      +COEF(92,4)*LW(J,3)+COEF(92,5)*LW(J-1,3)+COEF(92,6)
     X      *LPI(J-1,3)+COEF(92,7)*LPI(J-2,3)+COEF(92,8)*T(J) +S(92,J)
      LP1(J,3)= COEF(93,1)+COEF(93,2)*LP1(J-1,3)+COEF(93,3)*LP1(J-2,3)
     X      +COEF(93,4)*LW1(J,3)+COEF(93,5)*LW1(J-1,3)+COEF(93,6)
     X      *FP1L+COEF(93,7)*FP1L2+COEF(93,8)*T(J)+S(93,J)
      LP2(J,3)= COEF(94,1)+COEF(94,2)*LP2(J-1,3)+COEF(94,3)*LP2(J-2,3)
     X      +COEF(94,4)*LW2(J,3)+COEF(94,5)*LW2(J-1,3)+COEF(94,6)
     X      *LPI2(J-1,3)+COEF(94,7)*LPI2(J-2,3)+COEF(94,8)*T(J)+S(94,J)
      LP3(J,3)= COEF(95,1)+COEF(95,2)*LP3(J-1,3)+COEF(95,3)*LW3(J,3)
     X      +COEF(95,4)*FP3L+COEF(95,5)*T(J) +S(95,J)
      LP4(J,3)= COEF(96,1)+COEF(96,2)*LP4(J-1,3)+COEF(96,3)*LP4(J-2,3)
     X      +COEF(96,4)*LW4(J,3)+COEF(96,5)*LW4(J-1,3)+COEF(96,6)
     X      *LPI4(J-1,3)+COEF(96,7)*LPI4(J-2,3)+COEF(96,8)*T(J)+S(96,J)
      LP5(J,3)= COEF(97,1)+COEF(97,2)*LP5(J-1,3)+COEF(97,3)*LP5(J-2,3)
     X      +COEF(97,4)*LW5(J,3)+COEF(97,5)*LW5(J-1,3)+COEF(97,6)
     X      *LPI5(J-1,3)+COEF(97,7)*LPI5(J-2,3)+COEF(97,8)*T(J)+S(97,J)
      LP6(J,3)=COEF(98,1)+COEF(98,2)*LP6(J-1,3)+COEF(98,3)*LP6(J-2,3)
     X    +COEF(98,4)*LW6(J,3)+COEF(98,5)*LW6(J-1,3)+COEF(98,6)
     X    *LPI6(J-1,3)+COEF(98,7)*LPI6(J-2,3)+COEF(98,8)*T(J)+S(98,J)
C
C ---------------------------------------------------------------------
C  IMPORT PRICE EQUATIONS
C ---------------------------------------------------------------------
C
      LPI(J,3)= COEF(99,1)+COEF(99,2)*LPI(J-1,3)+COEF(99,3)*
     X       LPI(J-2,3)+COEF(99,4)*FP+COEF(99,5)*FPL +S(99,J)
      LPI1(J,3)=COEF(100,1)+COEF(100,2)*LPI1(J-1,3)+COEF(100,3)*
     X       LPI1(J-2,3)+COEF(100,4)*FP1+COEF(100,5)*FP1L +S(100,J)
      LPI2(J,3)=COEF(101,1)+COEF(101,2)*LPI2(J-1,3)+COEF(101,3)*
     X       LPI2(J-2,3)+COEF(101,4)*FP2+COEF(101,5)*FP2L +S(101,J)
      LPI3(J,3)=COEF(102,1)+COEF(102,2)*LPI3(J-1,3)+COEF(102,3)*
     X       LPI3(J-2,3)+COEF(102,4)*FP3+COEF(102,5)*FP3L +S(102,J)
      LPI4(J,3)=COEF(103,1)+COEF(103,2)*LPI4(J-1,3)+COEF(103,3)*
     X       LPI4(J-2,3)+COEF(103,4)*FP4+COEF(103,5)*FP4L +S(103,J)
      LPI5(J,3)=COEF(104,1)+COEF(104,2)*LPI5(J-1,3)+COEF(104,3)*
     X       LPI5(J-2,3)+COEF(104,4)*FP5+COEF(104,5)*FP5L +S(104,J)
      LPI6(J,3)=COEF(105,1)+COEF(105,2)*LPI6(J-1,3)+COEF(105,3)*
     X       LPI6(J-2,3)+COEF(105,4)*FP6+COEF(105,5)*FP6L +S(105,J)
C
C -----------------------------------------------------------------
C  EXPORT PRICE EQUATIONS
C -----------------------------------------------------------------
C
      LPE(J,3)= COEF(106,1)+COEF(106,2)*LPE(J-1,3)+COEF(106,3)
     X       *LPE(J-2,3)+COEF(106,4)*LP(J,3)+COEF(106,5)*LP(J-1,3)
     X       +COEF(106,6)*T(J) +S(106,J)
      LPE1(J,3)= COEF(107,1)+COEF(107,2)*LPE1(J-1,3)+COEF(107,3)
     X       *LPE1(J-2,3)+COEF(107,4)*LP1(J,3)+COEF(107,5)*LP1(J-1,3)
     X       +COEF(107,6)*T(J) +S(107,J)
      LPE2(J,3)= COEF(108,1)+COEF(108,2)*LPE2(J-1,3)+COEF(108,3)
     X       *LPE2(J-2,3)+COEF(108,4)*LP2(J,3)+COEF(108,5)*LP2(J-1,3)
     X       +COEF(108,6)*T(J) +S(108,J)
      LPE3(J,3)= COEF(109,1)+COEF(109,2)*LPE3(J-1,3)+COEF(109,3)
     X       *LPE3(J-2,3)+COEF(109,4)*LP3(J,3)+COEF(109,5)*LP3(J-1,3)
     X       +COEF(109,6)*FP3+COEF(109,7)*FP3L+COEF(109,8)*T(J)
     X       +S(109,J)
      LPE4(J,3)= COEF(110,1)+COEF(110,2)*LPE4(J-1,3)+COEF(110,3)
     X       *LPE4(J-2,3)+COEF(110,4)*LP4(J,3)+COEF(110,5)*LP4(J-1,3)
     X       +COEF(110,6)*FP4+COEF(110,7)*FP4L+COEF(110,8)*T(J)
     X       +S(110,J)
      LPE5(J,3)= COEF(111,1)+COEF(111,2)*LPE5(J-1,3)+COEF(111,3)
     X       *LPE5(J-2,3)+COEF(111,4)*LP5(J,3)+COEF(111,5)*LP5(J-1,3)
     X       +COEF(111,6)*FP5+COEF(111,7)*FP5L+COEF(111,8)*T(J)
     X       +S(111,J)
      LPE6(J,3)= COEF(112,1)+COEF(112,2)*LPE6(J-1,3)+COEF(112,3)
     X       *LPE6(J-2,3)+COEF(112,4)*LP6(J,3)+COEF(112,5)*LP6(J-1,3)
     X       +COEF(112,6)*FP6+COEF(112,7)*FP6L+COEF(112,8)*T(J)
     X       +S(112,J)
C
C ------------------------------------------------------------------
C                                                                       
C  STOP TYPE I ITERATIONS IF CONVERGENCE IS ACHIEVED.                   
C  IF ANY OF THE VARIABLES AT ANY J HAVE NOT CONVERGED, AVOID           
C  CHECKING THE REST OF THE VARIABLES AT THE CURRENT PERIOD AND ALL     
C  VARIABLES IN LATER PERIODS.                                          
C                                                                       
	       IF(.NOT. PASS1) GO TO 190
C                
C  CHECK CONVERGENCE CRITERION FOR EACH VARIABLE.  IF ABSOLUTE                
C  DIFFERENCE BETWEEN VALUES IS GREATER THAN CRITICAL VALUE, 
C  GOTO 2 AND START ITERATION OVER.
C
C FIRST, CHECK EXCHANGE RATES USING TIGHTER RESTRICTIONS
C
	       IF(DABS(ZE(J,38)-ZE(J,37)).GT.CR1*.1) GO TO 2
	       IF(DABS(ZE(J,43)-ZE(J,42)).GT.CR1*.1) GO TO 2
	       IF(DABS(ZE(J,48)-ZE(J,47)).GT.CR1*.1) GO TO 2
	       IF(DABS(ZE(J,53)-ZE(J,52)).GT.CR1*.01) GO TO 2
	       IF(DABS(ZE(J,58)-ZE(J,57)).GT.CR1*.01) GO TO 2
	       IF(DABS(ZE(J,63)-ZE(J,62)).GT.CR1*.1) GO TO 2
C
C SECOND, CHECK EACH VARIABLE
C 
	       DO 191 KK=1,NE*N,N
		  IF(DABS((ZE(J,KK+2)-ZE(J,KK+1))/NORM(J,(KK+4)/5))
     X            .GT.CR1) GO TO 2
 191           CONTINUE
C
C I'M FOR KILLING THIS CHECK. IT IS A CHECK ON WHETHER THE ENDOGENOUS
C MONEY SUPPLY IN A SINGLE LEADER FIXED EXCHANGE RATE REGIME IS 
C CHANGING AS THE ITERATION PROGRESSES. THIS CHANGE IS SOLELY
C DEPENDENT ON CHANGES IN INTEREST RATES, PRICES AND OUTPUT WHICH ARE
C BEING CHECKED ALREADY.
C THE PROBLEM IS THAT IT MUST BE MODEIFIED FOR DIFFERENT FIXED
C EXCHANGE RATE REGIMES.
C
C               IF(IFLEXE.EQ.0) THEN                                    
C                 DO 192 KK=1,35,5                                      
C                   IF(DABS(ZO(J,KK+2)-ZO(J,KK+1)).GT.CR1) GO TO 2      
C 192              CONTINUE                                              
C               END IF
C
		GO TO 180                                               
C
C  IF CONVERGENCE IS NOT ACHIEVED, UPDATE TYPE I VECTOR BY A WEIGHTED
C AVERAGE OF PREVIOUS VALUE AND NEW VALUE, WITH WEIGHT SCALE1 (INPUT
C BY USER). SCALE1=1.0 IMPLIES FULL REPLACEMENT
C
C  CONTINUE TYPE I ITERATIONS FOR CURRENT PERIOD J (GOTO 2).
C  IF TYPE I CONVERGENCE IS ACHIEVED, OR LIMIT REACHED,
C  START ITERATIONS FOR NEXT PERIOD J + 1 (GOTO 180).
C
    2           PASS1= .FALSE.
  190           CONTINUE
C
		DO 195 KK=1,NE*N,N                                      
		  ZE(J,KK+1)=ZE(J,KK+1)+SCALE1*(ZE(J,KK+2)-ZE(J,KK+1))
  195           CONTINUE
		DO 196 KK=1,35,N
		  ZO(J,KK+1)=ZO(J,KK+1)+SCALE1*(ZO(J,KK+2)-ZO(J,KK+1))
  196           CONTINUE
  180         CONTINUE
C 
C  IF TYPE I CONVERGENCE ACHIEVED, GOTO 220
C
	      IF(PASS1) GO TO 220
 170        CONTINUE                                                    
C
C IF TYPE I ITERATION LIMIT REACHED, WRITE MESSGAE TO SCREEN
C
	    IF(.NOT.PASS1) THEN                                       
	      WRITE(*,230) K
  230         FORMAT(' TYPE I ITERATION LIMIT REACHED AT TYPE II ITERATI
     XON',,1X,I3)
	      GO TO 140                                               
	    END IF                                                    
C                                                                     
C  CHECK FOR TYPE II CONVERGENCE:                                     
C
 220        DO 240 J=I,I+H
	      IF(DABS(ZE(J,38)-ZE(J,37)).GT.CR2*.1) GO TO 250
	      IF(DABS(ZE(J,43)-ZE(J,42)).GT.CR2*.1) GO TO 250
	      IF(DABS(ZE(J,48)-ZE(J,47)).GT.CR2*.1) GO TO 250
	      IF(DABS(ZE(J,53)-ZE(J,52)).GT.CR2*.01) GO TO 250
	      IF(DABS(ZE(J,58)-ZE(J,57)).GT.CR2*.01) GO TO 250
	      IF(DABS(ZE(J,63)-ZE(J,62)).GT.CR2*.1) GO TO 250
C
	      DO 241 KK=1,100,5
		IF(DABS((ZE(J,KK+3)-ZE(J,KK+2))/NORM(J,(KK+4)/5))
     X                  .GT.CR2) GO TO 250
 241          CONTINUE
C
	      DO 242 KK=351,381,5
		IF(DABS((ZE(J,KK+3)-ZE(J,KK+2))/NORM(J,(KK+4)/5))
     X                  .GT.CR2) GO TO 250
 242          CONTINUE
C
	      DO 243 KK=421,486,5
		IF(DABS((ZE(J,KK+3)-ZE(J,KK+2))/NORM(J,(KK+4)/5))
     X                  .GT.CR2) GO TO 250
 243          CONTINUE
 240        CONTINUE
 244  FORMAT(7F12.6)
C
	    GO TO 260
C
 250        PASS2=.FALSE.
C            
C UPDATE EXPECTATIONS BY TAKING A WEIGHTED AVERAGE OF CURRENT 
C SOLUTION VALUE AND EXPECTED VALUE FROM PREVIOUS TYPE II ITERATION,
C USING SCALE FACTOR SCALE2.
C
	    DO 270 J=I,I+NFUT
	      DO 271 KK=1,100,5
		ZE(J,KK+3)=ZE(J,KK+3)+SCALE2*(ZE(J,KK+2)-ZE(J,KK+3))
 271          CONTINUE
	      DO 272 KK=351,381,5
		ZE(J,KK+3)=ZE(J,KK+3)+SCALE2*(ZE(J,KK+2)-ZE(J,KK+3))    
 272          CONTINUE
	      DO 273 KK=421,486,5
		ZE(J,KK+3)=ZE(J,KK+3)+SCALE2*(ZE(J,KK+2)-ZE(J,KK+3))
 273          CONTINUE
 270        CONTINUE
 160      CONTINUE
C
	  WRITE(*,280) YQ(I),NFUT
C
 280      FORMAT(' TYPE II ITERATION LIMIT EXCEEDED FOR OBSERVATION ',
     X         F5.1,' AND NFUT= ',I3)
	  PAST2=.FALSE.
C
	  GO TO  140
C
 260      WRITE(*,290) YQ(I),NFUT
 261      WRITE(*,291) K
 290      FORMAT(' TYPE II CONVERGENCE ACHIEVED FOR OBSERVATION ',
     X         F5.1,' AND NFUT= ',I3)
 291      FORMAT(' TYPE II ITERATIONS BEFORE CONVERGENCE ',I3)
C
C  STOP TYPE III ITERATIONS IF MOST RECENT TYPE II CONVERGENCE IS
C  SUFFICIENTLY CLOSE TO PREVIOUS TYPE II CONVERGENCE.
C
	  IF((NFUT.EQ.NFUT1).OR.(.NOT.PAST2)) GO TO 300
	  DO 310 J=I,I+H
	    IF(DABS(ZE(J,38)-ZE(J,37)).GT.CR3*.1) GO TO 320
	    IF(DABS(ZE(J,43)-ZE(J,42)).GT.CR3*.1) GO TO 320
	    IF(DABS(ZE(J,48)-ZE(J,47)).GT.CR3*.1) GO TO 320
	    IF(DABS(ZE(J,53)-ZE(J,52)).GT.CR3*.01) GO TO 320
	    IF(DABS(ZE(J,58)-ZE(J,57)).GT.CR3*.01) GO TO 320
	    IF(DABS(ZE(J,63)-ZE(J,62)).GT.CR3*.1) GO TO 320
C
	    DO 311 KK=1,100,5
	      IF(DABS((ZE(J,KK+4)-ZE(J,KK+3))/NORM(J,(KK+4)/5))
     X                .GT.CR3) GO TO 320
 311        CONTINUE
C
	    DO 312 KK=351,381,5
	      IF(DABS((ZE(J,KK+4)-ZE(J,KK+3))/NORM(J,(KK+4)/5))
     X                .GT.CR3) GO TO 320
 312        CONTINUE
C
	    DO 313 KK=421,486,5
	      IF(DABS((ZE(J,KK+4)-ZE(J,KK+3))/NORM(J,(KK+4)/5))
     X                .GT.CR3) GO TO 320
 313        CONTINUE
C
 310      CONTINUE
	  GO TO 330
 320      PASS3=.FALSE.
C
 300      DO 340 J=I,I+H
	    DO 341 KK=1,100,5
	      ZE(J,KK+4)=ZE(J,KK+3)
 341        CONTINUE
C
	    DO 342 KK=351,381,5
	      ZE(J,KK+4)=ZE(J,KK+3)
 342        CONTINUE
C
	    DO 343 KK=421,486,5
	      ZE(J,KK+4)=ZE(J,KK+3)
 343        CONTINUE
 340      CONTINUE
 140    CONTINUE
C
	WRITE(*,350) YQ(I)
 350    FORMAT(' TYPE III ITERATION LIMIT REACHED FOR OBSERVATION ',
     X         F5.1)
	PASS3=.FALSE.
 330    IF(PASS3) WRITE(*,360) YQ(I)
C
 360    FORMAT(' TYPE III CONVERGENCE ACHIEVED FOR OBSERVATION ',F5.1)
C
C       DO 361 IJ = 1,1
C          U1(I,IJ)=LE1(I,1)-LE1(I+1,4)-.25*(RS1(I,IJ)-RS(I,IJ))
C  361   CONTINUE
C
 130  CONTINUE
C
      RETURN                                                            
      END
C
C  *********************************************************************
C  SUBROUTINE STOCH                                                     
C  *********************************************************************
C                                                                       
      SUBROUTINE STOCH(initseed)
      PARAMETER(NT=240,NDL=119,NPL=126,N=5,NE=112,NO=79,NCOEFL=119,
     X NCOEFS=8,MAXLAG=3)
      IMPLICIT DOUBLE PRECISION (A-G,O-Z)
      DOUBLE PRECISION E(NE)
      DOUBLE PRECISION VCOV(NE,NE),SH(NE,NT)
      DOUBLE PRECISION YQ(NT)
      integer is(5)
C
      COMMON /SPECIF/ ISTOCH,NSIMLS,ISUB,IDTYPE,IPRULE,IFLEXE,IRES,NBEG,
     X NEND,NTP,NBEP,NEEP,CR1,CR2,CR3,MAXIT1,MAXIT2,NFUT1,NFUT2,YQ
      COMMON /SHOCKS/ VCOV,SH
C
      IF (ISTOCH .EQ. 1) THEN
C
C  DRAW STANDARD NORMAL SHOCKS                                  
C  (ONE FOR EACH EQUATION FOR EACH PERIOD TO BE SIMULATED)            
C
	 WRITE(*,*) 'DRAWING RANDOM SHOCKS.'
c
c set initial values for U(0,1) random number generator
c
       is(1)=initseed
       is(2)=20000
       is(3)=30000
       is(4)=40000
       is(5)=500000
c      
	 DO 500 J=1,NTP
            do 410 k=1,ne
               SH(K,J)=0.0D0
  410       continue
            call dnrv(ne,e,is)	    
C                                                                       
C  MULTIPLY VECTOR OF STANDARD NORMALS BY THE MATRIX VCOV              
C                                                                       
	    DO 430 K = 1,NE
	       DO 420 JJ = 1,NE
		  SH(K,J)=SH(K,J)+VCOV(K,JJ)*E(JJ)
  420          CONTINUE
C
	       IF((IFLEXE.EQ.0).AND.(K.GE.8).AND.(K.LE.13))
     X           SH(K,J)=0.0D0
	       IF((IFLEXE.EQ.1).AND.(K.GE.2).AND.(K.LE.7))
     X           SH(K,J)=0.0D0
	       IF(K.EQ.1) SH(K,J)=0.D0
  430       CONTINUE
  500    CONTINUE
C
C  IF THE SIMULATION IS DETERMINISTIC, SET SHOCKS TO ZERO
C
      ELSE
	 WRITE(*,*) 'SETTING RANDOM SHOCKS TO ZERO.'
	 DO 600 I=1,NE
	    DO 600 J=1,NT
	       SH(I,J)=0.0D0
 600     CONTINUE
      END IF
C                                                        
      RETURN                                                            
      END
c
c*******************************************************************
c subroutine dnrv
c this subroutine generates a vector of pseudo-random numbers
c distributed as independent standard normal random variables
c the iseed value must be a positive integer
c
c*******************************************************************
c
      subroutine dnrv(nrvs,drv,iseeds)
      implicit double precision (a-g,o-z)
      double precision urv(2),drv(nrvs)
      integer iseeds(5)
c
      icnt=0
c
   10 continue
c
c call U(0,1) RNG to generate a 2 x 1 vector of U(0,1) realizations
c
      call vprng(2,iseeds,urv)
      x1=2.0d0*urv(1)-1.0d0
      x2=2.0d0*urv(2)-1.0d0
      x3=x1**2+x2**2
c
c restart if x3 exactly equals 0 or > 1
c
      if(x3.le.0.0d0) goto 10
      if(x3.ge.1.0d0) goto 10
      icnt=icnt+2
c
c Box-Muller transformation
c
      x3=dsqrt(-2.0d0*dlog(x3)/x3)
      drv(icnt-1)=x1*x3
      if (icnt.le.nrvs) drv(icnt)=x2*x3
      if (icnt.ge.nrvs) goto 20
      goto 10
c         
   20 continue
c      
      return
      end
c
***********************************************************************
*
* SUBROUTINE VPRNG
*
************************************************************************
	SUBROUTINE VPRNG(LENGTH,ISEEDS,ZONE)
C
	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	IMPLICIT INTEGER (I-N)
	PARAMETER(NSEEDS=5)
	INTEGER  LENGTH,ISEEDS(NSEEDS)
	DOUBLE PRECISION   ZONE(LENGTH)
	INTEGER  ISTORE(2)
C
*-----------------------------------------------------------------------
C        
	M=ISEEDS(1)
	IA=ISEEDS(2)
	IB=ISEEDS(3)
	IC=ISEEDS(4)
	IRAND=ISEEDS(5)
C
	DO 10 I=1,LENGTH
	      DO 30 K=1,2
		 M=M+7
		 IA=IA+1907
		 IB=IB+73939
		 IC=IC+99901
C        
		 IF(M.GE.9973)M=M-9871
		 IF(IA.GE.99991)IA=IA-89989
		 IF(IB.GE.224729)IB=IB-96233
		 IF(IC.GE.9925387)IC=IC-9121439
C 
		 IRAND=(MOD((IRAND*M+IA+IB+IC),100000))/10
		 ISTORE(K)=IRAND
30            CONTINUE
	      ZONE(I)=(10000*ISTORE(1)+ISTORE(2))/1.D8
10      CONTINUE
C
	ISEEDS(1)=M
	ISEEDS(2)=IA
	ISEEDS(3)=IB
	ISEEDS(4)=IC
	ISEEDS(5)=IRAND
C
	RETURN
	END




















