/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

class ProgramSearchEngine
implements IRunnableWithProgress {
    private HashSet<IType> result = new HashSet();

    ProgramSearchEngine() {
    }

    public static Set<IType> runSearch() {
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        ProgramSearchEngine engine = new ProgramSearchEngine();
        try {
            ps.run(false, false, (IRunnableWithProgress)engine);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return engine.result;
    }

    public void run(IProgressMonitor pm) {
        int searchWork = 25;
        int subtypesWork = 75;
        pm.beginTask("Searching for programs.", searchWork + subtypesWork);
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        MethodCollector collector = new MethodCollector();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            new SearchEngine().search(pattern, participants, scope, (SearchRequestor)collector, (IProgressMonitor)new SubProgressMonitor(pm, searchWork));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.addSpecificType("acm.program.Program");
        this.addSpecificType("stanford.karel.Karel");
        this.addSubtypes(scope, (IProgressMonitor)new SubProgressMonitor(pm, subtypesWork));
        this.filterTypes();
    }

    private void addSpecificType(String name) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                IType type;
                IJavaProject project = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
                if (project != null && (type = project.findType(name)) != null) {
                    this.result.add(type);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private void addSubtypes(IJavaSearchScope scope, IProgressMonitor pm) {
        HashSet<IType> toAdd = new HashSet<IType>();
        pm.beginTask("Searching for subclasses.", this.result.size());
        for (IType type : this.result) {
            try {
                IType[] subtypes;
                ITypeHierarchy hierarchy = type.newTypeHierarchy(pm);
                IType[] iTypeArray = subtypes = hierarchy.getAllSubtypes(type);
                int n = subtypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType st = iTypeArray[n2];
                    if (scope.encloses((IJavaElement)st)) {
                        toAdd.add(st);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            pm.worked(1);
        }
        this.result.addAll(toAdd);
    }

    private void filterTypes() {
        String[] prefixes = new String[]{"acm", "stanford"};
        Iterator<IType> iterator = this.result.iterator();
        while (iterator.hasNext()) {
            IType type = iterator.next();
            boolean filter = false;
            String[] stringArray = prefixes;
            int n = prefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                if (type.getFullyQualifiedName().startsWith(String.valueOf(prefix) + ".")) {
                    filter = true;
                }
                ++n2;
            }
            try {
                if (Flags.isAbstract((int)type.getFlags())) {
                    filter = true;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (!filter) continue;
            iterator.remove();
        }
    }

    private class MethodCollector
    extends SearchRequestor {
        private MethodCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) {
            try {
                Object enclosingElement = match.getElement();
                if (!(enclosingElement instanceof IMethod)) {
                    return;
                }
                IMethod cur = (IMethod)enclosingElement;
                if (!cur.isMainMethod() || cur.isBinary()) {
                    return;
                }
                IPackageFragmentRoot root = this.getRoot((IJavaElement)cur);
                if (root == null || root.isArchive()) {
                    return;
                }
                IType type = cur.getDeclaringType();
                ProgramSearchEngine.this.result.add(type);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }

        private IPackageFragmentRoot getRoot(IJavaElement element) {
            return (IPackageFragmentRoot)element.getAncestor(3);
        }
    }
}

