/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.handlers;

import edu.stanford.cs106.handlers.ProgramSearchEngine;
import edu.stanford.cs106.handlers.ProgramSelectDialog;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RunSelect
extends AbstractHandler {
    protected static IType lastProgram;
    protected static String lastArgs;

    static {
        lastArgs = "";
    }

    public Object execute(ExecutionEvent event) {
        IType program = this.chooseProgram();
        if (program != null) {
            this.launch(program);
        }
        return null;
    }

    protected IType chooseProgram() {
        IWorkbench wb = PlatformUI.getWorkbench();
        Shell shell = wb.getActiveWorkbenchWindow().getShell();
        Set<IType> programs = ProgramSearchEngine.runSearch();
        if (programs.size() == 0) {
            String message = "Could not find any programs to run. (Do you have a public void run() method?)";
            MessageDialog.openError((Shell)shell, (String)"", (String)message);
            return null;
        }
        if (programs.size() == 1) {
            return programs.iterator().next();
        }
        ProgramSelectDialog dialog = new ProgramSelectDialog(shell, programs.toArray());
        dialog.setArgs(lastArgs);
        if (dialog.open() != 0) {
            return null;
        }
        lastProgram = (IType)dialog.getFirstResult();
        lastArgs = dialog.getArgs();
        return lastProgram;
    }

    protected void launch(IType program) {
        ILaunchConfiguration config = this.findOrCreateConfig(program);
        if (config == null) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            if (wc == null) {
                return;
            }
            String args = String.valueOf(lastArgs) + " code=" + program.getFullyQualifiedName() + ".class";
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            config = wc.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
        }
    }

    private ILaunchConfiguration chooseConfig(ArrayList<ILaunchConfiguration> configs) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle("Choose Launch Configuration");
        dialog.setMultipleSelection(false);
        dialog.setElements(configs.toArray());
        int result = dialog.open();
        labelProvider.dispose();
        return result == 0 ? (ILaunchConfiguration)dialog.getFirstResult() : null;
    }

    private ILaunchConfiguration createConfig(IType program) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        try {
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, lm.generateLaunchConfigurationName(program.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, program.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, program.getJavaProject().getElementName());
            return wc.doSave();
        }
        catch (CoreException e) {
            this.reportCreateError(e);
            return null;
        }
    }

    private ILaunchConfiguration findOrCreateConfig(IType program) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        try {
            ILaunchConfiguration[] allConfigs;
            ILaunchConfiguration[] iLaunchConfigurationArray = allConfigs = lm.getLaunchConfigurations(configType);
            int n = allConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String name = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
                String project = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (name.equals(program.getFullyQualifiedName()) && project.equals(program.getJavaProject().getElementName())) {
                    configs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (configs.size() == 0) {
            return this.createConfig(program);
        }
        if (configs.size() == 1) {
            return (ILaunchConfiguration)configs.get(0);
        }
        return this.chooseConfig(configs);
    }

    private void reportCreateError(final CoreException e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ErrorDialog.openError((Shell)shell, (String)"", (String)"", (IStatus)e.getStatus());
            }
        });
    }
}

