/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class ShowPerspective
extends AbstractHandler {
    protected String perspective;

    public Object execute(ExecutionEvent event) {
        try {
            IWorkbench wb = PlatformUI.getWorkbench();
            wb.showPerspective(this.perspective, wb.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class Debugger
    extends ShowPerspective {
        public Debugger() {
            this.perspective = "org.eclipse.debug.ui.DebugPerspective";
        }
    }

    public static class Editor
    extends ShowPerspective {
        public Editor() {
            this.perspective = "org.eclipse.jdt.ui.JavaPerspective";
        }
    }
}

