/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.listeners;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;

class GitListener
implements ILaunchesListener,
IResourceChangeListener {
    private static final int MAX_REPO_SIZE = 0xA00000;
    private static final int ADDED = 1;
    private static final int CHANGED = 2;
    private static final int REMOVED = 4;
    private int numRuns = 0;

    GitListener() {
    }

    public void launchesAdded(ILaunch[] launches) {
        ++this.numRuns;
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        if (event.getType() != 1) {
            return;
        }
        IProject lastProject = null;
        int flags = 0;
        Repository repo = null;
        IResourceDelta[] iResourceDeltaArray = deltas = event.getDelta().getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IProject project = (IProject)delta.getResource().getAdapter(IProject.class);
            if (project != null && this.isStanfordProject(project)) {
                if (!project.equals(lastProject)) {
                    this.commitProject(repo, lastProject, flags);
                    lastProject = project;
                    flags = 0;
                }
                try {
                    repo = this.getRepo(project);
                    if (repo != null) {
                        flags |= this.processDelta(repo, project, delta);
                    }
                }
                catch (IOException | GitAPIException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.commitProject(repo, lastProject, flags);
    }

    private void commitProject(Repository repo, IProject project, int flags) {
        if (repo == null || project == null || flags == 0) {
            return;
        }
        StringBuilder types = new StringBuilder();
        if ((flags & 1) != 0) {
            types.append("A");
        }
        if ((flags & 2) != 0) {
            types.append("C");
        }
        if ((flags & 4) != 0) {
            types.append("R");
        }
        String message = "{\"types\":\"" + types.toString() + "\",\"runs\":" + this.numRuns + "}";
        try {
            Git git = new Git(repo);
            git.commit().setAuthor("S", "s").setCommitter("S", "s").setMessage(message).call();
            git.close();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        repo.close();
    }

    private long getDirSize(File f) {
        if (!f.isDirectory()) {
            return f.length();
        }
        long total = 0L;
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            total += this.getDirSize(child);
            ++n2;
        }
        return total;
    }

    private String getExtension(IResourceDelta delta) {
        if (delta == null) {
            return null;
        }
        IResource res = delta.getResource();
        if (res == null) {
            return null;
        }
        IPath path = res.getLocation();
        if (path == null) {
            return null;
        }
        return path.getFileExtension();
    }

    private Repository getRepo(IProject project) throws IOException {
        File repoDir = new File(project.getLocation().toFile(), ".git");
        long dirSize = this.getDirSize(repoDir);
        if (dirSize > 0xA00000L) {
            return null;
        }
        FileRepository repo = new FileRepository(repoDir);
        try {
            repo.create(false);
        }
        catch (IllegalStateException illegalStateException) {}
        return repo;
    }

    private boolean isStanfordProject(IProject project) {
        if (project.findMember("acm.jar") != null) {
            return true;
        }
        return project.findMember("karel.jar") != null;
    }

    private int processDelta(Repository repo, IProject project, IResourceDelta delta) throws GitAPIException, IOException {
        IResourceDelta[] children;
        int flags = 0;
        if ("class".equals(this.getExtension(delta))) {
            switch (delta.getKind()) {
                case 1: {
                    flags |= 1;
                    break;
                }
                case 4: {
                    flags |= 2;
                    break;
                }
                case 2: {
                    flags |= 4;
                }
            }
            this.updateRepo(repo, project, delta);
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            flags |= this.processDelta(repo, project, child);
            ++n2;
        }
        return flags;
    }

    private void updateRepo(Repository repo, IProject project, IResourceDelta delta) throws GitAPIException, IOException {
        String absPath = delta.getResource().getLocation().toFile().getAbsolutePath();
        String relPath = absPath.substring(project.getLocation().toFile().getAbsolutePath().length() + 1);
        relPath = String.valueOf(relPath.substring(0, relPath.length() - ".class".length())) + ".java";
        if (delta.getKind() == 2) {
            DirCache dirCache = repo.lockDirCache();
            DirCacheEditor editor = dirCache.editor();
            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(relPath));
            editor.commit();
        } else {
            new AddCommand(repo).addFilepattern(relPath).call();
        }
    }
}

