/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.listeners;

import edu.stanford.cs106.CS106Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

class PartIdListener
implements IPageListener,
IPartListener2,
IWindowListener {
    private PartHandler handler;
    private String id;

    public PartIdListener(String id, PartHandler handler) {
        this.handler = handler;
        this.id = id;
        IWorkbench workbench = CS106Plugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.windowOpened(window);
            ++n2;
        }
        workbench.addWindowListener((IWindowListener)this);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            this.partOpened((IWorkbenchPartReference)view);
            ++n2;
        }
        page.addPartListener((IPartListener2)this);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (!this.id.equals(partRef.getId())) {
            return;
        }
        final IWorkbenchPart part = partRef.getPart(true);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PartIdListener.this.handler.handlePart(part);
            }
        });
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            this.pageOpened(page);
            ++n2;
        }
        window.addPageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public static interface PartHandler {
        public void handlePart(IWorkbenchPart var1);
    }
}

