/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.listeners;

import edu.stanford.cs106.CS106Plugin;
import edu.stanford.cs106.listeners.GitListener;
import edu.stanford.cs106.listeners.ResourceFilter;
import edu.stanford.cs106.listeners.ThreadFilter;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.intro.IIntroManager;

public class Startup
implements IStartup {
    public void earlyStartup() {
        this.closeIntro();
        if (this.getPref("threadFiltering")) {
            ThreadFilter.init();
        }
        if (this.getPref("resourceFiltering")) {
            ResourceFilter.init();
        }
        GitListener git = new GitListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)git, 1);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)git);
    }

    private void closeIntro() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IIntroManager manager = CS106Plugin.getDefault().getWorkbench().getIntroManager();
                if (manager.getIntro() != null) {
                    manager.closeIntro(manager.getIntro());
                }
            }
        });
    }

    private boolean getPref(String key) {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getBoolean("edu.stanford.cs106", key, false, null);
    }

    public static class PrefDefaults
    extends AbstractPreferenceInitializer {
        public void initializeDefaultPreferences() {
            IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("edu.stanford.cs106");
            prefs.putBoolean("threadFiltering", true);
            prefs.putBoolean("resourceFiltering", true);
        }
    }

    public static class PrefPage
    extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {
        public void init(IWorkbench workbench) {
        }

        protected void createFieldEditors() {
            this.setMessage("NOTE: You need to restart Eclipse for these preferences to take effect.");
            this.addField((FieldEditor)new BooleanFieldEditor("threadFiltering", "Enable filtering of non-main threads", this.getFieldEditorParent()));
            this.addField((FieldEditor)new BooleanFieldEditor("resourceFiltering", "Enable filtering of advanced resources (e.g. included external jars)", this.getFieldEditorParent()));
        }

        protected IPreferenceStore doGetPreferenceStore() {
            return CS106Plugin.getDefault().getPreferenceStore();
        }
    }
}

