/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.SubmitError;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

class Assignment
implements Comparable<Assignment> {
    private String name;
    private Date dueDate;
    private String dir;

    public Assignment(JSONObject json) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        f.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        this.name = json.getString("Name");
        try {
            this.dueDate = f.parse(json.getString("DueDate"));
        }
        catch (ParseException e) {
            throw new SubmitError("Couldn't read assignment due date.", e);
        }
        this.dir = json.getString("DirectoryName");
    }

    @Override
    public int compareTo(Assignment other) {
        return this.dueDate.compareTo(other.dueDate);
    }

    public String getName() {
        return this.name;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getDir() {
        return this.dir;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.dueDate + ")";
    }
}

