/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AuthDialog
extends Dialog {
    private String initUser;
    private String user;
    private Text userText;
    private String password;
    private Text passwordText;

    public AuthDialog(Shell shell) {
        this(shell, "");
    }

    public AuthDialog(Shell shell, String initUser) {
        super(shell);
        this.initUser = initUser;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.getButton(0).setText("Login");
        return buttons;
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(outer, 0);
        contents.getShell().setText("Login to Stanford");
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(contents, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        l.setText("Enter your SUNet ID and password to log in.");
        data = new GridData(768);
        new Label(contents, 0).setText("SUNet ID:");
        this.userText = new Text(contents, 2048);
        this.userText.setLayoutData((Object)data);
        this.userText.setText(this.initUser);
        new Label(contents, 0).setText("Password:");
        this.passwordText = new Text(contents, 0x400800);
        this.passwordText.setLayoutData((Object)data);
        return outer;
    }

    protected void okPressed() {
        this.user = this.userText.getText();
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    public static class AuthUI
    implements UIKeyboardInteractive,
    UserInfo {
        private Shell shell;

        public AuthUI(Shell shell) {
            this.shell = shell;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassphrase(String msg) {
            return false;
        }

        public boolean promptPassword(String msg) {
            return false;
        }

        public boolean promptYesNo(String msg) {
            return MessageDialog.openQuestion((Shell)this.shell, (String)"Login", (String)msg);
        }

        public void showMessage(String msg) {
            MessageDialog.openInformation((Shell)this.shell, (String)"Login", (String)msg);
        }

        public String[] promptKeyboardInteractive(String dest, String name, String instr, String[] prompts, boolean[] echo) {
            String[] resp = new String[prompts.length];
            int i = 0;
            while (i < prompts.length) {
                InputDialog in = new InputDialog(this.shell, "Login to Stanford", prompts[i], null, null);
                if (in.open() != 0) {
                    return null;
                }
                resp[i] = in.getValue();
                ++i;
            }
            return resp;
        }
    }
}

