/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import edu.stanford.cs106.submitter.AuthDialog;
import edu.stanford.cs106.submitter.Config;
import edu.stanford.cs106.submitter.SubmitError;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

class AuthSession {
    private JSch jsch;
    private Session session;
    private String user;
    private String fullName;

    public static AuthSession create(Shell shell) {
        String user = "";
        AuthDialog dialog;
        while ((dialog = new AuthDialog(shell, user)).open() == 0) {
            user = dialog.getUser();
            String password = dialog.getPassword();
            if (user.length() == 0 || password.length() == 0) {
                AuthSession.showError(shell, "You must enter your SUNet ID and password to login.");
                continue;
            }
            try {
                return new AuthSession(shell, user, password);
            }
            catch (JSchException e) {
                e.printStackTrace();
                AuthSession.showError(shell, "Error logging into Stanford server. Check your SUNet ID and password, and make sure your two-factor is set up.");
                continue;
            }
            break;
        }
        return null;
    }

    private static void showError(Shell shell, String message) {
        MessageDialog.openError((Shell)shell, (String)"Login Error", (String)message);
    }

    public void close() {
        this.session.disconnect();
    }

    public String getUser() {
        return this.user;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isConnected() {
        ChannelExec c = null;
        try {
            c = (ChannelExec)this.session.openChannel("exec");
            c.setCommand("true");
            c.connect();
            return true;
        }
        catch (JSchException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    public String toString() {
        if (this.fullName != null) {
            return String.valueOf(this.fullName) + " (" + this.user + ")";
        }
        return this.user;
    }

    public ChannelSftp startSftp() {
        try {
            ChannelSftp sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            return sftp;
        }
        catch (JSchException e) {
            throw new SubmitError("Unable to start file transfer with server.", e);
        }
    }

    private AuthSession(Shell shell, String user, String password) throws JSchException {
        String key;
        this.user = user;
        Config.Server server = Config.getInstance().getServer();
        this.jsch = new JSch();
        this.session = this.jsch.getSession(user, server.getHost(), server.getPort());
        this.session.setPassword(password);
        this.session.setUserInfo((UserInfo)new AuthDialog.AuthUI(shell));
        String auth = server.getAuth();
        if (auth != null) {
            this.session.setConfig("PreferredAuthentications", auth);
        }
        if ((key = server.getKey()) != null) {
            try {
                this.jsch.setKnownHosts((InputStream)new ByteArrayInputStream(key.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                key = null;
            }
        }
        if (key == null) {
            this.session.setConfig("StrictHostKeyChecking", "no");
        }
        this.session.connect();
        this.setFullName();
    }

    private void setFullName() {
        String cmd = Config.getInstance().getFullNameCmd();
        if (cmd == null) {
            return;
        }
        ChannelExec c = null;
        try {
            try {
                c = (ChannelExec)this.session.openChannel("exec");
                c.setCommand(cmd);
                InputStream in = c.getInputStream();
                c.connect();
                BufferedReader rd = new BufferedReader(new InputStreamReader(in));
                this.fullName = rd.readLine();
            }
            catch (JSchException | IOException e) {
                e.printStackTrace();
                if (c != null) {
                    c.disconnect();
                }
            }
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }
}

