/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.CS106Plugin;
import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.SubmitError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Version;

class Config {
    public static final String COURSE = "CS106A";
    private static final String CONFIG_URL = "https://web.stanford.edu/class/cs106a/submitter/config.json";
    private static Config instance;
    private String fullNameCmd;
    private String gradeTmpl;
    private String gitPath;
    private String submitPath;
    private Server server;
    private Assignment[] assignments;

    public static Config getInstance() {
        return Config.getInstance(false);
    }

    public static Config getInstance(boolean reload) {
        if (instance == null || reload) {
            instance = new Config();
        }
        return instance;
    }

    public String getFullNameCmd() {
        return this.fullNameCmd;
    }

    public String getGradeTmpl() {
        return this.gradeTmpl;
    }

    public String getGitPath() {
        return this.gitPath;
    }

    public String getSubmitPath() {
        return this.submitPath;
    }

    public Server getServer() {
        return this.server;
    }

    public Assignment[] getAssignments() {
        return this.assignments;
    }

    private Config() {
        try {
            JSONObject json = new JSONObject(this.readJSON(CONFIG_URL));
            Version min = new Version(json.getString("min_version"));
            if (CS106Plugin.getVersion().compareTo(min) < 0) {
                throw new SubmitError("Your Stanford Eclipse plugin is out of date and can't submit projects.\nPlease download the updated software from CS106A.stanford.edu/.");
            }
            this.fullNameCmd = Config.strOrNull(json, "full_name_cmd");
            this.gradeTmpl = Config.strOrNull(json, "grade_tmpl");
            this.gitPath = Config.strOrNull(json, "git_path");
            this.submitPath = json.getString("submit_path");
            this.server = new Server(json.getJSONObject("server"));
            String assignURL = json.getString("assignments_url");
            JSONArray assignJSON = new JSONArray(this.readJSON(assignURL));
            if (assignJSON.length() == 0) {
                throw new SubmitError("No assignments to submit for CS106A.");
            }
            this.assignments = new Assignment[assignJSON.length()];
            int i = 0;
            while (i < assignJSON.length()) {
                this.assignments[i] = new Assignment(assignJSON.getJSONObject(i));
                ++i;
            }
            Arrays.sort(this.assignments);
        }
        catch (JSONException e) {
            String msg = "Couldn't read submitter configuration for CS106A\n\nCheck your network connection and try again. If this problem continues, contact the course staff.";
            throw new SubmitError(msg, e);
        }
    }

    private static String strOrNull(JSONObject json, String key) {
        if (json.isNull(key)) {
            return null;
        }
        String s = json.getString(key);
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private JSONTokener readJSON(String url) {
        try {
            InputStream stream = new URL(url).openStream();
            return new JSONTokener(stream);
        }
        catch (IOException e) {
            throw new SubmitError("Couldn't get CS106A submitter configuration file.", e);
        }
    }

    public static class Server {
        private String host;
        private int port;
        private String auth;
        private String key;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getAuth() {
            return this.auth;
        }

        public String getKey() {
            return this.key;
        }

        private Server(JSONObject json) {
            this.host = json.getString("host");
            this.port = json.getInt("port");
            this.auth = Config.strOrNull(json, "auth");
            this.key = Config.strOrNull(json, "key");
        }
    }
}

