/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.AuthSession;
import edu.stanford.cs106.submitter.Config;
import edu.stanford.cs106.submitter.RunSubmit;
import edu.stanford.cs106.submitter.Submission;
import edu.stanford.cs106.submitter.SubmitDialog;
import edu.stanford.cs106.submitter.SubmitError;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Main
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        Submission sub;
        Shell shell;
        block5: {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Config.getInstance(true);
            sub = new Submission();
            if (sub.auth == null || !this.promptLastSession(shell, sub.auth)) {
                sub.setAuth(AuthSession.create(shell));
            }
            if (sub.auth != null) break block5;
            return null;
        }
        try {
            SubmitDialog dialog = new SubmitDialog(shell, sub);
            int res = dialog.open();
            if (res == 0) {
                this.runSubmit(shell, sub);
            }
        }
        catch (SubmitError e) {
            ErrorDialog.openError((Shell)shell, (String)"Submit Error", null, (IStatus)e.getStatus());
            e.printStackTrace();
        }
        return null;
    }

    private boolean promptLastSession(Shell shell, AuthSession auth) {
        String msg = "You are currently logged in as:\n\n" + auth.toString() + "\n\nIs this correct?";
        return MessageDialog.openQuestion((Shell)shell, (String)"Logged In", (String)msg);
    }

    private void runSubmit(Shell shell, Submission sub) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new RunSubmit(sub));
            MessageDialog.openInformation((Shell)shell, (String)"Submit Successful", (String)("You have successfully submitted " + sub.assignment.getName() + " for " + "CS106A" + "."));
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openError((Shell)shell, (String)"Submit Canceled", (String)"Submission canceled.");
        }
        catch (InvocationTargetException e) {
            Throwable inner = e.getCause();
            if (inner instanceof SubmitError) {
                throw (SubmitError)inner;
            }
            throw new SubmitError("Unexpected error while submitting assignment.", inner);
        }
    }
}

