/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import edu.stanford.cs106.submitter.Config;
import edu.stanford.cs106.submitter.Submission;
import edu.stanford.cs106.submitter.SubmitError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

class RunSubmit
implements IRunnableWithProgress {
    private static final String DATE_FILE = "lateDays.txt";
    private static final String GIT_DATE_FILE = "info.txt";
    private static final String GRADE_FILE = "GRADE.txt";
    private static final String PROJECT_FILE = ".project";
    private static final HashSet<String> SKIP_FILES = new HashSet<String>(Arrays.asList("lateDays.txt", "GRADE.txt"));
    private int numFiles;
    private ChannelSftp sftp;
    private Submission sub;

    public RunSubmit(Submission sub) {
        this.sub = sub;
    }

    public void run(IProgressMonitor pm) throws InterruptedException {
        String submitDir;
        File root = this.sub.project.getLocation().toFile();
        this.walkDir(root, true, new FileHandler(){

            @Override
            public void process(String path, boolean dir) {
                RunSubmit runSubmit = RunSubmit.this;
                runSubmit.numFiles = runSubmit.numFiles + 1;
            }
        }, null);
        pm.beginTask("Submitting project...", this.numFiles);
        this.sftp = this.sub.auth.startSftp();
        try {
            this.sftp.lcd(root.getPath());
            this.sftp.cd(Config.getInstance().getSubmitPath());
            this.cd_create(this.sub.assignment.getDir());
            submitDir = this.makeSubmitDir();
        }
        catch (SftpException e) {
            throw new SubmitError("Error creating submission folder.", e);
        }
        this.walkDir(root, true, new FileHandler(){

            @Override
            public void process(String path, boolean dir) {
                if (SKIP_FILES.contains(path)) {
                    return;
                }
                try {
                    if (path.equals(RunSubmit.PROJECT_FILE)) {
                        RunSubmit.this.writeProjectFile(path);
                        return;
                    }
                    if (dir) {
                        RunSubmit.this.sftp.mkdir(path);
                    } else {
                        RunSubmit.this.sftp.put(path, path);
                    }
                }
                catch (SftpException e) {
                    throw new SubmitError("Error sending " + path, e);
                }
            }
        }, pm);
        pm.subTask("Finishing submit...");
        this.finishSubmit();
        String gitPath = Config.getInstance().getGitPath();
        if (gitPath != null) {
            this.submitGit(gitPath, submitDir);
        }
    }

    private void cd_create(String dir) throws SftpException {
        try {
            this.sftp.mkdir(dir);
        }
        catch (SftpException sftpException) {}
        this.sftp.cd(dir);
    }

    private void finishSubmit() {
        try {
            String gradeTmpl = Config.getInstance().getGradeTmpl();
            if (gradeTmpl != null) {
                this.writeGradeFile(GRADE_FILE, gradeTmpl);
            }
            this.writeDateFile(DATE_FILE);
        }
        catch (SftpException sftpException) {}
    }

    private String makeSubmitDir() throws SftpException {
        String prefix = String.valueOf(this.sub.auth.getUser()) + "_";
        int max = 0;
        Vector submits = this.sftp.ls(String.valueOf(prefix) + "*");
        for (ChannelSftp.LsEntry ent : submits) {
            int num;
            String name = ent.getFilename();
            try {
                num = Integer.parseInt(name.substring(prefix.length()));
            }
            catch (NumberFormatException numberFormatException) {
                num = -1;
            }
            if (num <= max) continue;
            max = num;
        }
        String dir = String.valueOf(prefix) + (max + 1);
        this.sftp.mkdir(dir);
        this.sftp.cd(dir);
        return dir;
    }

    private void submitGit(String gitPath, String submitDir) {
        try {
            this.sftp.cd(gitPath);
            this.cd_create(this.sub.assignment.getDir());
            this.cd_create(submitDir);
            this.writeDateFile(GIT_DATE_FILE);
            this.cd_create(".git");
            File gitRoot = new File(this.sub.project.getLocation().toFile(), ".git");
            this.sftp.lcd(gitRoot.getPath());
            this.walkDir(gitRoot, false, new FileHandler(){

                @Override
                public void process(String path, boolean dir) {
                    try {
                        if (dir) {
                            RunSubmit.this.sftp.mkdir(path);
                        } else {
                            RunSubmit.this.sftp.put(path, path);
                        }
                    }
                    catch (SftpException e) {
                        e.printStackTrace();
                    }
                }
            }, null);
        }
        catch (SftpException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void walkDir(File root, boolean skipGit, FileHandler h, IProgressMonitor pm) throws InterruptedException {
        this.walkDir("", root, skipGit, h, pm);
    }

    private void walkDir(String path, File root, boolean skipGit, FileHandler h, IProgressMonitor pm) throws InterruptedException {
        File[] files = new File(root, path).listFiles();
        if (files == null) {
            throw new SubmitError("Unexpected error: " + path + " not a directory.");
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String p = String.valueOf(path.length() != 0 ? String.valueOf(path) + "/" : "") + f.getName();
            if (!skipGit || !p.startsWith(".git")) {
                if (pm != null) {
                    if (pm.isCanceled()) {
                        throw new InterruptedException();
                    }
                    pm.subTask(p);
                }
                boolean dir = f.isDirectory();
                h.process(p, dir);
                if (pm != null) {
                    pm.worked(1);
                }
                if (dir) {
                    this.walkDir(p, root, skipGit, h, pm);
                }
            }
            ++n2;
        }
    }

    private void writeDateFile(String path) throws SftpException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.sftp.put(path)));
        SimpleDateFormat f = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss");
        out.println("student_submission_time: " + f.format(new Date()));
        out.println("assignment_due_time: " + f.format(this.sub.assignment.getDueDate()));
        out.close();
    }

    private void writeGradeFile(String path, String tmplPath) throws SftpException {
        InputStream in = this.sftp.get(tmplPath);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.sftp.put(path)));
        Scanner s = new Scanner(in);
        s.useDelimiter("\\A");
        if (s.hasNext()) {
            out.print(s.next());
        }
        s.close();
        out.close();
    }

    private void writeProjectFile(String path) throws SftpException {
        this.sftp.put(path, ".project.bak");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.sftp.put(path)));
        File file = new File(this.sub.project.getLocation().toFile(), path);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader rd = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = rd.readLine()) != null) {
                    Pattern p = Pattern.compile("(.*<name>" + Pattern.quote(this.sub.project.getName()) + ")(</name>.*)");
                    Matcher m = p.matcher(line);
                    if (m.matches()) {
                        line = String.valueOf(m.group(1)) + "_" + this.sub.auth.getUser() + m.group(2);
                    }
                    out.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        out.close();
    }

    private static interface FileHandler {
        public void process(String var1, boolean var2);
    }
}

