/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.Config;
import edu.stanford.cs106.submitter.Submission;
import edu.stanford.cs106.submitter.SubmitError;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class SubmitDialog
extends TitleAreaDialog
implements SelectionListener {
    private Combo assignment;
    private Label dueDate;
    private Label login;
    private Label project;
    private Button projectButton;
    private Submission sub;

    public SubmitDialog(Shell shell, Submission sub) {
        super(shell);
        this.sub = sub;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.assignment) {
            this.updateAssignment();
        } else if (e.getSource() == this.projectButton) {
            this.chooseProject();
        } else {
            throw new SubmitError("An unexpected error occurred.\nUnrecognized event source.");
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.setOkEnabled(false);
        this.getButton(0).setText("Submit");
        return buttons;
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(outer, 0);
        contents.getShell().setText("Submit Project");
        this.setTitle("Submit Project");
        this.setMessage("Select the assignment and project to submit.");
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(3, false));
        this.addLogin(contents);
        this.addAssignment(contents);
        this.addProject(contents);
        return outer;
    }

    protected void okPressed() {
        String name = this.project.getText();
        Assignment[] assignmentArray = Config.getInstance().getAssignments();
        int n = assignmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Assignment a = assignmentArray[n2];
            if (a.getDir().equalsIgnoreCase(name)) {
                MessageDialog warn;
                if (a == this.sub.assignment || (warn = new MessageDialog(this.getShell(), "Submit Project", null, "It looks like you're trying to submit " + a.getName() + ", but you chose " + this.sub.assignment.getName() + ".\n\nDo you want to continue?", 4, new String[]{"Yes", "No"}, 1)).open() == 0) break;
                return;
            }
            ++n2;
        }
        super.okPressed();
    }

    private void addAssignment(Composite contents) {
        new Label(contents, 0).setText("Assignment:");
        this.assignment = new Combo(contents, 12);
        this.assignment.addSelectionListener((SelectionListener)this);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.assignment.setLayoutData((Object)data);
        Date now = new Date();
        boolean future = false;
        int selected = -1;
        Assignment[] assignments = Config.getInstance().getAssignments();
        int i = 0;
        while (i < assignments.length) {
            Assignment a = assignments[i];
            this.assignment.add(a.getName());
            if (!future) {
                selected = i;
            }
            if (now.compareTo(a.getDueDate()) < 0) {
                future = true;
            }
            ++i;
        }
        this.assignment.select(selected);
        new Label(contents, 0).setText("Due:");
        this.dueDate = new Label(contents, 0);
        this.setBold(this.dueDate);
        this.dueDate.setLayoutData((Object)data);
        this.updateAssignment();
    }

    private void addLogin(Composite contents) {
        new Label(contents, 0).setText("Logged in as:");
        this.login = new Label(contents, 0);
        this.setBold(this.login);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.login.setLayoutData((Object)data);
        this.login.setText(this.sub.auth.toString());
    }

    private void addProject(Composite contents) {
        new Label(contents, 0).setText("Project:");
        this.project = new Label(contents, 0);
        GridData data = new GridData(768);
        this.project.setLayoutData((Object)data);
        this.setBold(this.project);
        this.project.setText("<None selected>");
        this.projectButton = new Button(contents, 8);
        this.projectButton.addSelectionListener((SelectionListener)this);
        this.projectButton.setText("Choose...");
    }

    private void chooseProject() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle("Select Project");
        dialog.setMessage("Select the Eclipse project to submit.");
        dialog.setElements((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
        if (dialog.open() != 0) {
            return;
        }
        this.sub.project = (IProject)dialog.getFirstResult();
        this.project.setText(this.sub.project.getName());
        this.setOkEnabled(true);
    }

    private void setBold(Label l) {
        FontDescriptor fd = FontDescriptor.createFrom((Font)l.getFont()).setStyle(1);
        l.setFont(fd.createFont((Device)l.getDisplay()));
    }

    private void setOkEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private void updateAssignment() {
        this.sub.assignment = Config.getInstance().getAssignments()[this.assignment.getSelectionIndex()];
        SimpleDateFormat f = new SimpleDateFormat("EEE, MMM d, yyyy h:mm:ss aa zzz");
        this.dueDate.setText(f.format(this.sub.assignment.getDueDate()));
    }
}

