/*
 * Decompiled with CFR 0.152.
 */
package acmx.export;

import acm.util.ErrorException;
import acm.util.JTFTools;
import acmx.classfile.Attribute;
import acmx.classfile.ClassEntry;
import acmx.classfile.ClassTransformer;
import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.FieldRefEntry;
import acmx.classfile.JVMOperation;
import acmx.classfile.JavaClass;
import acmx.classfile.JavaField;
import acmx.classfile.JavaMethod;
import acmx.classfile.MethodRefEntry;
import acmx.classfile.NameAndTypeEntry;
import acmx.export.JDK11MethodPatches;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDK11Transformer
implements ClassTransformer {
    private static final int OLD_STYLE_SIZE = 52;
    private static final int OLD_STYLE_MAX_STACK = 3;
    private static final int OLD_STYLE_MAX_LOCALS = 6;
    private static final int OLD_STYLE_EX_START = 9;
    private static final int OLD_STYLE_EX_END = 21;
    private static final int OLD_STYLE_EX_HANDLER = 21;
    private static final int[] OLD_STYLE_CODE;
    private static final String EXPORT_PACKAGE = "acmx.export";
    private static final String[] FIELD_ATTRIBUTES;
    private static final String[] METHOD_ATTRIBUTES;
    private static final String[] CLASS_ATTRIBUTES;
    private Map<String, String> classSubstitutions = this.createClassSubstitutionTable();
    private Map<String, String> colorSubstitutions = this.createColorSubstitutionTable();
    private Map<String, String> methodSubstitutions = JDK11MethodPatches.getSubstitutionTable();

    static {
        int[] nArray = new int[32];
        nArray[0] = 43;
        nArray[1] = 182;
        nArray[4] = 58;
        nArray[5] = 4;
        nArray[6] = 25;
        nArray[7] = 4;
        nArray[8] = 194;
        nArray[9] = 42;
        nArray[10] = 43;
        nArray[11] = 28;
        nArray[12] = 183;
        nArray[15] = 78;
        nArray[16] = 168;
        nArray[18] = 9;
        nArray[19] = 45;
        nArray[20] = 176;
        nArray[21] = 25;
        nArray[22] = 4;
        nArray[23] = 195;
        nArray[24] = 191;
        nArray[25] = 58;
        nArray[26] = 5;
        nArray[27] = 25;
        nArray[28] = 4;
        nArray[29] = 195;
        nArray[30] = 169;
        nArray[31] = 5;
        OLD_STYLE_CODE = nArray;
        FIELD_ATTRIBUTES = new String[]{"ConstantValue"};
        METHOD_ATTRIBUTES = new String[]{"Code", "Exceptions"};
        CLASS_ATTRIBUTES = new String[]{"SourceFile"};
    }

    public JDK11Transformer() {
        if (JTFTools.testDebugOption("checkClassSubstitutionTable")) {
            this.checkClassSubstitutionTable();
        }
    }

    @Override
    public void apply(JavaClass jc) {
        Attribute attribute;
        Iterator<Attribute> attributes;
        boolean updateFlag;
        jc.setMajorVersion(45);
        jc.setMinorVersion(3);
        boolean bl = updateFlag = !this.checkForSwingClass(jc.getClassName());
        if (updateFlag) {
            Iterator<ConstantPoolEntry> constants = jc.constantPoolIterator();
            while (constants.hasNext()) {
                ConstantPoolEntry entry = constants.next();
                switch (entry.getEntryType()) {
                    case 7: {
                        this.fixClassEntry((ClassEntry)entry);
                        break;
                    }
                    case 12: {
                        this.fixNameAndTypeEntry((NameAndTypeEntry)entry);
                        break;
                    }
                    case 9: {
                        this.fixFieldRefEntry((FieldRefEntry)entry);
                    }
                }
            }
        }
        Iterator<JavaField> fields = jc.fieldIterator();
        while (fields.hasNext()) {
            String newType;
            String oldType;
            JavaField field = fields.next();
            if (updateFlag && (oldType = field.getDescriptor()) != (newType = this.fixDescriptor(oldType))) {
                field.setDescriptor(newType);
            }
            attributes = field.attributeIterator();
            while (attributes.hasNext()) {
                attribute = attributes.next();
                if (this.isEssentialAttribute(attribute, FIELD_ATTRIBUTES)) continue;
                attributes.remove();
            }
        }
        Iterator<JavaMethod> methods = jc.methodIterator();
        while (methods.hasNext()) {
            JavaMethod method = methods.next();
            if (updateFlag) {
                String newType;
                String oldType = method.getDescriptor();
                if (oldType != (newType = this.fixDescriptor(oldType))) {
                    method.setDescriptor(newType);
                }
                Iterator<JVMOperation> operations = method.codeIterator();
                while (operations.hasNext()) {
                    JVMOperation op = operations.next();
                    int refIndex = op.getMethodRefIndex();
                    if (refIndex == -1) continue;
                    this.fixMethodRef((MethodRefEntry)jc.getConstantPoolEntry(refIndex), op);
                }
            }
            Iterator<Attribute> attributes2 = method.attributeIterator();
            while (attributes2.hasNext()) {
                Attribute attribute2 = attributes2.next();
                if (!this.isEssentialAttribute(attribute2, METHOD_ATTRIBUTES)) {
                    attributes2.remove();
                    continue;
                }
                if (!attribute2.getName().equals("Code")) continue;
                if (jc.getClassName().equals("acm.gui.TableLayout") && method.getName().equals("processLayout")) {
                    this.patchProcessLayout(attribute2);
                    continue;
                }
                this.fixCodeAttribute(attribute2);
            }
        }
        attributes = jc.attributeIterator();
        while (attributes.hasNext()) {
            attribute = attributes.next();
            if (this.isEssentialAttribute(attribute, CLASS_ATTRIBUTES)) continue;
            attributes.remove();
        }
    }

    private void fixClassEntry(ClassEntry entry) {
        String newName;
        String oldName = entry.getName();
        String string = newName = oldName.startsWith("[") ? this.fixDescriptor(oldName) : this.classSubstitutions.get(oldName);
        if (newName != null && !oldName.equals(newName)) {
            entry.setName(newName);
        }
    }

    private void fixNameAndTypeEntry(NameAndTypeEntry entry) {
        String oldType = entry.getDescriptor();
        String newType = this.fixDescriptor(oldType);
        if (!newType.equals(oldType)) {
            entry.setTypeDescriptor(newType);
        }
    }

    private void fixFieldRefEntry(FieldRefEntry entry) {
        String oldName;
        String newName;
        JavaClass jc = entry.getOwner();
        int classIndex = entry.getClassIndex();
        ClassEntry classEntry = (ClassEntry)jc.getConstantPoolEntry(classIndex);
        int ntIndex = entry.getNameAndTypeIndex();
        NameAndTypeEntry ntEntry = (NameAndTypeEntry)jc.getConstantPoolEntry(ntIndex);
        if (classEntry.getName().equals("java/awt/Color") && (newName = this.colorSubstitutions.get(oldName = ntEntry.getName())) != null) {
            int nameIndex = jc.createUTF8Entry(newName);
            int typeIndex = ntEntry.getDescriptorIndex();
            ntIndex = jc.createNameAndTypeEntry(nameIndex, typeIndex);
            entry.setNameAndTypeIndex(ntIndex);
        }
    }

    private String fixDescriptor(String oldDescriptor) {
        String newDescriptor = "";
        int cp = 0;
        while (cp < oldDescriptor.length()) {
            char ch = oldDescriptor.charAt(cp);
            if (ch == 'L') {
                int semi = oldDescriptor.indexOf(59, cp);
                if (semi == -1) {
                    throw new ErrorException("Bad descriptor " + oldDescriptor);
                }
                String oldName = oldDescriptor.substring(cp + 1, semi);
                String newName = this.classSubstitutions.get(oldName);
                if (newName == null) {
                    newName = oldName;
                }
                newDescriptor = String.valueOf(newDescriptor) + 'L' + newName + ';';
                cp = semi;
            } else {
                newDescriptor = String.valueOf(newDescriptor) + ch;
            }
            ++cp;
        }
        return newDescriptor;
    }

    private void fixMethodRef(MethodRefEntry methodRef, JVMOperation op) {
        String oldPrototype = methodRef.getPrototype();
        String newPrototype = this.methodSubstitutions.get(oldPrototype);
        if (newPrototype != null) {
            op.setMethodRef(methodRef.getOwner().createMethodRefEntry(newPrototype));
        }
    }

    private void fixCodeAttribute(Attribute attribute) {
        try {
            byte[] oldBytes = attribute.getData();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(oldBytes));
            in.skip(4L);
            int codeLength = in.readInt();
            in.skip(codeLength);
            short exceptionTableLength = in.readShort();
            in.skip(8 * exceptionTableLength);
            in.close();
            int attributeSize = 12 + codeLength + 8 * exceptionTableLength;
            byte[] newBytes = new byte[attributeSize];
            System.arraycopy(oldBytes, 0, newBytes, 0, attributeSize - 2);
            attribute.setData(newBytes);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private boolean isEssentialAttribute(Attribute attribute, String[] array) {
        String name = attribute.getName();
        int i = 0;
        while (i < array.length) {
            if (name.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Map<String, String> createClassSubstitutionTable() {
        String prefix = String.valueOf(EXPORT_PACKAGE.replace('.', '/')) + "/";
        HashMap<String, String> subs = new HashMap<String, String>();
        ArrayList<String> exportClasses = null;
        exportClasses = JTFTools.testDebugOption("readClassListFromDir") ? this.readClassListFromDir() : this.readClassListFromJar();
        int i = 0;
        while (i < exportClasses.size()) {
            String exportName = exportClasses.get(i);
            if (!(exportName = exportName.substring(0, exportName.length() - ".class".length())).startsWith(prefix)) {
                throw new ErrorException("Illegal export class: " + exportName);
            }
            String javaName = exportName.substring(prefix.length());
            subs.put(javaName, exportName);
            ++i;
        }
        subs.put("java/lang/StringBuilder", "java/lang/StringBuffer");
        return subs;
    }

    private Map<String, String> createColorSubstitutionTable() {
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put("BLACK", "black");
        subs.put("BLUE", "blue");
        subs.put("CYAN", "cyan");
        subs.put("DARK_GRAY", "darkGray");
        subs.put("GRAY", "gray");
        subs.put("GREEN", "green");
        subs.put("LIGHT_GRAY", "lightGray");
        subs.put("MAGENTA", "magenta");
        subs.put("ORANGE", "orange");
        subs.put("PINK", "pink");
        subs.put("RED", "red");
        subs.put("WHITE", "white");
        subs.put("YELLOW", "yellow");
        return subs;
    }

    private ArrayList<String> readClassListFromJar() {
        String prefix = String.valueOf(EXPORT_PACKAGE.replace('.', '/')) + "/";
        ZipFile file = null;
        String classPath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classPath, ":");
        try {
            while (tokenizer.hasMoreTokens() && file == null) {
                String pathElement = tokenizer.nextToken();
                if (pathElement.equals("acm.jar")) {
                    file = new ZipFile(new File(new File(System.getProperty("user.dir")), "acm.jar"));
                    continue;
                }
                if (!pathElement.endsWith("/acm.jar")) continue;
                file = new ZipFile(new File(pathElement));
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
        ArrayList<String> exportClasses = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e = file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.startsWith(prefix) || !name.endsWith(".class")) continue;
            exportClasses.add(name);
        }
        return exportClasses;
    }

    private ArrayList<String> readClassListFromDir() {
        String prefix = String.valueOf(EXPORT_PACKAGE.replace('.', '/')) + "/";
        ArrayList<String> exportClasses = new ArrayList<String>();
        File dir = new File(String.valueOf(System.getProperty("user.dir")) + "/" + prefix);
        this.scanForSourceFiles(dir, prefix, exportClasses, 0);
        return exportClasses;
    }

    private void scanForSourceFiles(File dir, String prefix, ArrayList<String> exportClasses, int level) {
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            File file = new File(dir, filename);
            if (file.isDirectory()) {
                this.scanForSourceFiles(file, String.valueOf(prefix) + filename + "/", exportClasses, level + 1);
            } else if (filename.endsWith(".java") && level > 0) {
                exportClasses.add(String.valueOf(prefix) + filename.substring(0, filename.length() - 5));
            }
            ++i;
        }
    }

    private boolean checkForSwingClass(String name) {
        if (!name.startsWith("acm.") && !name.startsWith("acmx.")) {
            return false;
        }
        if (name.equals("acm.util.SwingTimer")) {
            return false;
        }
        if (name.equals("acmx.export.javax.swing.SwingInteractor")) {
            return false;
        }
        return name.substring(name.lastIndexOf(46) + 1).startsWith("Swing");
    }

    private void checkClassSubstitutionTable() {
        for (String oldClassName : this.classSubstitutions.keySet()) {
            String newClassName = this.classSubstitutions.get(oldClassName);
            try {
                Class<?> oldClass = Class.forName(oldClassName.replace('/', '.'));
                if (Modifier.isInterface(oldClass.getModifiers())) continue;
                Method[] methods = Class.forName(newClassName.replace('/', '.')).getMethods();
                int i = 0;
                while (i < methods.length) {
                    Method method = methods[i];
                    int modifiers = method.getModifiers();
                    if (Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers)) {
                        String name = method.getName();
                        Class<?>[] args = method.getParameterTypes();
                        int j = 0;
                        while (j < args.length) {
                            String className = args[j].getName();
                            if (className.startsWith("acmx.export.")) {
                                className = className.substring(EXPORT_PACKAGE.length() + 1);
                                args[j] = Class.forName(className);
                            }
                            ++j;
                        }
                        try {
                            oldClass.getMethod(name, args);
                        }
                        catch (Exception ex) {
                            System.err.println("No match for " + method);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void patchProcessLayout(Attribute attribute) {
        byte[] oldBytes = attribute.getData();
        int c1 = 0;
        int c2 = 0;
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] == -74) {
                c1 = i + 1;
                i += 2;
            } else if (oldBytes[i] == -73) {
                c2 = i + 1;
                break;
            }
            ++i;
        }
        if (c2 == 0) {
            throw new ErrorException("processLayout code changed");
        }
        byte[] newBytes = new byte[52];
        int nx = 0;
        newBytes[nx++] = 0;
        newBytes[nx++] = 3;
        newBytes[nx++] = 0;
        newBytes[nx++] = 6;
        newBytes[nx++] = 0;
        newBytes[nx++] = 0;
        newBytes[nx++] = 0;
        newBytes[nx++] = (byte)OLD_STYLE_CODE.length;
        int i2 = 0;
        while (i2 < OLD_STYLE_CODE.length) {
            int xx = OLD_STYLE_CODE[i2];
            newBytes[nx++] = (byte)xx;
            if (xx == 182) {
                newBytes[nx++] = oldBytes[c1++];
                newBytes[nx++] = oldBytes[c1];
                i2 += 2;
            } else if (xx == 183) {
                newBytes[nx++] = oldBytes[c2++];
                newBytes[nx++] = oldBytes[c2];
                i2 += 2;
            }
            ++i2;
        }
        newBytes[nx++] = 0;
        newBytes[nx++] = 1;
        newBytes[nx++] = 0;
        newBytes[nx++] = 9;
        newBytes[nx++] = 0;
        newBytes[nx++] = 21;
        newBytes[nx++] = 0;
        newBytes[nx++] = 21;
        newBytes[nx++] = 0;
        newBytes[nx++] = 0;
        attribute.setData(newBytes);
    }
}

