/*
 * Decompiled with CFR 0.152.
 */
package acmx.export;

import acm.gui.TableLayout;
import acm.program.Program;
import acm.util.JTFTools;
import acmx.export.ProgressBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

class ProgressBarDialog
extends JDialog
implements ActionListener {
    private static final int DIALOG_WIDTH = 250;
    private static final int DIALOG_HEIGHT = 90;
    private static final int PROGRESS_BAR_HEIGHT = 25;
    private ProgressBar progressBar;
    private boolean cancelFlag;

    public ProgressBarDialog(Program program) {
        super(JTFTools.getEnclosingFrame(program), "Progress", false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new TableLayout(2, 1));
        this.progressBar = new ProgressBar();
        contentPane.add((Component)this.progressBar, "weightx=1 left=5 right=5 height=25");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        contentPane.add((Component)cancelButton, "top=10 fill=NONE");
        Rectangle programBounds = program.getBounds();
        int x = programBounds.x + (programBounds.width - 250) / 2;
        int y = programBounds.y + (programBounds.height - 90) / 2;
        this.setBounds(x, y, 250, 90);
    }

    public void popup() {
        this.setVisible(true);
        this.repaint();
    }

    public boolean hasBeenCancelled() {
        return this.cancelFlag;
    }

    public void setMaximumBumpCount(int max) {
        this.progressBar.setMaximumBumpCount(max);
    }

    public void bump() {
        this.progressBar.bump();
    }

    public void actionPerformed(ActionEvent e) {
        this.cancelFlag = true;
        this.setVisible(false);
    }
}

