/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.JTextFieldModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class AWTTextField
extends Component
implements JTextFieldModel,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    private static final Color BORDER_COLOR = new Color(0x666666);
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private static final int MARGIN = 3;
    private ArrayList<ActionListener> actionListeners;
    private String input;
    private int selectionStart;
    private int selectionEnd;
    private int alignment;
    private int startX;
    private int nColumns;
    private String actionCommand;
    private boolean hasFocus;
    private boolean isEditable;

    public AWTTextField() {
        this.setBackground(Color.WHITE);
        this.setFont(JTFTools.getStandardFont(FONT));
        this.setText("");
        this.actionListeners = new ArrayList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.isEditable = true;
    }

    public void setText(String text) {
        this.input = text;
        this.selectionStart = this.selectionEnd = this.input.length();
        this.repaint();
    }

    public String getText() {
        return this.input;
    }

    public void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.input.length();
    }

    public void setHorizontalAlignment(int align) {
        this.alignment = align;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setColumns(int columns) {
        this.nColumns = columns;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        int nc = this.nColumns == 0 ? 10 : this.nColumns;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return new Dimension(nc * fm.stringWidth("m") + 6, 22);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(BORDER_COLOR);
        g.drawRect(0, 0, size.width - 2, size.height - 2);
        g.setColor(Color.WHITE);
        g.drawRect(1, 1, size.width - 2, size.height - 2);
        g.setColor(this.getBackground());
        g.drawLine(1, size.height - 1, 1, size.height - 1);
        g.drawLine(size.width - 1, 1, size.width - 1, 1);
        FontMetrics fm = g.getFontMetrics();
        int x = 3;
        switch (this.alignment) {
            case 0: {
                x = (size.width - fm.stringWidth(this.input)) / 2;
                break;
            }
            case 4: {
                x = size.width - fm.stringWidth(this.input) - 3;
            }
        }
        int y = (size.height + fm.getAscent()) / 2 - 2;
        int bottom = y + fm.getDescent() + 1;
        int top = y - fm.getAscent() - 1;
        if (this.hasFocus) {
            if (this.selectionStart == this.selectionEnd) {
                g.setColor(Color.GRAY);
                int cx = x + fm.stringWidth(this.input.substring(0, this.selectionEnd));
                g.drawLine(cx, bottom, cx, top);
                g.setColor(this.getForeground());
                g.drawString(this.input, x, y);
            } else {
                g.setColor(SystemColor.textHighlight);
                int left = x + fm.stringWidth(this.input.substring(0, this.selectionStart));
                int right = x + fm.stringWidth(this.input.substring(0, this.selectionEnd));
                g.fillRect(left, top, right - left, bottom - top);
                g.setColor(this.getForeground());
                g.drawString(this.input.substring(0, this.selectionStart), x, y);
                g.drawString(this.input.substring(this.selectionEnd), right, y);
                g.setColor(SystemColor.textHighlightText);
                g.drawString(this.input.substring(this.selectionStart, this.selectionEnd), left, y);
            }
        } else {
            g.setColor(this.getForeground());
            g.drawString(this.input, x, y);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.repaint();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.repaint();
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent e) {
        this.startX = e.getX();
        if (e.getClickCount() > 1) {
            this.selectionStart = 0;
            this.selectionEnd = this.input.length();
        } else {
            this.selectionStart = this.selectionEnd = this.findTextIndex(this.startX);
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        int p1 = this.findTextIndex(this.startX);
        int p2 = this.findTextIndex(e.getX());
        this.selectionStart = Math.min(p1, p2);
        this.selectionEnd = Math.max(p1, p2);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (!this.isEditable) {
            return;
        }
        char ch = e.getKeyChar();
        switch (ch) {
            case '\b': 
            case '\u007f': {
                if (this.selectionStart == this.selectionEnd) {
                    if (this.selectionStart > 0) {
                        this.input = String.valueOf(this.input.substring(0, this.selectionStart - 1)) + this.input.substring(this.selectionStart);
                        --this.selectionStart;
                    }
                } else {
                    this.input = String.valueOf(this.input.substring(0, this.selectionStart)) + this.input.substring(this.selectionEnd);
                }
                this.selectionEnd = this.selectionStart;
                break;
            }
            case '\n': 
            case '\r': {
                this.fireActionListeners(new ActionEvent(e.getSource(), 1001, this.actionCommand, e.getModifiers()));
                break;
            }
            case '\t': {
                break;
            }
            default: {
                this.input = String.valueOf(this.input.substring(0, this.selectionStart)) + ch + this.input.substring(this.selectionEnd);
                ++this.selectionStart;
                this.selectionEnd = this.selectionStart;
            }
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                if (this.selectionStart == this.selectionEnd) {
                    this.selectionStart = this.selectionEnd = Math.max(0, this.selectionStart - 1);
                } else {
                    this.selectionEnd = this.selectionStart;
                }
                this.repaint();
                break;
            }
            case 39: {
                this.selectionStart = this.selectionStart == this.selectionEnd ? (this.selectionEnd = Math.min(this.input.length(), this.selectionStart + 1)) : this.selectionEnd;
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.repaint();
    }

    private int findTextIndex(int x) {
        Dimension size = this.getSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int start = 3;
        switch (this.alignment) {
            case 0: {
                start = (size.width - fm.stringWidth(this.input)) / 2;
                break;
            }
            case 4: {
                start = size.width - fm.stringWidth(this.input) - 3;
            }
        }
        int minDistance = Math.abs(start - x);
        int minIndex = 0;
        int i = 1;
        while (i <= this.input.length()) {
            int distance = Math.abs(start + fm.stringWidth(this.input.substring(0, i)) - x);
            if (distance < minDistance) {
                minIndex = i;
                minDistance = distance;
            }
            ++i;
        }
        return minIndex;
    }
}

