/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acmx.export.javax.swing.AWTButton;
import acmx.export.javax.swing.ButtonActionListener;
import acmx.export.javax.swing.Icon;
import acmx.export.javax.swing.JButtonModel;
import acmx.export.javax.swing.SwingInteractor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class JButton
extends SwingInteractor {
    private ArrayList<ActionListener> actionListeners;
    private JButtonModel model = new AWTButton();
    private ButtonActionListener buttonListener;

    public JButton() {
        this("");
    }

    public JButton(String name) {
        this(name, null);
    }

    public JButton(Icon icon) {
        this(null, icon);
    }

    public JButton(String name, Icon icon) {
        this.setContents((Component)((Object)this.model));
        this.setText(name);
        this.setIcon(icon);
        this.actionListeners = new ArrayList();
        this.buttonListener = new ButtonActionListener(this);
        this.model.addActionListener(this.buttonListener);
    }

    public void setText(String text) {
        this.model.setText(text);
    }

    public String getText() {
        return this.model.getText();
    }

    public void setIcon(Icon icon) {
        this.model.setButtonIcon(icon);
    }

    public Icon getIcon() {
        return this.model.getButtonIcon();
    }

    public void setActionCommand(String command) {
        this.model.setActionCommand(command);
    }

    public String getActionCommand() {
        String cmd = this.model.getActionCommand();
        if (cmd == null) {
            cmd = this.model.getText();
        }
        return cmd;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public ActionListener[] getActionListeners() {
        int nListeners = this.actionListeners.size();
        ActionListener[] array = new ActionListener[nListeners];
        int i = 0;
        while (i < nListeners) {
            array[i] = this.actionListeners.get(i);
            ++i;
        }
        return array;
    }
}

