/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GCanvas;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.program.GObjectProgram;
import acm.program.GProgramListener;
import acm.program.Program;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicsProgram
extends Program {
    private GCanvas gc;
    private GProgramListener eventListener = new GProgramListener(this);

    protected GraphicsProgram() {
        this.gc = this.createGCanvas();
        this.gc.addMouseListener(this.eventListener);
        if (this.eventListener.needsMouseMotionListeners()) {
            this.gc.addMouseMotionListener(this.eventListener);
        }
        this.add((Component)this.gc, "Center");
        this.validate();
    }

    @Override
    public void run() {
    }

    @Override
    public void init() {
    }

    public GCanvas getGCanvas() {
        return this.gc;
    }

    public void add(GObject gobj) {
        this.gc.add(gobj);
    }

    public final void add(GObject gobj, double x, double y) {
        gobj.setLocation(x, y);
        this.add(gobj);
    }

    public final void add(GObject gobj, GPoint pt) {
        this.add(gobj);
        gobj.setLocation(pt);
    }

    public void remove(GObject gobj) {
        this.gc.remove(gobj);
    }

    @Override
    public void removeAll() {
        this.gc.removeAll();
    }

    public int getElementCount() {
        return this.gc.getElementCount();
    }

    public GObject getElement(int index) {
        return this.gc.getElement(index);
    }

    public GObject getElementAt(double x, double y) {
        return this.gc.getElementAt(x, y);
    }

    public final GObject getElementAt(GPoint pt) {
        return this.getElementAt(pt.getX(), pt.getY());
    }

    public Iterator<GObject> iterator() {
        return this.gc.iterator();
    }

    public Iterator<GObject> iterator(int direction) {
        return this.gc.iterator(direction);
    }

    public void addMouseListeners() {
        this.gc.addMouseListener(this);
        this.gc.addMouseMotionListener(this);
    }

    public void addMouseListeners(EventListener listener) {
        boolean ok = false;
        if (listener instanceof MouseListener) {
            this.gc.addMouseListener((MouseListener)listener);
            ok = true;
        }
        if (listener instanceof MouseMotionListener) {
            this.gc.addMouseMotionListener((MouseMotionListener)listener);
            ok = true;
        }
        if (!ok) {
            throw new ErrorException("addMouseListeners: Illegal listener");
        }
    }

    public void addKeyListeners() {
        this.gc.addKeyListener(this);
    }

    public void addKeyListeners(KeyListener listener) {
        this.gc.addKeyListener(listener);
    }

    public void waitForClick() {
        this.eventListener.waitForClick();
    }

    @Override
    public void repaint() {
        this.gc.repaint();
        super.repaint();
    }

    public void removeAllComponents() {
        super.removeAll();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.gc != null) {
            this.gc.setBackground(bg);
        }
    }

    public static void startGraphicsProgram(GObject gobj, String[] args) {
        GObjectProgram program = new GObjectProgram();
        program.setStartupObject(gobj);
        program.start(args);
    }

    protected GCanvas createGCanvas() {
        return new GCanvas();
    }

    @Override
    protected void endHook() {
        this.gc.repaint();
    }

    @Override
    protected boolean isStarted() {
        if (this.gc == null || !super.isStarted()) {
            return false;
        }
        Dimension size = this.gc.getSize();
        return size != null && size.width != 0 && size.height != 0;
    }
}

