/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.program.Program;
import acm.util.DOSCommandLine;
import acm.util.EmptyContainer;
import acm.util.ErrorException;
import acm.util.Platform;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JTFTools {
    private static final int BUFFER_SIZE = 4096;
    private static final String[] SERIF_SUBSTITUTIONS = new String[]{"Serif", "Times", "TimesRoman", "Times-Roman"};
    private static final String[] SANSSERIF_SUBSTITUTIONS = new String[]{"SansSerif", "Helvetica", "Arial"};
    private static final String[] MONOSPACED_SUBSTITUTIONS = new String[]{"Monospaced", "Courier", "Monaco"};
    private static final String[] SKIP_JARS = new String[]{"acm.jar", "acm11.jar", "swingall.jar", "patchJTF.jar"};
    private static boolean fontFamilyTableInitialized = false;
    private static String[] fontFamilyArray = null;
    private static HashMap<String, String> fontFamilyTable = null;
    private static HashMap<Thread, Applet> appletTable = new HashMap();
    private static Applet mostRecentApplet = null;
    private static SecurityManager managerThatFails = null;
    private static String debugOptions = null;

    private JTFTools() {
    }

    public static Container createEmptyContainer() {
        return new EmptyContainer();
    }

    public static Frame getEnclosingFrame(Component comp) {
        if (comp instanceof Program) {
            comp = ((Program)comp).getContentPane();
        }
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static Font getStandardFont(Font font) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        if (font == null || fontFamilyTable == null) {
            return font;
        }
        String family = font.getFamily();
        if (fontFamilyTable.get(JTFTools.trimFamilyName(family)) != null) {
            return font;
        }
        if (family.equals("Serif") || family.equals("Times")) {
            family = JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS);
        } else if (family.equals("SansSerif")) {
            family = JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS);
        } else if (family.equals("Monospaced")) {
            family = JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS);
        } else {
            return font;
        }
        if (family == null) {
            return font;
        }
        return new Font(family, font.getStyle(), font.getSize());
    }

    public static String[] getFontList() {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        return fontFamilyArray;
    }

    public static String findFontFamily(String str) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String familyName = fontFamilyTable.get(JTFTools.trimFamilyName(tokenizer.nextToken()));
            if (familyName == null) continue;
            return familyName;
        }
        return null;
    }

    public static Font decodeFont(String str) {
        return JTFTools.decodeFont(str, null);
    }

    public static Font decodeFont(String str, Font oldFont) {
        String familyName = str;
        int fontStyle = oldFont == null ? 0 : oldFont.getStyle();
        int fontSize = oldFont == null ? 12 : oldFont.getSize();
        int hyphen = str.indexOf(45);
        if (hyphen >= 0) {
            familyName = str.substring(0, hyphen);
            String styleName = str = str.substring(hyphen + 1).toLowerCase();
            hyphen = str.indexOf(45);
            if (hyphen >= 0) {
                styleName = str.substring(0, hyphen);
                str = str.substring(hyphen + 1);
            } else {
                str = "*";
            }
            if (Character.isDigit(styleName.charAt(0))) {
                String tmp = styleName;
                styleName = str;
                str = tmp;
            }
            if (styleName.equals("plain")) {
                fontStyle = 0;
            } else if (styleName.equals("bold")) {
                fontStyle = 1;
            } else if (styleName.equals("italic")) {
                fontStyle = 2;
            } else if (styleName.equals("bolditalic")) {
                fontStyle = 3;
            } else if (!styleName.equals("*")) {
                throw new ErrorException("Illegal font style");
            }
            if (!str.equals("*")) {
                try {
                    fontSize = Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    throw new ErrorException("Illegal font size");
                }
            }
        }
        if (familyName.equals("*")) {
            familyName = oldFont == null ? "Default" : oldFont.getName();
        } else {
            if (!fontFamilyTableInitialized) {
                JTFTools.initFontFamilyTable();
            }
            if (fontFamilyTable != null && (familyName = fontFamilyTable.get(JTFTools.trimFamilyName(familyName))) == null) {
                familyName = "Default";
            }
        }
        return JTFTools.getStandardFont(new Font(familyName, fontStyle, fontSize));
    }

    public static Color decodeColor(String name) {
        if (name.equalsIgnoreCase("desktop")) {
            return SystemColor.desktop;
        }
        if (name.equalsIgnoreCase("activeCaption")) {
            return SystemColor.activeCaption;
        }
        if (name.equalsIgnoreCase("activeCaptionText")) {
            return SystemColor.activeCaptionText;
        }
        if (name.equalsIgnoreCase("activeCaptionBorder")) {
            return SystemColor.activeCaptionBorder;
        }
        if (name.equalsIgnoreCase("inactiveCaption")) {
            return SystemColor.inactiveCaption;
        }
        if (name.equalsIgnoreCase("inactiveCaptionText")) {
            return SystemColor.inactiveCaptionText;
        }
        if (name.equalsIgnoreCase("inactiveCaptionBorder")) {
            return SystemColor.inactiveCaptionBorder;
        }
        if (name.equalsIgnoreCase("window")) {
            return SystemColor.window;
        }
        if (name.equalsIgnoreCase("windowBorder")) {
            return SystemColor.windowBorder;
        }
        if (name.equalsIgnoreCase("windowText")) {
            return SystemColor.windowText;
        }
        if (name.equalsIgnoreCase("menu")) {
            return SystemColor.menu;
        }
        if (name.equalsIgnoreCase("menuText")) {
            return SystemColor.menuText;
        }
        if (name.equalsIgnoreCase("text")) {
            return SystemColor.text;
        }
        if (name.equalsIgnoreCase("textText")) {
            return SystemColor.textText;
        }
        if (name.equalsIgnoreCase("textHighlight")) {
            return SystemColor.textHighlight;
        }
        if (name.equalsIgnoreCase("textHighlightText")) {
            return SystemColor.textHighlightText;
        }
        if (name.equalsIgnoreCase("textInactiveText")) {
            return SystemColor.textInactiveText;
        }
        if (name.equalsIgnoreCase("control")) {
            return SystemColor.control;
        }
        if (name.equalsIgnoreCase("controlText")) {
            return SystemColor.controlText;
        }
        if (name.equalsIgnoreCase("controlHighlight")) {
            return SystemColor.controlHighlight;
        }
        if (name.equalsIgnoreCase("controlLtHighlight")) {
            return SystemColor.controlLtHighlight;
        }
        if (name.equalsIgnoreCase("controlShadow")) {
            return SystemColor.controlShadow;
        }
        if (name.equalsIgnoreCase("controlDkShadow")) {
            return SystemColor.controlDkShadow;
        }
        if (name.equalsIgnoreCase("scrollbar")) {
            return SystemColor.scrollbar;
        }
        if (name.equalsIgnoreCase("info")) {
            return SystemColor.info;
        }
        if (name.equalsIgnoreCase("infoText")) {
            return SystemColor.infoText;
        }
        if (name.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (name.equalsIgnoreCase("darkGray")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (name.equalsIgnoreCase("lightGray")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (name.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        try {
            return Color.decode(name);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("Illegal color value");
        }
    }

    public static void registerApplet(Applet applet) {
        JTFTools.registerApplet(applet, Thread.currentThread());
        mostRecentApplet = applet;
    }

    public static void registerApplet(Applet applet, Thread thread) {
        appletTable.put(thread, applet);
    }

    public static Applet getApplet() {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
        }
        return applet;
    }

    public static void pause(double milliseconds) {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
            appletTable.put(Thread.currentThread(), applet);
        }
        try {
            int millis = (int)milliseconds;
            int nanos = (int)Math.round((milliseconds - (double)millis) * 1000000.0);
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setDebugOptions(String options) {
        debugOptions = options == null ? null : "+" + options.toLowerCase() + "+";
    }

    public static boolean testDebugOption(String option) {
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.indexOf("+" + option.toLowerCase() + "+") >= 0;
    }

    public static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return JTFTools.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return JTFTools.getShellCommandLine();
    }

    public static String getMainClass() {
        String className = null;
        try {
            className = System.getProperty("java.main");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className == null) {
            className = JTFTools.readMainClassFromClassPath();
        }
        if (className == null) {
            String commandLine = JTFTools.getCommandLine();
            className = JTFTools.readMainClassFromCommandLine(commandLine);
        }
        return className;
    }

    public static boolean checkIfLoaded(String className) {
        boolean result;
        block14: {
            block13: {
                if (Platform.compareVersion("1.2") < 0) {
                    return false;
                }
                result = false;
                if (System.getSecurityManager() == null) break block13;
                return false;
            }
            if (managerThatFails != null) break block14;
            try {
                Class<?> managerThatFailsClass = Class.forName("acm.util.SecurityManagerThatFails");
                managerThatFails = (SecurityManager)managerThatFailsClass.newInstance();
            }
            catch (Exception ex) {
                return false;
            }
        }
        try {
            System.setSecurityManager(managerThatFails);
            try {
                try {
                    result = Class.forName(className) != null;
                }
                catch (ExceptionInInitializerError err) {
                    result = true;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
            finally {
                System.setSecurityManager(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void terminateAppletThreads(Applet applet) {
        try {
            Thread myThread = Thread.currentThread();
            Class<?> threadClass = Class.forName("java.lang.Thread");
            Method stop = threadClass.getMethod("stop", new Class[0]);
            for (Thread t : appletTable.keySet()) {
                if (t == myThread || !t.isAlive() || !JTFTools.isAnonymous(t) || applet != appletTable.get(t)) continue;
                stop.invoke((Object)t, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAnonymous(Thread t) {
        String name = t.getName();
        if (!name.startsWith("Thread-")) {
            return false;
        }
        int i = 7;
        while (i < name.length()) {
            if (!Character.isDigit(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void copyFile(File oldFile, File newFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(oldFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            JTFTools.copyBytes(in, out, oldFile.length());
            in.close();
            out.close();
            Platform.copyFileTypeAndCreator(oldFile, newFile);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, long nBytes) throws IOException {
        byte[] buffer = new byte[4096];
        while (nBytes > 0L) {
            int chunkSize = (int)Math.min(4096L, nBytes);
            if ((chunkSize = in.read(buffer, 0, chunkSize)) == -1) {
                return;
            }
            out.write(buffer, 0, chunkSize);
            nBytes -= (long)chunkSize;
        }
    }

    private static void initFontFamilyTable() {
        fontFamilyTableInitialized = true;
        int pass = 1;
        while (fontFamilyArray == null && pass <= 2) {
            try {
                if (pass == 1) {
                    Class<?> classGE = Class.forName("java.awt.GraphicsEnvironment");
                    Method getLocalGraphicsEnvironment = classGE.getMethod("getLocalGraphicsEnvironment", new Class[0]);
                    Method getAvailableFontFamilyNames = classGE.getMethod("getAvailableFontFamilyNames", new Class[0]);
                    Object ge = getLocalGraphicsEnvironment.invoke(null, new Object[0]);
                    fontFamilyArray = (String[])getAvailableFontFamilyNames.invoke(ge, new Object[0]);
                } else {
                    Class<?> classToolkit = Class.forName("java.awt.Toolkit");
                    Method getFontList = classToolkit.getMethod("getFontList", new Class[0]);
                    fontFamilyArray = (String[])getFontList.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++pass;
        }
        fontFamilyTable = new HashMap();
        int i = 0;
        while (i < fontFamilyArray.length) {
            fontFamilyTable.put(JTFTools.trimFamilyName(fontFamilyArray[i]), fontFamilyArray[i]);
            ++i;
        }
        fontFamilyTable.put("serif", JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS));
        fontFamilyTable.put("sansserif", JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS));
        fontFamilyTable.put("monospaced", JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS));
    }

    private static String getFirstAvailableFontSubstitution(String[] fontOptions) {
        int i = 0;
        while (i < fontOptions.length) {
            if (fontFamilyTable.get(JTFTools.trimFamilyName(fontOptions[i])) != null) {
                return fontOptions[i];
            }
            ++i;
        }
        return null;
    }

    private static String trimFamilyName(String family) {
        String str = "";
        int i = 0;
        while (i < family.length()) {
            char ch = family.charAt(i);
            if (ch != ' ' && ch != '-') {
                str = String.valueOf(str) + Character.toLowerCase(ch);
            }
            ++i;
        }
        return str;
    }

    private static String getShellCommandLine() {
        Process p;
        block3: {
            try {
                String option = Platform.isMac() ? "command" : "args";
                String[] argv = new String[]{"bash", "-c", "ps -p $PPID -o " + option};
                p = Runtime.getRuntime().exec(argv);
                p.waitFor();
                if (p.getErrorStream().read() == -1) break block3;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(p.getInputStream()));
        rd.readLine();
        return rd.readLine();
    }

    private static String readMainClassFromManifest(String jarName) {
        ZipFile jarFile;
        ZipEntry entry;
        block7: {
            if (JTFTools.testDebugOption("main")) {
                System.out.println("Read class from JAR manifest in " + jarName);
            }
            if ((entry = (jarFile = new ZipFile(jarName)).getEntry("META-INF/MANIFEST.MF")) != null) break block7;
            return null;
        }
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
            String line = rd.readLine();
            while (line != null) {
                if (line.startsWith("Main-Class:")) {
                    String mainClass = line.substring("Main-Class:".length()).trim();
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + mainClass);
                    }
                    return mainClass;
                }
                line = rd.readLine();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMainClassFromCommandLine(String line) {
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from command line: " + line);
        }
        if (line == null) {
            return null;
        }
        boolean jarFlag = false;
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
            tokenizer.resetSyntax();
            tokenizer.wordChars(33, 255);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            boolean cmdRead = false;
            while (true) {
                int tt = tokenizer.nextToken();
                String token = tokenizer.sval;
                switch (tt) {
                    case -1: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (cmdRead) {
                    if (token.startsWith("-")) {
                        if (token.equals("-jar")) {
                            jarFlag = true;
                            continue;
                        }
                        if (!token.equals("-cp") && !token.equals("-classpath")) continue;
                        tokenizer.nextToken();
                        continue;
                    }
                    if (jarFlag) {
                        return JTFTools.readMainClassFromManifest(token);
                    }
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + token);
                    }
                    return token;
                }
                cmdRead = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String readMainClassFromClassPath() {
        String result = null;
        String classpath = System.getProperty("java.class.path");
        if (classpath == null) {
            classpath = System.getProperty("user.dir");
        }
        if (classpath == null) {
            return null;
        }
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from class path: " + classpath);
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, ":;");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            File file = new File(token);
            String[] candidates = null;
            if (file.isDirectory()) {
                candidates = file.list();
            } else if (token.endsWith(".jar") && !JTFTools.nameAppears(token, SKIP_JARS)) {
                try {
                    ZipFile zf = new ZipFile(file);
                    ArrayList<String> list = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        list.add(entries.nextElement().getName());
                    }
                    candidates = new String[list.size()];
                    int i = 0;
                    while (i < candidates.length) {
                        candidates[i] = (String)list.get(i);
                        ++i;
                    }
                }
                catch (IOException ex) {
                    candidates = null;
                }
            }
            if (candidates == null) continue;
            int i = 0;
            while (i < candidates.length) {
                block17: {
                    String className;
                    String fileName = candidates[i];
                    if (fileName.endsWith(".class") && (className = fileName.substring(0, fileName.lastIndexOf(".class"))).indexOf("/") == -1 && JTFTools.checkIfLoaded(className)) {
                        block18: {
                            Class<?> c = Class.forName(className);
                            Class[] types = new Class[]{candidates.getClass()};
                            if (c.getMethod("main", types) == null) break block17;
                            if (JTFTools.testDebugOption("main")) {
                                System.out.println("Main class = " + className);
                            }
                            if (result == null) break block18;
                            return null;
                        }
                        try {
                            result = className;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean nameAppears(String name, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

