/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GCompound;
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRoundRect;
import acm.util.ErrorException;
import java.awt.Color;

class GDie
extends GCompound
implements YahtzeeDisplayConstants {
    private int dieValue;
    private boolean highlighted;

    public GDie() {
        this.set(0);
    }

    public void set(int n) {
        this.dieValue = n;
        this.removeAll();
        this.createOutline(this.highlighted ? YahtzeeDisplayConstants.PIP_COLOR : YahtzeeDisplayConstants.DIE_COLOR);
        if (n == 0) {
            this.createQuestionMark();
        } else {
            this.createPips(n);
        }
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
        this.set(this.dieValue);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    private void createOutline(Color color) {
        GRoundRect gRoundRect = new GRoundRect(0.0, 0.0, 44.0, 44.0, 18.0);
        gRoundRect.setColor(YahtzeeDisplayConstants.PIP_COLOR);
        gRoundRect.setFilled(true);
        gRoundRect.setFillColor(color);
        this.add((GObject)gRoundRect);
    }

    private void createQuestionMark() {
        GLabel gLabel = new GLabel("?");
        gLabel.setColor(YahtzeeDisplayConstants.PIP_COLOR);
        gLabel.setFont(YahtzeeDisplayConstants.QUESTION_MARK_FONT);
        this.add((GObject)gLabel, (44.0 - gLabel.getWidth()) / 2.0, (44.0 + gLabel.getAscent()) / 2.0 - 1.0);
    }

    private void createPips(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.createPip(2, 2);
                break;
            }
            case 2: {
                this.createPip(3, 1);
                this.createPip(1, 3);
                break;
            }
            case 3: {
                this.createPip(3, 1);
                this.createPip(2, 2);
                this.createPip(1, 3);
                break;
            }
            case 4: {
                this.createPip(1, 1);
                this.createPip(1, 3);
                this.createPip(3, 1);
                this.createPip(3, 3);
                break;
            }
            case 5: {
                this.createPip(1, 1);
                this.createPip(1, 3);
                this.createPip(2, 2);
                this.createPip(3, 1);
                this.createPip(3, 3);
                break;
            }
            case 6: {
                this.createPip(1, 1);
                this.createPip(1, 2);
                this.createPip(1, 3);
                this.createPip(3, 1);
                this.createPip(3, 2);
                this.createPip(3, 3);
                break;
            }
            default: {
                throw new ErrorException("Illegal die value = " + n);
            }
        }
    }

    private void createPip(int n, int n2) {
        double d = 22.0 + 0.27 * (double)(n - 2) * 44.0;
        double d2 = 22.0 + 0.27 * (double)(n2 - 2) * 44.0 + 1.0;
        GOval gOval = new GOval(10.0, 10.0);
        gOval.setFilled(true);
        gOval.setColor(this.highlighted ? YahtzeeDisplayConstants.DIE_COLOR : YahtzeeDisplayConstants.PIP_COLOR);
        this.add((GObject)gOval, d - 5.0, d2 - 5.0);
    }
}

