/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GCompound;
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GRect;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Font;

class GScorecardEntry
extends GCompound
implements YahtzeeDisplayConstants {
    private GRect box;
    private GLabel label;
    private int myCategory;
    private int alignment;
    private boolean highlighted;
    private Color highlightColor;
    private Color textColor;
    private Color backgroundColor;

    public GScorecardEntry(double d, double d2, int n) {
        this.myCategory = n;
        this.box = new GRect(d, d2);
        this.box.setFilled(true);
        this.label = new GLabel("");
        this.highlighted = false;
        this.add((GObject)this.box);
        this.add((GObject)this.label);
        this.setHighlightColor(YahtzeeDisplayConstants.STANDARD_HIGHLIGHT);
        this.setTextColor(Color.black);
        this.setBackgroundColor(Color.white);
        this.setHighlighted(false);
        this.setAlignment(2);
    }

    public void setLabel(String string) {
        this.label.setLabel(string);
        double d = this.getXCoordinate();
        double d2 = (this.box.getHeight() + this.label.getAscent()) / 2.0 - 1.0;
        this.label.setLocation(d, d2);
        this.setHighlighted(this.highlighted);
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
        if (this.highlighted) {
            this.label.setColor(this.highlightColor == YahtzeeDisplayConstants.STANDARD_HIGHLIGHT ? Color.black : Color.white);
            this.box.setFillColor(this.highlightColor);
        } else {
            this.label.setColor(this.textColor);
            this.box.setFillColor(this.backgroundColor);
        }
    }

    public int getCategory() {
        return this.myCategory;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setFont(Font font) {
        this.label.setFont(font);
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    private double getXCoordinate() {
        switch (this.alignment) {
            case 0: {
                return 4.0;
            }
            case 1: {
                return 18.0;
            }
            case 2: {
                return (this.box.getWidth() - this.label.getWidth()) / 2.0;
            }
            case 3: {
                return 0.65 * this.box.getWidth() - this.label.getWidth();
            }
        }
        throw new ErrorException("Illegal alignment");
    }
}

