/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GCanvas;
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class YahtzeeDisplay
implements YahtzeeDisplayConstants,
ActionListener,
MouseListener {
    private static final int WAIT_FOR_ROLL = 1;
    private static final int WAIT_FOR_REROLL = 2;
    private static final int WAIT_FOR_CATEGORY = 3;
    private GDie[] diceArray;
    private GScorecardEntry[][] scorecard;
    private GCanvas canvas;
    private GButton rollButton;
    private GLabel messageArea;
    private int mode;
    private int selectedCategory;
    private boolean mouseDown;

    public YahtzeeDisplay(GCanvas gCanvas, String[] stringArray) {
        this.canvas = gCanvas;
        this.canvas.setBackground(BACKGROUND_COLOR);
        if (stringArray.length > 4) {
            throw new ErrorException("Too many players");
        }
        this.createButton();
        this.createDice();
        this.createScorecard(stringArray);
        this.createMessageArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPlayerToClickRoll(int n) {
        if (n < 1 || n >= this.scorecard.length) {
            throw new ErrorException("waitForPlayerToClickRoll: Illegal player number " + n);
        }
        this.mode = 1;
        this.rollButton.setLabel("Roll Dice");
        this.rollButton.setEnabled(true);
        this.scorecard[n][0].setHighlighted(true);
        for (int i = 0; i < 5; ++i) {
            this.diceArray[i].set(0);
        }
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
    }

    public void displayDice(int[] nArray) {
        this.messageArea.setLabel("");
        if (nArray.length != 5) {
            throw new ErrorException("Dice array has incorrect length");
        }
        for (int i = 0; i < 5; ++i) {
            this.diceArray[i].set(nArray[i]);
            this.diceArray[i].setHighlighted(false);
            JTFTools.pause((double)100.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPlayerToSelectDice() {
        this.mode = 2;
        this.rollButton.setLabel("Roll again");
        this.rollButton.setEnabled(true);
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
    }

    public boolean isDieSelected(int n) {
        if (n < 0 || n >= 5) {
            throw new ErrorException("isDieSelected: Index is out of range");
        }
        return this.diceArray[n].isHighlighted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForPlayerToSelectCategory() {
        this.mode = 3;
        this.rollButton.setLabel("Roll Dice");
        this.rollButton.setEnabled(false);
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
        return this.selectedCategory;
    }

    public void updateScorecard(int n, int n2, int n3) {
        this.messageArea.setLabel("");
        if (n < 1 || n > 17) {
            throw new ErrorException("updateScorecard: Illegal category");
        }
        if (n2 < 1 || n2 >= this.scorecard.length) {
            throw new ErrorException("updateScorecard: Illegal player number " + n2);
        }
        this.scorecard[n2][0].setHighlighted(false);
        this.scorecard[n2][n].setLabel("" + n3);
    }

    public void printMessage(String string) {
        this.messageArea.setLabel(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mode == 1 || this.mode == 2) {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mode == 2 && mouseEvent.getSource() instanceof GDie) {
            GDie gDie;
            gDie.setHighlighted(!(gDie = (GDie)mouseEvent.getSource()).isHighlighted());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mode != 3 || !(mouseEvent.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry gScorecardEntry = (GScorecardEntry)mouseEvent.getSource();
        int n = gScorecardEntry.getCategory();
        if (!this.isSelectableCategory(n)) {
            return;
        }
        for (int i = 0; i < this.scorecard.length; ++i) {
            this.scorecard[i][n].setHighlighted(true);
        }
        this.mouseDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        if (this.mode != 3 || !(mouseEvent.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry gScorecardEntry = (GScorecardEntry)mouseEvent.getSource();
        if (!gScorecardEntry.isHighlighted()) {
            return;
        }
        int n = gScorecardEntry.getCategory();
        for (int i = 0; i < this.scorecard.length; ++i) {
            this.scorecard[i][n].setHighlighted(false);
        }
        this.selectedCategory = n;
        YahtzeeDisplay yahtzeeDisplay = this;
        synchronized (yahtzeeDisplay) {
            this.notifyAll();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        if (this.mode != 3 || !(mouseEvent.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry gScorecardEntry = (GScorecardEntry)mouseEvent.getSource();
        int n = gScorecardEntry.getCategory();
        if (!this.isSelectableCategory(n)) {
            return;
        }
        for (int i = 0; i < this.scorecard.length; ++i) {
            this.scorecard[i][n].setHighlighted(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        if (this.mode != 3 || !(mouseEvent.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry gScorecardEntry = (GScorecardEntry)mouseEvent.getSource();
        int n = gScorecardEntry.getCategory();
        if (!this.isSelectableCategory(n)) {
            return;
        }
        for (int i = 0; i < this.scorecard.length; ++i) {
            this.scorecard[i][n].setHighlighted(false);
        }
    }

    private void createButton() {
        this.rollButton = new GButton("Roll Dice");
        this.rollButton.addActionListener(this);
        this.canvas.add((GObject)this.rollButton, 12.0, 10.0);
    }

    private void createDice() {
        this.diceArray = new GDie[5];
        for (int i = 0; i < 5; ++i) {
            this.diceArray[i] = new GDie();
            this.diceArray[i].addMouseListener(this);
            this.canvas.add((GObject)this.diceArray[i], 33.0, (double)(40 + i * 50));
        }
    }

    private void createScorecard(String[] stringArray) {
        int n;
        this.scorecard = new GScorecardEntry[stringArray.length + 1][18];
        double d = 110.0;
        double d2 = 10.0;
        GScorecardEntry gScorecardEntry = new GScorecardEntry(140.0, 20.0, 0);
        gScorecardEntry.setLabel("Category");
        this.canvas.add((GObject)gScorecardEntry, d, d2);
        d2 += 20.0;
        for (n = 1; n <= 17; ++n) {
            gScorecardEntry = new GScorecardEntry(140.0, 15.0, n);
            if (this.isSelectableCategory(n)) {
                gScorecardEntry.setAlignment(1);
                gScorecardEntry.setTextColor(CATEGORY_TEXT);
                gScorecardEntry.addMouseListener(this);
            } else {
                gScorecardEntry.setAlignment(0);
                gScorecardEntry.setTextColor(FIXED_CATEGORY_TEXT);
            }
            gScorecardEntry.setFont(CATEGORY_FONT);
            gScorecardEntry.setHighlightColor(CATEGORY_TEXT);
            gScorecardEntry.setBackgroundColor(CATEGORY_BACKGROUND);
            gScorecardEntry.setLabel(this.categoryName(n));
            this.scorecard[0][n] = gScorecardEntry;
            this.canvas.add((GObject)gScorecardEntry, d, d2);
            d2 += 15.0;
        }
        d = 251.0;
        for (n = 1; n <= stringArray.length; ++n) {
            d2 = 10.0;
            gScorecardEntry = new GScorecardEntry(65.0, 20.0, 0);
            gScorecardEntry.setLabel(stringArray[n - 1]);
            this.scorecard[n][0] = gScorecardEntry;
            this.canvas.add((GObject)gScorecardEntry, d, d2);
            d2 += 20.0;
            for (int i = 1; i <= 17; ++i) {
                gScorecardEntry = new GScorecardEntry(65.0, 15.0, i);
                gScorecardEntry.setAlignment(3);
                if (this.isSelectableCategory(i)) {
                    gScorecardEntry.setHighlightColor(CATEGORY_TEXT);
                    gScorecardEntry.setFont(SCORE_FONT);
                    gScorecardEntry.addMouseListener(this);
                } else {
                    gScorecardEntry.setFont(FIXED_SCORE_FONT);
                }
                this.scorecard[n][i] = gScorecardEntry;
                this.canvas.add((GObject)gScorecardEntry, d, d2);
                d2 += 15.0;
            }
            d += 65.0;
        }
    }

    private void createMessageArea() {
        this.messageArea = new GLabel("");
        this.messageArea.setColor(Color.white);
        this.messageArea.setFont(MESSAGE_FONT);
        this.canvas.add((GObject)this.messageArea, 33.0, 315.0);
    }

    private String categoryName(int n) {
        switch (n) {
            case 1: {
                return "Ones";
            }
            case 2: {
                return "Twos";
            }
            case 3: {
                return "Threes";
            }
            case 4: {
                return "Fours";
            }
            case 5: {
                return "Fives";
            }
            case 6: {
                return "Sixes";
            }
            case 7: {
                return "Upper Score";
            }
            case 8: {
                return "Upper Bonus (35)";
            }
            case 9: {
                return "Three of a Kind";
            }
            case 10: {
                return "Four of a Kind";
            }
            case 11: {
                return "Full House (25)";
            }
            case 12: {
                return "Small Straight (30)";
            }
            case 13: {
                return "Large Straight (40)";
            }
            case 14: {
                return "Yahtzee! (50)";
            }
            case 15: {
                return "Chance";
            }
            case 16: {
                return "Lower Score";
            }
            case 17: {
                return "TOTAL";
            }
        }
        throw new ErrorException("Illegal category");
    }

    private boolean isSelectableCategory(int n) {
        return n >= 1 && n <= 6 || n >= 9 && n <= 15;
    }
}

