/*
 * Decompiled with CFR 0.152.
 */
import acm.io.IODialog;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;

public class Yahtzee
extends GraphicsProgram
implements YahtzeeConstants {
    private int nPlayers;
    private String[] playerNames;
    private YahtzeeDisplay display;
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public static void main(String[] args) {
        Yahtzee z = new Yahtzee();
        z.start();
    }

    @Override
    public void run() {
        IODialog dialog = this.getDialog();
        this.nPlayers = dialog.readInt("Enter number of players");
        this.playerNames = new String[this.nPlayers];
        int i = 1;
        while (i <= this.nPlayers) {
            this.playerNames[i - 1] = dialog.readLine("Enter name for player " + i);
            ++i;
        }
        this.display = new YahtzeeDisplay(this.getGCanvas(), this.playerNames);
        this.playGame();
    }

    private void playGame() {
        int player;
        int[] dice = new int[5];
        int[][] scorecard = new int[this.nPlayers + 1][18];
        int turn = 0;
        while (turn < 17) {
            player = 1;
            while (player <= this.nPlayers) {
                scorecard[player][turn] = -1;
                ++player;
            }
            ++turn;
        }
        turn = 0;
        while (turn < 13) {
            player = 1;
            while (player <= this.nPlayers) {
                int category;
                this.display.printMessage(String.valueOf(this.playerNames[player - 1]) + "'s turn!, Click the \"Roll Dice\" button  to roll the dice.");
                this.display.waitForPlayerToClickRoll(player);
                this.rollDice(dice, true);
                this.display.displayDice(dice);
                this.display.printMessage("Select the dice you wish to re-roll and click \"Roll Again\"");
                this.display.waitForPlayerToSelectDice();
                this.rollDice(dice, false);
                this.display.displayDice(dice);
                this.display.printMessage("Select the dice you wish to re-roll and click \"Roll Again\"");
                this.display.waitForPlayerToSelectDice();
                this.rollDice(dice, false);
                this.display.displayDice(dice);
                this.display.printMessage("Select a category for this roll");
                while (scorecard[player][category = this.display.waitForPlayerToSelectCategory()] != -1) {
                    this.display.printMessage("You already picked that category. Please choose another category");
                }
                int score = 0;
                if (YahtzeeMagicStub.checkCategory(dice, category)) {
                    score = this.score(dice, category);
                }
                this.display.updateScorecard(category, player, score);
                scorecard[player][category] = score;
                this.updateTotal(player, scorecard);
                ++player;
            }
            ++turn;
        }
        int maxPlayer = 1;
        int maxScore = 0;
        int player2 = 1;
        while (player2 <= this.nPlayers) {
            this.updateFinalTotals(player2, scorecard);
            if (scorecard[player2][17] > maxScore) {
                maxPlayer = player2;
                maxScore = scorecard[player2][17];
            }
            ++player2;
        }
        this.display.printMessage("Congratulations, " + this.playerNames[maxPlayer - 1] + ", you're the winner with at total score of " + maxScore + "!");
    }

    private void updateTotal(int player, int[][] scorecard) {
        int total = 0;
        int i = 1;
        while (i < 16) {
            if (scorecard[player][i] != -1) {
                total += scorecard[player][i];
            }
            ++i;
        }
        this.display.updateScorecard(17, player, total);
        scorecard[player][17] = total;
    }

    private void updateFinalTotals(int player, int[][] scorecard) {
        int upper = 0;
        int i = 1;
        while (i <= 6) {
            if (scorecard[player][i] != -1) {
                upper += scorecard[player][i];
            }
            ++i;
        }
        int bonus = 0;
        if (upper >= 63) {
            bonus = 35;
        }
        this.display.updateScorecard(8, player, bonus);
        scorecard[player][8] = bonus;
        this.display.updateScorecard(7, player, upper);
        scorecard[player][7] = upper;
        int lower = 0;
        int i2 = 9;
        while (i2 <= 15) {
            if (scorecard[player][i2] != -1) {
                lower += scorecard[player][i2];
            }
            ++i2;
        }
        this.display.updateScorecard(16, player, lower);
        scorecard[player][16] = lower;
        this.display.updateScorecard(17, player, upper + lower + bonus);
        scorecard[player][17] = upper + lower + bonus;
    }

    private int score(int[] dice, int category) {
        int[] hist = new int[7];
        int i = 0;
        while (i < dice.length) {
            int n = dice[i];
            hist[n] = hist[n] + 1;
            ++i;
        }
        switch (category) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return category * hist[category];
            }
            case 9: 
            case 10: {
                return this.sumDice(dice);
            }
            case 12: {
                return 30;
            }
            case 13: {
                return 40;
            }
            case 14: {
                return 50;
            }
            case 11: {
                return 25;
            }
            case 15: {
                return this.sumDice(dice);
            }
        }
        return 0;
    }

    private int sumDice(int[] dice) {
        int sum = 0;
        int i = 0;
        while (i < dice.length) {
            sum += dice[i];
            ++i;
        }
        return sum;
    }

    private void rollDice(int[] dice, boolean all) {
        int i = 0;
        while (i < dice.length) {
            if (this.display.isDieSelected(i) || all) {
                dice[i] = this.rgen.nextInt(1, 6);
            }
            ++i;
        }
    }
}

