/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GCanvas;
import acm.graphics.GLabel;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class YahtzeeDisplay
implements YahtzeeDisplayConstants,
ActionListener,
MouseListener {
    private static final int WAIT_FOR_ROLL = 1;
    private static final int WAIT_FOR_REROLL = 2;
    private static final int WAIT_FOR_CATEGORY = 3;
    private GDie[] diceArray;
    private GScorecardEntry[][] scorecard;
    private GCanvas canvas;
    private GButton rollButton;
    private GLabel messageArea;
    private int mode;
    private int selectedCategory;
    private boolean mouseDown;

    public YahtzeeDisplay(GCanvas gc, String[] playerNames) {
        this.canvas = gc;
        this.canvas.setBackground(YahtzeeDisplayConstants.BACKGROUND_COLOR);
        if (playerNames.length > 4) {
            throw new ErrorException("Too many players");
        }
        this.createButton();
        this.createDice();
        this.createScorecard(playerNames);
        this.createMessageArea();
    }

    public void waitForPlayerToClickRoll(int player) {
        if (player < 1 || player >= this.scorecard.length) {
            throw new ErrorException("waitForPlayerToClickRoll: Illegal player number " + player);
        }
        this.mode = 1;
        this.rollButton.setLabel("Roll Dice");
        this.rollButton.setEnabled(true);
        this.scorecard[player][0].setHighlighted(true);
        int i = 0;
        while (i < 5) {
            this.diceArray[i].set(0);
            ++i;
        }
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
    }

    public void displayDice(int[] dice) {
        this.messageArea.setLabel("");
        if (dice.length != 5) {
            throw new ErrorException("Dice array has incorrect length");
        }
        int i = 0;
        while (i < 5) {
            this.diceArray[i].set(dice[i]);
            this.diceArray[i].setHighlighted(false);
            JTFTools.pause(100.0);
            ++i;
        }
    }

    public void waitForPlayerToSelectDice() {
        this.mode = 2;
        this.rollButton.setLabel("Roll again");
        this.rollButton.setEnabled(true);
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
    }

    public boolean isDieSelected(int index) {
        if (index < 0 || index >= 5) {
            throw new ErrorException("isDieSelected: Index is out of range");
        }
        return this.diceArray[index].isHighlighted();
    }

    public int waitForPlayerToSelectCategory() {
        this.mode = 3;
        this.rollButton.setLabel("Roll Dice");
        this.rollButton.setEnabled(false);
        try {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.messageArea.setLabel("");
        return this.selectedCategory;
    }

    public void updateScorecard(int category, int player, int score) {
        this.messageArea.setLabel("");
        if (category < 1 || category > 17) {
            throw new ErrorException("updateScorecard: Illegal category");
        }
        if (player < 1 || player >= this.scorecard.length) {
            throw new ErrorException("updateScorecard: Illegal player number " + player);
        }
        this.scorecard[player][0].setHighlighted(false);
        this.scorecard[player][category].setLabel("" + score);
    }

    public void printMessage(String message) {
        this.messageArea.setLabel(message);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mode == 1 || this.mode == 2) {
            YahtzeeDisplay yahtzeeDisplay = this;
            synchronized (yahtzeeDisplay) {
                this.notifyAll();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.mode == 2 && e.getSource() instanceof GDie) {
            GDie die;
            die.setHighlighted(!(die = (GDie)e.getSource()).isHighlighted());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.mode != 3 || !(e.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry entry = (GScorecardEntry)e.getSource();
        int category = entry.getCategory();
        if (!this.isSelectableCategory(category)) {
            return;
        }
        int i = 0;
        while (i < this.scorecard.length) {
            this.scorecard[i][category].setHighlighted(true);
            ++i;
        }
        this.mouseDown = true;
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        if (this.mode != 3 || !(e.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry entry = (GScorecardEntry)e.getSource();
        if (!entry.isHighlighted()) {
            return;
        }
        int category = entry.getCategory();
        int i = 0;
        while (i < this.scorecard.length) {
            this.scorecard[i][category].setHighlighted(false);
            ++i;
        }
        this.selectedCategory = category;
        YahtzeeDisplay yahtzeeDisplay = this;
        synchronized (yahtzeeDisplay) {
            this.notifyAll();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.mouseDown) {
            return;
        }
        if (this.mode != 3 || !(e.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry entry = (GScorecardEntry)e.getSource();
        int category = entry.getCategory();
        if (!this.isSelectableCategory(category)) {
            return;
        }
        int i = 0;
        while (i < this.scorecard.length) {
            this.scorecard[i][category].setHighlighted(true);
            ++i;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.mouseDown) {
            return;
        }
        if (this.mode != 3 || !(e.getSource() instanceof GScorecardEntry)) {
            return;
        }
        GScorecardEntry entry = (GScorecardEntry)e.getSource();
        int category = entry.getCategory();
        if (!this.isSelectableCategory(category)) {
            return;
        }
        int i = 0;
        while (i < this.scorecard.length) {
            this.scorecard[i][category].setHighlighted(false);
            ++i;
        }
    }

    private void createButton() {
        this.rollButton = new GButton("Roll Dice");
        this.rollButton.addActionListener(this);
        this.canvas.add(this.rollButton, 12.0, 10.0);
    }

    private void createDice() {
        this.diceArray = new GDie[5];
        int i = 0;
        while (i < 5) {
            this.diceArray[i] = new GDie();
            this.diceArray[i].addMouseListener(this);
            this.canvas.add(this.diceArray[i], 33.0, (double)(40 + i * 50));
            ++i;
        }
    }

    private void createScorecard(String[] playerNames) {
        this.scorecard = new GScorecardEntry[playerNames.length + 1][18];
        double x = 110.0;
        double y = 10.0;
        GScorecardEntry entry = new GScorecardEntry(140.0, 20.0, 0);
        entry.setLabel("Category");
        this.canvas.add(entry, x, y);
        y += 20.0;
        int c = 1;
        while (c <= 17) {
            entry = new GScorecardEntry(140.0, 15.0, c);
            if (this.isSelectableCategory(c)) {
                entry.setAlignment(1);
                entry.setTextColor(YahtzeeDisplayConstants.CATEGORY_TEXT);
                entry.addMouseListener(this);
            } else {
                entry.setAlignment(0);
                entry.setTextColor(YahtzeeDisplayConstants.FIXED_CATEGORY_TEXT);
            }
            entry.setFont(YahtzeeDisplayConstants.CATEGORY_FONT);
            entry.setHighlightColor(YahtzeeDisplayConstants.CATEGORY_TEXT);
            entry.setBackgroundColor(YahtzeeDisplayConstants.CATEGORY_BACKGROUND);
            entry.setLabel(this.categoryName(c));
            this.scorecard[0][c] = entry;
            this.canvas.add(entry, x, y);
            y += 15.0;
            ++c;
        }
        x = 251.0;
        int i = 1;
        while (i <= playerNames.length) {
            y = 10.0;
            entry = new GScorecardEntry(65.0, 20.0, 0);
            entry.setLabel(playerNames[i - 1]);
            this.scorecard[i][0] = entry;
            this.canvas.add(entry, x, y);
            y += 20.0;
            int c2 = 1;
            while (c2 <= 17) {
                entry = new GScorecardEntry(65.0, 15.0, c2);
                entry.setAlignment(3);
                if (this.isSelectableCategory(c2)) {
                    entry.setHighlightColor(YahtzeeDisplayConstants.CATEGORY_TEXT);
                    entry.setFont(YahtzeeDisplayConstants.SCORE_FONT);
                    entry.addMouseListener(this);
                } else {
                    entry.setFont(YahtzeeDisplayConstants.FIXED_SCORE_FONT);
                }
                this.scorecard[i][c2] = entry;
                this.canvas.add(entry, x, y);
                y += 15.0;
                ++c2;
            }
            x += 65.0;
            ++i;
        }
    }

    private void createMessageArea() {
        this.messageArea = new GLabel("");
        this.messageArea.setColor(Color.white);
        this.messageArea.setFont(YahtzeeDisplayConstants.MESSAGE_FONT);
        this.canvas.add(this.messageArea, 33.0, 315.0);
    }

    private String categoryName(int category) {
        switch (category) {
            case 1: {
                return "Ones";
            }
            case 2: {
                return "Twos";
            }
            case 3: {
                return "Threes";
            }
            case 4: {
                return "Fours";
            }
            case 5: {
                return "Fives";
            }
            case 6: {
                return "Sixes";
            }
            case 7: {
                return "Upper Score";
            }
            case 8: {
                return "Upper Bonus (35)";
            }
            case 9: {
                return "Three of a Kind";
            }
            case 10: {
                return "Four of a Kind";
            }
            case 11: {
                return "Full House (25)";
            }
            case 12: {
                return "Small Straight (30)";
            }
            case 13: {
                return "Large Straight (40)";
            }
            case 14: {
                return "Yahtzee! (50)";
            }
            case 15: {
                return "Chance";
            }
            case 16: {
                return "Lower Score";
            }
            case 17: {
                return "TOTAL";
            }
        }
        throw new ErrorException("Illegal category");
    }

    private boolean isSelectableCategory(int category) {
        return category >= 1 && category <= 6 || category >= 9 && category <= 15;
    }
}

