/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRectangle;
import acm.graphics.GRoundRect;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;

class ArcRenderer
implements Serializable {
    private static final double EPSILON = 1.0E-5;
    private GObject target;
    private Polygon poly;
    private int x0;
    private int y0;
    private GRectangle oldBounds;
    private double oldStart;
    private double oldSweep;
    private boolean cacheValid;

    public ArcRenderer(GObject gobj) {
        this.target = gobj;
        this.poly = new Polygon();
        this.cacheValid = false;
    }

    public synchronized void draw(Graphics g) {
        this.validateCache();
        if (((GFillable)((Object)this.target)).isFilled()) {
            g.setColor(((GFillable)((Object)this.target)).getFillColor());
            g.fillPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
            g.setColor(this.target.getColor());
            g.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        } else if (this.target instanceof GArc) {
            g.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints - 1);
        } else {
            g.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        }
    }

    private void validateCache() {
        GRectangle bounds = null;
        double start = 0.0;
        double sweep = 360.0;
        if (this.target instanceof GOval || this.target instanceof GRoundRect) {
            bounds = this.target.getBounds();
        } else {
            GArc arc = (GArc)this.target;
            bounds = arc.getFrameRectangle();
            start = arc.getStartAngle();
            sweep = arc.getSweepAngle();
            if (start != this.oldStart || sweep != this.oldSweep) {
                this.cacheValid = false;
            }
        }
        if (bounds == null) {
            return;
        }
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        if (!this.cacheValid || width != this.oldBounds.getWidth() || height != this.oldBounds.getHeight()) {
            this.poly.npoints = 0;
            if (this.target instanceof GRoundRect) {
                GRoundRect rr = (GRoundRect)this.target;
                double arcWidth = GMath.round(rr.getArcWidth());
                double arcHeight = GMath.round(rr.getArcHeight());
                this.poly.addPoint(GMath.round(x + arcWidth / 2.0 + 1.0E-5), GMath.round(y + 1.0E-5));
                this.addArc(x, y, arcWidth, arcHeight, 90.0, 90.0);
                this.addArc(x, y + height - arcHeight, arcWidth, arcHeight, 180.0, 90.0);
                this.addArc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 270.0, 90.0);
                this.addArc(x + width - arcWidth, y, arcWidth, arcHeight, 0.0, 90.0);
            } else {
                this.addArc(x, y, width, height, start, sweep);
                if (this.target instanceof GArc) {
                    this.poly.addPoint(GMath.round(x + width / 2.0 + 1.0E-5), GMath.round(y + height / 2.0 + 1.0E-5));
                    this.oldStart = start;
                    this.oldSweep = sweep;
                }
            }
            this.x0 = GMath.round((double)this.poly.xpoints[0] - x);
            this.y0 = GMath.round((double)this.poly.ypoints[0] - y);
            this.oldBounds = bounds;
        }
        if (x != this.oldBounds.getX() || y != this.oldBounds.getY()) {
            this.movePoly(GMath.round(x + 1.0E-5), GMath.round(y + 1.0E-5));
            this.oldBounds = bounds;
        }
        this.cacheValid = true;
    }

    private synchronized void addArc(double x, double y, double width, double height, double start, double sweep) {
        double aspectRatio = height / width;
        double rx = width / 2.0;
        double ry = height / 2.0;
        double xc = x + rx;
        double yc = y + ry;
        if (sweep < 0.0) {
            start += sweep;
            sweep = -sweep;
        }
        if (sweep > 359.99) {
            sweep = 360.0;
        }
        double dt = Math.atan2(1.0, Math.max(width, height));
        int nSteps = (int)(GMath.toRadians(sweep) / dt);
        dt = GMath.toRadians(sweep) / (double)nSteps;
        double theta = GMath.toRadians(start);
        int i = 0;
        while (i <= nSteps) {
            double px = xc + rx * Math.cos(theta);
            double py = yc - rx * Math.sin(theta) * aspectRatio;
            this.poly.addPoint(GMath.round(px + 1.0E-5), GMath.round(py + 1.0E-5));
            theta += dt;
            ++i;
        }
    }

    private synchronized void movePoly(int x, int y) {
        int dx = x - (this.poly.xpoints[0] - this.x0);
        int dy = y - (this.poly.ypoints[0] - this.y0);
        int i = 0;
        while (i < this.poly.npoints) {
            int n = i;
            this.poly.xpoints[n] = this.poly.xpoints[n] + dx;
            int n2 = i++;
            this.poly.ypoints[n2] = this.poly.ypoints[n2] + dy;
        }
    }
}

