/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.graphics.VertexList;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class GPolygon
extends GObject
implements GFillable,
GScalable {
    private double xScale;
    private double yScale;
    private double rotation;
    private VertexList vertices = new VertexList();
    private boolean cacheValid;
    private boolean complete;
    private Polygon poly;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 1L;

    public GPolygon() {
        this.clear();
    }

    public GPolygon(double x, double y) {
        this();
        this.setLocation(x, y);
    }

    public GPolygon(GPoint[] points) {
        this();
        this.vertices.add(points);
        this.markAsComplete();
    }

    public void addVertex(double x, double y) {
        if (this.complete) {
            throw new ErrorException("You can't add vertices to a GPolygon that has been marked as complete.");
        }
        this.vertices.addVertex(x, y);
    }

    public void addEdge(double dx, double dy) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(dx, dy);
    }

    public final void addPolarEdge(double r, double theta) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(r * GMath.cosDegrees(theta), -r * GMath.sinDegrees(theta));
    }

    public void addArc(double arcWidth, double arcHeight, double start, double sweep) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addArc(arcWidth, arcHeight, start, sweep);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.getCurrentPoint();
    }

    public void scale(double sx, double sy) {
        this.xScale *= sx;
        this.yScale *= sy;
        this.repaint();
    }

    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    public void rotate(double theta) {
        this.rotation += theta;
        this.repaint();
    }

    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public GRectangle getBounds() {
        return this.vertices.getBounds(this.getX(), this.getY(), this.xScale, this.yScale, this.rotation);
    }

    public boolean contains(double x, double y) {
        return this.vertices.contains((x - this.getX()) / this.xScale, (y - this.getY()) / this.yScale);
    }

    public void paint(Graphics g) {
        if (this.vertices.size() == 0) {
            return;
        }
        Polygon p = this.getPolygon();
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(this.getColor());
        }
        g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void recenter() {
        this.vertices.recenter();
        this.cacheValid = false;
    }

    public Object clone() {
        try {
            GPolygon clone = (GPolygon)super.clone();
            clone.vertices = new VertexList(clone.vertices);
            return clone;
        }
        catch (Exception CloneNotSupportedException) {
            throw new ErrorException("Impossible exception");
        }
    }

    protected void repaint() {
        this.cacheValid = false;
        super.repaint();
    }

    protected Polygon getPolygon() {
        if (this.cacheValid) {
            return this.poly;
        }
        this.poly = this.vertices.createPolygon(this.getX(), this.getY(), this.xScale, this.yScale, this.rotation);
        this.cacheValid = true;
        return this.poly;
    }

    protected void markAsComplete() {
        this.complete = true;
    }

    protected void clear() {
        if (this.complete) {
            throw new ErrorException("You can't clear a GPolygon that has been marked as complete.");
        }
        this.vertices.clear();
        this.rotation = 0.0;
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.cacheValid = false;
    }
}

