/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.FinalPathElement;
import acm.graphics.GRectangle;
import acm.graphics.PathElement;
import acm.graphics.PathState;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;

class PathList
implements Serializable {
    private static final PathElement FINAL_PATH_ELEMENT = new FinalPathElement();
    private ArrayList<PathElement> path = new ArrayList();

    public synchronized void add(PathElement element) {
        this.path.add(element);
    }

    public synchronized void add(PathElement e1, PathElement e2) {
        this.path.add(e1);
        this.path.add(e2);
    }

    public synchronized void remove(PathElement element) {
        this.path.remove(element);
    }

    public synchronized void clear() {
        this.path.clear();
    }

    public int getElementCount() {
        return this.path.size();
    }

    public PathElement getElement(int index) {
        return this.path.get(index);
    }

    public synchronized GRectangle getBounds(PathState state) {
        GRectangle bounds = new GRectangle(-1.0, -1.0, -1.0, -1.0);
        int nElements = this.path.size();
        int i = 0;
        while (i < nElements) {
            PathElement element = this.path.get(i);
            element.updateBounds(bounds, state);
            ++i;
        }
        return bounds;
    }

    public synchronized void mapPaint(Graphics g, PathState state) {
        int nElements = this.path.size();
        int i = 0;
        while (i < nElements) {
            PathElement element = this.path.get(i);
            element.paint(g, state);
            ++i;
        }
        FINAL_PATH_ELEMENT.paint(g, state);
    }
}

