/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

public class IntField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private static final int PIXEL_MARGIN = 2;
    private boolean exceptionOnError;
    private int minValue;
    private int maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private NumberFormat parser = NumberFormat.getNumberInstance(Locale.US);
    private IODialog dialog;
    static final long serialVersionUID = 1L;

    public IntField() {
        this("", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int value) {
        this("" + value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int low, int high) {
        this("", low, high);
    }

    public IntField(int value, int low, int high) {
        this("" + value, low, high);
    }

    private IntField(String str, int low, int high) {
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(4);
        this.minValue = low;
        this.maxValue = high;
        this.setText(str);
        this.exceptionOnError = false;
    }

    public int getValue() {
        int value;
        block9: {
            String text = this.getText().trim();
            if (text.length() == 0) {
                if (this.minValue <= 0 && this.maxValue >= 0) {
                    return 0;
                }
                return this.minValue;
            }
            String msg = null;
            value = 0;
            try {
                value = this.parser.parse(text).intValue();
                if (value >= this.minValue && value <= this.maxValue) break block9;
                msg = "Value is outside the specified range";
            }
            catch (ParseException ex) {
                msg = "Illegal integer format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(msg);
            }
            String prompt = "Enter an integer";
            if (this.minValue != Integer.MIN_VALUE) {
                prompt = this.maxValue != Integer.MAX_VALUE ? String.valueOf(prompt) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(prompt) + " greater than " + this.minValue;
            } else if (this.maxValue != Integer.MAX_VALUE) {
                prompt = String.valueOf(prompt) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            value = this.dialog.readInt(prompt, this.minValue, this.maxValue);
        }
        this.setValue(value);
        return value;
    }

    public void setValue(int n) {
        this.setText(this.formatter == null ? this.defaultFormat(n) : this.formatter.format(n));
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String format) {
        String contents = this.getText().trim();
        int value = 0;
        if (contents.length() != 0) {
            try {
                value = this.parser.parse(contents).intValue();
            }
            catch (ParseException ex) {
                throw new ErrorException(ex);
            }
        }
        this.formatString = format;
        if (format == null) {
            this.formatter = null;
            this.parser = NumberFormat.getNumberInstance(Locale.US);
        } else {
            this.formatter = format.length() == 0 ? new DecimalFormat() : new DecimalFormat(format);
            this.parser = this.formatter;
        }
        if (contents.length() != 0) {
            this.setValue(value);
        }
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(60, size.width), Math.max(22, size.height));
    }

    private String defaultFormat(int n) {
        String str = "" + n;
        int availableSpace = this.getSize().width - 4;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(str) > availableSpace) {
            str = "";
            while (fm.stringWidth(String.valueOf(str) + "#") <= availableSpace) {
                str = String.valueOf(str) + "#";
            }
        }
        return str;
    }
}

