/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.ConsoleModel;
import acm.io.IOConsole;
import acm.program.ProgramMenuBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.PrintJob;
import java.io.BufferedReader;
import java.io.IOException;

class SystemConsoleModel
implements ConsoleModel {
    private IOConsole console;
    private BufferedReader inputScript;
    private String text = "";

    public void setConsole(IOConsole owner) {
        this.console = owner;
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public void clear() {
    }

    public void print(String str, int style) {
        System.out.print(str);
        this.text = String.valueOf(this.text) + str;
    }

    public String readLine() {
        System.out.flush();
        String line = "";
        try {
            while (true) {
                int ch;
                if ((ch = this.inputScript == null ? System.in.read() : this.inputScript.read()) == -1 && line.length() == 0) {
                    try {
                        if (this.inputScript != null) {
                            this.inputScript.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.inputScript = null;
                    continue;
                }
                if (ch != -1 && ch != 10) {
                    line = String.valueOf(line) + (char)ch;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.inputScript != null) {
            this.print(String.valueOf(line) + "\n", 1);
        }
        return line;
    }

    public String getText() {
        return this.text;
    }

    public String getText(int start, int end) {
        return this.text.substring(start, end);
    }

    public int getLength() {
        return this.text.length();
    }

    public Component getConsoleModel() {
        return null;
    }

    public Component getTextPane() {
        return null;
    }

    public void setFont(Font font) {
        if (font != font) {
            // empty if block
        }
    }

    public void setInputStyle(int style) {
    }

    public void setInputColor(Color color) {
    }

    public void setErrorStyle(int style) {
    }

    public void setErrorColor(Color color) {
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void selectAll() {
    }

    public boolean isPointSelection() {
        return true;
    }

    public void print(PrintJob pj) {
    }

    public void setInputScript(BufferedReader rd) {
        this.inputScript = rd;
    }

    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    public Component getConsolePane() {
        return null;
    }

    public void requestFocus() {
    }

    public void setMenuBar(ProgramMenuBar mbar) {
    }
}

