/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.program.CommandLineProgramLoader;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineProgram
implements IOModel,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private HashMap<String, String> parameterTable = null;
    private ArrayList<Object> finalizers = new ArrayList();
    private AppletStub appletStub;
    private String myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
    private IOConsole myConsole;

    protected CommandLineProgram() {
        this.setConsole(this.createConsole());
    }

    public static void checkIfHeadless(String className) {
        if (!JTFTools.testDebugOption("headless")) {
            try {
                Class<?> graphicsEnvironmentClass = Class.forName("java.awt.GraphicsEnvironment");
                Method isHeadless = graphicsEnvironmentClass.getMethod("isHeadless", new Class[0]);
                if (!Boolean.TRUE.equals(isHeadless.invoke(null, new Object[0]))) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
        try {
            CommandLineProgramLoader loader = new CommandLineProgramLoader(className);
            Class<?> mainClass = loader.loadClass(className);
            CommandLineProgram program = (CommandLineProgram)mainClass.newInstance();
            program.init();
            program.run();
            program.exit();
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    @Override
    public void run() {
    }

    public void init() {
    }

    @Override
    public void print(String value) {
        this.getOutputModel().print(value);
    }

    @Override
    public final void print(boolean x) {
        this.print("" + x);
    }

    @Override
    public final void print(char x) {
        this.print("" + x);
    }

    @Override
    public final void print(double x) {
        this.print("" + x);
    }

    @Override
    public final void print(float x) {
        this.print("" + x);
    }

    @Override
    public final void print(int x) {
        this.print("" + x);
    }

    @Override
    public final void print(long x) {
        this.print("" + x);
    }

    @Override
    public final void print(Object x) {
        this.print("" + x);
    }

    @Override
    public void println() {
        this.getOutputModel().println();
    }

    @Override
    public void println(String value) {
        this.getOutputModel().println(value);
    }

    @Override
    public final void println(boolean x) {
        this.println("" + x);
    }

    @Override
    public final void println(char x) {
        this.println("" + x);
    }

    @Override
    public final void println(double x) {
        this.println("" + x);
    }

    @Override
    public final void println(float x) {
        this.println("" + x);
    }

    @Override
    public final void println(int x) {
        this.println("" + x);
    }

    @Override
    public final void println(long x) {
        this.println("" + x);
    }

    @Override
    public final void println(Object x) {
        this.println("" + x);
    }

    @Override
    public void showErrorMessage(String msg) {
        this.getOutputModel().showErrorMessage(msg);
    }

    @Override
    public final String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String prompt) {
        return this.getInputModel().readLine(prompt);
    }

    @Override
    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final int readInt(int low, int high) {
        return this.readInt(null, low, high);
    }

    @Override
    public final int readInt(String prompt) {
        return this.readInt(prompt, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int readInt(String prompt, int low, int high) {
        return this.getInputModel().readInt(prompt, low, high);
    }

    @Override
    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public final double readDouble(double low, double high) {
        return this.readDouble(null, low, high);
    }

    @Override
    public final double readDouble(String prompt) {
        return this.readDouble(prompt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double readDouble(String prompt, double low, double high) {
        return this.getInputModel().readDouble(prompt, low, high);
    }

    @Override
    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public final boolean readBoolean(String prompt) {
        return this.readBoolean(prompt, "true", "false");
    }

    @Override
    public boolean readBoolean(String prompt, String trueLabel, String falseLabel) {
        return this.getInputModel().readBoolean(prompt, trueLabel, falseLabel);
    }

    public boolean isAppletMode() {
        return false;
    }

    public void setConsole(IOConsole console) {
        this.myConsole = console;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public IODialog getDialog() {
        return null;
    }

    public IOModel getInputModel() {
        return this.getConsole();
    }

    public IOModel getOutputModel() {
        return this.getConsole();
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String region) {
        if (region != region) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void add(Component comp, String region, Object constraints) {
        if (comp != comp) {
            // empty if block
        }
        if (region != region) {
            // empty if block
        }
        if (constraints != constraints) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void addActionListeners() {
        throw new ErrorException("No graphics environment");
    }

    public void addActionListeners(ActionListener listener) {
        if (listener != listener) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void start(String[] args) {
        if (this.parameterTable == null && args != null) {
            this.parameterTable = CommandLineProgram.createParameterTable(args);
        }
        this.init();
        this.run();
    }

    public void exit() {
        int nFinalizers = this.finalizers.size();
        int i = 0;
        while (i < nFinalizers) {
            Object obj = this.finalizers.get(i);
            try {
                Class<?> c = obj.getClass();
                Method exit = c.getMethod("exit", new Class[0]);
                exit.invoke(obj, new Object[0]);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
            ++i;
        }
    }

    public void addExitHook(Object obj) {
        this.finalizers.add(obj);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        throw new ErrorException("No graphics environment");
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public String getParameter(String name) {
        String value = null;
        if (this.parameterTable != null) {
            value = this.parameterTable.get(name.toLowerCase());
        }
        return value;
    }

    public void setLayout(LayoutManager layout) {
        if (layout != layout) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public LayoutManager getLayout() {
        throw new ErrorException("No graphics environment");
    }

    public void setBackground(Color color) {
        if (color != color) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != comp) {
            // empty if block
        }
        if (constraints != constraints) {
            // empty if block
        }
        if (index != index) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void remove(int index) {
        if (index != index) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void remove(Component comp) {
        if (comp != comp) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void removeAll() {
        throw new ErrorException("No graphics environment");
    }

    public void validate() {
        throw new ErrorException("No graphics environment");
    }

    public void repaint() {
        throw new ErrorException("No graphics environment");
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        HashMap<String, String> ht = CommandLineProgram.createParameterTable(args);
        JTFTools.setDebugOptions(ht.get("debug"));
        String className = ht.get("code");
        if (className == null) {
            className = JTFTools.getMainClass();
        }
        Class<?> mainClass = null;
        CommandLineProgram program = null;
        if (className != null) {
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            className = className.replace('/', '.');
            try {
                mainClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (mainClass != null) {
            try {
                Object obj = mainClass.newInstance();
                if (!(obj instanceof CommandLineProgram)) {
                    throw new ErrorException("Main class does not specify a program");
                }
                program = (CommandLineProgram)obj;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (program == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        program.setParameterTable(ht);
        program.start(null);
    }

    public void menuAction(String cmd) {
        if (cmd != cmd) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected void setMacMenuBarFlag(boolean flag) {
        if (flag != flag) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected boolean getMacMenuBarFlag() {
        throw new ErrorException("No graphics environment");
    }

    protected Component getBorder(String side) {
        if (side != side) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected String[] getArgumentArray() {
        if (this.parameterTable == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.parameterTable.get("ARGS"), "\t", false);
        String[] args = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            args[i] = tokenizer.nextToken();
            ++i;
        }
        return args;
    }

    protected boolean isStarted() {
        throw new ErrorException("No graphics environment");
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub stub) {
        this.appletStub = stub;
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap<String, String> ht) {
        this.parameterTable = ht;
    }

    protected HashMap<String, String> getParameterTable() {
        return this.parameterTable;
    }

    protected static HashMap<String, String> createParameterTable(String[] args) {
        if (args == null) {
            return null;
        }
        HashMap<String, String> ht = new HashMap<String, String>();
        String newArgs = "";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int equals = arg.indexOf(61);
            if (equals > 0) {
                String name = arg.substring(0, equals).toLowerCase();
                String value = arg.substring(equals + 1);
                ht.put(name, value);
            } else {
                if (newArgs.length() > 0) {
                    newArgs = String.valueOf(newArgs) + '\t';
                }
                newArgs = String.valueOf(newArgs) + arg;
            }
            ++i;
        }
        ht.put("ARGS", newArgs);
        return ht;
    }
}

