/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.OldStyleCheckBoxMenuItem;
import acm.program.OldStyleMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuBarListener;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramMenuBar
extends JMenuBar
implements Iterable<JMenuItem> {
    public static final int SHIFT = 131072;
    private Program program;
    private ActionListener menuBarListener;
    private ActionListener focusedListener;
    private HashMap<KeyStroke, JMenuItem> accelerators;
    private HashSet<JMenuItem> focusedItems;
    private MenuBar oldStyleMenuBar;
    private boolean macMenuBarFlag;

    public ProgramMenuBar(Program owner) {
        this.program = owner;
        this.menuBarListener = new ProgramMenuBarListener(this);
        this.focusedListener = null;
        this.accelerators = new HashMap();
        this.focusedItems = new HashSet();
        this.macMenuBarFlag = true;
        this.addMenus();
    }

    public Program getProgram() {
        return this.program;
    }

    public JMenuItem createStandardItem(String action) {
        JMenuItem item = null;
        if (action.equals("Quit")) {
            item = this.createProgramItem(action);
            if (Platform.isMac()) {
                this.setAccelerator(item, 81);
            } else {
                item.setName("Exit");
            }
        } else if (action.equals("Cut")) {
            item = this.createFocusedItem(action, 88);
            if (!Platform.isMac()) {
                item.setName("Cut (x)");
            }
        } else if (action.equals("Copy")) {
            item = this.createFocusedItem(action, 67);
            if (!Platform.isMac()) {
                item.setName("Copy (c)");
            }
        } else if (action.equals("Paste")) {
            item = this.createFocusedItem(action, 86);
            if (!Platform.isMac()) {
                item.setName("Paste (v)");
            }
        } else if (action.equals("Select All")) {
            item = this.createFocusedItem(action, 65);
        } else if (action.equals("Save")) {
            item = this.createFocusedItem(action, 83);
        } else if (action.equals("Save As")) {
            item = this.createFocusedItem(action);
        } else if (action.equals("Print")) {
            item = this.createProgramItem(action, 80);
            item.setName("Print...");
        } else if (action.equals("Print Console")) {
            item = this.createProgramItem(action);
        } else if (action.equals("Script")) {
            item = this.createProgramItem(action);
            item.setName("Script...");
        } else if (action.equals("Export Applet")) {
            item = this.createProgramItem(action);
            item.setName("Export Applet...");
        } else if (action.equals("Submit Project")) {
            item = this.createProgramItem(action);
            item.setName("Submit Project...");
        } else {
            throw new ErrorException("Illegal standard menu item: " + action);
        }
        return item;
    }

    public JMenuItem createProgramItem(String action) {
        JMenuItem item = new JMenuItem(action);
        item.setActionCommand(action);
        item.addActionListener(this.menuBarListener);
        return item;
    }

    public JMenuItem createProgramItem(String action, int key) {
        JMenuItem item = this.createProgramItem(action);
        this.setAccelerator(item, key);
        return item;
    }

    public JMenuItem createFocusedItem(String action) {
        JMenuItem item = this.createProgramItem(action);
        this.focusedItems.add(item);
        return item;
    }

    public JMenuItem createFocusedItem(String action, int key) {
        JMenuItem item = this.createFocusedItem(action);
        this.setAccelerator(item, key);
        return item;
    }

    public boolean isFocusedItem(JMenuItem item) {
        return this.focusedItems.contains(item);
    }

    public void setAccelerator(JMenuItem item, int key) {
        int mask;
        int n = mask = Platform.isMac() ? 4 : 2;
        if (key > 65536) {
            key -= 131072;
            mask |= 1;
        }
        KeyStroke stroke = KeyStroke.getKeyStroke((int)((char)key), mask);
        this.accelerators.put(stroke, item);
        if (Platform.isMac()) {
            item.setAccelerator(stroke);
        } else {
            item.setMnemonic(key);
        }
    }

    public void setEnabled(String action, boolean flag) {
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            this.setEnabled(this.getMenu(i), action, flag);
            ++i;
        }
    }

    public void install(Component comp) {
        Container contentPane = this.program.getContentPane();
        while (comp != null && !(comp instanceof JFrame)) {
            if ((comp = comp.getParent()) != contentPane || !this.program.isAppletMode()) continue;
            if (!Platform.isMac() || !this.macMenuBarFlag) {
                this.program.setJMenuBar(this);
            }
            return;
        }
        if (comp == null) {
            return;
        }
        JFrame frame = (JFrame)comp;
        if (Platform.isMac() && this.macMenuBarFlag) {
            if (this.oldStyleMenuBar == null) {
                this.oldStyleMenuBar = this.createOldStyleMenuBar();
            }
            frame.setMenuBar(this.oldStyleMenuBar);
        } else {
            frame.setJMenuBar(this);
            frame.validate();
        }
    }

    public void setMacMenuBarFlag(boolean flag) {
        this.macMenuBarFlag = flag;
    }

    public boolean getMacMenuBarFlag() {
        return this.macMenuBarFlag;
    }

    public void fireActionListeners(ActionEvent e) {
        if (this.focusedListener != null && this.focusedItems.contains(e.getSource())) {
            this.focusedListener.actionPerformed(e);
        } else {
            this.program.menuAction(e);
        }
    }

    public boolean fireAccelerator(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        JMenuItem item = this.accelerators.get(stroke);
        if (item != null) {
            item.doClick(0);
            return true;
        }
        return false;
    }

    public void setFocusedListener(ActionListener listener) {
        this.focusedListener = listener;
    }

    @Override
    public Iterator<JMenuItem> iterator() {
        ArrayList<JMenuItem> itemList = new ArrayList<JMenuItem>();
        int i = 0;
        while (i < this.getMenuCount()) {
            this.addItemToList(itemList, this.getMenu(i));
            ++i;
        }
        return itemList.iterator();
    }

    protected void addMenus() {
        this.addFileMenu();
        this.addEditMenu();
    }

    protected void addFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.addFileMenuItems(fileMenu);
        this.add(fileMenu);
    }

    protected void addEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        this.addEditMenuItems(editMenu);
        this.add(editMenu);
    }

    protected void addFileMenuItems(JMenu menu) {
        menu.add(this.createStandardItem("Save"));
        menu.add(this.createStandardItem("Save As"));
        menu.addSeparator();
        menu.add(this.createStandardItem("Print"));
        menu.add(this.createStandardItem("Print Console"));
        menu.add(this.createStandardItem("Script"));
        menu.addSeparator();
        menu.add(this.createStandardItem("Export Applet"));
        menu.add(this.createStandardItem("Submit Project"));
        menu.addSeparator();
        menu.add(this.createStandardItem("Quit"));
    }

    protected void addEditMenuItems(JMenu menu) {
        menu.add(this.createStandardItem("Cut"));
        menu.add(this.createStandardItem("Copy"));
        menu.add(this.createStandardItem("Paste"));
        menu.add(this.createStandardItem("Select All"));
    }

    private void addItemToList(ArrayList<JMenuItem> itemList, JMenuItem item) {
        if (item == null) {
            return;
        }
        if (item instanceof JMenu) {
            JMenu menu = (JMenu)item;
            int i = 0;
            while (i < menu.getItemCount()) {
                this.addItemToList(itemList, menu.getItem(i));
                ++i;
            }
        } else {
            itemList.add(item);
        }
    }

    private MenuBar createOldStyleMenuBar() {
        MenuBar mbar = new MenuBar();
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            mbar.add(this.createOldStyleMenu(this.getMenu(i)));
            ++i;
        }
        return mbar;
    }

    private Menu createOldStyleMenu(JMenu jmenu) {
        Menu menu = new Menu(jmenu.getText());
        int nItems = jmenu.getItemCount();
        int i = 0;
        while (i < nItems) {
            menu.add(this.createOldStyleMenuItem(jmenu.getItem(i)));
            ++i;
        }
        return menu;
    }

    private MenuItem createOldStyleMenuItem(Object jitem) {
        if (jitem == null) {
            return new MenuItem("-");
        }
        if (jitem instanceof JMenu) {
            return this.createOldStyleMenu((JMenu)jitem);
        }
        if (jitem instanceof JCheckBoxMenuItem) {
            return new OldStyleCheckBoxMenuItem((JCheckBoxMenuItem)jitem);
        }
        if (jitem instanceof JMenuItem) {
            return new OldStyleMenuItem((JMenuItem)jitem);
        }
        throw new ErrorException("Unsupported menu item type");
    }

    private void setEnabled(JMenu item, String action, boolean flag) {
        JMenu menu = item;
        int nItems = menu.getItemCount();
        int i = 0;
        while (i < nItems) {
            JMenuItem subItem = menu.getItem(i);
            if (subItem != null) {
                this.setEnabled(subItem, action, flag);
            }
            ++i;
        }
    }

    private void setEnabled(JMenuItem item, String action, boolean flag) {
        if (action.equals(item.getActionCommand())) {
            item.setEnabled(flag);
        }
    }
}

