/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

class Base64OutputStream
extends OutputStream {
    private static final int COLUMNS = 76;
    private static final char[] BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private int buffer;
    private int columnCount;
    private int byteCount;
    private PrintStream out;

    public Base64OutputStream(PrintStream printStream) {
        this.out = printStream;
        this.out.flush();
        this.byteCount = 0;
        this.columnCount = 0;
        this.buffer = 0;
    }

    public void write(int b) throws IOException {
        this.buffer = this.buffer << 8 | b & 0xFF;
        ++this.byteCount;
        if (this.byteCount == 3) {
            this.out.write(BASE64[this.buffer >> 18 & 0x3F]);
            this.out.write(BASE64[this.buffer >> 12 & 0x3F]);
            this.out.write(BASE64[this.buffer >> 6 & 0x3F]);
            this.out.write(BASE64[this.buffer & 0x3F]);
            this.columnCount += 4;
            if (this.columnCount >= 76) {
                this.columnCount = 0;
                this.out.println();
            }
            this.byteCount = 0;
            this.buffer = 0;
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.pad();
        this.out.close();
    }

    public void pad() {
        switch (this.byteCount) {
            case 0: {
                break;
            }
            case 1: {
                this.out.write(BASE64[this.buffer >> 2 & 0x3F]);
                this.out.write(BASE64[this.buffer << 4 & 0x3F]);
                this.out.write(61);
                this.out.write(61);
                break;
            }
            case 2: {
                this.out.write(BASE64[this.buffer >> 10 & 0x3F]);
                this.out.write(BASE64[this.buffer >> 4 & 0x3F]);
                this.out.write(BASE64[this.buffer << 2 & 0x3F]);
                this.out.write(61);
            }
        }
        this.out.println();
        this.out.println();
    }
}

