/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.program.Program;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

class ExportAppletDialog
extends JFileChooser {
    private JCheckBox exportFilesCheckBox;
    private Component target;

    public ExportAppletDialog(File dir, Program program) {
        super(dir);
        this.setFileSelectionMode(1);
        this.setDialogTitle("Export Applet");
        String className = program.getClass().getName();
        String programName = className.substring(className.lastIndexOf(46) + 1);
        this.setSelectedFile(new File(dir, programName));
        this.exportFilesCheckBox = new JCheckBox("Export resource files");
        this.exportFilesCheckBox.setSelected(true);
        this.target = program;
    }

    protected JDialog createDialog(Component parent) {
        JDialog dialog = super.createDialog(parent);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.exportFilesCheckBox);
        dialog.getContentPane().add((Component)panel, "South");
        dialog.validate();
        return dialog;
    }

    public File chooseOutputDirectory() {
        int result = this.showSaveDialog(this.target);
        if (result == 1) {
            return null;
        }
        return this.getSelectedFile();
    }

    public boolean exportFiles() {
        return this.exportFilesCheckBox.isSelected();
    }
}

