/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    String filenamePattern;
    String filenameDescription;

    public FileChooserFilter() {
        this.filenamePattern = null;
        this.filenameDescription = null;
    }

    public FileChooserFilter(String pattern) {
        this(pattern, String.valueOf(pattern) + " files");
    }

    public FileChooserFilter(String pattern, String description) {
        this.filenamePattern = pattern;
        this.filenameDescription = description;
    }

    public boolean accept(File file) {
        if (this.filenamePattern == null) {
            throw new ErrorException("No override definition for accept");
        }
        if (file.isDirectory()) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.filenamePattern, ";");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (pattern.length() <= 0 || !JTFTools.matchFilenamePattern(file.getName(), pattern)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        if (this.filenameDescription == null) {
            throw new ErrorException("No override definition for getDescription");
        }
        return this.filenameDescription;
    }
}

