/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.DirectGif89Frame;
import acm.util.Gif89Frame;
import acm.util.Gif89Put;
import acm.util.GifColorTable;
import acm.util.IndexGif89Frame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

class Gif89Encoder {
    private Dimension dispDim = new Dimension(0, 0);
    private GifColorTable colorTable;
    private int bgIndex = 0;
    private int loopCount = 1;
    private String theComments;
    private Vector<Gif89Frame> vFrames = new Vector();

    public Gif89Encoder() {
        this.colorTable = new GifColorTable();
    }

    public Gif89Encoder(Image static_image) throws IOException {
        this();
        this.addFrame(static_image);
    }

    public Gif89Encoder(Color[] colors) {
        this.colorTable = new GifColorTable(colors);
    }

    public Gif89Encoder(Color[] colors, int width, int height, byte[] ci_pixels) throws IOException {
        this(colors);
        this.addFrame(width, height, ci_pixels);
    }

    public int getFrameCount() {
        return this.vFrames.size();
    }

    public Gif89Frame getFrameAt(int index) {
        return this.isOk(index) ? this.vFrames.elementAt(index) : null;
    }

    public void addFrame(Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.addElement(gf);
    }

    public void addFrame(Image image) throws IOException {
        this.addFrame(new DirectGif89Frame(image));
    }

    public void addFrame(int width, int height, byte[] ci_pixels) throws IOException {
        this.addFrame(new IndexGif89Frame(width, height, ci_pixels));
    }

    public void insertFrame(int index, Gif89Frame gf) throws IOException {
        this.accommodateFrame(gf);
        this.vFrames.insertElementAt(gf, index);
    }

    public void setTransparentIndex(int index) {
        this.colorTable.setTransparent(index);
    }

    public void setLogicalDisplay(Dimension dim, int background) {
        this.dispDim = new Dimension(dim);
        this.bgIndex = background;
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    public void setComments(String comments) {
        this.theComments = comments;
    }

    public void setUniformDelay(int interval) {
        int i = 0;
        while (i < this.vFrames.size()) {
            this.vFrames.elementAt(i).setDelay(interval);
            ++i;
        }
    }

    public void encode(OutputStream out) throws IOException {
        int nframes = this.getFrameCount();
        boolean is_sequence = nframes > 1;
        this.colorTable.closePixelProcessing();
        Gif89Put.ascii("GIF89a", out);
        this.writeLogicalScreenDescriptor(out);
        this.colorTable.encode(out);
        if (is_sequence && this.loopCount != 1) {
            this.writeNetscapeExtension(out);
        }
        if (this.theComments != null && this.theComments.length() > 0) {
            this.writeCommentExtension(out);
        }
        int i = 0;
        while (i < nframes) {
            this.vFrames.elementAt(i).encode(out, is_sequence, this.colorTable.getDepth(), this.colorTable.getTransparent());
            ++i;
        }
        out.write(59);
        out.flush();
    }

    public static void main(String[] args) {
        try {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("gif89out.gif"));
                if (args[0].toUpperCase().endsWith(".JPG")) {
                    new Gif89Encoder(tk.getImage(args[0])).encode(out);
                } else {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(args[0]));
                    Gif89Encoder ge = new Gif89Encoder();
                    while ((line = in.readLine()) != null) {
                        ge.addFrame(tk.getImage(line.trim()));
                    }
                    ge.setLoopCount(0);
                    ge.encode(out);
                    in.close();
                }
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            System.exit(0);
        }
    }

    private void accommodateFrame(Gif89Frame gf) throws IOException {
        this.dispDim.width = Math.max(this.dispDim.width, gf.getWidth());
        this.dispDim.height = Math.max(this.dispDim.height, gf.getHeight());
        this.colorTable.processPixels(gf);
    }

    private void writeLogicalScreenDescriptor(OutputStream os) throws IOException {
        Gif89Put.leShort(this.dispDim.width, os);
        Gif89Put.leShort(this.dispDim.height, os);
        os.write(0xF0 | this.colorTable.getDepth() - 1);
        os.write(this.bgIndex);
        os.write(0);
    }

    private void writeNetscapeExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(255);
        os.write(11);
        Gif89Put.ascii("NETSCAPE2.0", os);
        os.write(3);
        os.write(1);
        Gif89Put.leShort(this.loopCount > 1 ? this.loopCount - 1 : 0, os);
        os.write(0);
    }

    private void writeCommentExtension(OutputStream os) throws IOException {
        os.write(33);
        os.write(254);
        int remainder = this.theComments.length() % 255;
        int nsubblocks_full = this.theComments.length() / 255;
        int nsubblocks = nsubblocks_full + (remainder > 0 ? 1 : 0);
        int ibyte = 0;
        int isb = 0;
        while (isb < nsubblocks) {
            int size = isb < nsubblocks_full ? 255 : remainder;
            os.write(size);
            Gif89Put.ascii(this.theComments.substring(ibyte, ibyte + size), os);
            ibyte += size;
            ++isb;
        }
        os.write(0);
    }

    private boolean isOk(int frame_index) {
        return frame_index >= 0 && frame_index < this.vFrames.size();
    }
}

