/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.program.Program;
import acm.util.Base64OutputStream;
import acm.util.DOSCommandLine;
import acm.util.EmptyContainer;
import acm.util.ErrorException;
import acm.util.ExportAppletDialog;
import acm.util.HexByteOutputStream;
import acm.util.MailStream;
import acm.util.NullOutputStream;
import acm.util.Platform;
import acm.util.ProgressBarDialog;
import acm.util.SubmitOptions;
import acm.util.ThreadedMenuAction;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JProgressBar;

public class JTFTools {
    private static final String[] SKIP_FILES = new String[]{".DS_Store", "FINDER.DAT", "RESOURCE.FRK"};
    private static final String[] RESOURCE_EXTENSIONS = new String[]{".txt", ".dat", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav", ".class"};
    private static final String[] SUBMIT_EXTENSIONS = new String[]{".java", ".html", ".txt", ".dat", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav"};
    private static HashMap<Component, SubmitOptions> optionsTable = new HashMap();
    private static final int BUFFER_SIZE = 4096;
    private static final String[] SERIF_SUBSTITUTIONS = new String[]{"Serif", "Times", "TimesRoman", "Times-Roman"};
    private static final String[] SANSSERIF_SUBSTITUTIONS = new String[]{"SansSerif", "Helvetica", "Arial"};
    private static final String[] MONOSPACED_SUBSTITUTIONS = new String[]{"Monospaced", "Courier", "Monaco"};
    private static final String[] SKIP_JARS = new String[]{"acm.jar", "acm11.jar", "swingall.jar", "patchJTF.jar"};
    private static boolean fontFamilyTableInitialized = false;
    private static String[] fontFamilyArray = null;
    private static HashMap<String, String> fontFamilyTable = null;
    private static HashMap<Thread, Applet> appletTable = new HashMap();
    private static Applet mostRecentApplet = null;
    private static SecurityManager managerThatFails = null;
    private static String debugOptions = null;

    private JTFTools() {
    }

    public static void pause(double milliseconds) {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
            appletTable.put(Thread.currentThread(), applet);
        }
        try {
            int millis = (int)milliseconds;
            int nanos = (int)Math.round((milliseconds - (double)millis) * 1000000.0);
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Container createEmptyContainer() {
        return new EmptyContainer();
    }

    public static Frame getEnclosingFrame(Component comp) {
        if (comp instanceof Program) {
            comp = ((Program)comp).getContentPane();
        }
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static Font getStandardFont(Font font) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        if (font == null || fontFamilyTable == null) {
            return font;
        }
        String family = font.getFamily();
        if (fontFamilyTable.get(JTFTools.trimFamilyName(family)) != null) {
            return font;
        }
        if (family.equals("Serif") || family.equals("Times")) {
            family = JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS);
        } else if (family.equals("SansSerif")) {
            family = JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS);
        } else if (family.equals("Monospaced")) {
            family = JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS);
        } else {
            return font;
        }
        if (family == null) {
            return font;
        }
        return new Font(family, font.getStyle(), font.getSize());
    }

    public static String[] getFontList() {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        return fontFamilyArray;
    }

    public static String findFontFamily(String str) {
        if (!fontFamilyTableInitialized) {
            JTFTools.initFontFamilyTable();
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ";", false);
        while (tokenizer.hasMoreTokens()) {
            String familyName = fontFamilyTable.get(JTFTools.trimFamilyName(tokenizer.nextToken()));
            if (familyName == null) continue;
            return familyName;
        }
        return null;
    }

    public static Font decodeFont(String str) {
        return JTFTools.decodeFont(str, null);
    }

    public static Font decodeFont(String str, Font oldFont) {
        String familyName = str;
        int fontStyle = oldFont == null ? 0 : oldFont.getStyle();
        int fontSize = oldFont == null ? 12 : oldFont.getSize();
        int hyphen = str.indexOf(45);
        if (hyphen >= 0) {
            familyName = str.substring(0, hyphen);
            String styleName = str = str.substring(hyphen + 1).toLowerCase();
            hyphen = str.indexOf(45);
            if (hyphen >= 0) {
                styleName = str.substring(0, hyphen);
                str = str.substring(hyphen + 1);
            } else {
                str = "*";
            }
            if (Character.isDigit(styleName.charAt(0))) {
                String tmp = styleName;
                styleName = str;
                str = tmp;
            }
            if (styleName.equals("plain")) {
                fontStyle = 0;
            } else if (styleName.equals("bold")) {
                fontStyle = 1;
            } else if (styleName.equals("italic")) {
                fontStyle = 2;
            } else if (styleName.equals("bolditalic")) {
                fontStyle = 3;
            } else if (!styleName.equals("*")) {
                throw new ErrorException("Illegal font style");
            }
            if (!str.equals("*")) {
                try {
                    fontSize = Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    throw new ErrorException("Illegal font size");
                }
            }
        }
        if (familyName.equals("*")) {
            familyName = oldFont == null ? "Default" : oldFont.getName();
        } else {
            if (!fontFamilyTableInitialized) {
                JTFTools.initFontFamilyTable();
            }
            if (fontFamilyTable != null && (familyName = fontFamilyTable.get(JTFTools.trimFamilyName(familyName))) == null) {
                familyName = "Default";
            }
        }
        return JTFTools.getStandardFont(new Font(familyName, fontStyle, fontSize));
    }

    public static Color decodeColor(String name) {
        if (name.equalsIgnoreCase("desktop")) {
            return SystemColor.desktop;
        }
        if (name.equalsIgnoreCase("activeCaption")) {
            return SystemColor.activeCaption;
        }
        if (name.equalsIgnoreCase("activeCaptionText")) {
            return SystemColor.activeCaptionText;
        }
        if (name.equalsIgnoreCase("activeCaptionBorder")) {
            return SystemColor.activeCaptionBorder;
        }
        if (name.equalsIgnoreCase("inactiveCaption")) {
            return SystemColor.inactiveCaption;
        }
        if (name.equalsIgnoreCase("inactiveCaptionText")) {
            return SystemColor.inactiveCaptionText;
        }
        if (name.equalsIgnoreCase("inactiveCaptionBorder")) {
            return SystemColor.inactiveCaptionBorder;
        }
        if (name.equalsIgnoreCase("window")) {
            return SystemColor.window;
        }
        if (name.equalsIgnoreCase("windowBorder")) {
            return SystemColor.windowBorder;
        }
        if (name.equalsIgnoreCase("windowText")) {
            return SystemColor.windowText;
        }
        if (name.equalsIgnoreCase("menu")) {
            return SystemColor.menu;
        }
        if (name.equalsIgnoreCase("menuText")) {
            return SystemColor.menuText;
        }
        if (name.equalsIgnoreCase("text")) {
            return SystemColor.text;
        }
        if (name.equalsIgnoreCase("textText")) {
            return SystemColor.textText;
        }
        if (name.equalsIgnoreCase("textHighlight")) {
            return SystemColor.textHighlight;
        }
        if (name.equalsIgnoreCase("textHighlightText")) {
            return SystemColor.textHighlightText;
        }
        if (name.equalsIgnoreCase("textInactiveText")) {
            return SystemColor.textInactiveText;
        }
        if (name.equalsIgnoreCase("control")) {
            return SystemColor.control;
        }
        if (name.equalsIgnoreCase("controlText")) {
            return SystemColor.controlText;
        }
        if (name.equalsIgnoreCase("controlHighlight")) {
            return SystemColor.controlHighlight;
        }
        if (name.equalsIgnoreCase("controlLtHighlight")) {
            return SystemColor.controlLtHighlight;
        }
        if (name.equalsIgnoreCase("controlShadow")) {
            return SystemColor.controlShadow;
        }
        if (name.equalsIgnoreCase("controlDkShadow")) {
            return SystemColor.controlDkShadow;
        }
        if (name.equalsIgnoreCase("scrollbar")) {
            return SystemColor.scrollbar;
        }
        if (name.equalsIgnoreCase("info")) {
            return SystemColor.info;
        }
        if (name.equalsIgnoreCase("infoText")) {
            return SystemColor.infoText;
        }
        if (name.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (name.equalsIgnoreCase("darkGray")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (name.equalsIgnoreCase("lightGray")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (name.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        try {
            return Color.decode(name);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("Illegal color value");
        }
    }

    public static boolean matchFilenamePattern(String filename, String pattern) {
        return JTFTools.recursiveMatch(filename, 0, pattern, 0);
    }

    public static void registerApplet(Applet applet) {
        JTFTools.registerApplet(applet, Thread.currentThread());
        mostRecentApplet = applet;
    }

    public static void registerApplet(Applet applet, Thread thread) {
        appletTable.put(thread, applet);
    }

    public static Applet getApplet() {
        Applet applet = appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
        }
        return applet;
    }

    public static void setDebugOptions(String options) {
        debugOptions = options == null ? null : "+" + options.toLowerCase() + "+";
    }

    public static boolean testDebugOption(String option) {
        if (debugOptions == null) {
            return false;
        }
        return debugOptions.indexOf("+" + option.toLowerCase() + "+") >= 0;
    }

    public static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return JTFTools.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return JTFTools.getShellCommandLine();
    }

    public static String getMainClass() {
        String className = null;
        try {
            className = System.getProperty("java.main");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className == null) {
            className = JTFTools.readMainClassFromClassPath();
        }
        if (className == null) {
            String commandLine = JTFTools.getCommandLine();
            className = JTFTools.readMainClassFromCommandLine(commandLine);
        }
        return className;
    }

    public static boolean checkIfLoaded(String className) {
        boolean result;
        block14: {
            block13: {
                if (Platform.compareVersion("1.2") < 0) {
                    return false;
                }
                result = false;
                if (System.getSecurityManager() == null) break block13;
                return false;
            }
            if (managerThatFails != null) break block14;
            try {
                Class<?> managerThatFailsClass = Class.forName("acm.util.SecurityManagerThatFails");
                managerThatFails = (SecurityManager)managerThatFailsClass.newInstance();
            }
            catch (Exception ex) {
                return false;
            }
        }
        try {
            System.setSecurityManager(managerThatFails);
            try {
                try {
                    result = Class.forName(className) != null;
                }
                catch (ExceptionInInitializerError err) {
                    result = true;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
            finally {
                System.setSecurityManager(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void terminateAppletThreads(Applet applet) {
        try {
            Thread myThread = Thread.currentThread();
            Class<?> threadClass = Class.forName("java.lang.Thread");
            Method stop = threadClass.getMethod("stop", new Class[0]);
            for (Thread t : appletTable.keySet()) {
                if (t == myThread || !t.isAlive() || !JTFTools.isAnonymous(t) || applet != appletTable.get(t)) continue;
                stop.invoke((Object)t, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAnonymous(Thread t) {
        String name = t.getName();
        if (!name.startsWith("Thread-")) {
            return false;
        }
        int i = 7;
        while (i < name.length()) {
            if (!Character.isDigit(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static PrintStream openMailStream(String smtpServer, String from, String to) {
        return new MailStream(smtpServer, from, to);
    }

    public static void cancelMail(PrintStream out) {
        ((MailStream)out).cancel();
    }

    public static void sendStandardHeaders(PrintStream out, String senderName, String subject) {
        ((MailStream)out).sendStandardHeaders(senderName, subject);
    }

    public static OutputStream openHexByteOutputStream(PrintStream printStream) {
        return new HexByteOutputStream(printStream);
    }

    public static OutputStream openBase64OutputStream(PrintStream printStream) {
        return new Base64OutputStream(printStream);
    }

    public static void padBase64OutputStream(OutputStream out) {
        ((Base64OutputStream)out).pad();
    }

    public static void exportJar(File jarFile, File dir, String imports, Object transformer) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jarFile));
            JTFTools.dumpJarAndResources("", dir, out, null, imports, null, false, transformer);
            out.close();
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public static boolean executeExportAction(Program program, String command) {
        if (command.equals("Export Applet") || command.equals("Submit Project")) {
            new Thread(new ThreadedMenuAction(program, command)).start();
            return true;
        }
        return false;
    }

    public static String getLocalHostName() {
        try {
            InetAddress myHost = InetAddress.getLocalHost();
            Class<?> inetAddressClass = myHost.getClass();
            Method getCanonicalHostName = inetAddressClass.getMethod("getCanonicalHostName", new Class[0]);
            return (String)getCanonicalHostName.invoke((Object)myHost, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void copyFile(File oldFile, File newFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(oldFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            JTFTools.copyBytes(in, out, oldFile.length());
            in.close();
            out.close();
            Platform.copyFileTypeAndCreator(oldFile, newFile);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, long nBytes) throws IOException {
        byte[] buffer = new byte[4096];
        while (nBytes > 0L) {
            int chunkSize = (int)Math.min(4096L, nBytes);
            if ((chunkSize = in.read(buffer, 0, chunkSize)) == -1) {
                return;
            }
            out.write(buffer, 0, chunkSize);
            nBytes -= (long)chunkSize;
        }
    }

    static String getURLSuffix(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static void exportApplet(Program program, JProgressBar progress) {
        try {
            File indexFile;
            String className = program.getClass().getName();
            String programName = className.substring(className.lastIndexOf(".") + 1);
            File dir = new File(System.getProperty("user.dir"));
            File home = new File(System.getProperty("user.home"));
            ExportAppletDialog dialog = new ExportAppletDialog(home, program);
            File outDir = dialog.chooseOutputDirectory();
            if (outDir == null) {
                return;
            }
            if (outDir.exists()) {
                if (!outDir.isDirectory()) {
                    outDir = new File(outDir.getParent());
                }
            } else {
                outDir.mkdir();
            }
            if (progress != null) {
                progress.setMaximum(JTFTools.countResources(dir, RESOURCE_EXTENSIONS, "acm.jar") + 1);
                ProgressBarDialog.popup(progress);
            }
            if ((indexFile = new File(dir, "index.html")).canRead()) {
                JTFTools.copyFile(indexFile, new File(outDir, "index.html"));
            } else {
                JTFTools.dumpHTMLIndex(outDir, program, className, programName);
            }
            if (progress != null) {
                if (ProgressBarDialog.hasBeenCancelled(progress)) {
                    return;
                }
                progress.setValue(progress.getValue() + 1);
            }
            JTFTools.dumpJarAndResources(dir, outDir, String.valueOf(programName) + ".jar", "acm.jar", progress, dialog.exportFiles(), null);
            if (progress != null) {
                ProgressBarDialog.dismiss(progress);
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private static void initFontFamilyTable() {
        fontFamilyTableInitialized = true;
        int pass = 1;
        while (fontFamilyArray == null && pass <= 2) {
            try {
                if (pass == 1) {
                    Class<?> classGE = Class.forName("java.awt.GraphicsEnvironment");
                    Method getLocalGraphicsEnvironment = classGE.getMethod("getLocalGraphicsEnvironment", new Class[0]);
                    Method getAvailableFontFamilyNames = classGE.getMethod("getAvailableFontFamilyNames", new Class[0]);
                    Object ge = getLocalGraphicsEnvironment.invoke(null, new Object[0]);
                    fontFamilyArray = (String[])getAvailableFontFamilyNames.invoke(ge, new Object[0]);
                } else {
                    Class<?> classToolkit = Class.forName("java.awt.Toolkit");
                    Method getFontList = classToolkit.getMethod("getFontList", new Class[0]);
                    fontFamilyArray = (String[])getFontList.invoke((Object)Toolkit.getDefaultToolkit(), new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++pass;
        }
        fontFamilyTable = new HashMap();
        int i = 0;
        while (i < fontFamilyArray.length) {
            fontFamilyTable.put(JTFTools.trimFamilyName(fontFamilyArray[i]), fontFamilyArray[i]);
            ++i;
        }
        fontFamilyTable.put("serif", JTFTools.getFirstAvailableFontSubstitution(SERIF_SUBSTITUTIONS));
        fontFamilyTable.put("sansserif", JTFTools.getFirstAvailableFontSubstitution(SANSSERIF_SUBSTITUTIONS));
        fontFamilyTable.put("monospaced", JTFTools.getFirstAvailableFontSubstitution(MONOSPACED_SUBSTITUTIONS));
    }

    private static String getFirstAvailableFontSubstitution(String[] fontOptions) {
        int i = 0;
        while (i < fontOptions.length) {
            if (fontFamilyTable.get(JTFTools.trimFamilyName(fontOptions[i])) != null) {
                return fontOptions[i];
            }
            ++i;
        }
        return null;
    }

    private static String trimFamilyName(String family) {
        String str = "";
        int i = 0;
        while (i < family.length()) {
            char ch = family.charAt(i);
            if (ch != ' ' && ch != '-') {
                str = String.valueOf(str) + Character.toLowerCase(ch);
            }
            ++i;
        }
        return str;
    }

    private static boolean recursiveMatch(String str, int sx, String pattern, int px) {
        int strlen = str.length();
        int patlen = pattern.length();
        if (px == patlen) {
            return sx == strlen;
        }
        char pch = pattern.charAt(px);
        if (pch == '*') {
            int i = sx;
            while (i <= strlen) {
                if (JTFTools.recursiveMatch(str, i, pattern, px + 1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (sx == strlen) {
            return false;
        }
        char sch = str.charAt(sx);
        if (pch == '[') {
            boolean match = false;
            boolean invert = false;
            if (++px == patlen) {
                throw new ErrorException("matchFilenamePattern: missing ]");
            }
            if (pattern.charAt(px) == '^') {
                ++px;
                invert = true;
            }
            while (px < patlen && pattern.charAt(px) != ']') {
                if (px + 2 < patlen && pattern.charAt(px + 1) == '-') {
                    match |= sch >= pattern.charAt(px) && sch <= pattern.charAt(px + 2);
                    px += 3;
                    continue;
                }
                match |= sch == pattern.charAt(px);
                ++px;
            }
            if (px == patlen) {
                throw new ErrorException("matchFilenamePattern: missing ]");
            }
            if (match == invert) {
                return false;
            }
        } else if (pch != '?' && pch != sch) {
            return false;
        }
        return JTFTools.recursiveMatch(str, sx + 1, pattern, px + 1);
    }

    private static String getShellCommandLine() {
        Process p;
        block3: {
            try {
                String option = Platform.isMac() ? "command" : "args";
                String[] argv = new String[]{"bash", "-c", "ps -p $PPID -o " + option};
                p = Runtime.getRuntime().exec(argv);
                p.waitFor();
                if (p.getErrorStream().read() == -1) break block3;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(p.getInputStream()));
        rd.readLine();
        return rd.readLine();
    }

    private static String readMainClassFromManifest(String jarName) {
        ZipFile jarFile;
        ZipEntry entry;
        block7: {
            if (JTFTools.testDebugOption("main")) {
                System.out.println("Read class from JAR manifest in " + jarName);
            }
            if ((entry = (jarFile = new ZipFile(jarName)).getEntry("META-INF/MANIFEST.MF")) != null) break block7;
            return null;
        }
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
            String line = rd.readLine();
            while (line != null) {
                if (line.startsWith("Main-Class:")) {
                    String mainClass = line.substring("Main-Class:".length()).trim();
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + mainClass);
                    }
                    return mainClass;
                }
                line = rd.readLine();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMainClassFromCommandLine(String line) {
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from command line: " + line);
        }
        if (line == null) {
            return null;
        }
        boolean jarFlag = false;
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
            tokenizer.resetSyntax();
            tokenizer.wordChars(33, 255);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            boolean cmdRead = false;
            while (true) {
                int tt = tokenizer.nextToken();
                String token = tokenizer.sval;
                switch (tt) {
                    case -1: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (cmdRead) {
                    if (token.startsWith("-")) {
                        if (token.equals("-jar")) {
                            jarFlag = true;
                            continue;
                        }
                        if (!token.equals("-cp") && !token.equals("-classpath")) continue;
                        tokenizer.nextToken();
                        continue;
                    }
                    if (jarFlag) {
                        return JTFTools.readMainClassFromManifest(token);
                    }
                    if (JTFTools.testDebugOption("main")) {
                        System.out.println("Main class = " + token);
                    }
                    return token;
                }
                cmdRead = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String readMainClassFromClassPath() {
        String result = null;
        String classpath = System.getProperty("java.class.path");
        if (classpath == null) {
            classpath = System.getProperty("user.dir");
        }
        if (classpath == null) {
            return null;
        }
        if (JTFTools.testDebugOption("main")) {
            System.out.println("Read class from class path: " + classpath);
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, ":;");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            File file = new File(token);
            String[] candidates = null;
            if (file.isDirectory()) {
                candidates = file.list();
            } else if (token.endsWith(".jar") && !JTFTools.nameAppears(token, SKIP_JARS)) {
                try {
                    ZipFile zf = new ZipFile(file);
                    ArrayList<String> list = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        list.add(entries.nextElement().getName());
                    }
                    candidates = new String[list.size()];
                    int i = 0;
                    while (i < candidates.length) {
                        candidates[i] = (String)list.get(i);
                        ++i;
                    }
                }
                catch (IOException ex) {
                    candidates = null;
                }
            }
            if (candidates == null) continue;
            int i = 0;
            while (i < candidates.length) {
                block17: {
                    String className;
                    String fileName = candidates[i];
                    if (fileName.endsWith(".class") && (className = fileName.substring(0, fileName.lastIndexOf(".class"))).indexOf("/") == -1 && JTFTools.checkIfLoaded(className)) {
                        block18: {
                            Class<?> c = Class.forName(className);
                            Class[] types = new Class[]{candidates.getClass()};
                            if (c.getMethod("main", types) == null) break block17;
                            if (JTFTools.testDebugOption("main")) {
                                System.out.println("Main class = " + className);
                            }
                            if (result == null) break block18;
                            return null;
                        }
                        try {
                            result = className;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected static void submitProject(Program program, JProgressBar progress) {
        SubmitOptions options = JTFTools.getOptions(program);
        if (options.popup() && options.isComplete()) {
            String className = program.getClass().getName();
            String programName = className.substring(className.lastIndexOf(".") + 1);
            String boundary = "==" + System.currentTimeMillis() + "==";
            String smtpServer = options.getSMTPServer();
            String authorName = options.getAuthorName();
            String authorEMail = options.getAuthorEMail();
            String instructor = options.getSubmissionEMail();
            String authorID = authorEMail;
            int atIndex = authorEMail.indexOf("@");
            if (atIndex != -1) {
                authorID = authorID.substring(0, atIndex);
            }
            String zipName = String.valueOf(programName) + "_" + authorID;
            File dir = new File(System.getProperty("user.dir"));
            if (progress != null) {
                progress.setMaximum(JTFTools.countResources(dir, SUBMIT_EXTENSIONS, null));
                ProgressBarDialog.popup(progress);
            }
            PrintStream out = JTFTools.openMailStream(smtpServer, authorEMail, instructor);
            JTFTools.sendStandardHeaders(out, authorName, programName);
            out.println("Mime-Version: 1.0");
            out.println("Content-Type: multipart/mixed; boundary=\"" + boundary + '\"');
            out.println();
            out.println("--" + boundary);
            out.println("Content-Transfer-Encoding: base64");
            out.println("Content-Type: application/zip; name=" + zipName + ".zip");
            out.println("Content-Disposition: attachment; filename=" + zipName + ".zip");
            JTFTools.submitDirectory(out, zipName, progress);
            if (ProgressBarDialog.hasBeenCancelled(progress)) {
                JTFTools.cancelMail(out);
            }
            out.println("--" + boundary + "--");
            out.close();
            if (progress != null) {
                ProgressBarDialog.dismiss(progress);
            }
        }
    }

    private static void dumpHTMLIndex(File outDir, Program program, String className, String programName) throws IOException {
        File outFile = new File(outDir, "index.html");
        PrintWriter wr = new PrintWriter(new FileWriter(outFile));
        Dimension size = program.getSize();
        wr.println("<html>");
        wr.println("<head>");
        wr.println("<meta name=\"generator\" content=\"ACM Java Libraries V1.1\">");
        wr.println("<title>" + programName + "</title>");
        wr.println("</head>");
        wr.println("<body>");
        wr.println("<center>");
        wr.println("<table border=2 cellpadding=0 cellspacing=0>");
        wr.println("<tr><td>");
        wr.println("<applet archive=\"" + programName + ".jar\"");
        wr.println("        code=\"" + className.replace('.', '/') + ".class\"");
        wr.println("        width=" + size.width + " height=" + size.height + ">");
        wr.println("</applet>");
        wr.println("</td></tr>");
        wr.println("</table>");
        wr.println("</center>");
        wr.println("</body>");
        wr.println("</html>");
        wr.close();
    }

    private static void dumpJarAndResources(File dir, File outDir, String filename, String imports, JProgressBar progress, boolean exportFiles, Object transformer) throws IOException {
        File outFile = new File(outDir, filename);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
        JTFTools.dumpJarAndResources("", dir, out, outDir, imports, progress, exportFiles, transformer);
        out.close();
    }

    private static void dumpJarAndResources(String path, File dir, ZipOutputStream out, File outDir, String imports, JProgressBar progress, boolean exportFiles, Object transformer) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(progress)) {
            return;
        }
        JTFTools.dumpTree(path, dir, out, outDir, progress, 0, exportFiles, transformer);
        StringTokenizer tokenizer = new StringTokenizer(imports, ";");
        while (tokenizer.hasMoreTokens()) {
            String jarName = tokenizer.nextToken().trim();
            File libFile = JTFTools.getLibrary(jarName);
            if (libFile == null) continue;
            ZipFile jarFile = new ZipFile(libFile);
            Enumeration<? extends ZipEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!JTFTools.nameAppears(entryName, SKIP_FILES)) {
                    int ch;
                    BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));
                    if (transformer != null && entryName.endsWith(".class")) {
                        entry = new ZipEntry(entryName);
                        out.putNextEntry(entry);
                        JTFTools.transformClass(transformer, in, out);
                    } else {
                        out.putNextEntry(entry);
                        JTFTools.copyBytes(in, out, entry.getSize());
                    }
                    while ((ch = ((InputStream)in).read()) != -1) {
                        out.write(ch);
                    }
                    out.closeEntry();
                    ((InputStream)in).close();
                }
                if (progress == null) continue;
                progress.setValue(progress.getValue() + 1);
            }
        }
    }

    private static void dumpTree(String path, File file, ZipOutputStream out, File outDir, JProgressBar progress, int level, boolean exportFiles, Object transformer) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(progress)) {
            return;
        }
        String filename = file.getName();
        if (file.isDirectory()) {
            String[] files = file.list();
            if (level > 0) {
                path = String.valueOf(path) + filename + "/";
            }
            int i = 0;
            while (i < files.length) {
                JTFTools.dumpTree(path, new File(file, files[i]), out, outDir, progress, level + 1, exportFiles, transformer);
                ++i;
            }
        } else if (JTFTools.isResourceComponent(filename)) {
            String entryName = String.valueOf(path) + filename;
            if (entryName.startsWith("Java Classes/")) {
                entryName = entryName.substring(entryName.indexOf(47) + 1);
            }
            ZipEntry entry = new ZipEntry(entryName);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            out.putNextEntry(entry);
            if (transformer != null && filename.endsWith(".class")) {
                JTFTools.transformClass(transformer, in, out);
            } else {
                JTFTools.copyBytes(in, out, file.length());
            }
            ((InputStream)in).close();
            if (exportFiles && outDir != null && !filename.endsWith(".class")) {
                in = new BufferedInputStream(new FileInputStream(file));
                outDir = new File(outDir, path);
                File outFile = new File(outDir, filename);
                outDir.mkdirs();
                BufferedOutputStream backup = new BufferedOutputStream(new FileOutputStream(outFile));
                JTFTools.copyBytes(in, backup, file.length());
                ((InputStream)in).close();
                backup.close();
            }
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
        }
    }

    private static void transformClass(Object transformer, InputStream in, OutputStream out) {
        Method transform = null;
        try {
            Class[] types = new Class[]{Class.forName("java.io.InputStream"), Class.forName("java.io.OutputStream")};
            transform = transformer.getClass().getMethod("transform", types);
        }
        catch (Exception ex) {
            throw new ErrorException("exportJar: Illegal class transformer object");
        }
        try {
            Object[] args = new Object[]{in, out};
            transform.invoke(transformer, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private static int countResources(File file, String[] extensions, String libName) {
        File libJar;
        String filename = file.getName();
        int count = 0;
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                count += JTFTools.countResources(new File(file, files[i]), extensions, null);
                ++i;
            }
        } else {
            int i = 0;
            while (i < extensions.length && count == 0) {
                if (filename.endsWith(extensions[i])) {
                    count = 1;
                }
                ++i;
            }
        }
        if (libName != null && (libJar = JTFTools.getLibrary(libName)) != null) {
            try {
                ZipFile jarFile = new ZipFile(libJar);
                Enumeration<? extends ZipEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ++count;
                    e.nextElement();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return count;
    }

    private static File getLibrary(String libName) {
        if (libName == null) {
            return null;
        }
        File library = new File(libName);
        if (libName.startsWith(".") || library.isAbsolute()) {
            return library;
        }
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            classPath = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals(libName) && !token.endsWith("/" + libName)) continue;
            return new File(token);
        }
        File dir = new File(System.getProperty("user.dir"));
        library = new File(dir, libName);
        return library.exists() ? library : null;
    }

    private static boolean isResourceComponent(String filename) {
        int i = 0;
        while (i < RESOURCE_EXTENSIONS.length) {
            if (filename.endsWith(RESOURCE_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void submitDirectory(PrintStream out, String zipName, JProgressBar progress) {
        try {
            OutputStream base64Stream = JTFTools.openBase64OutputStream(out);
            ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(base64Stream));
            ZipOutputStream dummy = new ZipOutputStream(new NullOutputStream());
            File dir = new File(System.getProperty("user.dir"));
            JTFTools.dumpZip(String.valueOf(zipName) + "/", dir, zip, dummy, true, progress);
            dummy.close();
            zip.finish();
            zip.flush();
            JTFTools.padBase64OutputStream(base64Stream);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private static void dumpZip(String path, File file, ZipOutputStream out, ZipOutputStream dummy, boolean topLevel, JProgressBar progress) throws IOException {
        if (ProgressBarDialog.hasBeenCancelled(progress)) {
            return;
        }
        String filename = file.getName();
        if (file.isDirectory()) {
            String[] files = file.list();
            if (!topLevel) {
                path = String.valueOf(path) + filename + "/";
            }
            int i = 0;
            while (i < files.length) {
                JTFTools.dumpZip(path, new File(file, files[i]), out, dummy, false, progress);
                ++i;
            }
        } else if (JTFTools.isSubmitComponent(filename)) {
            String entryName = String.valueOf(path) + filename;
            ZipEntry entry = new ZipEntry(entryName);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            if (dummy != null) {
                dummy.putNextEntry(entry);
                JTFTools.copyBytes(in, dummy, file.length());
                dummy.closeEntry();
                ((InputStream)in).close();
                in = new BufferedInputStream(new FileInputStream(file));
            }
            out.putNextEntry(entry);
            JTFTools.copyBytes(in, out, file.length());
            out.closeEntry();
            ((InputStream)in).close();
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
        }
    }

    private static boolean isSubmitComponent(String filename) {
        int i = 0;
        while (i < SUBMIT_EXTENSIONS.length) {
            if (filename.endsWith(SUBMIT_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static SubmitOptions getOptions(Program program) {
        SubmitOptions options = optionsTable.get(program);
        if (options == null) {
            options = new SubmitOptions(program);
            optionsTable.put(program, options);
        }
        return options;
    }

    private static boolean nameAppears(String name, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

