/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.gui.TableLayout;
import acm.program.Program;
import acm.util.JTFTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

class ProgressBarDialog
extends JDialog
implements ActionListener {
    private static final int DIALOG_WIDTH = 250;
    private static final int DIALOG_HEIGHT = 90;
    private static final int PROGRESS_BAR_HEIGHT = 25;
    private JProgressBar progressBar;

    public ProgressBarDialog(Program program) {
        super(JTFTools.getEnclosingFrame(program), "Progress", false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new TableLayout(2, 1));
        this.progressBar = new JProgressBar();
        contentPane.add((Component)this.progressBar, "weightx=1 left=5 right=5 height=25");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        contentPane.add((Component)cancelButton, "top=10 fill=NONE");
        Rectangle programBounds = program.getBounds();
        int x = programBounds.x + (programBounds.width - 250) / 2;
        int y = programBounds.y + (programBounds.height - 90) / 2;
        this.setBounds(x, y, 250, 90);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void actionPerformed(ActionEvent e) {
        this.progressBar.setString("Cancel");
        this.setVisible(false);
    }

    public static boolean hasBeenCancelled(JProgressBar bar) {
        if (bar == null) {
            return false;
        }
        String str = bar.getString();
        return str != null && str.equals("Cancel");
    }

    public static void popup(JProgressBar bar) {
        Container comp = bar;
        while (comp != null) {
            if (comp instanceof ProgressBarDialog) {
                comp.setVisible(true);
                comp.repaint();
                return;
            }
            comp = comp.getParent();
        }
    }

    public static void dismiss(JProgressBar bar) {
        Container comp = bar;
        while (comp != null) {
            if (comp instanceof ProgressBarDialog) {
                ((Component)comp).setVisible(false);
                return;
            }
            comp = comp.getParent();
        }
    }
}

