/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.SoundPlayer;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundClip
implements AudioClip {
    public static final int MONO = 1;
    public static final int STEREO = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final double STANDARD_FRAME_RATE = 22050.0;
    public static final int MAX_SAMPLE = Short.MAX_VALUE;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BUFFER_INCREMENT = 10000;
    private AudioFormat format;
    private SoundPlayer player;
    private String soundName;
    private double clipVolume;
    private float frameRate;
    private int nChannels;
    private int frameCount;
    private int currentFrame;
    private byte[] data;

    public SoundClip() {
        this(1);
    }

    public SoundClip(int channels) {
        if (channels < 1 || channels > 2) {
            throw new ErrorException("SoundClip: Illegal number of channels");
        }
        this.nChannels = channels;
        this.frameRate = 22050.0f;
        this.soundName = "Untitled";
        this.frameCount = 0;
        this.clipVolume = 1.0;
        this.data = new byte[0];
        this.format = new AudioFormat(this.frameRate, 16, channels, true, true);
    }

    public SoundClip(String name) {
        if (name.startsWith("http:")) {
            try {
                URL url = new URL(name);
                this.soundName = JTFTools.getURLSuffix(url.getPath());
                this.readSound(this.convertToPCM(this.getAudioInputStream(url.openStream())));
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        } else {
            this.soundName = name;
            this.readSound(this.convertToPCM(this.getAudioInputStream(new File(name))));
        }
    }

    public SoundClip(File file) {
        try {
            this.soundName = file.getName();
            this.readSound(this.convertToPCM(this.getAudioInputStream(file)));
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public SoundClip(URL url) {
        try {
            this.soundName = JTFTools.getURLSuffix(url.getPath());
            this.readSound(this.convertToPCM(this.getAudioInputStream(url.openStream())));
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public SoundClip(InputStream in) {
        this.soundName = "Untitled";
        this.readSound(this.convertToPCM(this.getAudioInputStream(in)));
    }

    public SoundClip(int[] samples) {
        this(1);
        this.addSampleData(samples);
    }

    public SoundClip(int[] left, int[] right) {
        this(2);
        this.addSampleData(left, right);
    }

    public synchronized void play() {
        if (this.player == null) {
            this.player = new SoundPlayer(this);
        }
        this.player.play();
    }

    public void loop() {
        if (this.player == null) {
            this.player = new SoundPlayer(this);
        }
        this.player.loop();
    }

    public synchronized void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public void save(String filename) {
        this.save(new File(System.getProperty("user.dir"), filename));
    }

    public void save(File file) {
        try {
            AudioSystem.write(this.getAudioInputStream(), this.getFormatForFile(file.getName()), file);
        }
        catch (IOException ex) {
            throw new ErrorException("save: I/O error - " + ex.getMessage());
        }
    }

    public String getName() {
        return this.soundName;
    }

    public void setName(String name) {
        this.soundName = name;
    }

    public int getChannelCount() {
        return this.nChannels;
    }

    public boolean isStereo() {
        return this.nChannels == 2;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public double getDuration() {
        return (float)this.frameCount / this.frameRate;
    }

    public int getFrameIndex() {
        return this.currentFrame;
    }

    public void setFrameIndex(int frameIndex) {
        this.currentFrame = frameIndex;
    }

    public void rewind() {
        this.setFrameIndex(0);
    }

    public double getVolume() {
        return this.clipVolume;
    }

    public void setVolume(double volume) {
        this.clipVolume = volume;
    }

    public int[] getSampleData() {
        return this.getSampleData(0);
    }

    public int[] getSampleData(int channel) {
        this.standardize();
        if (channel < 0 || channel >= this.nChannels) {
            throw new ErrorException("getSamples: Channel number out of range");
        }
        int[] samples = new int[this.frameCount];
        int ix = channel * 2;
        int i = 0;
        while (i < this.frameCount) {
            samples[i] = this.data[ix] << 8 | this.data[ix + 1] & 0xFF;
            ix += this.nChannels * 2;
            ++i;
        }
        return samples;
    }

    public void addSampleData(int sample) {
        this.standardize();
        if (this.nChannels == 2) {
            this.addSampleData(sample, sample);
        } else {
            int ix = this.frameCount * 2;
            ++this.frameCount;
            if (ix >= this.data.length) {
                byte[] newData = new byte[ix + 10000];
                if (ix > 0) {
                    System.arraycopy(this.data, 0, newData, 0, ix);
                }
                this.data = newData;
            }
            this.data[ix++] = (byte)(sample >> 8);
            this.data[ix++] = (byte)(sample & 0xFF);
        }
    }

    public void addSampleData(int left, int right) {
        this.standardize();
        if (this.nChannels != 2) {
            throw new ErrorException("addSampleData: Sound is not stereo");
        }
        int ix = 2 * this.frameCount * 2;
        ++this.frameCount;
        if (ix >= this.data.length) {
            byte[] newData = new byte[ix + 10000];
            if (ix > 0) {
                System.arraycopy(this.data, 0, newData, 0, ix);
            }
            this.data = newData;
        }
        this.data[ix++] = (byte)(left >> 8);
        this.data[ix++] = (byte)(left & 0xFF);
        this.data[ix++] = (byte)(right >> 8);
        this.data[ix++] = (byte)(right & 0xFF);
    }

    public void addSampleData(int[] samples) {
        this.standardize();
        if (this.nChannels == 2) {
            this.addSampleData(samples, samples);
        } else {
            int ix = this.frameCount * 2;
            this.frameCount += samples.length;
            byte[] newData = new byte[this.frameCount * 2];
            if (ix > 0) {
                System.arraycopy(this.data, 0, newData, 0, ix);
            }
            this.data = newData;
            int i = 0;
            while (i < samples.length) {
                this.data[ix++] = (byte)(samples[i] >> 8);
                this.data[ix++] = (byte)(samples[i] & 0xFF);
                ++i;
            }
        }
    }

    public void addSampleData(int[] left, int[] right) {
        this.standardize();
        if (this.nChannels != 2) {
            throw new ErrorException("addSampleData: Sound is not stereo");
        }
        if (left.length != right.length) {
            throw new ErrorException("addSampleData: Channels have unequal length");
        }
        int ix = 2 * this.frameCount * 2;
        this.frameCount += left.length;
        byte[] newData = new byte[2 * this.frameCount * 2];
        if (ix > 0) {
            System.arraycopy(this.data, 0, newData, 0, ix);
        }
        this.data = newData;
        int i = 0;
        while (i < left.length) {
            this.data[ix++] = (byte)(left[i] >> 8);
            this.data[ix++] = (byte)(left[i] & 0xFF);
            this.data[ix++] = (byte)(right[i] >> 8);
            this.data[ix++] = (byte)(right[i] & 0xFF);
            ++i;
        }
    }

    public String toString() {
        String str = this.soundName;
        str = String.valueOf(str) + " (";
        str = String.valueOf(str) + (this.nChannels == 1 ? "mono" : "stereo");
        str = String.valueOf(str) + ", ";
        str = String.valueOf(str) + new DecimalFormat("#0.00").format(this.getDuration());
        str = String.valueOf(str) + " sec)";
        return str;
    }

    public static double sampleToIntensity(int sample) {
        return Math.max(-1.0, Math.min(1.0, (double)sample / 32767.0));
    }

    public static int intensityToSample(double intensity) {
        return (int)Math.round(Math.max(-1.0, Math.min(1.0, intensity)) * 32767.0);
    }

    protected byte[] getData() {
        return this.data;
    }

    protected AudioFormat getFormat() {
        return this.format;
    }

    protected AudioInputStream getAudioInputStream() {
        return new AudioInputStream(new ByteArrayInputStream(this.data), this.format, this.frameCount);
    }

    private void standardize() {
        if ((double)this.frameRate == 22050.0) {
            return;
        }
        double sf = 22050.0 / (double)this.frameRate;
        int newFrameCount = (int)((double)this.frameCount * sf);
        byte[] newData = new byte[this.nChannels * newFrameCount * 2];
        int ix = 0;
        int i = 0;
        while (i < newFrameCount) {
            int channel = 0;
            while (channel < this.nChannels) {
                int sx = (int)((double)i / sf) * 2 * this.nChannels + 2 * channel;
                int sample = this.data[sx] << 8 | this.data[sx + 1] & 0xFF;
                newData[ix++] = (byte)(sample >> 8);
                newData[ix++] = (byte)(sample & 0xFF);
                ++channel;
            }
            ++i;
        }
        this.data = newData;
        this.frameCount = newFrameCount;
        this.format = new AudioFormat(this.frameRate, 16, this.nChannels, true, true);
    }

    private AudioFileFormat.Type getFormatForFile(String name) {
        if ((name = name.toLowerCase()).endsWith(".wav")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (name.endsWith(".aif")) {
            return AudioFileFormat.Type.AIFF;
        }
        if (name.endsWith(".aiff")) {
            return AudioFileFormat.Type.AIFF;
        }
        return AudioFileFormat.Type.AU;
    }

    private void readSound(AudioInputStream in) {
        this.format = in.getFormat();
        this.nChannels = this.format.getChannels();
        this.frameRate = this.format.getFrameRate();
        long frameLength = in.getFrameLength();
        if (frameLength > Integer.MAX_VALUE) {
            throw new ErrorException("SoundClip: Sound file is too large");
        }
        this.frameCount = (int)frameLength;
        this.data = this.frameCount < 0 ? new byte[10000] : new byte[this.frameCount * this.nChannels * 2];
        int offset = 0;
        boolean eof = false;
        while (!eof) {
            int nBytes;
            for (int bytesRemaining = this.data.length - offset; bytesRemaining > 0; bytesRemaining -= nBytes) {
                try {
                    nBytes = in.read(this.data, offset, bytesRemaining);
                    if (nBytes == 0) {
                        eof = true;
                        break;
                    }
                    offset += nBytes;
                    continue;
                }
                catch (IOException ex) {
                    throw new ErrorException(ex);
                }
            }
            if (this.frameCount >= 0) {
                eof = true;
            }
            if (eof) continue;
            byte[] ndata = new byte[2 * this.data.length];
            System.arraycopy(this.data, 0, ndata, 0, this.data.length);
            this.data = ndata;
        }
        if (offset < this.data.length && this.frameCount < 0) {
            byte[] ndata = new byte[offset];
            System.arraycopy(this.data, 0, ndata, 0, offset);
            this.data = ndata;
        }
        if (this.frameCount < 0) {
            this.frameCount = offset / (2 * this.nChannels);
        }
    }

    private AudioInputStream convertToPCM(AudioInputStream in) {
        AudioFormat newFormat = in.getFormat();
        newFormat = new AudioFormat(newFormat.getSampleRate(), 16, newFormat.getChannels(), true, true);
        return AudioSystem.getAudioInputStream(newFormat, in);
    }

    private AudioInputStream getAudioInputStream(InputStream in) {
        try {
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return AudioSystem.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException ex) {
            throw new ErrorException(this.createUnsupportedFormatMessage());
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private AudioInputStream getAudioInputStream(File file) {
        try {
            return AudioSystem.getAudioInputStream(file);
        }
        catch (UnsupportedAudioFileException ex) {
            throw new ErrorException(this.createUnsupportedFormatMessage());
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private String createUnsupportedFormatMessage() {
        int dot = this.soundName.lastIndexOf(46);
        if (dot == -1) {
            return "Unsupported audio file format";
        }
        return "The " + this.soundName.substring(dot + 1) + " format is not supported by JavaSound";
    }
}

