/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.SoundClip;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

class SoundPlayer
implements Runnable {
    private static final int PADDING = 400;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int MAX_BUFFER_SIZE = 4096;
    private static final double EPSILON = 1.0E-6;
    private SoundClip soundClip;
    private Thread thread;
    private boolean looping;
    private double oldVolume;

    public SoundPlayer(SoundClip sound) {
        this.soundClip = sound;
        this.oldVolume = 1.0;
    }

    public void play() {
        if (this.thread != null) {
            return;
        }
        this.looping = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void loop() {
        if (this.thread != null) {
            return;
        }
        this.looping = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.looping = false;
        this.thread = null;
    }

    public void run() {
        byte[] data = this.soundClip.getData();
        int nChannels = this.soundClip.getChannelCount();
        int offset = this.soundClip.getFrameIndex() * nChannels * 2;
        int length = this.soundClip.getFrameCount() * nChannels * 2;
        SourceDataLine line = this.openSourceDataLine(Math.min(4096, length));
        line.start();
        while (this.thread != null) {
            int bytesRemaining = length - offset;
            while (this.thread != null && bytesRemaining > 0) {
                this.setLineVolume(line, this.soundClip.getVolume());
                int chunkSize = Math.min(4096, bytesRemaining);
                int nBytes = line.write(data, offset, chunkSize);
                offset += nBytes;
                bytesRemaining -= nBytes;
            }
            if (!this.looping) break;
            offset = 0;
        }
        if (this.thread == null) {
            this.soundClip.setFrameIndex(offset / nChannels / 2);
        }
        data = new byte[400];
        line.write(data, 0, data.length);
        line.drain();
        line.stop();
        line.close();
        this.thread = null;
    }

    private SourceDataLine openSourceDataLine(int bufferSize) {
        try {
            AudioFormat format = this.soundClip.getFormat();
            Class<?> sourceDataLineClass = Class.forName("javax.sound.sampled.SourceDataLine");
            DataLine.Info info = new DataLine.Info(sourceDataLineClass, format);
            if (!AudioSystem.isLineSupported(info)) {
                throw new ErrorException("SoundClip: Unsupported data line format");
            }
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format, bufferSize);
            return line;
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setLineVolume(SourceDataLine line, double volume) {
        if (this.oldVolume == volume) {
            return;
        }
        this.oldVolume = volume;
        if (line.isControlSupported(FloatControl.Type.VOLUME)) {
            FloatControl volumeControl = (FloatControl)line.getControl(FloatControl.Type.VOLUME);
            volumeControl.setValue((float)volume);
        } else if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            double gain = 20.0 * Math.log(Math.max(volume, 1.0E-6)) / Math.log(10.0);
            gainControl.setValue((float)gain);
        }
    }
}

