/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.Animator;
import acm.util.ErrorException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpeedBarListener
implements AdjustmentListener,
ChangeListener {
    private Animator animator;
    private Object speedBar;
    private Method getValue;
    private Method getMinimum;
    private Method getMaximum;

    SpeedBarListener() {
    }

    public static void register(Animator animator, Object speedBar) {
        SpeedBarListener listener = new SpeedBarListener();
        listener.animator = animator;
        listener.speedBar = speedBar;
        Class<?> speedBarClass = speedBar.getClass();
        Method addListener = SpeedBarListener.lookForMethod(speedBarClass, "addAdjustmentListener");
        if (addListener == null) {
            addListener = SpeedBarListener.lookForMethod(speedBarClass, "addChangeListener");
        }
        if (addListener == null) {
            addListener = SpeedBarListener.lookForMethod(speedBarClass, "addChangeListener");
        }
        try {
            listener.getValue = speedBarClass.getMethod("getValue", new Class[0]);
            listener.getMinimum = speedBarClass.getMethod("getMinimum", new Class[0]);
            listener.getMaximum = speedBarClass.getMethod("getMaximum", new Class[0]);
            Object[] args = new Object[]{listener};
            addListener.invoke(speedBar, args);
        }
        catch (Exception ex) {
            throw new ErrorException("Illegal speed bar object");
        }
        listener.setSpeed();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e != e) {
            // empty if block
        }
        this.setSpeed();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e != e) {
            // empty if block
        }
        this.setSpeed();
    }

    public void setSpeed() {
        try {
            int min = (Integer)this.getMinimum.invoke(this.speedBar, new Object[0]);
            int max = (Integer)this.getMaximum.invoke(this.speedBar, new Object[0]);
            int value = (Integer)this.getValue.invoke(this.speedBar, new Object[0]);
            double fraction = (double)(value - min) / (double)(max - min);
            this.animator.setSpeed(fraction);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private static Method lookForMethod(Class<?> speedBarClass, String methodName) {
        Method[] methods = speedBarClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }
}

